/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks;

import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.hibernate.validator.ap.internal.checks.AbstractConstraintCheck;
import org.hibernate.validator.ap.internal.checks.ConstraintCheckIssue;
import org.hibernate.validator.ap.internal.util.CollectionHelper;
import org.hibernate.validator.ap.internal.util.ConstraintHelper;

public class MethodAnnotationCheck
extends AbstractConstraintCheck {
    private ConstraintHelper constraintHelper;

    public MethodAnnotationCheck(ConstraintHelper constraintHelper) {
        this.constraintHelper = constraintHelper;
    }

    @Override
    public Set<ConstraintCheckIssue> checkMethod(ExecutableElement element, AnnotationMirror annotation) {
        ConstraintHelper.AnnotationProcessorValidationTarget target;
        if (this.constraintHelper.isConstraintAnnotation(annotation.getAnnotationType().asElement())) {
            Set<ConstraintHelper.AnnotationProcessorValidationTarget> supportedTargets = this.constraintHelper.getSupportedValidationTargets(annotation.getAnnotationType());
            if (supportedTargets.size() != 1) {
                target = this.constraintHelper.resolveValidationTarget(element, annotation);
                if (target == null) {
                    return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_TARGET_NOT_INFERABLE", annotation.getAnnotationType().asElement().getSimpleName()));
                }
            } else {
                target = supportedTargets.toArray(new ConstraintHelper.AnnotationProcessorValidationTarget[1])[0];
            }
        } else {
            target = ConstraintHelper.AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT;
        }
        if (target == ConstraintHelper.AnnotationProcessorValidationTarget.ANNOTATED_ELEMENT && !this.hasReturnValue(element)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "ONLY_NON_VOID_METHODS_MAY_BE_ANNOTATED", new Object[0]));
        }
        if (target == ConstraintHelper.AnnotationProcessorValidationTarget.PARAMETERS && !this.hasParameters(element)) {
            return CollectionHelper.asSet(ConstraintCheckIssue.error(element, annotation, "CROSS_PARAMETER_VALIDATION_ON_PARAMETERLESS_METHOD", annotation.getAnnotationType().asElement().getSimpleName()));
        }
        return Collections.emptySet();
    }

    private boolean hasParameters(ExecutableElement method) {
        return method.getParameters().size() > 0;
    }

    private boolean hasReturnValue(ExecutableElement method) {
        return method.getReturnType().getKind() != TypeKind.VOID;
    }
}

