<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="text" indent="no"/>
    <xsl:strip-space elements="*"/>
    <xsl:template match="/singletons">package soot;

/*-
 * #%L
 * Soot - a J*va Optimization Framework
 * %%
 * Copyright (C) 2003 Ondrej Lhotak
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 2.1 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * &lt;http://www.gnu.org/licenses/lgpl-2.1.html&gt;.
 * #L%
 */

/* THIS FILE IS AUTOMATICALLY GENERATED FROM soot/singletons.xml DO NOT EDIT! */

/** A class to group together all the global variables in Soot. */
@jakarta.annotation.Generated(value = "<xsl:copy-of select="system-property('xsl:vendor')"/> v<xsl:copy-of select="system-property('xsl:version')"/>", comments = "from <xsl:value-of select="tokenize(base-uri(), '/')[last()]"/>")
public class Singletons {

    public final class Global {
        private Global() {}
    }

    protected Global g = new Global();<xsl:text/>

        <xsl:for-each select="/singletons/class">
            <xsl:variable name="class" select="."/>
            <xsl:variable name="undottedClass" select="translate(.,'.','_')"/>
            <xsl:variable name="instanceName">instance_<xsl:value-of select="$undottedClass"/></xsl:variable>

    private <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$instanceName"/>;
    public <xsl:value-of select="$class"/><xsl:text> </xsl:text><xsl:value-of select="$undottedClass"/>() {
        if (<xsl:value-of select="$instanceName"/> == null) {
	       	synchronized (this) {
		        if (<xsl:value-of select="$instanceName"/> == null)
	        		<xsl:value-of select="$instanceName"/> = new <xsl:value-of select="$class"/>(g);
	       	}
       	}
        return <xsl:value-of select="$instanceName"/>;
    }
    protected void release_<xsl:value-of select="$undottedClass"/>() {
    	<xsl:value-of select="$instanceName"/> = null;
    }<xsl:text/>
        </xsl:for-each>
}<xsl:text/>
    </xsl:template>
</xsl:stylesheet>