#!/bin/sh
#
## KAAPI library source
## -----------------------------------------
##
## by Thierry Gautier
## Apache Project, IMAG, Grenoble, France
##
## use:
#  m4_generator <NB_PARAM> 
#


makeheader() {
cat <<ENDDDD 
// **********************************************************
// WARNING! This file has been automatically generated by M4
// *********************************************************
//#define RUN_TASK
ENDDDD

}



#############################################################
## loop for file bodies
#############################################################
echo "SOFA_DIR="$SOFA_DIR
NUMBER=0
COUNTER=$1
MAX_NUMBER_PARAMS=$1
## `expr $1 + 1`
cat $SOFA_DIR/framework/copyright.txt > $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks.h
cat $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks_prologue.m4 >> $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks.h
while [ $COUNTER -ge 0 ]
do
      if [ $NUMBER -gt 0 ]
      then
        m4 -DKAAPI_NUMBER_PARAMS=$NUMBER -DKAAPI_MAX_NUMBER_PARAMS=$MAX_NUMBER_PARAMS  $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks_macros.m4  $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks_gen.m4 >> $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks.h
      fi
      echo "Generating file: $file step $NUMBER :-)"
      NUMBER=`expr $NUMBER + 1`
      COUNTER=`expr $COUNTER - 1`
done
cat $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks_epilogue.m4 >> $SOFA_DIR/framework/sofa/core/objectmodel/BaseObjectTasks.h


