/******************************************************************************
*                 SOFA, Simulation Open-Framework Architecture                *
*                    (c) 2006 INRIA, USTL, UJF, CNRS, MGH                     *
*                                                                             *
* This program is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This program is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this program. If not, see <http://www.gnu.org/licenses/>.        *
*******************************************************************************
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_COMPONENT_CONTROLLER_ENSLAVEMENTFORCEFEEDBACK_H
#define SOFA_COMPONENT_CONTROLLER_ENSLAVEMENTFORCEFEEDBACK_H

#include <SofaBaseCollision/ContactListener.h>
#include <sofa/core/collision/DetectionOutput.h>
#include <sofa/core/collision/Intersection.h>
#include <SofaHaptics/ForceFeedback.h>
#include <SofaBaseMechanics/MechanicalObject.h>
#include <sofa/defaulttype/RigidTypes.h>

namespace sofa
{

namespace component
{

namespace controller
{

class EnslavementForceFeedback : public virtual core::collision::ContactListener, public virtual sofa::component::controller::ForceFeedback
{
public:
    SOFA_CLASS2(EnslavementForceFeedback, core::collision::ContactListener, sofa::component::controller::ForceFeedback);


    void init() override;
    void beginContact(const type::vector<const type::vector<core::collision::DetectionOutput>* >& ) override;
    void endContact(void*) override;
    virtual void computeForce(SReal, SReal, SReal, SReal, SReal, SReal, SReal, SReal& fx, SReal& fy, SReal& fz) override;
    virtual void computeWrench(const sofa::defaulttype::SolidTypes<SReal>::Transform &world_H_tool, const sofa::defaulttype::SolidTypes<SReal>::SpatialVector &V_tool_world, sofa::defaulttype::SolidTypes<SReal>::SpatialVector &W_tool_world )  override;

    Data<double> d_relativeStiffness; ///< Relative Stiffness
    Data<double> d_attractionDistance; ///< Distance at which the Omni is attracted to the contact point.
    Data<bool> d_normalsPointOut; ///< True if the normals of objects point outwards, false if they point inwards.
    Data<double> d_contactScale; ///< Scales the maximum penetration depth.
    Data<double> d_penOffset; ///< Distance at which there is no reaction force.

protected:
    sofa::type::Vec3d m_contactForce;

    EnslavementForceFeedback( core::CollisionModel* collModel1 = nullptr, core::CollisionModel* collModel2 = nullptr );
    ~EnslavementForceFeedback(){}
};

}
}
}

#endif //SOFA_COMPONENT_CONTROLLER_ENSLAVEMENTFORCEFEEDBACK_H
