/******************************************************************************
*                 SOFA, Simulation Open-Framework Architecture                *
*                    (c) 2006 INRIA, USTL, UJF, CNRS, MGH                     *
*                                                                             *
* This program is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This program is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this program. If not, see <http://www.gnu.org/licenses/>.        *
*******************************************************************************
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#ifndef SOFA_HELPER_BACKTRACE_H
#define SOFA_HELPER_BACKTRACE_H

#include <sofa/helper/config.h>
#include <vector>
#include <string>


namespace sofa::helper
{

class SOFA_HELPER_API BackTrace
{
public:
    /// Dump current backtrace to stderr.
    /// Currently only works on Linux. NOOP on other architectures.
    static void dump();

    /// Enable dump of backtrace when a signal is received.
    /// Useful to have information about crashes without starting a debugger (as it is not always easy to do, i.e. for parallel/distributed applications).
    /// Currently only works on Linux. NOOP on other architectures
    static void autodump();

    typedef std::vector<std::string> StackTrace;
    static StackTrace getTrace(size_t maxEntries=std::numeric_limits<unsigned int>().max());

protected:

    /// Callback for signals
    static void sig(int sig);
};

} // namespace sofa::helper


#endif
