[![SOFA, Simulation Open-Framework Architecture](https://www.sofa-framework.org/wp-content/uploads/2013/01/SOFA_LOGO_ORANGE_2-normal.png)](https://www.sofa-framework.org/)

<br/>

[![Documentation](https://img.shields.io/badge/doc-on_website-brightgreen.svg)](https://www.sofa-framework.org/community/doc/)
[![Support](https://img.shields.io/badge/support-on_GitHub_Discussions-orange.svg)](https://github.com/sofa-framework/sofa/discussions)
[![Discord](https://img.shields.io/badge/chat-on_Discord-darkred.svg)](https://discord.gg/G63t3a8Ra6)

<a href="https://twitter.com/intent/follow?original_referer=https%3A%2F%2Fpublish.twitter.com%2F%3FbuttonType%3DFollowButton%26query%3Dhttps%253A%252F%252Ftwitter.com%252FSofaFramework%26widget%3DButton&ref_src=twsrc%5Etfw&region=follow_link&screen_name=SofaFramework&tw_p=followbutton"><img src="https://img.shields.io/twitter/follow/SofaFramework?label=Follow%20%40SofaFramework&style=social"></a>
[![Contact](https://img.shields.io/badge/contact-on_website-brightgreen.svg)](https://www.sofa-framework.org/consortium/contact/)
[![we're hiring](https://img.shields.io/badge/we're%20hiring!-join%20us-orange)](https://www.sofa-framework.org/about/jobs/)

## What is SOFA

SOFA is an open source framework targeted at interactive physics simulation based on the Finite Element Method (FEM), with an emphasis on medical simulation and robotics.  
It is mainly intended for the research community to help foster newer algorithms, but can also be used as an efficient prototyping tool.  
SOFA's advanced software architecture allows:  
- the creation of complex and evolving simulations by combining new algorithms with existing algorithms 
- the modification of key parameters of the simulation such as deformable behavior, 
  surface representation, solvers, constraints, collision algorithm, etc.  
- the synthesis of complex models from simpler ones using a graph description
- the efficient simulation of the dynamics of interacting objects using abstract equation solvers
- the comparison of various algorithms and mathematical models

SOFA is often presented as a standalone software (runSofa) and a simulation tool, but the project is most importantly a bundle of libraries and thus can be used/integrated in any project.  

SOFA provides a plugin system allowing the coupling of additional codes to add functionalities. A lot of plugins are already referenced in the [source code](https://github.com/sofa-framework/sofa/tree/master/applications/plugins), under [sofa-framework organisation](https://github.com/orgs/sofa-framework/repositories?q=plugin&sort=name), and on the [Marketplace](https://www.sofa-framework.org/applications/marketplace/). Feel free to contact us to get your own plugins referenced!


## How to download and install

Please refer to SOFA download page: https://www.sofa-framework.org/download/


## How to contribute

The SOFA community will be pleased to welcome you!  
Find all the ways to contribute to the project: https://www.sofa-framework.org/community/get-involved/

Before creating any issue or pull request, please read carefully [our CONTRIBUTING rules](https://github.com/sofa-framework/sofa/blob/master/CONTRIBUTING.md).


## Information

### Authors
See [Authors.txt](https://github.com/sofa-framework/sofa/blob/master/Authors.txt)

### Licenses
SOFA is LGPL, except:
- applications/projects (GPL)
- applications/tutorials (GPL)
- directories with a license file specifying a different license

LGPL refers to the GNU Lesser General Public License as published by the Free Software
Foundation; either version 2.1 of the License, or (at your option) any later 
version.

GPL refers to the GNU General Public License as published by the Free Software Foundation;
either version 2 of the License, or (at your option) any later version.

### Contact
contact@sofa-framework.org

-----------------------------------------------------------------------------

SOFA, Simulation Open-Framework Architecture  
(c) 2006 INRIA, USTL, UJF, CNRS, MGH
