/*
 * -------------------------------- MIT License --------------------------------
 * 
 * Copyright (c) 2018 SNF4J contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * -----------------------------------------------------------------------------
 */
package org.snf4j.core.future;

import org.junit.Test;
import org.snf4j.core.TestSession;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

public class TwoThresholdFutureTest {

	@Test
	public void testGetFirstThreshold() {
		DataFuture<Void> df = new DataFuture<Void>(new TestSession());
		TwoThresholdFuture<Void> f = new TwoThresholdFuture<Void>(df, 100);
		
		assertEquals(100, f.getFirstThreshold());
	}
	
	@Test
	public void testIsSuccessful() {
		DataFuture<Void> df = new DataFuture<Void>(new TestSession());
		TwoThresholdFuture<Void> f = new TwoThresholdFuture<Void>(df, 100);

		assertFalse(f.isSuccessful());
		df.add(100);
		assertFalse(f.isSuccessful());
		f.setSecondThreshold(101);
		assertFalse(f.isSuccessful());
		df.add(1);
		assertTrue(f.isSuccessful());
		
		TwoThresholdFuture<Void> f2 = new TwoThresholdFuture<Void>(df, 100);
		assertFalse(f2.isSuccessful());
		f2.setSecondThreshold(101);
		assertTrue(f2.isSuccessful());
		
	}
}
