/*
 * -------------------------------- MIT License --------------------------------
 * 
 * Copyright (c) 2019-2024 SNF4J contributors
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * -----------------------------------------------------------------------------
 */
package org.snf4j.core.engine;

/**
 * An <code>enum</code> describing the current handshaking state of an 
 * {@link IEngine} implementation.
 * 
 * @author <a href="http://snf4j.org">SNF4J.ORG</a>
 */
public enum HandshakeStatus {
	/**
	 * An {@link IEngine} implementation has just finished handshaking.
	 * <p>
	 * This value should be only generated by a call to {@link IEngine#wrap} or 
	 * {@link IEngine#unwrap} when that call finishes a handshake. It shouldn't 
	 * be generated by {@link IEngine#getHandshakeStatus}.
	 */
	FINISHED,
	
	/**
	 * An {@link IEngine} implementation needs the results of one (or more) 
	 * delegated tasks.
	 */
	NEED_TASK,
	
	/**
	 * An {@link IEngine} implementation needs to receive data from the 
	 * remote side.
	 */
	NEED_UNWRAP,
	
	/**
	 * An {@link IEngine} implementation is ready to unwrap data that has been
	 * previously received from the remote side. The data does not need to
	 * be received again.
	 */
	NEED_UNWRAP_AGAIN,
	
	/**
	 * An {@link IEngine} implementation must send data to the remote side.
	 */
	NEED_WRAP,
	
	/**
	 * An {@link IEngine} implementation is not currently handshaking.
	 */
	NOT_HANDSHAKING,
	
	/**
	 * An {@link IEngine} implementation needs a session timer to schedule a tasks.
	 * @since 1.12
	 */
	NEED_TIMER
}
