# Update: Head to Cyfrin Updraft

> **ℹ️ Important:**
> This repo is no longer actively maintained as there have been changes in Hardhat tooling. The video is out of sync with the code, and you can still follow along with the video, but you will likely need to troubleshoot the changes in the tooling and dependencies. Note also that best practices have evolved since this video was made.  
> If you'd like to continue your training with more up-to-date material, you can take a look at [Cyfrin Updraft](https://updraft.cyfrin.io/). That content is developed with love by Patrick & Cyfrin <3. However note that Cyfrin Updraft training uses Foundry, not Hardhat, so there will be tooling changes involved.

# Web3, Full Stack Solidity, Smart Contract & Blockchain - Beginner to Expert ULTIMATE Course | Javascript Edition

<br/>
<p align="center">
<a href="https://www.youtube.com/watch?v=gyMwXuJrbJQ" target="_blank">
<img src="./img/blockchain1.png" width="500" alt="Solidity, Blockchain, and Smart Contract Course – Beginner to Expert Javascript Tutorial">
</a>
</p>
<br/>

Welcome to the repository for the Ultimate Web3, Full Stack Solidity, and Smart Contract - Beginner to Expert Full Course | Javascript Edition FreeCodeCamp Course!

# Link to video: https://www.youtube.com/watch?v=gyMwXuJrbJQ

All code references have both a javascript and a typescript edition.

Recommended Testnet: Sepolia

_We have updated the repos to work with Sepolia due to Rinkeby and Kovan being sunset, and Goerli being a disaster. Let us know if any of the changes break stuff!_

# [Testnet Faucets](https://faucets.chain.link)

Main Faucet:<a href="https://faucets.chain.link" target="_blank"> https://faucets.chain.link</a>
Backup Faucet:<a href="https://sepoliafaucet.com/" target="_blank"> https://sepoliafaucet.com/</a>

> ⚠️ All code associated with this course is for demo purposes only. They have not been audited and should not be considered production ready. Please use at your own risk.

# Resources For This Course

### Questions

- [Github Discussions](https://github.com/smartcontractkit/full-blockchain-solidity-course-js/discussions)
  - Ask questions and chat about the course here!
- [Stack Exchange Ethereum](https://ethereum.stackexchange.com/)
  - Great place for asking technical questions about Ethereum
- [StackOverflow](https://stackoverflow.com/)
  - Great place for asking technical questions overall

# Table of Contents

<details>
<summary>Resources</summary>
<ol>
<li><a href="#testnet-faucets">Testnet Faucets</a></li>
<li><a href="#resources-for-this-course">Resources For This Course</a><ul>
<li><a href="#questions">Questions</a></li>
</ul>
</li>
<li><a href="#table-of-contents">Table of Contents</a></li>
</ol>
</details>
<details>
<summary> <a href="#lesson-0-the-edge-of-the-rabbit-hole">Lesson 0: The Edge of the Rabbit Hole</a></summary>
<ol>
  <li>
  <a href="#welcome-to-the-course">Welcome to the course! </a>
  </li>
  <li>
  <a href="#best-practices">Best Practices </a>
  </li>
</ol>
</details>
<details>
<summary> <a href="#lesson-1-blockchain-basics"> Lesson 1: Blockchain Basics </a> </summary>
<ol>
<li>
<a href="#what-is-a-blockchain-what-does-a-blockchain-do">What is a Blockchain? What does a blockchain do?</a>
</li>
<li><a href="#the-purpose-of-smart-contracts">The Purpose Of Smart Contracts</a></li>
<li><a href="#other-blockchain-benefits">Other Blockchain Benefits</a></li>
<li><a href="#what-have-smart-contracts-done-so-far">What have Smart Contracts done so far?</a></li>
<li><a href="#making-your-first-transaction">Making Your First Transaction</a></li>
<li><a href="#gas-i-introduction-to-gas">Gas I: Introduction to Gas</a></li>
<li><a href="#how-do-blockchains-work">How Do Blockchains Work?</a></li>
<li><a href="#signing-transactions">Signing Transactions</a></li>
<li><a href="#gas-ii">Gas II</a></li>
<li><a href="#high-level-blockchain-fundamentals">High-Level Blockchain Fundamentals</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-2-welcome-to-remix-simple-storage">Lesson 2: Welcome to Remix! Simple Storage</a></summary>
<ol>
<li><a href="#introduction">Introduction</a></li>
<li><a href="#setting-up-your-first-contract">Setting Up Your First Contract</a></li>
<li><a href="#basic-solidity-types">Basic Solidity: Types</a></li>
<li><a href="#basic-solidity-functions">Basic Solidity: Functions</a></li>
<li><a href="#basic-solidity-arrays--structs">Basic Solidity: Arrays &amp; Structs</a></li>
<li><a href="#basic-solidity-compiler-errors-and-warnings">Basic Solidity: Compiler Errors and Warnings</a></li>
<li><a href="#memory-storage-calldata-intro">Memory, Storage, Calldata (Intro)</a></li>
<li><a href="#mappings">Mappings</a></li>
<li><a href="#deploying-your-first-contract">Deploying your First Contract</a></li>
<li><a href="#the-evm--a-recap-of-lesson-2">The EVM &amp; A Recap of Lesson 2</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-3-remix-storage-factory">Lesson 3: Remix Storage Factory</a></summary>
<ol>
<li><a href="#introduction-1">Introduction</a></li>
<li><a href="#basic-solidity-importing-contracts-into-other-contracts">Basic Solidity: Importing Contracts into other Contracts</a></li>
<li><a href="#basic-solidity-interacting-with-other-contracts">Basic Solidity: Interacting with other Contracts</a></li>
<li><a href="#basic-solidity-inheritance--overrides">Basic Solidity: Inheritance &amp; Overrides</a></li>
<li><a href="#lesson-3-recap">Lesson 3 Recap</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-4-remix-fund-me">Lesson 4: Remix Fund Me</a></summary>
<ol>
<li><a href="#introduction-2">Introduction</a></li>
<li><a href="#sending-eth-through-a-function--reverts">Sending ETH Through a Function &amp; Reverts</a></li>
<li><a href="#chainlink--oracles">Chainlink &amp; Oracles</a></li>
<li><a href="#review-of-sending-eth-and-working-with-chainlink">Review of Sending ETH and working with Chainlink</a></li>
<li><a href="#interfaces--price-feeds">Interfaces &amp; Price Feeds</a></li>
<li><a href="#importing-from-github--npm">Importing from GitHub &amp; NPM</a></li>
<li><a href="#floating-point-math-in-solidtiy">Floating Point Math in Solidity</a></li>
<li><a href="#basic-solidity-arrays--structs-ii">Basic Solidity: Arrays &amp; Structs II</a></li>
<li><a href="#review-of-interfacs-importing-from-github--math-in-solidity">Review of Interfacs, Importing from GitHub, &amp; Math in Solidity</a></li>
<li><a href="#libraries">Libraries</a></li>
<li><a href="#safemath-overflow-checking-and-the-unchecked-keywork">SafeMath, Overflow Checking, and the &quot;unchecked&quot; keywork</a></li>
<li><a href="#basic-solidity-for-loop">Basic Solidity: For Loop</a></li>
<li><a href="#basic-solidity-resetting-an-array">Basic Solidity: Resetting an Array</a></li>
<li><a href="#sending-eth-from-a-contract">Sending ETH from a Contract</a></li>
<li><a href="#basic-solidity-constructor">Basic Solidity: Constructor</a></li>
<li><a href="#basic-solidity-modifiers">Basic Solidity: Modifiers</a></li>
<li><a href="#testnet-demo">Testnet Demo</a></li>
<li><a href="#advanced-solidity">Advanced Solidity</a><ul>
<li><a href="#immutable--constant">Immutable &amp; Constant</a></li>
<li><a href="#custom-errors">Custom Errors</a></li>
<li><a href="#receive--fallback-functions">Receive &amp; Fallback Functions</a></li>
<li><a href="#lesson-4-recap">Lesson 4 Recap</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-5-ethersjs-simple-storage">Lesson 5: Ethers.js Simple Storage</a></summary>
<ol>
<li><a href="#effective-debugging-strategies--getting-help">Effective Debugging Strategies &amp; Getting Help</a><ul>
<li><a href="#how-to-debug-anything-video">How to Debug Anything Video</a></li>
</ul>
</li>
<li><a href="#installation--setup">Installation &amp; Setup</a><ul>
<li><a href="#mac--linux-setup">Mac &amp; Linux Setup</a></li>
<li><a href="#windows-setup">Windows Setup</a></li>
<li><a href="#gitpod">Gitpod</a></li>
</ul>
</li>
<li><a href="#local-development-introduction">Local Development Introduction</a><ul>
<li><a href="#optional-javascript-crash-courses">Optional Javascript Crash Courses</a></li>
</ul>
</li>
<li><a href="#tiny-javascript-refresher">Tiny Javascript Refresher</a></li>
<li><a href="#asynchronous-programming-in-javascript">Asynchronous Programming in Javascript</a></li>
<li><a href="#compiling-our-solidity">Compiling our Solidity</a></li>
<li><a href="#ganache--networks">Ganache &amp; Networks</a></li>
<li><a href="#introduction-to-ethersjs">Introduction to Ethers.js</a><ul>
<li><a href="#a-note-on-the-await-keyword">A Note on the await Keyword</a></li>
</ul>
</li>
<li><a href="#adding-transaction-overrides">Adding Transaction Overrides</a></li>
<li><a href="#transaction-receipts">Transaction Receipts</a></li>
<li><a href="#sending-a-raw-transaction-in-ethersjs">Sending a &quot;raw&quot; Transaction in Ethersjs</a></li>
<li><a href="#interacting-with-contracts-in-ethersjs">Interacting with Contracts in Ethersjs</a></li>
<li><a href="#environment-variables">Environment Variables</a></li>
<li><a href="#better-private-key-management">Better Private Key Management</a></li>
<li><a href="#optional-prettier-formatting">Optional Prettier Formatting</a></li>
<li><a href="#deploying-to-a-testnet-or-a-mainnet">Deploying to a Testnet or a Mainnet</a></li>
<li><a href="#verifying-on-block-explorers-from-the-ui">Verifying on Block Explorers from the UI</a></li>
<li><a href="#alchemy-dashboard--the-mempool">Alchemy Dashboard &amp; The Mempool</a></li>
<li><a href="#lesson-5-recap">Lesson 5 Recap</a><ul>
<li><a href="#typescript-ethers-simple-storage">Typescript Ethers Simple Storage</a></li>
</ul>
</li>
</ol>
</details>
<details>
<summary><a href="#lesson-6-hardhat-simple-storage">Lesson 6: Hardhat Simple Storage</a></summary>
<ol>
<li><a href="#introduction-3">Introduction</a></li>
<li><a href="#hardhat-setup">Hardhat Setup</a><ul>
<li><a href="#troubleshooting-hardaht-setup">Troubleshooting Hardaht Setup</a></li>
</ul>
</li>
<li><a href="#hardhat-setup-continued">Hardhat Setup Continued</a></li>
<li><a href="#deploying-simplestorage-from-hardhat">Deploying SimpleStorage from Hardhat</a></li>
<li><a href="#networks-in-hardhat">Networks in Hardhat</a></li>
<li><a href="#programatic-verification">Programatic Verification</a></li>
<li><a href="#interacting-with-contracts-in-hardhat">Interacting with Contracts in Hardhat</a></li>
<li><a href="#artifacts-troubleshooting">Artifacts Troubleshooting</a></li>
<li><a href="#custom-hardhat-tasks">Custom Hardhat Tasks</a></li>
<li><a href="#hardhat-localhost-node">Hardhat Localhost Node</a></li>
<li><a href="#the-hardhat-console">The Hardhat Console</a></li>
<li><a href="#hardhat-tests">Hardhat Tests</a></li>
<li><a href="#hardhat-gas-reporter">Hardhat Gas Reporter</a></li>
<li><a href="#solidity-coverage">Solidity Coverage</a></li>
<li><a href="#hardhat-waffle">Hardhat Waffle</a></li>
<li><a href="#lesson-6-recap">Lesson 6 Recap</a><ul>
<li><a href="#typescript-hardhat-simple-storage">Typescript Hardhat Simple Storage</a></li>
</ul>
</li>
</ol>
</details>
<details>
<summary><a href="#lesson-7-hardhat-fund-me">Lesson 7: Hardhat Fund Me</a></summary>
<ol>
<li><a href="#introduction-4">Introduction</a></li>
<li><a href="#hardhat-setup---fund-me">Hardhat Setup - Fund Me</a></li>
<li><a href="#linting">Linting</a></li>
<li><a href="#hardhat-setup---fund-me---continued">Hardhat Setup - Fund Me - Continued</a></li>
<li><a href="#importing-from-npm">Importing from NPM</a></li>
<li><a href="#hardhat-deploy">Hardhat Deploy</a></li>
<li><a href="#mocking">Mocking</a></li>
<li><a href="#utils-folder">Utils Folder</a></li>
<li><a href="#testnet-demo---hardhat-fund-me">Testnet Demo - Hardhat Fund Me</a></li>
<li><a href="#solidity-style-guide">Solidity Style Guide</a></li>
<li><a href="#testing-fund-me">Testing Fund Me</a></li>
<li><a href="#breakpoints--debugging">Breakpoints &amp; Debugging</a></li>
<li><a href="#gas-iii">Gas III:</a></li>
<li><a href="#consolelog--debugging">console.log &amp; Debugging</a></li>
<li><a href="#testing-fund-me-ii">Testing Fund Me II</a></li>
<li><a href="#storage-in-solidity">Storage in Solidity</a></li>
<li><a href="#gas-optimizations-using-storage-knowledge">Gas Optimizations using Storage Knowledge</a></li>
<li><a href="#solidity-chainlink-style-guide">Solidity Chainlink Style Guide</a></li>
<li><a href="#storage-review">Storage Review</a></li>
<li><a href="#staging-tests">Staging Tests</a></li>
<li><a href="#running-scripts-on-a-local-node">Running Scripts on a Local Node</a></li>
<li><a href="#adding-scripts-to-your-packagejson">Adding Scripts to your package.json</a></li>
<li><a href="#pushing-to-github">Pushing to GitHub</a></li>
<li><a href="#-tweet-me-add-your-repo-in">🐸🐦 Tweet Me (add your repo in)!</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-8-html--javascript-fund-me-full-stack--front-end">Lesson 8: HTML / Javascript Fund Me (Full Stack / Front End)</a></summary>
<ol>
<li><a href="#introduction-5">Introduction</a></li>
<li><a href="#how-websites-work-with-web3-wallets">How Websites work with Web3 Wallets</a></li>
<li><a href="#html-setup">HTML Setup</a></li>
<li><a href="#connecting-html-to-metamask">Connecting HTML to Metamask</a></li>
<li><a href="#javascript-in-its-own-file">Javascript in it&#39;s own file</a></li>
<li><a href="#es6-vs-nodejs">ES6 vs Nodejs</a></li>
<li><a href="#sending-a-transaction-from-a-website">Sending a transaction from a Website</a></li>
<li><a href="#resetting-an-account-in-metamask">Resetting an Account in Metamask</a></li>
<li><a href="#listening-for-events-and-completed-transactions">Listening for Events and Completed Transactions</a></li>
<li><a href="#input-forms">Input Forms</a></li>
<li><a href="#reading-from-the-blockchain">Reading from the Blockchain</a></li>
<li><a href="#withdraw-function">Withdraw Function</a></li>
<li><a href="#lesson-8-recap">Lesson 8 Recap</a><ul>
<li><a href="#optional-links">Optional Links</a></li>
</ul>
</li>
</ol>
</details>
<details>
<summary><a href="#lesson-9-hardhat-smart-contract-lottery">Lesson 9: Hardhat Smart Contract Lottery</a></summary>
<ol>
<li><a href="#introduction-6">Introduction</a></li>
<li><a href="#hardhat-setup---smart-contract-lottery">Hardhat Setup - Smart Contract Lottery</a></li>
<li><a href="#rafflesol-setup">Raffle.sol Setup</a></li>
<li><a href="#introduction-to-events">Introduction to Events</a></li>
<li><a href="#events-in-rafflesol">Events in Raffle.sol</a></li>
<li><a href="#introduction-to-chainlink-vrf">Introduction to Chainlink VRF</a><ul>
<li><a href="#sub-lesson-chainlink-vrf">Sub-Lesson: Chainlink VRF</a></li>
</ul>
</li>
<li><a href="#implementing-chainlink-vrf---introduction">Implementing Chainlink VRF - Introduction</a><ul>
<li><a href="#hardhat-shorthand">Hardhat Shorthand</a></li>
</ul>
</li>
<li><a href="#implementing-chainlink-vrf---the-request">Implementing Chainlink VRF - The Request</a></li>
<li><a href="#implementing-chainlink-vrf---the-fulfill">Implementing Chainlink VRF - The FulFill</a><ul>
<li><a href="#modulo">Modulo</a></li>
</ul>
</li>
<li><a href="#introduction-to-chainlink-keepers">Introduction to Chainlink Keepers</a></li>
<li><a href="#implementing-chainlink-keepers---checkupkeep">Implementing Chainlink Keepers - checkUpkeep</a><ul>
<li><a href="#enums">Enums</a></li>
</ul>
</li>
<li><a href="#implementing-chainlink-keepers---checkupkeep-continued">Implementing Chainlink Keepers - checkUpkeep continued</a></li>
<li><a href="#implementing-chainlink-keepers---performupkeep">Implementing Chainlink Keepers - performUpkeep</a></li>
<li><a href="#code-cleanup">Code Cleanup</a></li>
<li><a href="#deploying-rafflesol">Deploying Raffle.sol</a><ul>
<li><a href="#mock-chainlink-vrf-coordinator">Mock Chainlink VRF Coordinator</a></li>
<li><a href="#continued">Continued</a></li>
</ul>
</li>
<li><a href="#rafflesol-unit-tests">Raffle.sol Unit Tests</a><ul>
<li><a href="#testing-events--chai-matchers">Testing Events &amp; Chai Matchers</a></li>
<li><a href="#continued-i">Continued I</a></li>
</ul>
</li>
<li><a href="#hardhat-methods--time-travel">Hardhat Methods &amp; Time Travel</a><ul>
<li><a href="#continued-ii">Continued II</a></li>
</ul>
</li>
<li><a href="#callstatic">Callstatic</a><ul>
<li><a href="#continued-iii">Continued III</a></li>
<li><a href="#massive-promise-test">Massive Promise Test</a></li>
<li><a href="#continued-iv">Continued IV</a></li>
</ul>
</li>
<li><a href="#rafflesol-staging-tests">Raffle.sol Staging Tests</a></li>
<li><a href="#testing-on-a-testnet">Testing on a Testnet</a><ul>
<li><a href="#recommended-link-amounts-for-sepolia-staging-test">Recommended LINK amounts for Sepolia Staging Test:</a></li>
</ul>
</li>
<li><a href="#conclusion">Conclusion</a></li>
<li><a href="#typescript---smart-contract-lottery">Typescript - Smart Contract Lottery</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-10-nextjs-smart-contract-lottery-full-stack--front-end">Lesson 10: NextJS Smart Contract Lottery (Full Stack / Front End)</a></summary>
<ol>
<li><a href="#introduction-7">Introduction</a><ul>
<li><a href="#optional-sub-lesson-full-stack-development--other-libraries">Optional Sub-Lesson: Full Stack Development &amp; Other Libraries</a></li>
</ul>
</li>
<li><a href="#nextjs-setup">NextJS Setup</a></li>
<li><a href="#manual-header-i">Manual Header I</a><ul>
<li><a href="#react-hooks">React Hooks</a></li>
</ul>
</li>
<li><a href="#manual-header-ii">Manual Header II</a></li>
<li><a href="#useeffect-hook">useEffect Hook</a></li>
<li><a href="#local-storage">Local Storage</a></li>
<li><a href="#isweb3enabledloading">isWeb3EnabledLoading</a></li>
<li><a href="#web3uikit">web3uikit</a></li>
<li><a href="#introduction-to-calling-functions-in-nextjs">Introduction to Calling Functions in Nextjs</a><ul>
<li><a href="#automatic-constant-value-ui-updater">Automatic Constant Value UI Updater</a></li>
<li><a href="#runcontractfunction">runContractFunction</a></li>
</ul>
</li>
<li><a href="#usestate">useState</a></li>
<li><a href="#calling-functions-in-nextjs">Calling Functions in NextJS</a></li>
<li><a href="#usenotification">useNotification</a></li>
<li><a href="#reading--displaying-contract-data">Reading &amp; Displaying Contract Data</a></li>
<li><a href="#a-note-about-onsuccess">A Note about <code>onSuccess</code></a></li>
<li><a href="#a-challenge-to-you">A Challenge to You</a></li>
<li><a href="#tailwind--styling">Tailwind &amp; Styling</a></li>
<li><a href="#introduction-to-hosting-your-site">Introduction to Hosting your Site</a></li>
<li><a href="#ipfs">IPFS</a></li>
<li><a href="#hosting-on-ipfs">Hosting on IPFS</a></li>
<li><a href="#hosting-on-ipfs--filecoin-using-fleek">Hosting on IPFS &amp; Filecoin using Fleek</a></li>
<li><a href="#filecoin-overview">Filecoin Overview</a></li>
<li><a href="#lesson-10-recap">Lesson 10 Recap</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-11-hardhat-starter-kit">Lesson 11: Hardhat Starter Kit</a></summary>
<ol>
</details>
<details>
<summary><a href="#lesson-12-hardhat-erc20s">Lesson 12: Hardhat ERC20s</a></summary>
<ol>
<li><a href="#what-is-an-erc-what-is-an-eip">What is an ERC? What is an EIP?</a></li>
<li><a href="#what-is-an-erc20">What is an ERC20?</a></li>
<li><a href="#manually-creating-an-erc20-token">Manually Creating an ERC20 Token</a></li>
<li><a href="#creating-an-erc20-token-with-openzeppelin">Creating an ERC20 Token with Openzeppelin</a></li>
<li><a href="#lesson-12-recap">Lesson 12 Recap</a></li>
</ul>
</ol>
</details>
<details>
<summary><a href="#lesson-13-hardhat-defi--aave">Lesson 13: Hardhat DeFi &amp; Aave</a></summary>
<ol>
<li><a href="#what-is-defi">What is DeFi?</a></li>
<li><a href="#what-is-aave">What is Aave?</a></li>
<li><a href="#programatic-borrowing--lending">Programatic Borrowing &amp; Lending</a></li>
<li><a href="#weth---wrapped-eth">WETH - Wrapped ETH</a></li>
<li><a href="#forking-mainnet">Forking Mainnet</a></li>
<li><a href="#depositing-into-aave">Depositing into Aave</a></li>
<li><a href="#borrowing-from-aave">Borrowing from Aave</a></li>
<li><a href="#repaying-with-aave">Repaying with Aave</a></li>
<li><a href="#visualizing-the-transactions">Visualizing the Transactions</a></li>
<li><a href="#lesson-13-recap">Lesson 13 Recap</a></li>
<li><a href="#happy-bow-tie-friday-with-austin-griffith">Happy Bow-Tie Friday with Austin Griffith</a><ul>
<li><a href="#more-defi-learnings">More DeFi Learnings:</a></li>
</ul>
</li>
</ul>
</ol>
</details>
<details>
<summary><a href="#lesson-14-hardhat-nfts-everything-you-need-to-know-about-nfts">Lesson 14: Hardhat NFTs (EVERYTHING you need to know about NFTs)</a></summary>
<ol>
<li><a href="#what-is-an-nft">What is an NFT?</a></li>
<li><a href="#code-overview">Code Overview</a></li>
<li><a href="#hardhat-setup-1">Hardhat Setup</a></li>
<li><a href="#basic-nft">Basic NFT</a><ul>
<li><a href="#write-tests">Write Tests</a></li>
</ul>
</li>
<li><a href="#random-ipfs-nft">Random IPFS NFT</a><ul>
<li><a href="#mapping-chainlink-vrf-requests">Mapping Chainlink VRF Requests</a></li>
<li><a href="#creating-rare-nfts">Creating Rare NFTs</a></li>
<li><a href="#setting-the-nft-image">Setting the NFT Image</a></li>
<li><a href="#setting-an-nft-mint-price">Setting an NFT Mint Price</a></li>
<li><a href="#deploy-script">Deploy Script</a></li>
<li><a href="#uploading-token-images-with-pinata">Uploading Token Images with Pinata</a></li>
<li><a href="#uploading-token-uris-metadata-with-pinata">Uploading Token URIs (metadata) with Pinata</a></li>
<li><a href="#deploying">Deploying</a></li>
<li><a href="#tests">Tests</a></li>
</ul>
</li>
<li><a href="#dynamic-svg-on-chain-nft">Dynamic SVG On-Chain NFT</a><ul>
<li><a href="#what-is-an-svg">What is an SVG?</a></li>
<li><a href="#initial-code">Initial Code</a></li>
<li><a href="#base64-encoding">Base64 Encoding</a></li>
</ul>
</li>
<li><a href="#advanced-evm-opcodes-encoding-and-calling">Advanced: EVM Opcodes, Encoding, and Calling</a><ul>
<li><a href="#abiencode--abiencodepacked">abi.encode &amp; abi.encodePacked</a></li>
<li><a href="#introduction-to-encoding-function-calls-directly">Introduction to Encoding Function Calls Directly</a></li>
<li><a href="#introduction-to-encoding-function-calls-recap">Introduction to Encoding Function Calls Recap</a></li>
<li><a href="#encoding-function-calls-directly">Encoding Function Calls Directly</a></li>
<li><a href="#creating-an-nft-tokenuri-on-chain">Creating an NFT TokenURI on-Chain</a></li>
<li><a href="#making-the-nft-dynamic">Making the NFT Dynamic</a></li>
<li><a href="#deploy-script-1">Deploy Script</a></li>
</ul>
</li>
<li><a href="#deploying-the-nfts-to-a-testnet">Deploying the NFTs to a Testnet</a></li>
<li><a href="#lesson-14-recap">Lesson 14 Recap</a></li>
</ul>
</ol>
</details>
<details>
<summary><a href="#lesson-15-nextjs-nft-marketplace-if-you-finish-this-lesson-you-are-a-full-stack-monster">Lesson 15: NextJS NFT Marketplace (If you finish this lesson, you are a full-stack MONSTER!)</a></summary>
<ol>
<li><a href="#introduction-8">Introduction</a></li>
<li><a href="#part-i-nft-marketplace-contracts">Part I: NFT Marketplace Contracts</a><ul>
<li><a href="#hardhat-setup-2">Hardhat Setup</a></li>
<li><a href="#nftmarketplacesol">NftMarketplace.sol</a></li>
</ul>
</li>
<li><a href="#reentrancy">Reentrancy</a><ul>
<li><a href="#nftmarketplacesol---continued">NftMarketplace.sol - Continued</a></li>
<li><a href="#nftmarketplacesol---deploy-script">NftMarketplace.sol - Deploy Script</a></li>
<li><a href="#nftmarketplacesol---tests">NftMarketplace.sol - Tests</a></li>
<li><a href="#nftmarketplacesol---scripts">NftMarketplace.sol - Scripts</a></li>
</ul>
</li>
<li><a href="#part-ii-moralis-front-end">Part II: Moralis Front End</a><ul>
<li><a href="#what-is-moralis">What is Moralis?</a></li>
<li><a href="#nextjs-setup-1">NextJS Setup</a></li>
<li><a href="#adding-tailwind">Adding Tailwind</a></li>
<li><a href="#introduction-to-indexing-in-web3">Introduction to Indexing in Web3</a></li>
<li><a href="#connecting-moralis-to-our-local-hardhat-node">Connecting Moralis to our Local Hardhat Node</a></li>
<li><a href="#moralis-event-sync">Moralis Event Sync</a><ul>
<li><a href="#reset-local-chain">Reset Local Chain</a></li>
</ul>
</li>
<li><a href="#moralis-cloud-functions">Moralis Cloud Functions</a><ul>
<li><a href="#practice-resetting-the-local-chain">Practice Resetting the Local Chain</a></li>
</ul>
</li>
<li><a href="#moralis-cloud-functions-ii">Moralis Cloud Functions II</a></li>
<li><a href="#querying-the-moralis-database">Querying the Moralis Database</a></li>
<li><a href="#rendering-the-nft-images">Rendering the NFT Images</a></li>
<li><a href="#update-listing-modal">Update Listing Modal</a></li>
<li><a href="#buy-nft-listing">Buy NFT Listing</a></li>
<li><a href="#listing-nfts-for-sale">Listing NFTs for Sale</a></li>
</ul>
</li>
<li><a href="#part-iii-thegraph-front-end">Part III: TheGraph Front End</a><ul>
<li><a href="#introduction-9">Introduction</a></li>
<li><a href="#what-is-the-graph">What is The Graph?</a></li>
<li><a href="#building-a-subgraph">Building a Subgraph</a></li>
<li><a href="#deploying-our-subgraph">Deploying our Subgraph</a></li>
<li><a href="#reading-from-the-graph">Reading from The Graph</a></li>
<li><a href="#hosting-our-dapp">Hosting our Dapp</a></li>
</ul>
</li>
</ul>
</ol>
</details>
<details>
<summary><a href="#lesson-16-hardhat-upgrades">Lesson 16: Hardhat Upgrades</a></summary>
<ol>
<li><a href="#upgradeable-smart-contracts-overview">Upgradeable Smart Contracts Overview</a></li>
<li><a href="#types-of-upgrades">Types of Upgrades</a></li>
<li><a href="#delegatecall">Delegatecall</a></li>
<li><a href="#small-proxy-example">Small Proxy Example</a></li>
<li><a href="#transparent-upgradeable-smart-contract">Transparent Upgradeable Smart Contract</a></li>
</ul>
</ol>
</details>
<details>
<summary><a href="#lesson-17-hardhat-daos">Lesson 17: Hardhat DAOs</a></summary>
<ol>
<li><a href="#introduction-10">Introduction</a></li>
<li><a href="#what-is-a-dao">What is a DAO?</a></li>
<li><a href="#how-to-build-a-dao">How to build a DAO</a></li>
</ol>
</details>
<details>
<summary><a href="#lesson-18-security--auditing">Lesson 18: Security &amp; Auditing</a></summary>
<ol>
<li><a href="#introduction-11">Introduction</a></li>
<li><a href="#slither">Slither</a></li>
<li><a href="#fuzzing-and-eth-security-toolbox">Fuzzing and Eth Security Toolbox</a></li>
<li><a href="#closing-thoughts">Closing Thoughts</a></li>
</ol>
</details>
<details>
<summary>More Resources</summary>
<ul>
<li><a href="#congratulations">Congratulations</a><ul>
<li><a href="#where-do-i-go-now">Where do I go now?</a><ul>
<li><a href="#learning-more">Learning More</a></li>
<li><a href="#community">Community</a></li>
<li><a href="#hackathons">Hackathons</a></li>
</ul>
</li>
</ul>
</li>
</ul>
</ul>
</details>

# Lesson 0: The Edge of the Rabbit Hole

## Welcome to the course!

_[⌨️ (00:00:00) Lesson 0: Welcome To Blockchain](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=0s)_

## Best Practices

- **Follow the repository:** While going through the course be 100% certain to follow along with the github repository. If you run into in an issue check the chronological-updates in the repo.
- **Be Active in the community:** Ask questions and engage with other developers going through the course in the discussions tab, be sure to go and say hello or gm! This space is different from the other industries, you don't have to be secretive; communicate, network and learn with others :)
- **Learn at your own pace:** It doesn't matter if it takes you a day, a week, a month or even a year. Progress >>> Perfection
- **Take Breaks:** You will exhaust your mind and recall less if you go all out and watch the entire course in one sitting.
  **Suggested Strategy** every 25 minutes take a 5 min break, and every 2 hours take a longer 30 min break
- **Refer to Documentation:** Things are constantly being updated, so whenever Patrick opens up some documentation, open it your end and maybe even have the code sample next to you.

# Lesson 1: Blockchain Basics

_[⌨️ (00:09:05) Lesson 1: Blockchain Basics](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=545s)_

## What is a Blockchain? What does a blockchain do?

- [Bitcoin Whitepaper](https://bitcoin.org/bitcoin.pdf)
  - [Satoshi Nakamoto](https://en.wikipedia.org/wiki/Satoshi_Nakamoto)
- [Ethereum Whitepaper](https://ethereum.org/en/whitepaper/)
  - [Vitalik Buterin](https://en.wikipedia.org/wiki/Vitalik_Buterin)
- [What is a Smart Contract?](https://chain.link/education/smart-contracts)
- [Nick Szabo](https://en.wikipedia.org/wiki/Nick_Szabo)
- [Hybrid Smart Contracts](https://blog.chain.link/hybrid-smart-contracts-explained/)
- [Blockchain Oracles](https://betterprogramming.pub/what-is-a-blockchain-oracle-f5ccab8dbd72?source=friends_link&sk=d921a38466df8a9176ed8dd767d8c77d)
- [Terminology](https://connect.comptia.org/content/articles/blockchain-terminology)
- [Web3](https://en.wikipedia.org/wiki/Web3)
- [What is a blockchain](https://www.investopedia.com/terms/b/blockchain.asp)

## The Purpose Of Smart Contracts

_[⌨️ (00:18:27) The Purpose of Smart Contracts](https://youtu.be/gyMwXuJrbJQ?t=1107)_

- 🎥 [Original Video](https://www.youtube.com/watch?v=_JeRq7Gwj5Y&feature=youtu.be)
- 🦬 [My ETH Denver Talk](https://www.youtube.com/watch?v=06hXCX_jj2E)
- 🍔 [McDonalds Scandal](https://www.chicagotribune.com/sns-mcdonalds-story.html)
- ⛓ [More on the evolution of agreements](https://www.youtube.com/watch?v=ufVyX7JDCgg)
- ✍️ [What is a Smart Contract?](https://www.youtube.com/watch?v=ZE2HxTmxfrI)
- 🧱 [How does a blockchain work?](https://www.youtube.com/watch?v=SSo_EIwHSd4)
- 🔮 [Chainlink & Oracles](https://www.youtube.com/watch?v=tIUHQ7sDoaU)

## Other Blockchain Benefits

_[⌨️ (00:30:41) Other Blockchain Benefits](https://youtu.be/gyMwXuJrbJQ?t=1841)_

- Decentralized
- Transparency & Flexibility
- Speed & Efficiency
- Security & Immutability
- Counterparty Risk Removal
- Trust Minimized Agreements

## What have Smart Contracts done so far?

_[⌨️ (00:36:36) What have Smart Contracts done so far?](https://youtu.be/gyMwXuJrbJQ?t=2196)_

- [DeFi](https://chain.link/education/defi)
  - [Defi Llama](https://defillama.com/)
  - [Why DeFi is Important](https://medium.com/the-capital/why-defi-1519cc4d4bd3)
- [DAOs](https://betterprogramming.pub/what-is-a-dao-what-is-the-architecture-of-a-dao-how-to-build-a-dao-high-level-d096a97162cc)
- [NFTs](https://www.youtube.com/watch?v=9yuHz6g_P50)

## Making Your First Transaction

_[⌨️ (00:39:17) Making Your First Transaction](https://youtu.be/gyMwXuJrbJQ?t=2357)_

- [Metamask Download Link](https://metamask.io/)
  - [What is a Private Key?](https://www.coinbase.com/learn/crypto-basics/what-is-a-private-key)
  - [What is a Secret Phrase?](https://metamask.zendesk.com/hc/en-us/articles/360060826432-What-is-a-Secret-Recovery-Phrase-and-how-to-keep-your-crypto-wallet-secure)
- [Etherscan](https://etherscan.io/)
- [Sepolia Etherscan](https://sepolia.etherscan.io/)
- Sepolia Faucet (Check the [link token contracts page](https://docs.chain.link/docs/link-token-contracts/#sepolia))
  - NOTE: The Chainlink documentation always has the most up to date faucets on their [link token contracts page](https://docs.chain.link/docs/link-token-contracts/#sepolia). If the faucet above is broken, check the chainlink documentation for the most up to date faucet.
- OR, use the [Sepolia ETH Faucet](https://faucets.chain.link/), just be sure to swap your metamask to Sepolia!

## Gas I: Introduction to Gas

_[⌨️ (00:58:59) Gas I: Introduction to Gas](https://youtu.be/gyMwXuJrbJQ?t=3539)_

- [Gas and Gas Fees](https://ethereum.org/en/developers/docs/gas/)
- [Wei, Gwei, and Ether Converter](https://eth-converter.com/)
- [ETH Gas Station](https://ethgasstation.info/)

## How Do Blockchains Work?

_[⌨️ (01:05:32) How Do Blockchains Work](https://youtu.be/gyMwXuJrbJQ?t=3932)_

- [What is a hash?](https://techjury.net/blog/what-is-cryptographic-hash/)
- [Blockchain Demo](https://andersbrownworth.com/blockchain/)
- [Summary](https://ethereum.org/en/developers/docs/intro-to-ethereum/)

## Signing Transactions

_[⌨️ (01:22:55) Signing Transactions](https://youtu.be/gyMwXuJrbJQ?t=4975)_

- [Public / Private Keys](https://andersbrownworth.com/blockchain/public-private-keys/keys)
- [Layer 2 and Rollups](https://ethereum.org/en/developers/docs/scaling/layer-2-rollups/)
- [Decentralized Blockchain Oracles](https://blog.chain.link/what-is-the-blockchain-oracle-problem/)

## Gas II

_[⌨️ (01:30:22) Gas II: Block Rewards & EIP 1559](https://youtu.be/gyMwXuJrbJQ?t=5422)_

- [Block Rewards](https://www.investopedia.com/terms/b/block-reward.asp)
- Advanced Gas
  - [EIP 1559](https://www.youtube.com/watch?v=MGemhK9t44Q)
  - GWEI, WEI, and ETH
    - [ETH Converter](https://eth-converter.com/)

## Gas II Summary

_[⌨️ (01:36:44) Gas II Summary](https://youtu.be/gyMwXuJrbJQ?t=5804)_

- [Run Your Own Ethereum Node](https://geth.ethereum.org/docs/getting-started)

## High-Level Blockchain Fundamentals

_[⌨️ (01:39:32) High-Level Blockchain Fundamentals]https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=5972s()_

- [Consensus](https://wiki.polkadot.network/docs/learn-consensus)
- [Proof of Stake](https://ethereum.org/en/developers/docs/consensus-mechanisms/pos/)
- [Proof of Work](https://ethereum.org/en/developers/docs/consensus-mechanisms/pow/)
- [Nakamoto Consensus](https://blockonomi.com/nakamoto-consensus/)
- [Ethereum 2 (the merge)](https://ethereum.org/en/eth2/)

🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊 Completed Blockchain Basics! 🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊

# Lesson 2: [Welcome to Remix! Simple Storage](https://github.com/PatrickAlphaC/simple-storage-fcc)

_[⌨️ (02:01:16) Lesson 2: Welcome to Remix! Simple Storage](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=7276s)_

💻 Code: https://github.com/PatrickAlphaC/simple-storage-fcc

## Introduction

_[⌨️ (02:03:05) Introduction](https://youtu.be/gyMwXuJrbJQ?t=7385)_

- [Remix](https://remix.ethereum.org/)
- [Solidity Documentation](https://docs.soliditylang.org/en/latest/index.html)

## Setting Up Your First Contract

_[⌨️ (02:05:18) Setting Up Your First Contract](https://youtu.be/gyMwXuJrbJQ?t=7518)_

- Versioning
- Take notes in your code!
- [What is a software license](https://snyk.io/learn/what-is-a-software-license/)
- SPDX License
- Compiling
- Contract Declaration

## Basic Solidity: Types

_[⌨️ (02:12:28) Basic Solidity Types](https://youtu.be/gyMwXuJrbJQ?t=7948)_

- [Types & Declaring Variables](https://docs.soliditylang.org/en/v0.8.13/)
  - `uint256`, `int256`, `bool`, `string`, `address`, `bytes32`
  - [Solidity Types](https://docs.soliditylang.org/en/latest/types.html)
  - [Bits and Bytes](https://www.youtube.com/watch?v=Dnd28lQHquU)
- Default Initializations
- Comments

## Basic Solidity: Functions

_[⌨️ (02:18:40) Basic Solidity Functions](https://youtu.be/gyMwXuJrbJQ?t=8320)_

- Functions
- Deploying a Contract
  - Smart Contracts have addresses just like our wallets
- Calling a public state-changing Function
- [Visibility](https://docs.soliditylang.org/en/latest/contracts.html#visibility-and-getters)
- Gas III | An example
- Scope
- View & Pure Functions

## Basic Solidity: Arrays & Structs

_[⌨️ (02:35:30) Basic Solidity Arrays & Structs](https://youtu.be/gyMwXuJrbJQ?t=9331)_

- Structs
- Intro to Storage
- Arrays
- Dynamic & Fixed Sized
- `push` array function

## Basic Solidity: Compiler Errors and Warnings

_[⌨️ (02:45:35) Basic Solidity Errors & Warnings](https://youtu.be/gyMwXuJrbJQ?t=9935)_

- Yellow: Warnings are Ok
- Red: Errors are not Ok

## Memory, Storage, Calldata (Intro)

_[⌨️ (02:46:34) Basic Solidity Memory, Storage, & Calldata (Intro)](https://youtu.be/gyMwXuJrbJQ?t=9994)_

- 6 Places you can store and access data
  - calldata
  - memory
  - storage
  - code
  - logs
  - stack

## Mappings

_[⌨️ (02:50:17) Basic Solidity Mappings](https://youtu.be/gyMwXuJrbJQ?t=10217)_

- [Mappings](https://solidity-by-example.org/mapping)

## Deploying your First Contract

_[⌨️ (02:53:38) Deploying your First Contract](https://youtu.be/gyMwXuJrbJQ?t=10418)_

- A testnet or mainnet
- Connecting Metamask
- [Find a faucet here](https://docs.chain.link/docs/link-token-contracts/#Sepolia)
- See the faucets at the top of this readme!
- Interacting with Deployed Contracts

## The EVM & A Recap of Lesson 2

_[⌨️ (03:03:07) The EVM & A Recap of Lesson 2](https://youtu.be/gyMwXuJrbJQ?t=10987)_

- The EVM

# Lesson 3: Remix Storage Factory

_[⌨️ (03:05:34) Lesson 3: Remix Storage Factory](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=11134s)_

💻 Code: https://github.com/PatrickAlphaC/storage-factory-fcc

## Introduction

_[⌨️ (03:06:06) Introduction](https://youtu.be/gyMwXuJrbJQ?t=11166)_

- [Factory Pattern](https://betterprogramming.pub/learn-solidity-the-factory-pattern-75d11c3e7d29)

## Basic Solidity: Importing Contracts into other Contracts

_[⌨️ (03:07:29) Importing Contracts into other Contracts](https://youtu.be/gyMwXuJrbJQ?t=11249)_

- [Composibility](https://chain.link/techtalks/defi-composability)
- [Solidity new keyword](https://docs.soliditylang.org/en/latest/control-structures.html?highlight=new#creating-contracts-via-new)
- [Importing Code in solidity](https://solidity-by-example.org/import)

## Basic Solidity: Interacting with other Contracts

_[⌨️ (03:16:36) Interacting with other contracts](https://youtu.be/gyMwXuJrbJQ?t=11796)_

- To interact, you always need: ABI + Address
- [ABI](https://docs.soliditylang.org/en/latest/abi-spec.html?highlight=abi)

## Basic Solidity: Inheritance & Overrides

_[⌨️ (03:25:23) Inheritance & Overrides](https://youtu.be/gyMwXuJrbJQ?t=12323)_

- [Inheritance](https://solidity-by-example.org/inheritance)
- [Override & Virtual Keyword](https://docs.soliditylang.org/en/latest/contracts.html?highlight=override#function-overriding)

## Lesson 3 Recap

_[⌨️ (03:30:29) Lesson 3 Recap](https://youtu.be/gyMwXuJrbJQ?t=12629)_

# Lesson 4: Remix Fund Me

_[⌨️ (03:31:55) Lesson 4: Remix Fund Me](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=12715s)_

💻 Code: https://github.com/PatrickAlphaC/fund-me-fcc

## Introduction

## Sending ETH Through a Function & Reverts

- [Fields in a Transaction](https://ethereum.org/en/developers/docs/transactions/)
- [More on v,r,s](https://ethereum.stackexchange.com/questions/15766/what-does-v-r-s-in-eth-gettransactionbyhash-mean)
- [payable](https://solidity-by-example.org/payable)
- [msg.value & Other global keywords](https://docs.soliditylang.org/en/latest/cheatsheet.html?highlight=cheatsheet#global-variables)
- [require](https://codedamn.com/news/solidity/what-is-require-in-solidity)
- [revert](https://medium.com/blockchannel/the-use-of-revert-assert-and-require-in-solidity-and-the-new-revert-opcode-in-the-evm-1a3a7990e06e)

## Chainlink & Oracles

- [What is a blockchain oracle?](https://chain.link/education/blockchain-oracles)
- [What is the oracle problem?](https://blog.chain.link/what-is-the-blockchain-oracle-problem/)
- [Chainlink](https://chain.link/)
- [Chainlink Price Feeds (Data Feeds)](https://docs.chain.link/docs/get-the-latest-price/)
  - [data.chain.link](https://data.chain.link/)
- [Chainlink VRF](https://docs.chain.link/docs/chainlink-vrf/)
- [Chainlink Keepers](https://docs.chain.link/docs/chainlink-keepers/introduction/)
- [Chainlink API Calls](https://docs.chain.link/docs/request-and-receive-data/)
- [Importing Tokens into your Metamask](https://consensys.net/blog/metamask/how-to-add-your-custom-tokens-in-metamask/)
- [Request and Receive Chainlink Model](https://docs.chain.link/docs/architecture-request-model/)

## Review of Sending ETH and working with Chainlink

## Interfaces & Price Feeds

- [Chainlink Price Feeds (Data Feeds)](https://docs.chain.link/docs/get-the-latest-price/)
- [Chainlink GitHub](https://github.com/smartcontractkit/chainlink)
- [Interface](https://solidity-by-example.org/interface)

## Importing from GitHub & NPM

- [Chainlink NPM Package](https://www.npmjs.com/package/@chainlink/contracts)

## Floating Point Math in Solidity

- [tuple](https://docs.soliditylang.org/en/latest/abi-spec.html?highlight=tuple#handling-tuple-types)
- [Floating Point Numbers in Solidity](https://stackoverflow.com/questions/58277234/does-solidity-supports-floating-point-number)
- [Type Casting](https://ethereum.stackexchange.com/questions/6891/type-casting-in-solidity)
- Gas Estimation Failed
  - Someone should make an article explaining this error

## Basic Solidity: Arrays & Structs II

- [msg.sender](https://docs.soliditylang.org/en/latest/cheatsheet.html?highlight=msg.sender)

## Review of Interfaces, Importing from GitHub, & Math in Solidity

## Libraries

- [Library](https://docs.soliditylang.org/en/v0.8.14/contracts.html?highlight=library#libraries)
- [Solidity-by-example Library](https://solidity-by-example.org/library)

## SafeMath, Overflow Checking, and the "unchecked" keyword

- [Openzeppelin Safemath](https://github.com/OpenZeppelin/openzeppelin-contracts/blob/master/contracts/utils/math/SafeMath.sol)
- [unchecked vs. checked](https://docs.soliditylang.org/en/latest/control-structures.html#checked-or-unchecked-arithmetic)

## Basic Solidity: For Loop

- [For Loop](https://solidity-by-example.org/loop)
- `/* */` is another way to make comments

## Basic Solidity: Resetting an Array

## Sending ETH from a Contract

- [Transfer, Send, Call](https://solidity-by-example.org/sending-ether/)
- [this keyword](https://ethereum.stackexchange.com/questions/1781/what-is-the-this-keyword-in-solidity)

## Basic Solidity: Constructor

- [Constructor](https://solidity-by-example.org/constructor)

## Basic Solidity: Modifiers

- [Double equals](https://www.geeksforgeeks.org/solidity-operators/)
- [Modifier](https://solidity-by-example.org/function-modifier)

## Testnet Demo

- [Disconnecting Metamask](https://help.1inch.io/en/articles/4666771-metamask-how-to-connect-disconnect-and-switch-accounts-with-metamask-on-1inch-network)

## Advanced Solidity

### Immutable & Constant

- [Immutable](https://solidity-by-example.org/immutable)
- [Constant](https://solidity-by-example.org/constants)
- [Current ETH Gas Prices](https://etherscan.io/gastracker)
- Don't stress about gas optimizations! (yet)
- Naming Conventions
  - [Someone make this!](https://github.com/smartcontractkit/full-blockchain-solidity-course-js/issues/13)

### Custom Errors

- [Custom Errors Introduction](https://blog.soliditylang.org/2021/04/21/custom-errors/)

### Receive & Fallback Functions

- [Solidity Docs Special Functions](https://docs.soliditylang.org/en/latest/contracts.html?highlight=fallback#special-functions)
- [Fallback](https://solidity-by-example.org/fallback)
- [Receive](https://docs.soliditylang.org/en/latest/contracts.html?highlight=fallback#receive-ether-function)

## Lesson 4 Recap

🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊 Completed Solidity Basics! 🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊

# Lesson 5: Ethers.js Simple Storage

_[⌨️ (05:30:42) Lesson 5: Ethers.js Simple Storage](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=19842s)_

💻 Code: https://github.com/PatrickAlphaC/ethers-simple-storage-fcc

🧪 [Alchemy: https://alchemy.com/?a=673c802981](https://alchemy.com/?a=673c802981)

## Effective Debugging Strategies & Getting Help

_[⌨️ (5:30:46) Effective Debugging Stategies & Getting Help](https://youtu.be/gyMwXuJrbJQ?t=19846)_

1. Tinker and isolate problem
   1. For this course, take at LEAST 15 minutes to figure out a bug.
2. Google / Web Search the Exact problem
   1. Go to this GitHub Repo / Discussions
3. Ask a question on a Forum like Stack Exchange Ethereum or Stack Overflow
   1. Format your questions!!
   2. Use [Markdown](https://www.markdowntutorial.com/)

### How to Debug Anything Video

- [Patrick's Original Video](https://www.youtube.com/watch?v=XT8STflvwNo)

## Installation & Setup

- [Visual Studio Code](https://code.visualstudio.com/)
  - [Crash Course](https://www.youtube.com/watch?v=WPqXP_kLzpo)
- [NodeJS](https://nodejs.org/en/)
- [VSCode Keybindings](https://code.visualstudio.com/docs/getstarted/keybindings)
- [Git](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git)
- [What is a terminal?](https://code.visualstudio.com/docs/editor/integrated-terminal)

### Mac & Linux Setup

### Windows Setup

- [WSL](https://docs.microsoft.com/en-us/windows/wsl/install)
  - When working in WSL, use Linux commands instead of Windows commands
- [TroubleShooting](https://docs.microsoft.com/en-us/windows/wsl/troubleshooting)
- `curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.1/install.sh | bash`

> ⚠️ Please use Gitpod as an absolute last resort

### Gitpod

- [Gitpod](https://www.gitpod.io/)
  - **If using this, NEVER share a private key with real money on Gitpod**
  - Ideally you figure out the MacOS, Linux, or Windows install though

## Local Development Introduction

- `CMD + K` or `CTRL + K` clears the terminal
- `mkdir ethers-simple-storage-fcc`
- `code .` to open VSCode in a new VSCode window

### Optional Javascript Crash Courses

- [NodeJS Course](https://www.youtube.com/watch?v=RLtyhwFtXQA)
- [Javascript Course](https://www.youtube.com/watch?v=jS4aFq5-91M)
- Import your `SimpleStorage.sol`
- [Solidity + Hardhat VSCode Extension](https://marketplace.visualstudio.com/items?itemName=NomicFoundation.hardhat-solidity)

- Format your solidity code with:

```
    "[solidity]": {
        "editor.defaultFormatter": "NomicFoundation.hardhat-solidity"
    },
    "[javascript]":{
      "editor.defaultFormatter": "esbenp.prettier-vscode"
    }
```

In your `.vscode/settings.json` file.

- [Prettier Extension](https://marketplace.visualstudio.com/items?itemName=esbenp.prettier-vscode)

## Tiny Javascript Refresher

- [Javascript Tips](https://www.freecodecamp.org/news/learn-javascript-free-js-courses-for-beginners/)

## Asynchronous Programming in Javascript

- [Asynchronous Programming](https://www.bmc.com/blogs/asynchronous-programming/)
- [async keyword](https://www.w3schools.com/JS//js_async.asp)
- [Promise in Javascript](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)
- [await keyword](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/await)

## Compiling our Solidity

- [Yarn Install](https://yarnpkg.com/getting-started/install)
- [solc-js](https://github.com/ethereum/solc-js)
  - `yarn add solc@0.8.7-fixed`
- [yarn scripts](https://classic.yarnpkg.com/lang/en/docs/cli/run/)

## Ganache & Networks

- [Ganache](https://trufflesuite.com/ganache/)
- Networks in Metamask
- RPC URL
- [Geth](https://github.com/ethereum/go-ethereum)
- [JSON RPC Spec Playground](https://playground.open-rpc.org/?schemaUrl=https://raw.githubusercontent.com/ethereum/execution-apis/assembled-spec/openrpc.json&uiSchema%5BappBar%5D%5Bui:splitView%5D=false&uiSchema%5BappBar%5D%5Bui:input%5D=false&uiSchema%5BappBar%5D%5Bui:examplesDropdown%5D=false)

## Introduction to Ethers.js

- [Ethers.js](https://docs.ethers.io/v5/getting-started/)
- [prettier-plugin-solidity](https://github.com/prettier-solidity/prettier-plugin-solidity)

### A Note on the await Keyword

## Adding Transaction Overrides

## Transaction Receipts

## Sending a "raw" Transaction in Ethers.js

## Interacting with Contracts in Ethers.js

- [EVM Decompiler](https://ethervm.io/decompile)
- [BigNumber](https://docs.ethers.io/v5/api/utils/bignumber/)

## Environment Variables

- [dotenv](https://www.npmjs.com/package/dotenv)
- [.gitignore](https://www.atlassian.com/git/tutorials/saving-changes/gitignore)

## Better Private Key Management

- [wallet.encrypt](https://docs.ethers.io/v5/api/signer/#Wallet-encrypt)
- [THE .ENV PLEDGE](https://github.com/smartcontractkit/full-blockchain-solidity-course-js/discussions/5)

## Optional Prettier Formatting

- [Prettier](https://prettier.io/docs/en/index.html)
- [Best README Template](https://github.com/othneildrew/Best-README-Template)

## Deploying to a Testnet or a Mainnet

- [Alchemy](https://alchemy.com/?a=673c802981)
- [Getting your private key from Metamask](https://metamask.zendesk.com/hc/en-us/articles/360015289632-How-to-Export-an-Account-Private-Key)
- `CTRL + C` stops any terminal command

## Verifying on Block Explorers from the UI

## Alchemy Dashboard & The Mempool

- [Special Guest Albert Hu](https://twitter.com/thatguyintech)
- [Mempool](https://ethereum.org/en/developers/tutorials/sending-transactions-using-web3-and-alchemy/#see-your-transaction-in-the-mempool)

## Lesson 5 Recap

### Typescript Ethers Simple Storage

# Lesson 6: Hardhat Simple Storage

_[⌨️ (08:20:17) Lesson 6: Hardhat Simple Storage](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=30017s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-simple-storage-fcc

## Introduction

_[⌨️ (08:20:19) Introduction](https://youtu.be/gyMwXuJrbJQ?t=30019)_

## Hardhat Setup

_[⌨️ (08:22:47) Hardhat Setup](https://youtu.be/gyMwXuJrbJQ?t=30167)_

- [Hardhat Documentation](https://hardhat.org/)
- [DevDependencies vs Dependencies](https://stackoverflow.com/questions/18875674/whats-the-difference-between-dependencies-devdependencies-and-peerdependencies)
- [@ Sign node modules](https://stackoverflow.com/questions/36667258/what-is-the-meaning-of-the-at-prefix-on-npm-packages)

### Troubleshooting Hardhat Setup

_[⌨️ (08:29:43) Troubleshooting Hardhat Setup](https://youtu.be/gyMwXuJrbJQ?t=30583)_

- [Special Guest Cami Ramos Garzon](https://twitter.com/camiinthisthang)

## Hardhat Setup Continued

_[⌨️ (08:31:48) Hardhat Setup Continued](https://youtu.be/gyMwXuJrbJQ?t=30708)_

## Deploying SimpleStorage from Hardhat

_[⌨️ (08:33:10) Deploying SimpleStorage from Hardhat](https://youtu.be/gyMwXuJrbJQ?t=30790)_

## Networks in Hardhat

_[⌨️ (08:41:44) Networks in Hardhat](https://youtu.be/gyMwXuJrbJQ?t=31304)_

- [The Hardhat Network](https://hardhat.org/hardhat-network/)
- [Hardhat configuration](https://hardhat.org/config/#configuration)
- [Chain ID List](https://chainlist.org/)

## Programmatic Verification

_[⌨️ (08:51:16) Programmatic Verification](https://youtu.be/gyMwXuJrbJQ?t=31876)_

- [Etherscan Verify Tutorial](https://docs.etherscan.io/tutorials/verifying-contracts-programmatically)
- [Etherscan Docs](https://docs.etherscan.io/)
- [Hardhat-Etherscan](https://hardhat.org/plugins/nomiclabs-hardhat-etherscan.html)
- [Etherscan API Keys](https://info.etherscan.com/api-keys/)
- [Javascript == vs ===](https://stackoverflow.com/questions/359494/which-equals-operator-vs-should-be-used-in-javascript-comparisons)

## Interacting with Contracts in Hardhat

_[⌨️ (09:06:37) Interacting with Contracts in Hardhat](https://youtu.be/gyMwXuJrbJQ?t=32797)_

## Artifacts Troubleshooting

_[⌨️ (09:09:42) Artifacts Troubleshooting](https://youtu.be/gyMwXuJrbJQ?t=32982)_

## Custom Hardhat Tasks

_[⌨️ (09:10:52) Custom Hardhat Tasks](https://youtu.be/gyMwXuJrbJQ?t=33052)_

- [Hardhat Tasks](https://hardhat.org/guides/create-task.html)
- [Javascript Arrow Functions](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/Arrow_functions)

## Hardhat Localhost Node

_[⌨️ (09:18:12) Hardhat Localhost Node](https://youtu.be/gyMwXuJrbJQ?t=33492)_

## The Hardhat Console

_[⌨️ (09:23:11) The Hardhat Console](https://youtu.be/gyMwXuJrbJQ?t=33791)_

- [Hardhat Console](https://hardhat.org/guides/hardhat-console.html)

## Hardhat Tests

_[⌨️ (09:26:13) Hardhat Tests](https://youtu.be/gyMwXuJrbJQ?t=33973)_

- [Hardhat Tests](https://hardhat.org/tutorial/testing-contracts.html#_5-testing-contracts)
- [Mocha Style Tests](https://mochajs.org/)
- [Chai](https://www.npmjs.com/package/chai)
- [Waffle Tests](https://ethereum-waffle.readthedocs.io/en/latest/)

## Hardhat Gas Reporter

_[⌨️ (09:38:10) Hardhat Gas Reporter](https://youtu.be/gyMwXuJrbJQ?t=34690)_

- [Hardhat Gas Reporter](https://www.npmjs.com/package/hardhat-gas-reporter)
- [Coinmarketcap API](https://coinmarketcap.com/api/)

## Solidity Coverage

_[⌨️ (09:44:40) Solidity Coverage](https://youtu.be/gyMwXuJrbJQ?t=35080)_

- [Solidity Coverage](https://github.com/sc-forks/solidity-coverage)

## Hardhat Waffle

_[⌨️ (09:47:02) Hardhat Waffle](https://youtu.be/gyMwXuJrbJQ?t=35222)_

- [Hardhat-Waffle](https://npm.io/package/@nomiclabs/hardhat-waffle)

## Lesson 6 Recap

_[⌨️ (09:47:37) Lesson 6 Recap](https://youtu.be/gyMwXuJrbJQ?t=35257)_

### Typescript Hardhat Simple Storage

_[⌨️ (09:52:15) Typescript Hardhat Simple Storage](https://youtu.be/gyMwXuJrbJQ?t=35535)_

- [Typechain](https://github.com/dethcrypto/TypeChain)

```
yarn add --dev @typechain/ethers-v5 @typechain/hardhat @types/chai @types/node @types/mocha ts-node typechain typescript
```

# Lesson 7: Hardhat Fund Me

_[⌨️ (10:00:48) Lesson 7: Hardhat Fund Me](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=36048s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-fund-me-fcc

## Introduction

_[⌨️ (10:00:50) Introduction](https://youtu.be/gyMwXuJrbJQ?t=36050)_

## Hardhat Setup - Fund Me

_[⌨️ (10:03:41) Hardhat Setup - Fund Me](https://youtu.be/gyMwXuJrbJQ?t=36221)_

## Linting

_[⌨️ (10:06:20) Linting](https://youtu.be/gyMwXuJrbJQ?t=36380)_

- [Eslint](https://eslint.org/)
- [Solhint](https://github.com/protofire/solhint)
- [Linting Code](https://www.perforce.com/blog/qac/what-lint-code-and-why-linting-important)

## Hardhat Setup - Fund Me - Continued

_[⌨️ (10:07:47) Hardhat Setup - Fund Me - Continued](https://youtu.be/gyMwXuJrbJQ?t=36467)_

## Importing from NPM

_[⌨️ (10:09:38) Importing from NPM](https://youtu.be/gyMwXuJrbJQ?t=36578)_

- [@chainlink/contracts](https://www.npmjs.com/package/@chainlink/contracts)

## Hardhat Deploy

_[⌨️ (10:10:43) Hardhat Deploy](https://youtu.be/gyMwXuJrbJQ?t=36643)_

- [Hardhat Deploy](https://github.com/wighawag/hardhat-deploy)

## Mocking

_[⌨️ (10:21:05) Mocking](https://youtu.be/gyMwXuJrbJQ?t=37265)_

- [Mocking](https://stackoverflow.com/questions/2665812/what-is-mocking)
- [Aave Github](https://github.com/aave/aave-v3-core)
- [Chainlink Github](https://github.com/smartcontractkit/chainlink)
- Multiple Versions of Solidity
- Tags in hardhat

## Utils Folder

_[⌨️ (10:52:51) Utils Folder](https://youtu.be/gyMwXuJrbJQ?t=39171)_

## Testnet Demo - Hardhat Fund Me

_[⌨️ (10:55:45) Testnet Demo - Hardhat Fund Me](https://youtu.be/gyMwXuJrbJQ?t=39345)_

- Hardhat Deploy Block Confirmations

### TypeScript

- [Code file](https://github.com/PatrickAlphaC/hardhat-fund-me-fcc/blob/84271e7002e55d86c90b26466ff27bc067f25de0/deploy/01-deploy-fund-me.ts#L29) (TypeScript edition)
- Define blockConfirmations in the `helper-hardhat-config.ts` file instead of `hardhat-config.js`.

## Solidity Style Guide

_[⌨️ (11:00:10) Solidity Style Guide](https://youtu.be/gyMwXuJrbJQ?t=39610)_

- [Style Guide](https://docs.soliditylang.org/en/latest/style-guide.html)
- [NatSpec](https://docs.soliditylang.org/en/latest/natspec-format.html)

## Testing Fund Me

_[⌨️ (11:08:36) Testing Fund Me](https://youtu.be/gyMwXuJrbJQ?t=40116)_

- [Unit Testing](https://en.wikipedia.org/wiki/Unit_testing)
- [Hardhat Deploy Fixtures](https://github.com/wighawag/hardhat-deploy#creating-fixtures)
- [ethers.getContract](https://github.com/wighawag/hardhat-deploy-ethers)
- [expect](https://ethereum-waffle.readthedocs.io/en/latest/matchers.html)
- [ethers.utils.parseUnits](https://docs.ethers.io/v5/api/utils/display-logic/#utils-parseUnits)
- [Waffle Chai Matchers](https://ethereum-waffle.readthedocs.io/en/latest/matchers.html)

## Breakpoints & Debugging

_[⌨️ (11:30:39) Breakpoints & Debugging](https://youtu.be/gyMwXuJrbJQ?t=41439)_

- [VSCode Breakpoints](https://code.visualstudio.com/Docs/editor/debugging)

## Gas III

_[⌨️ (11:33:40) Gas III](https://youtu.be/gyMwXuJrbJQ?t=41620)_

- [Transaction Response](https://docs.ethers.io/v5/api/providers/types/#providers-TransactionResponse)
- [Transaction Receipt](https://docs.ethers.io/v5/api/providers/types/#providers-TransactionReceipt)

## console.log & Debugging

_[⌨️ (11:36:35) console.log & Debugging](https://youtu.be/gyMwXuJrbJQ?t=41795)_

- [Hardhat console.log](https://hardhat.org/hardhat-network/reference/#console-log)

## Testing Fund Me II

_[⌨️ (11:37:31) Testing Fund Me II](https://youtu.be/gyMwXuJrbJQ?t=41851)_

## Storage in Solidity

_[⌨️ (11:44:34) Storage in Solidity](https://youtu.be/gyMwXuJrbJQ?t=42274)_

- [Storage Layout](https://docs.soliditylang.org/en/latest/internals/layout_in_storage.html)
- [Purpose of the memory keyword](https://stackoverflow.com/questions/33839154/in-ethereum-solidity-what-is-the-purpose-of-the-memory-keyword)
- [getStorageAt](https://docs.ethers.io/v5/api/providers/provider/#Provider-getStorageAt)

## Gas Optimizations using Storage Knowledge

_[⌨️ (11:52:38) Gas Optimizations using Storage Knowledge](https://youtu.be/gyMwXuJrbJQ?t=42758)_

- [Opcodes](https://ethereum.org/en/developers/docs/evm/opcodes/)
- [Opcodes by Gas](https://github.com/crytic/evm-opcodes)
- [Opcodes by Gas](https://evm.codes/)
- Append `s_` to storage variables
- Append `i_` to immutable variables
- Caps lock and underscore constant variables

## Solidity Chainlink Style Guide

_[⌨️ (12:05:29) Solidity Chainlink Style Guide](https://youtu.be/gyMwXuJrbJQ?t=43529)_

- [Chainlink Solidity Style Guide](https://github.com/smartcontractkit/full-blockchain-solidity-course-js/issues/13)

## Storage Review

_[⌨️ (12:09:59) Storage Review](https://youtu.be/gyMwXuJrbJQ?t=43799)_

## Staging Tests

_[⌨️ (12:11:43) Staging Tests](https://youtu.be/gyMwXuJrbJQ?t=43903)_

- [Ternary](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Conditional_Operator)

## Running Scripts on a Local Node

_[⌨️ (12:17:58) Running Scripts on a Local Node](https://youtu.be/gyMwXuJrbJQ?t=44278)_

## Adding Scripts to your package.json

_[⌨️ (12:22:00) Adding Scripts to your package.json](https://youtu.be/gyMwXuJrbJQ?t=44520)_

## Pushing to GitHub

_[⌨️ (12:25:17) Pushing to GitHub](https://youtu.be/gyMwXuJrbJQ?t=44717)_

- [Github Quickstart](https://docs.github.com/en/get-started/quickstart)
- [What is Git?](https://www.git-scm.com/book/en/v2/Getting-Started-What-is-Git%3F)
- [The quickstart that we follow in the video](https://docs.github.com/en/get-started/importing-your-projects-to-github/importing-source-code-to-github/adding-locally-hosted-code-to-github#adding-a-local-repository-to-github-using-git)
- [Learn about git and GitHub](https://www.youtube.com/watch?v=RGOj5yH7evk)

## 🐸🐦 [Tweet Me (add your repo in)!](https://twitter.com/intent/tweet?text=I%20just%20made%20my%20first%20Smart%20Contract%20repo%20using%20@solidity_lang,%20@HardhatHQ,%20@chainlink,%20@AlchemyPlatform,%20and%20more!%0a%0aThanks%20@PatrickAlphaC!!)

# Lesson 8: HTML / Javascript Fund Me (Full Stack / Front End)

_[⌨️ (12:32:57) Lesson 8: HTML / Javascript Fund Me (Full Stack / Front End)](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=45177s)_

💻 Code: https://github.com/PatrickAlphaC/html-fund-me-fcc

## Introduction

## How Websites work with Web3 Wallets

- [How to Connect your Smart Contracts to Metamask](https://www.youtube.com/watch?v=pdsYCkUWrgQ)
  - 💻 Code from Video: https://github.com/PatrickAlphaC/full-stack-web3-metamask-connectors
  - ✍️ Article from Video: https://betterprogramming.pub/everything-you-need-to-know-about-fullstack-web3-94c0f1b18019?sk=a2764bcbdae98bf05e1052931de77982

## HTML Setup

- Live Server: ExtensionID: ritwickdey.LiveServer

## Connecting HTML to Metamask

- [Metamask Docs](https://docs.metamask.io/guide/)

## Javascript in it's own file

## ES6 vs Nodejs

- [ES6 vs Nodesjs](https://stackoverflow.com/questions/31354559/using-node-js-require-vs-es6-import-export#31367852)
- [Ethers docs for web browser](https://docs.ethers.io/v5/getting-started/#getting-started--importing--web-browser)
- [module vs text/javascript](https://stackoverflow.com/questions/51418964/script-type-text-javascript-vs-script-type-module)

## Sending a transaction from a Website

- [Web3Provider](https://docs.ethers.io/v5/api/providers/other/#Web3Provider)
- [Adding a network to metamask](https://metamask.zendesk.com/hc/en-us/articles/360043227612-How-to-add-a-custom-network-RPC)

## Resetting an Account in Metamask

```
MetaMask - RPC Error:
[ethjs-query] while formatting ouputs from RPC '{"value":{"code":-32603,"data":{"code":-32000,"message":"Nonce too high. Expected nonce to be 2 but got 4. Note that transactions can't be queued when automining."}}}'
```

## Listening for Events and Completed Transactions

- [provider.once](https://docs.ethers.io/v5/api/providers/provider/#Provider-once)
- [Anonymous function](https://www.geeksforgeeks.org/javascript-anonymous-functions/)
- [Javascript Promise](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise)

## Input Forms

## Reading from the Blockchain

## Withdraw Function

## Lesson 8 Recap

### Optional Links:

- [Browserify](https://browserify.org/)
- [Watchify](https://www.npmjs.com/package/watchify)

# Lesson 9: Hardhat Smart Contract Lottery

_[⌨️ (13:41:02) Lesson 9: Hardhat Smart Contract Lottery](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=49262s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-smartcontract-lottery-fcc

## Introduction

## Hardhat Setup - Smart Contract Lottery

_[⌨️ (13:43:43) Hardhat Setup](https://youtu.be/gyMwXuJrbJQ?t=49423)_

- Install dependencies:

```bash
yarn add --dev @nomiclabs/hardhat-ethers@npm:hardhat-deploy-ethers ethers @nomiclabs/hardhat-etherscan @nomiclabs/hardhat-waffle chai ethereum-waffle hardhat hardhat-contract-sizer hardhat-deploy hardhat-gas-reporter prettier prettier-plugin-solidity solhint solidity-coverage dotenv
```

- Install dependencies (Typescript version):

```bash
yarn add --dev @nomiclabs/hardhat-ethers@npm:hardhat-deploy-ethers ethers @nomiclabs/hardhat-etherscan @nomiclabs/hardhat-waffle chai ethereum-waffle hardhat hardhat-contract-sizer hardhat-deploy hardhat-gas-reporter prettier prettier-plugin-solidity solhint solidity-coverage dotenv @typechain/ethers-v5 @typechain/hardhat @types/chai @types/node ts-node typechain typescript
```

## Raffle.sol Setup

_[⌨️ (13:46:55) Raffle.sol Setup](https://youtu.be/gyMwXuJrbJQ?t=49615)_

- [Custom Errors in Solidity](https://blog.soliditylang.org/2021/04/21/custom-errors/)

## Introduction to Events

_[⌨️ (13:54:02) Introduction to Events](https://youtu.be/gyMwXuJrbJQ?t=50042)_

- [Events & Logging Video](https://www.youtube.com/watch?v=KDYJC85eS5M)
- [Events & Logging in Hardhat](https://github.com/PatrickAlphaC/hardhat-events-logs)

## Events in Raffle.sol

_[⌨️ (14:00:47) Events in Raffle.sol](https://youtu.be/gyMwXuJrbJQ?t=50447)_

## Introduction to Chainlink VRF

_[⌨️ (14:02:30) Introduction to Chainlink VRF](https://youtu.be/gyMwXuJrbJQ?t=50550)_

- [Special Guest Stephen Fluin](https://twitter.com/stephenfluin)

### Sub-Lesson: Chainlink VRF

> - [Chainlink VRFv2 Docs](https://docs.chain.link/docs/get-a-random-number/)
> - [Chainlink VRFv2 Walkthrough](https://www.youtube.com/watch?v=rdJ5d8j1RCg)
> - [Chainlink Contracts](https://github.com/smartcontractkit/chainlink/blob/develop/contracts/src/v0.8/VRFConsumerBase.sol)

## Implementing Chainlink VRF - Introduction

_[⌨️ (14:09:53) Implementing Chainlink VRF](https://youtu.be/gyMwXuJrbJQ?t=50993)_

### Hardhat Shorthand

- [Hardhat Shorthand](https://hardhat.org/guides/shorthand.html)

## Implementing Chainlink VRF - The Request

## Implementing Chainlink VRF - The FulFill

### Modulo

- [Modulo](https://docs.soliditylang.org/en/latest/types.html?highlight=modulo#modulo)

## Introduction to Chainlink Keepers

- [Chainlink Keepers Docs](https://docs.chain.link/docs/chainlink-keepers/introduction/)
- [Chainlink Keepers Walkthrough](https://www.youtube.com/watch?v=-Wkw5JVQGUo)

## Implementing Chainlink Keepers - checkUpkeep

### Enums

- [Enum](https://docs.soliditylang.org/en/latest/structure-of-a-contract.html?highlight=enum#enum-types)

## Implementing Chainlink Keepers - checkUpkeep continued

- block.timestamp

## Implementing Chainlink Keepers - performUpkeep

## Code Cleanup

## Deploying Raffle.sol

### Mock Chainlink VRF Coordinator

### Continued

- [LINK Token](https://docs.chain.link/docs/link-token-contracts/)

## Raffle.sol Unit Tests

- We use `async function` in the describe blocks at the start, but we correctly take them out later.

### Testing Events & Chai Matchers

- [Emit Chai Matcher](https://ethereum-waffle.readthedocs.io/en/latest/matchers.html#emitting-events)

### Continued I

## Hardhat Methods & Time Travel

- [Make Hardhat do whatever you want it to](https://hardhat.org/hardhat-network/reference/)
- [Special debugging hardhat methods](https://hardhat.org/hardhat-network/reference/#special-testing-debugging-methods)

### Continued II

## Callstatic

- [Callstatic](https://docs.ethers.io/v5/api/contract/contract/#contract-callStatic)

### Continued III

### Massive Promise Test

### Continued IV

## Raffle.sol Staging Tests

## Testing on a Testnet

### Recommended LINK amounts for Sepolia Staging Test:

- Chainlink VRF: 2 LINK
- Chainlink Keepers: 8 LINK

## Conclusion

## Typescript - Smart Contract Lottery

🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊 Completed Hardhat Basics! 🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊

# Lesson 10: NextJS Smart Contract Lottery (Full Stack / Front End)

_[⌨️ (16:34:07) Lesson 10: NextJS Smart Contract Lottery (Full Stack / Front End)](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=59647s)_

💻 Code: https://github.com/PatrickAlphaC/nextjs-smartcontract-lottery-fcc

⚡️⚡️ Live Demo IPFS: ipfs://QmXwACyjcS8tL7UkYwimpqMqW9sKzSHUjE4uSZBSyQVuEH

⚡️⚡️ Live Demo Fleek: https://fancy-dream-3458.on.fleek.co/

## Introduction

We move into using [NextJS](https://nextjs.org/) for our front end. NextJS is a [React framework](https://reactjs.org/) for building websites.

### Optional Sub-Lesson: Full Stack Development & Other Libraries

- [6 Ways to connect your dapp to a wallet](https://www.youtube.com/watch?v=pdsYCkUWrgQ)
- [NextJS Crash Course](https://www.youtube.com/watch?v=mTz0GXj8NN0)
- Other React libraries:
  - [Web3React](https://github.com/NoahZinsmeister/web3-react)
  - [wagmi](https://github.com/tmm/wagmi)
  - [react-moralis](https://www.npmjs.com/package/react-moralis)
  - [useDapp](https://github.com/TrueFiEng/useDApp)
  - [Web3Modal](https://github.com/Web3Modal/web3modal)
  - [useMetamask](https://github.com/mdtanrikulu/use-metamask)
- Other Full Stack Web3 Templates
  - [scaffold-eth](https://github.com/scaffold-eth/scaffold-eth)
  - [ethereum-boilerplate](https://github.com/ethereum-boilerplate/ethereum-boilerplate)
  - [create-eth-app](https://github.com/paulrberg/create-eth-app)
- [React being quite popular](https://insights.stackoverflow.com/survey/2021#section-most-popular-technologies-web-frameworks)
- [Why use react?](https://www.freecodecamp.org/news/why-use-react-for-web-development/)

## NextJS Setup

- [NextJS Documentation](https://nextjs.org/learn/basics/create-nextjs-app)
- [NextJS Minimal Ethers Example For Lottery](https://github.com/PatrickAlphaC/nextjs-ethers-introduction)

```
yarn create next-app .
```

## Manual Header I

- [What is a component?](https://www.w3schools.com/react/react_components.asp)
- [jsx](https://reactjs.org/docs/introducing-jsx.html)
- [Moralis](https://moralis.io/)
- [React Moralis](https://github.com/MoralisWeb3/react-moralis)

### React Hooks

- [What is a react hook?](https://reactjs.org/docs/hooks-overview.html)

## Manual Header II

## useEffect Hook

- [useEffect Hook](https://reactjs.org/docs/hooks-effect.html)
- [More on useEffect](https://blog.logrocket.com/guide-to-react-useeffect-hook/)
- [React Context](https://www.freecodecamp.org/news/react-context-for-beginners/)
  - [useEffect Firing Twice](https://stackoverflow.com/questions/60618844/react-hooks-useeffect-is-called-twice-even-if-an-empty-array-is-used-as-an-ar)

## Local Storage

- [Local Storage](https://codinglead.co/javascript/what-is-localstorage)

## isWeb3EnabledLoading

## web3uikit

- [web3uikit](https://github.com/web3ui/web3uikit)
- [web3uikit interactive docs](https://web3ui.github.io/web3uikit/?path=/story/1-web3-blockie--custom-seed)
- [web3uikit connect button](https://web3ui.github.io/web3uikit/?path=/story/1-web3-connectbutton--default)

## Introduction to Calling Functions in Nextjs

- [useWeb3Contract](https://github.com/MoralisWeb3/react-moralis#useweb3contract)

### Automatic Constant Value UI Updater

- [ethers.utils.FormatTypes](https://docs.ethers.io/v5/api/utils/abi/fragments/#fragments--formats)

### runContractFunction

- [Moralis Provider](https://github.com/MoralisWeb3/react-moralis#wrap-your-app-in-a-moralisprovider)
- [useMoralis](https://github.com/MoralisWeb3/react-moralis#usemoralis)
- [parseInt](https://www.w3schools.com/JSREF/jsref_parseint.asp)

## useState

- [useState Hook](https://reactjs.org/docs/hooks-state.html)

## Calling Functions in NextJS

## useNotification

- Add `onError` to all your `runContractFunction` calls

## Reading & Displaying Contract Data

## A Note about `onSuccess`

- `onSuccess` just checks to see if MetaMask sends the transaction, not

## A Challenge to You

## Tailwind & Styling

- [Learn CSS](https://www.w3schools.com/css/)
- [Tailwindcss](https://tailwindcss.com/)
- [PostCSS Extension](https://marketplace.visualstudio.com/items?itemName=csstools.postcss)
- [Tailwind Extension](https://marketplace.visualstudio.com/items?itemName=bradlc.vscode-tailwindcss)
- [Install Tailwind into NextJS](https://tailwindcss.com/docs/guides/nextjs)

## Introduction to Hosting your Site

_[⌨️ (18:12:50) Introdunction to Hosting your Site](https://youtu.be/gyMwXuJrbJQ?t=65570)_

- [Vercel](https://vercel.com/)
- [Moralis](https://moralis.io/)
- [Netilfy](https://www.netlify.com/)
- [IPFS](https://ipfs.io/)

## IPFS

_[⌨️ (18:15:14) IPFS](https://youtu.be/gyMwXuJrbJQ?t=65714)_

- [What is IPFS](https://www.youtube.com/watch?v=5Uj6uR3fp-U)
- [IPFS](https://ipfs.io/)

## Hosting on IPFS

_[⌨️ (18:18:51) Hosting on IPFS](https://youtu.be/gyMwXuJrbJQ?t=65931)_

- [IPFS Companion](https://chrome.google.com/webstore/detail/ipfs-companion/nibjojkomfdiaoajekhjakgkdhaomnch)
- [Brave Browser](https://brave.com/)
- `yarn build && yarn next export`

## Hosting on IPFS & Filecoin using Fleek

_[⌨️ (18:25:45) Hosting on IPFS & Filecoin using Fleek](https://youtu.be/gyMwXuJrbJQ?t=66345)_

- [Fleek](https://fleek.co/)

## Filecoin Overview

_[⌨️ (18:31:28) Filecoin Overview](https://youtu.be/gyMwXuJrbJQ?t=66688)_

- [Special Guest Ally Haire](https://twitter.com/DeveloperAlly)
- [IPFS URL of Ally's Video](ipfs://bafybeiasd6oxqiefoxgtskrokomexnb4zcq3fhwlcbyplx2paw65zmq2du)

## Lesson 10 Recap

# Lesson 11: Hardhat Starter Kit

_[⌨️ (18:51:36) Lesson 11: Hardhat Starter Kit](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=67896s)_

💻 Code: https://github.com/smartcontractkit/hardhat-starter-kit

# Lesson 12: Hardhat ERC20s

_[⌨️ (18:59:24) Lesson 12: Hardhat ERC20s](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=68364s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-erc20-fcc

## What is an ERC? What is an EIP?

- [What is an EIP?](https://eips.ethereum.org/)
- [EIPs codebase](https://github.com/ethereum/EIPs)

## What is an ERC20?

- [Video (using brownie/python)](https://youtu.be/8rpir_ZSK1g?t=39)
- [EIP-20](https://eips.ethereum.org/EIPS/eip-20)
- [ERC-677](https://github.com/ethereum/EIPs/issues/677)
- [EIP-777](https://eips.ethereum.org/EIPS/eip-777)

## Manually Creating an ERC20 Token

## Creating an ERC20 Token with Openzeppelin

- [Openzeppelin](https://openzeppelin.com/)
- [Openzeppelin Contracts](https://github.com/OpenZeppelin/openzeppelin-contracts)
- [Solmate (Openzeppelin alternative)](https://github.com/Rari-Capital/solmate)

## Lesson 12 Recap

# Lesson 13: Hardhat DeFi & Aave

_[⌨️ (19:16:13) Lesson 13: Hardhat DeFi & Aave](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=69373s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-defi-fcc

## What is DeFi?

- [What is DeFi?](https://chain.link/education/defi)
- [DefiLlama](https://defillama.com/)

## What is Aave?

- [Aave](https://aave.com/)
- [My Previous Aave Video on Shorting Assets](https://www.youtube.com/watch?v=TmNGAvI-RUA)

## Programmatic Borrowing & Lending

- [DAI](https://makerdao.com/en/)
- [Uniswap](https://app.uniswap.org/)

## WETH - Wrapped ETH

- [WETH Token Sepolia Etherscan](https://sepolia.etherscan.io/address/0xdd13E55209Fd76AfE204dBda4007C227904f0a81)
- [WETH Token Mainnet](https://etherscan.io/token/0xc02aaa39b223fe8d0a0e5c4f27ead9083c756cc2)

## Forking Mainnet

- [Mainnet Forking](https://hardhat.org/hardhat-network/guides/mainnet-forking.html)

## Depositing into Aave

- [Aave V2 Docs](https://docs.aave.com/developers/v/2.0/)
- [Aave NPM](https://www.npmjs.com/package/@aave/protocol-v2)

## Borrowing from Aave

- [Aave Borrowing FAQs](https://docs.aave.com/faq/borrowing)
- [Health Factor](https://docs.aave.com/faq/borrowing#what-is-the-health-factor)
- [Aave Risk Parameters](https://docs.aave.com/risk/asset-risk/risk-parameters)

## Repaying with Aave

## Visualizing the Transactions

- [aTokens](https://docs.aave.com/developers/v/1.0/developing-on-aave/the-protocol/atokens)

## Lesson 13 Recap

## Happy Bow-Tie Friday with Austin Griffith

- [Special Guest Austin Griffith](https://twitter.com/austingriffith)!
- [Speed Run Ethereum](https://speedrunethereum.com/)

### More DeFi Learnings:

- [Defi-Minimal](https://github.com/smartcontractkit/defi-minimal/tree/main/contracts)
- [Defi Dad](https://www.youtube.com/channel/UCatItl6C7wJp9txFMbXbSTg)

# Lesson 14: Hardhat NFTs (EVERYTHING you need to know about NFTs)

_[⌨️ (20:28:51) Lesson 14: Hardhat NFTs ](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=73731s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-nft-fcc

## What is an NFT?

- [Video](https://www.youtube.com/watch?v=9yuHz6g_P50)
- [Optional: All on Chain SVG NFT](https://www.youtube.com/watch?v=9oERTH9Bkw0)
- [EIP-721](https://eips.ethereum.org/EIPS/eip-721)

## Code Overview

- [Opensea Testnet](https://testnets.opensea.io/)

## Hardhat Setup

## Basic NFT

### Write Tests

- [Openzeppelin NFT](https://docs.openzeppelin.com/contracts/4.x/)

## Random IPFS NFT

### Mapping Chainlink VRF Requests

### Creating Rare NFTs

### Setting the NFT Image

### Setting an NFT Mint Price

### Deploy Script

### Uploading Token Images with Pinata

- [Pinata](https://pinata.cloud)
- [nft.storage](https://nft.storage)
- [Pinata NPM](https://www.npmjs.com/package/@pinata/sdk)
- [Pinata Docs](https://docs.pinata.cloud/)

### Uploading Token URIs (metadata) with Pinata

### Deploying

### Tests

## Dynamic SVG On-Chain NFT

- [Patrick's Original Video](https://www.youtube.com/watch?v=9oERTH9Bkw0)

### What is an SVG?

- [SVG Tutorial](https://www.w3schools.com/graphics/svg_intro.asp)
  - [On-Chain SVG Example](https://opensea.io/assets/matic/0x291ff90b9c410f56e047599bfee6b585c0c484d7/2)

### Initial Code

### Base64 Encoding

- [Base64 Encoding](https://en.wikipedia.org/wiki/Base64)
  - [Example Encoder](https://base64.guru/converter/encode/image/svg)
- [base64-sol](https://www.npmjs.com/package/base64-sol/v/1.0.1)

## Advanced: EVM Opcodes, Encoding, and Calling

### abi.encode & abi.encodePacked

- [abi.encode](https://docs.soliditylang.org/en/latest/cheatsheet.html?highlight=cheatsheet#global-variables)
- [abi.encodePacked](https://docs.soliditylang.org/en/latest/cheatsheet.html?highlight=cheatsheet#global-variables)
  Thanks to [Alex Roan](https://twitter.com/alexroan) for his help on this session!
- [Example Contract Creation Transaction](https://etherscan.io/tx/0x112133a0a74af775234c077c397c8b75850ceb61840b33b23ae06b753da40490)
  What REALLY is the ABI?
- [EVM Opcodes](https://www.evm.codes/)
- [More EVM Opcodes](https://github.com/crytic/evm-opcodes)
- [Solidity Cheatsheet](https://docs.soliditylang.org/en/latest/cheatsheet.html?highlight=encodewithsignature)
- [abi.encode vs abi.encodePacked](https://ethereum.stackexchange.com/questions/91826/why-are-there-two-methods-encoding-arguments-abi-encode-and-abi-encodepacked)

### Introduction to Encoding Function Calls Directly

### Introduction to Encoding Function Calls Recap

### Encoding Function Calls Directly

- [Function Selector](https://blog.openzeppelin.com/deconstructing-a-solidity-contract-part-iii-the-function-selector-6a9b6886ea49/)
- [Function Signature](https://twitter.com/PatrickAlphaC/status/1517156225670078465)

### Creating an NFT TokenURI on-Chain

### Making the NFT Dynamic

### Deploy Script

## Deploying the NFTs to a Testnet

## Lesson 14 Recap

Extra credit:

- [Deconstructing Solidity](https://blog.openzeppelin.com/deconstructing-a-solidity-contract-part-ii-creation-vs-runtime-6b9d60ecb44c/)
- [Knowing and controlling your Smart Contract Address](https://www.youtube.com/watch?v=56K0FdosZ8g)
- [From Solidity to byte code](https://www.youtube.com/watch?v=RxL_1AfV7N4)

# Lesson 15: NextJS NFT Marketplace (If you finish this lesson, you are a full-stack MONSTER!)

_[⌨️ (23:37:03) Lesson 15: NextJS NFT Marketplace (Full Stack / Front End)](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=85023s)_

## Large Update, please read

Moralis has recently updated to a self-hosted server over their own server. For this, you can do one of the following:

- [Learn how to run one yourself](https://www.youtube.com/watch?v=9GtysZs-FrA)
- Follow along to learn the concepts of this more interactive app, without actually coding along
- Skip to the section where we interact with the graph

TL;DR: TheGraph code should work exactly the same as the video, however the Moralis code will not.

💻 Code:

- Backend (Contracts): https://github.com/PatrickAlphaC/hardhat-nft-marketplace-fcc
- Frontend (Moralis Indexer): https://github.com/PatrickAlphaC/nextjs-nft-marketplace-moralis-fcc
- Frontend (TheGraph Indexer): https://github.com/PatrickAlphaC/nextjs-nft-marketplace-thegraph-fcc
  - The Graph: https://github.com/PatrickAlphaC/graph-nft-marketplace-fcc

Special thanks to [Matt Durkin](https://twitter.com/mdurkin92) for help with this section.

## Introduction

- [Opensea](https://opensea.io/)
- [Artion](https://github.com/Fantom-foundation/Artion-Contracts)

## Part I: NFT Marketplace Contracts

### Hardhat Setup

### NftMarketplace.sol

- [Pull Over Push](https://fravoll.github.io/solidity-patterns/pull_over_push.html)

## Reentrancy

- [Reentrancy](https://solidity-by-example.org/hacks/re-entrancy)
- [Rekt.news](https://rekt.news/leaderboard/)
- [Openzeppelin NonReentrant](https://docs.openzeppelin.com/contracts/4.x/api/security#ReentrancyGuard)

### NftMarketplace.sol - Continued

### NftMarketplace.sol - Deploy Script

### NftMarketplace.sol - Tests

### NftMarketplace.sol - Scripts

## Part II: Moralis Front End

### What is Moralis?

- [Special Guest Ivan Liljeqvist](https://twitter.com/IvanOnTech)

### NextJS Setup

- [Link NextJS](https://nextjs.org/docs/api-reference/next/link)

### Adding Tailwind

- [Tailwind with NextJS](https://tailwindcss.com/docs/guides/nextjs)

### Introduction to Indexing in Web3

- [TheGraph](https://thegraph.com/en/)
- [Moralis](https://moralis.io/)

### Connecting Moralis to our Local Hardhat Node

- [NextJS Environment Variables](https://nextjs.org/docs/basic-features/environment-variables)
- [Reverse Proxy FRP](https://github.com/fatedier/frp/releases)
  - [Docs](https://docs.moralis.io/moralis-dapp/web3/setting-up-ganache)
  - [Trouble Shooting](https://docs.moralis.io/faq#frpc)
- [Moralis Forum](https://forum.moralis.io/)
- [Moralis Admin CLI](https://docs.moralis.io/moralis-dapp/tools/moralis-admin-cli)

### Moralis Event Sync

- [Moralis Add Event Sync From Code](https://docs.moralis.io/moralis-dapp/connect-the-sdk/connect-using-node#add-new-event-sync-from-code)

#### Reset Local Chain

### Moralis Cloud Functions

- [Moralis Cloud Functions](https://docs.moralis.io/moralis-dapp/cloud-code/cloud-functions)
- [Moralis Logging](https://docs.moralis.io/moralis-dapp/tools/moralis-admin-cli#get-logs)
- [Hardhat Network Reference](https://hardhat.org/hardhat-network/reference/)
- Moralis Database only confirms a transaction with a block confirmation - so we need to move blocks on our hardhat local node.
- [Moralis Triggers](https://docs.moralis.io/moralis-dapp/cloud-code/triggers)

#### Practice Resetting the Local Chain

### Moralis Cloud Functions II

### Querying the Moralis Database

- [Moralis Queries](https://docs.moralis.io/moralis-dapp/database/queries)

### Rendering the NFT Images

- [useNFTBalance](https://github.com/MoralisWeb3/react-moralis#usenftbalances)
- [fetch](https://www.npmjs.com/package/node-fetch)
- [next/image](https://nextjs.org/docs/api-reference/next/image#loader-configuration)

### Update Listing Modal

### Buy NFT Listing

### Listing NFTs for Sale

- [web3uikit Form](https://web3uikit.com/)

## Part III: TheGraph Front End

### Introduction

### What is The Graph?

- [Special Guest Nader Dabit](https://twitter.com/dabit3)

### Building a Subgraph

- [Example Subgraphs](https://thegraph.com/explorer/)
- [The Graph Studio](https://thegraph.com/studio/)
- [GraphQL VSCode Extension](https://marketplace.visualstudio.com/items?itemName=GraphQL.vscode-graphql)
- [GraphQL](https://graphql.org/)

### Deploying our Subgraph

- [GraphQL Queries](https://www.tutorialspoint.com/graphql/graphql_query.htm)

### Reading from The Graph

- [@apollo/client](https://www.npmjs.com/package/@apollo/client)
- [gql](https://www.npmjs.com/package/gql)
- [The Graph Docs](https://thegraph.com/docs/en/)

### Hosting our Dapp

🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊 Completed Front End Basics! 🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊

# Lesson 16: Hardhat Upgrades

_[⌨️ (28:53:11) Lesson 16: Hardhat Upgrades](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=103991s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-upgrades-fcc

## Upgradable Smart Contracts Overview

- [Optional Video](https://www.youtube.com/watch?v=bdXJmWajZRY)
- [Links from Video]

## Types of Upgrades

1.  Parameter
2.  Social Migrate
3.  Proxy
    1.  Proxy Gotchas
        1. [Function Collisions](https://blog.openzeppelin.com/the-state-of-smart-contract-upgrades/#diamonds)
        2. [Storage Collisions](https://blog.openzeppelin.com/the-state-of-smart-contract-upgrades/#diamonds)
    2.  [Metamorphic Upgrades](https://github.com/PatrickAlphaC/hardhat-metamorphic-upgrades-fcc)
    3.  [Transparent](https://blog.openzeppelin.com/the-transparent-proxy-pattern/)
    4.  [UUPS](https://forum.openzeppelin.com/t/uups-proxies-tutorial-solidity-javascript/7786)
    5.  [Diamond](https://eips.ethereum.org/EIPS/eip-2535)

## Delegatecall

- [delegatecall (solidity-by-example)](https://solidity-by-example.org/delegatecall)
- [Yul](https://docs.soliditylang.org/en/latest/yul.html)

## Small Proxy Example

- [EIP 1967](https://eips.ethereum.org/EIPS/eip-1967)

## Transparent Upgradable Smart Contract

- [Hardhat-deploy Proxies](https://github.com/wighawag/hardhat-deploy#deploying-and-upgrading-proxies)
- [Openzeppelin Upgrades Plugin](https://docs.openzeppelin.com/upgrades-plugins/1.x/)
  - [Openzeppelin upgrades tutorial](https://forum.openzeppelin.com/t/openzeppelin-upgrades-step-by-step-tutorial-for-hardhat/3580)
- [hardhat deploy upgrades examples](https://github.com/wighawag/template-ethereum-contracts/tree/examples/openzeppelin-proxies/deploy)

# Lesson 17: Hardhat DAOs

_[⌨️ (29:45:24) Lesson 17: Hardhat DAOs](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=107124s)_

⬆️ Up-to-date code: https://github.com/PatrickAlphaC/dao-template

💻 Code from video: https://github.com/PatrickAlphaC/hardhat-dao-fcc

## Introduction

## What is a DAO?

- [What is a DAO?](https://www.youtube.com/watch?v=X_QKZzd68ro)

## How to build a DAO

- [How to build a DAO](https://www.youtube.com/watch?v=AhJtmUqhAqg)
- That's Patrick
- [PY Code](https://github.com/brownie-mix/dao-mix)
- [Python Video](https://www.youtube.com/watch?v=rD8AxZ_wBA4)
- [Openzeppelin Governance](https://docs.openzeppelin.com/contracts/4.x/api/governance)
- [Compound Governance](https://compound.finance/governance)
- [Contract Wizard](https://docs.openzeppelin.com/contracts/4.x/wizard)
- [CastVoteBySig](https://forum.openzeppelin.com/t/what-is-votecastbysig/17069/2)

# Lesson 18: Security & Auditing

_[⌨️ (31:28:32) Lesson 18: Security & Auditing ](https://www.youtube.com/watch?v=gyMwXuJrbJQ&t=113312s)_

💻 Code: https://github.com/PatrickAlphaC/hardhat-security-fcc

## Introduction

- [Readiness Guide](https://learn.openzeppelin.com/security-audits/readiness-guide)

## Slither

- [Install python](https://www.python.org/downloads/)
- [Slither](https://github.com/crytic/slither#how-to-install)
- [solc-select](https://github.com/crytic/solc-select)
- [Fuzz testing](https://en.wikipedia.org/wiki/Fuzzing)

## Fuzzing and Eth Security Toolbox

- [Echidna](https://github.com/crytic/echidna)
- [Docker Install](https://docs.docker.com/get-docker/)
- [Eth-Security-ToolBox](https://github.com/trailofbits/eth-security-toolbox)

## Closing Thoughts

- [Best Practices](https://consensys.github.io/smart-contract-best-practices/)
- [Attacks](https://consensys.github.io/smart-contract-best-practices/attacks/)
  - [Oracle Attacks](https://hackernoon.com/how-dollar100m-got-stolen-from-defi-in-2021-price-oracle-manipulation-and-flash-loan-attacks-explained-3n6q33r1)
  - [Re-entrancy Attacks](https://quantstamp.com/blog/what-is-a-re-entrancy-attack)
- [Damn Vulnerable Defi](https://www.damnvulnerabledefi.xyz/)
- [Ethernaut](https://ethernaut.openzeppelin.com/)
- Some Auditors:
  - [OpenZeppelin](https://openzeppelin.com/)
  - [SigmaPrime](https://sigmaprime.io/)
  - [Trail of Bits](https://www.trailofbits.com/)

# Congratulations

🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊 Completed The Course! 🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊🎊

## Where do I go now?

### Learning More

- [CryptoZombies](https://cryptozombies.io/)
- [Patrick Collins](https://www.youtube.com/channel/UCn-3f8tw_E1jZvhuHatROwA)
- [Dapp University](https://www.youtube.com/channel/UCY0xL8V6NzzFcwzHCgB8orQ)
- [ChainShot](https://www.chainshot.com/courses)
- [Cami Ramos Garzon](https://twitter.com/camiinthisthang)
- [Albert Hu](https://twitter.com/thatguyintech)
- [Ivan Liljeqvist](https://twitter.com/IvanOnTech)
- [Ally Haire](https://twitter.com/DeveloperAlly)
- [Stephen Fluin](https://twitter.com/stephenfluin)
- [Eat the Blocks](https://www.youtube.com/channel/UCZM8XQjNOyG2ElPpEUtNasA)
- [Austin Griffith](https://www.youtube.com/channel/UC_HI2i2peo1A-STdG22GFsA)
- [Nader Dabit](https://www.youtube.com/user/boyindasouth)
- [Ethereum.org](https://ethereum.org/en/)

### Community

- [Twitter](https://twitter.com/PatrickAlphaC)
- [Hardhat Discord](https://hardhat.org/discord)
- [Ethereum Python Community Discord](https://discord.gg/9zk7snTfWe)
- [Chainlink Discord](https://discord.gg/2YHSAey)
- [Ethereum Discord](https://ethereum.org/en/)
- [Reddit ethdev](https://www.reddit.com/r/ethdev/)

### Hackathons

- [CL Hackathon](https://chain.link/hackathon)
- [ETHGlobal](https://ethglobal.com/)
- [ETHIndia](https://ethindia.co/)

Be sure to check out project grant programs!

And make today an amazing day!

# Thank you

Thanks to everyone who is taking, participating in, and working on this course. It's been a passion project and a data dump of everything I've learnt in the web3 space to get you up to speed quickly. Also, a big thank you to Chainlink Labs for encouraging this course to come to light-and to the many Chainlink Labs team members who helped with various assets!

[![Patrick Collins Twitter](https://img.shields.io/badge/Twitter-1DA1F2?style=for-the-badge&logo=twitter&logoColor=white)](https://twitter.com/PatrickAlphaC)
[![Patrick Collins YouTube](https://img.shields.io/badge/YouTube-FF0000?style=for-the-badge&logo=youtube&logoColor=white)](https://www.youtube.com/channel/UCn-3f8tw_E1jZvhuHatROwA)
[![Patrick Collins Linkedin](https://img.shields.io/badge/LinkedIn-0077B5?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/patrickalphac/)
[![Patrick Collins Medium](https://img.shields.io/badge/Medium-000000?style=for-the-badge&logo=medium&logoColor=white)](https://medium.com/@patrick.collins_58673/)
