<?php declare(strict_types = 1);
//
// Generated by Smalldb\CodeCooker\Generator\DtoGenerator.
// Do NOT edit! All changes will be lost!
// 
// 
namespace Smalldb\StateMachine\Test\Example\User\UserData;

use InvalidArgumentException;
use Smalldb\CodeCooker\Annotation\GeneratedClass;
use Smalldb\StateMachine\Test\Example\User\UserProperties as Source_UserProperties;


/**
 * @GeneratedClass
 * @see \Smalldb\StateMachine\Test\Example\User\UserProperties
 */
class UserDataImmutable extends Source_UserProperties implements UserData
{

	public function __construct(?UserData $source = null)
	{
		if ($source !== null) {
			if ($source instanceof Source_UserProperties) {
				$this->id = $source->id;
				$this->username = $source->username;
				$this->password = $source->password;
				$this->roles = $source->roles;
				$this->fullName = $source->fullName;
				$this->email = $source->email;
			} else {
				$this->id = $source->getId();
				$this->username = $source->getUsername();
				$this->password = $source->getPassword();
				$this->roles = $source->getRoles();
				$this->fullName = $source->getFullName();
				$this->email = $source->getEmail();
			}
		}
	}


	public static function fromArray(?array $source, ?UserData $sourceObj = null): ?self
	{
		if ($source === null) {
			return null;
		}
		$t = $sourceObj instanceof self ? clone $sourceObj : new self($sourceObj);
		$t->id = isset($source['id']) ? (int) $source['id'] : null;
		$t->username = (string) $source['username'];
		$t->password = (string) $source['password'];
		$t->roles = is_string($source['roles']) ? json_decode($source['roles'], TRUE) : (array) $source['roles'];
		$t->fullName = (string) $source['fullName'];
		$t->email = (string) $source['email'];
		return $t;
	}


	public static function fromIterable(?UserData $sourceObj, iterable $source): self
	{
		$t = $sourceObj instanceof self ? clone $sourceObj : new self($sourceObj);
		foreach ($source as $prop => $value) {
			switch ($prop) {
				case 'id': $t->id = $value; break;
				case 'username': $t->username = $value; break;
				case 'password': $t->password = $value; break;
				case 'roles': $t->roles = $value; break;
				case 'fullName': $t->fullName = $value; break;
				case 'email': $t->email = $value; break;
				default: throw new InvalidArgumentException('Unknown property: "' . $prop . '" not in ' . __CLASS__);
			}
		}
		return $t;
	}


	public function getId(): ?int
	{
		return $this->id;
	}


	public function getUsername(): string
	{
		return $this->username;
	}


	public function getPassword(): string
	{
		return $this->password;
	}


	public function getRoles(): array
	{
		return $this->roles;
	}


	public function getFullName(): string
	{
		return $this->fullName;
	}


	public function getEmail(): string
	{
		return $this->email;
	}


	public static function get(UserData $source, string $propertyName)
	{
		switch ($propertyName) {
			case 'id': return $source->getId();
			case 'username': return $source->getUsername();
			case 'password': return $source->getPassword();
			case 'roles': return $source->getRoles();
			case 'fullName': return $source->getFullName();
			case 'email': return $source->getEmail();
			default: throw new \InvalidArgumentException("Unknown property: " . $propertyName);
		}
	}


	public function withId(?int $id): self
	{
		$t = clone $this;
		$t->id = $id;
		return $t;
	}


	public function withUsername(string $username): self
	{
		$t = clone $this;
		$t->username = $username;
		return $t;
	}


	public function withPassword(string $password): self
	{
		$t = clone $this;
		$t->password = $password;
		return $t;
	}


	public function withRoles(array $roles): self
	{
		$t = clone $this;
		$t->roles = $roles;
		return $t;
	}


	public function withFullName(string $fullName): self
	{
		$t = clone $this;
		$t->fullName = $fullName;
		return $t;
	}


	public function withEmail(string $email): self
	{
		$t = clone $this;
		$t->email = $email;
		return $t;
	}

}

