//
//  ESPAES.m
//  EspTouchDemo
//
//  Created by AE on 2018/4/5.
//

#import "ESPAES.h"
#import <CommonCrypto/CommonCryptor.h>

@implementation ESPAES

- (instancetype)initWithKey:(NSString *)secretKey {
    self = [super init];
    if (self) {
        key = secretKey;
    }
    return self;
}

- (NSData *)AES128EncryptData:(NSData *)data {
    char keyPtr[kCCKeySizeAES128 + 1];
    bzero(keyPtr, sizeof(keyPtr));
    [key getCString:keyPtr maxLength:sizeof(keyPtr) encoding:NSUTF8StringEncoding];
    NSUInteger dataLength = [data length];
    size_t bufferSize = dataLength + kCCBlockSizeAES128;
    void *buffer = malloc(bufferSize);
    size_t numBytesEncrypted = 0;
    CCCryptorStatus cryptStatus = CCCrypt(kCCEncrypt, kCCAlgorithmAES128,
        kCCOptionPKCS7Padding | kCCOptionECBMode,
        keyPtr, kCCBlockSizeAES128,
        NULL,
        [data bytes], dataLength,
        buffer, bufferSize,
        &numBytesEncrypted);
    if (cryptStatus == kCCSuccess) {
        return [NSData dataWithBytesNoCopy:buffer length:numBytesEncrypted];
    }
    free(buffer);
    return nil;
}

- (NSData *)AES128DecryptData:(NSData *)data {
    char keyPtr[kCCKeySizeAES128 + 1];
    bzero(keyPtr, sizeof(keyPtr));
    [key getCString:keyPtr maxLength:sizeof(keyPtr) encoding:NSUTF8StringEncoding];
    NSUInteger dataLength = [data length];
    size_t bufferSize = dataLength + kCCBlockSizeAES128;
    void *buffer = malloc(bufferSize);
    size_t numBytesDecrypted = 0;
    CCCryptorStatus cryptStatus = CCCrypt(kCCDecrypt, kCCAlgorithmAES128,
        kCCOptionPKCS7Padding | kCCOptionECBMode,
        keyPtr, kCCBlockSizeAES128,
        NULL,
        [data bytes], dataLength,
        buffer, bufferSize,
        &numBytesDecrypted);
    if (cryptStatus == kCCSuccess) {
        return [NSData dataWithBytesNoCopy:buffer length:numBytesDecrypted];
    }
    free(buffer);
    return nil;
}

@end
