<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: MIT -->

# Examples

These examples demonstrate the main features of Slint and how to use them in different language environments.



| Thumbnail  | Description | Example | 
| --- | --- | --- | 
| [Widget Gallery ![Gallery demo image](https://github.com/user-attachments/assets/e37ad016-475a-4c01-8d1b-1326ee7aa733 "Gallery demo image")](./gallery/) |  A simple application showing the different widgets. <br/> [Project...](./gallery) | [Wasm Demo](https://slint.dev/snapshots/master/demos/gallery/) |
| [Energy Meter![Energy meter demo image](https://github.com/user-attachments/assets/abfe03e3-ded6-4ddc-82b7-8303ee45515c "Energy meter demo image")](./energy-monitor/) |  A fictional user interface of a device that monitors energy consumption in a building. <br/> [Project...](./energy-monitor) | [Wasm Demo](https://slint.dev/snapshots/master/demos/energy-monitor/) |
| [Todo app![Todo demo image](https://github.com/user-attachments/assets/e534736b-3f64-4631-8b9a-80ccd985e9de "Todo demo image")](./todo/) |  A simple todo application. <br/> [Project...](./todo)<br><br>A simple todo application based on the [Model View Controller](https://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller) pattern. <br/> [Project...](./todo-mvc) | [Wasm Demo](https://slint.dev/snapshots/master/demos/todo/)<br><br>[Wasm MVC Demo](https://slint.dev/snapshots/master/demos/todo-mvc/)   |
| [Carousel![Carousel demo image](https://user-images.githubusercontent.com/6715107/196679740-840a4b67-afaa-4d47-9a31-bfe643c7de48.png "Carousel demo image")](./carousel/) |  A custom carousel widget that can be controlled by touch, mouse and keyboard. <br/> [Project...](./carousel) | [Wasm Demo](https://slint.dev/snapshots/master/demos/carousel/) |
| [Slide Puzzle![Slide Puzzle demo image](https://github.com/user-attachments/assets/c54d5d2d-5cce-41bf-a0d4-a94b94970df9 "Slide Puzzle demo image")](./slide_puzzle/) |  Puzzle game based on a Flutter example. <br/> [Project...](./slide_puzzle) | [Wasm Demo](https://slint.dev/snapshots/master/demos/slide_puzzle/) |
| [Memory Game![Memory demo image](https://github.com/user-attachments/assets/63216b63-2f9e-48c0-8efe-64cee9e91f07 "Memory demo image")](./memory/) |  A basic memory game used as an example the tutorial. <br/> [Project...](./memory) | [Wasm Demo](https://slint.dev/snapshots/master/demos/memory/) |
| [IOT Dashboard![iot dashboard demo image](https://slint.dev/resources/iot-dashboard_screenshot.png "iot dashboard demo image")](./iot-dashboard/) |  AA clone of one demo from the [QSkinny framework](https://qskinny.github.io/).<br/> Also shows how to dynamically load widgets from C++. <br/> [Project...](./iot-dashboard) |  |
| [Image Filter![Image filter demo image](https://github.com/user-attachments/assets/a373bc10-fa61-42c0-b80e-9d9f63cd022b "Image filter demo image")](./imagefilter/) |  A Rust-only example that shows how to use the Rust image crate to do image manipulationsand feed the result into Slint. <br/> [Project...](./imagefilter/) | [Wasm Demo](https://slint.dev/snapshots/master/demos/imagefilter/) |
| [Plotter![Plotter demo image](https://slint.dev/resources/plotter_screenshot.png "Plotter demo image")](./plotter/) | A Rust-only example that shows how to use the Rust plotters crate to do plot a graph and integrate the result into Slint. <br/> [Project...](./plotter/) | [Wasm Demo](https://slint.dev/snapshots/master/demos/plotter/) |
| [Using Bash![Bash demo image](https://github.com/user-attachments/assets/dcac4189-fc7b-4a9f-b7cb-9d075b338628 "Bash demo image")](./bash/) | Some examples of how to use the `slint-viewer` to add a GUI to shell scripts. <br/> [Project...](./bash/) |  |
| [OpenGL Underlay![OpenGL Underlay demo image](https://slint.dev/resources/opengl_underlay_screenshot.png "OpenGL Underlay demo image")](./opengl_underlay/) | A Rust and C++ example that shows how render Slint on top of graphical effect rendered using custom OpenGL code. <br/> [Project...](./opengl_underlay/) | [Wasm Demo](https://slint.dev/snapshots/master/demos/opengl_underlay/) |
| [OpenGL![OpenGL Texture demo image](https://github.com/slint-ui/slint/assets/1486/b9f1f6cf-3859-418e-9662-0c7170c3b1f2 "OpenGL Texture demo image")](./opengl_texture/) | A Rust and C++ example that shows how render a scene with custom OpenGL code into a texture and render that texture within a Slint scene. <br/> [Project...](./opengl_texture/) |  |
| [FFmpeg ![ffmpeg demo image](https://github.com/slint-ui/slint/assets/1486/5a1fad32-611a-478e-ab8f-576b4b4bdaf3 "ffmpeg demo image")](./ffmpeg/) | A Rust example that shows how render video frames with FFmpeg within a Slint scene.  <br/> [Project...](./ffmpeg/) |  |
| [Maps![Maps demo image](https://github.com/slint-ui/slint/assets/959326/f5e8cca6-dee1-4681-83da-88fec27f9a45 "OpenGL Underlay demo image")](./maps/) | A rust example that load image tiles asynchronously from OpenStreetMap server and allow panning and zooming. <br/> [Project...](./maps/) |  |
| [Virtual Keyboard![Virtual Keyboard demo image](https://user-images.githubusercontent.com/6715107/231668373-23faedf8-b42a-401d-b3a2-845d5e61252b.png "Virtual Keyboard demo image")](./virtual_keyboard/) | A Rust and C++ example that shows how to implement a custom virtual keyboard in Slint. <br/> [Project...](./virtual_keyboard/) |  |
| [7GUIs![7 GUI's demo image](https://user-images.githubusercontent.com/22800467/169002497-5b90e63b-5717-4290-8ac7-c618d9e2a4f1.png "7 GUI's demo image")](./7guis/) | Our implementations of the ["7GUIs"](https://7guis.github.io/7guis/) Tasks. <br/> [Project...](./7guis/) |  |

#### External examples
| Thumbnail  | Description |
| --- | --- |
| [Cargo UI![Cargo UI image](https://raw.githubusercontent.com/slint-ui/cargo-ui/master/screenshots/deptree.png "Cargo UI image")](https://github.com/slint-ui/cargo-ui) | A rust application that makes use of threads in the background. <br/> [Project...](https://github.com/slint-ui/cargo-ui) | 


---
### Loading the example with the `viewer`

Simply load the .slint file with the viewer application

```sh
cargo run --release --bin slint-viewer -- examples/gallery/gallery.slint
```

---
### Running the Rust Examples

You can run the examples either by going into folder or into the rust sub-folder and use `cargo run`, for example:

```sh
cd examples/gallery
cargo run --release
```

or you can run them from anywhere in the Cargo workspace by name:

```sh
cargo run --release --bin gallery
```

---
### Wasm builds

In order to make the wasm build of the example, you first need to edit the Cargo.toml
files to uncomment the line starting with `#wasm#` (or use the `sed` line bellow)
You can then use wasm-pack (which you may need to obtain with `cargo install wasm-pack`).
This will generate the wasm in the `./pkg` directory, which the `index.html` file will open.
Since wasm files cannot be served from `file://` URL, you need to open a wab server to serve
the content

```sh
cd examples/imagefilter/rust
sed -i "s/^#wasm# //" Cargo.toml
wasm-pack build --release --target web
python3 -m http.server
```

---
### Running the C++ Examples

* **When compiling Slint from sources:** If you follow the [C++ build instructions](/docs/building.md#c-build), this will build the C++
examples as well by default
* **From [installed binary packages](/api/cpp/README.md#binary-packages):** Simply run cmake in one of the example directory containing a CMakeLists.txt

 ```sh
 mkdir build && cd build
 cmake -GNinja -DCMAKE_PREFIX_PATH="<path to installed>" ..
 cmake --build .
 ```

---
### Running the Node Examples

You can run the examples by going into the node sub-folder and use [`pnpm`](https://pnpm.io), for example:

```sh
cd examples/todo/node
pnpm install
pnpm start
```
