<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: MIT -->

# Assets

## C++ SDK

For C++ developers, this release contains the following pre-packed builds of Slint:

| Desktop Operating System | Compiler | Architecture | Download |
|--------------------------|----------|--------------|----------|
| Linux                    | gcc      | x86-64       | [Slint-cpp-{download_version}-Linux-x86_64.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{download_version}-Linux-x86_64.tar.gz) |
| Windows                  | MSVC     | x86-64       | [Slint-cpp-{download_version}-win64-MSVC.exe](https://github.com/slint-ui/slint/releases/download/{download_version}/Slint-cpp-{download_version}-win64-MSVC.exe) |

| Templates for Microcontroller Evaluation Board | Download |
|----------------------------------|----------|
| [STM32H747I-DISCO](https://www.st.com/en/evaluation-tools/stm32h747i-disco.html): Dual-core Arm M7/M4 MCU with 4” touch LCD display module | [slint-cpp-template-stm32h747i-disco.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-cpp-template-stm32h747i-disco.zip) |
| [STM32H735G-DK](https://www.st.com/en/evaluation-tools/stm32h735g-dk.html): Arm M7 MCU with 4” touch LCD display module | [slint-cpp-template-stm32h735g-dk.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-cpp-template-stm32h735g-dk.zip) |

## Tool Binaries

| Add-on    | Linux x86-64 | Windows | macOS |
|-----------|--------------|---------|-------|
| **slint-lsp** | [slint-lsp-linux.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-linux.tar.gz) | [slint-lsp-windows.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-windows.zip) | [slint-lsp-macos.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-lsp-macos.tar.gz) |
| **slint-viewer** | [slint-viewer-linux.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-linux.tar.gz) | [slint-viewer-windows.zip](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-windows.zip) | [slint-viewer-macos.tar.gz](https://github.com/slint-ui/slint/releases/download/{download_version}/slint-viewer-macos.tar.gz) |
