<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: MIT -->
# Writing Style Guide

Use this style guide as a check list when reviewing / writing:

  - documentation
  - blog posts
  - posts on social media

## Objective

In our written communication we aim to be:

  - concise: It's common to skim through text these days.
  - easily understood: Simple terms, phrases, and words reach a wider audience.
  - informal: We're not a big corporation, we need to appear as a small, human company.

## Guidance

 1. Use contractions:
   Avoid: "We are proud to announce ..."
   Use: "We're proud to announce ..."
   Rationale: Makes for a conversational, human tone.

 2. Offer direct advice:
   - Avoid: "Please install XYZ ..."
   - Use: "Install XYZ"
   - Rational: The user is reading this to get instructions, there's no need to beat around the bush.
   
 3. Write actionable:
   - Avoid: "Element XYZ makes it possible to set the background color."
   - Use: "Use element XYZ to set the background color."
   - Rationale: Shorter, straight to the point.

 4. Don't shout.
   - Avoid: "Try out XYZ!"
   - Use: "Try out XYZ."
   - Rationale: Use exclamation points sparingly, save them for when they really count. We already have the attention of the reader.

## Docs

  - Ensure links don't go to blank pages e.g. [1.7 concepts](https://releases.slint.dev/1.7.0/docs/slint/src/language/concepts/)


## Tabs
The dev-platform tabs should be in the following order:
- Windows
- macOS
- Linux
