<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: MIT -->

# Security Policy

## Supported Versions

We commit to publishing security updates for the last release of Slint:

| Name | Description | URL |
| ---- | ----------- | --- |
| `slint` Rust crate | Rust crate for Slint API | https://crates.io/crates/slint |
| `slint-interpreter` Rust crate | Rust crate for Slint interpreter API | https://crates.io/crates/slint-interpreter |
| Slint for C++ | CMake package for Slint | https://github.com/slint-ui/slint/releases/latest |
| `slint-ui` NPM package | Node.js API for Slint | https://www.npmjs.com/package/slint-ui |
| `slint` Python Package | Python API for Slint | https://pypi.org/project/slint/ |
| Slint Visual Studio Code Extension | IDE Integration into VS Code | https://marketplace.visualstudio.com/items?itemName=Slint.slint |
| `slint-viewer` | Convenience tool to view `.slint` files from the command line | https://crates.io/crates/slint-viewer \| https://github.com/slint-ui/slint/releases/latest |
| `slint-lsp` | Language Server Protocol implementation for `.slint` files | https://crates.io/crates/slint-lsp \| https://github.com/slint-ui/slint/releases/latest |

Paid license holders may be eligible for support on additional versions, depending on their specific terms of
agreement.

## Reporting a Vulnerability

Please report any vulnerabilities via the GitHub Private Vulnerability Disclosure functionality.

Check out the [GitHub Instructions](https://docs.github.com/en/code-security/security-advisories/guidance-on-reporting-and-writing-information-about-vulnerabilities/privately-reporting-a-security-vulnerability#privately-reporting-a-security-vulnerability) on how to submit a report.

