<!-- Copyright © SixtyFPS GmbH <info@slint.dev> ; SPDX-License-Identifier: GPL-3.0-only OR LicenseRef-Slint-Royalty-free-2.0 OR LicenseRef-Slint-Software-3.0 -->

# Contributing

We warmly welcome contributions to the project. Let's discuss ideas or questions
in [Github discussions](https://github.com/slint-ui/slint/discussions).
Please feel welcome to open GitHub issues, pull requests, or comment for example
on [RFC tagged](https://github.com/slint-ui/slint/labels/rfc) issues.

Issues which we think are suitable for new contributors are tagged with
[good first issue](https://github.com/slint-ui/slint/labels/good%20first%20issue).

## Contributor License Agreement

All contributions are accepted under the terms of the MIT No Attribution License.
Please note that you must have written the contribution 100% yourself and that
no rights have been transferred to third parties (e.g. your employer).
In any other case, please let us know.

When opening a pull request, you will be asked to sign a
[Contributor License Agreement (CLA)](https://cla-assistant.io/slint-ui/slint).

## Internal documentation

 - [Development guide](docs/development.md)
 - [Building Slint from sources in this repository](docs/building.md)
 - [Testing](docs/testing.md)
 - [GitHub issues triage and labels](docs/triage.md)

## Coding Style

For the Rust portion of the code base, the CI enforce the coding style via rustfmt.
For the C++ portion of the code base, the CI enforce the coding style via `clang-format`.

