const CSSPageData: any = {
  description:
    "Cascading Style Sheets is a style sheet language used for describing the presentation of a document written in a markup language such as HTML. \n\nNo matter what kind of website or web application you want to build, you'll have to use CSS. If you haven't written much CSS, or even if you’ve never written CSS at all, don’t worry. That's what these courses are for. We’ll start with basic CSS concepts, then gradually progress to more advanced topics and lessons.",
  image:
    'https://res.cloudinary.com/dg3gyk0gu/image/upload/v1612886562/next.egghead.io/css/css-flexbox-illustration-by-maggie-appleton-on-egghead_2x.png',
  name: 'Curated: CSS Resources',
  resources: [
    {
      _id: '26f82ea7-5d61-465e-bdbb-526bd9162996',
      name: 'Curated: CSS by skill level',
      resources: [
        {
          _id: '099b01d5-f852-4d74-81a6-7e23e84527ab',
          name: 'Beginner',
          resources: [
            {
              _id: 'css-fundamentals',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/227/full/EGH_CSSFundamentals_Final.png',
              instructor: {
                image:
                  'https://d2eip9sf3oo6c2.cloudfront.net/instructors/avatars/000/000/167/medium/imageedit_5_6802843011.jpg',
                name: 'Tyler Clark',
                path: 'https://tylerclark.life/',
                slug: 'tyler-clark',
                title: 'instructor',
                twitter: 'https://twitter.com/iamtylerwclark',
              },
              path: '/courses/css-fundamentals',
              title: 'CSS Fundamentals',
            },
            {
              _id: 'style-an-application-from-start-to-finish',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/057/full/EGH_StyleCSSApp_Final.png',
              path: '/courses/style-an-application-from-start-to-finish',
              title: 'Style an Application from Start to Finish',
            },
            {
              _id: 'flexbox-fundamentals',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/036/full/EGH_Flexbox.png',
              path: '/courses/flexbox-fundamentals',
              title: 'Flexbox Fundamentals',
            },
            {
              _id: 'build-modern-layouts-with-css-grid-d3f5',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/playlists/square_covers/000/418/653/full/EGH_modern-layouts-css__1000.png',
              path: '/playlists/build-modern-layouts-with-css-grid-d3f5',
              title: 'Build Modern Layouts with CSS Grid',
            },
          ],
          slug: {
            _type: 'slug',
            current: 'beginner-css',
          },
          title: 'Beginner CSS',
        },
        {
          _id: '8e0f4575-29de-4224-aac5-f8becfa47f89',
          name: 'Intermediate',
          resources: [
            {
              _id: 'css-selectors-in-depth',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/235/full/EGH_CSSSelectors_Final.png',
              path: '/courses/css-selectors-in-depth',
              title: 'CSS Selectors in Depth',
            },
            {
              _id: 'optimize-user-experience-for-mobile-devices-and-browsers',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/151/full/EGH_OptimizeUXMobile_Final.png',
              path:
                '/courses/optimize-user-experience-for-mobile-devices-and-browsers',
              title: 'Optimize User Experience for Mobile Devices and Browsers',
            },
            {
              _id: 'learn-css-animations-for-a-better-user-experience-fbef',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/175/full/csslang.png',
              path:
                '/playlists/learn-css-animations-for-a-better-user-experience-fbef',
              title: 'Learn CSS Animations for a Better User Experience ',
            },
            {
              _id: 'css-tricks-698c',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/175/full/csslang.png',
              instructor: {
                image:
                  'https://d2eip9sf3oo6c2.cloudfront.net/instructors/avatars/000/000/416/medium/avatar-face.png',
                name: 'Jhey Tompkins',
                path: 'https://jhey.dev/',
                slug: 'resources-by-jhey-tompkins',
                title: 'instructor',
                twitter: 'https://twitter.com/jh3yy',
              },
              path: '/playlists/css-tips-and-tricks-930b',
              title: 'CSS Tips and Tricks',
            },
          ],
          slug: {
            _type: 'slug',
            current: 'intermediate-css',
          },
          title: 'Intermediate CSS',
        },
        {
          _id: '18473d30-8edb-49a1-a69b-65755844cde3',
          name: 'Advanced',
          resources: [
            {
              _id: 'learn-advanced-css-layout-techniques',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/081/full/EGH_Advanced_CSS_Layouts_Final.png',
              path: '/courses/learn-advanced-css-layout-techniques',
              title: 'Learn Advanced CSS Layout Techniques',
            },
            {
              _id: 'build-complex-layouts-with-css-grid-layout',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/107/full/EGH_CSS_Grids.png',
              path: '/courses/build-complex-layouts-with-css-grid-layout',
              title: 'Build Complex Layouts with CSS Grid Layout',
            },
            {
              _id: 'create-css-illustrations-b24c',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/175/full/csslang.png',
              path: '/playlists/create-css-illustrations-b24c',
              title: 'Use CSS to Create Art and Illustrations',
            },
            {
              _id: 'tic-tac-toe-with-css-and-svg-be02',
              image:
                'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/175/full/csslang.png',
              instructor: {
                image:
                  'https://d2eip9sf3oo6c2.cloudfront.net/instructors/avatars/000/000/416/medium/avatar-face.png',
                name: 'Jhey Tompkins',
                path: 'https://jhey.dev/',
                slug: 'resources-by-jhey-tompkins',
                title: 'instructor',
                twitter: 'https://twitter.com/jh3yy',
              },
              path: '/playlists/tic-tac-toe-with-css-and-svg-be02',
              title: 'Tic Tac Toe with CSS and SVG',
            },
          ],
          slug: {
            _type: 'slug',
            current: 'advanced-css',
          },
          title: 'Advanced CSS',
        },
      ],
      slug: {
        _type: 'slug',
        current: 'css-by-skill-level',
      },
      title: 'CSS by skill level',
      type: 'collection',
    },
    {
      _id: 'bb6d1123-74b8-409f-8979-cc8e83cd43a0',
      name: 'Curated: CSS Animation',
      resources: [
        {
          _id: 'animating-react-components-with-framer-motion-acecb152',
          image:
            'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/026/full/react.png',
          path:
            '/playlists/animating-react-components-with-framer-motion-acecb152',
          title: 'Animating React Components with Framer Motion',
        },
        {
          _id: 'create-amazing-animations-with-greensock',
          image:
            'https://d2eip9sf3oo6c2.cloudfront.net/series/square_covers/000/000/253/full/EGH_GreensockAnimation_Final.png',
          path: '/courses/create-amazing-animations-with-greensock',
          title: 'Create Amazing Animations with GreenSock',
        },
        {
          _id: 'spring-animation-in-react-with-react-spring-7bb9',
          image:
            'https://d2eip9sf3oo6c2.cloudfront.net/tags/images/000/000/026/full/react.png',
          path: '/playlists/spring-animation-in-react-with-react-spring-7bb9',
          title: 'Spring Animation in React with React Spring',
        },
      ],
      slug: {
        _type: 'slug',
        current: 'css-animation',
      },
      title: 'Animation',
      type: 'collection',
    },
  ],
  slug: {
    _type: 'slug',
    current: 'curated-css-resources',
  },
  title: 'CSS',
}

export default CSSPageData
