import * as React from 'react'

const ClosedCaptionIcon: React.FunctionComponent<
  React.PropsWithChildren<{className?: string}>
> = ({className}) => {
  return (
    <svg
      aria-labelledby="ccTitle"
      viewBox="0 0 122.88 114.83"
      fill="currentColor"
      className={className}
    >
      <title id="ccTitle">closed-captioning</title>
      <g>
        <path d="M25.5,57.01c0-2.51,0.42-4.97,1.26-7.4c0.84-2.43,2.07-4.61,3.68-6.54c1.61-1.93,3.57-3.49,5.87-4.68 c2.3-1.2,4.92-1.79,7.87-1.79c3.53,0,6.59,0.82,9.18,2.46c2.59,1.64,4.52,3.81,5.79,6.51l-7.67,6.13c-0.34-1-0.8-1.83-1.36-2.49 c-0.57-0.66-1.19-1.18-1.88-1.56c-0.69-0.39-1.4-0.66-2.14-0.81c-0.74-0.15-1.45-0.23-2.14-0.23c-1.44,0-2.68,0.32-3.73,0.95 c-1.05,0.64-1.9,1.46-2.57,2.49c-0.67,1.02-1.17,2.18-1.49,3.47c-0.33,1.29-0.49,2.57-0.49,3.85c0,1.43,0.19,2.8,0.57,4.11 c0.38,1.31,0.93,2.47,1.65,3.47c0.72,1,1.6,1.8,2.65,2.4c1.05,0.6,2.22,0.9,3.52,0.9c0.69,0,1.39-0.09,2.11-0.26 c0.72-0.17,1.42-0.46,2.08-0.87s1.27-0.93,1.8-1.56c0.53-0.64,0.95-1.42,1.26-2.34l8.18,5.49c-0.55,1.5-1.38,2.85-2.5,4.05 c-1.11,1.2-2.38,2.2-3.81,3.01c-1.42,0.81-2.95,1.43-4.58,1.85c-1.63,0.42-3.22,0.64-4.76,0.64c-2.71,0-5.19-0.61-7.43-1.82 c-2.25-1.21-4.18-2.82-5.81-4.83c-1.63-2-2.89-4.28-3.78-6.82C25.94,62.21,25.5,59.63,25.5,57.01L25.5,57.01L25.5,57.01z M15.77,0 h91.34c4.34,0,8.28,1.77,11.14,4.63s4.63,6.8,4.63,11.14v83.29c0,4.34-1.77,8.28-4.63,11.14c-2.86,2.86-6.8,4.63-11.14,4.63H15.77 c-4.34,0-8.28-1.77-11.14-4.63C1.77,107.34,0,103.4,0,99.06V15.77c0-4.34,1.77-8.29,4.63-11.14C7.48,1.77,11.43,0,15.77,0L15.77,0z M107.11,9.91H15.77c-1.61,0-3.07,0.66-4.13,1.72c-1.06,1.06-1.72,2.53-1.72,4.13v83.29c0,1.61,0.66,3.07,1.72,4.13 c1.06,1.06,2.53,1.72,4.13,1.72h91.34c1.61,0,3.07-0.66,4.13-1.72c1.06-1.06,1.72-2.53,1.72-4.13V15.77c0-1.61-0.66-3.07-1.72-4.13 C110.18,10.57,108.72,9.91,107.11,9.91L107.11,9.91z M63.38,57.01c0-2.51,0.42-4.97,1.26-7.4c0.84-2.43,2.07-4.61,3.68-6.54 c1.61-1.93,3.57-3.49,5.87-4.68c2.3-1.2,4.92-1.79,7.87-1.79c3.53,0,6.59,0.82,9.18,2.46c2.59,1.64,4.52,3.81,5.79,6.51l-7.67,6.13 c-0.34-1-0.8-1.83-1.36-2.49c-0.57-0.66-1.19-1.18-1.88-1.56c-0.69-0.39-1.4-0.66-2.14-0.81c-0.74-0.15-1.45-0.23-2.14-0.23 c-1.44,0-2.68,0.32-3.73,0.95c-1.05,0.64-1.9,1.46-2.57,2.49s-1.17,2.18-1.49,3.47c-0.33,1.29-0.49,2.57-0.49,3.85 c0,1.43,0.19,2.8,0.57,4.11c0.38,1.31,0.93,2.47,1.65,3.47c0.72,1,1.6,1.8,2.65,2.4c1.05,0.6,2.22,0.9,3.52,0.9 c0.69,0,1.39-0.09,2.11-0.26c0.72-0.17,1.41-0.46,2.08-0.87c0.67-0.4,1.27-0.93,1.8-1.56c0.53-0.64,0.95-1.42,1.26-2.34l8.18,5.49 c-0.55,1.5-1.38,2.85-2.5,4.05c-1.11,1.2-2.38,2.2-3.81,3.01c-1.42,0.81-2.95,1.43-4.58,1.85c-1.63,0.42-3.22,0.64-4.76,0.64 c-2.71,0-5.19-0.61-7.43-1.82c-2.25-1.21-4.18-2.82-5.81-4.83c-1.63-2-2.89-4.28-3.78-6.82C63.82,62.21,63.37,59.63,63.38,57.01 L63.38,57.01L63.38,57.01z" />
      </g>
    </svg>
  )
}

export default ClosedCaptionIcon
