import "package:morse_learn/models/models.dart";

extension StringExtension on String {
  List<MorseUnit> toMorseUnits() => _chatUnitsMap[toUpperCase()]!;
}

const Map<String, List<MorseUnit>> _chatUnitsMap = {
  "A": [MorseUnit.dot, MorseUnit.dash],
  "B": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dot, MorseUnit.dot],
  "C": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dash, MorseUnit.dot],
  "D": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dot],
  "E": [MorseUnit.dot],
  "F": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash, MorseUnit.dot],
  "G": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dot],
  "H": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dot, MorseUnit.dot],
  "I": [MorseUnit.dot, MorseUnit.dot],
  "J": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dash, MorseUnit.dash],
  "K": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dash],
  "L": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dot, MorseUnit.dot],
  "M": [MorseUnit.dash, MorseUnit.dash],
  "N": [MorseUnit.dash, MorseUnit.dot],
  "O": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash],
  "P": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dash, MorseUnit.dot],
  "Q": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dot, MorseUnit.dash],
  "R": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dot],
  "S": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dot],
  "T": [MorseUnit.dash],
  "U": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "V": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "W": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dash],
  "X": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "Y": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dash, MorseUnit.dash],
  "Z": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dot, MorseUnit.dot],

  "0": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "1": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "2": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "3": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "4": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
  ],
  "5": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "6": [
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "7": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "8": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "9": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
  ],

  "Å": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
  ],
  "Ä": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dot, MorseUnit.dash],
  "À": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
  ],
  "É": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "È": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
  ],
  "Ö": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash, MorseUnit.dot],
  "Ü": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash, MorseUnit.dash],
  "ß": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ñ": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "Ą": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dot, MorseUnit.dash],
  "Æ": [MorseUnit.dot, MorseUnit.dash, MorseUnit.dot, MorseUnit.dash],
  "Ć": [
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ĉ": [
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ç": [
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Đ": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ð": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
  ],
  "Ę": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ĝ": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
  ],
  "Ĥ": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash, MorseUnit.dash],
  "Ĵ": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
  ],
  "Ł": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
  ],
  "Ń": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
  ],
  "Ó": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash, MorseUnit.dot],
  "Ø": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash, MorseUnit.dot],
  "Ś": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ŝ": [
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
  ],
  "Š": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash, MorseUnit.dash],
  "Þ": [
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
  ],
  "Ŭ": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash, MorseUnit.dash],
  "Ź": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
    MorseUnit.dot,
  ],
  "Ż": [
    MorseUnit.dash,
    MorseUnit.dash,
    MorseUnit.dot,
    MorseUnit.dot,
    MorseUnit.dash,
  ],

  //these might be wrong
  "Á": [MorseUnit.dot, MorseUnit.dash],
  "Í": [MorseUnit.dot, MorseUnit.dot],
  "Ú": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "Â": [MorseUnit.dot, MorseUnit.dash],
  "Ê": [MorseUnit.dot],
  "Ë": [MorseUnit.dot],
  "Î": [MorseUnit.dot, MorseUnit.dot],
  "Ô": [MorseUnit.dash, MorseUnit.dash, MorseUnit.dash],
  "Û": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "Ù": [MorseUnit.dot, MorseUnit.dot, MorseUnit.dash],
  "Ÿ": [MorseUnit.dash, MorseUnit.dot, MorseUnit.dash, MorseUnit.dash],
  "Ï": [MorseUnit.dot, MorseUnit.dot],
  "Œ": [MorseUnit.dot],
};
