// Copyright © 2017, Che-Wei Hsu <cwxhsu@gmail.com>
// This file is part of the MintCM.
// Some rights reserved. See README.

#ifndef _MCM_RETURN_H_
#define _MCM_RETURN_H_




enum MCM_RETURN_CODE
{
    MCM_RCODE_PASS                      = 0,

    MCM_RCODE_COMMON_SHUTDOWN           = -1,

    MCM_RCODE_DAEMON_INTERNAL_ERROR     = -100,

    MCM_RCODE_CONFIG_INTERNAL_ERROR     = -200,
    MCM_RCODE_CONFIG_ALLOC_FAIL         = -201,
    MCM_RCODE_CONFIG_INVALID_PATH       = -202,
    MCM_RCODE_CONFIG_NOT_FIND_STORE     = -203,
    MCM_RCODE_CONFIG_INVALID_SIZE       = -204,
    MCM_RCODE_CONFIG_INVALID_MEMBER     = -205,
    MCM_RCODE_CONFIG_INVALID_STORE      = -206,
    MCM_RCODE_CONFIG_PERMISSION_DENY    = -207,
    MCM_RCODE_CONFIG_ACCESS_DENY        = -208,
    MCM_RCODE_CONFIG_DUPLIC_ENTRY       = -209,
    MCM_RCODE_CONFIG_TOO_MANY_ENTRY     = -210,

    MCM_RCODE_SERVICE_INTERNAL_ERROR    = -300,
    MCM_RCODE_SERVICE_ALLOC_FAIL        = -301,
    MCM_RCODE_SERVICE_INVALID_REQ       = -302,

    MCM_RCODE_ACTION_INTERNAL_ERROR     = -400,

    MCM_RCODE_LULIB_INTERNAL_ERROR      = -500,
    MCM_RCODE_LULIB_ALLOC_FAIL          = -501,
    MCM_RCODE_LULIB_SOCKET_ERROR        = -502,
    MCM_RCODE_LULIB_INTERRUPT           = -503,

    MCM_RCODE_LKLIB_INTERNAL_ERROR      = -600,
    MCM_RCODE_LKLIB_ALLOC_FAIL          = -601,
    MCM_RCODE_LKLIB_SOCKET_ERROR        = -602,

    MCM_RCODE_JSLIB_INTERNAL_ERROR      = -700,

    MCM_RCODE_CGI_CONFIG_INTERNAL_ERROR = -800,

    MCM_RCODE_CGI_UPLOAD_INTERNAL_ERROR = -900,

    MCM_RCODE_COMMAND_INTERNAL_ERROR    = -1000,

    MCM_RCODE_MCM_BOUNDARY              = -1100,

    MCM_RCODE_MODULE_INTERNAL_ERROR     = -3000
};




#endif
