# Semantic Segmentation Datasets

## General

* [COCO-Stuff](https://github.com/nightrome/cocostuff)
* [PASCAL-Context](https://cs.stanford.edu/~roozbeh/pascal-context/)
* [PASCAL-VOC](http://host.robots.ox.ac.uk/pascal/VOC/)
* [MSeg](https://github.com/mseg-dataset/mseg-api)
* [ADE20K](http://groups.csail.mit.edu/vision/datasets/ADE20K/)
* [Places365](http://places2.csail.mit.edu/)

## Outdoor

* [CityScapes](https://www.cityscapes-dataset.com/)
* [KITTI](http://www.cvlibs.net/datasets/kitti/)
* [Mapillary Vistas](https://www.mapillary.com/dataset/vistas?lat=20&lng=0&z=1.5&pKey=xyW6a0ZmrJtjLw2iJ71Oqg)
* [CamVid](http://mi.eng.cam.ac.uk/research/projects/VideoRec/CamVid/)
* [Standford Background](http://dags.stanford.edu/projects/scenedataset.html)
* [ApolloScape](http://apolloscape.auto/)
* [BDD100K](https://bdd-data.berkeley.edu/)
* [WoodScape](https://github.com/valeoai/WoodScape)
* [IDD](http://idd.insaan.iiit.ac.in/)
* [DADA-2000](https://github.com/JWFangit/LOTVS-DADA)
* [Street Hazards](https://github.com/hendrycks/anomaly-seg)
* [UNDD](https://github.com/sauradip/night_image_semantic_segmentation)
* [WildDash](https://wilddash.cc/)
* [A2D2](https://www.a2d2.audi/a2d2/en/dataset.html)

## Indoor

* [ScanNet](http://www.scan-net.org/)
* [Sun-RGBD](https://rgbd.cs.princeton.edu/)
* [SceneNet](https://robotvault.bitbucket.io/)
* [2D-3D-Semantics](https://github.com/alexsax/2D-3D-Semantics)
* [NYUDepthv2](https://cs.nyu.edu/~silberman/datasets/nyu_depth_v2.html)
* [SUN3D](http://sun3d.cs.princeton.edu/)

## Human Parts

* [LIP/CIHP](http://sysu-hcp.net/lip/index.php)
* [MHP](https://github.com/ZhaoJ9014/Multi-Human-Parsing)
* [DeepFashion2](https://github.com/switchablenorms/DeepFashion2)
* [PASCAL-Person-Part](http://roozbehm.info/pascal-parts/pascal-parts.html)
* [PIC](http://picdataset.com/challenge/task/download/)
* [iMat](https://github.com/visipedia/imat_comp)

## Food

* [FoodSeg103](https://xiongweiwu.github.io/foodseg103.html)

## Binary

* [SBCoseg](http://www.mlmrlab.com/cosegmentation_dataset_downloadC.html)
* [DeepFish](https://github.com/alzayats/DeepFish)
* [MVTecAD](https://www.mvtec.com/company/research/datasets/mvtec-ad/)
* [LLAMAS](https://unsupervised-llamas.com/llamas/)

## Boundary Segmentation

* [SBD](http://home.bharathh.info/pubs/codes/SBD/download.html)
* [SketchyScene](https://github.com/SketchyScene/SketchyScene)
* [TextSeg](https://github.com/SHI-Labs/Rethinking-Text-Segmentation)

## Synthetic

* [EDEN](https://lhoangan.github.io/eden/)
* [Synscapes](https://7dlabs.com/synscapes-overview)
* [SYNTHIA](https://synthia-dataset.net/)
* [GTA5](https://download.visinf.tu-darmstadt.de/data/from_games/)

## Robot-view

* [Robot Home](http://mapir.isa.uma.es/mapirwebsite/index.php/mapir-downloads/203-robot-at-home-dataset.html)
* [RobotriX](https://github.com/3dperceptionlab/therobotrix)
* [Gibson Env](http://gibsonenv.stanford.edu/)

## Medical

* [BraTS2015](https://www.smir.ch/BRATS/Start2015)
* [Medical-Decathlon](http://medicaldecathlon.com/)
* [PROMISE12](https://promise12.grand-challenge.org/)
* [REFUGE](https://bitbucket.org/woalsdnd/refuge/src/master/)
* [BIMCV-COVID-19](https://github.com/BIMCV-CSUSP/BIMCV-COVID-19)
* [OpenEDS](https://research.fb.com/programs/openeds-challenge)
* [Retinal-Microsurgery](https://sites.google.com/site/sznitr/home)
* [CoNSeP](https://warwick.ac.uk/fac/sci/dcs/research/tia/data/hovernet/)
* [ISIC-2018-Task1](https://challenge2018.isic-archive.com/task1/)
* [Cata7](https://github.com/nizhenliang/RAUNet)
* [ROSE](https://imed.nimte.ac.cn/dataofrose.html)
* [SegTHOR](https://competitions.codalab.org/competitions/21145)
* [CAMEL](https://github.com/ThoroughImages/CAMEL)
* [CryoNuSeg](https://github.com/masih4/CryoNuSeg)
* [OpenEDS2020](https://research.fb.com/programs/openeds-2020-challenge/)
* [VocalFolds](https://github.com/imesluh/vocalfolds)
* [Medico](https://multimediaeval.github.io/editions/2020/tasks/medico/)
* [20MioEyeDS](https://unitc-my.sharepoint.com/personal/iitfu01_cloud_uni-tuebingen_de/_layouts/15/onedrive.aspx?id=%2Fpersonal%2Fiitfu01%5Fcloud%5Funi%2Dtuebingen%5Fde%2FDocuments%2F20MioEyeDS&originalPath=aHR0cHM6Ly91bml0Yy1teS5zaGFyZXBvaW50LmNvbS86ZjovZy9wZXJzb25hbC9paXRmdTAxX2Nsb3VkX3VuaS10dWViaW5nZW5fZGUvRXZyTlBkdGlnRlZIdENNZUZLU3lMbFVCZXBPY2JYMG5Fa2Ftd2VlWmEwczlTUT9ydGltZT1zcWtvTV9CYzJVZw)
* [BrainMRI](https://www.kaggle.com/mateuszbuda/lgg-mri-segmentation)
* [Liver Tumor](https://www.kaggle.com/andrewmvd/liver-tumor-segmentation)
* [MRI Hippocampus](https://www.kaggle.com/sabermalek/mrihs)

## Aerial

* [RIT-18](https://github.com/rmkemker/RIT-18)
* [PolSF](https://github.com/liuxuvip/PolSF)
* [AIRS](https://www.airs-dataset.com/)
* [UOPNOA](https://zenodo.org/record/4648002)
* [LandCover](https://landcover.ai/)
* [ICG](https://www.kaggle.com/bulentsiyah/semantic-drone-dataset)

## Video

* [DAVIS](https://davischallenge.org/)
* [SESIV](https://sites.google.com/view/ltnghia/research/sesiv)
* [YouTube-VOS](https://youtube-vos.org/)

## Others

* [SUIM](http://irvlab.cs.umn.edu/resources/suim-dataset)
* [Cam2BEV](https://github.com/ika-rwth-aachen/Cam2BEV)
* [LabPics](https://www.kaggle.com/sagieppel/labpics-chemistry-labpics-medical)
* [CreativeFlow+](https://www.cs.toronto.edu/creativeflow/)
* [RoadAnomaly21](https://segmentmeifyoucan.com/datasets)
* [RoadObstacle21](https://segmentmeifyoucan.com/datasets)
* [HouseExpo](https://github.com/teaganli/houseexpo/)
* [D2S](https://www.mvtec.com/company/research/datasets/mvtec-d2s/)