using Silmoon.Extension;
using Silmoon.Extension.Models.Identities;
using Silmoon.Extension.Models.Identities.Enums;
using Silmoon.Models;
using Silmoon.Web.Extension;
using Silmoon.Web.Extensions;
using System;
using System.Security.Cryptography;
using System.Text;
using System.Web;
using System.Web.Mvc;

namespace Silmoon.Web
{
    public abstract class UserSessionManager<TUser> : System.Web.SessionState.IRequiresSessionState where TUser : IDefaultUserIdentity
    {
        RSACryptoServiceProvider rsa = null;
        string cookieDomain = null;
        DateTime cookieExpires = default;
        int sessionTimeout = 30;

        public int SessionTimeout
        {
            get
            {
                if (HttpContext.Current.Session != null)
                    sessionTimeout = HttpContext.Current.Session.Timeout;
                return sessionTimeout;
            }
            set
            {
                sessionTimeout = value;
                if (HttpContext.Current.Session != null)
                    HttpContext.Current.Session.Timeout = value;
            }
        }
        public event EventHandler UserLogin;
        public event EventHandler UserLogout;
        public event UserSessionHanlder OnRequestRefreshUserSession;
        public event UserTokenHanlder OnRequestUserToken;
        public event UserVerifyPermissionHandler OnVerifyUserPermission;

        public string Username
        {
            get
            {
                return User?.Username;
            }
        }
        public IdentityRole? Role
        {
            get
            {
                return User?.Role;
            }
        }
        //[Obsolete]
        public LoginState State
        {
            get
            {
                if (HttpContext.Current.Session["___silmoon_state"] != null)
                {
                    int.TryParse(HttpContext.Current.Session["___silmoon_state"].ToString(), out int result);
                    return (LoginState)result;
                }
                else return LoginState.None;
            }
            private set
            {
                HttpContext.Current.Session["___silmoon_state"] = (int)value;
            }
        }
        public TUser User
        {
            get
            {
                if (HttpContext.Current.Session["___silmoon_user"] != null)
                    return (TUser)HttpContext.Current.Session["___silmoon_user"];
                else return default;
            }
            private set { HttpContext.Current.Session["___silmoon_user"] = value; }
        }
        public bool IsSignin
        {
            get
            {
                return State == LoginState.Login;
            }
        }

        public RSACryptoServiceProvider RSACookiesCrypto
        {
            get { return rsa; }
            set { rsa = value; }
        }
        public string CookieDomain
        {
            get { return cookieDomain; }
            set { cookieDomain = value; }
        }
        public DateTime CookieExpires
        {
            get { return cookieExpires; }
            set { cookieExpires = value; }
        }

        public UserSessionManager() : this(null) { }
        public UserSessionManager(string cookieDomain)
        {
            this.cookieDomain = cookieDomain;
        }

        public bool GteRole(IdentityRole role)
        {
            var srule = Role;
            if (srule.HasValue)
                return srule >= role;
            else return false;
        }


        public object ReadSession(string key)
        {
            return HttpContext.Current.Session[key];
        }
        /// <summary>
        /// UserSessionĵ¼״̬
        /// û¼ὫʵֵViewBag.UserSessionûݸֵViewBag.User
        /// </summary>
        /// <param name="controller">controllernullԶתڵ¼״̬²ᣬûỰʵֵViewBag.UserSessionûݲḳֵViewBag.User</param>
        /// <param name="IsRole">IsRuleͬʱжûɫ</param>
        /// <param name="requestRefreshUserSession">TrueOnRequestRefreshUserSession¼»ȡûʵ</param>
        /// <param name="isAppApiRequest">жǷApiApi᷵RedirectΪApi󣬽Json</param>
        /// <param name="signInUrl">controllerȡûUserTokenȲûе¼ʹתָURL</param>
        /// <returns></returns>
        public ActionResult MvcSessionChecking(Controller controller, IdentityRole? IsRole, bool requestRefreshUserSession = false, bool isAppApiRequest = false, string signInUrl = "~/User/Signin?url=$SigninUrl")
        {
            controller.ViewBag.UserSession = this;
            signInUrl = signInUrl?.Replace("$SigninUrl", controller.Server.UrlEncode(controller.Request.RawUrl));
            var username = controller.Request.QueryString["Username"];
            var userToken = controller.Request.QueryString["UserToken"] ?? controller.Request.QueryString["AppUserToken"];
            var tokenNoSession = controller.Request.QueryString["TokenNoSession"].ToBool(false, false);
            var ignoreUserToken = controller.Request.QueryString["ignoreUserToken"].ToBool(false, false);

            if (!IsSignin || (!userToken.IsNullOrEmpty() && !ignoreUserToken))
            {
                //ûе¼UserTokenǿյĲҲUserToken
                if (userToken.IsNullOrEmpty() || userToken.ToLower() == "null")
                {
                    //ǵ¼״̬ûṩAppUserToken¡
                    if (controller.Request.IsAjaxRequest())
                        return new JsonResult { Data = StateFlag.Create(false, -9999, "no signin."), JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                    else return new RedirectResult(signInUrl);
                }
                else
                {
                    //UserToken¼֤̣ȡûʵ塣
                    var userInfo = OnRequestUserToken(username, userToken);
                    if (userInfo != null)
                    {
                        //AppUserToken̷֤ûʵ塣
                        User = userInfo;
                        if (!tokenNoSession) Signin(User);

                        //ʹUserToken¼
                        if (IsRole.HasValue && Role < IsRole)
                        {
                            if (controller.Request.IsAjaxRequest() || isAppApiRequest)
                                return new JsonResult { Data = StateFlag.Create(false, -9999, "access denied."), JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                            else return new ContentResult() { Content = "access denied", ContentType = "text/plain" };
                        }
                        controller.ViewBag.User = User;
                        return null;
                    }
                    else
                    {
                        if (controller.Request.IsAjaxRequest() || isAppApiRequest)
                            return new JsonResult { Data = StateFlag.Create(false, -9999, "OnRequestUserToken return null."), JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                        else
                        {
                            //һͻǰǵ¼״̬ʹAppUserToken¼AppUserToken¼ʧܣת¼ҳ棬ڵ¼״̬ٴصǰҳ棬ѭ
                            return new RedirectResult(signInUrl);
                        }
                    }
                }
            }
            else
            {
                if (requestRefreshUserSession)
                {
                    var userInfo = onRequestRefreshUserSession();
                    if (userInfo != null)
                        User = userInfo;
                    else
                    {
                        if (controller.Request.IsAjaxRequest() || isAppApiRequest)
                            return new JsonResult { Data = StateFlag.Create(false, -9999, "onRequestRefreshUserSession return null."), JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                        else return new RedirectResult(signInUrl);
                    }
                }

                if (IsRole.HasValue)
                {
                    if (Role < IsRole)
                    {
                        if (controller.Request.IsAjaxRequest() || isAppApiRequest)
                            return new JsonResult { Data = StateFlag.Create(false, -9999, "access denied."), JsonRequestBehavior = JsonRequestBehavior.AllowGet };
                        else return new ContentResult() { Content = "access denied", ContentType = "text/plain" };
                    }
                }

                controller.ViewBag.User = User;
                return null;
            }
        }
        public ActionResult VerifySession(Controller controller, IdentityRole? IsRole, bool isJsonRequest = false, bool requestRefreshUserSession = false, string signInUrl = "~/User/Signin?url=$SigninUrl")
        {
            controller.ViewBag.UserSession = this;
            signInUrl = signInUrl?.Replace("$SigninUrl", controller.Server.UrlEncode(controller.Request.RawUrl));

            if (IsSignin)
            {
                if (requestRefreshUserSession)
                {
                    User = onRequestRefreshUserSession();
                    if (User == null) return isJsonRequest ? controller.JsonStateFlag(false, -9999, "onRequestRefreshUserSession return null.") : (ActionResult)new RedirectResult(signInUrl);
                }
                if (IsRole.HasValue)
                {
                    if (Role < IsRole)
                    {
                        if (isJsonRequest)
                            return controller.JsonStateFlag(false, -9999, "Role permission denied.");
                        else return new ContentResult() { Content = "Ȩ޲㡣", ContentType = "text/plain" };
                    }
                }
                var check = OnVerifyUserPermission?.Invoke(User);
                if (check.HasValue && !check.Value)
                {
                    if (isJsonRequest)
                        return controller.JsonStateFlag(false, -9999, "OnVerifyUserPermission check permission fail.");
                    else return new ContentResult() { Content = "ԶȨ޲㡣", ContentType = "text/plain" };
                }
                controller.ViewBag.User = User;
                return null;
            }
            else
            {
                if (isJsonRequest)
                    return controller.JsonStateFlag(false, -9999, "No signin.");
                else return new RedirectResult(signInUrl);
            }
        }
        public ActionResult VerifySession(HttpContextBase httpContext, IdentityRole? IsRole, bool isJsonRequest = false, bool requestRefreshUserSession = false, string signInUrl = "~/User/Signin?url=$SigninUrl")
        {
            signInUrl = signInUrl?.Replace("$SigninUrl", httpContext.Server.UrlEncode(httpContext.Request.RawUrl));

            if (IsSignin)
            {
                if (requestRefreshUserSession)
                {
                    User = onRequestRefreshUserSession();
                    if (User == null) return new ContentResult() { Content = StateFlag.Create(false, -9999, "onRequestRefreshUserSession return null.").ToJsonString(), ContentType = "application/json" };
                }
                if (IsRole.HasValue)
                {
                    if (Role < IsRole)
                    {
                        if (isJsonRequest)
                            return new ContentResult() { Content = StateFlag.Create(false, -9999, "Role permission denied.").ToJsonString(), ContentType = "application/json" };
                        else return new ContentResult() { Content = "Ȩ޲㡣", ContentType = "text/plain" };
                    }
                }
                var check = OnVerifyUserPermission?.Invoke(User);
                if (check.HasValue && !check.Value)
                {
                    if (isJsonRequest)
                        return new ContentResult() { Content = StateFlag.Create(false, -9999, "OnVerifyUserPermission check permission fail.").ToJsonString(), ContentType = "application/json" };
                    else return new ContentResult() { Content = "ԶȨ޲㡣", ContentType = "text/plain" };
                }
                return null;
            }
            else
            {
                if (isJsonRequest)
                    return new ContentResult() { Content = StateFlag.Create(false, -9999, "No signin.").ToJsonString(), ContentType = "application/json" };
                else return new RedirectResult(signInUrl);
            }
        }

        public void WriteSession(string key, string value)
        {
            HttpContext.Current.Session.Timeout = sessionTimeout;
            HttpContext.Current.Session[key] = value;
        }

        public bool LoginFromCookie()
        {
            if (rsa == null) return false;
            if (HttpContext.Current.Request.Cookies["___silmoon_user_session"] != null && !string.IsNullOrEmpty(HttpContext.Current.Request.Cookies["___silmoon_user_session"].Value))
            {
                byte[] data = Convert.FromBase64String(HttpContext.Current.Request.Cookies["___silmoon_user_session"].Value);
                data = rsa.Decrypt(data, true);
                string username = Encoding.Default.GetString(data, 2, BitConverter.ToInt16(data, 0));
                string password = Encoding.Default.GetString(data, BitConverter.ToInt16(data, 0) + 4, data[BitConverter.ToInt16(data, 0) + 2]);
                return CookieRelogin(username, password);
            }
            else
            {
                return false;
            }
        }
        public bool LoginCrossLoginCookie()
        {
            if (rsa == null) return false;
            if (HttpContext.Current.Request.Cookies["___silmoon_cross_session"] != null && !string.IsNullOrEmpty(HttpContext.Current.Request.Cookies["___silmoon_cross_session"].Value))
            {
                byte[] data = Convert.FromBase64String(HttpContext.Current.Request.Cookies["___silmoon_cross_session"].Value);
                data = rsa.Decrypt(data, true);
                string username = Encoding.Default.GetString(data, 2, BitConverter.ToInt16(data, 0));
                string password = Encoding.Default.GetString(data, BitConverter.ToInt16(data, 0) + 4, data[BitConverter.ToInt16(data, 0) + 2]);
                bool result = CrossLogin(username, password);
                HttpContext.Current.Response.Cookies.Remove("___silmoon_cross_session");
                return result;
            }
            else
            {
                return false;
            }
        }
        public bool LoginFormToken(string token)
        {
            if (rsa == null) return false;
            byte[] data = Convert.FromBase64String(token);
            data = rsa.Decrypt(data, true);
            string username = Encoding.Default.GetString(data, 2, BitConverter.ToInt16(data, 0));
            string password = Encoding.Default.GetString(data, BitConverter.ToInt16(data, 0) + 4, data[BitConverter.ToInt16(data, 0) + 2]);
            bool result = TokenLogin(username, password);
            return result;
        }

        public virtual bool CookieRelogin(string username, string password)
        {
            return false;
        }
        public virtual bool CrossLogin(string username, string password)
        {
            return false;
        }
        public virtual bool TokenLogin(string username, string password)
        {
            return false;
        }

        public string GetUserToken()
        {
            if (rsa == null) return "";

            byte[] usernameData = Encoding.Default.GetBytes(User.Username);
            byte[] passwordData = Encoding.Default.GetBytes(User.Password);
            byte[] data = new byte[4 + usernameData.Length + passwordData.Length];

            Array.Copy(BitConverter.GetBytes((short)usernameData.Length), 0, data, 0, 2);
            Array.Copy(usernameData, 0, data, 2, usernameData.Length);
            Array.Copy(BitConverter.GetBytes((short)passwordData.Length), 0, data, usernameData.Length + 2, 2);
            Array.Copy(passwordData, 0, data, usernameData.Length + 4, passwordData.Length);

            data = rsa.Encrypt(data, true);
            return Convert.ToBase64String(data);
        }
        /// <summary>
        /// дһָʱڵġ___silmoon_user_sessionCookieԱ´Զ¼
        /// </summary>
        /// <param name="Expires">ʱ</param>
        public void WriteCookie(DateTime Expires = default(DateTime))
        {
            if (rsa != null)
            {
                if (Expires != default) cookieExpires = Expires;

                if (cookieDomain != null)
                    HttpContext.Current.Response.Cookies["___silmoon_user_session"].Domain = cookieDomain;

                if (CookieExpires != default(DateTime))
                    HttpContext.Current.Response.Cookies["___silmoon_user_session"].Expires = cookieExpires;

                HttpContext.Current.Response.Cookies["___silmoon_user_session"].Value = GetUserToken();
            }
        }
        public void WriteCrossLoginCookie(string domain = null)
        {
            if (rsa != null)
            {
                HttpContext.Current.Response.Cookies["___silmoon_cross_session"].Value = GetUserToken();
                if (!string.IsNullOrEmpty(domain))
                    HttpContext.Current.Response.Cookies["___silmoon_cross_session"].Domain = domain;
                HttpContext.Current.Response.Cookies["___silmoon_cross_session"].Expires = DateTime.Now.AddDays(1);
            }
        }

        public virtual void Signin(TUser user)
        {
            Signin(user.Username, user.Role, user);
        }
        public virtual void Signin(string username, TUser user)
        {
            Signin(username, user.Role, user);
        }
        public virtual void Signin(string username, IdentityRole role, TUser user = default)
        {
            HttpContext.Current.Session.Timeout = sessionTimeout;
            User = user;
            State = LoginState.Login;
            UserLogin?.Invoke(this, EventArgs.Empty);
        }
        public virtual void Signout()
        {
            State = LoginState.Logout;
            HttpContext.Current.Session.Remove("___silmoon_username");
            HttpContext.Current.Session.Remove("___silmoon_password");
            HttpContext.Current.Session.Remove("___silmoon_level");
            HttpContext.Current.Session.Remove("___silmoon_userflag");
            HttpContext.Current.Session.Remove("___silmoon_object");
            HttpContext.Current.Session.Remove("___silmoon_user");

            if (UserLogout != null) UserLogout(this, EventArgs.Empty);
        }

        public void ClearCrossCookie()
        {
            if (HttpContext.Current.Request.Cookies["___silmoon_cross_session"] != null)
            {
                if (cookieDomain != null)
                    HttpContext.Current.Response.Cookies["___silmoon_cross_session"].Domain = cookieDomain;
                HttpContext.Current.Response.Cookies["___silmoon_cross_session"].Expires = DateTime.Now.AddYears(-10);
            }
        }
        public void ClearUserCookie()
        {
            if (cookieDomain != null)
                HttpContext.Current.Response.Cookies["___silmoon_user_session"].Domain = cookieDomain;
            HttpContext.Current.Response.Cookies["___silmoon_user_session"].Expires = DateTime.Now.AddYears(-10);
        }
        public virtual void Clearup()
        {
            ClearUserCookie();
            ClearCrossCookie();
            Signout();
        }

        TUser onRequestRefreshUserSession()
        {
            if (OnRequestRefreshUserSession == null)
                return default(TUser);
            else
            {
                return OnRequestRefreshUserSession(User);
            }
        }
        public delegate TUser UserSessionHanlder(TUser User);
        public delegate TUser UserTokenHanlder(string Username, string UserToken);
        public delegate bool UserVerifyPermissionHandler(TUser User);
    }


    [Serializable]
    public enum LoginState
    {
        None = 0,
        Login = 1,
        Logout = -1,
    }
}