/**
 *  格式化文章發布時間
 */
 export default {
    customTime(item){
        let nowTime = new Date().getTime()
        let minuteTime = 60*1000
        let hourTime = 60*minuteTime
        let dayTime = 24*hourTime
        let monthTime = dayTime * 30
        let yearTime = monthTime * 12

        let publishTime = new Date(item).getTime()
        let historyTime = parseInt(nowTime) - parseInt(publishTime)
        let descTime
        if(historyTime >= yearTime){
          //按年算
          descTime = parseInt(historyTime/yearTime) + '年前'
        }else if(historyTime< yearTime && historyTime >= monthTime){
          //按月算
          descTime = parseInt(historyTime/monthTime) + '月前'
        }else if(historyTime< monthTime && historyTime>= dayTime){
          //按天算
          descTime = parseInt(historyTime/dayTime) + '天前'
        }else if(historyTime< dayTime && historyTime>= hourTime){
          //按小时算
          descTime = parseInt(historyTime/hourTime) + '小时前'
        }else if(historyTime< hourTime && historyTime>= minuteTime){
          //按分钟算
          descTime = parseInt(historyTime/minuteTime) + '分钟前'
        }else{
          descTime = '刚刚'
        }
        return descTime

    },
    formatDate(time){
      if (time ==null){
        return "未知时间";
      }
      let tmpDate = new Date(time)
      let year = tmpDate.getFullYear()
      let mathon = tmpDate.getMonth() + 1
      let day = tmpDate.getDate()
      let hours = tmpDate.getHours()
      let minutes = tmpDate.getMinutes()
      return year + '-' + mathon + '-' + day + ' ' + hours + ':' + minutes
    }
 }
