package com.sika.code.common.string.constant;

/**
 * 字符串常量类
 *
 * @author daiqi
 * @date 2018年2月25日 下午8:43:44
 */
public class StringConstant {

    /**
     * 符号字符串常量类
     *
     * @author daiqi
     * @date 2018年2月25日 下午8:44:33
     */
    public static class Symbol {
        /**
         * 符号---空格--- " "
         */
        public static final String SPACE = " ";
        /**
         * 符号---空串--- ""
         */
        public static final String EMPTY = "";
        /**
         * 符号---单and符号--- &
         */
        public static final String SINGLE_AND = "&";
        /**
         * 符号常量---英文冒号--- :
         */
        public static final String COLON = ":";
        /**
         * 符号常量---英文小于号--- <
         */
        public static final String LESS_THAN = "<";
        /**
         * 符号常量---英文大于号--- >
         */
        public static final String GREATER_THAN = ">";
        /**
         * 符号常量---英文正斜杠--- /
         */
        public static final String FORWARD_SLASH = "/";
        /**
         * 符号常量---英文反斜杠--- \\
         */
        public static final String BACK_SLASH = "\\";
        /**
         * 符号常量---英文下划线--- _
         */
        public static final String UNDER_LINE = "_";
        /**
         * 符号常量---英文句号--- .
         */
        public static final String STOP = ".";
        /**
         * 符号常量---英文等于号--- =
         */
        public static final String EQUAL = "=";
        /**
         * 符号常量---英文双引号--- "
         */
        public static final String DOUBLE_QUOTES = "\"";
        /**
         * 符号常量---英文左小括号--- (
         */
        public static final String LEFT_PARENTHESES = "(";
        /**
         * 符号常量---英文右小括号--- )
         */
        public static final String RIGHT_PARENTHESES = ")";
        /**
         * 符号常量---英文左大括号--- {
         */
        public static final String LEFT_BRACES = "{";
        /**
         * 符号常量---英文右大括号--- }
         */
        public static final String RIGHT_BRACES = "}";
        /**
         * 符号常量---英文逗号--- ,
         */
        public static final String COMMA = ",";
        /**
         * 符号常量---英文@--- @
         */
        public static final String AT = "@";
        /**
         * 符号常量---英文#--- #
         */
        public static final String NUMBER = "#";
        /**
         * 符号常量---英文?--- ?
         */
        public static final String QUESTION_MARK = "?";
        /**
         * 符号常量---英文中划线 --- -
         */
        public static final String LINE_THROUGH = "-";
    }
}
