# Window Switcher

Window-Switcher offers hotkeys for quickly switching windows on Windows OS:

1. ```Alt+`(Backtick)```: switch between windows of the same app.

![switch-windows](https://github.com/sigoden/window-switcher/assets/4012553/06d387ce-31fd-450b-adf3-01bfcfc4bce3)

2. ```Alt+Tab```: switch between apps. (disabled by default)

![switch-apps](https://github.com/sigoden/window-switcher/assets/4012553/0c74a7ca-3a48-4458-8d2d-b40dc041f067)

**💡 Hold down the `Alt` key and tap the ``` `(Backtick)/Tab ``` key to cycle through windows/apps, Press ```Alt + `(Backtick)/Tab``` and release both keys to switch to the last active window/app.**

## Installation

1. **Download:** Visit the [Github Release](https://github.com/sigoden/windows-switcher/releases) and download the `windows-switcher.zip` file.
2. **Extract:** Unzip the downloaded file and extract the `window-switcher.exe` to your preferred location.
3. **Launch:** `window-switcher.exe` is a standalone executable, no installation is required, just double-click the file to run it.

For the tech-savvy, here's a one-liner to automate the installation:
```ps1
iwr -useb https://raw.githubusercontent.com/sigoden/window-switcher/main/install.ps1 | iex
```

## Configuration

Window-Switcher offers various customization options to tailor its behavior to your preferences. You can define custom keyboard shortcuts, enable or disable specific features, and fine-tune settings through a configuration file.

To personalize Window-Switcher, you'll need a configuration file named `window-switcher.ini`. This file should be placed in the same directory as the `window-switcher.exe` file. Once you've made changes to the configuration, make sure to restart Window-Switcher so your new settings can take effect.

Here is the default configuration:

```ini
# Whether to show trayicon, yes/no
trayicon = yes 

[switch-windows]

# Hotkey to switch windows
hotkey = alt+`

# List of hotkey conflict apps
# e.g. game1.exe,game2.exe
blacklist =

# Ignore minimal windows
ignore_minimal = no

# Only switch within the current virtual desktops: yes/no/auto
only_current_desktop = auto

[switch-apps]

# Whether to enable switching apps
enable = no 

# Hotkey to switch apps
hotkey = alt+tab

# Ignore minimal windows
ignore_minimal = no

# Only switch apps within the current virtual desktops: yes/no/auto
only_current_desktop = auto
```

## Running as Administrator (Optional)

The window-switcher works in standard user mode. But only the window-switcher running in administrator mode can manage applications running in administrator mode.

**Important:** If you enable the startup option while running in standard user mode, it will launch in standard mode upon system reboot. To ensure startup with admin privileges, launch the window-switcher as administrator first before enabling startup.

<details>
<summary>

## Hotkeys for non-English keyboard layouts

When using non-English keyboard layouts, standard keycodes might not match the expected keys, leading to functionality issues with hotkeys. To ensure your hotkeys work correctly, follow these guidelines:

</summary>

1. **Visit kbdlayout.info**: Go to [http://kbdlayout.info/shortcut](http://kbdlayout.info/shortcut) and select your keyboard layout and desired keys. This will provide an image and detailed mapping.

![kbdlayout](https://github.com/user-attachments/assets/311c452a-d725-4853-adfe-097f63caf21a)

2. **Keycode Mapping**: Use the keycodes provided to correctly map your hotkeys. Here are some standard keycodes:

https://github.com/sigoden/window-switcher/blob/55f00463318971fca79204fe7a4eb9592f659881/src/config.rs#L227-L324

3. **Customizing for Language-Specific Keyboards**:

   - If your keyboard is in a language other than English, such as German, you may need to adjust the hotkeys. For example:
     - Original hotkey: ``` alt+` ```
     - Adjusted hotkey: `alt+|` or `alt+vk_oem_5`

4. **Test Your Hotkey Setup**: After configuring, test the hotkeys to ensure they perform the intended actions across different keyboard layouts.

By following these steps, you can adapt hotkeys for various non-English keyboard layouts, ensuring smooth functionality regardless of the language or region of your keyboard. 

</details>

## License

Copyright (c) 2023-2024 window-switcher developers.

window-switcher is made available under the terms of the MIT License, at your option.

See the LICENSE files for license details.
