/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.jmx.shaded.io.prometheus.client.hotspot;

import io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import io.prometheus.jmx.shaded.io.prometheus.client.GaugeMetricFamily;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MemoryPoolsExports
extends Collector {
    private final MemoryMXBean memoryBean;
    private final List<MemoryPoolMXBean> poolBeans;

    public MemoryPoolsExports() {
        this(ManagementFactory.getMemoryMXBean(), ManagementFactory.getMemoryPoolMXBeans());
    }

    public MemoryPoolsExports(MemoryMXBean memoryBean, List<MemoryPoolMXBean> poolBeans) {
        this.memoryBean = memoryBean;
        this.poolBeans = poolBeans;
    }

    void addMemoryAreaMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        MemoryUsage heapUsage = this.memoryBean.getHeapMemoryUsage();
        MemoryUsage nonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
        GaugeMetricFamily used = new GaugeMetricFamily("jvm_memory_bytes_used", "Used bytes of a given JVM memory area.", Collections.singletonList("area"));
        used.addMetric(Collections.singletonList("heap"), heapUsage.getUsed());
        used.addMetric(Collections.singletonList("nonheap"), nonHeapUsage.getUsed());
        sampleFamilies.add(used);
        GaugeMetricFamily committed = new GaugeMetricFamily("jvm_memory_bytes_committed", "Committed (bytes) of a given JVM memory area.", Collections.singletonList("area"));
        committed.addMetric(Collections.singletonList("heap"), heapUsage.getCommitted());
        committed.addMetric(Collections.singletonList("nonheap"), nonHeapUsage.getCommitted());
        sampleFamilies.add(committed);
        GaugeMetricFamily max = new GaugeMetricFamily("jvm_memory_bytes_max", "Max (bytes) of a given JVM memory area.", Collections.singletonList("area"));
        max.addMetric(Collections.singletonList("heap"), heapUsage.getMax());
        max.addMetric(Collections.singletonList("nonheap"), nonHeapUsage.getMax());
        sampleFamilies.add(max);
        GaugeMetricFamily init = new GaugeMetricFamily("jvm_memory_bytes_init", "Initial bytes of a given JVM memory area.", Collections.singletonList("area"));
        init.addMetric(Collections.singletonList("heap"), heapUsage.getInit());
        init.addMetric(Collections.singletonList("nonheap"), nonHeapUsage.getInit());
        sampleFamilies.add(init);
    }

    void addMemoryPoolMetrics(List<Collector.MetricFamilySamples> sampleFamilies) {
        GaugeMetricFamily used = new GaugeMetricFamily("jvm_memory_pool_bytes_used", "Used bytes of a given JVM memory pool.", Collections.singletonList("pool"));
        sampleFamilies.add(used);
        GaugeMetricFamily committed = new GaugeMetricFamily("jvm_memory_pool_bytes_committed", "Committed bytes of a given JVM memory pool.", Collections.singletonList("pool"));
        sampleFamilies.add(committed);
        GaugeMetricFamily max = new GaugeMetricFamily("jvm_memory_pool_bytes_max", "Max bytes of a given JVM memory pool.", Collections.singletonList("pool"));
        sampleFamilies.add(max);
        GaugeMetricFamily init = new GaugeMetricFamily("jvm_memory_pool_bytes_init", "Initial bytes of a given JVM memory pool.", Collections.singletonList("pool"));
        sampleFamilies.add(init);
        for (MemoryPoolMXBean pool : this.poolBeans) {
            MemoryUsage poolUsage = pool.getUsage();
            used.addMetric(Collections.singletonList(pool.getName()), poolUsage.getUsed());
            committed.addMetric(Collections.singletonList(pool.getName()), poolUsage.getCommitted());
            max.addMetric(Collections.singletonList(pool.getName()), poolUsage.getMax());
            init.addMetric(Collections.singletonList(pool.getName()), poolUsage.getInit());
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addMemoryAreaMetrics(mfs);
        this.addMemoryPoolMetrics(mfs);
        return mfs;
    }
}

