# Условная выборка

## Условная

Используйте `null` или передайте функцию в качестве `key` для условной выборки
данных. Если функция выводит ошибку или возвращает ложное значение, SWR не
отправляет запрос.

```js
// условная выборка
const { data } = useSWR(shouldFetch ? '/api/data' : null, fetcher)

// ...или вернуть ложное значение
const { data } = useSWR(() => (shouldFetch ? '/api/data' : null), fetcher)

// ...или вывести ошибку, если user.id не определен
const { data } = useSWR(() => '/api/data?uid=' + user.id, fetcher)
```

## Зависимая

SWR также позволяет получать данные, которые зависят от других данных. Это
обеспечивает максимально возможный параллелизм (избегая водопадов), а также
последовательную выборку, когда для следующей выборки данных требуется фрагмент
динамических данных.

```js
function MyProjects() {
  const { data: user } = useSWR('/api/user')
  const { data: projects } = useSWR(() => '/api/projects?uid=' + user.id)
  // При передаче функции SWR будет использовать возвращаемое значение
  // как `key`. Если функция выдает ошибку или возвращает ложь,
  // SWR будет знать, что некоторые зависимости не готовы.
  // В этом случае `user.id` выдает ошибку, когда `user` не загружен.

  if (!projects) return 'загрузка...'
  return 'У вас ' + projects.length + ' проектов'
}
```
