/* Mapbox GL JS is Copyright © 2020 Mapbox and subject to the Mapbox Terms of Service ((https://www.mapbox.com/legal/tos/). */
(function (global, factory) {
typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory() :
typeof define === 'function' && define.amd ? define(factory) :
(global = global || self, global.mapboxgl = factory());
}(this, (function () { 'use strict';

/* eslint-disable */

var shared, worker, mapboxgl;
// define gets called three times: one for each chunk. we rely on the order
// they're imported to know which is which
function define(_, chunk) {
if (!shared) {
    shared = chunk;
} else if (!worker) {
    worker = chunk;
} else {
    var workerBundleString = 'var sharedChunk = {}; (' + shared + ')(sharedChunk); (' + worker + ')(sharedChunk);'

    var sharedChunk = {};
    shared(sharedChunk);
    mapboxgl = chunk(sharedChunk);
    if (typeof window !== 'undefined') {
        mapboxgl.workerUrl = window.URL.createObjectURL(new Blob([workerBundleString], { type: 'text/javascript' }));
    }
}
}


define(["exports"],(function(t){"use strict";var e=r;function r(t,e,r,i){this.cx=3*t,this.bx=3*(r-t)-this.cx,this.ax=1-this.cx-this.bx,this.cy=3*e,this.by=3*(i-e)-this.cy,this.ay=1-this.cy-this.by,this.p1x=t,this.p1y=i,this.p2x=r,this.p2y=i;}r.prototype.sampleCurveX=function(t){return ((this.ax*t+this.bx)*t+this.cx)*t},r.prototype.sampleCurveY=function(t){return ((this.ay*t+this.by)*t+this.cy)*t},r.prototype.sampleCurveDerivativeX=function(t){return (3*this.ax*t+2*this.bx)*t+this.cx},r.prototype.solveCurveX=function(t,e){var r,i,n,s,a;for(void 0===e&&(e=1e-6),n=t,a=0;a<8;a++){if(s=this.sampleCurveX(n)-t,Math.abs(s)<e)return n;var o=this.sampleCurveDerivativeX(n);if(Math.abs(o)<1e-6)break;n-=s/o;}if((n=t)<(r=0))return r;if(n>(i=1))return i;for(;r<i;){if(s=this.sampleCurveX(n),Math.abs(s-t)<e)return n;t>s?r=n:i=n,n=.5*(i-r)+r;}return n},r.prototype.solve=function(t,e){return this.sampleCurveY(this.solveCurveX(t,e))};var i=n;function n(t,e){this.x=t,this.y=e;}n.prototype={clone:function(){return new n(this.x,this.y)},add:function(t){return this.clone()._add(t)},sub:function(t){return this.clone()._sub(t)},multByPoint:function(t){return this.clone()._multByPoint(t)},divByPoint:function(t){return this.clone()._divByPoint(t)},mult:function(t){return this.clone()._mult(t)},div:function(t){return this.clone()._div(t)},rotate:function(t){return this.clone()._rotate(t)},rotateAround:function(t,e){return this.clone()._rotateAround(t,e)},matMult:function(t){return this.clone()._matMult(t)},unit:function(){return this.clone()._unit()},perp:function(){return this.clone()._perp()},round:function(){return this.clone()._round()},mag:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},equals:function(t){return this.x===t.x&&this.y===t.y},dist:function(t){return Math.sqrt(this.distSqr(t))},distSqr:function(t){var e=t.x-this.x,r=t.y-this.y;return e*e+r*r},angle:function(){return Math.atan2(this.y,this.x)},angleTo:function(t){return Math.atan2(this.y-t.y,this.x-t.x)},angleWith:function(t){return this.angleWithSep(t.x,t.y)},angleWithSep:function(t,e){return Math.atan2(this.x*e-this.y*t,this.x*t+this.y*e)},_matMult:function(t){var e=t[2]*this.x+t[3]*this.y;return this.x=t[0]*this.x+t[1]*this.y,this.y=e,this},_add:function(t){return this.x+=t.x,this.y+=t.y,this},_sub:function(t){return this.x-=t.x,this.y-=t.y,this},_mult:function(t){return this.x*=t,this.y*=t,this},_div:function(t){return this.x/=t,this.y/=t,this},_multByPoint:function(t){return this.x*=t.x,this.y*=t.y,this},_divByPoint:function(t){return this.x/=t.x,this.y/=t.y,this},_unit:function(){return this._div(this.mag()),this},_perp:function(){var t=this.y;return this.y=this.x,this.x=-t,this},_rotate:function(t){var e=Math.cos(t),r=Math.sin(t),i=r*this.x+e*this.y;return this.x=e*this.x-r*this.y,this.y=i,this},_rotateAround:function(t,e){var r=Math.cos(t),i=Math.sin(t),n=e.y+i*(this.x-e.x)+r*(this.y-e.y);return this.x=e.x+r*(this.x-e.x)-i*(this.y-e.y),this.y=n,this},_round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this}},n.convert=function(t){return t instanceof n?t:Array.isArray(t)?new n(t[0],t[1]):t};var s="undefined"!=typeof self?self:{};function a(t,e){if(Array.isArray(t)){if(!Array.isArray(e)||t.length!==e.length)return !1;for(let r=0;r<t.length;r++)if(!a(t[r],e[r]))return !1;return !0}if("object"==typeof t&&null!==t&&null!==e){if("object"!=typeof e)return !1;if(Object.keys(t).length!==Object.keys(e).length)return !1;for(const r in t)if(!a(t[r],e[r]))return !1;return !0}return t===e}const o=Math.pow(2,53)-1,l=Math.PI/180,u=180/Math.PI;function c(t){return t*l}function h(t){if(t<=0)return 0;if(t>=1)return 1;const e=t*t,r=e*t;return 4*(t<.5?r:3*(t-e)+r-.75)}function p(t,r,i,n){const s=new e(t,r,i,n);return function(t){return s.solve(t)}}const d=p(.25,.1,.25,1);function f(t,e,r){return Math.min(r,Math.max(e,t))}function y(t,e,r){const i=r-e,n=((t-e)%i+i)%i+e;return n===e?r:n}function m(t,e,r){if(!t.length)return r(null,[]);let i=t.length;const n=new Array(t.length);let s=null;t.forEach((t,a)=>{e(t,(t,e)=>{t&&(s=t),n[a]=e,0==--i&&r(s,n);});});}function g(t){const e=[];for(const r in t)e.push(t[r]);return e}function x(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}let v=1;function b(){return v++}function w(){return function t(e){return e?(e^16*Math.random()>>e/4).toString(16):([1e7]+-[1e3]+-4e3+-8e3+-1e11).replace(/[018]/g,t)}()}function _(t){return !!t&&/^[0-9a-f]{8}-[0-9a-f]{4}-[4][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(t)}function k(t,e){t.forEach(t=>{e[t]&&(e[t]=e[t].bind(e));});}function A(t,e){return -1!==t.indexOf(e,t.length-e.length)}function S(t,e,r){const i={};for(const n in t)i[n]=e.call(r||this,t[n],n,t);return i}function I(t,e,r){const i={};for(const n in t)e.call(r||this,t[n],n,t)&&(i[n]=t[n]);return i}function T(t){return Array.isArray(t)?t.map(T):"object"==typeof t&&t?S(t,T):t}const z={};function E(t){z[t]||("undefined"!=typeof console&&console.warn(t),z[t]=!0);}function M(t,e,r){return (r.y-t.y)*(e.x-t.x)>(e.y-t.y)*(r.x-t.x)}function B(t){let e=0;for(let r,i,n=0,s=t.length,a=s-1;n<s;a=n++)r=t[n],i=t[a],e+=(i.x-r.x)*(r.y+i.y);return e}function D(){return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope}function C(t){const e={};if(t.replace(/(?:^|(?:\s*\,\s*))([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)(?:\=(?:([^\x00-\x20\(\)<>@\,;\:\\"\/\[\]\?\=\{\}\x7F]+)|(?:\"((?:[^"\\]|\\.)*)\")))?/g,(t,r,i,n)=>{const s=i||n;return e[r]=!s||s.toLowerCase(),""}),e["max-age"]){const t=parseInt(e["max-age"],10);isNaN(t)?delete e["max-age"]:e["max-age"]=t;}return e}let P,V,F=null;function R(t){if(null==F){const e=t.navigator?t.navigator.userAgent:null;F=!!t.safari||!(!e||!(/\b(iPad|iPhone|iPod)\b/.test(e)||e.match("Safari")&&!e.match("Chrome")));}return F}function L(t){try{const e=s[t];return e.setItem("_mapbox_test_",1),e.removeItem("_mapbox_test_"),!0}catch(t){return !1}}let U,O=!1;const $={now:()=>void 0!==U?U:s.performance.now(),setErrorState(){O=!0;},setNow(t){U=t;},restoreNow(){U=void 0;},frame(t){if(O)return {cancel:()=>{}};const e=s.requestAnimationFrame(t);return {cancel:()=>s.cancelAnimationFrame(e)}},getImageData(t,e=0){const r=s.document.createElement("canvas"),i=r.getContext("2d");if(!i)throw new Error("failed to create canvas 2d context");return r.width=t.width,r.height=t.height,i.drawImage(t,0,0,t.width,t.height),i.getImageData(-e,-e,t.width+2*e,t.height+2*e)},resolveURL:t=>(P||(P=s.document.createElement("a")),P.href=t,P.href),get devicePixelRatio(){return s.devicePixelRatio},get prefersReducedMotion(){return !!s.matchMedia&&(null==V&&(V=s.matchMedia("(prefers-reduced-motion: reduce)")),V.matches)}};let q;const N={API_URL:"https://api.mapbox.com",get API_URL_REGEX(){if(null==q){const t=/^((https?:)?\/\/)?([^\/]+\.)?mapbox\.c(n|om)(\/|\?|$)/i;try{q=null!=process.env.API_URL_REGEX?new RegExp(process.env.API_URL_REGEX):t;}catch(e){q=t;}}return q},get EVENTS_URL(){return this.API_URL?0===this.API_URL.indexOf("https://api.mapbox.cn")?"https://events.mapbox.cn/events/v2":0===this.API_URL.indexOf("https://api.mapbox.com")?"https://events.mapbox.com/events/v2":null:null},SESSION_PATH:"/map-sessions/v1",FEEDBACK_URL:"https://apps.mapbox.com/feedback",TILE_URL_VERSION:"v4",RASTER_URL_PREFIX:"raster/v1",REQUIRE_ACCESS_TOKEN:!0,ACCESS_TOKEN:null,MAX_PARALLEL_IMAGE_REQUESTS:16},j={supported:!1,testSupport:function(t){!X&&Z&&(K?H(t):G=t);}};let G,Z,X=!1,K=!1;function H(t){const e=t.createTexture();t.bindTexture(t.TEXTURE_2D,e);try{if(t.texImage2D(t.TEXTURE_2D,0,t.RGBA,t.RGBA,t.UNSIGNED_BYTE,Z),t.isContextLost())return;j.supported=!0;}catch(t){}t.deleteTexture(e),X=!0;}s.document&&(Z=s.document.createElement("img"),Z.onload=function(){G&&H(G),G=null,K=!0;},Z.onerror=function(){X=!0,G=null;},Z.src="data:image/webp;base64,UklGRh4AAABXRUJQVlA4TBEAAAAvAQAAAAfQ//73v/+BiOh/AAA=");const Y="01";function W(t){return 0===t.indexOf("mapbox:")}function J(t){return N.API_URL_REGEX.test(t)}const Q=/^(\w+):\/\/([^/?]*)(\/[^?]+)?\??(.+)?/;function tt(t){const e=t.match(Q);if(!e)throw new Error("Unable to parse URL object");return {protocol:e[1],authority:e[2],path:e[3]||"/",params:e[4]?e[4].split("&"):[]}}function et(t){const e=t.params.length?`?${t.params.join("&")}`:"";return `${t.protocol}://${t.authority}${t.path}${e}`}function rt(t){if(!t)return null;const e=t.split(".");if(!e||3!==e.length)return null;try{return JSON.parse(decodeURIComponent(s.atob(e[1]).split("").map(t=>"%"+("00"+t.charCodeAt(0).toString(16)).slice(-2)).join("")))}catch(t){return null}}class it{constructor(t){this.type=t,this.anonId=null,this.eventData={},this.queue=[],this.pendingRequest=null;}getStorageKey(t){const e=rt(N.ACCESS_TOKEN);let r="";return r=e&&e.u?s.btoa(encodeURIComponent(e.u).replace(/%([0-9A-F]{2})/g,(t,e)=>String.fromCharCode(Number("0x"+e)))):N.ACCESS_TOKEN||"",t?`mapbox.eventData.${t}:${r}`:`mapbox.eventData:${r}`}fetchEventData(){const t=L("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{const t=s.localStorage.getItem(e);t&&(this.eventData=JSON.parse(t));const i=s.localStorage.getItem(r);i&&(this.anonId=i);}catch(t){E("Unable to read from LocalStorage");}}saveEventData(){const t=L("localStorage"),e=this.getStorageKey(),r=this.getStorageKey("uuid");if(t)try{s.localStorage.setItem(r,this.anonId),Object.keys(this.eventData).length>=1&&s.localStorage.setItem(e,JSON.stringify(this.eventData));}catch(t){E("Unable to write to LocalStorage");}}processRequests(t){}postEvent(t,e,r,i){if(!N.EVENTS_URL)return;const n=tt(N.EVENTS_URL);n.params.push(`access_token=${i||N.ACCESS_TOKEN||""}`);const s={event:this.type,created:new Date(t).toISOString(),sdkIdentifier:"mapbox-gl-js",sdkVersion:"2.1.1",skuId:Y,userId:this.anonId},a=e?x(s,e):s,o={url:et(n),headers:{"Content-Type":"text/plain"},body:JSON.stringify([a])};this.pendingRequest=At(o,t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);});}queueRequest(t,e){this.queue.push(t),this.processRequests(e);}}const nt=new class extends it{constructor(t){super("appUserTurnstile"),this._customAccessToken=t;}postTurnstileEvent(t,e){N.EVENTS_URL&&N.ACCESS_TOKEN&&Array.isArray(t)&&t.some(t=>W(t)||J(t))&&this.queueRequest(Date.now(),e);}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;this.anonId&&this.eventData.lastSuccess&&this.eventData.tokenU||this.fetchEventData();const e=rt(N.ACCESS_TOKEN),r=e?e.u:N.ACCESS_TOKEN;let i=r!==this.eventData.tokenU;_(this.anonId)||(this.anonId=w(),i=!0);const n=this.queue.shift();if(this.eventData.lastSuccess){const t=new Date(this.eventData.lastSuccess),e=new Date(n),r=(n-this.eventData.lastSuccess)/864e5;i=i||r>=1||r<-1||t.getDate()!==e.getDate();}else i=!0;if(!i)return this.processRequests();this.postEvent(n,{"enabled.telemetry":!1},t=>{t||(this.eventData.lastSuccess=n,this.eventData.tokenU=r);},t);}},st=nt.postTurnstileEvent.bind(nt),at=new class extends it{constructor(){super("map.load"),this.success={},this.skuToken="";}postMapLoadEvent(t,e,r,i){this.skuToken=e,this.errorCb=i,N.EVENTS_URL&&(r||N.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error("A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/")));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||(this.anonId||this.fetchEventData(),_(this.anonId)||(this.anonId=w()),this.postEvent(r,{skuToken:this.skuToken},t=>{t?this.errorCb(t):e&&(this.success[e]=!0);},t));}},ot=at.postMapLoadEvent.bind(at),lt=new class extends it{constructor(){super("map.auth"),this.success={},this.skuToken="";}getSession(t,e,r,i){if(!N.API_URL||!N.SESSION_PATH)return;const n=tt(N.API_URL+N.SESSION_PATH);n.params.push(`sku=${e||""}`),n.params.push(`access_token=${i||N.ACCESS_TOKEN||""}`);const s={url:et(n),headers:{"Content-Type":"text/plain"}};this.pendingRequest=St(s,t=>{this.pendingRequest=null,r(t),this.saveEventData(),this.processRequests(i);});}getSessionAPI(t,e,r,i){this.skuToken=e,this.errorCb=i,N.SESSION_PATH&&N.API_URL&&(r||N.ACCESS_TOKEN?this.queueRequest({id:t,timestamp:Date.now()},r):this.errorCb(new Error("NO_ACCESS_TOKEN")));}processRequests(t){if(this.pendingRequest||0===this.queue.length)return;const{id:e,timestamp:r}=this.queue.shift();e&&this.success[e]||this.getSession(r,this.skuToken,t=>{t?this.errorCb(t):e&&(this.success[e]=!0);},t);}},ut=lt.getSessionAPI.bind(lt);let ct,ht,pt=500,dt=50;function ft(){s.caches&&!ct&&(ct=s.caches.open("mapbox-tiles"));}function yt(t){const e=t.indexOf("?");return e<0?t:t.slice(0,e)}let mt,gt=1/0;function xt(){return null==mt&&(mt=s.OffscreenCanvas&&new s.OffscreenCanvas(1,1).getContext("2d")&&"function"==typeof s.createImageBitmap),mt}const vt={Unknown:"Unknown",Style:"Style",Source:"Source",Tile:"Tile",Glyphs:"Glyphs",SpriteImage:"SpriteImage",SpriteJSON:"SpriteJSON",Image:"Image"};"function"==typeof Object.freeze&&Object.freeze(vt);class bt extends Error{constructor(t,e,r){401===e&&J(r)&&(t+=": you may have provided an invalid Mapbox access token. See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes"),super(t),this.status=e,this.url=r;}toString(){return `${this.name}: ${this.message} (${this.status}): ${this.url}`}}const wt=D()?()=>self.worker&&self.worker.referrer:()=>("blob:"===s.location.protocol?s.parent:s).location.href;const _t=function(t,e){if(!(/^file:/.test(r=t.url)||/^file:/.test(wt())&&!/^\w+:/.test(r))){if(s.fetch&&s.Request&&s.AbortController&&s.Request.prototype.hasOwnProperty("signal"))return function(t,e){const r=new s.AbortController,i=new s.Request(t.url,{method:t.method||"GET",body:t.body,credentials:t.credentials,headers:t.headers,referrer:wt(),signal:r.signal});let n=!1,a=!1;const o=(l=i.url).indexOf("sku=")>0&&J(l);var l;"json"===t.type&&i.headers.set("Accept","application/json");const u=(r,n,l)=>{if(a)return;if(r&&"SecurityError"!==r.message&&E(r),n&&l)return c(n);const u=Date.now();s.fetch(i).then(r=>{if(r.ok){const t=o?r.clone():null;return c(r,t,u)}return e(new bt(r.statusText,r.status,t.url))}).catch(t=>{20!==t.code&&e(new Error(t.message));});},c=(r,o,l)=>{("arrayBuffer"===t.type?r.arrayBuffer():"json"===t.type?r.json():r.text()).then(t=>{a||(o&&l&&function(t,e,r){if(ft(),!ct)return;const i={status:e.status,statusText:e.statusText,headers:new s.Headers};e.headers.forEach((t,e)=>i.headers.set(e,t));const n=C(e.headers.get("Cache-Control")||"");n["no-store"]||(n["max-age"]&&i.headers.set("Expires",new Date(r+1e3*n["max-age"]).toUTCString()),new Date(i.headers.get("Expires")).getTime()-r<42e4||function(t,e){if(void 0===ht)try{new Response(new ReadableStream),ht=!0;}catch(t){ht=!1;}ht?e(t.body):t.blob().then(e);}(e,e=>{const r=new s.Response(e,i);ft(),ct&&ct.then(e=>e.put(yt(t.url),r)).catch(t=>E(t.message));}));}(i,o,l),n=!0,e(null,t,r.headers.get("Cache-Control"),r.headers.get("Expires")));}).catch(t=>{a||e(new Error(t.message));});};return o?function(t,e){if(ft(),!ct)return e(null);const r=yt(t.url);ct.then(t=>{t.match(r).then(i=>{const n=function(t){if(!t)return !1;const e=new Date(t.headers.get("Expires")||0),r=C(t.headers.get("Cache-Control")||"");return e>Date.now()&&!r["no-cache"]}(i);t.delete(r),n&&t.put(r,i.clone()),e(null,i,n);}).catch(e);}).catch(e);}(i,u):u(null,null),{cancel:()=>{a=!0,n||r.abort();}}}(t,e);if(D()&&self.worker&&self.worker.actor)return self.worker.actor.send("getResource",t,e,void 0,!0)}var r;return function(t,e){const r=new s.XMLHttpRequest;r.open(t.method||"GET",t.url,!0),"arrayBuffer"===t.type&&(r.responseType="arraybuffer");for(const e in t.headers)r.setRequestHeader(e,t.headers[e]);return "json"===t.type&&(r.responseType="text",r.setRequestHeader("Accept","application/json")),r.withCredentials="include"===t.credentials,r.onerror=()=>{e(new Error(r.statusText));},r.onload=()=>{if((r.status>=200&&r.status<300||0===r.status)&&null!==r.response){let i=r.response;if("json"===t.type)try{i=JSON.parse(r.response);}catch(t){return e(t)}e(null,i,r.getResponseHeader("Cache-Control"),r.getResponseHeader("Expires"));}else e(new bt(r.statusText,r.status,t.url));},r.send(t.body),{cancel:()=>r.abort()}}(t,e)},kt=function(t,e){return _t(x(t,{type:"arrayBuffer"}),e)},At=function(t,e){return _t(x(t,{method:"POST"}),e)},St=function(t,e){return _t(x(t,{method:"GET"}),e)};function It(t){const e=s.document.createElement("a");return e.href=t,e.protocol===s.document.location.protocol&&e.host===s.document.location.host}const Tt="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAC0lEQVQYV2NgAAIAAAUAAarVyFEAAAAASUVORK5CYII=";let zt,Et;zt=[],Et=0;const Mt=function(t,e){if(j.supported&&(t.headers||(t.headers={}),t.headers.accept="image/webp,*/*"),Et>=N.MAX_PARALLEL_IMAGE_REQUESTS){const r={requestParameters:t,callback:e,cancelled:!1,cancel(){this.cancelled=!0;}};return zt.push(r),r}Et++;let r=!1;const i=()=>{if(!r)for(r=!0,Et--;zt.length&&Et<N.MAX_PARALLEL_IMAGE_REQUESTS;){const t=zt.shift(),{requestParameters:e,callback:r,cancelled:i}=t;i||(t.cancel=Mt(e,r).cancel);}},n=kt(t,(t,r,n,a)=>{i(),t?e(t):r&&(xt()?function(t,e){const r=new s.Blob([new Uint8Array(t)],{type:"image/png"});s.createImageBitmap(r).then(t=>{e(null,t);}).catch(t=>{e(new Error(`Could not load image because of ${t.message}. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported.`));});}(r,e):function(t,e,r,i){const n=new s.Image,a=s.URL;n.onload=()=>{e(null,n),a.revokeObjectURL(n.src),n.onload=null,s.requestAnimationFrame(()=>{n.src=Tt;});},n.onerror=()=>e(new Error("Could not load image. Please make sure to use a supported image type such as PNG or JPEG. Note that SVGs are not supported."));const o=new s.Blob([new Uint8Array(t)],{type:"image/png"});n.cacheControl=r,n.expires=i,n.src=t.byteLength?a.createObjectURL(o):Tt;}(r,e,n,a));});return {cancel:()=>{n.cancel(),i();}}};function Bt(t,e,r){r[t]&&-1!==r[t].indexOf(e)||(r[t]=r[t]||[],r[t].push(e));}function Dt(t,e,r){if(r&&r[t]){const i=r[t].indexOf(e);-1!==i&&r[t].splice(i,1);}}class Ct{constructor(t,e={}){x(this,e),this.type=t;}}class Pt extends Ct{constructor(t,e={}){super("error",x({error:t},e));}}class Vt{on(t,e){return this._listeners=this._listeners||{},Bt(t,e,this._listeners),this}off(t,e){return Dt(t,e,this._listeners),Dt(t,e,this._oneTimeListeners),this}once(t,e){return e?(this._oneTimeListeners=this._oneTimeListeners||{},Bt(t,e,this._oneTimeListeners),this):new Promise(e=>this.once(t,e))}fire(t,e){"string"==typeof t&&(t=new Ct(t,e||{}));const r=t.type;if(this.listens(r)){t.target=this;const e=this._listeners&&this._listeners[r]?this._listeners[r].slice():[];for(const r of e)r.call(this,t);const i=this._oneTimeListeners&&this._oneTimeListeners[r]?this._oneTimeListeners[r].slice():[];for(const e of i)Dt(r,e,this._oneTimeListeners),e.call(this,t);const n=this._eventedParent;n&&(x(t,"function"==typeof this._eventedParentData?this._eventedParentData():this._eventedParentData),n.fire(t));}else t instanceof Pt&&console.error(t.error);return this}listens(t){return !!(this._listeners&&this._listeners[t]&&this._listeners[t].length>0||this._oneTimeListeners&&this._oneTimeListeners[t]&&this._oneTimeListeners[t].length>0||this._eventedParent&&this._eventedParent.listens(t))}setEventedParent(t,e){return this._eventedParent=t,this._eventedParentData=e,this}}var Ft={$version:8,$root:{version:{required:!0,type:"enum",values:[8]},name:{type:"string"},metadata:{type:"*"},center:{type:"array",value:"number"},zoom:{type:"number"},bearing:{type:"number",default:0,period:360,units:"degrees"},pitch:{type:"number",default:0,units:"degrees"},light:{type:"light"},terrain:{type:"terrain"},sources:{required:!0,type:"sources"},sprite:{type:"string"},glyphs:{type:"string"},transition:{type:"transition"},layers:{required:!0,type:"array",value:"layer"}},sources:{"*":{type:"source"}},source:["source_vector","source_raster","source_raster_dem","source_geojson","source_video","source_image"],source_vector:{type:{required:!0,type:"enum",values:{vector:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},attribution:{type:"string"},promoteId:{type:"promoteId"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster:{type:{required:!0,type:"enum",values:{raster:{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},scheme:{type:"enum",values:{xyz:{},tms:{}},default:"xyz"},attribution:{type:"string"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_raster_dem:{type:{required:!0,type:"enum",values:{"raster-dem":{}}},url:{type:"string"},tiles:{type:"array",value:"string"},bounds:{type:"array",value:"number",length:4,default:[-180,-85.051129,180,85.051129]},minzoom:{type:"number",default:0},maxzoom:{type:"number",default:22},tileSize:{type:"number",default:512,units:"pixels"},attribution:{type:"string"},encoding:{type:"enum",values:{terrarium:{},mapbox:{}},default:"mapbox"},volatile:{type:"boolean",default:!1},"*":{type:"*"}},source_geojson:{type:{required:!0,type:"enum",values:{geojson:{}}},data:{type:"*"},maxzoom:{type:"number",default:18},attribution:{type:"string"},buffer:{type:"number",default:128,maximum:512,minimum:0},filter:{type:"*"},tolerance:{type:"number",default:.375},cluster:{type:"boolean",default:!1},clusterRadius:{type:"number",default:50,minimum:0},clusterMaxZoom:{type:"number"},clusterMinPoints:{type:"number"},clusterProperties:{type:"*"},lineMetrics:{type:"boolean",default:!1},generateId:{type:"boolean",default:!1},promoteId:{type:"promoteId"}},source_video:{type:{required:!0,type:"enum",values:{video:{}}},urls:{required:!0,type:"array",value:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},source_image:{type:{required:!0,type:"enum",values:{image:{}}},url:{required:!0,type:"string"},coordinates:{required:!0,type:"array",length:4,value:{type:"array",length:2,value:"number"}}},layer:{id:{type:"string",required:!0},type:{type:"enum",values:{fill:{},line:{},symbol:{},circle:{},heatmap:{},"fill-extrusion":{},raster:{},hillshade:{},background:{},sky:{}},required:!0},metadata:{type:"*"},source:{type:"string"},"source-layer":{type:"string"},minzoom:{type:"number",minimum:0,maximum:24},maxzoom:{type:"number",minimum:0,maximum:24},filter:{type:"filter"},layout:{type:"layout"},paint:{type:"paint"}},layout:["layout_fill","layout_line","layout_circle","layout_heatmap","layout_fill-extrusion","layout_symbol","layout_raster","layout_hillshade","layout_background","layout_sky"],layout_background:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_sky:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_fill:{"fill-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_circle:{"circle-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_heatmap:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},"layout_fill-extrusion":{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_line:{"line-cap":{type:"enum",values:{butt:{},round:{},square:{}},default:"butt",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-join":{type:"enum",values:{bevel:{},round:{},miter:{}},default:"miter",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"line-miter-limit":{type:"number",default:2,requires:[{"line-join":"miter"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-round-limit":{type:"number",default:1.05,requires:[{"line-join":"round"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_symbol:{"symbol-placement":{type:"enum",values:{point:{},line:{},"line-center":{}},default:"point",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-spacing":{type:"number",default:250,minimum:1,units:"pixels",requires:[{"symbol-placement":"line"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"symbol-avoid-edges":{type:"boolean",default:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"symbol-sort-key":{type:"number",expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"symbol-z-order":{type:"enum",values:{auto:{},"viewport-y":{},source:{}},default:"auto",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-allow-overlap":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-ignore-placement":{type:"boolean",default:!1,requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-optional":{type:"boolean",default:!1,requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-size":{type:"number",default:1,minimum:0,units:"factor of the original icon size",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-text-fit":{type:"enum",values:{none:{},width:{},height:{},both:{}},default:"none",requires:["icon-image","text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-text-fit-padding":{type:"array",value:"number",length:4,default:[0,0,0,0],units:"pixels",requires:["icon-image","text-field",{"icon-text-fit":["both","width","height"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-image":{type:"resolvedImage",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-keep-upright":{type:"boolean",default:!1,requires:["icon-image",{"icon-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"icon-offset":{type:"array",value:"number",length:2,default:[0,0],requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"icon-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-pitch-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotation-alignment":{type:"enum",values:{map:{},viewport:{},auto:{}},default:"auto",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-field":{type:"formatted",default:"",tokens:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-font":{type:"array",value:"string",default:["Open Sans Regular","Arial Unicode MS Regular"],requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-size":{type:"number",default:16,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-width":{type:"number",default:10,minimum:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-line-height":{type:"number",default:1.2,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-letter-spacing":{type:"number",default:0,units:"ems",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-justify":{type:"enum",values:{auto:{},left:{},center:{},right:{}},default:"center",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-radial-offset":{type:"number",units:"ems",default:0,requires:["text-field"],"property-type":"data-driven",expression:{interpolated:!0,parameters:["zoom","feature"]}},"text-variable-anchor":{type:"array",value:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-anchor":{type:"enum",values:{center:{},left:{},right:{},top:{},bottom:{},"top-left":{},"top-right":{},"bottom-left":{},"bottom-right":{}},default:"center",requires:["text-field",{"!":"text-variable-anchor"}],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-max-angle":{type:"number",default:45,units:"degrees",requires:["text-field",{"symbol-placement":["line","line-center"]}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-writing-mode":{type:"array",value:"enum",values:{horizontal:{},vertical:{}},requires:["text-field",{"symbol-placement":["point"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-rotate":{type:"number",default:0,period:360,units:"degrees",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-padding":{type:"number",default:2,minimum:0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-keep-upright":{type:"boolean",default:!0,requires:["text-field",{"text-rotation-alignment":"map"},{"symbol-placement":["line","line-center"]}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-transform":{type:"enum",values:{none:{},uppercase:{},lowercase:{}},default:"none",requires:["text-field"],expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-offset":{type:"array",value:"number",units:"ems",length:2,default:[0,0],requires:["text-field",{"!":"text-radial-offset"}],expression:{interpolated:!0,parameters:["zoom","feature"]},"property-type":"data-driven"},"text-allow-overlap":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-ignore-placement":{type:"boolean",default:!1,requires:["text-field"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-optional":{type:"boolean",default:!1,requires:["text-field","icon-image"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_raster:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},layout_hillshade:{visibility:{type:"enum",values:{visible:{},none:{}},default:"visible","property-type":"constant"}},filter:{type:"array",value:"*"},filter_operator:{type:"enum",values:{"==":{},"!=":{},">":{},">=":{},"<":{},"<=":{},in:{},"!in":{},all:{},any:{},none:{},has:{},"!has":{},within:{}}},geometry_type:{type:"enum",values:{Point:{},LineString:{},Polygon:{}}},function:{expression:{type:"expression"},stops:{type:"array",value:"function_stop"},base:{type:"number",default:1,minimum:0},property:{type:"string",default:"$zoom"},type:{type:"enum",values:{identity:{},exponential:{},interval:{},categorical:{}},default:"exponential"},colorSpace:{type:"enum",values:{rgb:{},lab:{},hcl:{}},default:"rgb"},default:{type:"*",required:!1}},function_stop:{type:"array",minimum:0,maximum:24,value:["number","color"],length:2},expression:{type:"array",value:"*",minimum:1},light:{anchor:{type:"enum",default:"viewport",values:{map:{},viewport:{}},"property-type":"data-constant",transition:!1,expression:{interpolated:!1,parameters:["zoom"]}},position:{type:"array",default:[1.15,210,30],length:3,value:"number","property-type":"data-constant",transition:!0,expression:{interpolated:!0,parameters:["zoom"]}},color:{type:"color","property-type":"data-constant",default:"#ffffff",expression:{interpolated:!0,parameters:["zoom"]},transition:!0},intensity:{type:"number","property-type":"data-constant",default:.5,minimum:0,maximum:1,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},terrain:{source:{type:"string",required:!0},exaggeration:{type:"number","property-type":"data-constant",default:1,minimum:0,maximum:1e3,expression:{interpolated:!0,parameters:["zoom"]},transition:!0}},paint:["paint_fill","paint_line","paint_circle","paint_heatmap","paint_fill-extrusion","paint_symbol","paint_raster","paint_hillshade","paint_background","paint_sky"],paint_fill:{"fill-antialias":{type:"boolean",default:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-outline-color":{type:"color",transition:!0,requires:[{"!":"fill-pattern"},{"fill-antialias":!0}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"}},"paint_fill-extrusion":{"fill-extrusion-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"fill-extrusion-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["fill-extrusion-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"fill-extrusion-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"fill-extrusion-height":{type:"number",default:0,minimum:0,units:"meters",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-base":{type:"number",default:0,minimum:0,units:"meters",transition:!0,requires:["fill-extrusion-height"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"fill-extrusion-vertical-gradient":{type:"boolean",default:!0,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_line:{"line-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"line-pattern"}],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"line-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["line-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"line-width":{type:"number",default:1,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-gap-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-offset":{type:"number",default:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"line-dasharray":{type:"array",value:"number",minimum:0,transition:!0,units:"line widths",requires:[{"!":"line-pattern"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"line-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom","feature"]},"property-type":"cross-faded-data-driven"},"line-gradient":{type:"color",transition:!1,requires:[{"!":"line-dasharray"},{"!":"line-pattern"},{source:"geojson",has:{lineMetrics:!0}}],expression:{interpolated:!0,parameters:["line-progress"]},"property-type":"color-ramp"}},paint_circle:{"circle-radius":{type:"number",default:5,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-blur":{type:"number",default:0,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"circle-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["circle-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-scale":{type:"enum",values:{map:{},viewport:{}},default:"map",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-pitch-alignment":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"circle-stroke-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"circle-stroke-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"}},paint_heatmap:{"heatmap-radius":{type:"number",default:30,minimum:1,transition:!0,units:"pixels",expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-weight":{type:"number",default:1,minimum:0,transition:!1,expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"heatmap-intensity":{type:"number",default:1,minimum:0,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"heatmap-color":{type:"color",default:["interpolate",["linear"],["heatmap-density"],0,"rgba(0, 0, 255, 0)",.1,"royalblue",.3,"cyan",.5,"lime",.7,"yellow",1,"red"],transition:!1,expression:{interpolated:!0,parameters:["heatmap-density"]},"property-type":"color-ramp"},"heatmap-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_symbol:{"icon-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-color":{type:"color",default:"#000000",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"icon-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["icon-image"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"icon-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["icon-image","icon-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"text-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-color":{type:"color",default:"#000000",transition:!0,overridable:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-color":{type:"color",default:"rgba(0, 0, 0, 0)",transition:!0,requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-width":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-halo-blur":{type:"number",default:0,minimum:0,transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom","feature","feature-state"]},"property-type":"data-driven"},"text-translate":{type:"array",value:"number",length:2,default:[0,0],transition:!0,units:"pixels",requires:["text-field"],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"text-translate-anchor":{type:"enum",values:{map:{},viewport:{}},default:"map",requires:["text-field","text-translate"],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"}},paint_raster:{"raster-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-hue-rotate":{type:"number",default:0,period:360,transition:!0,units:"degrees",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-min":{type:"number",default:0,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-brightness-max":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-saturation":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-contrast":{type:"number",default:0,minimum:-1,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"raster-resampling":{type:"enum",values:{linear:{},nearest:{}},default:"linear",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"raster-fade-duration":{type:"number",default:300,minimum:0,transition:!1,units:"milliseconds",expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_hillshade:{"hillshade-illumination-direction":{type:"number",default:335,minimum:0,maximum:359,transition:!1,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-illumination-anchor":{type:"enum",values:{map:{},viewport:{}},default:"viewport",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-exaggeration":{type:"number",default:.5,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-shadow-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-highlight-color":{type:"color",default:"#FFFFFF",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"hillshade-accent-color":{type:"color",default:"#000000",transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_background:{"background-color":{type:"color",default:"#000000",transition:!0,requires:[{"!":"background-pattern"}],expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"},"background-pattern":{type:"resolvedImage",transition:!0,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"cross-faded"},"background-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},paint_sky:{"sky-type":{type:"enum",values:{gradient:{},atmosphere:{}},default:"atmosphere",expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun":{type:"array",value:"number",length:2,units:"degrees",minimum:[0,0],maximum:[360,180],transition:!1,requires:[{"sky-type":"atmosphere"}],expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-atmosphere-sun-intensity":{type:"number",requires:[{"sky-type":"atmosphere"}],default:10,minimum:0,maximum:100,transition:!1,"property-type":"data-constant"},"sky-gradient-center":{type:"array",requires:[{"sky-type":"gradient"}],value:"number",default:[0,0],length:2,units:"degrees",minimum:[0,0],maximum:[360,180],transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient-radius":{type:"number",requires:[{"sky-type":"gradient"}],default:90,minimum:0,maximum:180,transition:!1,expression:{interpolated:!1,parameters:["zoom"]},"property-type":"data-constant"},"sky-gradient":{type:"color",default:["interpolate",["linear"],["sky-radial-progress"],.8,"#87ceeb",1,"white"],transition:!1,requires:[{"sky-type":"gradient"}],expression:{interpolated:!0,parameters:["sky-radial-progress"]},"property-type":"color-ramp"},"sky-atmosphere-halo-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-atmosphere-color":{type:"color",default:"white",transition:!1,requires:[{"sky-type":"atmosphere"}],"property-type":"data-constant"},"sky-opacity":{type:"number",default:1,minimum:0,maximum:1,transition:!0,expression:{interpolated:!0,parameters:["zoom"]},"property-type":"data-constant"}},transition:{duration:{type:"number",default:300,minimum:0,units:"milliseconds"},delay:{type:"number",default:0,minimum:0,units:"milliseconds"}},"property-type":{"data-driven":{type:"property-type"},"cross-faded":{type:"property-type"},"cross-faded-data-driven":{type:"property-type"},"color-ramp":{type:"property-type"},"data-constant":{type:"property-type"},constant:{type:"property-type"}},promoteId:{"*":{type:"string"}}};class Rt{constructor(t,e,r,i){this.message=(t?`${t}: `:"")+r,i&&(this.identifier=i),null!=e&&e.__line__&&(this.line=e.__line__);}}function Lt(t){const e=t.value;return e?[new Rt(t.key,e,"constants have been deprecated as of v8")]:[]}function Ut(t,...e){for(const r of e)for(const e in r)t[e]=r[e];return t}function Ot(t){return t instanceof Number||t instanceof String||t instanceof Boolean?t.valueOf():t}function $t(t){if(Array.isArray(t))return t.map($t);if(t instanceof Object&&!(t instanceof Number||t instanceof String||t instanceof Boolean)){const e={};for(const r in t)e[r]=$t(t[r]);return e}return Ot(t)}class qt extends Error{constructor(t,e){super(e),this.message=e,this.key=t;}}class Nt{constructor(t,e=[]){this.parent=t,this.bindings={};for(const[t,r]of e)this.bindings[t]=r;}concat(t){return new Nt(this,t)}get(t){if(this.bindings[t])return this.bindings[t];if(this.parent)return this.parent.get(t);throw new Error(`${t} not found in scope.`)}has(t){return !!this.bindings[t]||!!this.parent&&this.parent.has(t)}}const jt={kind:"null"},Gt={kind:"number"},Zt={kind:"string"},Xt={kind:"boolean"},Kt={kind:"color"},Ht={kind:"object"},Yt={kind:"value"},Wt={kind:"collator"},Jt={kind:"formatted"},Qt={kind:"resolvedImage"};function te(t,e){return {kind:"array",itemType:t,N:e}}function ee(t){if("array"===t.kind){const e=ee(t.itemType);return "number"==typeof t.N?`array<${e}, ${t.N}>`:"value"===t.itemType.kind?"array":`array<${e}>`}return t.kind}const re=[jt,Gt,Zt,Xt,Kt,Jt,Ht,te(Yt),Qt];function ie(t,e){if("error"===e.kind)return null;if("array"===t.kind){if("array"===e.kind&&(0===e.N&&"value"===e.itemType.kind||!ie(t.itemType,e.itemType))&&("number"!=typeof t.N||t.N===e.N))return null}else {if(t.kind===e.kind)return null;if("value"===t.kind)for(const t of re)if(!ie(t,e))return null}return `Expected ${ee(t)} but found ${ee(e)} instead.`}function ne(t,e){return e.some(e=>e.kind===t.kind)}function se(t,e){return e.some(e=>"null"===e?null===t:"array"===e?Array.isArray(t):"object"===e?t&&!Array.isArray(t)&&"object"==typeof t:e===typeof t)}function ae(t,e){return t(e={exports:{}},e.exports),e.exports}var oe=ae((function(t,e){var r={transparent:[0,0,0,0],aliceblue:[240,248,255,1],antiquewhite:[250,235,215,1],aqua:[0,255,255,1],aquamarine:[127,255,212,1],azure:[240,255,255,1],beige:[245,245,220,1],bisque:[255,228,196,1],black:[0,0,0,1],blanchedalmond:[255,235,205,1],blue:[0,0,255,1],blueviolet:[138,43,226,1],brown:[165,42,42,1],burlywood:[222,184,135,1],cadetblue:[95,158,160,1],chartreuse:[127,255,0,1],chocolate:[210,105,30,1],coral:[255,127,80,1],cornflowerblue:[100,149,237,1],cornsilk:[255,248,220,1],crimson:[220,20,60,1],cyan:[0,255,255,1],darkblue:[0,0,139,1],darkcyan:[0,139,139,1],darkgoldenrod:[184,134,11,1],darkgray:[169,169,169,1],darkgreen:[0,100,0,1],darkgrey:[169,169,169,1],darkkhaki:[189,183,107,1],darkmagenta:[139,0,139,1],darkolivegreen:[85,107,47,1],darkorange:[255,140,0,1],darkorchid:[153,50,204,1],darkred:[139,0,0,1],darksalmon:[233,150,122,1],darkseagreen:[143,188,143,1],darkslateblue:[72,61,139,1],darkslategray:[47,79,79,1],darkslategrey:[47,79,79,1],darkturquoise:[0,206,209,1],darkviolet:[148,0,211,1],deeppink:[255,20,147,1],deepskyblue:[0,191,255,1],dimgray:[105,105,105,1],dimgrey:[105,105,105,1],dodgerblue:[30,144,255,1],firebrick:[178,34,34,1],floralwhite:[255,250,240,1],forestgreen:[34,139,34,1],fuchsia:[255,0,255,1],gainsboro:[220,220,220,1],ghostwhite:[248,248,255,1],gold:[255,215,0,1],goldenrod:[218,165,32,1],gray:[128,128,128,1],green:[0,128,0,1],greenyellow:[173,255,47,1],grey:[128,128,128,1],honeydew:[240,255,240,1],hotpink:[255,105,180,1],indianred:[205,92,92,1],indigo:[75,0,130,1],ivory:[255,255,240,1],khaki:[240,230,140,1],lavender:[230,230,250,1],lavenderblush:[255,240,245,1],lawngreen:[124,252,0,1],lemonchiffon:[255,250,205,1],lightblue:[173,216,230,1],lightcoral:[240,128,128,1],lightcyan:[224,255,255,1],lightgoldenrodyellow:[250,250,210,1],lightgray:[211,211,211,1],lightgreen:[144,238,144,1],lightgrey:[211,211,211,1],lightpink:[255,182,193,1],lightsalmon:[255,160,122,1],lightseagreen:[32,178,170,1],lightskyblue:[135,206,250,1],lightslategray:[119,136,153,1],lightslategrey:[119,136,153,1],lightsteelblue:[176,196,222,1],lightyellow:[255,255,224,1],lime:[0,255,0,1],limegreen:[50,205,50,1],linen:[250,240,230,1],magenta:[255,0,255,1],maroon:[128,0,0,1],mediumaquamarine:[102,205,170,1],mediumblue:[0,0,205,1],mediumorchid:[186,85,211,1],mediumpurple:[147,112,219,1],mediumseagreen:[60,179,113,1],mediumslateblue:[123,104,238,1],mediumspringgreen:[0,250,154,1],mediumturquoise:[72,209,204,1],mediumvioletred:[199,21,133,1],midnightblue:[25,25,112,1],mintcream:[245,255,250,1],mistyrose:[255,228,225,1],moccasin:[255,228,181,1],navajowhite:[255,222,173,1],navy:[0,0,128,1],oldlace:[253,245,230,1],olive:[128,128,0,1],olivedrab:[107,142,35,1],orange:[255,165,0,1],orangered:[255,69,0,1],orchid:[218,112,214,1],palegoldenrod:[238,232,170,1],palegreen:[152,251,152,1],paleturquoise:[175,238,238,1],palevioletred:[219,112,147,1],papayawhip:[255,239,213,1],peachpuff:[255,218,185,1],peru:[205,133,63,1],pink:[255,192,203,1],plum:[221,160,221,1],powderblue:[176,224,230,1],purple:[128,0,128,1],rebeccapurple:[102,51,153,1],red:[255,0,0,1],rosybrown:[188,143,143,1],royalblue:[65,105,225,1],saddlebrown:[139,69,19,1],salmon:[250,128,114,1],sandybrown:[244,164,96,1],seagreen:[46,139,87,1],seashell:[255,245,238,1],sienna:[160,82,45,1],silver:[192,192,192,1],skyblue:[135,206,235,1],slateblue:[106,90,205,1],slategray:[112,128,144,1],slategrey:[112,128,144,1],snow:[255,250,250,1],springgreen:[0,255,127,1],steelblue:[70,130,180,1],tan:[210,180,140,1],teal:[0,128,128,1],thistle:[216,191,216,1],tomato:[255,99,71,1],turquoise:[64,224,208,1],violet:[238,130,238,1],wheat:[245,222,179,1],white:[255,255,255,1],whitesmoke:[245,245,245,1],yellow:[255,255,0,1],yellowgreen:[154,205,50,1]};function i(t){return (t=Math.round(t))<0?0:t>255?255:t}function n(t){return i("%"===t[t.length-1]?parseFloat(t)/100*255:parseInt(t))}function s(t){return (e="%"===t[t.length-1]?parseFloat(t)/100:parseFloat(t))<0?0:e>1?1:e;var e;}function a(t,e,r){return r<0?r+=1:r>1&&(r-=1),6*r<1?t+(e-t)*r*6:2*r<1?e:3*r<2?t+(e-t)*(2/3-r)*6:t}try{e.parseCSSColor=function(t){var e,o=t.replace(/ /g,"").toLowerCase();if(o in r)return r[o].slice();if("#"===o[0])return 4===o.length?(e=parseInt(o.substr(1),16))>=0&&e<=4095?[(3840&e)>>4|(3840&e)>>8,240&e|(240&e)>>4,15&e|(15&e)<<4,1]:null:7===o.length&&(e=parseInt(o.substr(1),16))>=0&&e<=16777215?[(16711680&e)>>16,(65280&e)>>8,255&e,1]:null;var l=o.indexOf("("),u=o.indexOf(")");if(-1!==l&&u+1===o.length){var c=o.substr(0,l),h=o.substr(l+1,u-(l+1)).split(","),p=1;switch(c){case"rgba":if(4!==h.length)return null;p=s(h.pop());case"rgb":return 3!==h.length?null:[n(h[0]),n(h[1]),n(h[2]),p];case"hsla":if(4!==h.length)return null;p=s(h.pop());case"hsl":if(3!==h.length)return null;var d=(parseFloat(h[0])%360+360)%360/360,f=s(h[1]),y=s(h[2]),m=y<=.5?y*(f+1):y+f-y*f,g=2*y-m;return [i(255*a(g,m,d+1/3)),i(255*a(g,m,d)),i(255*a(g,m,d-1/3)),p];default:return null}}return null};}catch(t){}})).parseCSSColor;class le{constructor(t,e,r,i=1){this.r=t,this.g=e,this.b=r,this.a=i;}static parse(t){if(!t)return;if(t instanceof le)return t;if("string"!=typeof t)return;const e=oe(t);return e?new le(e[0]/255*e[3],e[1]/255*e[3],e[2]/255*e[3],e[3]):void 0}toString(){const[t,e,r,i]=this.toArray();return `rgba(${Math.round(t)},${Math.round(e)},${Math.round(r)},${i})`}toArray(){const{r:t,g:e,b:r,a:i}=this;return 0===i?[0,0,0,0]:[255*t/i,255*e/i,255*r/i,i]}}le.black=new le(0,0,0,1),le.white=new le(1,1,1,1),le.transparent=new le(0,0,0,0),le.red=new le(1,0,0,1),le.blue=new le(0,0,1,1);class ue{constructor(t,e,r){this.sensitivity=t?e?"variant":"case":e?"accent":"base",this.locale=r,this.collator=new Intl.Collator(this.locale?this.locale:[],{sensitivity:this.sensitivity,usage:"search"});}compare(t,e){return this.collator.compare(t,e)}resolvedLocale(){return new Intl.Collator(this.locale?this.locale:[]).resolvedOptions().locale}}class ce{constructor(t,e,r,i,n){this.text=t,this.image=e,this.scale=r,this.fontStack=i,this.textColor=n;}}class he{constructor(t){this.sections=t;}static fromString(t){return new he([new ce(t,null,null,null,null)])}isEmpty(){return 0===this.sections.length||!this.sections.some(t=>0!==t.text.length||t.image&&0!==t.image.name.length)}static factory(t){return t instanceof he?t:he.fromString(t)}toString(){return 0===this.sections.length?"":this.sections.map(t=>t.text).join("")}serialize(){const t=["format"];for(const e of this.sections){if(e.image){t.push(["image",e.image.name]);continue}t.push(e.text);const r={};e.fontStack&&(r["text-font"]=["literal",e.fontStack.split(",")]),e.scale&&(r["font-scale"]=e.scale),e.textColor&&(r["text-color"]=["rgba"].concat(e.textColor.toArray())),t.push(r);}return t}}class pe{constructor(t){this.name=t.name,this.available=t.available;}toString(){return this.name}static fromString(t){return t?new pe({name:t,available:!1}):null}serialize(){return ["image",this.name]}}function de(t,e,r,i){return "number"==typeof t&&t>=0&&t<=255&&"number"==typeof e&&e>=0&&e<=255&&"number"==typeof r&&r>=0&&r<=255?void 0===i||"number"==typeof i&&i>=0&&i<=1?null:`Invalid rgba value [${[t,e,r,i].join(", ")}]: 'a' must be between 0 and 1.`:`Invalid rgba value [${("number"==typeof i?[t,e,r,i]:[t,e,r]).join(", ")}]: 'r', 'g', and 'b' must be between 0 and 255.`}function fe(t){if(null===t)return !0;if("string"==typeof t)return !0;if("boolean"==typeof t)return !0;if("number"==typeof t)return !0;if(t instanceof le)return !0;if(t instanceof ue)return !0;if(t instanceof he)return !0;if(t instanceof pe)return !0;if(Array.isArray(t)){for(const e of t)if(!fe(e))return !1;return !0}if("object"==typeof t){for(const e in t)if(!fe(t[e]))return !1;return !0}return !1}function ye(t){if(null===t)return jt;if("string"==typeof t)return Zt;if("boolean"==typeof t)return Xt;if("number"==typeof t)return Gt;if(t instanceof le)return Kt;if(t instanceof ue)return Wt;if(t instanceof he)return Jt;if(t instanceof pe)return Qt;if(Array.isArray(t)){const e=t.length;let r;for(const e of t){const t=ye(e);if(r){if(r===t)continue;r=Yt;break}r=t;}return te(r||Yt,e)}return Ht}function me(t){const e=typeof t;return null===t?"":"string"===e||"number"===e||"boolean"===e?String(t):t instanceof le||t instanceof he||t instanceof pe?t.toString():JSON.stringify(t)}class ge{constructor(t,e){this.type=t,this.value=e;}static parse(t,e){if(2!==t.length)return e.error(`'literal' expression requires exactly one argument, but found ${t.length-1} instead.`);if(!fe(t[1]))return e.error("invalid value");const r=t[1];let i=ye(r);const n=e.expectedType;return "array"!==i.kind||0!==i.N||!n||"array"!==n.kind||"number"==typeof n.N&&0!==n.N||(i=n),new ge(i,r)}evaluate(){return this.value}eachChild(){}outputDefined(){return !0}serialize(){return "array"===this.type.kind||"object"===this.type.kind?["literal",this.value]:this.value instanceof le?["rgba"].concat(this.value.toArray()):this.value instanceof he?this.value.serialize():this.value}}class xe{constructor(t){this.name="ExpressionEvaluationError",this.message=t;}toJSON(){return this.message}}const ve={string:Zt,number:Gt,boolean:Xt,object:Ht};class be{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");let r,i=1;const n=t[0];if("array"===n){let n,s;if(t.length>2){const r=t[1];if("string"!=typeof r||!(r in ve)||"object"===r)return e.error('The item type argument of "array" must be one of string, number, boolean',1);n=ve[r],i++;}else n=Yt;if(t.length>3){if(null!==t[2]&&("number"!=typeof t[2]||t[2]<0||t[2]!==Math.floor(t[2])))return e.error('The length argument to "array" must be a positive integer literal',2);s=t[2],i++;}r=te(n,s);}else r=ve[n];const s=[];for(;i<t.length;i++){const r=e.parse(t[i],i,Yt);if(!r)return null;s.push(r);}return new be(r,s)}evaluate(t){for(let e=0;e<this.args.length;e++){const r=this.args[e].evaluate(t);if(!ie(this.type,ye(r)))return r;if(e===this.args.length-1)throw new xe(`Expected value to be of type ${ee(this.type)}, but found ${ee(ye(r))} instead.`)}return null}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){const t=this.type,e=[t.kind];if("array"===t.kind){const r=t.itemType;if("string"===r.kind||"number"===r.kind||"boolean"===r.kind){e.push(r.kind);const i=t.N;("number"==typeof i||this.args.length>1)&&e.push(i);}}return e.concat(this.args.map(t=>t.serialize()))}}class we{constructor(t){this.type=Jt,this.sections=t;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[1];if(!Array.isArray(r)&&"object"==typeof r)return e.error("First argument must be an image or text section.");const i=[];let n=!1;for(let r=1;r<=t.length-1;++r){const s=t[r];if(n&&"object"==typeof s&&!Array.isArray(s)){n=!1;let t=null;if(s["font-scale"]&&(t=e.parse(s["font-scale"],1,Gt),!t))return null;let r=null;if(s["text-font"]&&(r=e.parse(s["text-font"],1,te(Zt)),!r))return null;let a=null;if(s["text-color"]&&(a=e.parse(s["text-color"],1,Kt),!a))return null;const o=i[i.length-1];o.scale=t,o.font=r,o.textColor=a;}else {const s=e.parse(t[r],1,Yt);if(!s)return null;const a=s.type.kind;if("string"!==a&&"value"!==a&&"null"!==a&&"resolvedImage"!==a)return e.error("Formatted text type must be 'string', 'value', 'image' or 'null'.");n=!0,i.push({content:s,scale:null,font:null,textColor:null});}}return new we(i)}evaluate(t){return new he(this.sections.map(e=>{const r=e.content.evaluate(t);return ye(r)===Qt?new ce("",r,null,null,null):new ce(me(r),null,e.scale?e.scale.evaluate(t):null,e.font?e.font.evaluate(t).join(","):null,e.textColor?e.textColor.evaluate(t):null)}))}eachChild(t){for(const e of this.sections)t(e.content),e.scale&&t(e.scale),e.font&&t(e.font),e.textColor&&t(e.textColor);}outputDefined(){return !1}serialize(){const t=["format"];for(const e of this.sections){t.push(e.content.serialize());const r={};e.scale&&(r["font-scale"]=e.scale.serialize()),e.font&&(r["text-font"]=e.font.serialize()),e.textColor&&(r["text-color"]=e.textColor.serialize()),t.push(r);}return t}}class _e{constructor(t){this.type=Qt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Zt);return r?new _e(r):e.error("No image name provided.")}evaluate(t){const e=this.input.evaluate(t),r=pe.fromString(e);return r&&t.availableImages&&(r.available=t.availableImages.indexOf(e)>-1),r}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){return ["image",this.input.serialize()]}}const ke={"to-boolean":Xt,"to-color":Kt,"to-number":Gt,"to-string":Zt};class Ae{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expected at least one argument.");const r=t[0];if(("to-boolean"===r||"to-string"===r)&&2!==t.length)return e.error("Expected one argument.");const i=ke[r],n=[];for(let r=1;r<t.length;r++){const i=e.parse(t[r],r,Yt);if(!i)return null;n.push(i);}return new Ae(i,n)}evaluate(t){if("boolean"===this.type.kind)return Boolean(this.args[0].evaluate(t));if("color"===this.type.kind){let e,r;for(const i of this.args){if(e=i.evaluate(t),r=null,e instanceof le)return e;if("string"==typeof e){const r=t.parseColor(e);if(r)return r}else if(Array.isArray(e)&&(r=e.length<3||e.length>4?`Invalid rbga value ${JSON.stringify(e)}: expected an array containing either three or four numeric values.`:de(e[0],e[1],e[2],e[3]),!r))return new le(e[0]/255,e[1]/255,e[2]/255,e[3])}throw new xe(r||`Could not parse color from value '${"string"==typeof e?e:String(JSON.stringify(e))}'`)}if("number"===this.type.kind){let e=null;for(const r of this.args){if(e=r.evaluate(t),null===e)return 0;const i=Number(e);if(!isNaN(i))return i}throw new xe(`Could not convert ${JSON.stringify(e)} to number.`)}return "formatted"===this.type.kind?he.fromString(me(this.args[0].evaluate(t))):"resolvedImage"===this.type.kind?pe.fromString(me(this.args[0].evaluate(t))):me(this.args[0].evaluate(t))}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){if("formatted"===this.type.kind)return new we([{content:this.args[0],scale:null,font:null,textColor:null}]).serialize();if("resolvedImage"===this.type.kind)return new _e(this.args[0]).serialize();const t=[`to-${this.type.kind}`];return this.eachChild(e=>{t.push(e.serialize());}),t}}const Se=["Unknown","Point","LineString","Polygon"];class Ie{constructor(){this.globals=null,this.feature=null,this.featureState=null,this.formattedSection=null,this._parseColorCache={},this.availableImages=null,this.canonical=null;}id(){return this.feature&&"id"in this.feature?this.feature.id:null}geometryType(){return this.feature?"number"==typeof this.feature.type?Se[this.feature.type]:this.feature.type:null}geometry(){return this.feature&&"geometry"in this.feature?this.feature.geometry:null}canonicalID(){return this.canonical}properties(){return this.feature&&this.feature.properties||{}}parseColor(t){let e=this._parseColorCache[t];return e||(e=this._parseColorCache[t]=le.parse(t)),e}}class Te{constructor(t,e,r,i){this.name=t,this.type=e,this._evaluate=r,this.args=i;}evaluate(t){return this._evaluate(t,this.args)}eachChild(t){this.args.forEach(t);}outputDefined(){return !1}serialize(){return [this.name].concat(this.args.map(t=>t.serialize()))}static parse(t,e){const r=t[0],i=Te.definitions[r];if(!i)return e.error(`Unknown expression "${r}". If you wanted a literal array, use ["literal", [...]].`,0);const n=Array.isArray(i)?i[0]:i.type,s=Array.isArray(i)?[[i[1],i[2]]]:i.overloads,a=s.filter(([e])=>!Array.isArray(e)||e.length===t.length-1);let o=null;for(const[i,s]of a){o=new He(e.registry,e.path,null,e.scope);const a=[];let l=!1;for(let e=1;e<t.length;e++){const r=t[e],n=Array.isArray(i)?i[e-1]:i.type,s=o.parse(r,1+a.length,n);if(!s){l=!0;break}a.push(s);}if(!l)if(Array.isArray(i)&&i.length!==a.length)o.error(`Expected ${i.length} arguments, but found ${a.length} instead.`);else {for(let t=0;t<a.length;t++){const e=Array.isArray(i)?i[t]:i.type,r=a[t];o.concat(t+1).checkSubtype(e,r.type);}if(0===o.errors.length)return new Te(r,n,s,a)}}if(1===a.length)e.errors.push(...o.errors);else {const r=(a.length?a:s).map(([t])=>{return e=t,Array.isArray(e)?`(${e.map(ee).join(", ")})`:`(${ee(e.type)}...)`;var e;}).join(" | "),i=[];for(let r=1;r<t.length;r++){const n=e.parse(t[r],1+i.length);if(!n)return null;i.push(ee(n.type));}e.error(`Expected arguments of type ${r}, but found (${i.join(", ")}) instead.`);}return null}static register(t,e){Te.definitions=e;for(const r in e)t[r]=Te;}}class ze{constructor(t,e,r){this.type=Wt,this.locale=r,this.caseSensitive=t,this.diacriticSensitive=e;}static parse(t,e){if(2!==t.length)return e.error("Expected one argument.");const r=t[1];if("object"!=typeof r||Array.isArray(r))return e.error("Collator options argument must be an object.");const i=e.parse(void 0!==r["case-sensitive"]&&r["case-sensitive"],1,Xt);if(!i)return null;const n=e.parse(void 0!==r["diacritic-sensitive"]&&r["diacritic-sensitive"],1,Xt);if(!n)return null;let s=null;return r.locale&&(s=e.parse(r.locale,1,Zt),!s)?null:new ze(i,n,s)}evaluate(t){return new ue(this.caseSensitive.evaluate(t),this.diacriticSensitive.evaluate(t),this.locale?this.locale.evaluate(t):null)}eachChild(t){t(this.caseSensitive),t(this.diacriticSensitive),this.locale&&t(this.locale);}outputDefined(){return !1}serialize(){const t={};return t["case-sensitive"]=this.caseSensitive.serialize(),t["diacritic-sensitive"]=this.diacriticSensitive.serialize(),this.locale&&(t.locale=this.locale.serialize()),["collator",t]}}function Ee(t,e){t[0]=Math.min(t[0],e[0]),t[1]=Math.min(t[1],e[1]),t[2]=Math.max(t[2],e[0]),t[3]=Math.max(t[3],e[1]);}function Me(t,e){return !(t[0]<=e[0]||t[2]>=e[2]||t[1]<=e[1]||t[3]>=e[3])}function Be(t,e){const r=(180+t[0])/360,i=(180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t[1]*Math.PI/360)))/360,n=Math.pow(2,e.z);return [Math.round(r*n*8192),Math.round(i*n*8192)]}function De(t,e,r){const i=t[0]-e[0],n=t[1]-e[1],s=t[0]-r[0],a=t[1]-r[1];return i*a-s*n==0&&i*s<=0&&n*a<=0}function Ce(t,e){let r=!1;for(let a=0,o=e.length;a<o;a++){const o=e[a];for(let e=0,a=o.length;e<a-1;e++){if(De(t,o[e],o[e+1]))return !1;(n=o[e])[1]>(i=t)[1]!=(s=o[e+1])[1]>i[1]&&i[0]<(s[0]-n[0])*(i[1]-n[1])/(s[1]-n[1])+n[0]&&(r=!r);}}var i,n,s;return r}function Pe(t,e){for(let r=0;r<e.length;r++)if(Ce(t,e[r]))return !0;return !1}function Ve(t,e,r,i){const n=i[0]-r[0],s=i[1]-r[1],a=(t[0]-r[0])*s-n*(t[1]-r[1]),o=(e[0]-r[0])*s-n*(e[1]-r[1]);return a>0&&o<0||a<0&&o>0}function Fe(t,e,r){for(const u of r)for(let r=0;r<u.length-1;++r)if(0!=(o=[(a=u[r+1])[0]-(s=u[r])[0],a[1]-s[1]])[0]*(l=[(n=e)[0]-(i=t)[0],n[1]-i[1]])[1]-o[1]*l[0]&&Ve(i,n,s,a)&&Ve(s,a,i,n))return !0;var i,n,s,a,o,l;return !1}function Re(t,e){for(let r=0;r<t.length;++r)if(!Ce(t[r],e))return !1;for(let r=0;r<t.length-1;++r)if(Fe(t[r],t[r+1],e))return !1;return !0}function Le(t,e){for(let r=0;r<e.length;r++)if(Re(t,e[r]))return !0;return !1}function Ue(t,e,r){const i=[];for(let n=0;n<t.length;n++){const s=[];for(let i=0;i<t[n].length;i++){const a=Be(t[n][i],r);Ee(e,a),s.push(a);}i.push(s);}return i}function Oe(t,e,r){const i=[];for(let n=0;n<t.length;n++){const s=Ue(t[n],e,r);i.push(s);}return i}function $e(t,e,r,i){if(t[0]<r[0]||t[0]>r[2]){const e=.5*i;let n=t[0]-r[0]>e?-i:r[0]-t[0]>e?i:0;0===n&&(n=t[0]-r[2]>e?-i:r[2]-t[0]>e?i:0),t[0]+=n;}Ee(e,t);}function qe(t,e,r,i){const n=8192*Math.pow(2,i.z),s=[8192*i.x,8192*i.y],a=[];for(const i of t)for(const t of i){const i=[t.x+s[0],t.y+s[1]];$e(i,e,r,n),a.push(i);}return a}function Ne(t,e,r,i){const n=8192*Math.pow(2,i.z),s=[8192*i.x,8192*i.y],a=[];for(const r of t){const t=[];for(const i of r){const r=[i.x+s[0],i.y+s[1]];Ee(e,r),t.push(r);}a.push(t);}if(e[2]-e[0]<=n/2){(o=e)[0]=o[1]=1/0,o[2]=o[3]=-1/0;for(const t of a)for(const i of t)$e(i,e,r,n);}var o;return a}class je{constructor(t,e){this.type=Xt,this.geojson=t,this.geometries=e;}static parse(t,e){if(2!==t.length)return e.error(`'within' expression requires exactly one argument, but found ${t.length-1} instead.`);if(fe(t[1])){const e=t[1];if("FeatureCollection"===e.type)for(let t=0;t<e.features.length;++t){const r=e.features[t].geometry.type;if("Polygon"===r||"MultiPolygon"===r)return new je(e,e.features[t].geometry)}else if("Feature"===e.type){const t=e.geometry.type;if("Polygon"===t||"MultiPolygon"===t)return new je(e,e.geometry)}else if("Polygon"===e.type||"MultiPolygon"===e.type)return new je(e,e)}return e.error("'within' expression requires valid geojson object that contains polygon geometry type.")}evaluate(t){if(null!=t.geometry()&&null!=t.canonicalID()){if("Point"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],i=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Ue(e.coordinates,i,n),a=qe(t.geometry(),r,i,n);if(!Me(r,i))return !1;for(const t of a)if(!Ce(t,s))return !1}if("MultiPolygon"===e.type){const s=Oe(e.coordinates,i,n),a=qe(t.geometry(),r,i,n);if(!Me(r,i))return !1;for(const t of a)if(!Pe(t,s))return !1}return !0}(t,this.geometries);if("LineString"===t.geometryType())return function(t,e){const r=[1/0,1/0,-1/0,-1/0],i=[1/0,1/0,-1/0,-1/0],n=t.canonicalID();if("Polygon"===e.type){const s=Ue(e.coordinates,i,n),a=Ne(t.geometry(),r,i,n);if(!Me(r,i))return !1;for(const t of a)if(!Re(t,s))return !1}if("MultiPolygon"===e.type){const s=Oe(e.coordinates,i,n),a=Ne(t.geometry(),r,i,n);if(!Me(r,i))return !1;for(const t of a)if(!Le(t,s))return !1}return !0}(t,this.geometries)}return !1}eachChild(){}outputDefined(){return !0}serialize(){return ["within",this.geojson]}}function Ge(t){if(t instanceof Te){if("get"===t.name&&1===t.args.length)return !1;if("feature-state"===t.name)return !1;if("has"===t.name&&1===t.args.length)return !1;if("properties"===t.name||"geometry-type"===t.name||"id"===t.name)return !1;if(/^filter-/.test(t.name))return !1}if(t instanceof je)return !1;let e=!0;return t.eachChild(t=>{e&&!Ge(t)&&(e=!1);}),e}function Ze(t){if(t instanceof Te&&"feature-state"===t.name)return !1;let e=!0;return t.eachChild(t=>{e&&!Ze(t)&&(e=!1);}),e}function Xe(t,e){if(t instanceof Te&&e.indexOf(t.name)>=0)return !1;let r=!0;return t.eachChild(t=>{r&&!Xe(t,e)&&(r=!1);}),r}class Ke{constructor(t,e){this.type=e.type,this.name=t,this.boundExpression=e;}static parse(t,e){if(2!==t.length||"string"!=typeof t[1])return e.error("'var' expression requires exactly one string literal argument.");const r=t[1];return e.scope.has(r)?new Ke(r,e.scope.get(r)):e.error(`Unknown variable "${r}". Make sure "${r}" has been bound in an enclosing "let" expression before using it.`,1)}evaluate(t){return this.boundExpression.evaluate(t)}eachChild(){}outputDefined(){return !1}serialize(){return ["var",this.name]}}class He{constructor(t,e=[],r,i=new Nt,n=[]){this.registry=t,this.path=e,this.key=e.map(t=>`[${t}]`).join(""),this.scope=i,this.errors=n,this.expectedType=r;}parse(t,e,r,i,n={}){return e?this.concat(e,r,i)._parse(t,n):this._parse(t,n)}_parse(t,e){function r(t,e,r){return "assert"===r?new be(e,[t]):"coerce"===r?new Ae(e,[t]):t}if(null!==t&&"string"!=typeof t&&"boolean"!=typeof t&&"number"!=typeof t||(t=["literal",t]),Array.isArray(t)){if(0===t.length)return this.error('Expected an array with at least one element. If you wanted a literal array, use ["literal", []].');const i=t[0];if("string"!=typeof i)return this.error(`Expression name must be a string, but found ${typeof i} instead. If you wanted a literal array, use ["literal", [...]].`,0),null;const n=this.registry[i];if(n){let i=n.parse(t,this);if(!i)return null;if(this.expectedType){const t=this.expectedType,n=i.type;if("string"!==t.kind&&"number"!==t.kind&&"boolean"!==t.kind&&"object"!==t.kind&&"array"!==t.kind||"value"!==n.kind)if("color"!==t.kind&&"formatted"!==t.kind&&"resolvedImage"!==t.kind||"value"!==n.kind&&"string"!==n.kind){if(this.checkSubtype(t,n))return null}else i=r(i,t,e.typeAnnotation||"coerce");else i=r(i,t,e.typeAnnotation||"assert");}if(!(i instanceof ge)&&"resolvedImage"!==i.type.kind&&function t(e){if(e instanceof Ke)return t(e.boundExpression);if(e instanceof Te&&"error"===e.name)return !1;if(e instanceof ze)return !1;if(e instanceof je)return !1;const r=e instanceof Ae||e instanceof be;let i=!0;return e.eachChild(e=>{i=r?i&&t(e):i&&e instanceof ge;}),!!i&&Ge(e)&&Xe(e,["zoom","heatmap-density","line-progress","sky-radial-progress","accumulated","is-supported-script"])}(i)){const t=new Ie;try{i=new ge(i.type,i.evaluate(t));}catch(t){return this.error(t.message),null}}return i}return this.error(`Unknown expression "${i}". If you wanted a literal array, use ["literal", [...]].`,0)}return this.error(void 0===t?"'undefined' value invalid. Use null instead.":"object"==typeof t?'Bare objects invalid. Use ["literal", {...}] instead.':`Expected an array, but found ${typeof t} instead.`)}concat(t,e,r){const i="number"==typeof t?this.path.concat(t):this.path,n=r?this.scope.concat(r):this.scope;return new He(this.registry,i,e||null,n,this.errors)}error(t,...e){const r=`${this.key}${e.map(t=>`[${t}]`).join("")}`;this.errors.push(new qt(r,t));}checkSubtype(t,e){const r=ie(t,e);return r&&this.error(r),r}}function Ye(t,e){const r=t.length-1;let i,n,s=0,a=r,o=0;for(;s<=a;)if(o=Math.floor((s+a)/2),i=t[o],n=t[o+1],i<=e){if(o===r||e<n)return o;s=o+1;}else {if(!(i>e))throw new xe("Input is not a number.");a=o-1;}return 0}class We{constructor(t,e,r){this.type=t,this.input=e,this.labels=[],this.outputs=[];for(const[t,e]of r)this.labels.push(t),this.outputs.push(e);}static parse(t,e){if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");const r=e.parse(t[1],1,Gt);if(!r)return null;const i=[];let n=null;e.expectedType&&"value"!==e.expectedType.kind&&(n=e.expectedType);for(let r=1;r<t.length;r+=2){const s=1===r?-1/0:t[r],a=t[r+1],o=r,l=r+1;if("number"!=typeof s)return e.error('Input/output pairs for "step" expressions must be defined using literal numeric values (not computed expressions) for the input values.',o);if(i.length&&i[i.length-1][0]>=s)return e.error('Input/output pairs for "step" expressions must be arranged with input values in strictly ascending order.',o);const u=e.parse(a,l,n);if(!u)return null;n=n||u.type,i.push([s,u]);}return new We(n,r,i)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const i=this.input.evaluate(t);if(i<=e[0])return r[0].evaluate(t);const n=e.length;return i>=e[n-1]?r[n-1].evaluate(t):r[Ye(e,i)].evaluate(t)}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined())}serialize(){const t=["step",this.input.serialize()];for(let e=0;e<this.labels.length;e++)e>0&&t.push(this.labels[e]),t.push(this.outputs[e].serialize());return t}}function Je(t,e,r){return t*(1-r)+e*r}var Qe=Object.freeze({__proto__:null,number:Je,color:function(t,e,r){return new le(Je(t.r,e.r,r),Je(t.g,e.g,r),Je(t.b,e.b,r),Je(t.a,e.a,r))},array:function(t,e,r){return t.map((t,i)=>Je(t,e[i],r))}});const tr=6/29*3*(6/29),er=Math.PI/180,rr=180/Math.PI;function ir(t){return t>.008856451679035631?Math.pow(t,1/3):t/tr+4/29}function nr(t){return t>6/29?t*t*t:tr*(t-4/29)}function sr(t){return 255*(t<=.0031308?12.92*t:1.055*Math.pow(t,1/2.4)-.055)}function ar(t){return (t/=255)<=.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)}function or(t){const e=ar(t.r),r=ar(t.g),i=ar(t.b),n=ir((.4124564*e+.3575761*r+.1804375*i)/.95047),s=ir((.2126729*e+.7151522*r+.072175*i)/1);return {l:116*s-16,a:500*(n-s),b:200*(s-ir((.0193339*e+.119192*r+.9503041*i)/1.08883)),alpha:t.a}}function lr(t){let e=(t.l+16)/116,r=isNaN(t.a)?e:e+t.a/500,i=isNaN(t.b)?e:e-t.b/200;return e=1*nr(e),r=.95047*nr(r),i=1.08883*nr(i),new le(sr(3.2404542*r-1.5371385*e-.4985314*i),sr(-.969266*r+1.8760108*e+.041556*i),sr(.0556434*r-.2040259*e+1.0572252*i),t.alpha)}function ur(t,e,r){const i=e-t;return t+r*(i>180||i<-180?i-360*Math.round(i/360):i)}const cr={forward:or,reverse:lr,interpolate:function(t,e,r){return {l:Je(t.l,e.l,r),a:Je(t.a,e.a,r),b:Je(t.b,e.b,r),alpha:Je(t.alpha,e.alpha,r)}}},hr={forward:function(t){const{l:e,a:r,b:i}=or(t),n=Math.atan2(i,r)*rr;return {h:n<0?n+360:n,c:Math.sqrt(r*r+i*i),l:e,alpha:t.a}},reverse:function(t){const e=t.h*er,r=t.c;return lr({l:t.l,a:Math.cos(e)*r,b:Math.sin(e)*r,alpha:t.alpha})},interpolate:function(t,e,r){return {h:ur(t.h,e.h,r),c:Je(t.c,e.c,r),l:Je(t.l,e.l,r),alpha:Je(t.alpha,e.alpha,r)}}};var pr=Object.freeze({__proto__:null,lab:cr,hcl:hr});class dr{constructor(t,e,r,i,n){this.type=t,this.operator=e,this.interpolation=r,this.input=i,this.labels=[],this.outputs=[];for(const[t,e]of n)this.labels.push(t),this.outputs.push(e);}static interpolationFactor(t,r,i,n){let s=0;if("exponential"===t.name)s=fr(r,t.base,i,n);else if("linear"===t.name)s=fr(r,1,i,n);else if("cubic-bezier"===t.name){const a=t.controlPoints;s=new e(a[0],a[1],a[2],a[3]).solve(fr(r,1,i,n));}return s}static parse(t,e){let[r,i,n,...s]=t;if(!Array.isArray(i)||0===i.length)return e.error("Expected an interpolation type expression.",1);if("linear"===i[0])i={name:"linear"};else if("exponential"===i[0]){const t=i[1];if("number"!=typeof t)return e.error("Exponential interpolation requires a numeric base.",1,1);i={name:"exponential",base:t};}else {if("cubic-bezier"!==i[0])return e.error(`Unknown interpolation type ${String(i[0])}`,1,0);{const t=i.slice(1);if(4!==t.length||t.some(t=>"number"!=typeof t||t<0||t>1))return e.error("Cubic bezier interpolation requires four numeric arguments with values between 0 and 1.",1);i={name:"cubic-bezier",controlPoints:t};}}if(t.length-1<4)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if((t.length-1)%2!=0)return e.error("Expected an even number of arguments.");if(n=e.parse(n,2,Gt),!n)return null;const a=[];let o=null;"interpolate-hcl"===r||"interpolate-lab"===r?o=Kt:e.expectedType&&"value"!==e.expectedType.kind&&(o=e.expectedType);for(let t=0;t<s.length;t+=2){const r=s[t],i=s[t+1],n=t+3,l=t+4;if("number"!=typeof r)return e.error('Input/output pairs for "interpolate" expressions must be defined using literal numeric values (not computed expressions) for the input values.',n);if(a.length&&a[a.length-1][0]>=r)return e.error('Input/output pairs for "interpolate" expressions must be arranged with input values in strictly ascending order.',n);const u=e.parse(i,l,o);if(!u)return null;o=o||u.type,a.push([r,u]);}return "number"===o.kind||"color"===o.kind||"array"===o.kind&&"number"===o.itemType.kind&&"number"==typeof o.N?new dr(o,r,i,n,a):e.error(`Type ${ee(o)} is not interpolatable.`)}evaluate(t){const e=this.labels,r=this.outputs;if(1===e.length)return r[0].evaluate(t);const i=this.input.evaluate(t);if(i<=e[0])return r[0].evaluate(t);const n=e.length;if(i>=e[n-1])return r[n-1].evaluate(t);const s=Ye(e,i),a=dr.interpolationFactor(this.interpolation,i,e[s],e[s+1]),o=r[s].evaluate(t),l=r[s+1].evaluate(t);return "interpolate"===this.operator?Qe[this.type.kind.toLowerCase()](o,l,a):"interpolate-hcl"===this.operator?hr.reverse(hr.interpolate(hr.forward(o),hr.forward(l),a)):cr.reverse(cr.interpolate(cr.forward(o),cr.forward(l),a))}eachChild(t){t(this.input);for(const e of this.outputs)t(e);}outputDefined(){return this.outputs.every(t=>t.outputDefined())}serialize(){let t;t="linear"===this.interpolation.name?["linear"]:"exponential"===this.interpolation.name?1===this.interpolation.base?["linear"]:["exponential",this.interpolation.base]:["cubic-bezier"].concat(this.interpolation.controlPoints);const e=[this.operator,t,this.input.serialize()];for(let t=0;t<this.labels.length;t++)e.push(this.labels[t],this.outputs[t].serialize());return e}}function fr(t,e,r,i){const n=i-r,s=t-r;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}class yr{constructor(t,e){this.type=t,this.args=e;}static parse(t,e){if(t.length<2)return e.error("Expectected at least one argument.");let r=null;const i=e.expectedType;i&&"value"!==i.kind&&(r=i);const n=[];for(const i of t.slice(1)){const t=e.parse(i,1+n.length,r,void 0,{typeAnnotation:"omit"});if(!t)return null;r=r||t.type,n.push(t);}const s=i&&n.some(t=>ie(i,t.type));return new yr(s?Yt:r,n)}evaluate(t){let e,r=null,i=0;for(const n of this.args)if(i++,r=n.evaluate(t),r&&r instanceof pe&&!r.available&&(e||(e=r.name),r=null,i===this.args.length&&(r=e)),null!==r)break;return r}eachChild(t){this.args.forEach(t);}outputDefined(){return this.args.every(t=>t.outputDefined())}serialize(){const t=["coalesce"];return this.eachChild(e=>{t.push(e.serialize());}),t}}class mr{constructor(t,e){this.type=e.type,this.bindings=[].concat(t),this.result=e;}evaluate(t){return this.result.evaluate(t)}eachChild(t){for(const e of this.bindings)t(e[1]);t(this.result);}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found ${t.length-1} instead.`);const r=[];for(let i=1;i<t.length-1;i+=2){const n=t[i];if("string"!=typeof n)return e.error(`Expected string, but found ${typeof n} instead.`,i);if(/[^a-zA-Z0-9_]/.test(n))return e.error("Variable names must contain only alphanumeric characters or '_'.",i);const s=e.parse(t[i+1],i+1);if(!s)return null;r.push([n,s]);}const i=e.parse(t[t.length-1],t.length-1,e.expectedType,r);return i?new mr(r,i):null}outputDefined(){return this.result.outputDefined()}serialize(){const t=["let"];for(const[e,r]of this.bindings)t.push(e,r.serialize());return t.push(this.result.serialize()),t}}class gr{constructor(t,e,r){this.type=t,this.index=e,this.input=r;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Gt),i=e.parse(t[2],2,te(e.expectedType||Yt));return r&&i?new gr(i.type.itemType,r,i):null}evaluate(t){const e=this.index.evaluate(t),r=this.input.evaluate(t);if(e<0)throw new xe(`Array index out of bounds: ${e} < 0.`);if(e>=r.length)throw new xe(`Array index out of bounds: ${e} > ${r.length-1}.`);if(e!==Math.floor(e))throw new xe(`Array index must be an integer, but found ${e} instead.`);return r[e]}eachChild(t){t(this.index),t(this.input);}outputDefined(){return !1}serialize(){return ["at",this.index.serialize(),this.input.serialize()]}}class xr{constructor(t,e){this.type=Xt,this.needle=t,this.haystack=e;}static parse(t,e){if(3!==t.length)return e.error(`Expected 2 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Yt),i=e.parse(t[2],2,Yt);return r&&i?ne(r.type,[Xt,Zt,Gt,jt,Yt])?new xr(r,i):e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ee(r.type)} instead`):null}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!r)return !1;if(!se(e,["boolean","string","number","null"]))throw new xe(`Expected first argument to be of type boolean, string, number or null, but found ${ee(ye(e))} instead.`);if(!se(r,["string","array"]))throw new xe(`Expected second argument to be of type array or string, but found ${ee(ye(r))} instead.`);return r.indexOf(e)>=0}eachChild(t){t(this.needle),t(this.haystack);}outputDefined(){return !0}serialize(){return ["in",this.needle.serialize(),this.haystack.serialize()]}}class vr{constructor(t,e,r){this.type=Gt,this.needle=t,this.haystack=e,this.fromIndex=r;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Yt),i=e.parse(t[2],2,Yt);if(!r||!i)return null;if(!ne(r.type,[Xt,Zt,Gt,jt,Yt]))return e.error(`Expected first argument to be of type boolean, string, number or null, but found ${ee(r.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Gt);return n?new vr(r,i,n):null}return new vr(r,i)}evaluate(t){const e=this.needle.evaluate(t),r=this.haystack.evaluate(t);if(!se(e,["boolean","string","number","null"]))throw new xe(`Expected first argument to be of type boolean, string, number or null, but found ${ee(ye(e))} instead.`);if(!se(r,["string","array"]))throw new xe(`Expected second argument to be of type array or string, but found ${ee(ye(r))} instead.`);if(this.fromIndex){const i=this.fromIndex.evaluate(t);return r.indexOf(e,i)}return r.indexOf(e)}eachChild(t){t(this.needle),t(this.haystack),this.fromIndex&&t(this.fromIndex);}outputDefined(){return !1}serialize(){if(null!=this.fromIndex&&void 0!==this.fromIndex){const t=this.fromIndex.serialize();return ["index-of",this.needle.serialize(),this.haystack.serialize(),t]}return ["index-of",this.needle.serialize(),this.haystack.serialize()]}}class br{constructor(t,e,r,i,n,s){this.inputType=t,this.type=e,this.input=r,this.cases=i,this.outputs=n,this.otherwise=s;}static parse(t,e){if(t.length<5)return e.error(`Expected at least 4 arguments, but found only ${t.length-1}.`);if(t.length%2!=1)return e.error("Expected an even number of arguments.");let r,i;e.expectedType&&"value"!==e.expectedType.kind&&(i=e.expectedType);const n={},s=[];for(let a=2;a<t.length-1;a+=2){let o=t[a];const l=t[a+1];Array.isArray(o)||(o=[o]);const u=e.concat(a);if(0===o.length)return u.error("Expected at least one branch label.");for(const t of o){if("number"!=typeof t&&"string"!=typeof t)return u.error("Branch labels must be numbers or strings.");if("number"==typeof t&&Math.abs(t)>Number.MAX_SAFE_INTEGER)return u.error(`Branch labels must be integers no larger than ${Number.MAX_SAFE_INTEGER}.`);if("number"==typeof t&&Math.floor(t)!==t)return u.error("Numeric branch labels must be integer values.");if(r){if(u.checkSubtype(r,ye(t)))return null}else r=ye(t);if(void 0!==n[String(t)])return u.error("Branch labels must be unique.");n[String(t)]=s.length;}const c=e.parse(l,a,i);if(!c)return null;i=i||c.type,s.push(c);}const a=e.parse(t[1],1,Yt);if(!a)return null;const o=e.parse(t[t.length-1],t.length-1,i);return o?"value"!==a.type.kind&&e.concat(1).checkSubtype(r,a.type)?null:new br(r,i,a,n,s,o):null}evaluate(t){const e=this.input.evaluate(t);return (ye(e)===this.inputType&&this.outputs[this.cases[e]]||this.otherwise).evaluate(t)}eachChild(t){t(this.input),this.outputs.forEach(t),t(this.otherwise);}outputDefined(){return this.outputs.every(t=>t.outputDefined())&&this.otherwise.outputDefined()}serialize(){const t=["match",this.input.serialize()],e=Object.keys(this.cases).sort(),r=[],i={};for(const t of e){const e=i[this.cases[t]];void 0===e?(i[this.cases[t]]=r.length,r.push([this.cases[t],[t]])):r[e][1].push(t);}const n=t=>"number"===this.inputType.kind?Number(t):t;for(const[e,i]of r)t.push(1===i.length?n(i[0]):i.map(n)),t.push(this.outputs[e].serialize());return t.push(this.otherwise.serialize()),t}}class wr{constructor(t,e,r){this.type=t,this.branches=e,this.otherwise=r;}static parse(t,e){if(t.length<4)return e.error(`Expected at least 3 arguments, but found only ${t.length-1}.`);if(t.length%2!=0)return e.error("Expected an odd number of arguments.");let r;e.expectedType&&"value"!==e.expectedType.kind&&(r=e.expectedType);const i=[];for(let n=1;n<t.length-1;n+=2){const s=e.parse(t[n],n,Xt);if(!s)return null;const a=e.parse(t[n+1],n+1,r);if(!a)return null;i.push([s,a]),r=r||a.type;}const n=e.parse(t[t.length-1],t.length-1,r);return n?new wr(r,i,n):null}evaluate(t){for(const[e,r]of this.branches)if(e.evaluate(t))return r.evaluate(t);return this.otherwise.evaluate(t)}eachChild(t){for(const[e,r]of this.branches)t(e),t(r);t(this.otherwise);}outputDefined(){return this.branches.every(([t,e])=>e.outputDefined())&&this.otherwise.outputDefined()}serialize(){const t=["case"];return this.eachChild(e=>{t.push(e.serialize());}),t}}class _r{constructor(t,e,r,i){this.type=t,this.input=e,this.beginIndex=r,this.endIndex=i;}static parse(t,e){if(t.length<=2||t.length>=5)return e.error(`Expected 3 or 4 arguments, but found ${t.length-1} instead.`);const r=e.parse(t[1],1,Yt),i=e.parse(t[2],2,Gt);if(!r||!i)return null;if(!ne(r.type,[te(Yt),Zt,Yt]))return e.error(`Expected first argument to be of type array or string, but found ${ee(r.type)} instead`);if(4===t.length){const n=e.parse(t[3],3,Gt);return n?new _r(r.type,r,i,n):null}return new _r(r.type,r,i)}evaluate(t){const e=this.input.evaluate(t),r=this.beginIndex.evaluate(t);if(!se(e,["string","array"]))throw new xe(`Expected first argument to be of type array or string, but found ${ee(ye(e))} instead.`);if(this.endIndex){const i=this.endIndex.evaluate(t);return e.slice(r,i)}return e.slice(r)}eachChild(t){t(this.input),t(this.beginIndex),this.endIndex&&t(this.endIndex);}outputDefined(){return !1}serialize(){if(null!=this.endIndex&&void 0!==this.endIndex){const t=this.endIndex.serialize();return ["slice",this.input.serialize(),this.beginIndex.serialize(),t]}return ["slice",this.input.serialize(),this.beginIndex.serialize()]}}function kr(t,e){return "=="===t||"!="===t?"boolean"===e.kind||"string"===e.kind||"number"===e.kind||"null"===e.kind||"value"===e.kind:"string"===e.kind||"number"===e.kind||"value"===e.kind}function Ar(t,e,r,i){return 0===i.compare(e,r)}function Sr(t,e,r){const i="=="!==t&&"!="!==t;return class n{constructor(t,e,r){this.type=Xt,this.lhs=t,this.rhs=e,this.collator=r,this.hasUntypedArgument="value"===t.type.kind||"value"===e.type.kind;}static parse(t,e){if(3!==t.length&&4!==t.length)return e.error("Expected two or three arguments.");const r=t[0];let s=e.parse(t[1],1,Yt);if(!s)return null;if(!kr(r,s.type))return e.concat(1).error(`"${r}" comparisons are not supported for type '${ee(s.type)}'.`);let a=e.parse(t[2],2,Yt);if(!a)return null;if(!kr(r,a.type))return e.concat(2).error(`"${r}" comparisons are not supported for type '${ee(a.type)}'.`);if(s.type.kind!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error(`Cannot compare types '${ee(s.type)}' and '${ee(a.type)}'.`);i&&("value"===s.type.kind&&"value"!==a.type.kind?s=new be(a.type,[s]):"value"!==s.type.kind&&"value"===a.type.kind&&(a=new be(s.type,[a])));let o=null;if(4===t.length){if("string"!==s.type.kind&&"string"!==a.type.kind&&"value"!==s.type.kind&&"value"!==a.type.kind)return e.error("Cannot use collator to compare non-string types.");if(o=e.parse(t[3],3,Wt),!o)return null}return new n(s,a,o)}evaluate(n){const s=this.lhs.evaluate(n),a=this.rhs.evaluate(n);if(i&&this.hasUntypedArgument){const e=ye(s),r=ye(a);if(e.kind!==r.kind||"string"!==e.kind&&"number"!==e.kind)throw new xe(`Expected arguments for "${t}" to be (string, string) or (number, number), but found (${e.kind}, ${r.kind}) instead.`)}if(this.collator&&!i&&this.hasUntypedArgument){const t=ye(s),r=ye(a);if("string"!==t.kind||"string"!==r.kind)return e(n,s,a)}return this.collator?r(n,s,a,this.collator.evaluate(n)):e(n,s,a)}eachChild(t){t(this.lhs),t(this.rhs),this.collator&&t(this.collator);}outputDefined(){return !0}serialize(){const e=[t];return this.eachChild(t=>{e.push(t.serialize());}),e}}}const Ir=Sr("==",(function(t,e,r){return e===r}),Ar),Tr=Sr("!=",(function(t,e,r){return e!==r}),(function(t,e,r,i){return !Ar(0,e,r,i)})),zr=Sr("<",(function(t,e,r){return e<r}),(function(t,e,r,i){return i.compare(e,r)<0})),Er=Sr(">",(function(t,e,r){return e>r}),(function(t,e,r,i){return i.compare(e,r)>0})),Mr=Sr("<=",(function(t,e,r){return e<=r}),(function(t,e,r,i){return i.compare(e,r)<=0}));class Br{constructor(t,e,r,i,n){this.type=Zt,this.number=t,this.locale=e,this.currency=r,this.minFractionDigits=i,this.maxFractionDigits=n;}static parse(t,e){if(3!==t.length)return e.error("Expected two arguments.");const r=e.parse(t[1],1,Gt);if(!r)return null;const i=t[2];if("object"!=typeof i||Array.isArray(i))return e.error("NumberFormat options argument must be an object.");let n=null;if(i.locale&&(n=e.parse(i.locale,1,Zt),!n))return null;let s=null;if(i.currency&&(s=e.parse(i.currency,1,Zt),!s))return null;let a=null;if(i["min-fraction-digits"]&&(a=e.parse(i["min-fraction-digits"],1,Gt),!a))return null;let o=null;return i["max-fraction-digits"]&&(o=e.parse(i["max-fraction-digits"],1,Gt),!o)?null:new Br(r,n,s,a,o)}evaluate(t){return new Intl.NumberFormat(this.locale?this.locale.evaluate(t):[],{style:this.currency?"currency":"decimal",currency:this.currency?this.currency.evaluate(t):void 0,minimumFractionDigits:this.minFractionDigits?this.minFractionDigits.evaluate(t):void 0,maximumFractionDigits:this.maxFractionDigits?this.maxFractionDigits.evaluate(t):void 0}).format(this.number.evaluate(t))}eachChild(t){t(this.number),this.locale&&t(this.locale),this.currency&&t(this.currency),this.minFractionDigits&&t(this.minFractionDigits),this.maxFractionDigits&&t(this.maxFractionDigits);}outputDefined(){return !1}serialize(){const t={};return this.locale&&(t.locale=this.locale.serialize()),this.currency&&(t.currency=this.currency.serialize()),this.minFractionDigits&&(t["min-fraction-digits"]=this.minFractionDigits.serialize()),this.maxFractionDigits&&(t["max-fraction-digits"]=this.maxFractionDigits.serialize()),["number-format",this.number.serialize(),t]}}class Dr{constructor(t){this.type=Gt,this.input=t;}static parse(t,e){if(2!==t.length)return e.error(`Expected 1 argument, but found ${t.length-1} instead.`);const r=e.parse(t[1],1);return r?"array"!==r.type.kind&&"string"!==r.type.kind&&"value"!==r.type.kind?e.error(`Expected argument of type string or array, but found ${ee(r.type)} instead.`):new Dr(r):null}evaluate(t){const e=this.input.evaluate(t);if("string"==typeof e)return e.length;if(Array.isArray(e))return e.length;throw new xe(`Expected value to be of type string or array, but found ${ee(ye(e))} instead.`)}eachChild(t){t(this.input);}outputDefined(){return !1}serialize(){const t=["length"];return this.eachChild(e=>{t.push(e.serialize());}),t}}const Cr={"==":Ir,"!=":Tr,">":Er,"<":zr,">=":Sr(">=",(function(t,e,r){return e>=r}),(function(t,e,r,i){return i.compare(e,r)>=0})),"<=":Mr,array:be,at:gr,boolean:be,case:wr,coalesce:yr,collator:ze,format:we,image:_e,in:xr,"index-of":vr,interpolate:dr,"interpolate-hcl":dr,"interpolate-lab":dr,length:Dr,let:mr,literal:ge,match:br,number:be,"number-format":Br,object:be,slice:_r,step:We,string:be,"to-boolean":Ae,"to-color":Ae,"to-number":Ae,"to-string":Ae,var:Ke,within:je};function Pr(t,[e,r,i,n]){e=e.evaluate(t),r=r.evaluate(t),i=i.evaluate(t);const s=n?n.evaluate(t):1,a=de(e,r,i,s);if(a)throw new xe(a);return new le(e/255*s,r/255*s,i/255*s,s)}function Vr(t,e){return t in e}function Fr(t,e){const r=e[t];return void 0===r?null:r}function Rr(t){return {type:t}}function Lr(t){return {result:"success",value:t}}function Ur(t){return {result:"error",value:t}}function Or(t){return "data-driven"===t["property-type"]||"cross-faded-data-driven"===t["property-type"]}function $r(t){return !!t.expression&&t.expression.parameters.indexOf("zoom")>-1}function qr(t){return !!t.expression&&t.expression.interpolated}function Nr(t){return t instanceof Number?"number":t instanceof String?"string":t instanceof Boolean?"boolean":Array.isArray(t)?"array":null===t?"null":typeof t}function jr(t){return "object"==typeof t&&null!==t&&!Array.isArray(t)}function Gr(t){return t}function Zr(t,e,r){return void 0!==t?t:void 0!==e?e:void 0!==r?r:void 0}function Xr(t,e,r,i,n){return Zr(typeof r===n?i[r]:void 0,t.default,e.default)}function Kr(t,e,r){if("number"!==Nr(r))return Zr(t.default,e.default);const i=t.stops.length;if(1===i)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[i-1][0])return t.stops[i-1][1];const n=Ye(t.stops.map(t=>t[0]),r);return t.stops[n][1]}function Hr(t,e,r){const i=void 0!==t.base?t.base:1;if("number"!==Nr(r))return Zr(t.default,e.default);const n=t.stops.length;if(1===n)return t.stops[0][1];if(r<=t.stops[0][0])return t.stops[0][1];if(r>=t.stops[n-1][0])return t.stops[n-1][1];const s=Ye(t.stops.map(t=>t[0]),r),a=function(t,e,r,i){const n=i-r,s=t-r;return 0===n?0:1===e?s/n:(Math.pow(e,s)-1)/(Math.pow(e,n)-1)}(r,i,t.stops[s][0],t.stops[s+1][0]),o=t.stops[s][1],l=t.stops[s+1][1];let u=Qe[e.type]||Gr;if(t.colorSpace&&"rgb"!==t.colorSpace){const e=pr[t.colorSpace];u=(t,r)=>e.reverse(e.interpolate(e.forward(t),e.forward(r),a));}return "function"==typeof o.evaluate?{evaluate(...t){const e=o.evaluate.apply(void 0,t),r=l.evaluate.apply(void 0,t);if(void 0!==e&&void 0!==r)return u(e,r,a)}}:u(o,l,a)}function Yr(t,e,r){return "color"===e.type?r=le.parse(r):"formatted"===e.type?r=he.fromString(r.toString()):"resolvedImage"===e.type?r=pe.fromString(r.toString()):Nr(r)===e.type||"enum"===e.type&&e.values[r]||(r=void 0),Zr(r,t.default,e.default)}Te.register(Cr,{error:[{kind:"error"},[Zt],(t,[e])=>{throw new xe(e.evaluate(t))}],typeof:[Zt,[Yt],(t,[e])=>ee(ye(e.evaluate(t)))],"to-rgba":[te(Gt,4),[Kt],(t,[e])=>e.evaluate(t).toArray()],rgb:[Kt,[Gt,Gt,Gt],Pr],rgba:[Kt,[Gt,Gt,Gt,Gt],Pr],has:{type:Xt,overloads:[[[Zt],(t,[e])=>Vr(e.evaluate(t),t.properties())],[[Zt,Ht],(t,[e,r])=>Vr(e.evaluate(t),r.evaluate(t))]]},get:{type:Yt,overloads:[[[Zt],(t,[e])=>Fr(e.evaluate(t),t.properties())],[[Zt,Ht],(t,[e,r])=>Fr(e.evaluate(t),r.evaluate(t))]]},"feature-state":[Yt,[Zt],(t,[e])=>Fr(e.evaluate(t),t.featureState||{})],properties:[Ht,[],t=>t.properties()],"geometry-type":[Zt,[],t=>t.geometryType()],id:[Yt,[],t=>t.id()],zoom:[Gt,[],t=>t.globals.zoom],"heatmap-density":[Gt,[],t=>t.globals.heatmapDensity||0],"line-progress":[Gt,[],t=>t.globals.lineProgress||0],"sky-radial-progress":[Gt,[],t=>t.globals.skyRadialProgress||0],accumulated:[Yt,[],t=>void 0===t.globals.accumulated?null:t.globals.accumulated],"+":[Gt,Rr(Gt),(t,e)=>{let r=0;for(const i of e)r+=i.evaluate(t);return r}],"*":[Gt,Rr(Gt),(t,e)=>{let r=1;for(const i of e)r*=i.evaluate(t);return r}],"-":{type:Gt,overloads:[[[Gt,Gt],(t,[e,r])=>e.evaluate(t)-r.evaluate(t)],[[Gt],(t,[e])=>-e.evaluate(t)]]},"/":[Gt,[Gt,Gt],(t,[e,r])=>e.evaluate(t)/r.evaluate(t)],"%":[Gt,[Gt,Gt],(t,[e,r])=>e.evaluate(t)%r.evaluate(t)],ln2:[Gt,[],()=>Math.LN2],pi:[Gt,[],()=>Math.PI],e:[Gt,[],()=>Math.E],"^":[Gt,[Gt,Gt],(t,[e,r])=>Math.pow(e.evaluate(t),r.evaluate(t))],sqrt:[Gt,[Gt],(t,[e])=>Math.sqrt(e.evaluate(t))],log10:[Gt,[Gt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN10],ln:[Gt,[Gt],(t,[e])=>Math.log(e.evaluate(t))],log2:[Gt,[Gt],(t,[e])=>Math.log(e.evaluate(t))/Math.LN2],sin:[Gt,[Gt],(t,[e])=>Math.sin(e.evaluate(t))],cos:[Gt,[Gt],(t,[e])=>Math.cos(e.evaluate(t))],tan:[Gt,[Gt],(t,[e])=>Math.tan(e.evaluate(t))],asin:[Gt,[Gt],(t,[e])=>Math.asin(e.evaluate(t))],acos:[Gt,[Gt],(t,[e])=>Math.acos(e.evaluate(t))],atan:[Gt,[Gt],(t,[e])=>Math.atan(e.evaluate(t))],min:[Gt,Rr(Gt),(t,e)=>Math.min(...e.map(e=>e.evaluate(t)))],max:[Gt,Rr(Gt),(t,e)=>Math.max(...e.map(e=>e.evaluate(t)))],abs:[Gt,[Gt],(t,[e])=>Math.abs(e.evaluate(t))],round:[Gt,[Gt],(t,[e])=>{const r=e.evaluate(t);return r<0?-Math.round(-r):Math.round(r)}],floor:[Gt,[Gt],(t,[e])=>Math.floor(e.evaluate(t))],ceil:[Gt,[Gt],(t,[e])=>Math.ceil(e.evaluate(t))],"filter-==":[Xt,[Zt,Yt],(t,[e,r])=>t.properties()[e.value]===r.value],"filter-id-==":[Xt,[Yt],(t,[e])=>t.id()===e.value],"filter-type-==":[Xt,[Zt],(t,[e])=>t.geometryType()===e.value],"filter-<":[Xt,[Zt,Yt],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i<n}],"filter-id-<":[Xt,[Yt],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r<i}],"filter->":[Xt,[Zt,Yt],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i>n}],"filter-id->":[Xt,[Yt],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r>i}],"filter-<=":[Xt,[Zt,Yt],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i<=n}],"filter-id-<=":[Xt,[Yt],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r<=i}],"filter->=":[Xt,[Zt,Yt],(t,[e,r])=>{const i=t.properties()[e.value],n=r.value;return typeof i==typeof n&&i>=n}],"filter-id->=":[Xt,[Yt],(t,[e])=>{const r=t.id(),i=e.value;return typeof r==typeof i&&r>=i}],"filter-has":[Xt,[Yt],(t,[e])=>e.value in t.properties()],"filter-has-id":[Xt,[],t=>null!==t.id()&&void 0!==t.id()],"filter-type-in":[Xt,[te(Zt)],(t,[e])=>e.value.indexOf(t.geometryType())>=0],"filter-id-in":[Xt,[te(Yt)],(t,[e])=>e.value.indexOf(t.id())>=0],"filter-in-small":[Xt,[Zt,te(Yt)],(t,[e,r])=>r.value.indexOf(t.properties()[e.value])>=0],"filter-in-large":[Xt,[Zt,te(Yt)],(t,[e,r])=>function(t,e,r,i){for(;r<=i;){const n=r+i>>1;if(e[n]===t)return !0;e[n]>t?i=n-1:r=n+1;}return !1}(t.properties()[e.value],r.value,0,r.value.length-1)],all:{type:Xt,overloads:[[[Xt,Xt],(t,[e,r])=>e.evaluate(t)&&r.evaluate(t)],[Rr(Xt),(t,e)=>{for(const r of e)if(!r.evaluate(t))return !1;return !0}]]},any:{type:Xt,overloads:[[[Xt,Xt],(t,[e,r])=>e.evaluate(t)||r.evaluate(t)],[Rr(Xt),(t,e)=>{for(const r of e)if(r.evaluate(t))return !0;return !1}]]},"!":[Xt,[Xt],(t,[e])=>!e.evaluate(t)],"is-supported-script":[Xt,[Zt],(t,[e])=>{const r=t.globals&&t.globals.isSupportedScript;return !r||r(e.evaluate(t))}],upcase:[Zt,[Zt],(t,[e])=>e.evaluate(t).toUpperCase()],downcase:[Zt,[Zt],(t,[e])=>e.evaluate(t).toLowerCase()],concat:[Zt,Rr(Yt),(t,e)=>e.map(e=>me(e.evaluate(t))).join("")],"resolved-locale":[Zt,[Wt],(t,[e])=>e.evaluate(t).resolvedLocale()]});class Wr{constructor(t,e){this.expression=t,this._warningHistory={},this._evaluator=new Ie,this._defaultValue=e?function(t){return "color"===t.type&&jr(t.default)?new le(0,0,0,0):"color"===t.type?le.parse(t.default)||null:void 0===t.default?null:t.default}(e):null,this._enumValues=e&&"enum"===e.type?e.values:null;}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._evaluator.globals=t,this._evaluator.feature=e,this._evaluator.featureState=r,this._evaluator.canonical=i,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s,this.expression.evaluate(this._evaluator)}evaluate(t,e,r,i,n,s){this._evaluator.globals=t,this._evaluator.feature=e||null,this._evaluator.featureState=r||null,this._evaluator.canonical=i,this._evaluator.availableImages=n||null,this._evaluator.formattedSection=s||null;try{const t=this.expression.evaluate(this._evaluator);if(null==t||"number"==typeof t&&t!=t)return this._defaultValue;if(this._enumValues&&!(t in this._enumValues))throw new xe(`Expected value to be one of ${Object.keys(this._enumValues).map(t=>JSON.stringify(t)).join(", ")}, but found ${JSON.stringify(t)} instead.`);return t}catch(t){return this._warningHistory[t.message]||(this._warningHistory[t.message]=!0,"undefined"!=typeof console&&console.warn(t.message)),this._defaultValue}}}function Jr(t){return Array.isArray(t)&&t.length>0&&"string"==typeof t[0]&&t[0]in Cr}function Qr(t,e){const r=new He(Cr,[],e?function(t){const e={color:Kt,string:Zt,number:Gt,enum:Zt,boolean:Xt,formatted:Jt,resolvedImage:Qt};return "array"===t.type?te(e[t.value]||Yt,t.length):e[t.type]}(e):void 0),i=r.parse(t,void 0,void 0,void 0,e&&"string"===e.type?{typeAnnotation:"coerce"}:void 0);return i?Lr(new Wr(i,e)):Ur(r.errors)}class ti{constructor(t,e){this.kind=t,this._styleExpression=e,this.isStateDependent="constant"!==t&&!Ze(e.expression);}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,i,n,s)}evaluate(t,e,r,i,n,s){return this._styleExpression.evaluate(t,e,r,i,n,s)}}class ei{constructor(t,e,r,i){this.kind=t,this.zoomStops=r,this._styleExpression=e,this.isStateDependent="camera"!==t&&!Ze(e.expression),this.interpolationType=i;}evaluateWithoutErrorHandling(t,e,r,i,n,s){return this._styleExpression.evaluateWithoutErrorHandling(t,e,r,i,n,s)}evaluate(t,e,r,i,n,s){return this._styleExpression.evaluate(t,e,r,i,n,s)}interpolationFactor(t,e,r){return this.interpolationType?dr.interpolationFactor(this.interpolationType,t,e,r):0}}function ri(t,e){if("error"===(t=Qr(t,e)).result)return t;const r=t.value.expression,i=Ge(r);if(!i&&!Or(e))return Ur([new qt("","data expressions not supported")]);const n=Xe(r,["zoom"]);if(!n&&!$r(e))return Ur([new qt("","zoom expressions not supported")]);const s=function t(e){let r=null;if(e instanceof mr)r=t(e.result);else if(e instanceof yr){for(const i of e.args)if(r=t(i),r)break}else (e instanceof We||e instanceof dr)&&e.input instanceof Te&&"zoom"===e.input.name&&(r=e);return r instanceof qt||e.eachChild(e=>{const i=t(e);i instanceof qt?r=i:!r&&i?r=new qt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.'):r&&i&&r!==i&&(r=new qt("",'Only one zoom-based "step" or "interpolate" subexpression may be used in an expression.'));}),r}(r);return s||n?s instanceof qt?Ur([s]):s instanceof dr&&!qr(e)?Ur([new qt("",'"interpolate" expressions cannot be used with this property')]):Lr(s?new ei(i?"camera":"composite",t.value,s.labels,s instanceof dr?s.interpolation:void 0):new ti(i?"constant":"source",t.value)):Ur([new qt("",'"zoom" expression may only be used as input to a top-level "step" or "interpolate" expression.')])}class ii{constructor(t,e){this._parameters=t,this._specification=e,Ut(this,function t(e,r){const i="color"===r.type,n=e.stops&&"object"==typeof e.stops[0][0],s=n||!(n||void 0!==e.property),a=e.type||(qr(r)?"exponential":"interval");if(i&&((e=Ut({},e)).stops&&(e.stops=e.stops.map(t=>[t[0],le.parse(t[1])])),e.default=le.parse(e.default?e.default:r.default)),e.colorSpace&&"rgb"!==e.colorSpace&&!pr[e.colorSpace])throw new Error(`Unknown color space: ${e.colorSpace}`);let o,l,u;if("exponential"===a)o=Hr;else if("interval"===a)o=Kr;else if("categorical"===a){o=Xr,l=Object.create(null);for(const t of e.stops)l[t[0]]=t[1];u=typeof e.stops[0][0];}else {if("identity"!==a)throw new Error(`Unknown function type "${a}"`);o=Yr;}if(n){const i={},n=[];for(let t=0;t<e.stops.length;t++){const r=e.stops[t],s=r[0].zoom;void 0===i[s]&&(i[s]={zoom:s,type:e.type,property:e.property,default:e.default,stops:[]},n.push(s)),i[s].stops.push([r[0].value,r[1]]);}const s=[];for(const e of n)s.push([i[e].zoom,t(i[e],r)]);const a={name:"linear"};return {kind:"composite",interpolationType:a,interpolationFactor:dr.interpolationFactor.bind(void 0,a),zoomStops:s.map(t=>t[0]),evaluate:({zoom:t},i)=>Hr({stops:s,base:e.base},r,t).evaluate(t,i)}}if(s){const t="exponential"===a?{name:"exponential",base:void 0!==e.base?e.base:1}:null;return {kind:"camera",interpolationType:t,interpolationFactor:dr.interpolationFactor.bind(void 0,t),zoomStops:e.stops.map(t=>t[0]),evaluate:({zoom:t})=>o(e,r,t,l,u)}}return {kind:"source",evaluate(t,i){const n=i&&i.properties?i.properties[e.property]:void 0;return void 0===n?Zr(e.default,r.default):o(e,r,n,l,u)}}}(this._parameters,this._specification));}static deserialize(t){return new ii(t._parameters,t._specification)}static serialize(t){return {_parameters:t._parameters,_specification:t._specification}}}function ni(t){const e=t.key,r=t.value,i=t.valueSpec||{},n=t.objectElementValidators||{},s=t.style,a=t.styleSpec;let o=[];const l=Nr(r);if("object"!==l)return [new Rt(e,r,`object expected, ${l} found`)];for(const t in r){const l=t.split(".")[0],u=i[l]||i["*"];let c;if(n[l])c=n[l];else if(i[l])c=Mi;else if(n["*"])c=n["*"];else {if(!i["*"]){o.push(new Rt(e,r[t],`unknown property "${t}"`));continue}c=Mi;}o=o.concat(c({key:(e?`${e}.`:e)+t,value:r[t],valueSpec:u,style:s,styleSpec:a,object:r,objectKey:t},r));}for(const t in i)n[t]||i[t].required&&void 0===i[t].default&&void 0===r[t]&&o.push(new Rt(e,r,`missing required property "${t}"`));return o}function si(t){const e=t.value,r=t.valueSpec,i=t.style,n=t.styleSpec,s=t.key,a=t.arrayElementValidator||Mi;if("array"!==Nr(e))return [new Rt(s,e,`array expected, ${Nr(e)} found`)];if(r.length&&e.length!==r.length)return [new Rt(s,e,`array length ${r.length} expected, length ${e.length} found`)];if(r["min-length"]&&e.length<r["min-length"])return [new Rt(s,e,`array length at least ${r["min-length"]} expected, length ${e.length} found`)];let o={type:r.value,values:r.values,minimum:r.minimum,maximum:r.maximum};n.$version<7&&(o.function=r.function),"object"===Nr(r.value)&&(o=r.value);let l=[];for(let t=0;t<e.length;t++)l=l.concat(a({array:e,arrayIndex:t,value:e[t],valueSpec:o,style:i,styleSpec:n,key:`${s}[${t}]`}));return l}function ai(t){const e=t.key,r=t.value,i=t.valueSpec;let n=Nr(r);if("number"===n&&r!=r&&(n="NaN"),"number"!==n)return [new Rt(e,r,`number expected, ${n} found`)];if("minimum"in i){let n=i.minimum;if("array"===Nr(i.minimum)&&(n=i.minimum[t.arrayIndex]),r<n)return [new Rt(e,r,`${r} is less than the minimum value ${n}`)]}if("maximum"in i){let n=i.maximum;if("array"===Nr(i.maximum)&&(n=i.maximum[t.arrayIndex]),r>n)return [new Rt(e,r,`${r} is greater than the maximum value ${n}`)]}return []}function oi(t){const e=t.valueSpec,r=Ot(t.value.type);let i,n,s,a={};const o="categorical"!==r&&void 0===t.value.property,l=!o,u="array"===Nr(t.value.stops)&&"array"===Nr(t.value.stops[0])&&"object"===Nr(t.value.stops[0][0]),c=ni({key:t.key,value:t.value,valueSpec:t.styleSpec.function,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{stops:function(t){if("identity"===r)return [new Rt(t.key,t.value,'identity function may not have a "stops" property')];let e=[];const i=t.value;return e=e.concat(si({key:t.key,value:i,valueSpec:t.valueSpec,style:t.style,styleSpec:t.styleSpec,arrayElementValidator:h})),"array"===Nr(i)&&0===i.length&&e.push(new Rt(t.key,i,"array must have at least one stop")),e},default:function(t){return Mi({key:t.key,value:t.value,valueSpec:e,style:t.style,styleSpec:t.styleSpec})}}});return "identity"===r&&o&&c.push(new Rt(t.key,t.value,'missing required property "property"')),"identity"===r||t.value.stops||c.push(new Rt(t.key,t.value,'missing required property "stops"')),"exponential"===r&&t.valueSpec.expression&&!qr(t.valueSpec)&&c.push(new Rt(t.key,t.value,"exponential functions not supported")),t.styleSpec.$version>=8&&(l&&!Or(t.valueSpec)?c.push(new Rt(t.key,t.value,"property functions not supported")):o&&!$r(t.valueSpec)&&c.push(new Rt(t.key,t.value,"zoom functions not supported"))),"categorical"!==r&&!u||void 0!==t.value.property||c.push(new Rt(t.key,t.value,'"property" property is required')),c;function h(t){let r=[];const i=t.value,o=t.key;if("array"!==Nr(i))return [new Rt(o,i,`array expected, ${Nr(i)} found`)];if(2!==i.length)return [new Rt(o,i,`array length 2 expected, length ${i.length} found`)];if(u){if("object"!==Nr(i[0]))return [new Rt(o,i,`object expected, ${Nr(i[0])} found`)];if(void 0===i[0].zoom)return [new Rt(o,i,"object stop key must have zoom")];if(void 0===i[0].value)return [new Rt(o,i,"object stop key must have value")];if(s&&s>Ot(i[0].zoom))return [new Rt(o,i[0].zoom,"stop zoom values must appear in ascending order")];Ot(i[0].zoom)!==s&&(s=Ot(i[0].zoom),n=void 0,a={}),r=r.concat(ni({key:`${o}[0]`,value:i[0],valueSpec:{zoom:{}},style:t.style,styleSpec:t.styleSpec,objectElementValidators:{zoom:ai,value:p}}));}else r=r.concat(p({key:`${o}[0]`,value:i[0],valueSpec:{},style:t.style,styleSpec:t.styleSpec},i));return Jr($t(i[1]))?r.concat([new Rt(`${o}[1]`,i[1],"expressions are not allowed in function stops.")]):r.concat(Mi({key:`${o}[1]`,value:i[1],valueSpec:e,style:t.style,styleSpec:t.styleSpec}))}function p(t,s){const o=Nr(t.value),l=Ot(t.value),u=null!==t.value?t.value:s;if(i){if(o!==i)return [new Rt(t.key,u,`${o} stop domain type must match previous stop domain type ${i}`)]}else i=o;if("number"!==o&&"string"!==o&&"boolean"!==o)return [new Rt(t.key,u,"stop domain value must be a number, string, or boolean")];if("number"!==o&&"categorical"!==r){let i=`number expected, ${o} found`;return Or(e)&&void 0===r&&(i+='\nIf you intended to use a categorical function, specify `"type": "categorical"`.'),[new Rt(t.key,u,i)]}return "categorical"!==r||"number"!==o||isFinite(l)&&Math.floor(l)===l?"categorical"!==r&&"number"===o&&void 0!==n&&l<n?[new Rt(t.key,u,"stop domain values must appear in ascending order")]:(n=l,"categorical"===r&&l in a?[new Rt(t.key,u,"stop domain values must be unique")]:(a[l]=!0,[])):[new Rt(t.key,u,`integer expected, found ${l}`)]}}function li(t){const e=("property"===t.expressionContext?ri:Qr)($t(t.value),t.valueSpec);if("error"===e.result)return e.value.map(e=>new Rt(`${t.key}${e.key}`,t.value,e.message));const r=e.value.expression||e.value._styleExpression.expression;if("property"===t.expressionContext&&"text-font"===t.propertyKey&&!r.outputDefined())return [new Rt(t.key,t.value,`Invalid data expression for "${t.propertyKey}". Output values must be contained as literals within the expression.`)];if("property"===t.expressionContext&&"layout"===t.propertyType&&!Ze(r))return [new Rt(t.key,t.value,'"feature-state" data expressions are not supported with layout properties.')];if("filter"===t.expressionContext&&!Ze(r))return [new Rt(t.key,t.value,'"feature-state" data expressions are not supported with filters.')];if(t.expressionContext&&0===t.expressionContext.indexOf("cluster")){if(!Xe(r,["zoom","feature-state"]))return [new Rt(t.key,t.value,'"zoom" and "feature-state" expressions are not supported with cluster properties.')];if("cluster-initial"===t.expressionContext&&!Ge(r))return [new Rt(t.key,t.value,"Feature data expressions are not supported with initial expression part of cluster properties.")]}return []}function ui(t){const e=t.key,r=t.value,i=t.valueSpec,n=[];return Array.isArray(i.values)?-1===i.values.indexOf(Ot(r))&&n.push(new Rt(e,r,`expected one of [${i.values.join(", ")}], ${JSON.stringify(r)} found`)):-1===Object.keys(i.values).indexOf(Ot(r))&&n.push(new Rt(e,r,`expected one of [${Object.keys(i.values).join(", ")}], ${JSON.stringify(r)} found`)),n}function ci(t){if(!0===t||!1===t)return !0;if(!Array.isArray(t)||0===t.length)return !1;switch(t[0]){case"has":return t.length>=2&&"$id"!==t[1]&&"$type"!==t[1];case"in":return t.length>=3&&("string"!=typeof t[1]||Array.isArray(t[2]));case"!in":case"!has":case"none":return !1;case"==":case"!=":case">":case">=":case"<":case"<=":return 3!==t.length||Array.isArray(t[1])||Array.isArray(t[2]);case"any":case"all":for(const e of t.slice(1))if(!ci(e)&&"boolean"!=typeof e)return !1;return !0;default:return !0}}const hi={type:"boolean",default:!1,transition:!1,"property-type":"data-driven",expression:{interpolated:!1,parameters:["zoom","feature"]}};function pi(t){if(null==t)return {filter:()=>!0,needGeometry:!1};ci(t)||(t=fi(t));const e=Qr(t,hi);if("error"===e.result)throw new Error(e.value.map(t=>`${t.key}: ${t.message}`).join(", "));return {filter:(t,r,i)=>e.value.evaluate(t,r,{},i),needGeometry:function t(e){if(!Array.isArray(e))return !1;if("within"===e[0])return !0;for(let r=1;r<e.length;r++)if(t(e[r]))return !0;return !1}(t)}}function di(t,e){return t<e?-1:t>e?1:0}function fi(t){if(!t)return !0;const e=t[0];return t.length<=1?"any"!==e:"=="===e?yi(t[1],t[2],"=="):"!="===e?xi(yi(t[1],t[2],"==")):"<"===e||">"===e||"<="===e||">="===e?yi(t[1],t[2],e):"any"===e?(r=t.slice(1),["any"].concat(r.map(fi))):"all"===e?["all"].concat(t.slice(1).map(fi)):"none"===e?["all"].concat(t.slice(1).map(fi).map(xi)):"in"===e?mi(t[1],t.slice(2)):"!in"===e?xi(mi(t[1],t.slice(2))):"has"===e?gi(t[1]):"!has"===e?xi(gi(t[1])):"within"!==e||t;var r;}function yi(t,e,r){switch(t){case"$type":return [`filter-type-${r}`,e];case"$id":return [`filter-id-${r}`,e];default:return [`filter-${r}`,t,e]}}function mi(t,e){if(0===e.length)return !1;switch(t){case"$type":return ["filter-type-in",["literal",e]];case"$id":return ["filter-id-in",["literal",e]];default:return e.length>200&&!e.some(t=>typeof t!=typeof e[0])?["filter-in-large",t,["literal",e.sort(di)]]:["filter-in-small",t,["literal",e]]}}function gi(t){switch(t){case"$type":return !0;case"$id":return ["filter-has-id"];default:return ["filter-has",t]}}function xi(t){return ["!",t]}function vi(t){return ci($t(t.value))?li(Ut({},t,{expressionContext:"filter",valueSpec:{value:"boolean"}})):function t(e){const r=e.value,i=e.key;if("array"!==Nr(r))return [new Rt(i,r,`array expected, ${Nr(r)} found`)];const n=e.styleSpec;let s,a=[];if(r.length<1)return [new Rt(i,r,"filter array must have at least 1 element")];switch(a=a.concat(ui({key:`${i}[0]`,value:r[0],valueSpec:n.filter_operator,style:e.style,styleSpec:e.styleSpec})),Ot(r[0])){case"<":case"<=":case">":case">=":r.length>=2&&"$type"===Ot(r[1])&&a.push(new Rt(i,r,`"$type" cannot be use with operator "${r[0]}"`));case"==":case"!=":3!==r.length&&a.push(new Rt(i,r,`filter array for operator "${r[0]}" must have 3 elements`));case"in":case"!in":r.length>=2&&(s=Nr(r[1]),"string"!==s&&a.push(new Rt(`${i}[1]`,r[1],`string expected, ${s} found`)));for(let t=2;t<r.length;t++)s=Nr(r[t]),"$type"===Ot(r[1])?a=a.concat(ui({key:`${i}[${t}]`,value:r[t],valueSpec:n.geometry_type,style:e.style,styleSpec:e.styleSpec})):"string"!==s&&"number"!==s&&"boolean"!==s&&a.push(new Rt(`${i}[${t}]`,r[t],`string, number, or boolean expected, ${s} found`));break;case"any":case"all":case"none":for(let n=1;n<r.length;n++)a=a.concat(t({key:`${i}[${n}]`,value:r[n],style:e.style,styleSpec:e.styleSpec}));break;case"has":case"!has":s=Nr(r[1]),2!==r.length?a.push(new Rt(i,r,`filter array for "${r[0]}" operator must have 2 elements`)):"string"!==s&&a.push(new Rt(`${i}[1]`,r[1],`string expected, ${s} found`));break;case"within":s=Nr(r[1]),2!==r.length?a.push(new Rt(i,r,`filter array for "${r[0]}" operator must have 2 elements`)):"object"!==s&&a.push(new Rt(`${i}[1]`,r[1],`object expected, ${s} found`));}return a}(t)}function bi(t,e){const r=t.key,i=t.style,n=t.styleSpec,s=t.value,a=t.objectKey,o=n[`${e}_${t.layerType}`];if(!o)return [];const l=a.match(/^(.*)-transition$/);if("paint"===e&&l&&o[l[1]]&&o[l[1]].transition)return Mi({key:r,value:s,valueSpec:n.transition,style:i,styleSpec:n});const u=t.valueSpec||o[a];if(!u)return [new Rt(r,s,`unknown property "${a}"`)];let c;if("string"===Nr(s)&&Or(u)&&!u.tokens&&(c=/^{([^}]+)}$/.exec(s)))return [new Rt(r,s,`"${a}" does not support interpolation syntax\n`+`Use an identity property function instead: \`{ "type": "identity", "property": ${JSON.stringify(c[1])} }\`.`)];const h=[];return "symbol"===t.layerType&&("text-field"===a&&i&&!i.glyphs&&h.push(new Rt(r,s,'use of "text-field" requires a style "glyphs" property')),"text-font"===a&&jr($t(s))&&"identity"===Ot(s.type)&&h.push(new Rt(r,s,'"text-font" does not support identity functions'))),h.concat(Mi({key:t.key,value:s,valueSpec:u,style:i,styleSpec:n,expressionContext:"property",propertyType:e,propertyKey:a}))}function wi(t){return bi(t,"paint")}function _i(t){return bi(t,"layout")}function ki(t){let e=[];const r=t.value,i=t.key,n=t.style,s=t.styleSpec;r.type||r.ref||e.push(new Rt(i,r,'either "type" or "ref" is required'));let a=Ot(r.type);const o=Ot(r.ref);if(r.id){const s=Ot(r.id);for(let a=0;a<t.arrayIndex;a++){const t=n.layers[a];Ot(t.id)===s&&e.push(new Rt(i,r.id,`duplicate layer id "${r.id}", previously used at line ${t.id.__line__}`));}}if("ref"in r){let t;["type","source","source-layer","filter","layout"].forEach(t=>{t in r&&e.push(new Rt(i,r[t],`"${t}" is prohibited for ref layers`));}),n.layers.forEach(e=>{Ot(e.id)===o&&(t=e);}),t?t.ref?e.push(new Rt(i,r.ref,"ref cannot reference another ref layer")):a=Ot(t.type):e.push(new Rt(i,r.ref,`ref layer "${o}" not found`));}else if("background"!==a&&"sky"!==a)if(r.source){const t=n.sources&&n.sources[r.source],s=t&&Ot(t.type);t?"vector"===s&&"raster"===a?e.push(new Rt(i,r.source,`layer "${r.id}" requires a raster source`)):"raster"===s&&"raster"!==a?e.push(new Rt(i,r.source,`layer "${r.id}" requires a vector source`)):"vector"!==s||r["source-layer"]?"raster-dem"===s&&"hillshade"!==a?e.push(new Rt(i,r.source,"raster-dem source can only be used with layer type 'hillshade'.")):"line"!==a||!r.paint||!r.paint["line-gradient"]||"geojson"===s&&t.lineMetrics||e.push(new Rt(i,r,`layer "${r.id}" specifies a line-gradient, which requires a GeoJSON source with \`lineMetrics\` enabled.`)):e.push(new Rt(i,r,`layer "${r.id}" must specify a "source-layer"`)):e.push(new Rt(i,r.source,`source "${r.source}" not found`));}else e.push(new Rt(i,r,'missing required property "source"'));return e=e.concat(ni({key:i,value:r,valueSpec:s.layer,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":()=>[],type:()=>Mi({key:`${i}.type`,value:r.type,valueSpec:s.layer.type,style:t.style,styleSpec:t.styleSpec,object:r,objectKey:"type"}),filter:vi,layout:t=>ni({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>_i(Ut({layerType:a},t))}}),paint:t=>ni({layer:r,key:t.key,value:t.value,style:t.style,styleSpec:t.styleSpec,objectElementValidators:{"*":t=>wi(Ut({layerType:a},t))}})}})),e}function Ai(t){const e=t.value,r=t.key,i=Nr(e);return "string"!==i?[new Rt(r,e,`string expected, ${i} found`)]:[]}const Si={promoteId:function({key:t,value:e}){if("string"===Nr(e))return Ai({key:t,value:e});{const r=[];for(const i in e)r.push(...Ai({key:`${t}.${i}`,value:e[i]}));return r}}};function Ii(t){const e=t.value,r=t.key,i=t.styleSpec,n=t.style;if(!e.type)return [new Rt(r,e,'"type" is required')];const s=Ot(e.type);let a;switch(s){case"vector":case"raster":case"raster-dem":return a=ni({key:r,value:e,valueSpec:i[`source_${s.replace("-","_")}`],style:t.style,styleSpec:i,objectElementValidators:Si}),a;case"geojson":if(a=ni({key:r,value:e,valueSpec:i.source_geojson,style:n,styleSpec:i,objectElementValidators:Si}),e.cluster)for(const t in e.clusterProperties){const[i,n]=e.clusterProperties[t],s="string"==typeof i?[i,["accumulated"],["get",t]]:i;a.push(...li({key:`${r}.${t}.map`,value:n,expressionContext:"cluster-map"})),a.push(...li({key:`${r}.${t}.reduce`,value:s,expressionContext:"cluster-reduce"}));}return a;case"video":return ni({key:r,value:e,valueSpec:i.source_video,style:n,styleSpec:i});case"image":return ni({key:r,value:e,valueSpec:i.source_image,style:n,styleSpec:i});case"canvas":return [new Rt(r,null,"Please use runtime APIs to add canvas sources, rather than including them in stylesheets.","source.canvas")];default:return ui({key:`${r}.type`,value:e.type,valueSpec:{values:["vector","raster","raster-dem","geojson","video","image"]},style:n,styleSpec:i})}}function Ti(t){const e=t.value,r=t.styleSpec,i=r.light,n=t.style;let s=[];const a=Nr(e);if(void 0===e)return s;if("object"!==a)return s=s.concat([new Rt("light",e,`object expected, ${a} found`)]),s;for(const t in e){const a=t.match(/^(.*)-transition$/);s=s.concat(a&&i[a[1]]&&i[a[1]].transition?Mi({key:t,value:e[t],valueSpec:r.transition,style:n,styleSpec:r}):i[t]?Mi({key:t,value:e[t],valueSpec:i[t],style:n,styleSpec:r}):[new Rt(t,e[t],`unknown property "${t}"`)]);}return s}function zi(t){const e=t.value,r=t.key,i=t.style,n=t.styleSpec,s=n.terrain;let a=[];const o=Nr(e);if(void 0===e)return a;if("object"!==o)return a=a.concat([new Rt("terrain",e,`object expected, ${o} found`)]),a;for(const t in e){const r=t.match(/^(.*)-transition$/);a=a.concat(r&&s[r[1]]&&s[r[1]].transition?Mi({key:t,value:e[t],valueSpec:n.transition,style:i,styleSpec:n}):s[t]?Mi({key:t,value:e[t],valueSpec:s[t],style:i,styleSpec:n}):[new Rt(t,e[t],`unknown property "${t}"`)]);}if(e.source){const t=i.sources&&i.sources[e.source],n=t&&Ot(t.type);t?"raster-dem"!==n&&a.push(new Rt(r,e.source,`terrain cannot be used with a source of type ${n}, it only be used with a "raster-dem" source type`)):a.push(new Rt(r,e.source,`source "${e.source}" not found`));}else a.push(new Rt(r,e,'terrain is missing required property "source"'));return a}const Ei={"*":()=>[],array:si,boolean:function(t){const e=t.value,r=t.key,i=Nr(e);return "boolean"!==i?[new Rt(r,e,`boolean expected, ${i} found`)]:[]},number:ai,color:function(t){const e=t.key,r=t.value,i=Nr(r);return "string"!==i?[new Rt(e,r,`color expected, ${i} found`)]:null===oe(r)?[new Rt(e,r,`color expected, "${r}" found`)]:[]},constants:Lt,enum:ui,filter:vi,function:oi,layer:ki,object:ni,source:Ii,light:Ti,terrain:zi,string:Ai,formatted:function(t){return 0===Ai(t).length?[]:li(t)},resolvedImage:function(t){return 0===Ai(t).length?[]:li(t)}};function Mi(t){const e=t.value,r=t.valueSpec,i=t.styleSpec;return r.expression&&jr(Ot(e))?oi(t):r.expression&&Jr($t(e))?li(t):r.type&&Ei[r.type]?Ei[r.type](t):ni(Ut({},t,{valueSpec:r.type?i[r.type]:r}))}function Bi(t){const e=t.value,r=t.key,i=Ai(t);return i.length||(-1===e.indexOf("{fontstack}")&&i.push(new Rt(r,e,'"glyphs" url must include a "{fontstack}" token')),-1===e.indexOf("{range}")&&i.push(new Rt(r,e,'"glyphs" url must include a "{range}" token'))),i}function Di(t,e=Ft){let r=[];return r=r.concat(Mi({key:"",value:t,valueSpec:e.$root,styleSpec:e,style:t,objectElementValidators:{glyphs:Bi,"*":()=>[]}})),t.constants&&(r=r.concat(Lt({key:"constants",value:t.constants,style:t,styleSpec:e}))),Ci(r)}function Ci(t){return [].concat(t).sort((t,e)=>t.line-e.line)}function Pi(t){return function(...e){return Ci(t.apply(this,e))}}Di.source=Pi(Ii),Di.light=Pi(Ti),Di.terrain=Pi(zi),Di.layer=Pi(ki),Di.filter=Pi(vi),Di.paintProperty=Pi(wi),Di.layoutProperty=Pi(_i);const Vi=Di,Fi=Vi.light,Ri=Vi.paintProperty,Li=Vi.layoutProperty;function Ui(t,e){let r=!1;if(e&&e.length)for(const i of e)t.fire(new Pt(new Error(i.message))),r=!0;return r}var Oi=$i;function $i(t,e,r){var i=this.cells=[];if(t instanceof ArrayBuffer){this.arrayBuffer=t;var n=new Int32Array(this.arrayBuffer);t=n[0],this.d=(e=n[1])+2*(r=n[2]);for(var s=0;s<this.d*this.d;s++){var a=n[3+s],o=n[3+s+1];i.push(a===o?null:n.subarray(a,o));}var l=n[3+i.length+1];this.keys=n.subarray(n[3+i.length],l),this.bboxes=n.subarray(l),this.insert=this._insertReadonly;}else {this.d=e+2*r;for(var u=0;u<this.d*this.d;u++)i.push([]);this.keys=[],this.bboxes=[];}this.n=e,this.extent=t,this.padding=r,this.scale=e/t,this.uid=0;var c=r/e*t;this.min=-c,this.max=t+c;}$i.prototype.insert=function(t,e,r,i,n){this._forEachCell(e,r,i,n,this._insertCell,this.uid++),this.keys.push(t),this.bboxes.push(e),this.bboxes.push(r),this.bboxes.push(i),this.bboxes.push(n);},$i.prototype._insertReadonly=function(){throw "Cannot insert into a GridIndex created from an ArrayBuffer."},$i.prototype._insertCell=function(t,e,r,i,n,s){this.cells[n].push(s);},$i.prototype.query=function(t,e,r,i,n){var s=this.min,a=this.max;if(t<=s&&e<=s&&a<=r&&a<=i&&!n)return Array.prototype.slice.call(this.keys);var o=[];return this._forEachCell(t,e,r,i,this._queryCell,o,{},n),o},$i.prototype._queryCell=function(t,e,r,i,n,s,a,o){var l=this.cells[n];if(null!==l)for(var u=this.keys,c=this.bboxes,h=0;h<l.length;h++){var p=l[h];if(void 0===a[p]){var d=4*p;(o?o(c[d+0],c[d+1],c[d+2],c[d+3]):t<=c[d+2]&&e<=c[d+3]&&r>=c[d+0]&&i>=c[d+1])?(a[p]=!0,s.push(u[p])):a[p]=!1;}}},$i.prototype._forEachCell=function(t,e,r,i,n,s,a,o){for(var l=this._convertToCellCoord(t),u=this._convertToCellCoord(e),c=this._convertToCellCoord(r),h=this._convertToCellCoord(i),p=l;p<=c;p++)for(var d=u;d<=h;d++){var f=this.d*d+p;if((!o||o(this._convertFromCellCoord(p),this._convertFromCellCoord(d),this._convertFromCellCoord(p+1),this._convertFromCellCoord(d+1)))&&n.call(this,t,e,r,i,f,s,a,o))return}},$i.prototype._convertFromCellCoord=function(t){return (t-this.padding)/this.scale},$i.prototype._convertToCellCoord=function(t){return Math.max(0,Math.min(this.d-1,Math.floor(t*this.scale)+this.padding))},$i.prototype.toArrayBuffer=function(){if(this.arrayBuffer)return this.arrayBuffer;for(var t=this.cells,e=3+this.cells.length+1+1,r=0,i=0;i<this.cells.length;i++)r+=this.cells[i].length;var n=new Int32Array(e+r+this.keys.length+this.bboxes.length);n[0]=this.extent,n[1]=this.n,n[2]=this.padding;for(var s=e,a=0;a<t.length;a++){var o=t[a];n[3+a]=s,n.set(o,s),s+=o.length;}return n[3+t.length]=s,n.set(this.keys,s),n[3+t.length+1]=s+=this.keys.length,n.set(this.bboxes,s),s+=this.bboxes.length,n.buffer};const{ImageData:qi,ImageBitmap:Ni}=s,ji={};function Gi(t,e,r={}){Object.defineProperty(e,"_classRegistryKey",{value:t,writeable:!1}),ji[t]={klass:e,omit:r.omit||[],shallow:r.shallow||[]};}Gi("Object",Object),Oi.serialize=function(t,e){const r=t.toArrayBuffer();return e&&e.push(r),{buffer:r}},Oi.deserialize=function(t){return new Oi(t.buffer)},Gi("Grid",Oi),Gi("Color",le),Gi("Error",Error),Gi("ResolvedImage",pe),Gi("StylePropertyFunction",ii),Gi("StyleExpression",Wr,{omit:["_evaluator"]}),Gi("ZoomDependentExpression",ei),Gi("ZoomConstantExpression",ti),Gi("CompoundExpression",Te,{omit:["_evaluate"]});for(const t in Cr)Cr[t]._classRegistryKey||Gi(`Expression_${t}`,Cr[t]);function Zi(t){return t&&"undefined"!=typeof ArrayBuffer&&(t instanceof ArrayBuffer||t.constructor&&"ArrayBuffer"===t.constructor.name)}function Xi(t){return Ni&&t instanceof Ni}function Ki(t,e){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp)return t;if(Zi(t)||Xi(t))return e&&e.push(t),t;if(ArrayBuffer.isView(t)){const r=t;return e&&e.push(r.buffer),r}if(t instanceof qi)return e&&e.push(t.data.buffer),t;if(Array.isArray(t)){const r=[];for(const i of t)r.push(Ki(i,e));return r}if("object"==typeof t){const r=t.constructor,i=r._classRegistryKey;if(!i)throw new Error("can't serialize object of unregistered class");const n=r.serialize?r.serialize(t,e):{};if(!r.serialize){for(const r in t){if(!t.hasOwnProperty(r))continue;if(ji[i].omit.indexOf(r)>=0)continue;const s=t[r];n[r]=ji[i].shallow.indexOf(r)>=0?s:Ki(s,e);}t instanceof Error&&(n.message=t.message);}if(n.$name)throw new Error("$name property is reserved for worker serialization logic.");return "Object"!==i&&(n.$name=i),n}throw new Error(`can't serialize object of type ${typeof t}`)}function Hi(t){if(null==t||"boolean"==typeof t||"number"==typeof t||"string"==typeof t||t instanceof Boolean||t instanceof Number||t instanceof String||t instanceof Date||t instanceof RegExp||Zi(t)||Xi(t)||ArrayBuffer.isView(t)||t instanceof qi)return t;if(Array.isArray(t))return t.map(Hi);if("object"==typeof t){const e=t.$name||"Object",{klass:r}=ji[e];if(!r)throw new Error(`can't deserialize unregistered class ${e}`);if(r.deserialize)return r.deserialize(t);const i=Object.create(r.prototype);for(const r of Object.keys(t)){if("$name"===r)continue;const n=t[r];i[r]=ji[e].shallow.indexOf(r)>=0?n:Hi(n);}return i}throw new Error(`can't deserialize object of type ${typeof t}`)}class Yi{constructor(){this.first=!0;}update(t,e){const r=Math.floor(t);return this.first?(this.first=!1,this.lastIntegerZoom=r,this.lastIntegerZoomTime=0,this.lastZoom=t,this.lastFloorZoom=r,!0):(this.lastFloorZoom>r?(this.lastIntegerZoom=r+1,this.lastIntegerZoomTime=e):this.lastFloorZoom<r&&(this.lastIntegerZoom=r,this.lastIntegerZoomTime=e),t!==this.lastZoom&&(this.lastZoom=t,this.lastFloorZoom=r,!0))}}const Wi=t=>t>=1536&&t<=1791,Ji=t=>t>=1872&&t<=1919,Qi=t=>t>=2208&&t<=2303,tn=t=>t>=11904&&t<=12031,en=t=>t>=12032&&t<=12255,rn=t=>t>=12272&&t<=12287,nn=t=>t>=12288&&t<=12351,sn=t=>t>=12352&&t<=12447,an=t=>t>=12448&&t<=12543,on=t=>t>=12544&&t<=12591,ln=t=>t>=12704&&t<=12735,un=t=>t>=12736&&t<=12783,cn=t=>t>=12784&&t<=12799,hn=t=>t>=12800&&t<=13055,pn=t=>t>=13056&&t<=13311,dn=t=>t>=13312&&t<=19903,fn=t=>t>=19968&&t<=40959,yn=t=>t>=40960&&t<=42127,mn=t=>t>=42128&&t<=42191,gn=t=>t>=44032&&t<=55215,xn=t=>t>=63744&&t<=64255,vn=t=>t>=64336&&t<=65023,bn=t=>t>=65040&&t<=65055,wn=t=>t>=65072&&t<=65103,_n=t=>t>=65104&&t<=65135,kn=t=>t>=65136&&t<=65279,An=t=>t>=65280&&t<=65519;function Sn(t){for(const e of t)if(zn(e.charCodeAt(0)))return !0;return !1}function In(t){for(const e of t)if(!Tn(e.charCodeAt(0)))return !1;return !0}function Tn(t){return !(Wi(t)||Ji(t)||Qi(t)||vn(t)||kn(t))}function zn(t){return !(746!==t&&747!==t&&(t<4352||!(ln(t)||on(t)||wn(t)&&!(t>=65097&&t<=65103)||xn(t)||pn(t)||tn(t)||un(t)||!(!nn(t)||t>=12296&&t<=12305||t>=12308&&t<=12319||12336===t)||dn(t)||fn(t)||hn(t)||(t=>t>=12592&&t<=12687)(t)||(t=>t>=43360&&t<=43391)(t)||(t=>t>=55216&&t<=55295)(t)||(t=>t>=4352&&t<=4607)(t)||gn(t)||sn(t)||rn(t)||(t=>t>=12688&&t<=12703)(t)||en(t)||cn(t)||an(t)&&12540!==t||!(!An(t)||65288===t||65289===t||65293===t||t>=65306&&t<=65310||65339===t||65341===t||65343===t||t>=65371&&t<=65503||65507===t||t>=65512&&t<=65519)||!(!_n(t)||t>=65112&&t<=65118||t>=65123&&t<=65126)||(t=>t>=5120&&t<=5759)(t)||(t=>t>=6320&&t<=6399)(t)||bn(t)||(t=>t>=19904&&t<=19967)(t)||yn(t)||mn(t))))}function En(t){return !(zn(t)||function(t){return !!((t=>t>=128&&t<=255)(t)&&(167===t||169===t||174===t||177===t||188===t||189===t||190===t||215===t||247===t)||(t=>t>=8192&&t<=8303)(t)&&(8214===t||8224===t||8225===t||8240===t||8241===t||8251===t||8252===t||8258===t||8263===t||8264===t||8265===t||8273===t)||(t=>t>=8448&&t<=8527)(t)||(t=>t>=8528&&t<=8591)(t)||(t=>t>=8960&&t<=9215)(t)&&(t>=8960&&t<=8967||t>=8972&&t<=8991||t>=8996&&t<=9e3||9003===t||t>=9085&&t<=9114||t>=9150&&t<=9165||9167===t||t>=9169&&t<=9179||t>=9186&&t<=9215)||(t=>t>=9216&&t<=9279)(t)&&9251!==t||(t=>t>=9280&&t<=9311)(t)||(t=>t>=9312&&t<=9471)(t)||(t=>t>=9632&&t<=9727)(t)||(t=>t>=9728&&t<=9983)(t)&&!(t>=9754&&t<=9759)||(t=>t>=11008&&t<=11263)(t)&&(t>=11026&&t<=11055||t>=11088&&t<=11097||t>=11192&&t<=11243)||nn(t)||an(t)||(t=>t>=57344&&t<=63743)(t)||wn(t)||_n(t)||An(t)||8734===t||8756===t||8757===t||t>=9984&&t<=10087||t>=10102&&t<=10131||65532===t||65533===t)}(t))}function Mn(t){return t>=1424&&t<=2303||vn(t)||kn(t)}function Bn(t,e){return !(!e&&Mn(t)||t>=2304&&t<=3583||t>=3840&&t<=4255||(t=>t>=6016&&t<=6143)(t))}function Dn(t){for(const e of t)if(Mn(e.charCodeAt(0)))return !0;return !1}let Cn=null,Pn="unavailable",Vn=null;const Fn=function(t){t&&"string"==typeof t&&t.indexOf("NetworkError")>-1&&(Pn="error"),Cn&&Cn(t);};function Rn(){Ln.fire(new Ct("pluginStateChange",{pluginStatus:Pn,pluginURL:Vn}));}const Ln=new Vt,Un=function(){return Pn},On=function(){if("deferred"!==Pn||!Vn)throw new Error("rtl-text-plugin cannot be downloaded unless a pluginURL is specified");Pn="loading",Rn(),Vn&&kt({url:Vn},t=>{t?Fn(t):(Pn="loaded",Rn());});},$n={applyArabicShaping:null,processBidirectionalText:null,processStyledBidirectionalText:null,isLoaded:()=>"loaded"===Pn||null!=$n.applyArabicShaping,isLoading:()=>"loading"===Pn,setState(t){Pn=t.pluginStatus,Vn=t.pluginURL;},isParsed:()=>null!=$n.applyArabicShaping&&null!=$n.processBidirectionalText&&null!=$n.processStyledBidirectionalText,getPluginURL:()=>Vn};class qn{constructor(t,e){this.zoom=t,e?(this.now=e.now,this.fadeDuration=e.fadeDuration,this.zoomHistory=e.zoomHistory,this.transition=e.transition):(this.now=0,this.fadeDuration=0,this.zoomHistory=new Yi,this.transition={});}isSupportedScript(t){return function(t,e){for(const r of t)if(!Bn(r.charCodeAt(0),e))return !1;return !0}(t,$n.isLoaded())}crossFadingFactor(){return 0===this.fadeDuration?1:Math.min((this.now-this.zoomHistory.lastIntegerZoomTime)/this.fadeDuration,1)}getCrossfadeParameters(){const t=this.zoom,e=t-Math.floor(t),r=this.crossFadingFactor();return t>this.zoomHistory.lastIntegerZoom?{fromScale:2,toScale:1,t:e+(1-e)*r}:{fromScale:.5,toScale:1,t:1-(1-r)*e}}}class Nn{constructor(t,e){this.property=t,this.value=e,this.expression=function(t,e){if(jr(t))return new ii(t,e);if(Jr(t)){const r=ri(t,e);if("error"===r.result)throw new Error(r.value.map(t=>`${t.key}: ${t.message}`).join(", "));return r.value}{let r=t;return "string"==typeof t&&"color"===e.type&&(r=le.parse(t)),{kind:"constant",evaluate:()=>r}}}(void 0===e?t.specification.default:e,t.specification);}isDataDriven(){return "source"===this.expression.kind||"composite"===this.expression.kind}possiblyEvaluate(t,e,r){return this.property.possiblyEvaluate(this,t,e,r)}}class jn{constructor(t){this.property=t,this.value=new Nn(t,void 0);}transitioned(t,e){return new Zn(this.property,this.value,e,x({},t.transition,this.transition),t.now)}untransitioned(){return new Zn(this.property,this.value,null,{},0)}}class Gn{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitionablePropertyValues);}getValue(t){return T(this._values[t].value.value)}setValue(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new jn(this._values[t].property)),this._values[t].value=new Nn(this._values[t].property,null===e?void 0:T(e));}getTransition(t){return T(this._values[t].transition)}setTransition(t,e){this._values.hasOwnProperty(t)||(this._values[t]=new jn(this._values[t].property)),this._values[t].transition=T(e)||void 0;}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);const i=this.getTransition(e);void 0!==i&&(t[`${e}-transition`]=i);}return t}transitioned(t,e){const r=new Xn(this._properties);for(const i of Object.keys(this._values))r._values[i]=this._values[i].transitioned(t,e._values[i]);return r}untransitioned(){const t=new Xn(this._properties);for(const e of Object.keys(this._values))t._values[e]=this._values[e].untransitioned();return t}}class Zn{constructor(t,e,r,i,n){this.property=t,this.value=e,this.begin=n+i.delay||0,this.end=this.begin+i.duration||0,t.specification.transition&&(i.delay||i.duration)&&(this.prior=r);}possiblyEvaluate(t,e,r){const i=t.now||0,n=this.value.possiblyEvaluate(t,e,r),s=this.prior;if(s){if(i>this.end)return this.prior=null,n;if(this.value.isDataDriven())return this.prior=null,n;if(i<this.begin)return s.possiblyEvaluate(t,e,r);{const a=(i-this.begin)/(this.end-this.begin);return this.property.interpolate(s.possiblyEvaluate(t,e,r),n,h(a))}}return n}}class Xn{constructor(t){this._properties=t,this._values=Object.create(t.defaultTransitioningPropertyValues);}possiblyEvaluate(t,e,r){const i=new Yn(this._properties);for(const n of Object.keys(this._values))i._values[n]=this._values[n].possiblyEvaluate(t,e,r);return i}hasTransition(){for(const t of Object.keys(this._values))if(this._values[t].prior)return !0;return !1}}class Kn{constructor(t){this._properties=t,this._values=Object.create(t.defaultPropertyValues);}getValue(t){return T(this._values[t].value)}setValue(t,e){this._values[t]=new Nn(this._values[t].property,null===e?void 0:T(e));}serialize(){const t={};for(const e of Object.keys(this._values)){const r=this.getValue(e);void 0!==r&&(t[e]=r);}return t}possiblyEvaluate(t,e,r){const i=new Yn(this._properties);for(const n of Object.keys(this._values))i._values[n]=this._values[n].possiblyEvaluate(t,e,r);return i}}class Hn{constructor(t,e,r){this.property=t,this.value=e,this.parameters=r;}isConstant(){return "constant"===this.value.kind}constantOr(t){return "constant"===this.value.kind?this.value.value:t}evaluate(t,e,r,i){return this.property.evaluate(this.value,this.parameters,t,e,r,i)}}class Yn{constructor(t){this._properties=t,this._values=Object.create(t.defaultPossiblyEvaluatedValues);}get(t){return this._values[t]}}class Wn{constructor(t){this.specification=t;}possiblyEvaluate(t,e){return t.expression.evaluate(e)}interpolate(t,e,r){const i=Qe[this.specification.type];return i?i(t,e,r):t}}class Jn{constructor(t,e){this.specification=t,this.overrides=e;}possiblyEvaluate(t,e,r,i){return new Hn(this,"constant"===t.expression.kind||"camera"===t.expression.kind?{kind:"constant",value:t.expression.evaluate(e,null,{},r,i)}:t.expression,e)}interpolate(t,e,r){if("constant"!==t.value.kind||"constant"!==e.value.kind)return t;if(void 0===t.value.value||void 0===e.value.value)return new Hn(this,{kind:"constant",value:void 0},t.parameters);const i=Qe[this.specification.type];return i?new Hn(this,{kind:"constant",value:i(t.value.value,e.value.value,r)},t.parameters):t}evaluate(t,e,r,i,n,s){return "constant"===t.kind?t.value:t.evaluate(e,r,i,n,s)}}class Qn extends Jn{possiblyEvaluate(t,e,r,i){if(void 0===t.value)return new Hn(this,{kind:"constant",value:void 0},e);if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},r,i),s="resolvedImage"===t.property.specification.type&&"string"!=typeof n?n.name:n,a=this._calculate(s,s,s,e);return new Hn(this,{kind:"constant",value:a},e)}if("camera"===t.expression.kind){const r=this._calculate(t.expression.evaluate({zoom:e.zoom-1}),t.expression.evaluate({zoom:e.zoom}),t.expression.evaluate({zoom:e.zoom+1}),e);return new Hn(this,{kind:"constant",value:r},e)}return new Hn(this,t.expression,e)}evaluate(t,e,r,i,n,s){if("source"===t.kind){const a=t.evaluate(e,r,i,n,s);return this._calculate(a,a,a,e)}return "composite"===t.kind?this._calculate(t.evaluate({zoom:Math.floor(e.zoom)-1},r,i),t.evaluate({zoom:Math.floor(e.zoom)},r,i),t.evaluate({zoom:Math.floor(e.zoom)+1},r,i),e):t.value}_calculate(t,e,r,i){return i.zoom>i.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class ts{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,i){if(void 0!==t.value){if("constant"===t.expression.kind){const n=t.expression.evaluate(e,null,{},r,i);return this._calculate(n,n,n,e)}return this._calculate(t.expression.evaluate(new qn(Math.floor(e.zoom-1),e)),t.expression.evaluate(new qn(Math.floor(e.zoom),e)),t.expression.evaluate(new qn(Math.floor(e.zoom+1),e)),e)}}_calculate(t,e,r,i){return i.zoom>i.zoomHistory.lastIntegerZoom?{from:t,to:e}:{from:r,to:e}}interpolate(t){return t}}class es{constructor(t){this.specification=t;}possiblyEvaluate(t,e,r,i){return !!t.expression.evaluate(e,null,{},r,i)}interpolate(){return !1}}class rs{constructor(t){this.properties=t,this.defaultPropertyValues={},this.defaultTransitionablePropertyValues={},this.defaultTransitioningPropertyValues={},this.defaultPossiblyEvaluatedValues={},this.overridableProperties=[];for(const e in t){const r=t[e];r.specification.overridable&&this.overridableProperties.push(e);const i=this.defaultPropertyValues[e]=new Nn(r,void 0),n=this.defaultTransitionablePropertyValues[e]=new jn(r);this.defaultTransitioningPropertyValues[e]=n.untransitioned(),this.defaultPossiblyEvaluatedValues[e]=i.possiblyEvaluate({});}}}function is(t,e){return 256*(t=f(Math.floor(t),0,255))+f(Math.floor(e),0,255)}Gi("DataDrivenProperty",Jn),Gi("DataConstantProperty",Wn),Gi("CrossFadedDataDrivenProperty",Qn),Gi("CrossFadedProperty",ts),Gi("ColorRampProperty",es);const ns={Int8:Int8Array,Uint8:Uint8Array,Int16:Int16Array,Uint16:Uint16Array,Int32:Int32Array,Uint32:Uint32Array,Float32:Float32Array};class ss{constructor(t,e){this._structArray=t,this._pos1=e*this.size,this._pos2=this._pos1/2,this._pos4=this._pos1/4,this._pos8=this._pos1/8;}}class as{constructor(){this.isTransferred=!1,this.capacity=-1,this.resize(0);}static serialize(t,e){return t._trim(),e&&(t.isTransferred=!0,e.push(t.arrayBuffer)),{length:t.length,arrayBuffer:t.arrayBuffer}}static deserialize(t){const e=Object.create(this.prototype);return e.arrayBuffer=t.arrayBuffer,e.length=t.length,e.capacity=t.arrayBuffer.byteLength/e.bytesPerElement,e._refreshViews(),e}_trim(){this.length!==this.capacity&&(this.capacity=this.length,this.arrayBuffer=this.arrayBuffer.slice(0,this.length*this.bytesPerElement),this._refreshViews());}clear(){this.length=0;}resize(t){this.reserve(t),this.length=t;}reserve(t){if(t>this.capacity){this.capacity=Math.max(t,Math.floor(5*this.capacity),128),this.arrayBuffer=new ArrayBuffer(this.capacity*this.bytesPerElement);const e=this.uint8;this._refreshViews(),e&&this.uint8.set(e);}}_refreshViews(){throw new Error("_refreshViews() must be implemented by each concrete StructArray layout")}}function os(t,e=1){let r=0,i=0;return {members:t.map(t=>{const n=ns[t.type].BYTES_PER_ELEMENT,s=r=ls(r,Math.max(e,n)),a=t.components||1;return i=Math.max(i,n),r+=n*a,{name:t.name,type:t.type,components:a,offset:s}}),size:ls(r,Math.max(i,e)),alignment:e}}function ls(t,e){return Math.ceil(t/e)*e}class us extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.int16[i+0]=e,this.int16[i+1]=r,t}}us.prototype.bytesPerElement=4,Gi("StructArrayLayout2i4",us);class cs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=4*t;return this.int16[s+0]=e,this.int16[s+1]=r,this.int16[s+2]=i,this.int16[s+3]=n,t}}cs.prototype.bytesPerElement=8,Gi("StructArrayLayout4i8",cs);class hs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a){const o=this.length;return this.resize(o+1),this.emplace(o,t,e,r,i,n,s,a)}emplace(t,e,r,i,n,s,a,o){const l=6*t,u=12*t,c=3*t;return this.int16[l+0]=e,this.int16[l+1]=r,this.uint8[u+4]=i,this.uint8[u+5]=n,this.uint8[u+6]=s,this.uint8[u+7]=a,this.float32[c+2]=o,t}}hs.prototype.bytesPerElement=12,Gi("StructArrayLayout2i4ub1f12",hs);class ps extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.float32[i+0]=e,this.float32[i+1]=r,t}}ps.prototype.bytesPerElement=8,Gi("StructArrayLayout2f8",ps);class ds extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,i,n,s,a,o,l,u)}emplace(t,e,r,i,n,s,a,o,l,u,c){const h=10*t;return this.uint16[h+0]=e,this.uint16[h+1]=r,this.uint16[h+2]=i,this.uint16[h+3]=n,this.uint16[h+4]=s,this.uint16[h+5]=a,this.uint16[h+6]=o,this.uint16[h+7]=l,this.uint16[h+8]=u,this.uint16[h+9]=c,t}}ds.prototype.bytesPerElement=20,Gi("StructArrayLayout10ui20",ds);class fs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h){const p=this.length;return this.resize(p+1),this.emplace(p,t,e,r,i,n,s,a,o,l,u,c,h)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p){const d=12*t;return this.int16[d+0]=e,this.int16[d+1]=r,this.int16[d+2]=i,this.int16[d+3]=n,this.uint16[d+4]=s,this.uint16[d+5]=a,this.uint16[d+6]=o,this.uint16[d+7]=l,this.int16[d+8]=u,this.int16[d+9]=c,this.int16[d+10]=h,this.int16[d+11]=p,t}}fs.prototype.bytesPerElement=24,Gi("StructArrayLayout4i4ui4i24",fs);class ys extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.float32[n+0]=e,this.float32[n+1]=r,this.float32[n+2]=i,t}}ys.prototype.bytesPerElement=12,Gi("StructArrayLayout3f12",ys);class ms extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint32[1*t+0]=e,t}}ms.prototype.bytesPerElement=4,Gi("StructArrayLayout1ul4",ms);class gs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u){const c=this.length;return this.resize(c+1),this.emplace(c,t,e,r,i,n,s,a,o,l,u)}emplace(t,e,r,i,n,s,a,o,l,u,c){const h=16*t,p=8*t;return this.int16[h+0]=e,this.int16[h+1]=r,this.float32[p+1]=i,this.float32[p+2]=n,this.float32[p+3]=s,this.float32[p+4]=a,this.int16[h+10]=o,this.uint32[p+6]=l,this.uint16[h+14]=u,this.uint16[h+15]=c,t}}gs.prototype.bytesPerElement=32,Gi("StructArrayLayout2i4f1i1ul2ui32",gs);class xs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s){const a=this.length;return this.resize(a+1),this.emplace(a,t,e,r,i,n,s)}emplace(t,e,r,i,n,s,a){const o=6*t;return this.int16[o+0]=e,this.int16[o+1]=r,this.int16[o+2]=i,this.int16[o+3]=n,this.int16[o+4]=s,this.int16[o+5]=a,t}}xs.prototype.bytesPerElement=12,Gi("StructArrayLayout2i2i2i12",xs);class vs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n){const s=this.length;return this.resize(s+1),this.emplace(s,t,e,r,i,n)}emplace(t,e,r,i,n,s){const a=4*t,o=8*t;return this.float32[a+0]=e,this.float32[a+1]=r,this.float32[a+2]=i,this.int16[o+6]=n,this.int16[o+7]=s,t}}vs.prototype.bytesPerElement=16,Gi("StructArrayLayout2f1f2i16",vs);class bs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=12*t,a=3*t;return this.uint8[s+0]=e,this.uint8[s+1]=r,this.float32[a+1]=i,this.float32[a+2]=n,t}}bs.prototype.bytesPerElement=12,Gi("StructArrayLayout2ub2f12",bs);class ws extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.uint16[n+0]=e,this.uint16[n+1]=r,this.uint16[n+2]=i,t}}ws.prototype.bytesPerElement=6,Gi("StructArrayLayout3ui6",ws);class _s extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m){const g=this.length;return this.resize(g+1),this.emplace(g,t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g){const x=24*t,v=12*t,b=48*t;return this.int16[x+0]=e,this.int16[x+1]=r,this.uint16[x+2]=i,this.uint16[x+3]=n,this.uint32[v+2]=s,this.uint32[v+3]=a,this.uint32[v+4]=o,this.uint16[x+10]=l,this.uint16[x+11]=u,this.uint16[x+12]=c,this.float32[v+7]=h,this.float32[v+8]=p,this.uint8[b+36]=d,this.uint8[b+37]=f,this.uint8[b+38]=y,this.uint32[v+10]=m,this.int16[x+22]=g,t}}_s.prototype.bytesPerElement=48,Gi("StructArrayLayout2i2ui3ul3ui2f3ub1ul1i48",_s);class ks extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,T){const z=this.length;return this.resize(z+1),this.emplace(z,t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,T)}emplace(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A,S,I,T,z){const E=34*t,M=17*t;return this.int16[E+0]=e,this.int16[E+1]=r,this.int16[E+2]=i,this.int16[E+3]=n,this.int16[E+4]=s,this.int16[E+5]=a,this.int16[E+6]=o,this.int16[E+7]=l,this.uint16[E+8]=u,this.uint16[E+9]=c,this.uint16[E+10]=h,this.uint16[E+11]=p,this.uint16[E+12]=d,this.uint16[E+13]=f,this.uint16[E+14]=y,this.uint16[E+15]=m,this.uint16[E+16]=g,this.uint16[E+17]=x,this.uint16[E+18]=v,this.uint16[E+19]=b,this.uint16[E+20]=w,this.uint16[E+21]=_,this.uint16[E+22]=k,this.uint32[M+12]=A,this.float32[M+13]=S,this.float32[M+14]=I,this.float32[M+15]=T,this.float32[M+16]=z,t}}ks.prototype.bytesPerElement=68,Gi("StructArrayLayout8i15ui1ul4f68",ks);class As extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.float32[1*t+0]=e,t}}As.prototype.bytesPerElement=4,Gi("StructArrayLayout1f4",As);class Ss extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.int16=new Int16Array(this.arrayBuffer);}emplaceBack(t,e,r){const i=this.length;return this.resize(i+1),this.emplace(i,t,e,r)}emplace(t,e,r,i){const n=3*t;return this.int16[n+0]=e,this.int16[n+1]=r,this.int16[n+2]=i,t}}Ss.prototype.bytesPerElement=6,Gi("StructArrayLayout3i6",Ss);class Is extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint32=new Uint32Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=6*t;return this.uint32[3*t+0]=e,this.uint16[s+2]=r,this.uint16[s+3]=i,this.uint16[s+4]=n,t}}Is.prototype.bytesPerElement=12,Gi("StructArrayLayout1ul3ui12",Is);class Ts extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t,e){const r=this.length;return this.resize(r+1),this.emplace(r,t,e)}emplace(t,e,r){const i=2*t;return this.uint16[i+0]=e,this.uint16[i+1]=r,t}}Ts.prototype.bytesPerElement=4,Gi("StructArrayLayout2ui4",Ts);class zs extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.uint16=new Uint16Array(this.arrayBuffer);}emplaceBack(t){const e=this.length;return this.resize(e+1),this.emplace(e,t)}emplace(t,e){return this.uint16[1*t+0]=e,t}}zs.prototype.bytesPerElement=2,Gi("StructArrayLayout1ui2",zs);class Es extends as{_refreshViews(){this.uint8=new Uint8Array(this.arrayBuffer),this.float32=new Float32Array(this.arrayBuffer);}emplaceBack(t,e,r,i){const n=this.length;return this.resize(n+1),this.emplace(n,t,e,r,i)}emplace(t,e,r,i,n){const s=4*t;return this.float32[s+0]=e,this.float32[s+1]=r,this.float32[s+2]=i,this.float32[s+3]=n,t}}Es.prototype.bytesPerElement=16,Gi("StructArrayLayout4f16",Es);class Ms extends ss{get anchorPointX(){return this._structArray.int16[this._pos2+0]}get anchorPointY(){return this._structArray.int16[this._pos2+1]}get x1(){return this._structArray.float32[this._pos4+1]}get y1(){return this._structArray.float32[this._pos4+2]}get x2(){return this._structArray.float32[this._pos4+3]}get y2(){return this._structArray.float32[this._pos4+4]}get padding(){return this._structArray.int16[this._pos2+10]}get featureIndex(){return this._structArray.uint32[this._pos4+6]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+14]}get bucketIndex(){return this._structArray.uint16[this._pos2+15]}get anchorPoint(){return new i(this.anchorPointX,this.anchorPointY)}}Ms.prototype.size=32;class Bs extends gs{get(t){return new Ms(this,t)}}Gi("CollisionBoxArray",Bs);class Ds extends ss{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get glyphStartIndex(){return this._structArray.uint16[this._pos2+2]}get numGlyphs(){return this._structArray.uint16[this._pos2+3]}get vertexStartIndex(){return this._structArray.uint32[this._pos4+2]}get lineStartIndex(){return this._structArray.uint32[this._pos4+3]}get lineLength(){return this._structArray.uint32[this._pos4+4]}get segment(){return this._structArray.uint16[this._pos2+10]}get lowerSize(){return this._structArray.uint16[this._pos2+11]}get upperSize(){return this._structArray.uint16[this._pos2+12]}get lineOffsetX(){return this._structArray.float32[this._pos4+7]}get lineOffsetY(){return this._structArray.float32[this._pos4+8]}get writingMode(){return this._structArray.uint8[this._pos1+36]}get placedOrientation(){return this._structArray.uint8[this._pos1+37]}set placedOrientation(t){this._structArray.uint8[this._pos1+37]=t;}get hidden(){return this._structArray.uint8[this._pos1+38]}set hidden(t){this._structArray.uint8[this._pos1+38]=t;}get crossTileID(){return this._structArray.uint32[this._pos4+10]}set crossTileID(t){this._structArray.uint32[this._pos4+10]=t;}get associatedIconIndex(){return this._structArray.int16[this._pos2+22]}}Ds.prototype.size=48;class Cs extends _s{get(t){return new Ds(this,t)}}Gi("PlacedSymbolArray",Cs);class Ps extends ss{get anchorX(){return this._structArray.int16[this._pos2+0]}get anchorY(){return this._structArray.int16[this._pos2+1]}get rightJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+2]}get centerJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+3]}get leftJustifiedTextSymbolIndex(){return this._structArray.int16[this._pos2+4]}get verticalPlacedTextSymbolIndex(){return this._structArray.int16[this._pos2+5]}get placedIconSymbolIndex(){return this._structArray.int16[this._pos2+6]}get verticalPlacedIconSymbolIndex(){return this._structArray.int16[this._pos2+7]}get key(){return this._structArray.uint16[this._pos2+8]}get textBoxStartIndex(){return this._structArray.uint16[this._pos2+9]}get textBoxEndIndex(){return this._structArray.uint16[this._pos2+10]}get verticalTextBoxStartIndex(){return this._structArray.uint16[this._pos2+11]}get verticalTextBoxEndIndex(){return this._structArray.uint16[this._pos2+12]}get iconBoxStartIndex(){return this._structArray.uint16[this._pos2+13]}get iconBoxEndIndex(){return this._structArray.uint16[this._pos2+14]}get verticalIconBoxStartIndex(){return this._structArray.uint16[this._pos2+15]}get verticalIconBoxEndIndex(){return this._structArray.uint16[this._pos2+16]}get featureIndex(){return this._structArray.uint16[this._pos2+17]}get numHorizontalGlyphVertices(){return this._structArray.uint16[this._pos2+18]}get numVerticalGlyphVertices(){return this._structArray.uint16[this._pos2+19]}get numIconVertices(){return this._structArray.uint16[this._pos2+20]}get numVerticalIconVertices(){return this._structArray.uint16[this._pos2+21]}get useRuntimeCollisionCircles(){return this._structArray.uint16[this._pos2+22]}get crossTileID(){return this._structArray.uint32[this._pos4+12]}set crossTileID(t){this._structArray.uint32[this._pos4+12]=t;}get textBoxScale(){return this._structArray.float32[this._pos4+13]}get textOffset0(){return this._structArray.float32[this._pos4+14]}get textOffset1(){return this._structArray.float32[this._pos4+15]}get collisionCircleDiameter(){return this._structArray.float32[this._pos4+16]}}Ps.prototype.size=68;class Vs extends ks{get(t){return new Ps(this,t)}}Gi("SymbolInstanceArray",Vs);class Fs extends As{getoffsetX(t){return this.float32[1*t+0]}}Gi("GlyphOffsetArray",Fs);class Rs extends Ss{getx(t){return this.int16[3*t+0]}gety(t){return this.int16[3*t+1]}gettileUnitDistanceFromAnchor(t){return this.int16[3*t+2]}}Gi("SymbolLineVertexArray",Rs);class Ls extends ss{get featureIndex(){return this._structArray.uint32[this._pos4+0]}get sourceLayerIndex(){return this._structArray.uint16[this._pos2+2]}get bucketIndex(){return this._structArray.uint16[this._pos2+3]}get layoutVertexArrayOffset(){return this._structArray.uint16[this._pos2+4]}}Ls.prototype.size=12;class Us extends Is{get(t){return new Ls(this,t)}}Gi("FeatureIndexArray",Us);class Os extends ss{get a_centroid_pos0(){return this._structArray.uint16[this._pos2+0]}get a_centroid_pos1(){return this._structArray.uint16[this._pos2+1]}}Os.prototype.size=4;class $s extends Ts{get(t){return new Os(this,t)}}Gi("FillExtrusionCentroidArray",$s);const qs=os([{name:"a_pattern_to",components:4,type:"Uint16"},{name:"a_pattern_from",components:4,type:"Uint16"},{name:"a_pixel_ratio_to",components:1,type:"Uint16"},{name:"a_pixel_ratio_from",components:1,type:"Uint16"}]);var Ns=ae((function(t){t.exports=function(t,e){var r,i,n,s,a,o,l,u;for(i=t.length-(r=3&t.length),n=e,a=3432918353,o=461845907,u=0;u<i;)l=255&t.charCodeAt(u)|(255&t.charCodeAt(++u))<<8|(255&t.charCodeAt(++u))<<16|(255&t.charCodeAt(++u))<<24,++u,n=27492+(65535&(s=5*(65535&(n=(n^=l=(65535&(l=(l=(65535&l)*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295)<<13|n>>>19))+((5*(n>>>16)&65535)<<16)&4294967295))+((58964+(s>>>16)&65535)<<16);switch(l=0,r){case 3:l^=(255&t.charCodeAt(u+2))<<16;case 2:l^=(255&t.charCodeAt(u+1))<<8;case 1:n^=l=(65535&(l=(l=(65535&(l^=255&t.charCodeAt(u)))*a+(((l>>>16)*a&65535)<<16)&4294967295)<<15|l>>>17))*o+(((l>>>16)*o&65535)<<16)&4294967295;}return n^=t.length,n=2246822507*(65535&(n^=n>>>16))+((2246822507*(n>>>16)&65535)<<16)&4294967295,n=3266489909*(65535&(n^=n>>>13))+((3266489909*(n>>>16)&65535)<<16)&4294967295,(n^=n>>>16)>>>0};})),js=ae((function(t){t.exports=function(t,e){for(var r,i=t.length,n=e^i,s=0;i>=4;)r=1540483477*(65535&(r=255&t.charCodeAt(s)|(255&t.charCodeAt(++s))<<8|(255&t.charCodeAt(++s))<<16|(255&t.charCodeAt(++s))<<24))+((1540483477*(r>>>16)&65535)<<16),n=1540483477*(65535&n)+((1540483477*(n>>>16)&65535)<<16)^(r=1540483477*(65535&(r^=r>>>24))+((1540483477*(r>>>16)&65535)<<16)),i-=4,++s;switch(i){case 3:n^=(255&t.charCodeAt(s+2))<<16;case 2:n^=(255&t.charCodeAt(s+1))<<8;case 1:n=1540483477*(65535&(n^=255&t.charCodeAt(s)))+((1540483477*(n>>>16)&65535)<<16);}return n=1540483477*(65535&(n^=n>>>13))+((1540483477*(n>>>16)&65535)<<16),(n^=n>>>15)>>>0};})),Gs=Ns,Zs=js;Gs.murmur3=Ns,Gs.murmur2=Zs;class Xs{constructor(){this.ids=[],this.positions=[],this.indexed=!1;}add(t,e,r,i){this.ids.push(Ks(t)),this.positions.push(e,r,i);}getPositions(t){const e=Ks(t);let r=0,i=this.ids.length-1;for(;r<i;){const t=r+i>>1;this.ids[t]>=e?i=t:r=t+1;}const n=[];for(;this.ids[r]===e;)n.push({index:this.positions[3*r],start:this.positions[3*r+1],end:this.positions[3*r+2]}),r++;return n}static serialize(t,e){const r=new Float64Array(t.ids),i=new Uint32Array(t.positions);return function t(e,r,i,n){for(;i<n;){const s=e[i+n>>1];let a=i-1,o=n+1;for(;;){do{a++;}while(e[a]<s);do{o--;}while(e[o]>s);if(a>=o)break;Hs(e,a,o),Hs(r,3*a,3*o),Hs(r,3*a+1,3*o+1),Hs(r,3*a+2,3*o+2);}o-i<n-o?(t(e,r,i,o),i=o+1):(t(e,r,o+1,n),n=o);}}(r,i,0,r.length-1),e&&e.push(r.buffer,i.buffer),{ids:r,positions:i}}static deserialize(t){const e=new Xs;return e.ids=t.ids,e.positions=t.positions,e.indexed=!0,e}}function Ks(t){const e=+t;return !isNaN(e)&&e<=o?e:Gs(String(t))}function Hs(t,e,r){const i=t[e];t[e]=t[r],t[r]=i;}Gi("FeaturePositionMap",Xs);class Ys{constructor(t,e){this.gl=t.gl,this.location=e;}}class Ws extends Ys{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1f(this.location,t));}}class Js extends Ys{constructor(t,e){super(t,e),this.current=[0,0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]&&t[3]===this.current[3]||(this.current=t,this.gl.uniform4f(this.location,t[0],t[1],t[2],t[3]));}}class Qs extends Ys{constructor(t,e){super(t,e),this.current=le.transparent;}set(t){t.r===this.current.r&&t.g===this.current.g&&t.b===this.current.b&&t.a===this.current.a||(this.current=t,this.gl.uniform4f(this.location,t.r,t.g,t.b,t.a));}}const ta=new Float32Array(16),ea=new Float32Array(9);function ra(t){return [is(255*t.r,255*t.g),is(255*t.b,255*t.a)]}class ia{constructor(t,e,r){this.value=t,this.uniformNames=e.map(t=>`u_${t}`),this.type=r;}setUniform(t,e,r){t.set(r.constantOr(this.value));}getBinding(t,e,r){return "color"===this.type?new Qs(t,e):new Ws(t,e)}}class na{constructor(t,e){this.uniformNames=e.map(t=>`u_${t}`),this.patternFrom=null,this.patternTo=null,this.pixelRatioFrom=1,this.pixelRatioTo=1;}setConstantPatternPositions(t,e){this.pixelRatioFrom=e.pixelRatio,this.pixelRatioTo=t.pixelRatio,this.patternFrom=e.tlbr,this.patternTo=t.tlbr;}setUniform(t,e,r,i){const n="u_pattern_to"===i?this.patternTo:"u_pattern_from"===i?this.patternFrom:"u_pixel_ratio_to"===i?this.pixelRatioTo:"u_pixel_ratio_from"===i?this.pixelRatioFrom:null;n&&t.set(n);}getBinding(t,e,r){return "u_pattern"===r.substr(0,9)?new Js(t,e):new Ws(t,e)}}class sa{constructor(t,e,r,i){this.expression=t,this.type=r,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?2:1,offset:0})),this.paintVertexArray=new i;}populatePaintArray(t,e,r,i,n){const s=this.paintVertexArray.length,a=this.expression.evaluate(new qn(0),e,{},i,[],n);this.paintVertexArray.resize(t),this._setPaintValue(s,t,a);}updatePaintArray(t,e,r,i){const n=this.expression.evaluate({zoom:0},r,i);this._setPaintValue(t,e,n);}_setPaintValue(t,e,r){if("color"===this.type){const i=ra(r);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,i[0],i[1]);}else {for(let i=t;i<e;i++)this.paintVertexArray.emplace(i,r);this.maxValue=Math.max(this.maxValue,Math.abs(r));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}}class aa{constructor(t,e,r,i,n,s){this.expression=t,this.uniformNames=e.map(t=>`u_${t}_t`),this.type=r,this.useIntegerZoom=i,this.zoom=n,this.maxValue=0,this.paintVertexAttributes=e.map(t=>({name:`a_${t}`,type:"Float32",components:"color"===r?4:2,offset:0})),this.paintVertexArray=new s;}populatePaintArray(t,e,r,i,n){const s=this.expression.evaluate(new qn(this.zoom),e,{},i,[],n),a=this.expression.evaluate(new qn(this.zoom+1),e,{},i,[],n),o=this.paintVertexArray.length;this.paintVertexArray.resize(t),this._setPaintValue(o,t,s,a);}updatePaintArray(t,e,r,i){const n=this.expression.evaluate({zoom:this.zoom},r,i),s=this.expression.evaluate({zoom:this.zoom+1},r,i);this._setPaintValue(t,e,n,s);}_setPaintValue(t,e,r,i){if("color"===this.type){const n=ra(r),s=ra(i);for(let r=t;r<e;r++)this.paintVertexArray.emplace(r,n[0],n[1],s[0],s[1]);}else {for(let n=t;n<e;n++)this.paintVertexArray.emplace(n,r,i);this.maxValue=Math.max(this.maxValue,Math.abs(r),Math.abs(i));}}upload(t){this.paintVertexArray&&this.paintVertexArray.arrayBuffer&&(this.paintVertexBuffer&&this.paintVertexBuffer.buffer?this.paintVertexBuffer.updateData(this.paintVertexArray):this.paintVertexBuffer=t.createVertexBuffer(this.paintVertexArray,this.paintVertexAttributes,this.expression.isStateDependent));}destroy(){this.paintVertexBuffer&&this.paintVertexBuffer.destroy();}setUniform(t,e){const r=this.useIntegerZoom?Math.floor(e.zoom):e.zoom,i=f(this.expression.interpolationFactor(r,this.zoom,this.zoom+1),0,1);t.set(i);}getBinding(t,e,r){return new Ws(t,e)}}class oa{constructor(t,e,r,i,n,s,a){this.expression=t,this.type=r,this.useIntegerZoom=i,this.zoom=n,this.layerId=a;for(let t=0;t<e.length;++t);this.zoomInPaintVertexArray=new s,this.zoomOutPaintVertexArray=new s;}populatePaintArray(t,e,r){const i=this.zoomInPaintVertexArray.length;this.zoomInPaintVertexArray.resize(t),this.zoomOutPaintVertexArray.resize(t),this._setPaintValues(i,t,e.patterns&&e.patterns[this.layerId],r);}updatePaintArray(t,e,r,i,n){this._setPaintValues(t,e,r.patterns&&r.patterns[this.layerId],n);}_setPaintValues(t,e,r,i){if(!i||!r)return;const{min:n,mid:s,max:a}=r,o=i[n],l=i[s],u=i[a];if(o&&l&&u)for(let r=t;r<e;r++)this.zoomInPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],o.tl[0],o.tl[1],o.br[0],o.br[1],l.pixelRatio,o.pixelRatio),this.zoomOutPaintVertexArray.emplace(r,l.tl[0],l.tl[1],l.br[0],l.br[1],u.tl[0],u.tl[1],u.br[0],u.br[1],l.pixelRatio,u.pixelRatio);}upload(t){this.zoomInPaintVertexArray&&this.zoomInPaintVertexArray.arrayBuffer&&this.zoomOutPaintVertexArray&&this.zoomOutPaintVertexArray.arrayBuffer&&(this.zoomInPaintVertexBuffer=t.createVertexBuffer(this.zoomInPaintVertexArray,qs.members,this.expression.isStateDependent),this.zoomOutPaintVertexBuffer=t.createVertexBuffer(this.zoomOutPaintVertexArray,qs.members,this.expression.isStateDependent));}destroy(){this.zoomOutPaintVertexBuffer&&this.zoomOutPaintVertexBuffer.destroy(),this.zoomInPaintVertexBuffer&&this.zoomInPaintVertexBuffer.destroy();}}class la{constructor(t,e,r=(()=>!0)){this.binders={},this._buffers=[];const i=[];for(const n in t.paint._values){if(!r(n))continue;const s=t.paint.get(n);if(!(s instanceof Hn&&Or(s.property.specification)))continue;const a=ca(n,t.type),o=s.value,l=s.property.specification.type,u=s.property.useIntegerZoom,c=s.property.specification["property-type"],h="cross-faded"===c||"cross-faded-data-driven"===c;if("constant"===o.kind)this.binders[n]=h?new na(o.value,a):new ia(o.value,a,l),i.push(`/u_${n}`);else if("source"===o.kind||h){const r=ha(n,l,"source");this.binders[n]=h?new oa(o,a,l,u,e,r,t.id):new sa(o,a,l,r),i.push(`/a_${n}`);}else {const t=ha(n,l,"composite");this.binders[n]=new aa(o,a,l,u,e,t),i.push(`/z_${n}`);}}this.cacheKey=i.sort().join("");}getMaxValue(t){const e=this.binders[t];return e instanceof sa||e instanceof aa?e.maxValue:0}populatePaintArrays(t,e,r,i,n){for(const s in this.binders){const a=this.binders[s];(a instanceof sa||a instanceof aa||a instanceof oa)&&a.populatePaintArray(t,e,r,i,n);}}setConstantPatternPositions(t,e){for(const r in this.binders){const i=this.binders[r];i instanceof na&&i.setConstantPatternPositions(t,e);}}updatePaintArrays(t,e,r,i,n){let s=!1;for(const a in t){const o=e.getPositions(a);for(const e of o){const o=r.feature(e.index);for(const r in this.binders){const l=this.binders[r];if((l instanceof sa||l instanceof aa||l instanceof oa)&&!0===l.expression.isStateDependent){const u=i.paint.get(r);l.expression=u.value,l.updatePaintArray(e.start,e.end,o,t[a],n),s=!0;}}}}return s}defines(){const t=[];for(const e in this.binders){const r=this.binders[e];(r instanceof ia||r instanceof na)&&t.push(...r.uniformNames.map(t=>`#define HAS_UNIFORM_${t}`));}return t}getBinderAttributes(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof sa||r instanceof aa)for(let e=0;e<r.paintVertexAttributes.length;e++)t.push(r.paintVertexAttributes[e].name);else if(r instanceof oa)for(let e=0;e<qs.members.length;e++)t.push(qs.members[e].name);}return t}getBinderUniforms(){const t=[];for(const e in this.binders){const r=this.binders[e];if(r instanceof ia||r instanceof na||r instanceof aa)for(const e of r.uniformNames)t.push(e);}return t}getPaintVertexBuffers(){return this._buffers}getUniforms(t,e){const r=[];for(const i in this.binders){const n=this.binders[i];if(n instanceof ia||n instanceof na||n instanceof aa)for(const s of n.uniformNames)if(e[s]){const a=n.getBinding(t,e[s],s);r.push({name:s,property:i,binding:a});}}return r}setUniforms(t,e,r,i){for(const{name:t,property:n,binding:s}of e)this.binders[n].setUniform(s,i,r.get(n),t);}updatePaintBuffers(t){this._buffers=[];for(const e in this.binders){const r=this.binders[e];if(t&&r instanceof oa){const e=2===t.fromScale?r.zoomInPaintVertexBuffer:r.zoomOutPaintVertexBuffer;e&&this._buffers.push(e);}else (r instanceof sa||r instanceof aa)&&r.paintVertexBuffer&&this._buffers.push(r.paintVertexBuffer);}}upload(t){for(const e in this.binders){const r=this.binders[e];(r instanceof sa||r instanceof aa||r instanceof oa)&&r.upload(t);}this.updatePaintBuffers();}destroy(){for(const t in this.binders){const e=this.binders[t];(e instanceof sa||e instanceof aa||e instanceof oa)&&e.destroy();}}}class ua{constructor(t,e,r=(()=>!0)){this.programConfigurations={};for(const i of t)this.programConfigurations[i.id]=new la(i,e,r);this.needsUpload=!1,this._featureMap=new Xs,this._bufferOffset=0;}populatePaintArrays(t,e,r,i,n,s){for(const r in this.programConfigurations)this.programConfigurations[r].populatePaintArrays(t,e,i,n,s);void 0!==e.id&&this._featureMap.add(e.id,r,this._bufferOffset,t),this._bufferOffset=t,this.needsUpload=!0;}updatePaintArrays(t,e,r,i){for(const n of r)this.needsUpload=this.programConfigurations[n.id].updatePaintArrays(t,this._featureMap,e,n,i)||this.needsUpload;}get(t){return this.programConfigurations[t]}upload(t){if(this.needsUpload){for(const e in this.programConfigurations)this.programConfigurations[e].upload(t);this.needsUpload=!1;}}destroy(){for(const t in this.programConfigurations)this.programConfigurations[t].destroy();}}function ca(t,e){return {"text-opacity":["opacity"],"icon-opacity":["opacity"],"text-color":["fill_color"],"icon-color":["fill_color"],"text-halo-color":["halo_color"],"icon-halo-color":["halo_color"],"text-halo-blur":["halo_blur"],"icon-halo-blur":["halo_blur"],"text-halo-width":["halo_width"],"icon-halo-width":["halo_width"],"line-gap-width":["gapwidth"],"line-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"],"fill-extrusion-pattern":["pattern_to","pattern_from","pixel_ratio_to","pixel_ratio_from"]}[t]||[t.replace(`${e}-`,"").replace(/-/g,"_")]}function ha(t,e,r){const i={color:{source:ps,composite:Es},number:{source:As,composite:ps}},n=function(t){return {"line-pattern":{source:ds,composite:ds},"fill-pattern":{source:ds,composite:ds},"fill-extrusion-pattern":{source:ds,composite:ds}}[t]}(t);return n&&n[r]||i[e][r]}Gi("ConstantBinder",ia),Gi("CrossFadedConstantBinder",na),Gi("SourceExpressionBinder",sa),Gi("CrossFadedCompositeBinder",oa),Gi("CompositeExpressionBinder",aa),Gi("ProgramConfiguration",la,{omit:["_buffers"]}),Gi("ProgramConfigurationSet",ua);class pa extends Vt{constructor(t,e){if(super(),this.id=t.id,this.type=t.type,this._featureFilter={filter:()=>!0,needGeometry:!1},"custom"!==t.type&&(this.metadata=(t=t).metadata,this.minzoom=t.minzoom,this.maxzoom=t.maxzoom,"background"!==t.type&&"sky"!==t.type&&(this.source=t.source,this.sourceLayer=t["source-layer"],this.filter=t.filter),e.layout&&(this._unevaluatedLayout=new Kn(e.layout)),e.paint)){this._transitionablePaint=new Gn(e.paint);for(const e in t.paint)this.setPaintProperty(e,t.paint[e],{validate:!1});for(const e in t.layout)this.setLayoutProperty(e,t.layout[e],{validate:!1});this._transitioningPaint=this._transitionablePaint.untransitioned(),this.paint=new Yn(e.paint);}}getCrossfadeParameters(){return this._crossfadeParameters}getLayoutProperty(t){return "visibility"===t?this.visibility:this._unevaluatedLayout.getValue(t)}setLayoutProperty(t,e,r={}){null!=e&&this._validate(Li,`layers.${this.id}.layout.${t}`,t,e,r)||("visibility"!==t?this._unevaluatedLayout.setValue(t,e):this.visibility=e);}getPaintProperty(t){return A(t,"-transition")?this._transitionablePaint.getTransition(t.slice(0,-"-transition".length)):this._transitionablePaint.getValue(t)}setPaintProperty(t,e,r={}){if(null!=e&&this._validate(Ri,`layers.${this.id}.paint.${t}`,t,e,r))return !1;if(A(t,"-transition"))return this._transitionablePaint.setTransition(t.slice(0,-"-transition".length),e||void 0),!1;{const r=this._transitionablePaint._values[t],i="cross-faded-data-driven"===r.property.specification["property-type"],n=r.value.isDataDriven(),s=r.value;this._transitionablePaint.setValue(t,e),this._handleSpecialPaintPropertyUpdate(t);const a=this._transitionablePaint._values[t].value;return a.isDataDriven()||n||i||this._handleOverridablePaintPropertyUpdate(t,s,a)}}_handleSpecialPaintPropertyUpdate(t){}getProgramIds(){return null}getProgramConfiguration(t){return null}_handleOverridablePaintPropertyUpdate(t,e,r){return !1}isHidden(t){return !!(this.minzoom&&t<this.minzoom)||!!(this.maxzoom&&t>=this.maxzoom)||"none"===this.visibility}updateTransitions(t){this._transitioningPaint=this._transitionablePaint.transitioned(t,this._transitioningPaint);}hasTransition(){return this._transitioningPaint.hasTransition()}recalculate(t,e){t.getCrossfadeParameters&&(this._crossfadeParameters=t.getCrossfadeParameters()),this._unevaluatedLayout&&(this.layout=this._unevaluatedLayout.possiblyEvaluate(t,void 0,e)),this.paint=this._transitioningPaint.possiblyEvaluate(t,void 0,e);}serialize(){const t={id:this.id,type:this.type,source:this.source,"source-layer":this.sourceLayer,metadata:this.metadata,minzoom:this.minzoom,maxzoom:this.maxzoom,filter:this.filter,layout:this._unevaluatedLayout&&this._unevaluatedLayout.serialize(),paint:this._transitionablePaint&&this._transitionablePaint.serialize()};return this.visibility&&(t.layout=t.layout||{},t.layout.visibility=this.visibility),I(t,(t,e)=>!(void 0===t||"layout"===e&&!Object.keys(t).length||"paint"===e&&!Object.keys(t).length))}_validate(t,e,r,i,n={}){return (!n||!1!==n.validate)&&Ui(this,t.call(Vi,{key:e,layerType:this.type,objectKey:r,value:i,styleSpec:Ft,style:{glyphs:!0,sprite:!0}}))}is3D(){return !1}isSky(){return !1}isTileClipped(){return !1}hasOffscreenPass(){return !1}resize(){}isStateDependent(){for(const t in this.paint._values){const e=this.paint.get(t);if(e instanceof Hn&&Or(e.property.specification)&&("source"===e.value.kind||"composite"===e.value.kind)&&e.value.isStateDependent)return !0}return !1}}const da=os([{name:"a_pos",components:2,type:"Int16"}],4),{members:fa}=da;class ya{constructor(t=[]){this.segments=t;}prepareSegment(t,e,r,i){let n=this.segments[this.segments.length-1];return t>ya.MAX_VERTEX_ARRAY_LENGTH&&E(`Max vertices per segment is ${ya.MAX_VERTEX_ARRAY_LENGTH}: bucket requested ${t}`),(!n||n.vertexLength+t>ya.MAX_VERTEX_ARRAY_LENGTH||n.sortKey!==i)&&(n={vertexOffset:e.length,primitiveOffset:r.length,vertexLength:0,primitiveLength:0},void 0!==i&&(n.sortKey=i),this.segments.push(n)),n}get(){return this.segments}destroy(){for(const t of this.segments)for(const e in t.vaos)t.vaos[e].destroy();}static simpleSegment(t,e,r,i){return new ya([{vertexOffset:t,primitiveOffset:e,vertexLength:r,primitiveLength:i,vaos:{},sortKey:0}])}}ya.MAX_VERTEX_ARRAY_LENGTH=Math.pow(2,16)-1,Gi("SegmentVector",ya);const ma=Math.pow(2,14)-1,ga=-ma-1;function xa(t){const e=8192/t.extent,r=t.loadGeometry();for(let t=0;t<r.length;t++){const i=r[t];for(let t=0;t<i.length;t++){const r=i[t],n=Math.round(r.x*e),s=Math.round(r.y*e);r.x=f(n,ga,ma),r.y=f(s,ga,ma),(n<r.x||n>r.x+1||s<r.y||s>r.y+1)&&E("Geometry exceeds allowed extent, reduce your vector tile buffer size");}}return r}function va(t,e){return {type:t.type,id:t.id,properties:t.properties,geometry:e?xa(t):[]}}function ba(t,e,r,i,n){t.emplaceBack(2*e+(i+1)/2,2*r+(n+1)/2);}class wa{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new us,this.indexArray=new ws,this.segments=new ya,this.programConfigurations=new ua(t.layers,t.zoom),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){const i=this.layers[0],n=[];let s=null;"circle"===i.type&&(s=i.layout.get("circle-sort-key"));for(const{feature:e,id:i,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=va(e,t);if(!this.layers[0]._featureFilter.filter(new qn(this.zoom),l,r))continue;const u=s?s.evaluate(l,{},r):void 0,c={id:i,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:xa(e),patterns:{},sortKey:u};n.push(c);}s&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i,o=t[s].feature;this.addFeature(i,n,s,r),e.featureIndex.insert(o,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,fa),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,i){for(const r of e)for(const e of r){const r=e.x,i=e.y;if(r<0||r>=8192||i<0||i>=8192)continue;const n=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray,t.sortKey),s=n.vertexLength;ba(this.layoutVertexArray,r,i,-1,-1),ba(this.layoutVertexArray,r,i,1,-1),ba(this.layoutVertexArray,r,i,1,1),ba(this.layoutVertexArray,r,i,-1,1),this.indexArray.emplaceBack(s,s+1,s+2),this.indexArray.emplaceBack(s,s+3,s+2),n.vertexLength+=4,n.primitiveLength+=2;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,{},i);}}function _a(t,e){for(let r=0;r<t.length;r++)if(Ba(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ba(t,e[r]))return !0;return !!Ia(t,e)}function ka(t,e,r){return !!Ba(t,e)||!!za(e,t,r)}function Aa(t,e){if(1===t.length)return Ma(e,t[0]);for(let r=0;r<e.length;r++){const i=e[r];for(let e=0;e<i.length;e++)if(Ba(t,i[e]))return !0}for(let r=0;r<t.length;r++)if(Ma(e,t[r]))return !0;for(let r=0;r<e.length;r++)if(Ia(t,e[r]))return !0;return !1}function Sa(t,e,r){if(t.length>1){if(Ia(t,e))return !0;for(let i=0;i<e.length;i++)if(za(e[i],t,r))return !0}for(let i=0;i<t.length;i++)if(za(t[i],e,r))return !0;return !1}function Ia(t,e){if(0===t.length||0===e.length)return !1;for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1];for(let t=0;t<e.length-1;t++)if(Ta(i,n,e[t],e[t+1]))return !0}return !1}function Ta(t,e,r,i){return M(t,r,i)!==M(e,r,i)&&M(t,e,r)!==M(t,e,i)}function za(t,e,r){const i=r*r;if(1===e.length)return t.distSqr(e[0])<i;for(let r=1;r<e.length;r++)if(Ea(t,e[r-1],e[r])<i)return !0;return !1}function Ea(t,e,r){const i=e.distSqr(r);if(0===i)return t.distSqr(e);const n=((t.x-e.x)*(r.x-e.x)+(t.y-e.y)*(r.y-e.y))/i;return t.distSqr(n<0?e:n>1?r:r.sub(e)._mult(n)._add(e))}function Ma(t,e){let r,i,n,s=!1;for(let a=0;a<t.length;a++){r=t[a];for(let t=0,a=r.length-1;t<r.length;a=t++)i=r[t],n=r[a],i.y>e.y!=n.y>e.y&&e.x<(n.x-i.x)*(e.y-i.y)/(n.y-i.y)+i.x&&(s=!s);}return s}function Ba(t,e){let r=!1;for(let i=0,n=t.length-1;i<t.length;n=i++){const s=t[i],a=t[n];s.y>e.y!=a.y>e.y&&e.x<(a.x-s.x)*(e.y-s.y)/(a.y-s.y)+s.x&&(r=!r);}return r}function Da(t,e,r,n,s){for(const i of t)if(e<=i.x&&r<=i.y&&n>=i.x&&s>=i.y)return !0;const a=[new i(e,r),new i(e,s),new i(n,s),new i(n,r)];if(t.length>2)for(const e of a)if(Ba(t,e))return !0;for(let e=0;e<t.length-1;e++)if(Ca(t[e],t[e+1],a))return !0;return !1}function Ca(t,e,r){const i=r[0],n=r[2];if(t.x<i.x&&e.x<i.x||t.x>n.x&&e.x>n.x||t.y<i.y&&e.y<i.y||t.y>n.y&&e.y>n.y)return !1;const s=M(t,e,r[0]);return s!==M(t,e,r[1])||s!==M(t,e,r[2])||s!==M(t,e,r[3])}function Pa(t,e,r){const i=e.paint.get(t).value;return "constant"===i.kind?i.value:r.programConfigurations.get(e.id).getMaxValue(t)}function Va(t){return Math.sqrt(t[0]*t[0]+t[1]*t[1])}function Fa(t,e,r,n,s){if(!e[0]&&!e[1])return t;const a=i.convert(e)._mult(s);"viewport"===r&&a._rotate(-n);const o=[];for(let e=0;e<t.length;e++)o.push(t[e].sub(a));return o}function Ra(t,e,r,n){const s=i.convert(t)._mult(n);return "viewport"===e&&s._rotate(-r),s}Gi("CircleBucket",wa,{omit:["layers"]});const La=new rs({"circle-sort-key":new Jn(Ft.layout_circle["circle-sort-key"])});var Ua={paint:new rs({"circle-radius":new Jn(Ft.paint_circle["circle-radius"]),"circle-color":new Jn(Ft.paint_circle["circle-color"]),"circle-blur":new Jn(Ft.paint_circle["circle-blur"]),"circle-opacity":new Jn(Ft.paint_circle["circle-opacity"]),"circle-translate":new Wn(Ft.paint_circle["circle-translate"]),"circle-translate-anchor":new Wn(Ft.paint_circle["circle-translate-anchor"]),"circle-pitch-scale":new Wn(Ft.paint_circle["circle-pitch-scale"]),"circle-pitch-alignment":new Wn(Ft.paint_circle["circle-pitch-alignment"]),"circle-stroke-width":new Jn(Ft.paint_circle["circle-stroke-width"]),"circle-stroke-color":new Jn(Ft.paint_circle["circle-stroke-color"]),"circle-stroke-opacity":new Jn(Ft.paint_circle["circle-stroke-opacity"])}),layout:La},Oa="undefined"!=typeof Float32Array?Float32Array:Array;function $a(){var t=new Oa(9);return Oa!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[5]=0,t[6]=0,t[7]=0),t[0]=1,t[4]=1,t[8]=1,t}function qa(t){return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t}function Na(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],y=e[12],m=e[13],g=e[14],x=e[15],v=r[0],b=r[1],w=r[2],_=r[3];return t[0]=v*i+b*o+w*h+_*y,t[1]=v*n+b*l+w*p+_*m,t[2]=v*s+b*u+w*d+_*g,t[3]=v*a+b*c+w*f+_*x,t[4]=(v=r[4])*i+(b=r[5])*o+(w=r[6])*h+(_=r[7])*y,t[5]=v*n+b*l+w*p+_*m,t[6]=v*s+b*u+w*d+_*g,t[7]=v*a+b*c+w*f+_*x,t[8]=(v=r[8])*i+(b=r[9])*o+(w=r[10])*h+(_=r[11])*y,t[9]=v*n+b*l+w*p+_*m,t[10]=v*s+b*u+w*d+_*g,t[11]=v*a+b*c+w*f+_*x,t[12]=(v=r[12])*i+(b=r[13])*o+(w=r[14])*h+(_=r[15])*y,t[13]=v*n+b*l+w*p+_*m,t[14]=v*s+b*u+w*d+_*g,t[15]=v*a+b*c+w*f+_*x,t}Math.hypot||(Math.hypot=function(){for(var t=0,e=arguments.length;e--;)t+=arguments[e]*arguments[e];return Math.sqrt(t)});var ja=Na;function Ga(){var t=new Oa(3);return Oa!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t}function Za(t){var e=new Oa(3);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e}function Xa(t){return Math.hypot(t[0],t[1],t[2])}function Ka(t,e,r){var i=new Oa(3);return i[0]=t,i[1]=e,i[2]=r,i}function Ha(t,e,r){return t[0]=e[0]+r[0],t[1]=e[1]+r[1],t[2]=e[2]+r[2],t}function Ya(t,e,r){return t[0]=e[0]-r[0],t[1]=e[1]-r[1],t[2]=e[2]-r[2],t}function Wa(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t}function Ja(t,e,r,i){return t[0]=e[0]+r[0]*i,t[1]=e[1]+r[1]*i,t[2]=e[2]+r[2]*i,t}function Qa(t,e){var r=e[0],i=e[1],n=e[2],s=r*r+i*i+n*n;return s>0&&(s=1/Math.sqrt(s)),t[0]=e[0]*s,t[1]=e[1]*s,t[2]=e[2]*s,t}function to(t,e){return t[0]*e[0]+t[1]*e[1]+t[2]*e[2]}function eo(t,e,r){var i=e[0],n=e[1],s=e[2],a=r[0],o=r[1],l=r[2];return t[0]=n*l-s*o,t[1]=s*a-i*l,t[2]=i*o-n*a,t}function ro(t,e,r){var i=e[0],n=e[1],s=e[2],a=r[3]*i+r[7]*n+r[11]*s+r[15];return t[0]=(r[0]*i+r[4]*n+r[8]*s+r[12])/(a=a||1),t[1]=(r[1]*i+r[5]*n+r[9]*s+r[13])/a,t[2]=(r[2]*i+r[6]*n+r[10]*s+r[14])/a,t}function io(t,e,r){var i=r[0],n=r[1],s=r[2],a=e[0],o=e[1],l=e[2],u=n*l-s*o,c=s*a-i*l,h=i*o-n*a,p=n*h-s*c,d=s*u-i*h,f=i*c-n*u,y=2*r[3];return c*=y,h*=y,d*=2,f*=2,t[0]=a+(u*=y)+(p*=2),t[1]=o+c+d,t[2]=l+h+f,t}var no,so=Ya,ao=Xa;function oo(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3];return t[0]=r[0]*i+r[4]*n+r[8]*s+r[12]*a,t[1]=r[1]*i+r[5]*n+r[9]*s+r[13]*a,t[2]=r[2]*i+r[6]*n+r[10]*s+r[14]*a,t[3]=r[3]*i+r[7]*n+r[11]*s+r[15]*a,t}function lo(){var t=new Oa(4);return Oa!=Float32Array&&(t[0]=0,t[1]=0,t[2]=0),t[3]=1,t}function uo(t){return t[0]=0,t[1]=0,t[2]=0,t[3]=1,t}function co(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+a*o,t[1]=n*l+s*o,t[2]=s*l-n*o,t[3]=a*l-i*o,t}Ga(),no=new Oa(4),Oa!=Float32Array&&(no[0]=0,no[1]=0,no[2]=0,no[3]=0),Ga(),Ka(1,0,0),Ka(0,1,0),lo(),lo(),$a();class ho{constructor(t,e){this.points=t,this.planes=e;}static fromInvProjectionMatrix(t,e,r){const i=Math.pow(2,r),n=[[-1,1,-1,1],[1,1,-1,1],[1,-1,-1,1],[-1,-1,-1,1],[-1,1,1,1],[1,1,1,1],[1,-1,1,1],[-1,-1,1,1]].map(r=>{const n=oo([],r,t),s=1/n[3]/e*i;return function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t[3]=e[3]*r[3],t}(n,n,[s,s,1/n[3],s])}),s=[[0,1,2],[6,5,4],[0,3,7],[2,1,5],[3,2,6],[0,4,5]].map(t=>{const e=Qa([],eo([],so([],n[t[0]],n[t[1]]),so([],n[t[2]],n[t[1]]))),r=-to(e,n[t[1]]);return e.concat(r)});return new ho(n,s)}}class po{constructor(t,e){this.min=t,this.max=e,this.center=Wa([],Ha([],this.min,this.max),.5);}quadrant(t){const e=[t%2==0,t<2],r=Za(this.min),i=Za(this.max);for(let t=0;t<e.length;t++)r[t]=e[t]?this.min[t]:this.center[t],i[t]=e[t]?this.center[t]:this.max[t];return i[2]=this.max[2],new po(r,i)}distanceX(t){return Math.max(Math.min(this.max[0],t[0]),this.min[0])-t[0]}distanceY(t){return Math.max(Math.min(this.max[1],t[1]),this.min[1])-t[1]}distanceZ(t){return Math.max(Math.min(this.max[2],t[2]),this.min[2])-t[2]}intersects(t){const e=[[this.min[0],this.min[1],this.min[2],1],[this.max[0],this.min[1],this.min[2],1],[this.max[0],this.max[1],this.min[2],1],[this.min[0],this.max[1],this.min[2],1],[this.min[0],this.min[1],this.max[2],1],[this.max[0],this.min[1],this.max[2],1],[this.max[0],this.max[1],this.max[2],1],[this.min[0],this.max[1],this.max[2],1]];let r=!0;for(let s=0;s<t.planes.length;s++){const a=t.planes[s];let o=0;for(let t=0;t<e.length;t++)o+=(i=a)[0]*(n=e[t])[0]+i[1]*n[1]+i[2]*n[2]+i[3]*n[3]>=0;if(0===o)return 0;o!==e.length&&(r=!1);}var i,n;if(r)return 2;for(let e=0;e<3;e++){let r=Number.MAX_VALUE,i=-Number.MAX_VALUE;for(let n=0;n<t.points.length;n++){const s=t.points[n][e]-this.min[e];r=Math.min(r,s),i=Math.max(i,s);}if(i<0||r>this.max[e]-this.min[e])return 0}return 1}}function fo(t,e,r){const n=oo([],[t.x,t.y,e,1],r);return new i(n[0]/n[3],n[1]/n[3])}const yo=Ka(0,0,0),mo=Ka(0,0,1);function go(t,e){const r=Ga();return yo[2]=e,t.intersectsPlane(yo,mo,r),new i(r[0],r[1])}class xo extends wa{}function vo(t,{width:e,height:r},i,n){if(n){if(n instanceof Uint8ClampedArray)n=new Uint8Array(n.buffer);else if(n.length!==e*r*i)throw new RangeError("mismatched image size")}else n=new Uint8Array(e*r*i);return t.width=e,t.height=r,t.data=n,t}function bo(t,{width:e,height:r},i){if(e===t.width&&r===t.height)return;const n=vo({},{width:e,height:r},i);wo(t,n,{x:0,y:0},{x:0,y:0},{width:Math.min(t.width,e),height:Math.min(t.height,r)},i),t.width=e,t.height=r,t.data=n.data;}function wo(t,e,r,i,n,s){if(0===n.width||0===n.height)return e;if(n.width>t.width||n.height>t.height||r.x>t.width-n.width||r.y>t.height-n.height)throw new RangeError("out of range source coordinates for image copy");if(n.width>e.width||n.height>e.height||i.x>e.width-n.width||i.y>e.height-n.height)throw new RangeError("out of range destination coordinates for image copy");const a=t.data,o=e.data;for(let l=0;l<n.height;l++){const u=((r.y+l)*t.width+r.x)*s,c=((i.y+l)*e.width+i.x)*s;for(let t=0;t<n.width*s;t++)o[c+t]=a[u+t];}return e}Gi("HeatmapBucket",xo,{omit:["layers"]});class _o{constructor(t,e){vo(this,t,1,e);}resize(t){bo(this,t,1);}clone(){return new _o({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,i,n){wo(t,e,r,i,n,1);}}class ko{constructor(t,e){vo(this,t,4,e);}resize(t){bo(this,t,4);}replace(t,e){e?this.data.set(t):this.data=t instanceof Uint8ClampedArray?new Uint8Array(t.buffer):t;}clone(){return new ko({width:this.width,height:this.height},new Uint8Array(this.data))}static copy(t,e,r,i,n){wo(t,e,r,i,n,4);}}Gi("AlphaImage",_o),Gi("RGBAImage",ko);var Ao={paint:new rs({"heatmap-radius":new Jn(Ft.paint_heatmap["heatmap-radius"]),"heatmap-weight":new Jn(Ft.paint_heatmap["heatmap-weight"]),"heatmap-intensity":new Wn(Ft.paint_heatmap["heatmap-intensity"]),"heatmap-color":new es(Ft.paint_heatmap["heatmap-color"]),"heatmap-opacity":new Wn(Ft.paint_heatmap["heatmap-opacity"])})};function So(t){const e={},r=t.resolution||256,i=t.clips?t.clips.length:1,n=t.image||new ko({width:r,height:i}),s=(r,i,s)=>{e[t.evaluationKey]=s;const a=t.expression.evaluate(e);n.data[r+i+0]=Math.floor(255*a.r/a.a),n.data[r+i+1]=Math.floor(255*a.g/a.a),n.data[r+i+2]=Math.floor(255*a.b/a.a),n.data[r+i+3]=Math.floor(255*a.a);};if(t.clips)for(let e=0,n=0;e<i;++e,n+=4*r)for(let i=0,a=0;i<r;i++,a+=4){const o=i/(r-1),{start:l,end:u}=t.clips[e];s(n,a,l*(1-o)+u*o);}else for(let t=0,e=0;t<r;t++,e+=4)s(0,e,t/(r-1));return n}var Io={paint:new rs({"hillshade-illumination-direction":new Wn(Ft.paint_hillshade["hillshade-illumination-direction"]),"hillshade-illumination-anchor":new Wn(Ft.paint_hillshade["hillshade-illumination-anchor"]),"hillshade-exaggeration":new Wn(Ft.paint_hillshade["hillshade-exaggeration"]),"hillshade-shadow-color":new Wn(Ft.paint_hillshade["hillshade-shadow-color"]),"hillshade-highlight-color":new Wn(Ft.paint_hillshade["hillshade-highlight-color"]),"hillshade-accent-color":new Wn(Ft.paint_hillshade["hillshade-accent-color"])})};const To=os([{name:"a_pos",components:2,type:"Int16"}],4),{members:zo}=To;var Eo=Bo,Mo=Bo;function Bo(t,e,r){r=r||2;var i,n,s,a,o,l,u,c=e&&e.length,h=c?e[0]*r:t.length,p=Do(t,0,h,r,!0),d=[];if(!p||p.next===p.prev)return d;if(c&&(p=function(t,e,r,i){var n,s,a,o=[];for(n=0,s=e.length;n<s;n++)(a=Do(t,e[n]*i,n<s-1?e[n+1]*i:t.length,i,!1))===a.next&&(a.steiner=!0),o.push(No(a));for(o.sort(Uo),n=0;n<o.length;n++)Oo(o[n],r),r=Co(r,r.next);return r}(t,e,p,r)),t.length>80*r){i=s=t[0],n=a=t[1];for(var f=r;f<h;f+=r)(o=t[f])<i&&(i=o),(l=t[f+1])<n&&(n=l),o>s&&(s=o),l>a&&(a=l);u=0!==(u=Math.max(s-i,a-n))?1/u:0;}return Po(p,d,r,i,n,u),d}function Do(t,e,r,i,n){var s,a;if(n===rl(t,e,r,i)>0)for(s=e;s<r;s+=i)a=Qo(s,t[s],t[s+1],a);else for(s=r-i;s>=e;s-=i)a=Qo(s,t[s],t[s+1],a);return a&&Xo(a,a.next)&&(tl(a),a=a.next),a}function Co(t,e){if(!t)return t;e||(e=t);var r,i=t;do{if(r=!1,i.steiner||!Xo(i,i.next)&&0!==Zo(i.prev,i,i.next))i=i.next;else {if(tl(i),(i=e=i.prev)===i.next)break;r=!0;}}while(r||i!==e);return e}function Po(t,e,r,i,n,s,a){if(t){!a&&s&&function(t,e,r,i){var n=t;do{null===n.z&&(n.z=qo(n.x,n.y,e,r,i)),n.prevZ=n.prev,n.nextZ=n.next,n=n.next;}while(n!==t);n.prevZ.nextZ=null,n.prevZ=null,function(t){var e,r,i,n,s,a,o,l,u=1;do{for(r=t,t=null,s=null,a=0;r;){for(a++,i=r,o=0,e=0;e<u&&(o++,i=i.nextZ);e++);for(l=u;o>0||l>0&&i;)0!==o&&(0===l||!i||r.z<=i.z)?(n=r,r=r.nextZ,o--):(n=i,i=i.nextZ,l--),s?s.nextZ=n:t=n,n.prevZ=s,s=n;r=i;}s.nextZ=null,u*=2;}while(a>1)}(n);}(t,i,n,s);for(var o,l,u=t;t.prev!==t.next;)if(o=t.prev,l=t.next,s?Fo(t,i,n,s):Vo(t))e.push(o.i/r),e.push(t.i/r),e.push(l.i/r),tl(t),t=l.next,u=l.next;else if((t=l)===u){a?1===a?Po(t=Ro(Co(t),e,r),e,r,i,n,s,2):2===a&&Lo(t,e,r,i,n,s):Po(Co(t),e,r,i,n,s,1);break}}}function Vo(t){var e=t.prev,r=t,i=t.next;if(Zo(e,r,i)>=0)return !1;for(var n=t.next.next;n!==t.prev;){if(jo(e.x,e.y,r.x,r.y,i.x,i.y,n.x,n.y)&&Zo(n.prev,n,n.next)>=0)return !1;n=n.next;}return !0}function Fo(t,e,r,i){var n=t.prev,s=t,a=t.next;if(Zo(n,s,a)>=0)return !1;for(var o=n.x>s.x?n.x>a.x?n.x:a.x:s.x>a.x?s.x:a.x,l=n.y>s.y?n.y>a.y?n.y:a.y:s.y>a.y?s.y:a.y,u=qo(n.x<s.x?n.x<a.x?n.x:a.x:s.x<a.x?s.x:a.x,n.y<s.y?n.y<a.y?n.y:a.y:s.y<a.y?s.y:a.y,e,r,i),c=qo(o,l,e,r,i),h=t.prevZ,p=t.nextZ;h&&h.z>=u&&p&&p.z<=c;){if(h!==t.prev&&h!==t.next&&jo(n.x,n.y,s.x,s.y,a.x,a.y,h.x,h.y)&&Zo(h.prev,h,h.next)>=0)return !1;if(h=h.prevZ,p!==t.prev&&p!==t.next&&jo(n.x,n.y,s.x,s.y,a.x,a.y,p.x,p.y)&&Zo(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}for(;h&&h.z>=u;){if(h!==t.prev&&h!==t.next&&jo(n.x,n.y,s.x,s.y,a.x,a.y,h.x,h.y)&&Zo(h.prev,h,h.next)>=0)return !1;h=h.prevZ;}for(;p&&p.z<=c;){if(p!==t.prev&&p!==t.next&&jo(n.x,n.y,s.x,s.y,a.x,a.y,p.x,p.y)&&Zo(p.prev,p,p.next)>=0)return !1;p=p.nextZ;}return !0}function Ro(t,e,r){var i=t;do{var n=i.prev,s=i.next.next;!Xo(n,s)&&Ko(n,i,i.next,s)&&Wo(n,s)&&Wo(s,n)&&(e.push(n.i/r),e.push(i.i/r),e.push(s.i/r),tl(i),tl(i.next),i=t=s),i=i.next;}while(i!==t);return Co(i)}function Lo(t,e,r,i,n,s){var a=t;do{for(var o=a.next.next;o!==a.prev;){if(a.i!==o.i&&Go(a,o)){var l=Jo(a,o);return a=Co(a,a.next),l=Co(l,l.next),Po(a,e,r,i,n,s),void Po(l,e,r,i,n,s)}o=o.next;}a=a.next;}while(a!==t)}function Uo(t,e){return t.x-e.x}function Oo(t,e){if(e=function(t,e){var r,i=e,n=t.x,s=t.y,a=-1/0;do{if(s<=i.y&&s>=i.next.y&&i.next.y!==i.y){var o=i.x+(s-i.y)*(i.next.x-i.x)/(i.next.y-i.y);if(o<=n&&o>a){if(a=o,o===n){if(s===i.y)return i;if(s===i.next.y)return i.next}r=i.x<i.next.x?i:i.next;}}i=i.next;}while(i!==e);if(!r)return null;if(n===a)return r;var l,u=r,c=r.x,h=r.y,p=1/0;i=r;do{n>=i.x&&i.x>=c&&n!==i.x&&jo(s<h?n:a,s,c,h,s<h?a:n,s,i.x,i.y)&&(l=Math.abs(s-i.y)/(n-i.x),Wo(i,t)&&(l<p||l===p&&(i.x>r.x||i.x===r.x&&$o(r,i)))&&(r=i,p=l)),i=i.next;}while(i!==u);return r}(t,e)){var r=Jo(e,t);Co(e,e.next),Co(r,r.next);}}function $o(t,e){return Zo(t.prev,t,e.prev)<0&&Zo(e.next,t,t.next)<0}function qo(t,e,r,i,n){return (t=1431655765&((t=858993459&((t=252645135&((t=16711935&((t=32767*(t-r)*n)|t<<8))|t<<4))|t<<2))|t<<1))|(e=1431655765&((e=858993459&((e=252645135&((e=16711935&((e=32767*(e-i)*n)|e<<8))|e<<4))|e<<2))|e<<1))<<1}function No(t){var e=t,r=t;do{(e.x<r.x||e.x===r.x&&e.y<r.y)&&(r=e),e=e.next;}while(e!==t);return r}function jo(t,e,r,i,n,s,a,o){return (n-a)*(e-o)-(t-a)*(s-o)>=0&&(t-a)*(i-o)-(r-a)*(e-o)>=0&&(r-a)*(s-o)-(n-a)*(i-o)>=0}function Go(t,e){return t.next.i!==e.i&&t.prev.i!==e.i&&!function(t,e){var r=t;do{if(r.i!==t.i&&r.next.i!==t.i&&r.i!==e.i&&r.next.i!==e.i&&Ko(r,r.next,t,e))return !0;r=r.next;}while(r!==t);return !1}(t,e)&&(Wo(t,e)&&Wo(e,t)&&function(t,e){var r=t,i=!1,n=(t.x+e.x)/2,s=(t.y+e.y)/2;do{r.y>s!=r.next.y>s&&r.next.y!==r.y&&n<(r.next.x-r.x)*(s-r.y)/(r.next.y-r.y)+r.x&&(i=!i),r=r.next;}while(r!==t);return i}(t,e)&&(Zo(t.prev,t,e.prev)||Zo(t,e.prev,e))||Xo(t,e)&&Zo(t.prev,t,t.next)>0&&Zo(e.prev,e,e.next)>0)}function Zo(t,e,r){return (e.y-t.y)*(r.x-e.x)-(e.x-t.x)*(r.y-e.y)}function Xo(t,e){return t.x===e.x&&t.y===e.y}function Ko(t,e,r,i){var n=Yo(Zo(t,e,r)),s=Yo(Zo(t,e,i)),a=Yo(Zo(r,i,t)),o=Yo(Zo(r,i,e));return n!==s&&a!==o||!(0!==n||!Ho(t,r,e))||!(0!==s||!Ho(t,i,e))||!(0!==a||!Ho(r,t,i))||!(0!==o||!Ho(r,e,i))}function Ho(t,e,r){return e.x<=Math.max(t.x,r.x)&&e.x>=Math.min(t.x,r.x)&&e.y<=Math.max(t.y,r.y)&&e.y>=Math.min(t.y,r.y)}function Yo(t){return t>0?1:t<0?-1:0}function Wo(t,e){return Zo(t.prev,t,t.next)<0?Zo(t,e,t.next)>=0&&Zo(t,t.prev,e)>=0:Zo(t,e,t.prev)<0||Zo(t,t.next,e)<0}function Jo(t,e){var r=new el(t.i,t.x,t.y),i=new el(e.i,e.x,e.y),n=t.next,s=e.prev;return t.next=e,e.prev=t,r.next=n,n.prev=r,i.next=r,r.prev=i,s.next=i,i.prev=s,i}function Qo(t,e,r,i){var n=new el(t,e,r);return i?(n.next=i.next,n.prev=i,i.next.prev=n,i.next=n):(n.prev=n,n.next=n),n}function tl(t){t.next.prev=t.prev,t.prev.next=t.next,t.prevZ&&(t.prevZ.nextZ=t.nextZ),t.nextZ&&(t.nextZ.prevZ=t.prevZ);}function el(t,e,r){this.i=t,this.x=e,this.y=r,this.prev=null,this.next=null,this.z=null,this.prevZ=null,this.nextZ=null,this.steiner=!1;}function rl(t,e,r,i){for(var n=0,s=e,a=r-i;s<r;s+=i)n+=(t[a]-t[s])*(t[s+1]+t[a+1]),a=s;return n}function il(t,e,r,i,n){!function t(e,r,i,n,s){for(;n>i;){if(n-i>600){var a=n-i+1,o=r-i+1,l=Math.log(a),u=.5*Math.exp(2*l/3),c=.5*Math.sqrt(l*u*(a-u)/a)*(o-a/2<0?-1:1);t(e,r,Math.max(i,Math.floor(r-o*u/a+c)),Math.min(n,Math.floor(r+(a-o)*u/a+c)),s);}var h=e[r],p=i,d=n;for(nl(e,i,r),s(e[n],h)>0&&nl(e,i,n);p<d;){for(nl(e,p,d),p++,d--;s(e[p],h)<0;)p++;for(;s(e[d],h)>0;)d--;}0===s(e[i],h)?nl(e,i,d):nl(e,++d,n),d<=r&&(i=d+1),r<=d&&(n=d-1);}}(t,e,r||0,i||t.length-1,n||sl);}function nl(t,e,r){var i=t[e];t[e]=t[r],t[r]=i;}function sl(t,e){return t<e?-1:t>e?1:0}function al(t,e){const r=t.length;if(r<=1)return [t];const i=[];let n,s;for(let e=0;e<r;e++){const r=B(t[e]);0!==r&&(t[e].area=Math.abs(r),void 0===s&&(s=r<0),s===r<0?(n&&i.push(n),n=[t[e]]):n.push(t[e]));}if(n&&i.push(n),e>1)for(let t=0;t<i.length;t++)i[t].length<=e||(il(i[t],e,1,i[t].length-1,ol),i[t]=i[t].slice(0,e));return i}function ol(t,e){return e.area-t.area}function ll(t,e,r){const i=r.patternDependencies;let n=!1;for(const r of e){const e=r.paint.get(`${t}-pattern`);e.isConstant()||(n=!0);const s=e.constantOr(null);s&&(n=!0,i[s.to]=!0,i[s.from]=!0);}return n}function ul(t,e,r,i,n){const s=n.patternDependencies;for(const a of e){const e=a.paint.get(`${t}-pattern`).value;if("constant"!==e.kind){let t=e.evaluate({zoom:i-1},r,{},n.availableImages),o=e.evaluate({zoom:i},r,{},n.availableImages),l=e.evaluate({zoom:i+1},r,{},n.availableImages);t=t&&t.name?t.name:t,o=o&&o.name?o.name:o,l=l&&l.name?l.name:l,s[t]=!0,s[o]=!0,s[l]=!0,r.patterns[a.id]={min:t,mid:o,max:l};}}return r}Bo.deviation=function(t,e,r,i){var n=e&&e.length,s=Math.abs(rl(t,0,n?e[0]*r:t.length,r));if(n)for(var a=0,o=e.length;a<o;a++)s-=Math.abs(rl(t,e[a]*r,a<o-1?e[a+1]*r:t.length,r));var l=0;for(a=0;a<i.length;a+=3){var u=i[a]*r,c=i[a+1]*r,h=i[a+2]*r;l+=Math.abs((t[u]-t[h])*(t[c+1]-t[u+1])-(t[u]-t[c])*(t[h+1]-t[u+1]));}return 0===s&&0===l?0:Math.abs((l-s)/s)},Bo.flatten=function(t){for(var e=t[0][0].length,r={vertices:[],holes:[],dimensions:e},i=0,n=0;n<t.length;n++){for(var s=0;s<t[n].length;s++)for(var a=0;a<e;a++)r.vertices.push(t[n][s][a]);n>0&&r.holes.push(i+=t[n-1].length);}return r},Eo.default=Mo;class cl{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.layoutVertexArray=new us,this.indexArray=new ws,this.indexArray2=new Ts,this.programConfigurations=new ua(t.layers,t.zoom),this.segments=new ya,this.segments2=new ya,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasPattern=ll("fill",this.layers,e);const i=this.layers[0].layout.get("fill-sort-key"),n=[];for(const{feature:s,id:a,index:o,sourceLayerIndex:l}of t){const t=this.layers[0]._featureFilter.needGeometry,u=va(s,t);if(!this.layers[0]._featureFilter.filter(new qn(this.zoom),u,r))continue;const c=i?i.evaluate(u,{},r,e.availableImages):void 0,h={id:a,properties:s.properties,type:s.type,sourceLayerIndex:l,index:o,geometry:t?u.geometry:xa(s),patterns:{},sortKey:c};n.push(h);}i&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i;if(this.hasPattern){const t=ul("fill",this.layers,i,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(i,n,s,r,{});e.featureIndex.insert(t[s].feature,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,zo),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.indexBuffer2=t.createIndexBuffer(this.indexArray2)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.indexBuffer2.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.segments2.destroy());}addFeature(t,e,r,i,n){for(const t of al(e,500)){let e=0;for(const r of t)e+=r.length;const r=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray),i=r.vertexLength,n=[],s=[];for(const e of t){if(0===e.length)continue;e!==t[0]&&s.push(n.length/2);const r=this.segments2.prepareSegment(e.length,this.layoutVertexArray,this.indexArray2),i=r.vertexLength;this.layoutVertexArray.emplaceBack(e[0].x,e[0].y),this.indexArray2.emplaceBack(i+e.length-1,i),n.push(e[0].x),n.push(e[0].y);for(let t=1;t<e.length;t++)this.layoutVertexArray.emplaceBack(e[t].x,e[t].y),this.indexArray2.emplaceBack(i+t-1,i+t),n.push(e[t].x),n.push(e[t].y);r.vertexLength+=e.length,r.primitiveLength+=e.length;}const a=Eo(n,s);for(let t=0;t<a.length;t+=3)this.indexArray.emplaceBack(i+a[t],i+a[t+1],i+a[t+2]);r.vertexLength+=e,r.primitiveLength+=a.length/3;}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}}Gi("FillBucket",cl,{omit:["layers","patternFeatures"]});const hl=new rs({"fill-sort-key":new Jn(Ft.layout_fill["fill-sort-key"])});var pl={paint:new rs({"fill-antialias":new Wn(Ft.paint_fill["fill-antialias"]),"fill-opacity":new Jn(Ft.paint_fill["fill-opacity"]),"fill-color":new Jn(Ft.paint_fill["fill-color"]),"fill-outline-color":new Jn(Ft.paint_fill["fill-outline-color"]),"fill-translate":new Wn(Ft.paint_fill["fill-translate"]),"fill-translate-anchor":new Wn(Ft.paint_fill["fill-translate-anchor"]),"fill-pattern":new Qn(Ft.paint_fill["fill-pattern"])}),layout:hl};const dl=os([{name:"a_pos_normal_ed",components:4,type:"Int16"}]),fl=os([{name:"a_centroid_pos",components:2,type:"Uint16"}]),{members:yl}=dl;var ml=gl;function gl(t,e,r,i,n){this.properties={},this.extent=r,this.type=0,this._pbf=t,this._geometry=-1,this._keys=i,this._values=n,t.readFields(xl,this,e);}function xl(t,e,r){1==t?e.id=r.readVarint():2==t?function(t,e){for(var r=t.readVarint()+t.pos;t.pos<r;){var i=e._keys[t.readVarint()],n=e._values[t.readVarint()];e.properties[i]=n;}}(r,e):3==t?e.type=r.readVarint():4==t&&(e._geometry=r.pos);}function vl(t){for(var e,r,i=0,n=0,s=t.length,a=s-1;n<s;a=n++)i+=((r=t[a]).x-(e=t[n]).x)*(e.y+r.y);return i}gl.types=["Unknown","Point","LineString","Polygon"],gl.prototype.loadGeometry=function(){var t=this._pbf;t.pos=this._geometry;for(var e,r=t.readVarint()+t.pos,n=1,s=0,a=0,o=0,l=[];t.pos<r;){if(s<=0){var u=t.readVarint();n=7&u,s=u>>3;}if(s--,1===n||2===n)a+=t.readSVarint(),o+=t.readSVarint(),1===n&&(e&&l.push(e),e=[]),e.push(new i(a,o));else {if(7!==n)throw new Error("unknown command "+n);e&&e.push(e[0].clone());}}return e&&l.push(e),l},gl.prototype.bbox=function(){var t=this._pbf;t.pos=this._geometry;for(var e=t.readVarint()+t.pos,r=1,i=0,n=0,s=0,a=1/0,o=-1/0,l=1/0,u=-1/0;t.pos<e;){if(i<=0){var c=t.readVarint();r=7&c,i=c>>3;}if(i--,1===r||2===r)(n+=t.readSVarint())<a&&(a=n),n>o&&(o=n),(s+=t.readSVarint())<l&&(l=s),s>u&&(u=s);else if(7!==r)throw new Error("unknown command "+r)}return [a,l,o,u]},gl.prototype.toGeoJSON=function(t,e,r){var i,n,s=this.extent*Math.pow(2,r),a=this.extent*t,o=this.extent*e,l=this.loadGeometry(),u=gl.types[this.type];function c(t){for(var e=0;e<t.length;e++){var r=t[e];t[e]=[360*(r.x+a)/s-180,360/Math.PI*Math.atan(Math.exp((180-360*(r.y+o)/s)*Math.PI/180))-90];}}switch(this.type){case 1:var h=[];for(i=0;i<l.length;i++)h[i]=l[i][0];c(l=h);break;case 2:for(i=0;i<l.length;i++)c(l[i]);break;case 3:for(l=function(t){var e=t.length;if(e<=1)return [t];for(var r,i,n=[],s=0;s<e;s++){var a=vl(t[s]);0!==a&&(void 0===i&&(i=a<0),i===a<0?(r&&n.push(r),r=[t[s]]):r.push(t[s]));}return r&&n.push(r),n}(l),i=0;i<l.length;i++)for(n=0;n<l[i].length;n++)c(l[i][n]);}1===l.length?l=l[0]:u="Multi"+u;var p={type:"Feature",geometry:{type:u,coordinates:l},properties:this.properties};return "id"in this&&(p.id=this.id),p};var bl=wl;function wl(t,e){this.version=1,this.name=null,this.extent=4096,this.length=0,this._pbf=t,this._keys=[],this._values=[],this._features=[],t.readFields(_l,this,e),this.length=this._features.length;}function _l(t,e,r){15===t?e.version=r.readVarint():1===t?e.name=r.readString():5===t?e.extent=r.readVarint():2===t?e._features.push(r.pos):3===t?e._keys.push(r.readString()):4===t&&e._values.push(function(t){for(var e=null,r=t.readVarint()+t.pos;t.pos<r;){var i=t.readVarint()>>3;e=1===i?t.readString():2===i?t.readFloat():3===i?t.readDouble():4===i?t.readVarint64():5===i?t.readVarint():6===i?t.readSVarint():7===i?t.readBoolean():null;}return e}(r));}function kl(t,e,r){if(3===t){var i=new bl(r,r.readVarint()+r.pos);i.length&&(e[i.name]=i);}}wl.prototype.feature=function(t){if(t<0||t>=this._features.length)throw new Error("feature index out of bounds");this._pbf.pos=this._features[t];var e=this._pbf.readVarint()+this._pbf.pos;return new ml(this._pbf,e,this.extent,this._keys,this._values)};var Al={VectorTile:function(t,e){this.layers=t.readFields(kl,{},e);},VectorTileFeature:ml,VectorTileLayer:bl};const Sl=Al.VectorTileFeature.types,Il=Math.pow(2,13);function Tl(t,e,r,i,n,s,a,o){t.emplaceBack((e<<1)+a,(r<<1)+s,(Math.floor(i*Il)<<1)+n,Math.round(o));}class zl{constructor(){this.acc=new i(0,0),this.polyCount=[];}startRing(t){this.currentPolyCount={edges:0,top:0},this.polyCount.push(this.currentPolyCount),this.min||(this.min=new i(t.x,t.y),this.max=new i(t.x,t.y));}append(t,e){this.currentPolyCount.edges++,this.acc._add(t);let r=!!this.borders;const i=this.min,n=this.max;t.x<i.x?(i.x=t.x,r=!0):t.x>n.x&&(n.x=t.x,r=!0),t.y<i.y?(i.y=t.y,r=!0):t.y>n.y&&(n.y=t.y,r=!0),((0===t.x||8192===t.x)&&t.x===e.x)!=((0===t.y||8192===t.y)&&t.y===e.y)&&this.processBorderOverlap(t,e),r&&this.checkBorderIntersection(t,e);}checkBorderIntersection(t,e){e.x<0!=t.x<0&&this.addBorderIntersection(0,Je(e.y,t.y,(0-e.x)/(t.x-e.x))),e.x>8192!=t.x>8192&&this.addBorderIntersection(1,Je(e.y,t.y,(8192-e.x)/(t.x-e.x))),e.y<0!=t.y<0&&this.addBorderIntersection(2,Je(e.x,t.x,(0-e.y)/(t.y-e.y))),e.y>8192!=t.y>8192&&this.addBorderIntersection(3,Je(e.x,t.x,(8192-e.y)/(t.y-e.y)));}addBorderIntersection(t,e){this.borders||(this.borders=[[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE],[Number.MAX_VALUE,-Number.MAX_VALUE]]);const r=this.borders[t];e<r[0]&&(r[0]=e),e>r[1]&&(r[1]=e);}processBorderOverlap(t,e){if(t.x===e.x){if(t.y===e.y)return;const r=0===t.x?0:1;this.addBorderIntersection(r,e.y),this.addBorderIntersection(r,t.y);}else {const r=0===t.y?2:3;this.addBorderIntersection(r,e.x),this.addBorderIntersection(r,t.x);}}centroid(){const t=this.polyCount.reduce((t,e)=>t+e.edges,0);return 0!==t?this.acc.div(t)._round():new i(0,0)}span(){return new i(this.max.x-this.min.x,this.max.y-this.min.y)}intersectsCount(){return this.borders.reduce((t,e)=>t+ +(e[0]!==Number.MAX_VALUE),0)}}class El{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.layoutVertexArray=new cs,this.centroidVertexArray=new $s,this.indexArray=new ws,this.programConfigurations=new ua(t.layers,t.zoom),this.segments=new ya,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id),this.enableTerrain=t.enableTerrain;}populate(t,e,r){this.features=[],this.hasPattern=ll("fill-extrusion",this.layers,e),this.featuresOnBorder=[],this.borders=[[],[],[],[]],this.borderDone=[!1,!1,!1,!1],this.tileToMeter=function(t){const e=Math.exp(Math.PI*(1-t.y/(1<<t.z)*2));return 80150034*e/(e*e+1)/8192/(1<<t.z)}(r);for(const{feature:i,id:n,index:s,sourceLayerIndex:a}of t){const t=this.layers[0]._featureFilter.needGeometry,o=va(i,t);if(!this.layers[0]._featureFilter.filter(new qn(this.zoom),o,r))continue;const l={id:n,sourceLayerIndex:a,index:s,geometry:t?o.geometry:xa(i),properties:i.properties,type:i.type,patterns:{}},u=this.layoutVertexArray.length;this.hasPattern?this.features.push(ul("fill-extrusion",this.layers,l,this.zoom,e)):this.addFeature(l,l.geometry,s,r,{}),e.featureIndex.insert(i,l.geometry,s,a,this.index,u);}this.sortBorders();}addFeatures(t,e,r){for(const t of this.features){const{geometry:i}=t;this.addFeature(t,i,t.index,e,r);}this.sortBorders();}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,yl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}uploadCentroid(t){0!==this.centroidVertexArray.length&&(this.centroidVertexBuffer?this.needsCentroidUpdate&&this.centroidVertexBuffer.updateData(this.centroidVertexArray):this.centroidVertexBuffer=t.createVertexBuffer(this.centroidVertexArray,fl.members,!0),this.needsCentroidUpdate=!1);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.centroidVertexBuffer&&this.centroidVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}addFeature(t,e,r,i,n){const s=this.enableTerrain&&t.properties&&t.properties.hasOwnProperty("type")&&t.properties.hasOwnProperty("height")&&"Polygon"===Sl[t.type]?new zl:null;for(const r of al(e,500)){let e=0,i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray);if(0===r.length||(a=r[0]).every(t=>t.x<=0)||a.every(t=>t.x>=8192)||a.every(t=>t.y<=0)||a.every(t=>t.y>=8192))continue;for(let t=0;t<r.length;t++){const n=r[t];if(0===n.length)continue;e+=n.length;let a=0;s&&s.startRing(n[0]);for(let t=0;t<n.length;t++){const e=n[t];if(t>=1){const r=n[t-1];if(!Ml(e,r)){s&&s.append(e,r),i.vertexLength+4>ya.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(4,this.layoutVertexArray,this.indexArray));const t=e.sub(r)._perp(),n=t.x/(Math.abs(t.x)+Math.abs(t.y)),o=t.y>0?1:0,l=r.dist(e);a+l>32768&&(a=0),Tl(this.layoutVertexArray,e.x,e.y,n,o,0,0,a),Tl(this.layoutVertexArray,e.x,e.y,n,o,0,1,a),a+=l,Tl(this.layoutVertexArray,r.x,r.y,n,o,0,0,a),Tl(this.layoutVertexArray,r.x,r.y,n,o,0,1,a);const u=i.vertexLength;this.indexArray.emplaceBack(u,u+2,u+1),this.indexArray.emplaceBack(u+1,u+2,u+3),i.vertexLength+=4,i.primitiveLength+=2;}}}}if(i.vertexLength+e>ya.MAX_VERTEX_ARRAY_LENGTH&&(i=this.segments.prepareSegment(e,this.layoutVertexArray,this.indexArray)),"Polygon"!==Sl[t.type])continue;const n=[],o=[],l=i.vertexLength;for(let t=0;t<r.length;t++){const e=r[t];if(0!==e.length){e!==r[0]&&o.push(n.length/2);for(let t=0;t<e.length;t++){const r=e[t];Tl(this.layoutVertexArray,r.x,r.y,0,0,1,1,0),n.push(r.x),n.push(r.y),s&&s.currentPolyCount.top++;}}}const u=Eo(n,o);for(let t=0;t<u.length;t+=3)this.indexArray.emplaceBack(l+u[t],l+u[t+2],l+u[t+1]);i.primitiveLength+=u.length/3,i.vertexLength+=e;}var a;if(s&&s.polyCount.length>0){if(s.borders){s.vertexArrayOffset=this.centroidVertexArray.length;const t=s.borders,e=this.featuresOnBorder.push(s)-1;for(let r=0;r<4;r++)t[r][0]!==Number.MAX_VALUE&&this.borders[r].push(e);}this.encodeCentroid(s.borders?void 0:s.centroid(),s);}this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}sortBorders(){for(let t=0;t<4;t++)this.borders[t].sort((e,r)=>this.featuresOnBorder[e].borders[t][0]-this.featuresOnBorder[r].borders[t][0]);}encodeCentroid(t,e,r=!0){let i,n;if(t)if(0!==t.y){const r=e.span()._mult(this.tileToMeter);i=(Math.max(t.x,1)<<3)+Math.min(7,Math.round(r.x/10)),n=(Math.max(t.y,1)<<3)+Math.min(7,Math.round(r.y/10));}else i=Math.ceil(7.3*t.x),n=0;else i=0,n=+r;let s=r?this.centroidVertexArray.length:e.vertexArrayOffset;for(const t of e.polyCount){r&&this.centroidVertexArray.resize(this.centroidVertexArray.length+4*t.edges+t.top);for(let e=0;e<2*t.edges;e++)this.centroidVertexArray.emplace(s++,0,n),this.centroidVertexArray.emplace(s++,i,n);for(let e=0;e<t.top;e++)this.centroidVertexArray.emplace(s++,i,n);}}}function Ml(t,e){return t.x===e.x&&(t.x<0||t.x>8192)||t.y===e.y&&(t.y<0||t.y>8192)}Gi("FillExtrusionBucket",El,{omit:["layers","features"]}),Gi("PartMetadata",zl);var Bl={paint:new rs({"fill-extrusion-opacity":new Wn(Ft["paint_fill-extrusion"]["fill-extrusion-opacity"]),"fill-extrusion-color":new Jn(Ft["paint_fill-extrusion"]["fill-extrusion-color"]),"fill-extrusion-translate":new Wn(Ft["paint_fill-extrusion"]["fill-extrusion-translate"]),"fill-extrusion-translate-anchor":new Wn(Ft["paint_fill-extrusion"]["fill-extrusion-translate-anchor"]),"fill-extrusion-pattern":new Qn(Ft["paint_fill-extrusion"]["fill-extrusion-pattern"]),"fill-extrusion-height":new Jn(Ft["paint_fill-extrusion"]["fill-extrusion-height"]),"fill-extrusion-base":new Jn(Ft["paint_fill-extrusion"]["fill-extrusion-base"]),"fill-extrusion-vertical-gradient":new Wn(Ft["paint_fill-extrusion"]["fill-extrusion-vertical-gradient"])})};function Dl(t,e){return t.x*e.x+t.y*e.y}function Cl(t,e){if(1===t.length){let r=0;const i=e[r++];let n;for(;!n||i.equals(n);)if(n=e[r++],!n)return 1/0;for(;r<e.length;r++){const s=e[r],a=t[0],o=n.sub(i),l=s.sub(i),u=a.sub(i),c=Dl(o,o),h=Dl(o,l),p=Dl(l,l),d=Dl(u,o),f=Dl(u,l),y=c*p-h*h,m=(p*d-h*f)/y,g=(c*f-h*d)/y,x=i.z*(1-m-g)+n.z*m+s.z*g;if(isFinite(x))return x}return 1/0}{let t=1/0;for(const r of e)t=Math.min(t,r.z);return t}}function Pl(t){const e=new i(t[0],t[1]);return e.z=t[2],e}function Vl(t,e,r,i,n,s,a,o){const l=a*n.getElevationAt(t,e,!0,!0),u=0!==s[0],c=u?0===s[1]?a*(s[0]/7.3):a*function(t,e,r){const i=Math.floor(e[0]/8),n=Math.floor(e[1]/8),s=10*(e[0]-8*i),a=10*(e[1]-8*n),o=t.getElevationAt(i,n,!0,!0),l=t.getMeterToDEM(r),u=Math.floor(.5*(s*l-1)),c=Math.floor(.5*(a*l-1)),h=t.tileCoordToPixel(i,n),p=2*u+1,d=2*c+1,f=function(t,e,r,i,n){return [t.getElevationAtPixel(e,r,!0),t.getElevationAtPixel(e+n,r,!0),t.getElevationAtPixel(e,r+n,!0),t.getElevationAtPixel(e+i,r+n,!0)]}(t,h.x-u,h.y-c,p,d),y=Math.abs(f[0]-f[1]),m=Math.abs(f[2]-f[3]),g=Math.abs(f[0]-f[2])+Math.abs(f[1]-f[3]),x=Math.min(.25,.5*l*(y+m)/p),v=Math.min(.25,.5*l*g/d);return o+Math.max(x*s,v*a)}(n,s,o):l;return {base:l+(0===r)?-1:r,top:u?Math.max(c+i,l+r+2):l+i}}const Fl=os([{name:"a_pos_normal",components:2,type:"Int16"},{name:"a_data",components:4,type:"Uint8"},{name:"a_linesofar",components:1,type:"Float32"}],4),{members:Rl}=Fl,Ll=os([{name:"a_uv_x",components:1,type:"Float32"},{name:"a_split_index",components:1,type:"Float32"}]),{members:Ul}=Ll,Ol=Al.VectorTileFeature.types,$l=Math.cos(Math.PI/180*37.5);class ql{constructor(t){this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.hasPattern=!1,this.patternFeatures=[],this.lineClipsArray=[],this.gradients={},this.layers.forEach(t=>{this.gradients[t.id]={};}),this.layoutVertexArray=new hs,this.layoutVertexArray2=new ps,this.indexArray=new ws,this.programConfigurations=new ua(t.layers,t.zoom),this.segments=new ya,this.maxLineLength=0,this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id);}populate(t,e,r){this.hasPattern=ll("line",this.layers,e);const i=this.layers[0].layout.get("line-sort-key"),n=[];for(const{feature:e,id:s,index:a,sourceLayerIndex:o}of t){const t=this.layers[0]._featureFilter.needGeometry,l=va(e,t);if(!this.layers[0]._featureFilter.filter(new qn(this.zoom),l,r))continue;const u=i?i.evaluate(l,{},r):void 0,c={id:s,properties:e.properties,type:e.type,sourceLayerIndex:o,index:a,geometry:t?l.geometry:xa(e),patterns:{},sortKey:u};n.push(c);}i&&n.sort((t,e)=>t.sortKey-e.sortKey);for(const i of n){const{geometry:n,index:s,sourceLayerIndex:a}=i;if(this.hasPattern){const t=ul("line",this.layers,i,this.zoom,e);this.patternFeatures.push(t);}else this.addFeature(i,n,s,r,{});e.featureIndex.insert(t[s].feature,n,s,a,this.index);}}update(t,e,r){this.stateDependentLayers.length&&this.programConfigurations.updatePaintArrays(t,e,this.stateDependentLayers,r);}addFeatures(t,e,r){for(const t of this.patternFeatures)this.addFeature(t,t.geometry,t.index,e,r);}isEmpty(){return 0===this.layoutVertexArray.length}uploadPending(){return !this.uploaded||this.programConfigurations.needsUpload}upload(t){this.uploaded||(0!==this.layoutVertexArray2.length&&(this.layoutVertexBuffer2=t.createVertexBuffer(this.layoutVertexArray2,Ul)),this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Rl),this.indexBuffer=t.createIndexBuffer(this.indexArray)),this.programConfigurations.upload(t),this.uploaded=!0;}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy());}lineFeatureClips(t){if(t.properties&&t.properties.hasOwnProperty("mapbox_clip_start")&&t.properties.hasOwnProperty("mapbox_clip_end"))return {start:+t.properties.mapbox_clip_start,end:+t.properties.mapbox_clip_end}}addFeature(t,e,r,i,n){const s=this.layers[0].layout,a=s.get("line-join").evaluate(t,{}),o=s.get("line-cap"),l=s.get("line-miter-limit"),u=s.get("line-round-limit");this.lineClips=this.lineFeatureClips(t);for(const r of e)this.addLine(r,t,a,o,l,u);this.programConfigurations.populatePaintArrays(this.layoutVertexArray.length,t,r,n,i);}addLine(t,e,r,i,n,s){if(this.distance=0,this.scaledDistance=0,this.totalDistance=0,this.lineSoFar=0,this.lineClips){this.lineClipsArray.push(this.lineClips);for(let e=0;e<t.length-1;e++)this.totalDistance+=t[e].dist(t[e+1]);this.updateScaledDistance(),this.maxLineLength=Math.max(this.maxLineLength,this.totalDistance);}const a="Polygon"===Ol[e.type];let o=t.length;for(;o>=2&&t[o-1].equals(t[o-2]);)o--;let l=0;for(;l<o-1&&t[l].equals(t[l+1]);)l++;if(o<(a?3:2))return;"bevel"===r&&(n=1.05);const u=this.overscaling<=16?122880/(512*this.overscaling):0,c=this.segments.prepareSegment(10*o,this.layoutVertexArray,this.indexArray);let h,p=void 0,d=void 0,f=void 0,y=void 0;this.e1=this.e2=-1,a&&(h=t[o-2],y=t[l].sub(h)._unit()._perp());for(let e=l;e<o;e++){if(d=e===o-1?a?t[l+1]:void 0:t[e+1],d&&t[e].equals(d))continue;y&&(f=y),h&&(p=h),h=t[e],y=d?d.sub(h)._unit()._perp():f,f=f||y;let m=f.add(y);0===m.x&&0===m.y||m._unit();const g=f.x*y.x+f.y*y.y,x=m.x*y.x+m.y*y.y,v=0!==x?1/x:1/0,b=2*Math.sqrt(2-2*x),w=x<$l&&p&&d,_=f.x*y.y-f.y*y.x>0;if(w&&e>l){const t=h.dist(p);if(t>2*u){const e=h.sub(h.sub(p)._mult(u/t)._round());this.updateDistance(p,e),this.addCurrentVertex(e,f,0,0,c),p=e;}}const k=p&&d;let A=k?r:a?"butt":i;if(k&&"round"===A&&(v<s?A="miter":v<=2&&(A="fakeround")),"miter"===A&&v>n&&(A="bevel"),"bevel"===A&&(v>2&&(A="flipbevel"),v<n&&(A="miter")),p&&this.updateDistance(p,h),"miter"===A)m._mult(v),this.addCurrentVertex(h,m,0,0,c);else if("flipbevel"===A){if(v>100)m=y.mult(-1);else {const t=v*f.add(y).mag()/f.sub(y).mag();m._perp()._mult(t*(_?-1:1));}this.addCurrentVertex(h,m,0,0,c),this.addCurrentVertex(h,m.mult(-1),0,0,c);}else if("bevel"===A||"fakeround"===A){const t=-Math.sqrt(v*v-1),e=_?t:0,r=_?0:t;if(p&&this.addCurrentVertex(h,f,e,r,c),"fakeround"===A){const t=Math.round(180*b/Math.PI/20);for(let e=1;e<t;e++){let r=e/t;if(.5!==r){const t=r-.5;r+=r*t*(r-1)*((1.0904+g*(g*(3.55645-1.43519*g)-3.2452))*t*t+(.848013+g*(.215638*g-1.06021)));}const i=y.sub(f)._mult(r)._add(f)._unit()._mult(_?-1:1);this.addHalfVertex(h,i.x,i.y,!1,_,0,c);}}d&&this.addCurrentVertex(h,y,-e,-r,c);}else if("butt"===A)this.addCurrentVertex(h,m,0,0,c);else if("square"===A){const t=p?1:-1;this.addCurrentVertex(h,m,t,t,c);}else "round"===A&&(p&&(this.addCurrentVertex(h,f,0,0,c),this.addCurrentVertex(h,f,1,1,c,!0)),d&&(this.addCurrentVertex(h,y,-1,-1,c,!0),this.addCurrentVertex(h,y,0,0,c)));if(w&&e<o-1){const t=h.dist(d);if(t>2*u){const e=h.add(d.sub(h)._mult(u/t)._round());this.updateDistance(h,e),this.addCurrentVertex(e,y,0,0,c),h=e;}}}}addCurrentVertex(t,e,r,i,n,s=!1){const a=e.y*i-e.x,o=-e.y-e.x*i;this.addHalfVertex(t,e.x+e.y*r,e.y-e.x*r,s,!1,r,n),this.addHalfVertex(t,a,o,s,!0,-i,n);}addHalfVertex({x:t,y:e},r,i,n,s,a,o){this.layoutVertexArray.emplaceBack((t<<1)+(n?1:0),(e<<1)+(s?1:0),Math.round(63*r)+128,Math.round(63*i)+128,1+(0===a?0:a<0?-1:1),0,this.lineSoFar),this.lineClips&&this.layoutVertexArray2.emplaceBack(this.scaledDistance,this.lineClipsArray.length);const l=o.vertexLength++;this.e1>=0&&this.e2>=0&&(this.indexArray.emplaceBack(this.e1,this.e2,l),o.primitiveLength++),s?this.e2=l:this.e1=l;}updateScaledDistance(){if(this.lineClips){const t=this.totalDistance/(this.lineClips.end-this.lineClips.start);this.scaledDistance=this.distance/this.totalDistance,this.lineSoFar=t*this.lineClips.start+this.distance;}else this.lineSoFar=this.distance;}updateDistance(t,e){this.distance+=t.dist(e),this.updateScaledDistance();}}Gi("LineBucket",ql,{omit:["layers","patternFeatures"]});const Nl=new rs({"line-cap":new Wn(Ft.layout_line["line-cap"]),"line-join":new Jn(Ft.layout_line["line-join"]),"line-miter-limit":new Wn(Ft.layout_line["line-miter-limit"]),"line-round-limit":new Wn(Ft.layout_line["line-round-limit"]),"line-sort-key":new Jn(Ft.layout_line["line-sort-key"])});var jl={paint:new rs({"line-opacity":new Jn(Ft.paint_line["line-opacity"]),"line-color":new Jn(Ft.paint_line["line-color"]),"line-translate":new Wn(Ft.paint_line["line-translate"]),"line-translate-anchor":new Wn(Ft.paint_line["line-translate-anchor"]),"line-width":new Jn(Ft.paint_line["line-width"]),"line-gap-width":new Jn(Ft.paint_line["line-gap-width"]),"line-offset":new Jn(Ft.paint_line["line-offset"]),"line-blur":new Jn(Ft.paint_line["line-blur"]),"line-dasharray":new ts(Ft.paint_line["line-dasharray"]),"line-pattern":new Qn(Ft.paint_line["line-pattern"]),"line-gradient":new es(Ft.paint_line["line-gradient"])}),layout:Nl};const Gl=new class extends Jn{possiblyEvaluate(t,e){return e=new qn(Math.floor(e.zoom),{now:e.now,fadeDuration:e.fadeDuration,zoomHistory:e.zoomHistory,transition:e.transition}),super.possiblyEvaluate(t,e)}evaluate(t,e,r,i){return e=x({},e,{zoom:Math.floor(e.zoom)}),super.evaluate(t,e,r,i)}}(jl.paint.properties["line-width"].specification);function Zl(t,e){return e>0?e+2*t:t}Gl.useIntegerZoom=!0;const Xl=os([{name:"a_pos_offset",components:4,type:"Int16"},{name:"a_data",components:4,type:"Uint16"},{name:"a_pixeloffset",components:4,type:"Int16"}],4),Kl=os([{name:"a_projected_pos",components:3,type:"Float32"}],4),Hl=(os([{name:"a_fade_opacity",components:1,type:"Uint32"}],4),os([{name:"a_placed",components:2,type:"Uint8"},{name:"a_shift",components:2,type:"Float32"}])),Yl=os([{name:"a_size_scale",components:1,type:"Float32"},{name:"a_padding",components:2,type:"Float32"}]),Wl=(os([{type:"Int16",name:"anchorPointX"},{type:"Int16",name:"anchorPointY"},{type:"Float32",name:"x1"},{type:"Float32",name:"y1"},{type:"Float32",name:"x2"},{type:"Float32",name:"y2"},{type:"Int16",name:"padding"},{type:"Uint32",name:"featureIndex"},{type:"Uint16",name:"sourceLayerIndex"},{type:"Uint16",name:"bucketIndex"}]),os([{name:"a_pos",components:2,type:"Int16"},{name:"a_anchor_pos",components:2,type:"Int16"},{name:"a_extrude",components:2,type:"Int16"}],4)),Jl=os([{name:"a_pos_2f",components:2,type:"Float32"},{name:"a_radius",components:1,type:"Float32"},{name:"a_flags",components:2,type:"Int16"}],4);function Ql(t,e){const{expression:r}=e;if("constant"===r.kind)return {kind:"constant",layoutSize:r.evaluate(new qn(t+1))};if("source"===r.kind)return {kind:"source"};{const{zoomStops:e,interpolationType:i}=r;let n=0;for(;n<e.length&&e[n]<=t;)n++;n=Math.max(0,n-1);let s=n;for(;s<e.length&&e[s]<t+1;)s++;s=Math.min(e.length-1,s);const a=e[n],o=e[s];return "composite"===r.kind?{kind:"composite",minZoom:a,maxZoom:o,interpolationType:i}:{kind:"camera",minZoom:a,maxZoom:o,minSize:r.evaluate(new qn(a)),maxSize:r.evaluate(new qn(o)),interpolationType:i}}}function tu(t,{uSize:e,uSizeT:r},{lowerSize:i,upperSize:n}){return "source"===t.kind?i/128:"composite"===t.kind?Je(i/128,n/128,r):e}function eu(t,e){let r=0,i=0;if("constant"===t.kind)i=t.layoutSize;else if("source"!==t.kind){const{interpolationType:n,minZoom:s,maxZoom:a}=t,o=n?f(dr.interpolationFactor(n,e,s,a),0,1):0;"camera"===t.kind?i=Je(t.minSize,t.maxSize,o):r=o;}return {uSizeT:r,uSize:i}}os([{name:"triangle",components:3,type:"Uint16"}]),os([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Uint16",name:"glyphStartIndex"},{type:"Uint16",name:"numGlyphs"},{type:"Uint32",name:"vertexStartIndex"},{type:"Uint32",name:"lineStartIndex"},{type:"Uint32",name:"lineLength"},{type:"Uint16",name:"segment"},{type:"Uint16",name:"lowerSize"},{type:"Uint16",name:"upperSize"},{type:"Float32",name:"lineOffsetX"},{type:"Float32",name:"lineOffsetY"},{type:"Uint8",name:"writingMode"},{type:"Uint8",name:"placedOrientation"},{type:"Uint8",name:"hidden"},{type:"Uint32",name:"crossTileID"},{type:"Int16",name:"associatedIconIndex"}]),os([{type:"Int16",name:"anchorX"},{type:"Int16",name:"anchorY"},{type:"Int16",name:"rightJustifiedTextSymbolIndex"},{type:"Int16",name:"centerJustifiedTextSymbolIndex"},{type:"Int16",name:"leftJustifiedTextSymbolIndex"},{type:"Int16",name:"verticalPlacedTextSymbolIndex"},{type:"Int16",name:"placedIconSymbolIndex"},{type:"Int16",name:"verticalPlacedIconSymbolIndex"},{type:"Uint16",name:"key"},{type:"Uint16",name:"textBoxStartIndex"},{type:"Uint16",name:"textBoxEndIndex"},{type:"Uint16",name:"verticalTextBoxStartIndex"},{type:"Uint16",name:"verticalTextBoxEndIndex"},{type:"Uint16",name:"iconBoxStartIndex"},{type:"Uint16",name:"iconBoxEndIndex"},{type:"Uint16",name:"verticalIconBoxStartIndex"},{type:"Uint16",name:"verticalIconBoxEndIndex"},{type:"Uint16",name:"featureIndex"},{type:"Uint16",name:"numHorizontalGlyphVertices"},{type:"Uint16",name:"numVerticalGlyphVertices"},{type:"Uint16",name:"numIconVertices"},{type:"Uint16",name:"numVerticalIconVertices"},{type:"Uint16",name:"useRuntimeCollisionCircles"},{type:"Uint32",name:"crossTileID"},{type:"Float32",name:"textBoxScale"},{type:"Float32",components:2,name:"textOffset"},{type:"Float32",name:"collisionCircleDiameter"}]),os([{type:"Float32",name:"offsetX"}]),os([{type:"Int16",name:"x"},{type:"Int16",name:"y"},{type:"Int16",name:"tileUnitDistanceFromAnchor"}]);var ru=Object.freeze({__proto__:null,getSizeData:Ql,evaluateSizeForFeature:tu,evaluateSizeForZoom:eu,SIZE_PACK_FACTOR:128});function iu(t,e,r){return t.sections.forEach(t=>{t.text=function(t,e,r){const i=e.layout.get("text-transform").evaluate(r,{});return "uppercase"===i?t=t.toLocaleUpperCase():"lowercase"===i&&(t=t.toLocaleLowerCase()),$n.applyArabicShaping&&(t=$n.applyArabicShaping(t)),t}(t.text,e,r);}),t}const nu={"!":"︕","#":"＃",$:"＄","%":"％","&":"＆","(":"︵",")":"︶","*":"＊","+":"＋",",":"︐","-":"︲",".":"・","/":"／",":":"︓",";":"︔","<":"︿","=":"＝",">":"﹀","?":"︖","@":"＠","[":"﹇","\\":"＼","]":"﹈","^":"＾",_:"︳","`":"｀","{":"︷","|":"―","}":"︸","~":"～","¢":"￠","£":"￡","¥":"￥","¦":"￤","¬":"￢","¯":"￣","–":"︲","—":"︱","‘":"﹃","’":"﹄","“":"﹁","”":"﹂","…":"︙","‧":"・","₩":"￦","、":"︑","。":"︒","〈":"︿","〉":"﹀","《":"︽","》":"︾","「":"﹁","」":"﹂","『":"﹃","』":"﹄","【":"︻","】":"︼","〔":"︹","〕":"︺","〖":"︗","〗":"︘","！":"︕","（":"︵","）":"︶","，":"︐","－":"︲","．":"・","：":"︓","；":"︔","＜":"︿","＞":"﹀","？":"︖","［":"﹇","］":"﹈","＿":"︳","｛":"︷","｜":"―","｝":"︸","｟":"︵","｠":"︶","｡":"︒","｢":"﹁","｣":"﹂"};var su=function(t,e,r,i,n){var s,a,o=8*n-i-1,l=(1<<o)-1,u=l>>1,c=-7,h=r?n-1:0,p=r?-1:1,d=t[e+h];for(h+=p,s=d&(1<<-c)-1,d>>=-c,c+=o;c>0;s=256*s+t[e+h],h+=p,c-=8);for(a=s&(1<<-c)-1,s>>=-c,c+=i;c>0;a=256*a+t[e+h],h+=p,c-=8);if(0===s)s=1-u;else {if(s===l)return a?NaN:1/0*(d?-1:1);a+=Math.pow(2,i),s-=u;}return (d?-1:1)*a*Math.pow(2,s-i)},au=function(t,e,r,i,n,s){var a,o,l,u=8*s-n-1,c=(1<<u)-1,h=c>>1,p=23===n?Math.pow(2,-24)-Math.pow(2,-77):0,d=i?0:s-1,f=i?1:-1,y=e<0||0===e&&1/e<0?1:0;for(e=Math.abs(e),isNaN(e)||e===1/0?(o=isNaN(e)?1:0,a=c):(a=Math.floor(Math.log(e)/Math.LN2),e*(l=Math.pow(2,-a))<1&&(a--,l*=2),(e+=a+h>=1?p/l:p*Math.pow(2,1-h))*l>=2&&(a++,l/=2),a+h>=c?(o=0,a=c):a+h>=1?(o=(e*l-1)*Math.pow(2,n),a+=h):(o=e*Math.pow(2,h-1)*Math.pow(2,n),a=0));n>=8;t[r+d]=255&o,d+=f,o/=256,n-=8);for(a=a<<n|o,u+=n;u>0;t[r+d]=255&a,d+=f,a/=256,u-=8);t[r+d-f]|=128*y;},ou=lu;function lu(t){this.buf=ArrayBuffer.isView&&ArrayBuffer.isView(t)?t:new Uint8Array(t||0),this.pos=0,this.type=0,this.length=this.buf.length;}lu.Varint=0,lu.Fixed64=1,lu.Bytes=2,lu.Fixed32=5;var uu="undefined"==typeof TextDecoder?null:new TextDecoder("utf8");function cu(t){return t.type===lu.Bytes?t.readVarint()+t.pos:t.pos+1}function hu(t,e,r){return r?4294967296*e+(t>>>0):4294967296*(e>>>0)+(t>>>0)}function pu(t,e,r){var i=e<=16383?1:e<=2097151?2:e<=268435455?3:Math.floor(Math.log(e)/(7*Math.LN2));r.realloc(i);for(var n=r.pos-1;n>=t;n--)r.buf[n+i]=r.buf[n];}function du(t,e){for(var r=0;r<t.length;r++)e.writeVarint(t[r]);}function fu(t,e){for(var r=0;r<t.length;r++)e.writeSVarint(t[r]);}function yu(t,e){for(var r=0;r<t.length;r++)e.writeFloat(t[r]);}function mu(t,e){for(var r=0;r<t.length;r++)e.writeDouble(t[r]);}function gu(t,e){for(var r=0;r<t.length;r++)e.writeBoolean(t[r]);}function xu(t,e){for(var r=0;r<t.length;r++)e.writeFixed32(t[r]);}function vu(t,e){for(var r=0;r<t.length;r++)e.writeSFixed32(t[r]);}function bu(t,e){for(var r=0;r<t.length;r++)e.writeFixed64(t[r]);}function wu(t,e){for(var r=0;r<t.length;r++)e.writeSFixed64(t[r]);}function _u(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+16777216*t[e+3]}function ku(t,e,r){t[r]=e,t[r+1]=e>>>8,t[r+2]=e>>>16,t[r+3]=e>>>24;}function Au(t,e){return (t[e]|t[e+1]<<8|t[e+2]<<16)+(t[e+3]<<24)}function Su(t,e,r){1===t&&r.readMessage(Iu,e);}function Iu(t,e,r){if(3===t){const{id:t,bitmap:i,width:n,height:s,left:a,top:o,advance:l}=r.readMessage(Tu,{});e.push({id:t,bitmap:new _o({width:n+6,height:s+6},i),metrics:{width:n,height:s,left:a,top:o,advance:l}});}}function Tu(t,e,r){1===t?e.id=r.readVarint():2===t?e.bitmap=r.readBytes():3===t?e.width=r.readVarint():4===t?e.height=r.readVarint():5===t?e.left=r.readSVarint():6===t?e.top=r.readSVarint():7===t&&(e.advance=r.readVarint());}function zu(t){let e=0,r=0;for(const i of t)e+=i.w*i.h,r=Math.max(r,i.w);t.sort((t,e)=>e.h-t.h);const i=[{x:0,y:0,w:Math.max(Math.ceil(Math.sqrt(e/.95)),r),h:1/0}];let n=0,s=0;for(const e of t)for(let t=i.length-1;t>=0;t--){const r=i[t];if(!(e.w>r.w||e.h>r.h)){if(e.x=r.x,e.y=r.y,s=Math.max(s,e.y+e.h),n=Math.max(n,e.x+e.w),e.w===r.w&&e.h===r.h){const e=i.pop();t<i.length&&(i[t]=e);}else e.h===r.h?(r.x+=e.w,r.w-=e.w):e.w===r.w?(r.y+=e.h,r.h-=e.h):(i.push({x:r.x+e.w,y:r.y,w:r.w-e.w,h:e.h}),r.y+=e.h,r.h-=e.h);break}}return {w:n,h:s,fill:e/(n*s)||0}}lu.prototype={destroy:function(){this.buf=null;},readFields:function(t,e,r){for(r=r||this.length;this.pos<r;){var i=this.readVarint(),n=i>>3,s=this.pos;this.type=7&i,t(n,e,this),this.pos===s&&this.skip(i);}return e},readMessage:function(t,e){return this.readFields(t,e,this.readVarint()+this.pos)},readFixed32:function(){var t=_u(this.buf,this.pos);return this.pos+=4,t},readSFixed32:function(){var t=Au(this.buf,this.pos);return this.pos+=4,t},readFixed64:function(){var t=_u(this.buf,this.pos)+4294967296*_u(this.buf,this.pos+4);return this.pos+=8,t},readSFixed64:function(){var t=_u(this.buf,this.pos)+4294967296*Au(this.buf,this.pos+4);return this.pos+=8,t},readFloat:function(){var t=su(this.buf,this.pos,!0,23,4);return this.pos+=4,t},readDouble:function(){var t=su(this.buf,this.pos,!0,52,8);return this.pos+=8,t},readVarint:function(t){var e,r,i=this.buf;return e=127&(r=i[this.pos++]),r<128?e:(e|=(127&(r=i[this.pos++]))<<7,r<128?e:(e|=(127&(r=i[this.pos++]))<<14,r<128?e:(e|=(127&(r=i[this.pos++]))<<21,r<128?e:function(t,e,r){var i,n,s=r.buf;if(i=(112&(n=s[r.pos++]))>>4,n<128)return hu(t,i,e);if(i|=(127&(n=s[r.pos++]))<<3,n<128)return hu(t,i,e);if(i|=(127&(n=s[r.pos++]))<<10,n<128)return hu(t,i,e);if(i|=(127&(n=s[r.pos++]))<<17,n<128)return hu(t,i,e);if(i|=(127&(n=s[r.pos++]))<<24,n<128)return hu(t,i,e);if(i|=(1&(n=s[r.pos++]))<<31,n<128)return hu(t,i,e);throw new Error("Expected varint not more than 10 bytes")}(e|=(15&(r=i[this.pos]))<<28,t,this))))},readVarint64:function(){return this.readVarint(!0)},readSVarint:function(){var t=this.readVarint();return t%2==1?(t+1)/-2:t/2},readBoolean:function(){return Boolean(this.readVarint())},readString:function(){var t=this.readVarint()+this.pos,e=this.pos;return this.pos=t,t-e>=12&&uu?function(t,e,r){return uu.decode(t.subarray(e,r))}(this.buf,e,t):function(t,e,r){for(var i="",n=e;n<r;){var s,a,o,l=t[n],u=null,c=l>239?4:l>223?3:l>191?2:1;if(n+c>r)break;1===c?l<128&&(u=l):2===c?128==(192&(s=t[n+1]))&&(u=(31&l)<<6|63&s)<=127&&(u=null):3===c?(a=t[n+2],128==(192&(s=t[n+1]))&&128==(192&a)&&((u=(15&l)<<12|(63&s)<<6|63&a)<=2047||u>=55296&&u<=57343)&&(u=null)):4===c&&(a=t[n+2],o=t[n+3],128==(192&(s=t[n+1]))&&128==(192&a)&&128==(192&o)&&((u=(15&l)<<18|(63&s)<<12|(63&a)<<6|63&o)<=65535||u>=1114112)&&(u=null)),null===u?(u=65533,c=1):u>65535&&(u-=65536,i+=String.fromCharCode(u>>>10&1023|55296),u=56320|1023&u),i+=String.fromCharCode(u),n+=c;}return i}(this.buf,e,t)},readBytes:function(){var t=this.readVarint()+this.pos,e=this.buf.subarray(this.pos,t);return this.pos=t,e},readPackedVarint:function(t,e){if(this.type!==lu.Bytes)return t.push(this.readVarint(e));var r=cu(this);for(t=t||[];this.pos<r;)t.push(this.readVarint(e));return t},readPackedSVarint:function(t){if(this.type!==lu.Bytes)return t.push(this.readSVarint());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readSVarint());return t},readPackedBoolean:function(t){if(this.type!==lu.Bytes)return t.push(this.readBoolean());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readBoolean());return t},readPackedFloat:function(t){if(this.type!==lu.Bytes)return t.push(this.readFloat());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readFloat());return t},readPackedDouble:function(t){if(this.type!==lu.Bytes)return t.push(this.readDouble());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readDouble());return t},readPackedFixed32:function(t){if(this.type!==lu.Bytes)return t.push(this.readFixed32());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed32());return t},readPackedSFixed32:function(t){if(this.type!==lu.Bytes)return t.push(this.readSFixed32());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed32());return t},readPackedFixed64:function(t){if(this.type!==lu.Bytes)return t.push(this.readFixed64());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readFixed64());return t},readPackedSFixed64:function(t){if(this.type!==lu.Bytes)return t.push(this.readSFixed64());var e=cu(this);for(t=t||[];this.pos<e;)t.push(this.readSFixed64());return t},skip:function(t){var e=7&t;if(e===lu.Varint)for(;this.buf[this.pos++]>127;);else if(e===lu.Bytes)this.pos=this.readVarint()+this.pos;else if(e===lu.Fixed32)this.pos+=4;else {if(e!==lu.Fixed64)throw new Error("Unimplemented type: "+e);this.pos+=8;}},writeTag:function(t,e){this.writeVarint(t<<3|e);},realloc:function(t){for(var e=this.length||16;e<this.pos+t;)e*=2;if(e!==this.length){var r=new Uint8Array(e);r.set(this.buf),this.buf=r,this.length=e;}},finish:function(){return this.length=this.pos,this.pos=0,this.buf.subarray(0,this.length)},writeFixed32:function(t){this.realloc(4),ku(this.buf,t,this.pos),this.pos+=4;},writeSFixed32:function(t){this.realloc(4),ku(this.buf,t,this.pos),this.pos+=4;},writeFixed64:function(t){this.realloc(8),ku(this.buf,-1&t,this.pos),ku(this.buf,Math.floor(t*(1/4294967296)),this.pos+4),this.pos+=8;},writeSFixed64:function(t){this.realloc(8),ku(this.buf,-1&t,this.pos),ku(this.buf,Math.floor(t*(1/4294967296)),this.pos+4),this.pos+=8;},writeVarint:function(t){(t=+t||0)>268435455||t<0?function(t,e){var r,i;if(t>=0?(r=t%4294967296|0,i=t/4294967296|0):(i=~(-t/4294967296),4294967295^(r=~(-t%4294967296))?r=r+1|0:(r=0,i=i+1|0)),t>=0x10000000000000000||t<-0x10000000000000000)throw new Error("Given varint doesn't fit into 10 bytes");e.realloc(10),function(t,e,r){r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,t>>>=7,r.buf[r.pos++]=127&t|128,r.buf[r.pos]=127&(t>>>=7);}(r,0,e),function(t,e){var r=(7&t)<<4;e.buf[e.pos++]|=r|((t>>>=3)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t|((t>>>=7)?128:0),t&&(e.buf[e.pos++]=127&t)))));}(i,e);}(t,this):(this.realloc(4),this.buf[this.pos++]=127&t|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=127&(t>>>=7)|(t>127?128:0),t<=127||(this.buf[this.pos++]=t>>>7&127))));},writeSVarint:function(t){this.writeVarint(t<0?2*-t-1:2*t);},writeBoolean:function(t){this.writeVarint(Boolean(t));},writeString:function(t){t=String(t),this.realloc(4*t.length),this.pos++;var e=this.pos;this.pos=function(t,e,r){for(var i,n,s=0;s<e.length;s++){if((i=e.charCodeAt(s))>55295&&i<57344){if(!n){i>56319||s+1===e.length?(t[r++]=239,t[r++]=191,t[r++]=189):n=i;continue}if(i<56320){t[r++]=239,t[r++]=191,t[r++]=189,n=i;continue}i=n-55296<<10|i-56320|65536,n=null;}else n&&(t[r++]=239,t[r++]=191,t[r++]=189,n=null);i<128?t[r++]=i:(i<2048?t[r++]=i>>6|192:(i<65536?t[r++]=i>>12|224:(t[r++]=i>>18|240,t[r++]=i>>12&63|128),t[r++]=i>>6&63|128),t[r++]=63&i|128);}return r}(this.buf,t,this.pos);var r=this.pos-e;r>=128&&pu(e,r,this),this.pos=e-1,this.writeVarint(r),this.pos+=r;},writeFloat:function(t){this.realloc(4),au(this.buf,t,this.pos,!0,23,4),this.pos+=4;},writeDouble:function(t){this.realloc(8),au(this.buf,t,this.pos,!0,52,8),this.pos+=8;},writeBytes:function(t){var e=t.length;this.writeVarint(e),this.realloc(e);for(var r=0;r<e;r++)this.buf[this.pos++]=t[r];},writeRawMessage:function(t,e){this.pos++;var r=this.pos;t(e,this);var i=this.pos-r;i>=128&&pu(r,i,this),this.pos=r-1,this.writeVarint(i),this.pos+=i;},writeMessage:function(t,e,r){this.writeTag(t,lu.Bytes),this.writeRawMessage(e,r);},writePackedVarint:function(t,e){e.length&&this.writeMessage(t,du,e);},writePackedSVarint:function(t,e){e.length&&this.writeMessage(t,fu,e);},writePackedBoolean:function(t,e){e.length&&this.writeMessage(t,gu,e);},writePackedFloat:function(t,e){e.length&&this.writeMessage(t,yu,e);},writePackedDouble:function(t,e){e.length&&this.writeMessage(t,mu,e);},writePackedFixed32:function(t,e){e.length&&this.writeMessage(t,xu,e);},writePackedSFixed32:function(t,e){e.length&&this.writeMessage(t,vu,e);},writePackedFixed64:function(t,e){e.length&&this.writeMessage(t,bu,e);},writePackedSFixed64:function(t,e){e.length&&this.writeMessage(t,wu,e);},writeBytesField:function(t,e){this.writeTag(t,lu.Bytes),this.writeBytes(e);},writeFixed32Field:function(t,e){this.writeTag(t,lu.Fixed32),this.writeFixed32(e);},writeSFixed32Field:function(t,e){this.writeTag(t,lu.Fixed32),this.writeSFixed32(e);},writeFixed64Field:function(t,e){this.writeTag(t,lu.Fixed64),this.writeFixed64(e);},writeSFixed64Field:function(t,e){this.writeTag(t,lu.Fixed64),this.writeSFixed64(e);},writeVarintField:function(t,e){this.writeTag(t,lu.Varint),this.writeVarint(e);},writeSVarintField:function(t,e){this.writeTag(t,lu.Varint),this.writeSVarint(e);},writeStringField:function(t,e){this.writeTag(t,lu.Bytes),this.writeString(e);},writeFloatField:function(t,e){this.writeTag(t,lu.Fixed32),this.writeFloat(e);},writeDoubleField:function(t,e){this.writeTag(t,lu.Fixed64),this.writeDouble(e);},writeBooleanField:function(t,e){this.writeVarintField(t,Boolean(e));}};class Eu{constructor(t,{pixelRatio:e,version:r,stretchX:i,stretchY:n,content:s}){this.paddedRect=t,this.pixelRatio=e,this.stretchX=i,this.stretchY=n,this.content=s,this.version=r;}get tl(){return [this.paddedRect.x+1,this.paddedRect.y+1]}get br(){return [this.paddedRect.x+this.paddedRect.w-1,this.paddedRect.y+this.paddedRect.h-1]}get tlbr(){return this.tl.concat(this.br)}get displaySize(){return [(this.paddedRect.w-2)/this.pixelRatio,(this.paddedRect.h-2)/this.pixelRatio]}}class Mu{constructor(t,e){const r={},i={};this.haveRenderCallbacks=[];const n=[];this.addImages(t,r,n),this.addImages(e,i,n);const{w:s,h:a}=zu(n),o=new ko({width:s||1,height:a||1});for(const e in t){const i=t[e],n=r[e].paddedRect;ko.copy(i.data,o,{x:0,y:0},{x:n.x+1,y:n.y+1},i.data);}for(const t in e){const r=e[t],n=i[t].paddedRect,s=n.x+1,a=n.y+1,l=r.data.width,u=r.data.height;ko.copy(r.data,o,{x:0,y:0},{x:s,y:a},r.data),ko.copy(r.data,o,{x:0,y:u-1},{x:s,y:a-1},{width:l,height:1}),ko.copy(r.data,o,{x:0,y:0},{x:s,y:a+u},{width:l,height:1}),ko.copy(r.data,o,{x:l-1,y:0},{x:s-1,y:a},{width:1,height:u}),ko.copy(r.data,o,{x:0,y:0},{x:s+l,y:a},{width:1,height:u});}this.image=o,this.iconPositions=r,this.patternPositions=i;}addImages(t,e,r){for(const i in t){const n=t[i],s={x:0,y:0,w:n.data.width+2,h:n.data.height+2};r.push(s),e[i]=new Eu(s,n),n.hasRenderCallback&&this.haveRenderCallbacks.push(i);}}patchUpdatedImages(t,e){t.dispatchRenderCallbacks(this.haveRenderCallbacks);for(const r in t.updatedImages)this.patchUpdatedImage(this.iconPositions[r],t.getImage(r),e),this.patchUpdatedImage(this.patternPositions[r],t.getImage(r),e);}patchUpdatedImage(t,e,r){if(!t||!e)return;if(t.version===e.version)return;t.version=e.version;const[i,n]=t.tl;r.update(e.data,void 0,{x:i,y:n});}}Gi("ImagePosition",Eu),Gi("ImageAtlas",Mu);const Bu={horizontal:1,vertical:2,horizontalOnly:3};class Du{constructor(){this.scale=1,this.fontStack="",this.imageName=null;}static forText(t,e){const r=new Du;return r.scale=t||1,r.fontStack=e,r}static forImage(t){const e=new Du;return e.imageName=t,e}}class Cu{constructor(){this.text="",this.sectionIndex=[],this.sections=[],this.imageSectionID=null;}static fromFeature(t,e){const r=new Cu;for(let i=0;i<t.sections.length;i++){const n=t.sections[i];n.image?r.addImageSection(n):r.addTextSection(n,e);}return r}length(){return this.text.length}getSection(t){return this.sections[this.sectionIndex[t]]}getSectionIndex(t){return this.sectionIndex[t]}getCharCode(t){return this.text.charCodeAt(t)}verticalizePunctuation(){this.text=function(t){let e="";for(let r=0;r<t.length;r++){const i=t.charCodeAt(r+1)||null,n=t.charCodeAt(r-1)||null;e+=i&&En(i)&&!nu[t[r+1]]||n&&En(n)&&!nu[t[r-1]]||!nu[t[r]]?t[r]:nu[t[r]];}return e}(this.text);}trim(){let t=0;for(let e=0;e<this.text.length&&Vu[this.text.charCodeAt(e)];e++)t++;let e=this.text.length;for(let r=this.text.length-1;r>=0&&r>=t&&Vu[this.text.charCodeAt(r)];r--)e--;this.text=this.text.substring(t,e),this.sectionIndex=this.sectionIndex.slice(t,e);}substring(t,e){const r=new Cu;return r.text=this.text.substring(t,e),r.sectionIndex=this.sectionIndex.slice(t,e),r.sections=this.sections,r}toString(){return this.text}getMaxScale(){return this.sectionIndex.reduce((t,e)=>Math.max(t,this.sections[e].scale),0)}addTextSection(t,e){this.text+=t.text,this.sections.push(Du.forText(t.scale,t.fontStack||e));const r=this.sections.length-1;for(let e=0;e<t.text.length;++e)this.sectionIndex.push(r);}addImageSection(t){const e=t.image?t.image.name:"";if(0===e.length)return void E("Can't add FormattedSection with an empty image.");const r=this.getNextImageSectionCharCode();r?(this.text+=String.fromCharCode(r),this.sections.push(Du.forImage(e)),this.sectionIndex.push(this.sections.length-1)):E("Reached maximum number of images 6401");}getNextImageSectionCharCode(){return this.imageSectionID?this.imageSectionID>=63743?null:++this.imageSectionID:(this.imageSectionID=57344,this.imageSectionID)}}function Pu(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y){const m=Cu.fromFeature(t,n);let g;h===Bu.vertical&&m.verticalizePunctuation();const{processBidirectionalText:x,processStyledBidirectionalText:v}=$n;if(x&&1===m.sections.length){g=[];const t=x(m.toString(),$u(m,u,s,e,i,d,f));for(const e of t){const t=new Cu;t.text=e,t.sections=m.sections;for(let r=0;r<e.length;r++)t.sectionIndex.push(0);g.push(t);}}else if(v){g=[];const t=v(m.text,m.sectionIndex,$u(m,u,s,e,i,d,f));for(const e of t){const t=new Cu;t.text=e[0],t.sectionIndex=e[1],t.sections=m.sections,g.push(t);}}else g=function(t,e){const r=[],i=t.text;let n=0;for(const i of e)r.push(t.substring(n,i)),n=i;return n<i.length&&r.push(t.substring(n,i.length)),r}(m,$u(m,u,s,e,i,d,f));const b=[],w={positionedLines:b,text:m.toString(),top:c[1],bottom:c[1],left:c[0],right:c[0],writingMode:h,iconsInText:!1,verticalizable:!1};return function(t,e,r,i,n,s,a,o,l,u,c,h){let p=0,d=-17,f=0,y=0;const m="right"===o?1:"left"===o?0:.5;let g=0;for(const a of n){a.trim();const n=a.getMaxScale(),o=24*(n-1),v={positionedGlyphs:[],lineOffset:0};t.positionedLines[g]=v;const b=v.positionedGlyphs;let w=0;if(!a.length()){d+=s,++g;continue}for(let s=0;s<a.length();s++){const f=a.getSection(s),y=a.getSectionIndex(s),m=a.getCharCode(s);let g=0,v=null,_=null,k=null,A=24;const S=!(l===Bu.horizontal||!c&&!zn(m)||c&&(Vu[m]||(x=m,Wi(x)||Ji(x)||Qi(x)||vn(x)||kn(x))));if(f.imageName){const e=i[f.imageName];if(!e)continue;k=f.imageName,t.iconsInText=t.iconsInText||!0,_=e.paddedRect;const r=e.displaySize;f.scale=24*f.scale/h,v={width:r[0],height:r[1],left:1,top:-3,advance:S?r[1]:r[0],localGlyph:!1},g=o+(24-r[1]*f.scale),A=v.advance;const s=S?r[0]*f.scale-24*n:r[1]*f.scale-24*n;s>0&&s>w&&(w=s);}else {const t=r[f.fontStack],i=t&&t[m];if(i&&i.rect)_=i.rect,v=i.metrics;else {const t=e[f.fontStack],r=t&&t[m];if(!r)continue;v=r.metrics;}g=24*(n-f.scale);}S?(t.verticalizable=!0,b.push({glyph:m,imageName:k,x:p,y:d+g,vertical:S,scale:f.scale,localGlyph:v.localGlyph,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=A*f.scale+u):(b.push({glyph:m,imageName:k,x:p,y:d+g,vertical:S,scale:f.scale,localGlyph:v.localGlyph,fontStack:f.fontStack,sectionIndex:y,metrics:v,rect:_}),p+=v.advance*f.scale+u);}0!==b.length&&(f=Math.max(p-u,f),Nu(b,0,b.length-1,m,w)),p=0;const _=s*n+w;v.lineOffset=Math.max(w,o),d+=_,y=Math.max(_,y),++g;}var x;const v=d- -17,{horizontalAlign:b,verticalAlign:w}=qu(a);(function(t,e,r,i,n,s,a,o,l){const u=(e-r)*n;let c=0;c=s!==a?-o*i- -17:(-i*l+.5)*a;for(const e of t)for(const t of e.positionedGlyphs)t.x+=u,t.y+=c;})(t.positionedLines,m,b,w,f,y,s,v,n.length),t.top+=-w*v,t.bottom=t.top+v,t.left+=-b*f,t.right=t.left+f;}(w,e,r,i,g,a,o,l,h,u,p,y),!function(t){for(const e of t)if(0!==e.positionedGlyphs.length)return !1;return !0}(b)&&w}const Vu={9:!0,10:!0,11:!0,12:!0,13:!0,32:!0},Fu={10:!0,32:!0,38:!0,40:!0,41:!0,43:!0,45:!0,47:!0,173:!0,183:!0,8203:!0,8208:!0,8211:!0,8231:!0};function Ru(t,e,r,i,n,s){if(e.imageName){const t=i[e.imageName];return t?t.displaySize[0]*e.scale*24/s+n:0}{const i=r[e.fontStack],s=i&&i[t];return s?s.metrics.advance*e.scale+n:0}}function Lu(t,e,r,i){const n=Math.pow(t-e,2);return i?t<e?n/2:2*n:n+Math.abs(r)*r}function Uu(t,e,r){let i=0;return 10===t&&(i-=1e4),r&&(i+=150),40!==t&&65288!==t||(i+=50),41!==e&&65289!==e||(i+=50),i}function Ou(t,e,r,i,n,s){let a=null,o=Lu(e,r,n,s);for(const t of i){const i=Lu(e-t.x,r,n,s)+t.badness;i<=o&&(a=t,o=i);}return {index:t,x:e,priorBreak:a,badness:o}}function $u(t,e,r,i,n,s,a){if("point"!==s)return [];if(!t)return [];const o=[],l=function(t,e,r,i,n,s){let a=0;for(let r=0;r<t.length();r++){const o=t.getSection(r);a+=Ru(t.getCharCode(r),o,i,n,e,s);}return a/Math.max(1,Math.ceil(a/r))}(t,e,r,i,n,a),u=t.text.indexOf("​")>=0;let c=0;for(let r=0;r<t.length();r++){const s=t.getSection(r),p=t.getCharCode(r);if(Vu[p]||(c+=Ru(p,s,i,n,e,a)),r<t.length()-1){const e=!((h=p)<11904||!(ln(h)||on(h)||wn(h)||xn(h)||pn(h)||tn(h)||un(h)||nn(h)||dn(h)||fn(h)||hn(h)||An(h)||sn(h)||rn(h)||en(h)||cn(h)||an(h)||bn(h)||mn(h)||yn(h)));(Fu[p]||e||s.imageName)&&o.push(Ou(r+1,c,l,o,Uu(p,t.getCharCode(r+1),e&&u),!1));}}var h;return function t(e){return e?t(e.priorBreak).concat(e.index):[]}(Ou(t.length(),c,l,o,0,!0))}function qu(t){let e=.5,r=.5;switch(t){case"right":case"top-right":case"bottom-right":e=1;break;case"left":case"top-left":case"bottom-left":e=0;}switch(t){case"bottom":case"bottom-right":case"bottom-left":r=1;break;case"top":case"top-right":case"top-left":r=0;}return {horizontalAlign:e,verticalAlign:r}}function Nu(t,e,r,i,n){if(!i&&!n)return;const s=t[r],a=(t[r].x+s.metrics.advance*s.scale)*i;for(let i=e;i<=r;i++)t[i].x-=a,t[i].y+=n;}function ju(t,e,r){const{horizontalAlign:i,verticalAlign:n}=qu(r),s=e[0]-t.displaySize[0]*i,a=e[1]-t.displaySize[1]*n;return {image:t,top:a,bottom:a+t.displaySize[1],left:s,right:s+t.displaySize[0]}}function Gu(t,e,r,i,n,s){const a=t.image;let o;if(a.content){const t=a.content,e=a.pixelRatio||1;o=[t[0]/e,t[1]/e,a.displaySize[0]-t[2]/e,a.displaySize[1]-t[3]/e];}const l=e.left*s,u=e.right*s;let c,h,p,d;"width"===r||"both"===r?(d=n[0]+l-i[3],h=n[0]+u+i[1]):(d=n[0]+(l+u-a.displaySize[0])/2,h=d+a.displaySize[0]);const f=e.top*s,y=e.bottom*s;return "height"===r||"both"===r?(c=n[1]+f-i[0],p=n[1]+y+i[2]):(c=n[1]+(f+y-a.displaySize[1])/2,p=c+a.displaySize[1]),{image:a,top:c,right:h,bottom:p,left:d,collisionPadding:o}}class Zu extends i{constructor(t,e,r,i){super(t,e),this.angle=r,void 0!==i&&(this.segment=i);}clone(){return new Zu(this.x,this.y,this.angle,this.segment)}}function Xu(t,e,r,i,n){if(void 0===e.segment)return !0;let s=e,a=e.segment+1,o=0;for(;o>-r/2;){if(a--,a<0)return !1;o-=t[a].dist(s),s=t[a];}o+=t[a].dist(t[a+1]),a++;const l=[];let u=0;for(;o<r/2;){const e=t[a],r=t[a+1];if(!r)return !1;let s=t[a-1].angleTo(e)-e.angleTo(r);for(s=Math.abs((s+3*Math.PI)%(2*Math.PI)-Math.PI),l.push({distance:o,angleDelta:s}),u+=s;o-l[0].distance>i;)u-=l.shift().angleDelta;if(u>n)return !1;a++,o+=e.dist(r);}return !0}function Ku(t){let e=0;for(let r=0;r<t.length-1;r++)e+=t[r].dist(t[r+1]);return e}function Hu(t,e,r){return t?.6*e*r:0}function Yu(t,e){return Math.max(t?t.right-t.left:0,e?e.right-e.left:0)}function Wu(t,e,r,i,n,s){const a=Hu(r,n,s),o=Yu(r,i)*s;let l=0;const u=Ku(t)/2;for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1],s=i.dist(n);if(l+s>u){const c=(u-l)/s,h=Je(i.x,n.x,c),p=Je(i.y,n.y,c),d=new Zu(h,p,n.angleTo(i),r);return d._round(),!a||Xu(t,d,o,a,e)?d:void 0}l+=s;}}function Ju(t,e,r,i,n,s,a,o,l){const u=Hu(i,s,a),c=Yu(i,n),h=c*a,p=0===t[0].x||t[0].x===l||0===t[0].y||t[0].y===l;return e-h<e/4&&(e=h+e/4),function t(e,r,i,n,s,a,o,l,u){const c=a/2,h=Ku(e);let p=0,d=r-i,f=[];for(let t=0;t<e.length-1;t++){const r=e[t],o=e[t+1],l=r.dist(o),y=o.angleTo(r);for(;d+i<p+l;){d+=i;const m=(d-p)/l,g=Je(r.x,o.x,m),x=Je(r.y,o.y,m);if(g>=0&&g<u&&x>=0&&x<u&&d-c>=0&&d+c<=h){const r=new Zu(g,x,y,t);r._round(),n&&!Xu(e,r,a,n,s)||f.push(r);}}p+=l;}return l||f.length||o||(f=t(e,p/2,i,n,s,a,o,!0,u)),f}(t,p?e/2*o%e:(c/2+2*s)*a*o%e,e,u,r,h,p,!1,l)}function Qu(t,e,r,n,s){const a=[];for(let o=0;o<t.length;o++){const l=t[o];let u;for(let t=0;t<l.length-1;t++){let o=l[t],c=l[t+1];o.x<e&&c.x<e||(o.x<e?o=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x<e&&(c=new i(e,o.y+(e-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y<r&&c.y<r||(o.y<r?o=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round():c.y<r&&(c=new i(o.x+(r-o.y)/(c.y-o.y)*(c.x-o.x),r)._round()),o.x>=n&&c.x>=n||(o.x>=n?o=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round():c.x>=n&&(c=new i(n,o.y+(n-o.x)/(c.x-o.x)*(c.y-o.y))._round()),o.y>=s&&c.y>=s||(o.y>=s?o=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round():c.y>=s&&(c=new i(o.x+(s-o.y)/(c.y-o.y)*(c.x-o.x),s)._round()),u&&o.equals(u[u.length-1])||(u=[o],a.push(u)),u.push(c)))));}}return a}Gi("Anchor",Zu);var tc=ic,ec=ic,rc=1e20;function ic(t,e,r,i,n,s){this.fontSize=t||24,this.buffer=void 0===e?3:e,this.cutoff=i||.25,this.fontFamily=n||"sans-serif",this.fontWeight=s||"normal",this.radius=r||8;var a=this.size=this.fontSize+2*this.buffer,o=a+2*this.buffer;this.canvas=document.createElement("canvas"),this.canvas.width=this.canvas.height=a,this.ctx=this.canvas.getContext("2d"),this.ctx.font=this.fontWeight+" "+this.fontSize+"px "+this.fontFamily,this.ctx.textBaseline="middle",this.ctx.textAlign="left",this.ctx.fillStyle="black",this.gridOuter=new Float64Array(o*o),this.gridInner=new Float64Array(o*o),this.f=new Float64Array(o),this.z=new Float64Array(o+1),this.v=new Uint16Array(o),this.middle=Math.round(a/2*(navigator.userAgent.indexOf("Gecko/")>=0?1.2:1));}function nc(t,e,r,i,n,s){for(var a=0;a<e;a++)sc(t,a,e,r,i,n,s);for(var o=0;o<r;o++)sc(t,o*e,1,e,i,n,s);}function sc(t,e,r,i,n,s,a){var o,l,u,c;for(s[0]=0,a[0]=-rc,a[1]=rc,o=0;o<i;o++)n[o]=t[e+o*r];for(o=1,l=0,u=0;o<i;o++){do{u=(n[o]-n[c=s[l]]+o*o-c*c)/(o-c)/2;}while(u<=a[l]&&--l>-1);s[++l]=o,a[l]=u,a[l+1]=rc;}for(o=0,l=0;o<i;o++){for(;a[l+1]<o;)l++;t[e+o*r]=n[c=s[l]]+(o-c)*(o-c);}}ic.prototype._draw=function(t,e){var r,i,n,s,a,o,l,u,c=this.ctx.measureText(t),h=c.width,p=2*this.buffer;e&&void 0!==c.actualBoundingBoxLeft?(a=Math.floor(c.actualBoundingBoxAscent)-this.middle,o=Math.max(0,this.middle-Math.ceil(c.actualBoundingBoxAscent)),l=this.buffer,r=(i=Math.min(this.size,Math.ceil(c.actualBoundingBoxRight-c.actualBoundingBoxLeft)))+p,n=(s=Math.min(this.size-o,Math.ceil(c.actualBoundingBoxAscent+c.actualBoundingBoxDescent)))+p):(r=i=this.size,n=s=this.size,a=0,o=l=0),i&&s&&(this.ctx.clearRect(l,o,i,s),this.ctx.fillText(t,this.buffer,this.middle),u=this.ctx.getImageData(l,o,i,s));var d=new Uint8ClampedArray(r*n);return function(t,e,r,i,n,s,a){s.fill(rc,0,e*r),a.fill(0,0,e*r);for(var o=(e-i)/2,l=0;l<n;l++)for(var u=0;u<i;u++){var c=(l+o)*e+u+o,h=t.data[4*(l*i+u)+3]/255;if(1===h)s[c]=0,a[c]=rc;else if(0===h)s[c]=rc,a[c]=0;else {var p=Math.max(0,.5-h),d=Math.max(0,h-.5);s[c]=p*p,a[c]=d*d;}}}(u,r,n,i,s,this.gridOuter,this.gridInner),nc(this.gridOuter,r,n,this.f,this.v,this.z),nc(this.gridInner,r,n,this.f,this.v,this.z),function(t,e,r,i,n,s,a){for(var o=0;o<e*r;o++){var l=Math.sqrt(i[o])-Math.sqrt(n[o]);t[o]=Math.round(255-255*(l/s+a));}}(d,r,n,this.gridOuter,this.gridInner,this.radius,this.cutoff),{data:d,metrics:{width:i,height:s,sdfWidth:r,sdfHeight:n,top:a,left:0,advance:h,fontAscent:c.fontBoundingBoxAscent}}},ic.prototype.draw=function(t){return this._draw(t,!1).data},ic.prototype.drawWithMetrics=function(t){return this._draw(t,!0)},tc.default=ec;const ac={none:0,ideographs:1,all:2};class oc{constructor(t,e,r){this.requestManager=t,this.localGlyphMode=e,this.localFontFamily=r,this.entries={},this.localGlyphs={200:{},400:{},500:{},900:{}};}setURL(t){this.url=t;}getGlyphs(t,e){const r=[];for(const e in t)for(const i of t[e])r.push({stack:e,id:i});m(r,({stack:t,id:e},r)=>{let i=this.entries[t];i||(i=this.entries[t]={glyphs:{},requests:{},ranges:{}});let n=i.glyphs[e];if(void 0!==n)return void r(null,{stack:t,id:e,glyph:n});if(n=this._tinySDF(i,t,e),n)return i.glyphs[e]=n,void r(null,{stack:t,id:e,glyph:n});const s=Math.floor(e/256);if(256*s>65535)return void r(new Error("glyphs > 65535 not supported"));if(i.ranges[s])return void r(null,{stack:t,id:e,glyph:n});let a=i.requests[s];a||(a=i.requests[s]=[],oc.loadGlyphRange(t,s,this.url,this.requestManager,(t,e)=>{if(e){for(const t in e)this._doesCharSupportLocalGlyph(+t)||(i.glyphs[+t]=e[+t]);i.ranges[s]=!0;}for(const r of a)r(t,e);delete i.requests[s];})),a.push((i,n)=>{i?r(i):n&&r(null,{stack:t,id:e,glyph:n[e]||null});});},(t,r)=>{if(t)e(t);else if(r){const t={};for(const{stack:e,id:i,glyph:n}of r)(t[e]||(t[e]={}))[i]=n&&{id:n.id,bitmap:n.bitmap.clone(),metrics:n.metrics};e(null,t);}});}_doesCharSupportLocalGlyph(t){return this.localGlyphMode!==ac.none&&(this.localGlyphMode===ac.all?!!this.localFontFamily:!!this.localFontFamily&&(fn(t)||gn(t)||sn(t)||an(t)))}_tinySDF(t,e,r){const i=this.localFontFamily;if(!i)return;if(!this._doesCharSupportLocalGlyph(r))return;let n=t.tinySDF;if(!n){let r="400";/bold/i.test(e)?r="900":/medium/i.test(e)?r="500":/light/i.test(e)&&(r="200"),n=t.tinySDF=new oc.TinySDF(48,6,16,.25,i,r);}if(this.localGlyphs[n.fontWeight][r])return this.localGlyphs[n.fontWeight][r];const{data:s,metrics:a}=n.drawWithMetrics(String.fromCharCode(r)),{fontAscent:o,sdfWidth:l,sdfHeight:u,width:c,height:h,left:p,top:d,advance:f}=a,y=(o?o/2:17)-9;return this.localGlyphs[n.fontWeight][r]={id:r,bitmap:new _o({width:l,height:u},s),metrics:{width:c/2,height:h/2,left:p/2,top:d/2-y,advance:f/2,localGlyph:!0}}}}function lc(t,e,r,n){const s=[],a=t.image,o=a.pixelRatio,l=a.paddedRect.w-2,u=a.paddedRect.h-2,c=t.right-t.left,h=t.bottom-t.top,p=a.stretchX||[[0,l]],d=a.stretchY||[[0,u]],f=(t,e)=>t+e[1]-e[0],y=p.reduce(f,0),m=d.reduce(f,0),g=l-y,x=u-m;let v=0,b=y,w=0,_=m,k=0,A=g,S=0,I=x;if(a.content&&n){const t=a.content;v=uc(p,0,t[0]),w=uc(d,0,t[1]),b=uc(p,t[0],t[2]),_=uc(d,t[1],t[3]),k=t[0]-v,S=t[1]-w,A=t[2]-t[0]-b,I=t[3]-t[1]-_;}const T=(n,s,l,u)=>{const p=hc(n.stretch-v,b,c,t.left),d=pc(n.fixed-k,A,n.stretch,y),f=hc(s.stretch-w,_,h,t.top),g=pc(s.fixed-S,I,s.stretch,m),x=hc(l.stretch-v,b,c,t.left),T=pc(l.fixed-k,A,l.stretch,y),z=hc(u.stretch-w,_,h,t.top),E=pc(u.fixed-S,I,u.stretch,m),M=new i(p,f),B=new i(x,f),D=new i(x,z),C=new i(p,z),P=new i(d/o,g/o),V=new i(T/o,E/o),F=e*Math.PI/180;if(F){const t=Math.sin(F),e=Math.cos(F),r=[e,-t,t,e];M._matMult(r),B._matMult(r),C._matMult(r),D._matMult(r);}const R=n.stretch+n.fixed,L=s.stretch+s.fixed;return {tl:M,tr:B,bl:C,br:D,tex:{x:a.paddedRect.x+1+R,y:a.paddedRect.y+1+L,w:l.stretch+l.fixed-R,h:u.stretch+u.fixed-L},writingMode:void 0,glyphOffset:[0,0],sectionIndex:0,pixelOffsetTL:P,pixelOffsetBR:V,minFontScaleX:A/o/c,minFontScaleY:I/o/h,isSDF:r}};if(n&&(a.stretchX||a.stretchY)){const t=cc(p,g,y),e=cc(d,x,m);for(let r=0;r<t.length-1;r++){const i=t[r],n=t[r+1];for(let t=0;t<e.length-1;t++)s.push(T(i,e[t],n,e[t+1]));}}else s.push(T({fixed:0,stretch:-1},{fixed:0,stretch:-1},{fixed:0,stretch:l+1},{fixed:0,stretch:u+1}));return s}function uc(t,e,r){let i=0;for(const n of t)i+=Math.max(e,Math.min(r,n[1]))-Math.max(e,Math.min(r,n[0]));return i}function cc(t,e,r){const i=[{fixed:-1,stretch:0}];for(const[e,r]of t){const t=i[i.length-1];i.push({fixed:e-t.stretch,stretch:t.stretch}),i.push({fixed:e-t.stretch,stretch:t.stretch+(r-e)});}return i.push({fixed:e+1,stretch:r}),i}function hc(t,e,r,i){return t/e*r+i}function pc(t,e,r,i){return t-e*r/i}oc.loadGlyphRange=function(t,e,r,i,n){const s=256*e,a=s+255,o=i.transformRequest(i.normalizeGlyphsURL(r).replace("{fontstack}",t).replace("{range}",`${s}-${a}`),vt.Glyphs);kt(o,(t,e)=>{if(t)n(t);else if(e){const t={};for(const r of function(t){return new ou(t).readFields(Su,[])}(e))t[r.id]=r;n(null,t);}});},oc.TinySDF=tc;class dc{constructor(t=[],e=fc){if(this.data=t,this.length=this.data.length,this.compare=e,this.length>0)for(let t=(this.length>>1)-1;t>=0;t--)this._down(t);}push(t){this.data.push(t),this.length++,this._up(this.length-1);}pop(){if(0===this.length)return;const t=this.data[0],e=this.data.pop();return this.length--,this.length>0&&(this.data[0]=e,this._down(0)),t}peek(){return this.data[0]}_up(t){const{data:e,compare:r}=this,i=e[t];for(;t>0;){const n=t-1>>1,s=e[n];if(r(i,s)>=0)break;e[t]=s,t=n;}e[t]=i;}_down(t){const{data:e,compare:r}=this,i=this.length>>1,n=e[t];for(;t<i;){let i=1+(t<<1),s=e[i];const a=i+1;if(a<this.length&&r(e[a],s)<0&&(i=a,s=e[a]),r(s,n)>=0)break;e[t]=s,t=i;}e[t]=n;}}function fc(t,e){return t<e?-1:t>e?1:0}function yc(t,e=1,r=!1){let n=1/0,s=1/0,a=-1/0,o=-1/0;const l=t[0];for(let t=0;t<l.length;t++){const e=l[t];(!t||e.x<n)&&(n=e.x),(!t||e.y<s)&&(s=e.y),(!t||e.x>a)&&(a=e.x),(!t||e.y>o)&&(o=e.y);}const u=Math.min(a-n,o-s);let c=u/2;const h=new dc([],mc);if(0===u)return new i(n,s);for(let e=n;e<a;e+=u)for(let r=s;r<o;r+=u)h.push(new gc(e+c,r+c,c,t));let p=function(t){let e=0,r=0,i=0;const n=t[0];for(let t=0,s=n.length,a=s-1;t<s;a=t++){const s=n[t],o=n[a],l=s.x*o.y-o.x*s.y;r+=(s.x+o.x)*l,i+=(s.y+o.y)*l,e+=3*l;}return new gc(r/e,i/e,0,t)}(t),d=h.length;for(;h.length;){const i=h.pop();(i.d>p.d||!p.d)&&(p=i,r&&console.log("found best %d after %d probes",Math.round(1e4*i.d)/1e4,d)),i.max-p.d<=e||(c=i.h/2,h.push(new gc(i.p.x-c,i.p.y-c,c,t)),h.push(new gc(i.p.x+c,i.p.y-c,c,t)),h.push(new gc(i.p.x-c,i.p.y+c,c,t)),h.push(new gc(i.p.x+c,i.p.y+c,c,t)),d+=4);}return r&&(console.log(`num probes: ${d}`),console.log(`best distance: ${p.d}`)),p.p}function mc(t,e){return e.max-t.max}function gc(t,e,r,n){this.p=new i(t,e),this.h=r,this.d=function(t,e){let r=!1,i=1/0;for(let n=0;n<e.length;n++){const s=e[n];for(let e=0,n=s.length,a=n-1;e<n;a=e++){const n=s[e],o=s[a];n.y>t.y!=o.y>t.y&&t.x<(o.x-n.x)*(t.y-n.y)/(o.y-n.y)+n.x&&(r=!r),i=Math.min(i,Ea(t,n,o));}}return (r?1:-1)*Math.sqrt(i)}(this.p,n),this.max=this.d+this.h*Math.SQRT2;}const xc=Number.POSITIVE_INFINITY;function vc(t,e){return e[1]!==xc?function(t,e,r){let i=0,n=0;switch(e=Math.abs(e),r=Math.abs(r),t){case"top-right":case"top-left":case"top":n=r-7;break;case"bottom-right":case"bottom-left":case"bottom":n=7-r;}switch(t){case"top-right":case"bottom-right":case"right":i=-e;break;case"top-left":case"bottom-left":case"left":i=e;}return [i,n]}(t,e[0],e[1]):function(t,e){let r=0,i=0;e<0&&(e=0);const n=e/Math.sqrt(2);switch(t){case"top-right":case"top-left":i=n-7;break;case"bottom-right":case"bottom-left":i=7-n;break;case"bottom":i=7-e;break;case"top":i=e-7;}switch(t){case"top-right":case"bottom-right":r=-n;break;case"top-left":case"bottom-left":r=n;break;case"left":r=e;break;case"right":r=-e;}return [r,i]}(t,e[0])}function bc(t,e,r,i,n,s,a,o){t.createArrays(),t.tilePixelRatio=8192/(512*t.overscaling),t.compareText={},t.iconsNeedLinear=!1;const l=t.layers[0].layout,u=t.layers[0]._unevaluatedLayout._values,c={};if("composite"===t.textSizeData.kind){const{minZoom:e,maxZoom:r}=t.textSizeData;c.compositeTextSizes=[u["text-size"].possiblyEvaluate(new qn(e),a),u["text-size"].possiblyEvaluate(new qn(r),a)];}if("composite"===t.iconSizeData.kind){const{minZoom:e,maxZoom:r}=t.iconSizeData;c.compositeIconSizes=[u["icon-size"].possiblyEvaluate(new qn(e),a),u["icon-size"].possiblyEvaluate(new qn(r),a)];}c.layoutTextSize=u["text-size"].possiblyEvaluate(new qn(o+1),a),c.layoutIconSize=u["icon-size"].possiblyEvaluate(new qn(o+1),a),c.textMaxSize=u["text-size"].possiblyEvaluate(new qn(18),a);const h=24*l.get("text-line-height"),p="map"===l.get("text-rotation-alignment")&&"point"!==l.get("symbol-placement"),d=l.get("text-keep-upright"),f=l.get("text-size");for(const s of t.features){const o=l.get("text-font").evaluate(s,{},a).join(","),u=f.evaluate(s,{},a),y=c.layoutTextSize.evaluate(s,{},a),m=(c.layoutIconSize.evaluate(s,{},a),{horizontal:{},vertical:void 0}),g=s.text;let x,v=[0,0];if(g){const i=g.toString(),c=24*l.get("text-letter-spacing").evaluate(s,{},a),f=In(i)?c:0,x=l.get("text-anchor").evaluate(s,{},a),b=l.get("text-variable-anchor");if(!b){const t=l.get("text-radial-offset").evaluate(s,{},a);v=t?vc(x,[24*t,xc]):l.get("text-offset").evaluate(s,{},a).map(t=>24*t);}let w=p?"center":l.get("text-justify").evaluate(s,{},a);const _=l.get("symbol-placement"),k="point"===_?24*l.get("text-max-width").evaluate(s,{},a):0,A=()=>{t.allowVerticalPlacement&&Sn(i)&&(m.vertical=Pu(g,e,r,n,o,k,h,x,"left",f,v,Bu.vertical,!0,_,y,u));};if(!p&&b){const t="auto"===w?b.map(t=>wc(t)):[w];let i=!1;for(let s=0;s<t.length;s++){const a=t[s];if(!m.horizontal[a])if(i)m.horizontal[a]=m.horizontal[0];else {const t=Pu(g,e,r,n,o,k,h,"center",a,f,v,Bu.horizontal,!1,_,y,u);t&&(m.horizontal[a]=t,i=1===t.positionedLines.length);}}A();}else {"auto"===w&&(w=wc(x));const t=Pu(g,e,r,n,o,k,h,x,w,f,v,Bu.horizontal,!1,_,y,u);t&&(m.horizontal[w]=t),A(),Sn(i)&&p&&d&&(m.vertical=Pu(g,e,r,n,o,k,h,x,w,f,v,Bu.vertical,!1,_,y,u));}}let b=!1;if(s.icon&&s.icon.name){const e=i[s.icon.name];e&&(x=ju(n[s.icon.name],l.get("icon-offset").evaluate(s,{},a),l.get("icon-anchor").evaluate(s,{},a)),b=e.sdf,void 0===t.sdfIcons?t.sdfIcons=e.sdf:t.sdfIcons!==e.sdf&&E("Style sheet warning: Cannot mix SDF and non-SDF icons in one buffer"),(e.pixelRatio!==t.pixelRatio||0!==l.get("icon-rotate").constantOr(1))&&(t.iconsNeedLinear=!0));}const w=Ac(m.horizontal)||m.vertical;t.iconsInText=!!w&&w.iconsInText,(w||x)&&_c(t,s,m,x,i,c,y,0,v,b,a);}s&&t.generateCollisionDebugBuffers(o,t.collisionBoxArray);}function wc(t){switch(t){case"right":case"top-right":case"bottom-right":return "right";case"left":case"top-left":case"bottom-left":return "left"}return "center"}function _c(t,e,r,i,n,s,a,o,l,u,h){let p=s.textMaxSize.evaluate(e,{},h);void 0===p&&(p=a);const d=t.layers[0].layout,f=d.get("icon-offset").evaluate(e,{},h),y=Ac(r.horizontal),m=a/24,g=t.tilePixelRatio*m,x=t.tilePixelRatio*p/24,v=t.tilePixelRatio*d.get("symbol-spacing"),b=d.get("text-padding")*t.tilePixelRatio,w=d.get("icon-padding")*t.tilePixelRatio,_=c(d.get("text-max-angle")),k="map"===d.get("text-rotation-alignment")&&"point"!==d.get("symbol-placement"),A="map"===d.get("icon-rotation-alignment")&&"point"!==d.get("symbol-placement"),S=d.get("symbol-placement"),I=v/2,T=d.get("icon-text-fit");let z;i&&"none"!==T&&(t.allowVerticalPlacement&&r.vertical&&(z=Gu(i,r.vertical,T,d.get("icon-text-fit-padding"),f,m)),y&&(i=Gu(i,y,T,d.get("icon-text-fit-padding"),f,m)));const M=(o,c)=>{c.x<0||c.x>=8192||c.y<0||c.y>=8192||function(t,e,r,i,n,s,a,o,l,u,c,h,p,d,f,y,m,g,x,v,b,w,_,k,A){const S=t.addToLineVertexArray(e,r);let I,T,z,M,B,D,C,P=0,V=0,F=0,R=0,L=-1,U=-1;const O={};let $=Gs(""),q=0,N=0;if(void 0===o._unevaluatedLayout.getValue("text-radial-offset")?[q,N]=o.layout.get("text-offset").evaluate(b,{},k).map(t=>24*t):(q=24*o.layout.get("text-radial-offset").evaluate(b,{},k),N=xc),t.allowVerticalPlacement&&i.vertical){const t=i.vertical;if(f)D=Ic(t),a&&(C=Ic(a));else {const r=o.layout.get("text-rotate").evaluate(b,{},k)+90;z=Sc(l,e,u,c,h,t,0,d,r),a&&(M=Sc(l,e,u,c,h,a,0,g,r));}}if(n){const r=o.layout.get("icon-rotate").evaluate(b,{},k),i="none"!==o.layout.get("icon-text-fit"),s=lc(n,r,_,i),p=a?lc(a,r,_,i):void 0;T=Sc(l,e,u,c,h,n,0,g,r),P=4*s.length;const d=t.iconSizeData;let f=null;"source"===d.kind?(f=[128*o.layout.get("icon-size").evaluate(b,{},k)],f[0]>32640&&E(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)):"composite"===d.kind&&(f=[128*w.compositeIconSizes[0].evaluate(b,{},k),128*w.compositeIconSizes[1].evaluate(b,{},k)],(f[0]>32640||f[1]>32640)&&E(`${t.layerIds[0]}: Value for "icon-size" is >= 255. Reduce your "icon-size".`)),t.addSymbols(t.icon,s,f,v,x,b,!1,e,S.lineStartIndex,S.lineLength,-1,k),L=t.icon.placedSymbolArray.length-1,p&&(V=4*p.length,t.addSymbols(t.icon,p,f,v,x,b,Bu.vertical,e,S.lineStartIndex,S.lineLength,-1,k),U=t.icon.placedSymbolArray.length-1);}for(const r in i.horizontal){const n=i.horizontal[r];I||($=Gs(n.text),f?B=Ic(n):I=Sc(l,e,u,c,h,n,0,d,o.layout.get("text-rotate").evaluate(b,{},k)));const a=1===n.positionedLines.length;if(F+=kc(t,e,n,s,o,f,b,y,S,i.vertical?Bu.horizontal:Bu.horizontalOnly,a?Object.keys(i.horizontal):[r],O,L,w,k),a)break}i.vertical&&(R+=kc(t,e,i.vertical,s,o,f,b,y,S,Bu.vertical,["vertical"],O,U,w,k));let j=-1;const G=(t,e)=>t?Math.max(t,e):e;j=G(B,j),j=G(D,j),j=G(C,j);const Z=j>-1?1:0;Z&&(j*=A/24),t.glyphOffsetArray.length>=Vc.MAX_GLYPHS&&E("Too many glyphs being rendered in a tile. See https://github.com/mapbox/mapbox-gl-js/issues/2907"),void 0!==b.sortKey&&t.addToSortKeyRanges(t.symbolInstances.length,b.sortKey),t.symbolInstances.emplaceBack(e.x,e.y,O.right>=0?O.right:-1,O.center>=0?O.center:-1,O.left>=0?O.left:-1,O.vertical||-1,L,U,$,void 0!==I?I:t.collisionBoxArray.length,void 0!==I?I+1:t.collisionBoxArray.length,void 0!==z?z:t.collisionBoxArray.length,void 0!==z?z+1:t.collisionBoxArray.length,void 0!==T?T:t.collisionBoxArray.length,void 0!==T?T+1:t.collisionBoxArray.length,M||t.collisionBoxArray.length,M?M+1:t.collisionBoxArray.length,u,F,R,P,V,Z,0,p,q,N,j);}(t,c,o,r,i,n,z,t.layers[0],t.collisionBoxArray,e.index,e.sourceLayerIndex,t.index,g,b,k,l,0,w,A,f,e,s,u,h,a);};if("line"===S)for(const n of Qu(e.geometry,0,0,8192,8192)){const e=Ju(n,v,_,r.vertical||y,i,24,x,t.overscaling,8192);for(const r of e){const e=y;e&&Tc(t,e.text,I,r)||M(n,r);}}else if("line-center"===S){for(const t of e.geometry)if(t.length>1){const e=Wu(t,_,r.vertical||y,i,24,x);e&&M(t,e);}}else if("Polygon"===e.type)for(const t of al(e.geometry,0)){const e=yc(t,16);M(t[0],new Zu(e.x,e.y,0));}else if("LineString"===e.type)for(const t of e.geometry)M(t,new Zu(t[0].x,t[0].y,0));else if("Point"===e.type)for(const t of e.geometry)for(const e of t)M([e],new Zu(e.x,e.y,0));}function kc(t,e,r,n,s,a,o,l,u,c,h,p,d,f,y){const m=function(t,e,r,n,s,a,o,l){const u=n.layout.get("text-rotate").evaluate(a,{})*Math.PI/180,c=[];for(const t of e.positionedLines)for(const n of t.positionedGlyphs){if(!n.rect)continue;const a=n.rect||{};let h=4,p=!0,d=1,f=0;const y=(s||l)&&n.vertical,m=n.metrics.advance*n.scale/2;if(l&&e.verticalizable){const e=24*(n.scale-1),r=(24-n.metrics.width*n.scale)/2;f=t.lineOffset/2-(n.imageName?-r:e);}if(n.imageName){const t=o[n.imageName];p=t.sdf,d=t.pixelRatio,h=1/d;}const g=s?[n.x+m,n.y]:[0,0];let x=s?[0,0]:[n.x+m+r[0],n.y+r[1]-f],v=[0,0];y&&(v=x,x=[0,0]);const b=(n.metrics.left-h)*n.scale-m+x[0],w=(-n.metrics.top-h)*n.scale+x[1],_=b+a.w*n.scale/(d*(n.localGlyph?2:1)),k=w+a.h*n.scale/(d*(n.localGlyph?2:1)),A=new i(b,w),S=new i(_,w),I=new i(b,k),T=new i(_,k);if(y){const t=new i(-m,m- -17),e=-Math.PI/2,r=12-m,s=new i(22-r,-(n.imageName?r:0)),a=new i(...v);A._rotateAround(e,t)._add(s)._add(a),S._rotateAround(e,t)._add(s)._add(a),I._rotateAround(e,t)._add(s)._add(a),T._rotateAround(e,t)._add(s)._add(a);}if(u){const t=Math.sin(u),e=Math.cos(u),r=[e,-t,t,e];A._matMult(r),S._matMult(r),I._matMult(r),T._matMult(r);}const z=new i(0,0),E=new i(0,0);c.push({tl:A,tr:S,bl:I,br:T,tex:a,writingMode:e.writingMode,glyphOffset:g,sectionIndex:n.sectionIndex,isSDF:p,pixelOffsetTL:z,pixelOffsetBR:E,minFontScaleX:0,minFontScaleY:0});}return c}(0,r,l,s,a,o,n,t.allowVerticalPlacement),g=t.textSizeData;let x=null;"source"===g.kind?(x=[128*s.layout.get("text-size").evaluate(o,{},y)],x[0]>32640&&E(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)):"composite"===g.kind&&(x=[128*f.compositeTextSizes[0].evaluate(o,{},y),128*f.compositeTextSizes[1].evaluate(o,{},y)],(x[0]>32640||x[1]>32640)&&E(`${t.layerIds[0]}: Value for "text-size" is >= 255. Reduce your "text-size".`)),t.addSymbols(t.text,m,x,l,a,o,c,e,u.lineStartIndex,u.lineLength,d,y);for(const e of h)p[e]=t.text.placedSymbolArray.length-1;return 4*m.length}function Ac(t){for(const e in t)return t[e];return null}function Sc(t,e,r,n,s,a,o,l,u){let h=a.top,p=a.bottom,d=a.left,f=a.right;const y=a.collisionPadding;if(y&&(d-=y[0],h-=y[1],f+=y[2],p+=y[3]),u){const t=new i(d,h),e=new i(f,h),r=new i(d,p),n=new i(f,p),s=c(u);t._rotate(s),e._rotate(s),r._rotate(s),n._rotate(s),d=Math.min(t.x,e.x,r.x,n.x),f=Math.max(t.x,e.x,r.x,n.x),h=Math.min(t.y,e.y,r.y,n.y),p=Math.max(t.y,e.y,r.y,n.y);}return t.emplaceBack(e.x,e.y,d,h,f,p,l,r,n,s),t.length-1}function Ic(t){t.collisionPadding&&(t.top-=t.collisionPadding[1],t.bottom+=t.collisionPadding[3]);const e=t.bottom-t.top;return e>0?Math.max(10,e):null}function Tc(t,e,r,i){const n=t.compareText;if(e in n){const t=n[e];for(let e=t.length-1;e>=0;e--)if(i.dist(t[e])<r)return !0}else n[e]=[];return n[e].push(i),!1}const zc=Al.VectorTileFeature.types,Ec=[{name:"a_fade_opacity",components:1,type:"Uint8",offset:0}];function Mc(t,e,r,i,n,s,a,o,l,u,c,h,p){const d=o?Math.min(32640,Math.round(o[0])):0,f=o?Math.min(32640,Math.round(o[1])):0;t.emplaceBack(e,r,Math.round(32*i),Math.round(32*n),s,a,(d<<1)+(l?1:0),f,16*u,16*c,256*h,256*p);}function Bc(t,e,r){t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r),t.emplaceBack(e.x,e.y,r);}function Dc(t){for(const e of t.sections)if(Dn(e.text))return !0;return !1}class Cc{constructor(t){this.layoutVertexArray=new fs,this.indexArray=new ws,this.programConfigurations=t,this.segments=new ya,this.dynamicLayoutVertexArray=new ys,this.opacityVertexArray=new ms,this.placedSymbolArray=new Cs;}isEmpty(){return 0===this.layoutVertexArray.length&&0===this.indexArray.length&&0===this.dynamicLayoutVertexArray.length&&0===this.opacityVertexArray.length}upload(t,e,r,i){this.isEmpty()||(r&&(this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,Xl.members),this.indexBuffer=t.createIndexBuffer(this.indexArray,e),this.dynamicLayoutVertexBuffer=t.createVertexBuffer(this.dynamicLayoutVertexArray,Kl.members,!0),this.opacityVertexBuffer=t.createVertexBuffer(this.opacityVertexArray,Ec,!0),this.opacityVertexBuffer.itemSize=1),(r||i)&&this.programConfigurations.upload(t));}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.programConfigurations.destroy(),this.segments.destroy(),this.dynamicLayoutVertexBuffer.destroy(),this.opacityVertexBuffer.destroy());}}Gi("SymbolBuffers",Cc);class Pc{constructor(t,e,r){this.layoutVertexArray=new t,this.layoutAttributes=e,this.indexArray=new r,this.segments=new ya,this.collisionVertexArray=new bs,this.collisionVertexArrayExt=new ys;}upload(t){this.layoutVertexBuffer=t.createVertexBuffer(this.layoutVertexArray,this.layoutAttributes),this.indexBuffer=t.createIndexBuffer(this.indexArray),this.collisionVertexBuffer=t.createVertexBuffer(this.collisionVertexArray,Hl.members,!0),this.collisionVertexBufferExt=t.createVertexBuffer(this.collisionVertexArrayExt,Yl.members,!0);}destroy(){this.layoutVertexBuffer&&(this.layoutVertexBuffer.destroy(),this.indexBuffer.destroy(),this.segments.destroy(),this.collisionVertexBuffer.destroy(),this.collisionVertexBufferExt.destroy());}}Gi("CollisionBuffers",Pc);class Vc{constructor(t){this.collisionBoxArray=t.collisionBoxArray,this.zoom=t.zoom,this.overscaling=t.overscaling,this.layers=t.layers,this.layerIds=this.layers.map(t=>t.id),this.index=t.index,this.pixelRatio=t.pixelRatio,this.sourceLayerIndex=t.sourceLayerIndex,this.hasPattern=!1,this.hasRTLText=!1,this.sortKeyRanges=[],this.collisionCircleArray=[],this.placementInvProjMatrix=qa([]),this.placementViewportMatrix=qa([]);const e=this.layers[0]._unevaluatedLayout._values;this.textSizeData=Ql(this.zoom,e["text-size"]),this.iconSizeData=Ql(this.zoom,e["icon-size"]);const r=this.layers[0].layout,i=r.get("symbol-sort-key"),n=r.get("symbol-z-order");this.canOverlap=r.get("text-allow-overlap")||r.get("icon-allow-overlap")||r.get("text-ignore-placement")||r.get("icon-ignore-placement"),this.sortFeaturesByKey="viewport-y"!==n&&void 0!==i.constantOr(1),this.sortFeaturesByY=("viewport-y"===n||"auto"===n&&!this.sortFeaturesByKey)&&this.canOverlap,"point"===r.get("symbol-placement")&&(this.writingModes=r.get("text-writing-mode").map(t=>Bu[t])),this.stateDependentLayerIds=this.layers.filter(t=>t.isStateDependent()).map(t=>t.id),this.sourceID=t.sourceID;}createArrays(){this.text=new Cc(new ua(this.layers,this.zoom,t=>/^text/.test(t))),this.icon=new Cc(new ua(this.layers,this.zoom,t=>/^icon/.test(t))),this.glyphOffsetArray=new Fs,this.lineVertexArray=new Rs,this.symbolInstances=new Vs;}calculateGlyphDependencies(t,e,r,i,n){for(let s=0;s<t.length;s++)if(e[t.charCodeAt(s)]=!0,(r||i)&&n){const r=nu[t.charAt(s)];r&&(e[r.charCodeAt(0)]=!0);}}populate(t,e,r){const i=this.layers[0],n=i.layout,s=n.get("text-font"),a=n.get("text-field"),o=n.get("icon-image"),l=("constant"!==a.value.kind||a.value.value instanceof he&&!a.value.value.isEmpty()||a.value.value.toString().length>0)&&("constant"!==s.value.kind||s.value.value.length>0),u="constant"!==o.value.kind||!!o.value.value||Object.keys(o.parameters).length>0,c=n.get("symbol-sort-key");if(this.features=[],!l&&!u)return;const h=e.iconDependencies,p=e.glyphDependencies,d=e.availableImages,f=new qn(this.zoom);for(const{feature:e,id:a,index:o,sourceLayerIndex:y}of t){const t=i._featureFilter.needGeometry,m=va(e,t);if(!i._featureFilter.filter(f,m,r))continue;let g,x;if(t||(m.geometry=xa(e)),l){const t=i.getValueAndResolveTokens("text-field",m,r,d),e=he.factory(t);Dc(e)&&(this.hasRTLText=!0),(!this.hasRTLText||"unavailable"===Un()||this.hasRTLText&&$n.isParsed())&&(g=iu(e,i,m));}if(u){const t=i.getValueAndResolveTokens("icon-image",m,r,d);x=t instanceof pe?t:pe.fromString(t);}if(!g&&!x)continue;const v=this.sortFeaturesByKey?c.evaluate(m,{},r):void 0;if(this.features.push({id:a,text:g,icon:x,index:o,sourceLayerIndex:y,geometry:m.geometry,properties:e.properties,type:zc[e.type],sortKey:v}),x&&(h[x.name]=!0),g){const t=s.evaluate(m,{},r).join(","),e="map"===n.get("text-rotation-alignment")&&"point"!==n.get("symbol-placement");this.allowVerticalPlacement=this.writingModes&&this.writingModes.indexOf(Bu.vertical)>=0;for(const r of g.sections)if(r.image)h[r.image.name]=!0;else {const i=Sn(g.toString()),n=r.fontStack||t,s=p[n]=p[n]||{};this.calculateGlyphDependencies(r.text,s,e,this.allowVerticalPlacement,i);}}}"line"===n.get("symbol-placement")&&(this.features=function(t){const e={},r={},i=[];let n=0;function s(e){i.push(t[e]),n++;}function a(t,e,n){const s=r[t];return delete r[t],r[e]=s,i[s].geometry[0].pop(),i[s].geometry[0]=i[s].geometry[0].concat(n[0]),s}function o(t,r,n){const s=e[r];return delete e[r],e[t]=s,i[s].geometry[0].shift(),i[s].geometry[0]=n[0].concat(i[s].geometry[0]),s}function l(t,e,r){const i=r?e[0][e[0].length-1]:e[0][0];return `${t}:${i.x}:${i.y}`}for(let u=0;u<t.length;u++){const c=t[u],h=c.geometry,p=c.text?c.text.toString():null;if(!p){s(u);continue}const d=l(p,h),f=l(p,h,!0);if(d in r&&f in e&&r[d]!==e[f]){const t=o(d,f,h),n=a(d,f,i[t].geometry);delete e[d],delete r[f],r[l(p,i[n].geometry,!0)]=n,i[t].geometry=null;}else d in r?a(d,f,h):f in e?o(d,f,h):(s(u),e[d]=n-1,r[f]=n-1);}return i.filter(t=>t.geometry)}(this.features)),this.sortFeaturesByKey&&this.features.sort((t,e)=>t.sortKey-e.sortKey);}update(t,e,r){this.stateDependentLayers.length&&(this.text.programConfigurations.updatePaintArrays(t,e,this.layers,r),this.icon.programConfigurations.updatePaintArrays(t,e,this.layers,r));}isEmpty(){return 0===this.symbolInstances.length&&!this.hasRTLText}uploadPending(){return !this.uploaded||this.text.programConfigurations.needsUpload||this.icon.programConfigurations.needsUpload}upload(t){!this.uploaded&&this.hasDebugData()&&(this.textCollisionBox.upload(t),this.iconCollisionBox.upload(t)),this.text.upload(t,this.sortFeaturesByY,!this.uploaded,this.text.programConfigurations.needsUpload),this.icon.upload(t,this.sortFeaturesByY,!this.uploaded,this.icon.programConfigurations.needsUpload),this.uploaded=!0;}destroyDebugData(){this.textCollisionBox.destroy(),this.iconCollisionBox.destroy();}destroy(){this.text.destroy(),this.icon.destroy(),this.hasDebugData()&&this.destroyDebugData();}addToLineVertexArray(t,e){const r=this.lineVertexArray.length;if(void 0!==t.segment){let r=t.dist(e[t.segment+1]),i=t.dist(e[t.segment]);const n={};for(let i=t.segment+1;i<e.length;i++)n[i]={x:e[i].x,y:e[i].y,tileUnitDistanceFromAnchor:r},i<e.length-1&&(r+=e[i+1].dist(e[i]));for(let r=t.segment||0;r>=0;r--)n[r]={x:e[r].x,y:e[r].y,tileUnitDistanceFromAnchor:i},r>0&&(i+=e[r-1].dist(e[r]));for(let t=0;t<e.length;t++){const e=n[t];this.lineVertexArray.emplaceBack(e.x,e.y,e.tileUnitDistanceFromAnchor);}}return {lineStartIndex:r,lineLength:this.lineVertexArray.length-r}}addSymbols(t,e,r,i,n,s,a,o,l,u,c,h){const p=t.indexArray,d=t.layoutVertexArray,f=t.segments.prepareSegment(4*e.length,d,p,this.canOverlap?s.sortKey:void 0),y=this.glyphOffsetArray.length,m=f.vertexLength,g=this.allowVerticalPlacement&&a===Bu.vertical?Math.PI/2:0,x=s.text&&s.text.sections;for(let i=0;i<e.length;i++){const{tl:n,tr:a,bl:l,br:u,tex:c,pixelOffsetTL:y,pixelOffsetBR:m,minFontScaleX:v,minFontScaleY:b,glyphOffset:w,isSDF:_,sectionIndex:k}=e[i],A=f.vertexLength,S=w[1];Mc(d,o.x,o.y,n.x,S+n.y,c.x,c.y,r,_,y.x,y.y,v,b),Mc(d,o.x,o.y,a.x,S+a.y,c.x+c.w,c.y,r,_,m.x,y.y,v,b),Mc(d,o.x,o.y,l.x,S+l.y,c.x,c.y+c.h,r,_,y.x,m.y,v,b),Mc(d,o.x,o.y,u.x,S+u.y,c.x+c.w,c.y+c.h,r,_,m.x,m.y,v,b),Bc(t.dynamicLayoutVertexArray,o,g),p.emplaceBack(A,A+1,A+2),p.emplaceBack(A+1,A+2,A+3),f.vertexLength+=4,f.primitiveLength+=2,this.glyphOffsetArray.emplaceBack(w[0]),i!==e.length-1&&k===e[i+1].sectionIndex||t.programConfigurations.populatePaintArrays(d.length,s,s.index,{},h,x&&x[k]);}t.placedSymbolArray.emplaceBack(o.x,o.y,y,this.glyphOffsetArray.length-y,m,l,u,o.segment,r?r[0]:0,r?r[1]:0,i[0],i[1],a,0,!1,0,c);}_commitLayoutVertex(t,e,r,i,n){t.emplaceBack(e.x,e.y,r,i,Math.round(n.x),Math.round(n.y));}_addCollisionDebugVertices(t,e,r,n,s){const a=r.segments.prepareSegment(4,r.layoutVertexArray,r.indexArray),o=a.vertexLength,l=s.anchorX,u=s.anchorY;for(let t=0;t<4;t++)r.collisionVertexArray.emplaceBack(0,0,0,0);r.collisionVertexArrayExt.emplaceBack(e,-t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,-t.padding),r.collisionVertexArrayExt.emplaceBack(e,t.padding,t.padding),r.collisionVertexArrayExt.emplaceBack(e,-t.padding,t.padding),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y1)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x2,t.y2)),this._commitLayoutVertex(r.layoutVertexArray,n,l,u,new i(t.x1,t.y2)),a.vertexLength+=4;const c=r.indexArray;c.emplaceBack(o,o+1),c.emplaceBack(o+1,o+2),c.emplaceBack(o+2,o+3),c.emplaceBack(o+3,o),a.primitiveLength+=4;}_addTextDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceTextSize(t,s,e,a);this._addCollisionDebugVertices(i,n,this.textCollisionBox,i.anchorPoint,s);}}_addIconDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceIconSize(t,e,a);this._addCollisionDebugVertices(i,n,this.iconCollisionBox,i.anchorPoint,s);}}generateCollisionDebugBuffers(t,e){this.hasDebugData()&&this.destroyDebugData(),this.textCollisionBox=new Pc(xs,Wl.members,Ts),this.iconCollisionBox=new Pc(xs,Wl.members,Ts);const r=eu(this.iconSizeData,t),i=eu(this.textSizeData,t);for(let n=0;n<this.symbolInstances.length;n++){const s=this.symbolInstances.get(n);this._addTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._addTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex,s),this._addIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex,s);}}getSymbolInstanceTextSize(t,e,r,i){const n=this.text.placedSymbolArray.get(e.rightJustifiedTextSymbolIndex>=0?e.rightJustifiedTextSymbolIndex:e.centerJustifiedTextSymbolIndex>=0?e.centerJustifiedTextSymbolIndex:e.leftJustifiedTextSymbolIndex>=0?e.leftJustifiedTextSymbolIndex:e.verticalPlacedTextSymbolIndex>=0?e.verticalPlacedTextSymbolIndex:i),s=tu(this.textSizeData,t,n)/24;return this.tilePixelRatio*s}getSymbolInstanceIconSize(t,e,r){const i=this.icon.placedSymbolArray.get(r),n=tu(this.iconSizeData,t,i);return this.tilePixelRatio*n}_commitDebugCollisionVertexUpdate(t,e,r){t.emplaceBack(e,-r,-r),t.emplaceBack(e,r,-r),t.emplaceBack(e,r,r),t.emplaceBack(e,-r,r);}_updateTextDebugCollisionBoxes(t,e,r,i,n,s){for(let a=i;a<n;a++){const i=r.get(a),n=this.getSymbolInstanceTextSize(t,s,e,a);this._commitDebugCollisionVertexUpdate(this.textCollisionBox.collisionVertexArrayExt,n,i.padding);}}_updateIconDebugCollisionBoxes(t,e,r,i,n){for(let s=i;s<n;s++){const i=r.get(s),n=this.getSymbolInstanceIconSize(t,e,s);this._commitDebugCollisionVertexUpdate(this.iconCollisionBox.collisionVertexArrayExt,n,i.padding);}}updateCollisionDebugBuffers(t,e){if(!this.hasDebugData())return;this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexArrayExt.clear(),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexArrayExt.clear();const r=eu(this.iconSizeData,t),i=eu(this.textSizeData,t);for(let n=0;n<this.symbolInstances.length;n++){const s=this.symbolInstances.get(n);this._updateTextDebugCollisionBoxes(i,t,e,s.textBoxStartIndex,s.textBoxEndIndex,s),this._updateTextDebugCollisionBoxes(i,t,e,s.verticalTextBoxStartIndex,s.verticalTextBoxEndIndex,s),this._updateIconDebugCollisionBoxes(r,t,e,s.iconBoxStartIndex,s.iconBoxEndIndex),this._updateIconDebugCollisionBoxes(r,t,e,s.verticalIconBoxStartIndex,s.verticalIconBoxEndIndex);}this.hasTextCollisionBoxData()&&this.textCollisionBox.collisionVertexBufferExt&&this.textCollisionBox.collisionVertexBufferExt.updateData(this.textCollisionBox.collisionVertexArrayExt),this.hasIconCollisionBoxData()&&this.iconCollisionBox.collisionVertexBufferExt&&this.iconCollisionBox.collisionVertexBufferExt.updateData(this.iconCollisionBox.collisionVertexArrayExt);}_deserializeCollisionBoxesForSymbol(t,e,r,i,n,s,a,o,l){const u={};for(let i=e;i<r;i++){const e=t.get(i);u.textBox={x1:e.x1,y1:e.y1,x2:e.x2,y2:e.y2,padding:e.padding,anchorPointX:e.anchorPointX,anchorPointY:e.anchorPointY},u.textFeatureIndex=e.featureIndex;break}for(let e=i;e<n;e++){const r=t.get(e);u.verticalTextBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalTextFeatureIndex=r.featureIndex;break}for(let e=s;e<a;e++){const r=t.get(e);u.iconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.iconFeatureIndex=r.featureIndex;break}for(let e=o;e<l;e++){const r=t.get(e);u.verticalIconBox={x1:r.x1,y1:r.y1,x2:r.x2,y2:r.y2,padding:r.padding,anchorPointX:r.anchorPointX,anchorPointY:r.anchorPointY},u.verticalIconFeatureIndex=r.featureIndex;break}return u}deserializeCollisionBoxes(t){this.collisionArrays=[];for(let e=0;e<this.symbolInstances.length;e++){const r=this.symbolInstances.get(e);this.collisionArrays.push(this._deserializeCollisionBoxesForSymbol(t,r.textBoxStartIndex,r.textBoxEndIndex,r.verticalTextBoxStartIndex,r.verticalTextBoxEndIndex,r.iconBoxStartIndex,r.iconBoxEndIndex,r.verticalIconBoxStartIndex,r.verticalIconBoxEndIndex));}}hasTextData(){return this.text.segments.get().length>0}hasIconData(){return this.icon.segments.get().length>0}hasDebugData(){return this.textCollisionBox&&this.iconCollisionBox}hasTextCollisionBoxData(){return this.hasDebugData()&&this.textCollisionBox.segments.get().length>0}hasIconCollisionBoxData(){return this.hasDebugData()&&this.iconCollisionBox.segments.get().length>0}addIndicesForPlacedSymbol(t,e){const r=t.placedSymbolArray.get(e),i=r.vertexStartIndex+4*r.numGlyphs;for(let e=r.vertexStartIndex;e<i;e+=4)t.indexArray.emplaceBack(e,e+1,e+2),t.indexArray.emplaceBack(e+1,e+2,e+3);}getSortedSymbolIndexes(t){if(this.sortedAngle===t&&void 0!==this.symbolInstanceIndexes)return this.symbolInstanceIndexes;const e=Math.sin(t),r=Math.cos(t),i=[],n=[],s=[];for(let t=0;t<this.symbolInstances.length;++t){s.push(t);const a=this.symbolInstances.get(t);i.push(0|Math.round(e*a.anchorX+r*a.anchorY)),n.push(a.featureIndex);}return s.sort((t,e)=>i[t]-i[e]||n[e]-n[t]),s}addToSortKeyRanges(t,e){const r=this.sortKeyRanges[this.sortKeyRanges.length-1];r&&r.sortKey===e?r.symbolInstanceEnd=t+1:this.sortKeyRanges.push({sortKey:e,symbolInstanceStart:t,symbolInstanceEnd:t+1});}sortFeatures(t){if(this.sortFeaturesByY&&this.sortedAngle!==t&&!(this.text.segments.get().length>1||this.icon.segments.get().length>1)){this.symbolInstanceIndexes=this.getSortedSymbolIndexes(t),this.sortedAngle=t,this.text.indexArray.clear(),this.icon.indexArray.clear(),this.featureSortOrder=[];for(const t of this.symbolInstanceIndexes){const e=this.symbolInstances.get(t);this.featureSortOrder.push(e.featureIndex),[e.rightJustifiedTextSymbolIndex,e.centerJustifiedTextSymbolIndex,e.leftJustifiedTextSymbolIndex].forEach((t,e,r)=>{t>=0&&r.indexOf(t)===e&&this.addIndicesForPlacedSymbol(this.text,t);}),e.verticalPlacedTextSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.text,e.verticalPlacedTextSymbolIndex),e.placedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.placedIconSymbolIndex),e.verticalPlacedIconSymbolIndex>=0&&this.addIndicesForPlacedSymbol(this.icon,e.verticalPlacedIconSymbolIndex);}this.text.indexBuffer&&this.text.indexBuffer.updateData(this.text.indexArray),this.icon.indexBuffer&&this.icon.indexBuffer.updateData(this.icon.indexArray);}}}Gi("SymbolBucket",Vc,{omit:["layers","collisionBoxArray","features","compareText"]}),Vc.MAX_GLYPHS=65535,Vc.addDynamicAttributes=Bc;const Fc=new rs({"symbol-placement":new Wn(Ft.layout_symbol["symbol-placement"]),"symbol-spacing":new Wn(Ft.layout_symbol["symbol-spacing"]),"symbol-avoid-edges":new Wn(Ft.layout_symbol["symbol-avoid-edges"]),"symbol-sort-key":new Jn(Ft.layout_symbol["symbol-sort-key"]),"symbol-z-order":new Wn(Ft.layout_symbol["symbol-z-order"]),"icon-allow-overlap":new Wn(Ft.layout_symbol["icon-allow-overlap"]),"icon-ignore-placement":new Wn(Ft.layout_symbol["icon-ignore-placement"]),"icon-optional":new Wn(Ft.layout_symbol["icon-optional"]),"icon-rotation-alignment":new Wn(Ft.layout_symbol["icon-rotation-alignment"]),"icon-size":new Jn(Ft.layout_symbol["icon-size"]),"icon-text-fit":new Wn(Ft.layout_symbol["icon-text-fit"]),"icon-text-fit-padding":new Wn(Ft.layout_symbol["icon-text-fit-padding"]),"icon-image":new Jn(Ft.layout_symbol["icon-image"]),"icon-rotate":new Jn(Ft.layout_symbol["icon-rotate"]),"icon-padding":new Wn(Ft.layout_symbol["icon-padding"]),"icon-keep-upright":new Wn(Ft.layout_symbol["icon-keep-upright"]),"icon-offset":new Jn(Ft.layout_symbol["icon-offset"]),"icon-anchor":new Jn(Ft.layout_symbol["icon-anchor"]),"icon-pitch-alignment":new Wn(Ft.layout_symbol["icon-pitch-alignment"]),"text-pitch-alignment":new Wn(Ft.layout_symbol["text-pitch-alignment"]),"text-rotation-alignment":new Wn(Ft.layout_symbol["text-rotation-alignment"]),"text-field":new Jn(Ft.layout_symbol["text-field"]),"text-font":new Jn(Ft.layout_symbol["text-font"]),"text-size":new Jn(Ft.layout_symbol["text-size"]),"text-max-width":new Jn(Ft.layout_symbol["text-max-width"]),"text-line-height":new Wn(Ft.layout_symbol["text-line-height"]),"text-letter-spacing":new Jn(Ft.layout_symbol["text-letter-spacing"]),"text-justify":new Jn(Ft.layout_symbol["text-justify"]),"text-radial-offset":new Jn(Ft.layout_symbol["text-radial-offset"]),"text-variable-anchor":new Wn(Ft.layout_symbol["text-variable-anchor"]),"text-anchor":new Jn(Ft.layout_symbol["text-anchor"]),"text-max-angle":new Wn(Ft.layout_symbol["text-max-angle"]),"text-writing-mode":new Wn(Ft.layout_symbol["text-writing-mode"]),"text-rotate":new Jn(Ft.layout_symbol["text-rotate"]),"text-padding":new Wn(Ft.layout_symbol["text-padding"]),"text-keep-upright":new Wn(Ft.layout_symbol["text-keep-upright"]),"text-transform":new Jn(Ft.layout_symbol["text-transform"]),"text-offset":new Jn(Ft.layout_symbol["text-offset"]),"text-allow-overlap":new Wn(Ft.layout_symbol["text-allow-overlap"]),"text-ignore-placement":new Wn(Ft.layout_symbol["text-ignore-placement"]),"text-optional":new Wn(Ft.layout_symbol["text-optional"])});var Rc={paint:new rs({"icon-opacity":new Jn(Ft.paint_symbol["icon-opacity"]),"icon-color":new Jn(Ft.paint_symbol["icon-color"]),"icon-halo-color":new Jn(Ft.paint_symbol["icon-halo-color"]),"icon-halo-width":new Jn(Ft.paint_symbol["icon-halo-width"]),"icon-halo-blur":new Jn(Ft.paint_symbol["icon-halo-blur"]),"icon-translate":new Wn(Ft.paint_symbol["icon-translate"]),"icon-translate-anchor":new Wn(Ft.paint_symbol["icon-translate-anchor"]),"text-opacity":new Jn(Ft.paint_symbol["text-opacity"]),"text-color":new Jn(Ft.paint_symbol["text-color"],{runtimeType:Kt,getOverride:t=>t.textColor,hasOverride:t=>!!t.textColor}),"text-halo-color":new Jn(Ft.paint_symbol["text-halo-color"]),"text-halo-width":new Jn(Ft.paint_symbol["text-halo-width"]),"text-halo-blur":new Jn(Ft.paint_symbol["text-halo-blur"]),"text-translate":new Wn(Ft.paint_symbol["text-translate"]),"text-translate-anchor":new Wn(Ft.paint_symbol["text-translate-anchor"])}),layout:Fc};class Lc{constructor(t){this.type=t.property.overrides?t.property.overrides.runtimeType:jt,this.defaultValue=t;}evaluate(t){if(t.formattedSection){const e=this.defaultValue.property.overrides;if(e&&e.hasOverride(t.formattedSection))return e.getOverride(t.formattedSection)}return t.feature&&t.featureState?this.defaultValue.evaluate(t.feature,t.featureState):this.defaultValue.property.specification.default}eachChild(t){this.defaultValue.isConstant()||t(this.defaultValue.value._styleExpression.expression);}outputDefined(){return !1}serialize(){return null}}Gi("FormatSectionOverride",Lc,{omit:["defaultValue"]});class Uc extends pa{constructor(t){super(t,Rc);}recalculate(t,e){if(super.recalculate(t,e),"auto"===this.layout.get("icon-rotation-alignment")&&(this.layout._values["icon-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-rotation-alignment")&&(this.layout._values["text-rotation-alignment"]="point"!==this.layout.get("symbol-placement")?"map":"viewport"),"auto"===this.layout.get("text-pitch-alignment")&&(this.layout._values["text-pitch-alignment"]=this.layout.get("text-rotation-alignment")),"auto"===this.layout.get("icon-pitch-alignment")&&(this.layout._values["icon-pitch-alignment"]=this.layout.get("icon-rotation-alignment")),"point"===this.layout.get("symbol-placement")){const t=this.layout.get("text-writing-mode");if(t){const e=[];for(const r of t)e.indexOf(r)<0&&e.push(r);this.layout._values["text-writing-mode"]=e;}else this.layout._values["text-writing-mode"]=["horizontal"];}this._setPaintOverrides();}getValueAndResolveTokens(t,e,r,i){const n=this.layout.get(t).evaluate(e,{},r,i),s=this._unevaluatedLayout._values[t];return s.isDataDriven()||Jr(s.value)||!n?n:function(t,e){return e.replace(/{([^{}]+)}/g,(e,r)=>r in t?String(t[r]):"")}(e.properties,n)}createBucket(t){return new Vc(t)}queryRadius(){return 0}queryIntersectsFeature(){return !1}_setPaintOverrides(){for(const t of Rc.paint.overridableProperties){if(!Uc.hasPaintOverride(this.layout,t))continue;const e=this.paint.get(t),r=new Lc(e),i=new Wr(r,e.property.specification);let n=null;n="constant"===e.value.kind||"source"===e.value.kind?new ti("source",i):new ei("composite",i,e.value.zoomStops,e.value._interpolationType),this.paint._values[t]=new Hn(e.property,n,e.parameters);}}_handleOverridablePaintPropertyUpdate(t,e,r){return !(!this.layout||e.isDataDriven()||r.isDataDriven())&&Uc.hasPaintOverride(this.layout,t)}static hasPaintOverride(t,e){const r=t.get("text-field"),i=Rc.paint.properties[e];let n=!1;const s=t=>{for(const e of t)if(i.overrides&&i.overrides.hasOverride(e))return void(n=!0)};if("constant"===r.value.kind&&r.value.value instanceof he)s(r.value.value.sections);else if("source"===r.value.kind){const t=e=>{n||(e instanceof ge&&ye(e.value)===Jt?s(e.value.sections):e instanceof we?s(e.sections):e.eachChild(t));},e=r.value;e._styleExpression&&t(e._styleExpression.expression);}return n}getProgramConfiguration(t){return new la(this,t)}}var Oc={paint:new rs({"background-color":new Wn(Ft.paint_background["background-color"]),"background-pattern":new ts(Ft.paint_background["background-pattern"]),"background-opacity":new Wn(Ft.paint_background["background-opacity"])})},$c={paint:new rs({"raster-opacity":new Wn(Ft.paint_raster["raster-opacity"]),"raster-hue-rotate":new Wn(Ft.paint_raster["raster-hue-rotate"]),"raster-brightness-min":new Wn(Ft.paint_raster["raster-brightness-min"]),"raster-brightness-max":new Wn(Ft.paint_raster["raster-brightness-max"]),"raster-saturation":new Wn(Ft.paint_raster["raster-saturation"]),"raster-contrast":new Wn(Ft.paint_raster["raster-contrast"]),"raster-resampling":new Wn(Ft.paint_raster["raster-resampling"]),"raster-fade-duration":new Wn(Ft.paint_raster["raster-fade-duration"])})};class qc extends pa{constructor(t){super(t,{}),this.implementation=t;}is3D(){return "3d"===this.implementation.renderingMode}hasOffscreenPass(){return void 0!==this.implementation.prerender}recalculate(){}updateTransitions(){}hasTransition(){}serialize(){}onAdd(t){this.implementation.onAdd&&this.implementation.onAdd(t,t.painter.context.gl);}onRemove(t){this.implementation.onRemove&&this.implementation.onRemove(t,t.painter.context.gl);}}var Nc={paint:new rs({"sky-type":new Wn(Ft.paint_sky["sky-type"]),"sky-atmosphere-sun":new Wn(Ft.paint_sky["sky-atmosphere-sun"]),"sky-atmosphere-sun-intensity":new Wn(Ft.paint_sky["sky-atmosphere-sun-intensity"]),"sky-gradient-center":new Wn(Ft.paint_sky["sky-gradient-center"]),"sky-gradient-radius":new Wn(Ft.paint_sky["sky-gradient-radius"]),"sky-gradient":new es(Ft.paint_sky["sky-gradient"]),"sky-atmosphere-halo-color":new Wn(Ft.paint_sky["sky-atmosphere-halo-color"]),"sky-atmosphere-color":new Wn(Ft.paint_sky["sky-atmosphere-color"]),"sky-opacity":new Wn(Ft.paint_sky["sky-opacity"])})};function jc(t,e,r){const i=Ka(0,0,1),n=uo(lo());return function(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);t[0]=i*l-s*o,t[1]=n*l+a*o,t[2]=s*l+i*o,t[3]=a*l-n*o;}(n,n,r?-c(t)+Math.PI:c(t)),co(n,n,-c(e)),io(i,i,n),Qa(i,i)}const Gc={circle:class extends pa{constructor(t){super(t,Ua);}createBucket(t){return new wa(t)}queryRadius(t){const e=t;return Pa("circle-radius",this,e)+Pa("circle-stroke-width",this,e)+Va(this.paint.get("circle-translate"))}queryIntersectsFeature(t,e,r,i,n,s,a,o){const l="map"===this.paint.get("circle-pitch-alignment");if(l&&t.queryGeometry.isAboveHorizon)return !1;const u=Ra(this.paint.get("circle-translate"),this.paint.get("circle-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),c=this.paint.get("circle-radius").evaluate(e,r)+this.paint.get("circle-stroke-width").evaluate(e,r),h=l?c*t.pixelToTileUnitsFactor:c;for(const e of i)for(const r of e){const e=r.add(u),i=o&&s.elevation?s.elevation.exaggeration()*o.getElevationAt(e.x,e.y,!0):0,n=l?e:fo(e,i,a),c=l?t.tilespaceRays.map(t=>go(t,i)):t.queryGeometry.screenGeometry;let p=h;const d=oo([],[r.x,r.y,i,1],a);if("viewport"===this.paint.get("circle-pitch-scale")&&"map"===this.paint.get("circle-pitch-alignment")?p*=d[3]/s.cameraToCenterDistance:"map"===this.paint.get("circle-pitch-scale")&&"viewport"===this.paint.get("circle-pitch-alignment")&&(p*=s.cameraToCenterDistance/d[3]),ka(c,n,p))return !0}return !1}getProgramIds(){return ["circle"]}getProgramConfiguration(t){return new la(this,t)}},heatmap:class extends pa{createBucket(t){return new xo(t)}constructor(t){super(t,Ao),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"heatmap-color"===t&&this._updateColorRamp();}_updateColorRamp(){this.colorRamp=So({expression:this._transitionablePaint._values["heatmap-color"].value.expression,evaluationKey:"heatmapDensity",image:this.colorRamp}),this.colorRampTexture=null;}resize(){this.heatmapFbo&&(this.heatmapFbo.destroy(),this.heatmapFbo=null);}queryRadius(){return 0}queryIntersectsFeature(){return !1}hasOffscreenPass(){return 0!==this.paint.get("heatmap-opacity")&&"none"!==this.visibility}getProgramIds(){return ["heatmap","heatmapTexture"]}getProgramConfiguration(t){return new la(this,t)}},hillshade:class extends pa{constructor(t){super(t,Io);}hasOffscreenPass(){return 0!==this.paint.get("hillshade-exaggeration")&&"none"!==this.visibility}getProgramIds(){return ["hillshade","hillshadePrepare"]}getProgramConfiguration(t){return new la(this,t)}},fill:class extends pa{constructor(t){super(t,pl);}getProgramIds(){const t=this.paint.get("fill-pattern"),e=t&&t.constantOr(1),r=[e?"fillPattern":"fill"];return this.paint.get("fill-antialias")&&r.push(e&&!this.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline"),r}getProgramConfiguration(t){return new la(this,t)}recalculate(t,e){super.recalculate(t,e);const r=this.paint._values["fill-outline-color"];"constant"===r.value.kind&&void 0===r.value.value&&(this.paint._values["fill-outline-color"]=this.paint._values["fill-color"]);}createBucket(t){return new cl(t)}queryRadius(){return Va(this.paint.get("fill-translate"))}queryIntersectsFeature(t,e,r,i,n,s){return !t.queryGeometry.isAboveHorizon&&Aa(Fa(t.tilespaceGeometry,this.paint.get("fill-translate"),this.paint.get("fill-translate-anchor"),s.angle,t.pixelToTileUnitsFactor),i)}isTileClipped(){return !0}},"fill-extrusion":class extends pa{constructor(t){super(t,Bl);}createBucket(t){return new El(t)}queryRadius(){return Va(this.paint.get("fill-extrusion-translate"))}is3D(){return !0}getProgramIds(){return [this.paint.get("fill-extrusion-pattern").constantOr(1)?"fillExtrusionPattern":"fillExtrusion"]}getProgramConfiguration(t){return new la(this,t)}queryIntersectsFeature(t,e,r,n,s,a,o,l,u){const c=Ra(this.paint.get("fill-extrusion-translate"),this.paint.get("fill-extrusion-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),h=this.paint.get("fill-extrusion-height").evaluate(e,r),p=this.paint.get("fill-extrusion-base").evaluate(e,r),d=[0,0],f=l&&a.elevation,y=a.elevation?a.elevation.exaggeration():1;if(f){const e=t.tile.getBucket(this).centroidVertexArray,r=u+1;if(r<e.length){const t=e.get(r);d[0]=t.a_centroid_pos0,d[1]=t.a_centroid_pos1;}}if(0===d[0]&&1===d[1])return !1;const m=function(t,e,r,n,s,a,o,l,u){return a?function(t,e,r,i,n,s,a,o,l){const u=[],c=[],h=[0,0,0];for(const p of t){const t=[],d=[];for(const u of p){const c=u.x+i.x,p=u.y+i.y,f=Vl(c,p,e,r,s,a,o,l);h[0]=c,h[1]=p,h[2]=f.base;const y=Pl(ro(h,h,n));h[0]=c,h[1]=p,h[2]=f.top;const m=Pl(ro(h,h,n));t.push(y),d.push(m);}u.push(t),c.push(d);}return [u,c]}(t,e,r,n,s,a,o,l,u):function(t,e,r,n,s){const a=[],o=[],l=s[8]*e,u=s[9]*e,c=s[10]*e,h=s[11]*e,p=s[8]*r,d=s[9]*r,f=s[10]*r,y=s[11]*r;for(const e of t){const t=[],r=[];for(const a of e){const e=a.x+n.x,o=a.y+n.y,m=s[0]*e+s[4]*o+s[12],g=s[1]*e+s[5]*o+s[13],x=s[2]*e+s[6]*o+s[14],v=s[3]*e+s[7]*o+s[15],b=x+c,w=v+h,_=m+p,k=g+d,A=x+f,S=v+y,I=new i((m+l)/w,(g+u)/w);I.z=b/w,t.push(I);const T=new i(_/S,k/S);T.z=A/S,r.push(T);}a.push(t),o.push(r);}return [a,o]}(t,e,r,n,s)}(n,p,h,c,o,f?l:null,d,y,a.center.lat),g=t.queryGeometry;return function(t,e,r){let i=1/0;Aa(r,e)&&(i=Cl(r,e[0]));for(let n=0;n<e.length;n++){const s=e[n],a=t[n];for(let t=0;t<s.length-1;t++){const e=s[t],n=[e,s[t+1],a[t+1],a[t],e];_a(r,n)&&(i=Math.min(i,Cl(r,n)));}}return i!==1/0&&i}(m[0],m[1],g.isPointQuery()?g.screenBounds:g.screenGeometry)}},line:class extends pa{constructor(t){super(t,jl),this.gradientVersion=0;}_handleSpecialPaintPropertyUpdate(t){"line-gradient"===t&&(this.stepInterpolant=this._transitionablePaint._values["line-gradient"].value.expression._styleExpression.expression instanceof We,this.gradientVersion=(this.gradientVersion+1)%o);}gradientExpression(){return this._transitionablePaint._values["line-gradient"].value.expression}recalculate(t,e){super.recalculate(t,e),this.paint._values["line-floorwidth"]=Gl.possiblyEvaluate(this._transitioningPaint._values["line-width"].value,t);}createBucket(t){return new ql(t)}getProgramIds(){const t=this.paint.get("line-dasharray"),e=this.paint.get("line-pattern").constantOr(1),r=this.paint.get("line-gradient");return [e?"linePattern":t?"lineSDF":r?"lineGradient":"line"]}getProgramConfiguration(t){return new la(this,t)}queryRadius(t){const e=t,r=Zl(Pa("line-width",this,e),Pa("line-gap-width",this,e)),i=Pa("line-offset",this,e);return r/2+Math.abs(i)+Va(this.paint.get("line-translate"))}queryIntersectsFeature(t,e,r,n,s,a){if(t.queryGeometry.isAboveHorizon)return !1;const o=Fa(t.tilespaceGeometry,this.paint.get("line-translate"),this.paint.get("line-translate-anchor"),a.angle,t.pixelToTileUnitsFactor),l=t.pixelToTileUnitsFactor/2*Zl(this.paint.get("line-width").evaluate(e,r),this.paint.get("line-gap-width").evaluate(e,r)),u=this.paint.get("line-offset").evaluate(e,r);return u&&(n=function(t,e){const r=[],n=new i(0,0);for(let i=0;i<t.length;i++){const s=t[i],a=[];for(let t=0;t<s.length;t++){const r=s[t-1],i=s[t],o=s[t+1],l=0===t?n:i.sub(r)._unit()._perp(),u=t===s.length-1?n:o.sub(i)._unit()._perp(),c=l._add(u)._unit();c._mult(1/(c.x*u.x+c.y*u.y)),a.push(c._mult(e)._add(i));}r.push(a);}return r}(n,u*t.pixelToTileUnitsFactor)),function(t,e,r){for(let i=0;i<e.length;i++){const n=e[i];if(t.length>=3)for(let e=0;e<n.length;e++)if(Ba(t,n[e]))return !0;if(Sa(t,n,r))return !0}return !1}(o,n,l)}isTileClipped(){return !0}},symbol:Uc,background:class extends pa{constructor(t){super(t,Oc);}getProgramIds(){return [this.paint.get("background-pattern")?"backgroundPattern":"background"]}},raster:class extends pa{constructor(t){super(t,$c);}getProgramIds(){return ["raster"]}},sky:class extends pa{constructor(t){super(t,Nc),this._updateColorRamp();}_handleSpecialPaintPropertyUpdate(t){"sky-gradient"===t?this._updateColorRamp():"sky-atmosphere-sun"!==t&&"sky-atmosphere-halo-color"!==t&&"sky-atmosphere-color"!==t&&"sky-atmosphere-sun-intensity"!==t||(this._skyboxInvalidated=!0);}_updateColorRamp(){this.colorRamp=So({expression:this._transitionablePaint._values["sky-gradient"].value.expression,evaluationKey:"skyRadialProgress"}),this.colorRampTexture&&(this.colorRampTexture.destroy(),this.colorRampTexture=null);}needsSkyboxCapture(t){if(this._skyboxInvalidated||!this.skyboxTexture||!this.skyboxGeometry)return !0;if(!this.paint.get("sky-atmosphere-sun")){const e=t.style.light.properties.get("position");return this._lightPosition.azimuthal!==e.azimuthal||this._lightPosition.polar!==e.polar}}getCenter(t,e){const r=this.paint.get("sky-type");if("atmosphere"===r){const r=this.paint.get("sky-atmosphere-sun"),i=!r,n=t.style.light,s=n.properties.get("position");return i&&"viewport"===n.properties.get("anchor")&&E("The sun direction is attached to a light with viewport anchor, lighting may behave unexpectedly."),i?jc(s.azimuthal,90-s.polar,e):jc(r[0],90-r[1],e)}if("gradient"===r){const t=this.paint.get("sky-gradient-center");return jc(t[0],90-t[1],e)}}is3D(){return !1}isSky(){return !0}markSkyboxValid(t){this._skyboxInvalidated=!1,this._lightPosition=t.style.light.properties.get("position");}hasOffscreenPass(){return !0}getProgramIds(){const t=this.paint.get("sky-type");return "atmosphere"===t?["skyboxCapture","skybox"]:"gradient"===t?["skyboxGradient"]:null}}},{HTMLImageElement:Zc,HTMLCanvasElement:Xc,HTMLVideoElement:Kc,ImageData:Hc,ImageBitmap:Yc}=s;class Wc{constructor(t,e,r,i){this.context=t,this.format=r,this.texture=t.gl.createTexture(),this.update(e,i);}update(t,e,r){const{width:i,height:n}=t,s=!(this.size&&this.size[0]===i&&this.size[1]===n||r),{context:a}=this,{gl:o}=a;if(this.useMipmap=Boolean(e&&e.useMipmap),o.bindTexture(o.TEXTURE_2D,this.texture),a.pixelStoreUnpackFlipY.set(!1),a.pixelStoreUnpack.set(1),a.pixelStoreUnpackPremultiplyAlpha.set(this.format===o.RGBA&&(!e||!1!==e.premultiply)),s)this.size=[i,n],t instanceof Zc||t instanceof Xc||t instanceof Kc||t instanceof Hc||Yc&&t instanceof Yc?o.texImage2D(o.TEXTURE_2D,0,this.format,this.format,o.UNSIGNED_BYTE,t):o.texImage2D(o.TEXTURE_2D,0,this.format,i,n,0,this.format,o.UNSIGNED_BYTE,t.data);else {const{x:e,y:s}=r||{x:0,y:0};t instanceof Zc||t instanceof Xc||t instanceof Kc||t instanceof Hc||Yc&&t instanceof Yc?o.texSubImage2D(o.TEXTURE_2D,0,e,s,o.RGBA,o.UNSIGNED_BYTE,t):o.texSubImage2D(o.TEXTURE_2D,0,e,s,i,n,o.RGBA,o.UNSIGNED_BYTE,t.data);}this.useMipmap&&this.isSizePowerOfTwo()&&o.generateMipmap(o.TEXTURE_2D);}bind(t,e,r){const{context:i}=this,{gl:n}=i;n.bindTexture(n.TEXTURE_2D,this.texture),r!==n.LINEAR_MIPMAP_NEAREST||this.isSizePowerOfTwo()||(r=n.LINEAR),t!==this.filter&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MAG_FILTER,t),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_MIN_FILTER,r||t),this.filter=t),e!==this.wrap&&(n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_S,e),n.texParameteri(n.TEXTURE_2D,n.TEXTURE_WRAP_T,e),this.wrap=e);}isSizePowerOfTwo(){return this.size[0]===this.size[1]&&Math.log(this.size[0])/Math.LN2%1==0}destroy(){const{gl:t}=this.context;t.deleteTexture(this.texture),this.texture=null;}}class Jc{constructor(t){this._callback=t,this._triggered=!1,"undefined"!=typeof MessageChannel&&(this._channel=new MessageChannel,this._channel.port2.onmessage=()=>{this._triggered=!1,this._callback();});}trigger(){this._triggered||(this._triggered=!0,this._channel?this._channel.port1.postMessage(!0):setTimeout(()=>{this._triggered=!1,this._callback();},0));}remove(){delete this._channel,this._callback=()=>{};}}const Qc=s.performance;class th{constructor(t){this._marks={start:[t.url,"start"].join("#"),end:[t.url,"end"].join("#"),measure:t.url.toString()},Qc.mark(this._marks.start);}finish(){Qc.mark(this._marks.end);let t=Qc.getEntriesByName(this._marks.measure);return 0===t.length&&(Qc.measure(this._marks.measure,this._marks.start,this._marks.end),t=Qc.getEntriesByName(this._marks.measure),Qc.clearMarks(this._marks.start),Qc.clearMarks(this._marks.end),Qc.clearMeasures(this._marks.measure)),t}}class eh{constructor(){this.tasks={},this.taskQueue=[],k(["process"],this),this.invoker=new Jc(this.process),this.nextId=0;}add(t,e){const r=this.nextId++;return this.tasks[r]={fn:t,metadata:e,priority:rh(e),id:r},this.taskQueue.push(r),this.invoker.trigger(),{cancel:()=>{delete this.tasks[r];}}}process(){D();try{if(this.taskQueue=this.taskQueue.filter(t=>!!this.tasks[t]),!this.taskQueue.length)return;const t=this.pick();if(null===t)return;const e=this.tasks[t];if(delete this.tasks[t],this.taskQueue.length&&this.invoker.trigger(),!e)return;e.fn();}finally{}}pick(){let t=null,e=1/0;for(let r=0;r<this.taskQueue.length;r++){const i=this.tasks[this.taskQueue[r]];i.priority<e&&(e=i.priority,t=r);}if(null===t)return null;const r=this.taskQueue[t];return this.taskQueue.splice(t,1),r}remove(){this.invoker.remove();}}function rh({type:t,isSymbolTile:e,zoom:r}){return r=r||0,"message"===t?0:"maybePrepare"!==t||e?"parseTile"!==t||e?"parseTile"===t&&e?300-r:"maybePrepare"===t&&e?400-r:500:200-r:100-r}class ih{constructor(t,e){t&&(e?this.setSouthWest(t).setNorthEast(e):4===t.length?this.setSouthWest([t[0],t[1]]).setNorthEast([t[2],t[3]]):this.setSouthWest(t[0]).setNorthEast(t[1]));}setNorthEast(t){return this._ne=t instanceof nh?new nh(t.lng,t.lat):nh.convert(t),this}setSouthWest(t){return this._sw=t instanceof nh?new nh(t.lng,t.lat):nh.convert(t),this}extend(t){const e=this._sw,r=this._ne;let i,n;if(t instanceof nh)i=t,n=t;else {if(!(t instanceof ih))return Array.isArray(t)?4===t.length||t.every(Array.isArray)?this.extend(ih.convert(t)):this.extend(nh.convert(t)):this;if(i=t._sw,n=t._ne,!i||!n)return this}return e||r?(e.lng=Math.min(i.lng,e.lng),e.lat=Math.min(i.lat,e.lat),r.lng=Math.max(n.lng,r.lng),r.lat=Math.max(n.lat,r.lat)):(this._sw=new nh(i.lng,i.lat),this._ne=new nh(n.lng,n.lat)),this}getCenter(){return new nh((this._sw.lng+this._ne.lng)/2,(this._sw.lat+this._ne.lat)/2)}getSouthWest(){return this._sw}getNorthEast(){return this._ne}getNorthWest(){return new nh(this.getWest(),this.getNorth())}getSouthEast(){return new nh(this.getEast(),this.getSouth())}getWest(){return this._sw.lng}getSouth(){return this._sw.lat}getEast(){return this._ne.lng}getNorth(){return this._ne.lat}toArray(){return [this._sw.toArray(),this._ne.toArray()]}toString(){return `LngLatBounds(${this._sw.toString()}, ${this._ne.toString()})`}isEmpty(){return !(this._sw&&this._ne)}contains(t){const{lng:e,lat:r}=nh.convert(t);let i=this._sw.lng<=e&&e<=this._ne.lng;return this._sw.lng>this._ne.lng&&(i=this._sw.lng>=e&&e>=this._ne.lng),this._sw.lat<=r&&r<=this._ne.lat&&i}static convert(t){return !t||t instanceof ih?t:new ih(t)}}class nh{constructor(t,e){if(isNaN(t)||isNaN(e))throw new Error(`Invalid LngLat object: (${t}, ${e})`);if(this.lng=+t,this.lat=+e,this.lat>90||this.lat<-90)throw new Error("Invalid LngLat latitude value: must be between -90 and 90")}wrap(){return new nh(y(this.lng,-180,180),this.lat)}toArray(){return [this.lng,this.lat]}toString(){return `LngLat(${this.lng}, ${this.lat})`}distanceTo(t){const e=Math.PI/180,r=this.lat*e,i=t.lat*e,n=Math.sin(r)*Math.sin(i)+Math.cos(r)*Math.cos(i)*Math.cos((t.lng-this.lng)*e);return 6371008.8*Math.acos(Math.min(n,1))}toBounds(t=0){const e=360*t/40075017,r=e/Math.cos(Math.PI/180*this.lat);return new ih(new nh(this.lng-r,this.lat-e),new nh(this.lng+r,this.lat+e))}static convert(t){if(t instanceof nh)return t;if(Array.isArray(t)&&(2===t.length||3===t.length))return new nh(Number(t[0]),Number(t[1]));if(!Array.isArray(t)&&"object"==typeof t&&null!==t)return new nh(Number("lng"in t?t.lng:t.lon),Number(t.lat));throw new Error("`LngLatLike` argument must be specified as a LngLat instance, an object {lng: <lng>, lat: <lat>}, an object {lon: <lng>, lat: <lat>}, or an array of [<lng>, <lat>]")}}const sh=2*Math.PI*6371008.8;function ah(t){return sh*Math.cos(t*Math.PI/180)}function oh(t){return (180+t)/360}function lh(t){return (180-180/Math.PI*Math.log(Math.tan(Math.PI/4+t*Math.PI/360)))/360}function uh(t,e){return t/ah(e)}function ch(t){return 360/Math.PI*Math.atan(Math.exp((180-360*t)*Math.PI/180))-90}function hh(t,e){return t*ah(ch(e))}class ph{constructor(t,e,r=0){this.x=+t,this.y=+e,this.z=+r;}static fromLngLat(t,e=0){const r=nh.convert(t);return new ph(oh(r.lng),lh(r.lat),uh(e,r.lat))}toLngLat(){return new nh(360*this.x-180,ch(this.y))}toAltitude(){return hh(this.z,this.y)}meterInMercatorCoordinateUnits(){return 1/sh*(t=ch(this.y),1/Math.cos(t*Math.PI/180));var t;}}function dh(t,e,r){var i=2*Math.PI*6378137/256/Math.pow(2,r);return [t*i-2*Math.PI*6378137/2,e*i-2*Math.PI*6378137/2]}class fh{constructor(t,e,r){this.z=t,this.x=e,this.y=r,this.key=gh(0,t,t,e,r);}equals(t){return this.z===t.z&&this.x===t.x&&this.y===t.y}url(t,e){const r=(n=this.y,s=this.z,a=dh(256*(i=this.x),256*(n=Math.pow(2,s)-n-1),s),o=dh(256*(i+1),256*(n+1),s),a[0]+","+a[1]+","+o[0]+","+o[1]);var i,n,s,a,o;const l=function(t,e,r){let i,n="";for(let s=t;s>0;s--)i=1<<s-1,n+=(e&i?1:0)+(r&i?2:0);return n}(this.z,this.x,this.y);return t[(this.x+this.y)%t.length].replace("{prefix}",(this.x%16).toString(16)+(this.y%16).toString(16)).replace("{z}",String(this.z)).replace("{x}",String(this.x)).replace("{y}",String("tms"===e?Math.pow(2,this.z)-this.y-1:this.y)).replace("{quadkey}",l).replace("{bbox-epsg-3857}",r)}getTilePoint(t){const e=Math.pow(2,this.z);return new i(8192*(t.x*e-this.x),8192*(t.y*e-this.y))}getTileVec3(t){const e=Math.pow(2,this.z);return Ka(8192*(t.x*e-this.x),8192*(t.y*e-this.y),hh(t.z,t.y))}toString(){return `${this.z}/${this.x}/${this.y}`}}class yh{constructor(t,e){this.wrap=t,this.canonical=e,this.key=gh(t,e.z,e.z,e.x,e.y);}}class mh{constructor(t,e,r,i,n){this.overscaledZ=t,this.wrap=e,this.canonical=new fh(r,+i,+n),this.key=0===e&&t===r?this.canonical.key:gh(e,t,r,i,n);}equals(t){return this.overscaledZ===t.overscaledZ&&this.wrap===t.wrap&&this.canonical.equals(t.canonical)}scaledTo(t){const e=this.canonical.z-t;return t>this.canonical.z?new mh(t,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y):new mh(t,this.wrap,t,this.canonical.x>>e,this.canonical.y>>e)}calculateScaledKey(t,e=!0){if(this.overscaledZ===t&&e)return this.key;if(t>this.canonical.z)return gh(this.wrap*+e,t,this.canonical.z,this.canonical.x,this.canonical.y);{const r=this.canonical.z-t;return gh(this.wrap*+e,t,t,this.canonical.x>>r,this.canonical.y>>r)}}isChildOf(t){if(t.wrap!==this.wrap)return !1;const e=this.canonical.z-t.canonical.z;return 0===t.overscaledZ||t.overscaledZ<this.overscaledZ&&t.canonical.x===this.canonical.x>>e&&t.canonical.y===this.canonical.y>>e}children(t){if(this.overscaledZ>=t)return [new mh(this.overscaledZ+1,this.wrap,this.canonical.z,this.canonical.x,this.canonical.y)];const e=this.canonical.z+1,r=2*this.canonical.x,i=2*this.canonical.y;return [new mh(e,this.wrap,e,r,i),new mh(e,this.wrap,e,r+1,i),new mh(e,this.wrap,e,r,i+1),new mh(e,this.wrap,e,r+1,i+1)]}isLessThan(t){return this.wrap<t.wrap||!(this.wrap>t.wrap)&&(this.overscaledZ<t.overscaledZ||!(this.overscaledZ>t.overscaledZ)&&(this.canonical.x<t.canonical.x||!(this.canonical.x>t.canonical.x)&&this.canonical.y<t.canonical.y))}wrapped(){return new mh(this.overscaledZ,0,this.canonical.z,this.canonical.x,this.canonical.y)}unwrapTo(t){return new mh(this.overscaledZ,t,this.canonical.z,this.canonical.x,this.canonical.y)}overscaleFactor(){return Math.pow(2,this.overscaledZ-this.canonical.z)}toUnwrapped(){return new yh(this.wrap,this.canonical)}toString(){return `${this.overscaledZ}/${this.canonical.x}/${this.canonical.y}`}getTilePoint(t){return this.canonical.getTilePoint(new ph(t.x-this.wrap,t.y))}getTileVec3(t){return this.canonical.getTileVec3(new ph(t.x-this.wrap,t.y,t.z))}}function gh(t,e,r,i,n){const s=1<<Math.min(r,22);let a=s*(n%s)+i%s;return t&&r<22&&(a+=s*s*((t<0?-2*t-1:2*t)%(1<<2*(22-r)))),16*(32*a+r)+(e-r)}Gi("CanonicalTileID",fh),Gi("OverscaledTileID",mh,{omit:["posMatrix"]});class xh{constructor(t){this._stringToNumber={},this._numberToString=[];for(let e=0;e<t.length;e++){const r=t[e];this._stringToNumber[r]=e,this._numberToString[e]=r;}}encode(t){return this._stringToNumber[t]}decode(t){return this._numberToString[t]}}class vh{constructor(t,e,r,i,n){this.type="Feature",this._vectorTileFeature=t,t._z=e,t._x=r,t._y=i,this.properties=t.properties,this.id=n;}get geometry(){return void 0===this._geometry&&(this._geometry=this._vectorTileFeature.toGeoJSON(this._vectorTileFeature._x,this._vectorTileFeature._y,this._vectorTileFeature._z).geometry),this._geometry}set geometry(t){this._geometry=t;}toJSON(){const t={geometry:this.geometry};for(const e in this)"_geometry"!==e&&"_vectorTileFeature"!==e&&(t[e]=this[e]);return t}}var bh=os([{name:"a_pos",type:"Int16",components:2}]);class wh{constructor(t,e,r){this.tileID=t,this.uid=b(),this.uses=0,this.tileSize=e,this.tileZoom=r,this.buckets={},this.expirationTime=null,this.queryPadding=0,this.hasSymbolBuckets=!1,this.hasRTLText=!1,this.dependencies={},this.expiredRequestCount=0,this.state="loading";}registerFadeDuration(t){const e=t+this.timeAdded;e<$.now()||this.fadeEndTime&&e<this.fadeEndTime||(this.fadeEndTime=e);}wasRequested(){return "errored"===this.state||"loaded"===this.state||"reloading"===this.state}loadVectorData(t,e,r){if(this.hasData()&&this.unloadVectorData(),this.state="loaded",t){t.featureIndex&&(this.latestFeatureIndex=t.featureIndex,t.rawTileData?(this.latestRawTileData=t.rawTileData,this.latestFeatureIndex.rawTileData=t.rawTileData):this.latestRawTileData&&(this.latestFeatureIndex.rawTileData=this.latestRawTileData)),this.collisionBoxArray=t.collisionBoxArray,this.buckets=function(t,e){const r={};if(!e)return r;for(const i of t){const t=i.layerIds.map(t=>e.getLayer(t)).filter(Boolean);if(0!==t.length){i.layers=t,i.stateDependentLayerIds&&(i.stateDependentLayers=i.stateDependentLayerIds.map(e=>t.filter(t=>t.id===e)[0]));for(const e of t)r[e.id]=i;}}return r}(t.buckets,e.style),this.hasSymbolBuckets=!1;for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Vc){if(this.hasSymbolBuckets=!0,!r)break;e.justReloaded=!0;}}if(this.hasRTLText=!1,this.hasSymbolBuckets)for(const t in this.buckets){const e=this.buckets[t];if(e instanceof Vc&&e.hasRTLText){this.hasRTLText=!0,$n.isLoading()||$n.isLoaded()||"deferred"!==Un()||On();break}}this.queryPadding=0;for(const t in this.buckets){const r=this.buckets[t];this.queryPadding=Math.max(this.queryPadding,e.style.getLayer(t).queryRadius(r));}t.imageAtlas&&(this.imageAtlas=t.imageAtlas),t.glyphAtlasImage&&(this.glyphAtlasImage=t.glyphAtlasImage);}else this.collisionBoxArray=new Bs;}unloadVectorData(){for(const t in this.buckets)this.buckets[t].destroy();this.buckets={},this.imageAtlasTexture&&this.imageAtlasTexture.destroy(),this.imageAtlas&&(this.imageAtlas=null),this.glyphAtlasTexture&&this.glyphAtlasTexture.destroy(),this.latestFeatureIndex=null,this.state="unloaded";}getBucket(t){return this.buckets[t.id]}upload(t){for(const e in this.buckets){const r=this.buckets[e];r.uploadPending()&&r.upload(t);}const e=t.gl;this.imageAtlas&&!this.imageAtlas.uploaded&&(this.imageAtlasTexture=new Wc(t,this.imageAtlas.image,e.RGBA),this.imageAtlas.uploaded=!0),this.glyphAtlasImage&&(this.glyphAtlasTexture=new Wc(t,this.glyphAtlasImage,e.ALPHA),this.glyphAtlasImage=null);}prepare(t){this.imageAtlas&&this.imageAtlas.patchUpdatedImages(t,this.imageAtlasTexture);}queryRenderedFeatures(t,e,r,i,n,s,a,o){return this.latestFeatureIndex&&this.latestFeatureIndex.rawTileData?this.latestFeatureIndex.query({tileResult:i,pixelPosMatrix:a,transform:s,params:n},t,e,r):{}}querySourceFeatures(t,e){const r=this.latestFeatureIndex;if(!r||!r.rawTileData)return;const i=r.loadVTLayers(),n=e?e.sourceLayer:"",s=i._geojsonTileLayer||i[n];if(!s)return;const a=pi(e&&e.filter),{z:o,x:l,y:u}=this.tileID.canonical,c={z:o,x:l,y:u};for(let e=0;e<s.length;e++){const i=s.feature(e);if(a.needGeometry){const t=va(i,!0);if(!a.filter(new qn(this.tileID.overscaledZ),t,this.tileID.canonical))continue}else if(!a.filter(new qn(this.tileID.overscaledZ),i))continue;const h=r.getId(i,n),p=new vh(i,o,l,u,h);p.tile=c,t.push(p);}}hasData(){return "loaded"===this.state||"reloading"===this.state||"expired"===this.state}patternsLoaded(){return this.imageAtlas&&!!Object.keys(this.imageAtlas.patternPositions).length}setExpiryData(t){const e=this.expirationTime;if(t.cacheControl){const e=C(t.cacheControl);e["max-age"]&&(this.expirationTime=Date.now()+1e3*e["max-age"]);}else t.expires&&(this.expirationTime=new Date(t.expires).getTime());if(this.expirationTime){const t=Date.now();let r=!1;if(this.expirationTime>t)r=!1;else if(e)if(this.expirationTime<e)r=!0;else {const i=this.expirationTime-e;i?this.expirationTime=t+Math.max(i,3e4):r=!0;}else r=!0;r?(this.expiredRequestCount++,this.state="expired"):this.expiredRequestCount=0;}}getExpiryTimeout(){if(this.expirationTime)return this.expiredRequestCount?1e3*(1<<Math.min(this.expiredRequestCount-1,31)):Math.min(this.expirationTime-(new Date).getTime(),Math.pow(2,31)-1)}setFeatureState(t,e){if(!this.latestFeatureIndex||!this.latestFeatureIndex.rawTileData||0===Object.keys(t).length)return;const r=this.latestFeatureIndex.loadVTLayers();for(const i in this.buckets){if(!e.style.hasLayer(i))continue;const n=this.buckets[i],s=n.layers[0].sourceLayer||"_geojsonTileLayer",a=r[s],o=t[s];if(!a||!o||0===Object.keys(o).length)continue;n.update(o,a,this.imageAtlas&&this.imageAtlas.patternPositions||{});const l=e&&e.style&&e.style.getLayer(i);l&&(this.queryPadding=Math.max(this.queryPadding,l.queryRadius(n)));}}holdingForFade(){return void 0!==this.symbolFadeHoldUntil}symbolFadeFinished(){return !this.symbolFadeHoldUntil||this.symbolFadeHoldUntil<$.now()}clearFadeHold(){this.symbolFadeHoldUntil=void 0;}setHoldDuration(t){this.symbolFadeHoldUntil=$.now()+t;}setDependencies(t,e){const r={};for(const t of e)r[t]=!0;this.dependencies[t]=r;}hasDependency(t,e){for(const r of t){const t=this.dependencies[r];if(t)for(const r of e)if(t[r])return !0}return !1}clearQueryDebugViz(){}}class _h{constructor(){this.state={},this.stateChanges={},this.deletedStates={};}updateState(t,e,r){const i=String(e);if(this.stateChanges[t]=this.stateChanges[t]||{},this.stateChanges[t][i]=this.stateChanges[t][i]||{},x(this.stateChanges[t][i],r),null===this.deletedStates[t]){this.deletedStates[t]={};for(const e in this.state[t])e!==i&&(this.deletedStates[t][e]=null);}else if(this.deletedStates[t]&&null===this.deletedStates[t][i]){this.deletedStates[t][i]={};for(const e in this.state[t][i])r[e]||(this.deletedStates[t][i][e]=null);}else for(const e in r)this.deletedStates[t]&&this.deletedStates[t][i]&&null===this.deletedStates[t][i][e]&&delete this.deletedStates[t][i][e];}removeFeatureState(t,e,r){if(null===this.deletedStates[t])return;const i=String(e);if(this.deletedStates[t]=this.deletedStates[t]||{},r&&void 0!==e)null!==this.deletedStates[t][i]&&(this.deletedStates[t][i]=this.deletedStates[t][i]||{},this.deletedStates[t][i][r]=null);else if(void 0!==e)if(this.stateChanges[t]&&this.stateChanges[t][i])for(r in this.deletedStates[t][i]={},this.stateChanges[t][i])this.deletedStates[t][i][r]=null;else this.deletedStates[t][i]=null;else this.deletedStates[t]=null;}getState(t,e){const r=String(e),i=x({},(this.state[t]||{})[r],(this.stateChanges[t]||{})[r]);if(null===this.deletedStates[t])return {};if(this.deletedStates[t]){const r=this.deletedStates[t][e];if(null===r)return {};for(const t in r)delete i[t];}return i}initializeTileState(t,e){t.setFeatureState(this.state,e);}coalesceChanges(t,e){const r={};for(const t in this.stateChanges){this.state[t]=this.state[t]||{};const e={};for(const r in this.stateChanges[t])this.state[t][r]||(this.state[t][r]={}),x(this.state[t][r],this.stateChanges[t][r]),e[r]=this.state[t][r];r[t]=e;}for(const t in this.deletedStates){this.state[t]=this.state[t]||{};const e={};if(null===this.deletedStates[t])for(const r in this.state[t])e[r]={},this.state[t][r]={};else for(const r in this.deletedStates[t]){if(null===this.deletedStates[t][r])this.state[t][r]={};else for(const e of Object.keys(this.deletedStates[t][r]))delete this.state[t][r][e];e[r]=this.state[t][r];}r[t]=r[t]||{},x(r[t],e);}if(this.stateChanges={},this.deletedStates={},0!==Object.keys(r).length)for(const i in t)t[i].setFeatureState(r,e);}}class kh{constructor(t){this.size=t,this.minimums=[],this.maximums=[],this.leaves=[];}getElevation(t,e){const r=this.toIdx(t,e);return {min:this.minimums[r],max:this.maximums[r]}}isLeaf(t,e){return this.leaves[this.toIdx(t,e)]}toIdx(t,e){return e*this.size+t}}function Ah(t,e,r,i){let n=0,s=Number.MAX_VALUE;for(let a=0;a<3;a++)if(Math.abs(i[a])<1e-15){if(r[a]<t[a]||r[a]>e[a])return null}else {const o=1/i[a];let l=(t[a]-r[a])*o,u=(e[a]-r[a])*o;if(l>u){const t=l;l=u,u=t;}if(l>n&&(n=l),u<s&&(s=u),n>s)return null}return n}function Sh(t,e,r,i,n,s,a,o,l,u,c){const h=i-t,p=n-e,d=s-r,f=a-t,y=o-e,m=l-r,g=c[1]*m-c[2]*y,x=c[2]*f-c[0]*m,v=c[0]*y-c[1]*f,b=h*g+p*x+d*v;if(Math.abs(b)<1e-15)return null;const w=1/b,_=u[0]-t,k=u[1]-e,A=u[2]-r,S=(_*g+k*x+A*v)*w;if(S<0||S>1)return null;const I=k*d-A*p,T=A*h-_*d,z=_*p-k*h,E=(c[0]*I+c[1]*T+c[2]*z)*w;return E<0||S+E>1?null:(f*I+y*T+m*z)*w}function Ih(t,e,r){return (t-e)/(r-e)}function Th(t,e,r,i,n,s,a,o,l){const u=1<<r,c=s-i,h=a-n,p=(t+1)/u*c+i,d=(e+0)/u*h+n,f=(e+1)/u*h+n;o[0]=(t+0)/u*c+i,o[1]=d,l[0]=p,l[1]=f;}class zh{constructor(t){if(this.maximums=[],this.minimums=[],this.leaves=[],this.childOffsets=[],this.nodeCount=0,this.dem=t,this._siblingOffset=[[0,0],[1,0],[0,1],[1,1]],!this.dem)return;const e=function(t){const e=Math.ceil(Math.log2(t.dim/8)),r=[];let i=Math.ceil(Math.pow(2,e));const n=1/i,s=(t,e,r,i,n)=>{const s=i?1:0,a=(t+1)*r-s,o=e*r,l=(e+1)*r-s;n[0]=t*r,n[1]=o,n[2]=a,n[3]=l;};let a=new kh(i);const o=[];for(let e=0;e<i*i;e++){s(e%i,Math.floor(e/i),n,!1,o);const r=Mh(o[0],o[1],t),l=Mh(o[2],o[1],t),u=Mh(o[2],o[3],t),c=Mh(o[0],o[3],t);a.minimums.push(Math.min(r,l,u,c)),a.maximums.push(Math.max(r,l,u,c)),a.leaves.push(1);}for(r.push(a),i/=2;i>=1;i/=2){const t=r[r.length-1];a=new kh(i);for(let e=0;e<i*i;e++){s(e%i,Math.floor(e/i),2,!0,o);const r=t.getElevation(o[0],o[1]),n=t.getElevation(o[2],o[1]),l=t.getElevation(o[2],o[3]),u=t.getElevation(o[0],o[3]),c=t.isLeaf(o[0],o[1]),h=t.isLeaf(o[2],o[1]),p=t.isLeaf(o[2],o[3]),d=t.isLeaf(o[0],o[3]),f=Math.min(r.min,n.min,l.min,u.min),y=Math.max(r.max,n.max,l.max,u.max),m=c&&h&&p&&d;a.maximums.push(y),a.minimums.push(f),a.leaves.push(y-f<=5&&m?1:0);}r.push(a);}return r}(this.dem),r=e.length-1,i=e[r];this._addNode(i.minimums[0],i.maximums[0],i.leaves[0]),this._construct(e,0,0,r,0);}raycastRoot(t,e,r,i,n,s,a=1){return Ah([t,e,-100],[r,i,this.maximums[0]*a],n,s)}raycast(t,e,r,i,n,s,a=1){if(!this.nodeCount)return null;const o=this.raycastRoot(t,e,r,i,n,s,a);if(null==o)return null;const l=[],u=[],c=[],h=[],p=[{idx:0,t:o,nodex:0,nodey:0,depth:0}];for(;p.length>0;){const{idx:o,t:d,nodex:f,nodey:y,depth:m}=p.pop();if(this.leaves[o]){Th(f,y,m,t,e,r,i,c,h);const o=1<<m,l=(f+0)/o,u=(f+1)/o,p=(y+0)/o,g=(y+1)/o,x=Mh(l,p,this.dem)*a,v=Mh(u,p,this.dem)*a,b=Mh(u,g,this.dem)*a,w=Mh(l,g,this.dem)*a,_=Sh(c[0],c[1],x,h[0],c[1],v,h[0],h[1],b,n,s),k=Sh(h[0],h[1],b,c[0],h[1],w,c[0],c[1],x,n,s),A=Math.min(null!==_?_:Number.MAX_VALUE,null!==k?k:Number.MAX_VALUE);if(A!==Number.MAX_VALUE)return A;{const t=Ja([],n,s,d);if(Eh(x,v,w,b,Ih(t[0],c[0],h[0]),Ih(t[1],c[1],h[1]))>=t[2])return d}continue}let g=0;for(let p=0;p<this._siblingOffset.length;p++){Th((f<<1)+this._siblingOffset[p][0],(y<<1)+this._siblingOffset[p][1],m+1,t,e,r,i,c,h),c[2]=-100,h[2]=this.maximums[this.childOffsets[o]+p]*a;const d=Ah(c,h,n,s);if(null!=d){const t=d;l[p]=t;let e=!1;for(let r=0;r<g&&!e;r++)t>=l[u[r]]&&(u.splice(r,0,p),e=!0);e||(u[g]=p),g++;}}for(let t=0;t<g;t++){const e=u[t];p.push({idx:this.childOffsets[o]+e,t:l[e],nodex:(f<<1)+this._siblingOffset[e][0],nodey:(y<<1)+this._siblingOffset[e][1],depth:m+1});}}return null}_addNode(t,e,r){return this.minimums.push(t),this.maximums.push(e),this.leaves.push(r),this.childOffsets.push(0),this.nodeCount++}_construct(t,e,r,i,n){if(1===t[i].isLeaf(e,r))return;this.childOffsets[n]||(this.childOffsets[n]=this.nodeCount);const s=i-1,a=t[s];let o,l=0;for(let t=0;t<this._siblingOffset.length;t++){const i=2*e+this._siblingOffset[t][0],n=2*r+this._siblingOffset[t][1],s=a.getElevation(i,n),u=a.isLeaf(i,n),c=this._addNode(s.min,s.max,u);u&&(l|=1<<t),o||(o=c);}for(let i=0;i<this._siblingOffset.length;i++)l&1<<i||this._construct(t,2*e+this._siblingOffset[i][0],2*r+this._siblingOffset[i][1],s,o+i);}}function Eh(t,e,r,i,n,s){return Je(Je(t,r,s),Je(e,i,s),n)}function Mh(t,e,r){const i=r.dim,n=f(t*i-.5,0,i-1),s=f(e*i-.5,0,i-1),a=Math.floor(n),o=Math.floor(s),l=Math.min(a+1,i-1),u=Math.min(o+1,i-1);return Eh(r.get(a,o),r.get(l,o),r.get(a,u),r.get(l,u),n-a,s-o)}const Bh={mapbox:[6553.6,25.6,.1,1e4],terrarium:[256,1,1/256,32768]};class Dh{get tree(){return this._tree||this._buildQuadTree(),this._tree}constructor(t,e,r,i=!1,n=!1){if(this.uid=t,e.height!==e.width)throw new RangeError("DEM tiles must be square");if(r&&"mapbox"!==r&&"terrarium"!==r)return E(`"${r}" is not a valid encoding type. Valid types include "mapbox" and "terrarium".`);this.stride=e.height;const s=this.dim=e.height-2;if(this.data=new Uint32Array(e.data.buffer),this.encoding=r||"mapbox",this.borderReady=i,!i){for(let t=0;t<s;t++)this.data[this._idx(-1,t)]=this.data[this._idx(0,t)],this.data[this._idx(s,t)]=this.data[this._idx(s-1,t)],this.data[this._idx(t,-1)]=this.data[this._idx(t,0)],this.data[this._idx(t,s)]=this.data[this._idx(t,s-1)];this.data[this._idx(-1,-1)]=this.data[this._idx(0,0)],this.data[this._idx(s,-1)]=this.data[this._idx(s-1,0)],this.data[this._idx(-1,s)]=this.data[this._idx(0,s-1)],this.data[this._idx(s,s)]=this.data[this._idx(s-1,s-1)],n&&this._buildQuadTree();}}_buildQuadTree(){this._tree=new zh(this);}get(t,e,r=!1){const i=new Uint8Array(this.data.buffer);r&&(t=f(t,-1,this.dim),e=f(e,-1,this.dim));const n=4*this._idx(t,e);return ("terrarium"===this.encoding?this._unpackTerrarium:this._unpackMapbox)(i[n],i[n+1],i[n+2])}static getUnpackVector(t){return Bh[t]}get unpackVector(){return Bh[this.encoding]}_idx(t,e){if(t<-1||t>=this.dim+1||e<-1||e>=this.dim+1)throw new RangeError("out of range source coordinates for DEM data");return (e+1)*this.stride+(t+1)}_unpackMapbox(t,e,r){return (256*t*256+256*e+r)/10-1e4}_unpackTerrarium(t,e,r){return 256*t+e+r/256-32768}static pack(t,e){const r=[0,0,0,0],i=Dh.getUnpackVector(e);let n=Math.floor((t+i[3])/i[2]);return r[2]=n%256,n=Math.floor(n/256),r[1]=n%256,n=Math.floor(n/256),r[0]=n,r}getPixels(){return new ko({width:this.stride,height:this.stride},new Uint8Array(this.data.buffer))}backfillBorder(t,e,r){if(this.dim!==t.dim)throw new Error("dem dimension mismatch");let i=e*this.dim,n=e*this.dim+this.dim,s=r*this.dim,a=r*this.dim+this.dim;switch(e){case-1:i=n-1;break;case 1:n=i+1;}switch(r){case-1:s=a-1;break;case 1:a=s+1;}const o=-e*this.dim,l=-r*this.dim;for(let e=s;e<a;e++)for(let r=i;r<n;r++)this.data[this._idx(r,e)]=t.data[this._idx(r+o,e+l)];}onDeserialize(){this._tree&&(this._tree.dem=this);}}Gi("DEMData",Dh),Gi("DemMinMaxQuadTree",zh,{omit:["dem"]});class Ch{constructor(t,e){this.max=t,this.onRemove=e,this.reset();}reset(){for(const t in this.data)for(const e of this.data[t])e.timeout&&clearTimeout(e.timeout),this.onRemove(e.value);return this.data={},this.order=[],this}add(t,e,r){const i=t.wrapped().key;void 0===this.data[i]&&(this.data[i]=[]);const n={value:e,timeout:void 0};if(void 0!==r&&(n.timeout=setTimeout(()=>{this.remove(t,n);},r)),this.data[i].push(n),this.order.push(i),this.order.length>this.max){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}has(t){return t.wrapped().key in this.data}getAndRemove(t){return this.has(t)?this._getAndRemoveByKey(t.wrapped().key):null}_getAndRemoveByKey(t){const e=this.data[t].shift();return e.timeout&&clearTimeout(e.timeout),0===this.data[t].length&&delete this.data[t],this.order.splice(this.order.indexOf(t),1),e.value}getByKey(t){const e=this.data[t];return e?e[0].value:null}get(t){return this.has(t)?this.data[t.wrapped().key][0].value:null}remove(t,e){if(!this.has(t))return this;const r=t.wrapped().key,i=void 0===e?0:this.data[r].indexOf(e),n=this.data[r][i];return this.data[r].splice(i,1),n.timeout&&clearTimeout(n.timeout),0===this.data[r].length&&delete this.data[r],this.onRemove(n.value),this.order.splice(this.order.indexOf(r),1),this}setMaxSize(t){for(this.max=t;this.order.length>this.max;){const t=this._getAndRemoveByKey(this.order[0]);t&&this.onRemove(t);}return this}filter(t){const e=[];for(const r in this.data)for(const i of this.data[r])t(i.value)||e.push(i);for(const t of e)this.remove(t.value.tileID,t);}}class Ph{constructor(t,e,r){this.context=t;const i=t.gl;this.buffer=i.createBuffer(),this.dynamicDraw=Boolean(r),this.context.unbindVAO(),t.bindElementBuffer.set(this.buffer),i.bufferData(i.ELEMENT_ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?i.DYNAMIC_DRAW:i.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindElementBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.context.unbindVAO(),this.bind(),e.bufferSubData(e.ELEMENT_ARRAY_BUFFER,0,t.arrayBuffer);}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}const Vh={Int8:"BYTE",Uint8:"UNSIGNED_BYTE",Int16:"SHORT",Uint16:"UNSIGNED_SHORT",Int32:"INT",Uint32:"UNSIGNED_INT",Float32:"FLOAT"};class Fh{constructor(t,e,r,i){this.length=e.length,this.attributes=r,this.itemSize=e.bytesPerElement,this.dynamicDraw=i,this.context=t;const n=t.gl;this.buffer=n.createBuffer(),t.bindVertexBuffer.set(this.buffer),n.bufferData(n.ARRAY_BUFFER,e.arrayBuffer,this.dynamicDraw?n.DYNAMIC_DRAW:n.STATIC_DRAW),this.dynamicDraw||delete e.arrayBuffer;}bind(){this.context.bindVertexBuffer.set(this.buffer);}updateData(t){const e=this.context.gl;this.bind(),e.bufferSubData(e.ARRAY_BUFFER,0,t.arrayBuffer);}enableAttributes(t,e){for(let r=0;r<this.attributes.length;r++){const i=e.attributes[this.attributes[r].name];void 0!==i&&t.enableVertexAttribArray(i);}}setVertexAttribPointers(t,e,r){for(let i=0;i<this.attributes.length;i++){const n=this.attributes[i],s=e.attributes[n.name];void 0!==s&&t.vertexAttribPointer(s,n.components,t[Vh[n.type]],!1,this.itemSize,n.offset+this.itemSize*(r||0));}}destroy(){this.buffer&&(this.context.gl.deleteBuffer(this.buffer),delete this.buffer);}}class Rh{constructor(t){this.gl=t.gl,this.default=this.getDefault(),this.current=this.default,this.dirty=!1;}get(){return this.current}set(t){}getDefault(){return this.default}setDefault(){this.set(this.default);}}class Lh extends Rh{getDefault(){return le.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.clearColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class Uh extends Rh{getDefault(){return 1}set(t){(t!==this.current||this.dirty)&&(this.gl.clearDepth(t),this.current=t,this.dirty=!1);}}class Oh extends Rh{getDefault(){return 0}set(t){(t!==this.current||this.dirty)&&(this.gl.clearStencil(t),this.current=t,this.dirty=!1);}}class $h extends Rh{getDefault(){return [!0,!0,!0,!0]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.colorMask(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class qh extends Rh{getDefault(){return !0}set(t){(t!==this.current||this.dirty)&&(this.gl.depthMask(t),this.current=t,this.dirty=!1);}}class Nh extends Rh{getDefault(){return 255}set(t){(t!==this.current||this.dirty)&&(this.gl.stencilMask(t),this.current=t,this.dirty=!1);}}class jh extends Rh{getDefault(){return {func:this.gl.ALWAYS,ref:0,mask:255}}set(t){const e=this.current;(t.func!==e.func||t.ref!==e.ref||t.mask!==e.mask||this.dirty)&&(this.gl.stencilFunc(t.func,t.ref,t.mask),this.current=t,this.dirty=!1);}}class Gh extends Rh{getDefault(){const t=this.gl;return [t.KEEP,t.KEEP,t.KEEP]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||this.dirty)&&(this.gl.stencilOp(t[0],t[1],t[2]),this.current=t,this.dirty=!1);}}class Zh extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.STENCIL_TEST):e.disable(e.STENCIL_TEST),this.current=t,this.dirty=!1;}}class Xh extends Rh{getDefault(){return [0,1]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.depthRange(t[0],t[1]),this.current=t,this.dirty=!1);}}class Kh extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.DEPTH_TEST):e.disable(e.DEPTH_TEST),this.current=t,this.dirty=!1;}}class Hh extends Rh{getDefault(){return this.gl.LESS}set(t){(t!==this.current||this.dirty)&&(this.gl.depthFunc(t),this.current=t,this.dirty=!1);}}class Yh extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.BLEND):e.disable(e.BLEND),this.current=t,this.dirty=!1;}}class Wh extends Rh{getDefault(){const t=this.gl;return [t.ONE,t.ZERO]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||this.dirty)&&(this.gl.blendFunc(t[0],t[1]),this.current=t,this.dirty=!1);}}class Jh extends Rh{getDefault(){return le.transparent}set(t){const e=this.current;(t.r!==e.r||t.g!==e.g||t.b!==e.b||t.a!==e.a||this.dirty)&&(this.gl.blendColor(t.r,t.g,t.b,t.a),this.current=t,this.dirty=!1);}}class Qh extends Rh{getDefault(){return this.gl.FUNC_ADD}set(t){(t!==this.current||this.dirty)&&(this.gl.blendEquation(t),this.current=t,this.dirty=!1);}}class tp extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;t?e.enable(e.CULL_FACE):e.disable(e.CULL_FACE),this.current=t,this.dirty=!1;}}class ep extends Rh{getDefault(){return this.gl.BACK}set(t){(t!==this.current||this.dirty)&&(this.gl.cullFace(t),this.current=t,this.dirty=!1);}}class rp extends Rh{getDefault(){return this.gl.CCW}set(t){(t!==this.current||this.dirty)&&(this.gl.frontFace(t),this.current=t,this.dirty=!1);}}class ip extends Rh{getDefault(){return null}set(t){(t!==this.current||this.dirty)&&(this.gl.useProgram(t),this.current=t,this.dirty=!1);}}class np extends Rh{getDefault(){return this.gl.TEXTURE0}set(t){(t!==this.current||this.dirty)&&(this.gl.activeTexture(t),this.current=t,this.dirty=!1);}}class sp extends Rh{getDefault(){const t=this.gl;return [0,0,t.drawingBufferWidth,t.drawingBufferHeight]}set(t){const e=this.current;(t[0]!==e[0]||t[1]!==e[1]||t[2]!==e[2]||t[3]!==e[3]||this.dirty)&&(this.gl.viewport(t[0],t[1],t[2],t[3]),this.current=t,this.dirty=!1);}}class ap extends Rh{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindFramebuffer(e.FRAMEBUFFER,t),this.current=t,this.dirty=!1;}}class op extends Rh{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindRenderbuffer(e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class lp extends Rh{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindTexture(e.TEXTURE_2D,t),this.current=t,this.dirty=!1;}}class up extends Rh{getDefault(){return null}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.bindBuffer(e.ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class cp extends Rh{getDefault(){return null}set(t){const e=this.gl;e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,t),this.current=t,this.dirty=!1;}}class hp extends Rh{constructor(t){super(t),this.vao=t.extVertexArrayObject;}getDefault(){return null}set(t){this.vao&&(t!==this.current||this.dirty)&&(this.vao.bindVertexArrayOES(t),this.current=t,this.dirty=!1);}}class pp extends Rh{getDefault(){return 4}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_ALIGNMENT,t),this.current=t,this.dirty=!1;}}class dp extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_PREMULTIPLY_ALPHA_WEBGL,t),this.current=t,this.dirty=!1;}}class fp extends Rh{getDefault(){return !1}set(t){if(t===this.current&&!this.dirty)return;const e=this.gl;e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,t),this.current=t,this.dirty=!1;}}class yp extends Rh{constructor(t,e){super(t),this.context=t,this.parent=e;}getDefault(){return null}}class mp extends yp{setDirty(){this.dirty=!0;}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0),this.current=t,this.dirty=!1;}}class gp extends yp{attachment(){return this.gl.DEPTH_ATTACHMENT}set(t){if(t===this.current&&!this.dirty)return;this.context.bindFramebuffer.set(this.parent);const e=this.gl;e.framebufferRenderbuffer(e.FRAMEBUFFER,this.attachment(),e.RENDERBUFFER,t),this.current=t,this.dirty=!1;}}class xp{constructor(t,e,r,i){this.context=t,this.width=e,this.height=r;const n=this.framebuffer=t.gl.createFramebuffer();this.colorAttachment=new mp(t,n),i&&(this.depthAttachment=new gp(t,n));}destroy(){const t=this.context.gl,e=this.colorAttachment.get();if(e&&t.deleteTexture(e),this.depthAttachment){const e=this.depthAttachment.get();e&&t.deleteRenderbuffer(e);}t.deleteFramebuffer(this.framebuffer);}}class vp{constructor(t,e,r){this.func=t,this.mask=e,this.range=r;}}vp.ReadOnly=!1,vp.ReadWrite=!0,vp.disabled=new vp(519,vp.ReadOnly,[0,1]);class bp{constructor(t,e,r,i,n,s){this.test=t,this.ref=e,this.mask=r,this.fail=i,this.depthFail=n,this.pass=s;}}bp.disabled=new bp({func:519,mask:0},0,0,7680,7680,7680);class wp{constructor(t,e,r){this.blendFunction=t,this.blendColor=e,this.mask=r;}}wp.Replace=[1,0],wp.disabled=new wp(wp.Replace,le.transparent,[!1,!1,!1,!1]),wp.unblended=new wp(wp.Replace,le.transparent,[!0,!0,!0,!0]),wp.alphaBlended=new wp([1,771],le.transparent,[!0,!0,!0,!0]);class _p{constructor(t,e,r){this.enable=t,this.mode=e,this.frontFace=r;}}_p.disabled=new _p(!1,1029,2305),_p.backCCW=new _p(!0,1029,2305),_p.backCW=new _p(!0,1029,2304),_p.frontCW=new _p(!0,1028,2304),_p.frontCCW=new _p(!0,1028,2305);class kp extends Vt{constructor(t,e,r){super(),this.id=t,this._onlySymbols=r,e.on("data",t=>{"source"===t.dataType&&"metadata"===t.sourceDataType&&(this._sourceLoaded=!0),this._sourceLoaded&&!this._paused&&"source"===t.dataType&&"content"===t.sourceDataType&&(this.reload(),this.transform&&this.update(this.transform));}),e.on("error",()=>{this._sourceErrored=!0;}),this._source=e,this._tiles={},this._cache=new Ch(0,this._unloadTile.bind(this)),this._timers={},this._cacheTimers={},this._maxTileCacheSize=null,this._loadedParentTiles={},this._coveredTiles={},this._state=new _h;}onAdd(t){this.map=t,this._maxTileCacheSize=t?t._maxTileCacheSize:null;}loaded(){if(this._sourceErrored)return !0;if(!this._sourceLoaded)return !1;if(!this._source.loaded())return !1;for(const t in this._tiles){const e=this._tiles[t];if("loaded"!==e.state&&"errored"!==e.state)return !1}return !0}getSource(){return this._source}pause(){this._paused=!0;}resume(){if(!this._paused)return;const t=this._shouldReloadOnResume;this._paused=!1,this._shouldReloadOnResume=!1,t&&this.reload(),this.transform&&this.update(this.transform);}_loadTile(t,e){return t.isSymbolTile=this._onlySymbols,this._source.loadTile(t,e)}_unloadTile(t){if(this._source.unloadTile)return this._source.unloadTile(t,()=>{})}_abortTile(t){if(this._source.abortTile)return this._source.abortTile(t,()=>{})}serialize(){return this._source.serialize()}prepare(t){this._source.prepare&&this._source.prepare(),this._state.coalesceChanges(this._tiles,this.map?this.map.painter:null);for(const e in this._tiles){const r=this._tiles[e];r.upload(t),r.prepare(this.map.style.imageManager);}}getIds(){return g(this._tiles).map(t=>t.tileID).sort(Ap).map(t=>t.key)}getRenderableIds(t){const e=[];for(const r in this._tiles)this._isIdRenderable(+r,t)&&e.push(this._tiles[r]);return t?e.sort((t,e)=>{const r=t.tileID,n=e.tileID,s=new i(r.canonical.x,r.canonical.y)._rotate(this.transform.angle),a=new i(n.canonical.x,n.canonical.y)._rotate(this.transform.angle);return r.overscaledZ-n.overscaledZ||a.y-s.y||a.x-s.x}).map(t=>t.tileID.key):e.map(t=>t.tileID).sort(Ap).map(t=>t.key)}hasRenderableParent(t){const e=this.findLoadedParent(t,0);return !!e&&this._isIdRenderable(e.tileID.key)}_isIdRenderable(t,e){return this._tiles[t]&&this._tiles[t].hasData()&&!this._coveredTiles[t]&&(e||!this._tiles[t].holdingForFade())}reload(){if(this._paused)this._shouldReloadOnResume=!0;else {this._cache.reset();for(const t in this._tiles)"errored"!==this._tiles[t].state&&this._reloadTile(+t,"reloading");}}_reloadTile(t,e){const r=this._tiles[t];r&&("loading"!==r.state&&(r.state=e),this._loadTile(r,this._tileLoaded.bind(this,r,t,e)));}_tileLoaded(t,e,r,i){if(i)return t.state="errored",void(404!==i.status?this._source.fire(new Pt(i,{tile:t})):this.update(this.transform));t.timeAdded=$.now(),"expired"===r&&(t.refreshedUponExpiration=!0),this._setTileReloadTimer(e,t),"raster-dem"===this.getSource().type&&t.dem&&this._backfillDEM(t),this._state.initializeTileState(t,this.map?this.map.painter:null),this._source.fire(new Ct("data",{dataType:"source",tile:t,coord:t.tileID,sourceCacheId:this.id}));}_backfillDEM(t){const e=this.getRenderableIds();for(let i=0;i<e.length;i++){const n=e[i];if(t.neighboringTiles&&t.neighboringTiles[n]){const e=this.getTileByID(n);r(t,e),r(e,t);}}function r(t,e){if(!t.dem||t.dem.borderReady)return;t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0;let r=e.tileID.canonical.x-t.tileID.canonical.x;const i=e.tileID.canonical.y-t.tileID.canonical.y,n=Math.pow(2,t.tileID.canonical.z),s=e.tileID.key;0===r&&0===i||Math.abs(i)>1||(Math.abs(r)>1&&(1===Math.abs(r+n)?r+=n:1===Math.abs(r-n)&&(r-=n)),e.dem&&t.dem&&(t.dem.backfillBorder(e.dem,r,i),t.neighboringTiles&&t.neighboringTiles[s]&&(t.neighboringTiles[s].backfilled=!0)));}}getTile(t){return this.getTileByID(t.key)}getTileByID(t){return this._tiles[t]}_retainLoadedChildren(t,e,r,i){for(const n in this._tiles){let s=this._tiles[n];if(i[n]||!s.hasData()||s.tileID.overscaledZ<=e||s.tileID.overscaledZ>r)continue;let a=s.tileID;for(;s&&s.tileID.overscaledZ>e+1;){const t=s.tileID.scaledTo(s.tileID.overscaledZ-1);s=this._tiles[t.key],s&&s.hasData()&&(a=t);}let o=a;for(;o.overscaledZ>e;)if(o=o.scaledTo(o.overscaledZ-1),t[o.key]){i[a.key]=a;break}}}findLoadedParent(t,e){if(t.key in this._loadedParentTiles){const r=this._loadedParentTiles[t.key];return r&&r.tileID.overscaledZ>=e?r:null}for(let r=t.overscaledZ-1;r>=e;r--){const e=t.scaledTo(r),i=this._getLoadedTile(e);if(i)return i}}_getLoadedTile(t){const e=this._tiles[t.key];return e&&e.hasData()?e:this._cache.getByKey(this._source.reparseOverscaled?t.wrapped().key:t.canonical.key)}updateCacheSize(t,e){e=e||this._source.tileSize;const r=Math.ceil(t.width/e)+1,i=Math.ceil(t.height/e)+1,n=Math.floor(r*i*5),s="number"==typeof this._maxTileCacheSize?Math.min(this._maxTileCacheSize,n):n;this._cache.setMaxSize(s);}handleWrapJump(t){const e=Math.round((t-(void 0===this._prevLng?t:this._prevLng))/360);if(this._prevLng=t,e){const t={};for(const r in this._tiles){const i=this._tiles[r];i.tileID=i.tileID.unwrapTo(i.tileID.wrap+e),t[i.tileID.key]=i;}this._tiles=t;for(const t in this._timers)clearTimeout(this._timers[t]),delete this._timers[t];for(const t in this._tiles)this._setTileReloadTimer(+t,this._tiles[t]);}}update(t,e,r){if(this.transform=t,!this._sourceLoaded||this._paused||this.transform.freezeTileCoverage)return;if(this.usedForTerrain&&!r)return;let i;this.updateCacheSize(t,e),this.handleWrapJump(this.transform.center.lng),this._coveredTiles={},this.used||this.usedForTerrain?this._source.tileID?i=t.getVisibleUnwrappedCoordinates(this._source.tileID).map(t=>new mh(t.canonical.z,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y)):(i=t.coveringTiles({tileSize:e||this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom&&!r,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!!this.transform.elevation&&!this.usedForTerrain}),this._source.hasTile&&(i=i.filter(t=>this._source.hasTile(t)))):i=[];const n=this._updateRetainedTiles(i);if(Sp(this._source.type)&&0!==i.length){const t={},e={},r=Object.keys(n);for(const i of r){const r=n[i],s=this._tiles[i];if(!s||s.fadeEndTime&&s.fadeEndTime<=$.now())continue;const a=this.findLoadedParent(r,Math.max(r.overscaledZ-kp.maxOverzooming,this._source.minzoom));a&&(this._addTile(a.tileID),t[a.tileID.key]=a.tileID),e[i]=r;}const s=i[i.length-1].overscaledZ;for(const t in this._tiles){const r=this._tiles[t];if(n[t]||!r.hasData())continue;let i=r.tileID;for(;i.overscaledZ>s;){i=i.scaledTo(i.overscaledZ-1);const s=this._tiles[i.key];if(s&&s.hasData()&&e[i.key]){n[t]=r.tileID;break}}}for(const e in t)n[e]||(this._coveredTiles[e]=!0,n[e]=t[e]);}for(const t in n)this._tiles[t].clearFadeHold();const s=function(t,e){const r=[];for(const i in t)i in e||r.push(i);return r}(this._tiles,n);for(const t of s){const e=this._tiles[t];e.hasSymbolBuckets&&!e.holdingForFade()?e.setHoldDuration(this.map._fadeDuration):e.hasSymbolBuckets&&!e.symbolFadeFinished()||this._removeTile(+t);}this._updateLoadedParentTileCache(),this._onlySymbols&&this._source.afterUpdate&&this._source.afterUpdate();}releaseSymbolFadeTiles(){for(const t in this._tiles)this._tiles[t].holdingForFade()&&this._removeTile(+t);}_updateRetainedTiles(t){const e={};if(0===t.length)return e;const r={},i=t[t.length-1].overscaledZ,n=t[0].overscaledZ,s=Math.max(n-kp.maxOverzooming,this._source.minzoom),a=Math.max(n+kp.maxUnderzooming,this._source.minzoom),o={};for(const r of t){const t=this._addTile(r);e[r.key]=r,t.hasData()||i<this._source.maxzoom&&(o[r.key]=r);}this._retainLoadedChildren(o,i,a,e);for(const i of t){let t=this._tiles[i.key];if(t.hasData())continue;if(i.canonical.z>=this._source.maxzoom){const t=i.children(this._source.maxzoom)[0],r=this.getTile(t);if(r&&r.hasData()){e[t.key]=t;continue}}else {const t=i.children(this._source.maxzoom);if(e[t[0].key]&&e[t[1].key]&&e[t[2].key]&&e[t[3].key])continue}let n=t.wasRequested();for(let a=i.overscaledZ-1;a>=s;--a){const s=i.scaledTo(a);if(r[s.key])break;if(r[s.key]=!0,t=this.getTile(s),!t&&n&&(t=this._addTile(s)),t&&(e[s.key]=s,n=t.wasRequested(),t.hasData()))break}}return e}_updateLoadedParentTileCache(){this._loadedParentTiles={};for(const t in this._tiles){const e=[];let r,i=this._tiles[t].tileID;for(;i.overscaledZ>0;){if(i.key in this._loadedParentTiles){r=this._loadedParentTiles[i.key];break}e.push(i.key);const t=i.scaledTo(i.overscaledZ-1);if(r=this._getLoadedTile(t),r)break;i=t;}for(const t of e)this._loadedParentTiles[t]=r;}}_addTile(t){let e=this._tiles[t.key];if(e)return e;e=this._cache.getAndRemove(t),e&&(this._setTileReloadTimer(t.key,e),e.tileID=t,this._state.initializeTileState(e,this.map?this.map.painter:null),this._cacheTimers[t.key]&&(clearTimeout(this._cacheTimers[t.key]),delete this._cacheTimers[t.key],this._setTileReloadTimer(t.key,e)));const r=Boolean(e);return r||(e=new wh(t,this._source.tileSize*t.overscaleFactor(),this.transform.tileZoom),this._loadTile(e,this._tileLoaded.bind(this,e,t.key,e.state))),e?(e.uses++,this._tiles[t.key]=e,r||this._source.fire(new Ct("dataloading",{tile:e,coord:e.tileID,dataType:"source"})),e):null}_setTileReloadTimer(t,e){t in this._timers&&(clearTimeout(this._timers[t]),delete this._timers[t]);const r=e.getExpiryTimeout();r&&(this._timers[t]=setTimeout(()=>{this._reloadTile(t,"expired"),delete this._timers[t];},r));}_removeTile(t){const e=this._tiles[t];e&&(e.uses--,delete this._tiles[t],this._timers[t]&&(clearTimeout(this._timers[t]),delete this._timers[t]),e.uses>0||(e.hasData()&&"reloading"!==e.state?this._cache.add(e.tileID,e,e.getExpiryTimeout()):(e.aborted=!0,this._abortTile(e),this._unloadTile(e))));}clearTiles(){this._shouldReloadOnResume=!1,this._paused=!1;for(const t in this._tiles)this._removeTile(+t);this._cache.reset();}tilesIn(t,e,r){const i=[],n=this.transform;if(!n)return i;for(const s in this._tiles){const a=this._tiles[s];if(r&&a.clearQueryDebugViz(),a.holdingForFade())continue;const o=t.containsTile(a,n,e);o&&i.push(o);}return i}getVisibleCoordinates(t){const e=this.getRenderableIds(t).map(t=>this._tiles[t].tileID);for(const t of e)t.posMatrix=this.transform.calculatePosMatrix(t.toUnwrapped());return e}hasTransition(){if(this._source.hasTransition())return !0;if(Sp(this._source.type))for(const t in this._tiles){const e=this._tiles[t];if(void 0!==e.fadeEndTime&&e.fadeEndTime>=$.now())return !0}return !1}setFeatureState(t,e,r){this._state.updateState(t=t||"_geojsonTileLayer",e,r);}removeFeatureState(t,e,r){this._state.removeFeatureState(t=t||"_geojsonTileLayer",e,r);}getFeatureState(t,e){return this._state.getState(t=t||"_geojsonTileLayer",e)}setDependencies(t,e,r){const i=this._tiles[t];i&&i.setDependencies(e,r);}reloadTilesForDependencies(t,e){for(const r in this._tiles)this._tiles[r].hasDependency(t,e)&&this._reloadTile(+r,"reloading");this._cache.filter(r=>!r.hasDependency(t,e));}}function Ap(t,e){const r=Math.abs(2*t.wrap)-+(t.wrap<0),i=Math.abs(2*e.wrap)-+(e.wrap<0);return t.overscaledZ-e.overscaledZ||i-r||e.canonical.y-t.canonical.y||e.canonical.x-t.canonical.x}function Sp(t){return "raster"===t||"image"===t||"video"===t}kp.maxOverzooming=10,kp.maxUnderzooming=3;class Ip{constructor(t,e,r){this._demTile=t,this._dem=this._demTile.dem,this._scale=e,this._offset=r;}static create(t,e,r){const i=r||t.findDEMTileFor(e);if(!i||!i.dem)return;const n=i.dem,s=i.tileID,a=1<<e.canonical.z-s.canonical.z;return new Ip(i,i.tileSize/8192/a,[(e.canonical.x/a-s.canonical.x)*n.dim,(e.canonical.y/a-s.canonical.y)*n.dim])}tileCoordToPixel(t,e){const r=e*this._scale+this._offset[1],n=Math.floor(t*this._scale+this._offset[0]),s=Math.floor(r);return new i(n,s)}getElevationAt(t,e,r,i){const n=t*this._scale+this._offset[0],s=e*this._scale+this._offset[1],a=Math.floor(n),o=Math.floor(s),l=this._dem;return i=!!i,r?Je(Je(l.get(a,o,i),l.get(a,o+1,i),s-o),Je(l.get(a+1,o,i),l.get(a+1,o+1,i),s-o),n-a):l.get(a,o,i)}getElevationAtPixel(t,e,r){return this._dem.get(t,e,!!r)}getMeterToDEM(t){return (1<<this._demTile.tileID.canonical.z)*uh(1,t)*this._dem.stride}}class Tp{constructor(t,e){this.tileID=t,this.x=t.canonical.x,this.y=t.canonical.y,this.z=t.canonical.z,this.grid=new Oi(8192,16,0),this.featureIndexArray=new Us,this.promoteId=e;}insert(t,e,r,i,n,s=0){const a=this.featureIndexArray.length;this.featureIndexArray.emplaceBack(r,i,n,s);const o=this.grid;for(let t=0;t<e.length;t++){const r=e[t],i=[1/0,1/0,-1/0,-1/0];for(let t=0;t<r.length;t++){const e=r[t];i[0]=Math.min(i[0],e.x),i[1]=Math.min(i[1],e.y),i[2]=Math.max(i[2],e.x),i[3]=Math.max(i[3],e.y);}i[0]<8192&&i[1]<8192&&i[2]>=0&&i[3]>=0&&o.insert(a,i[0],i[1],i[2],i[3]);}}loadVTLayers(){return this.vtLayers||(this.vtLayers=new Al.VectorTile(new ou(this.rawTileData)).layers,this.sourceLayerCoder=new xh(this.vtLayers?Object.keys(this.vtLayers).sort():["_geojsonTileLayer"])),this.vtLayers}query(t,e,r,i){this.loadVTLayers();const n=t.params||{},s=pi(n.filter),a=t.tileResult,o=t.transform,l=a.bufferedTilespaceBounds,u=this.grid.query(l.min.x,l.min.y,l.max.x,l.max.y,(t,e,r,i)=>Da(a.bufferedTilespaceGeometry,t,e,r,i));u.sort(Ep);let c=null;o.elevation&&u.length>0&&(c=Ip.create(o.elevation,this.tileID));const h={};let p;for(let o=0;o<u.length;o++){const l=u[o];if(l===p)continue;p=l;const d=this.featureIndexArray.get(l);let f=null;this.loadMatchingFeature(h,d,s,n.layers,n.availableImages,e,r,i,(e,r,i,n=0)=>(f||(f=xa(e)),r.queryIntersectsFeature(a,e,i,f,this.z,t.transform,t.pixelPosMatrix,c,n)));}return h}loadMatchingFeature(t,e,r,i,n,s,a,o,l){const{featureIndex:u,bucketIndex:c,sourceLayerIndex:h,layoutVertexArrayOffset:p}=e,d=this.bucketLayerIDs[c];if(i&&!function(t,e){for(let r=0;r<t.length;r++)if(e.indexOf(t[r])>=0)return !0;return !1}(i,d))return;const f=this.sourceLayerCoder.decode(h),y=this.vtLayers[f].feature(u);if(r.needGeometry){const t=va(y,!0);if(!r.filter(new qn(this.tileID.overscaledZ),t,this.tileID.canonical))return}else if(!r.filter(new qn(this.tileID.overscaledZ),y))return;const m=this.getId(y,f);for(let e=0;e<d.length;e++){const r=d[e];if(i&&i.indexOf(r)<0)continue;const c=s[r];if(!c)continue;let h={};void 0!==m&&o&&(h=o.getState(c.sourceLayer||"_geojsonTileLayer",m));const f=x({},a[r]);f.paint=zp(f.paint,c.paint,y,h,n),f.layout=zp(f.layout,c.layout,y,h,n);const g=!l||l(y,c,h,p);if(!g)continue;const v=new vh(y,this.z,this.x,this.y,m);v.layer=f;let b=t[r];void 0===b&&(b=t[r]=[]),b.push({featureIndex:u,feature:v,intersectionZ:g});}}lookupSymbolFeatures(t,e,r,i,n,s,a,o){const l={};this.loadVTLayers();const u=pi(n);for(const n of t)this.loadMatchingFeature(l,{bucketIndex:r,sourceLayerIndex:i,featureIndex:n,layoutVertexArrayOffset:0},u,s,a,o,e);return l}hasLayer(t){for(const e of this.bucketLayerIDs)for(const r of e)if(t===r)return !0;return !1}getId(t,e){let r=t.id;return this.promoteId&&(r=t.properties["string"==typeof this.promoteId?this.promoteId:this.promoteId[e]],"boolean"==typeof r&&(r=Number(r))),r}}function zp(t,e,r,i,n){return S(t,(t,s)=>{const a=e instanceof Yn?e.get(s):null;return a&&a.evaluate?a.evaluate(r,i,n):a})}function Ep(t,e){return e-t}Gi("FeatureIndex",Tp,{omit:["rawTileData","sourceLayerCoder"]});class Mp{constructor(t){const e={},r=[];for(const i in t){const n=t[i],s=e[i]={};for(const t in n){const e=n[+t];if(!e||0===e.bitmap.width||0===e.bitmap.height)continue;const i=e.metrics.localGlyph?2:1,a={x:0,y:0,w:e.bitmap.width+2*i,h:e.bitmap.height+2*i};r.push(a),s[t]={rect:a,metrics:e.metrics};}}const{w:i,h:n}=zu(r),s=new _o({width:i||1,height:n||1});for(const r in t){const i=t[r];for(const t in i){const n=i[+t];if(!n||0===n.bitmap.width||0===n.bitmap.height)continue;const a=e[r][t].rect,o=n.metrics.localGlyph?2:1;_o.copy(n.bitmap,s,{x:0,y:0},{x:a.x+o,y:a.y+o},n.bitmap);}}this.image=s,this.positions=e;}}Gi("GlyphAtlas",Mp);class Bp{constructor(t){this.tileID=new mh(t.tileID.overscaledZ,t.tileID.wrap,t.tileID.canonical.z,t.tileID.canonical.x,t.tileID.canonical.y),this.tileZoom=t.tileZoom,this.uid=t.uid,this.zoom=t.zoom,this.pixelRatio=t.pixelRatio,this.tileSize=t.tileSize,this.source=t.source,this.overscaling=this.tileID.overscaleFactor(),this.showCollisionBoxes=t.showCollisionBoxes,this.collectResourceTiming=!!t.collectResourceTiming,this.returnDependencies=!!t.returnDependencies,this.promoteId=t.promoteId,this.enableTerrain=!!t.enableTerrain,this.isSymbolTile=t.isSymbolTile;}parse(t,e,r,i,n){this.status="parsing",this.data=t,this.collisionBoxArray=new Bs;const s=new xh(Object.keys(t.layers).sort()),a=new Tp(this.tileID,this.promoteId);a.bucketLayerIDs=[];const o={},l={featureIndex:a,iconDependencies:{},patternDependencies:{},glyphDependencies:{},availableImages:r},u=e.familiesBySource[this.source];for(const e in u){const i=t.layers[e];if(!i)continue;let n=!1,c=!1;for(const t of u[e])"symbol"===t[0].type?n=!0:c=!0;if(!0===this.isSymbolTile&&!n)continue;if(!1===this.isSymbolTile&&!c)continue;1===i.version&&E(`Vector tile source "${this.source}" layer "${e}" `+"does not use vector tile spec v2 and therefore may have some rendering errors.");const h=s.encode(e),p=[];for(let t=0;t<i.length;t++){const r=i.feature(t),n=a.getId(r,e);p.push({feature:r,id:n,index:t,sourceLayerIndex:h});}for(const t of u[e]){const e=t[0];void 0!==this.isSymbolTile&&"symbol"===e.type!==this.isSymbolTile||e.minzoom&&this.zoom<Math.floor(e.minzoom)||e.maxzoom&&this.zoom>=e.maxzoom||"none"!==e.visibility&&(Dp(t,this.zoom,r),(o[e.id]=e.createBucket({index:a.bucketLayerIDs.length,layers:t,zoom:this.zoom,pixelRatio:this.pixelRatio,overscaling:this.overscaling,collisionBoxArray:this.collisionBoxArray,sourceLayerIndex:h,sourceID:this.source,enableTerrain:this.enableTerrain})).populate(p,l,this.tileID.canonical),a.bucketLayerIDs.push(t.map(t=>t.id)));}}let c,h,p,d;const f={type:"maybePrepare",isSymbolTile:this.isSymbolTile,zoom:this.zoom},y=S(l.glyphDependencies,t=>Object.keys(t).map(Number));Object.keys(y).length?i.send("getGlyphs",{uid:this.uid,stacks:y},(t,e)=>{c||(c=t,h=e,v.call(this));},void 0,void 0,f):h={};const m=Object.keys(l.iconDependencies);m.length?i.send("getImages",{icons:m,source:this.source,tileID:this.tileID,type:"icons"},(t,e)=>{c||(c=t,p=e,v.call(this));},void 0,void 0,f):p={};const x=Object.keys(l.patternDependencies);function v(){if(c)return n(c);if(h&&p&&d){const t=new Mp(h),e=new Mu(p,d);for(const i in o){const n=o[i];n instanceof Vc?(Dp(n.layers,this.zoom,r),bc(n,h,t.positions,p,e.iconPositions,this.showCollisionBoxes,this.tileID.canonical,this.tileZoom)):n.hasPattern&&(n instanceof ql||n instanceof cl||n instanceof El)&&(Dp(n.layers,this.zoom,r),n.addFeatures(l,this.tileID.canonical,e.patternPositions));}this.status="done",n(null,{buckets:g(o).filter(t=>!t.isEmpty()),featureIndex:a,collisionBoxArray:this.collisionBoxArray,glyphAtlasImage:t.image,imageAtlas:e,glyphMap:this.returnDependencies?h:null,iconMap:this.returnDependencies?p:null,glyphPositions:this.returnDependencies?t.positions:null});}}x.length?i.send("getImages",{icons:x,source:this.source,tileID:this.tileID,type:"patterns"},(t,e)=>{c||(c=t,d=e,v.call(this));},void 0,void 0,f):d={},v.call(this);}}function Dp(t,e,r){const i=new qn(e);for(const e of t)e.recalculate(i,r);}class Cp{constructor(t){this.entries={},this.scheduler=t;}request(t,e,r,i){const n=this.entries[t]=this.entries[t]||{callbacks:[]};if(n.result){const[t,r]=n.result;return this.scheduler?this.scheduler.add(()=>{i(t,r);},e):i(t,r),()=>{}}return n.callbacks.push(i),n.cancel||(n.cancel=r((r,i)=>{n.result=[r,i];for(const t of n.callbacks)this.scheduler?this.scheduler.add(()=>{t(r,i);},e):t(r,i);setTimeout(()=>delete this.entries[t],3e3);})),()=>{n.result||(n.callbacks=n.callbacks.filter(t=>t!==i),n.callbacks.length||(n.cancel(),delete this.entries[t]));}}}function Pp(t,e,r){const i=JSON.stringify(t.request);return t.data&&(this.deduped.entries[i]={result:[null,t.data]}),this.deduped.request(i,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom},e=>{const i=kt(t.request,(t,i,n,s)=>{t?e(t):i&&e(null,{vectorTile:r?void 0:new Al.VectorTile(new ou(i)),rawData:i,cacheControl:n,expires:s});});return ()=>{i.cancel(),e();}},e)}t.AUTH_ERR_MSG="NO_ACCESS_TOKEN",t.Aabb=po,t.Actor=class{constructor(t,e,r){this.target=t,this.parent=e,this.mapId=r,this.callbacks={},this.cancelCallbacks={},k(["receive"],this),this.target.addEventListener("message",this.receive,!1),this.globalScope=D()?t:s,this.scheduler=new eh;}send(t,e,r,i,n=!1,s){const a=Math.round(1e18*Math.random()).toString(36).substring(0,10);r&&(r.metadata=s,this.callbacks[a]=r);const o=R(this.globalScope)?void 0:[];return this.target.postMessage({id:a,type:t,hasCallback:!!r,targetMapId:i,mustQueue:n,sourceMapId:this.mapId,data:Ki(e,o)},o),{cancel:()=>{r&&delete this.callbacks[a],this.target.postMessage({id:a,type:"<cancel>",targetMapId:i,sourceMapId:this.mapId});}}}receive(t){const e=t.data,r=e.id;if(r&&(!e.targetMapId||this.mapId===e.targetMapId))if("<cancel>"===e.type){const t=this.cancelCallbacks[r];delete this.cancelCallbacks[r],t&&t.cancel();}else if(D()||e.mustQueue){const t=this.callbacks[r];this.cancelCallbacks[r]=this.scheduler.add(()=>this.processTask(r,e),t&&t.metadata||{type:"message"});}else this.processTask(r,e);}processTask(t,e){if("<response>"===e.type){const r=this.callbacks[t];delete this.callbacks[t],r&&(e.error?r(Hi(e.error)):r(null,Hi(e.data)));}else {const r=R(this.globalScope)?void 0:[],i=e.hasCallback?(e,i)=>{delete this.cancelCallbacks[t],this.target.postMessage({id:t,type:"<response>",sourceMapId:this.mapId,error:e?Ki(e):null,data:Ki(i,r)},r);}:t=>{},n=Hi(e.data);if(this.parent[e.type])this.parent[e.type](e.sourceMapId,n,i);else if(this.parent.getWorkerSource){const t=e.type.split(".");this.parent.getWorkerSource(e.sourceMapId,t[0],n.source)[t[1]](n,i);}else i(new Error(`Could not find function ${e.type}`));}}remove(){this.scheduler.remove(),this.target.removeEventListener("message",this.receive,!1);}},t.CanonicalTileID=fh,t.Color=le,t.ColorMode=wp,t.Context=class{constructor(t){this.gl=t,this.extVertexArrayObject=this.gl.getExtension("OES_vertex_array_object"),this.clearColor=new Lh(this),this.clearDepth=new Uh(this),this.clearStencil=new Oh(this),this.colorMask=new $h(this),this.depthMask=new qh(this),this.stencilMask=new Nh(this),this.stencilFunc=new jh(this),this.stencilOp=new Gh(this),this.stencilTest=new Zh(this),this.depthRange=new Xh(this),this.depthTest=new Kh(this),this.depthFunc=new Hh(this),this.blend=new Yh(this),this.blendFunc=new Wh(this),this.blendColor=new Jh(this),this.blendEquation=new Qh(this),this.cullFace=new tp(this),this.cullFaceSide=new ep(this),this.frontFace=new rp(this),this.program=new ip(this),this.activeTexture=new np(this),this.viewport=new sp(this),this.bindFramebuffer=new ap(this),this.bindRenderbuffer=new op(this),this.bindTexture=new lp(this),this.bindVertexBuffer=new up(this),this.bindElementBuffer=new cp(this),this.bindVertexArrayOES=this.extVertexArrayObject&&new hp(this),this.pixelStoreUnpack=new pp(this),this.pixelStoreUnpackPremultiplyAlpha=new dp(this),this.pixelStoreUnpackFlipY=new fp(this),this.extTextureFilterAnisotropic=t.getExtension("EXT_texture_filter_anisotropic")||t.getExtension("MOZ_EXT_texture_filter_anisotropic")||t.getExtension("WEBKIT_EXT_texture_filter_anisotropic"),this.extTextureFilterAnisotropic&&(this.extTextureFilterAnisotropicMax=t.getParameter(this.extTextureFilterAnisotropic.MAX_TEXTURE_MAX_ANISOTROPY_EXT)),this.extTextureFilterAnisotropicForceOff=!1,this.extTextureHalfFloat=t.getExtension("OES_texture_half_float"),this.extTextureHalfFloat&&(t.getExtension("OES_texture_half_float_linear"),this.extRenderToTextureHalfFloat=t.getExtension("EXT_color_buffer_half_float")),this.extTimerQuery=t.getExtension("EXT_disjoint_timer_query"),this.maxTextureSize=t.getParameter(t.MAX_TEXTURE_SIZE);}setDefault(){this.unbindVAO(),this.clearColor.setDefault(),this.clearDepth.setDefault(),this.clearStencil.setDefault(),this.colorMask.setDefault(),this.depthMask.setDefault(),this.stencilMask.setDefault(),this.stencilFunc.setDefault(),this.stencilOp.setDefault(),this.stencilTest.setDefault(),this.depthRange.setDefault(),this.depthTest.setDefault(),this.depthFunc.setDefault(),this.blend.setDefault(),this.blendFunc.setDefault(),this.blendColor.setDefault(),this.blendEquation.setDefault(),this.cullFace.setDefault(),this.cullFaceSide.setDefault(),this.frontFace.setDefault(),this.program.setDefault(),this.activeTexture.setDefault(),this.bindFramebuffer.setDefault(),this.pixelStoreUnpack.setDefault(),this.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.pixelStoreUnpackFlipY.setDefault();}setDirty(){this.clearColor.dirty=!0,this.clearDepth.dirty=!0,this.clearStencil.dirty=!0,this.colorMask.dirty=!0,this.depthMask.dirty=!0,this.stencilMask.dirty=!0,this.stencilFunc.dirty=!0,this.stencilOp.dirty=!0,this.stencilTest.dirty=!0,this.depthRange.dirty=!0,this.depthTest.dirty=!0,this.depthFunc.dirty=!0,this.blend.dirty=!0,this.blendFunc.dirty=!0,this.blendColor.dirty=!0,this.blendEquation.dirty=!0,this.cullFace.dirty=!0,this.cullFaceSide.dirty=!0,this.frontFace.dirty=!0,this.program.dirty=!0,this.activeTexture.dirty=!0,this.viewport.dirty=!0,this.bindFramebuffer.dirty=!0,this.bindRenderbuffer.dirty=!0,this.bindTexture.dirty=!0,this.bindVertexBuffer.dirty=!0,this.bindElementBuffer.dirty=!0,this.extVertexArrayObject&&(this.bindVertexArrayOES.dirty=!0),this.pixelStoreUnpack.dirty=!0,this.pixelStoreUnpackPremultiplyAlpha.dirty=!0,this.pixelStoreUnpackFlipY.dirty=!0;}createIndexBuffer(t,e){return new Ph(this,t,e)}createVertexBuffer(t,e,r){return new Fh(this,t,e,r)}createRenderbuffer(t,e,r){const i=this.gl,n=i.createRenderbuffer();return this.bindRenderbuffer.set(n),i.renderbufferStorage(i.RENDERBUFFER,t,e,r),this.bindRenderbuffer.set(null),n}createFramebuffer(t,e,r){return new xp(this,t,e,r)}clear({color:t,depth:e,stencil:r}){const i=this.gl;let n=0;t&&(n|=i.COLOR_BUFFER_BIT,this.clearColor.set(t),this.colorMask.set([!0,!0,!0,!0])),void 0!==e&&(n|=i.DEPTH_BUFFER_BIT,this.depthRange.set([0,1]),this.clearDepth.set(e),this.depthMask.set(!0)),void 0!==r&&(n|=i.STENCIL_BUFFER_BIT,this.clearStencil.set(r),this.stencilMask.set(255)),i.clear(n);}setCullFace(t){!1===t.enable?this.cullFace.set(!1):(this.cullFace.set(!0),this.cullFaceSide.set(t.mode),this.frontFace.set(t.frontFace));}setDepthMode(t){t.func!==this.gl.ALWAYS||t.mask?(this.depthTest.set(!0),this.depthFunc.set(t.func),this.depthMask.set(t.mask),this.depthRange.set(t.range)):this.depthTest.set(!1);}setStencilMode(t){t.test.func!==this.gl.ALWAYS||t.mask?(this.stencilTest.set(!0),this.stencilMask.set(t.mask),this.stencilOp.set([t.fail,t.depthFail,t.pass]),this.stencilFunc.set({func:t.test.func,ref:t.ref,mask:t.test.mask})):this.stencilTest.set(!1);}setColorMode(t){a(t.blendFunction,wp.Replace)?this.blend.set(!1):(this.blend.set(!0),this.blendFunc.set(t.blendFunction),this.blendColor.set(t.blendColor)),this.colorMask.set(t.mask);}unbindVAO(){this.extVertexArrayObject&&this.bindVertexArrayOES.set(null);}},t.CullFaceMode=_p,t.DEMData=Dh,t.DataConstantProperty=Wn,t.DedupedRequest=Cp,t.DepthMode=vp,t.DepthStencilAttachment=class extends gp{attachment(){return this.gl.DEPTH_STENCIL_ATTACHMENT}},t.EXTENT=8192,t.Elevation=class{getAtPoint(t,e=0){const r=this._source();if(!r)return e;if(t.y<0||t.y>1)return e;const i=r.getSource().maxzoom,n=1<<i,s=Math.floor(t.x),a=t.x-s,o=new mh(i,s,i,Math.floor(a*n),Math.floor(t.y*n)),l=this.findDEMTileFor(o);if(!l||!l.dem)return e;const u=l.dem,c=1<<l.tileID.canonical.z,h=(a*c-l.tileID.canonical.x)*u.dim,p=(t.y*c-l.tileID.canonical.y)*u.dim,d=Math.floor(h),f=Math.floor(p);return this.exaggeration()*Je(Je(u.get(d,f),u.get(d,f+1),p-f),Je(u.get(d+1,f),u.get(d+1,f+1),p-f),h-d)}getAtTileOffset(t,e,r){const i=1<<t.canonical.z;return this.getAtPoint(new ph(t.wrap+(t.canonical.x+e/8192)/i,(t.canonical.y+r/8192)/i))}getForTilePoints(t,e,r,i){const n=Ip.create(this,t,i);return !!n&&(e.forEach(t=>{t[2]=this.exaggeration()*n.getElevationAt(t[0],t[1],r);}),!0)}getMinMaxForTile(t){const e=this.findDEMTileFor(t);if(!e||!e.dem)return null;const r=e.dem.tree,i=e.tileID,n=1<<t.canonical.z-i.canonical.z;let s=t.canonical.x/n-i.canonical.x,a=t.canonical.y/n-i.canonical.y,o=0;for(let e=0;e<t.canonical.z-i.canonical.z&&!r.leaves[o];e++){s*=2,a*=2;const t=2*Math.floor(a)+Math.floor(s);o=r.childOffsets[o]+t,s%=1,a%=1;}return {min:this.exaggeration()*r.minimums[o],max:this.exaggeration()*r.maximums[o]}}raycast(t,e,r){throw new Error("Pure virtual method called.")}pointCoordinate(t){throw new Error("Pure virtual method called.")}_source(){throw new Error("Pure virtual method called.")}exaggeration(){throw new Error("Pure virtual method called.")}findDEMTileFor(t){throw new Error("Pure virtual method called.")}get visibleDemTiles(){throw new Error("Getter must be implemented in subclass.")}},t.ErrorEvent=Pt,t.EvaluationParameters=qn,t.Event=Ct,t.Evented=Vt,t.Frustum=ho,t.GlyphManager=oc,t.ImagePosition=Eu,t.LngLat=nh,t.LngLatBounds=ih,t.LocalGlyphMode=ac,t.MAX_SAFE_INTEGER=o,t.MercatorCoordinate=ph,t.ONE_EM=24,t.OverscaledTileID=mh,t.Point=i,t.Point$1=i,t.Properties=rs,t.RGBAImage=ko,t.Ray=class{constructor(t,e){this.pos=t,this.dir=e;}intersectsPlane(t,e,r){const i=to(e,this.dir);if(Math.abs(i)<1e-6)return !1;const n=to(so(Ga(),t,this.pos),e)/i;return function(t,e){t[0]=e[0],t[1]=e[1],t[2]=e[2];}(r,Ja(Ga(),this.pos,this.dir,n)),!0}},t.RequestManager=class{constructor(t,e){this._transformRequestFn=t,this._customAccessToken=e,this._createSkuToken();}_createSkuToken(){const t=function(){let t="";for(let e=0;e<10;e++)t+="0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"[Math.floor(62*Math.random())];return {token:["1",Y,t].join(""),tokenExpiresAt:Date.now()+432e5}}();this._skuToken=t.token,this._skuTokenExpiresAt=t.tokenExpiresAt;}_isSkuTokenExpired(){return Date.now()>this._skuTokenExpiresAt}transformRequest(t,e){return this._transformRequestFn&&this._transformRequestFn(t,e)||{url:t}}normalizeStyleURL(t,e){if(!W(t))return t;const r=tt(t);return r.path=`/styles/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeGlyphsURL(t,e){if(!W(t))return t;const r=tt(t);return r.path=`/fonts/v1${r.path}`,this._makeAPIURL(r,this._customAccessToken||e)}normalizeSourceURL(t,e){if(!W(t))return t;const r=tt(t);return r.path=`/v4/${r.authority}.json`,r.params.push("secure"),this._makeAPIURL(r,this._customAccessToken||e)}normalizeSpriteURL(t,e,r,i){const n=tt(t);return W(t)?(n.path=`/styles/v1${n.path}/sprite${e}${r}`,this._makeAPIURL(n,this._customAccessToken||i)):(n.path+=`${e}${r}`,et(n))}normalizeTileURL(t,e,r){if(this._isSkuTokenExpired()&&this._createSkuToken(),t&&!W(t))return t;const i=tt(t);i.path=i.path.replace(/(\.(png|jpg)\d*)(?=$)/,`${e||r&&"raster"!==i.authority&&512===r?"@2x":""}${j.supported?".webp":"$1"}`),"raster"===i.authority?i.path=`/${N.RASTER_URL_PREFIX}${i.path}`:(i.path=i.path.replace(/^.+\/v4\//,"/"),i.path=`/${N.TILE_URL_VERSION}${i.path}`);const n=this._customAccessToken||function(t){for(const e of t){const t=e.match(/^access_token=(.*)$/);if(t)return t[1]}return null}(i.params)||N.ACCESS_TOKEN;return N.REQUIRE_ACCESS_TOKEN&&n&&this._skuToken&&i.params.push(`sku=${this._skuToken}`),this._makeAPIURL(i,n)}canonicalizeTileURL(t,e){const r=tt(t);if(!r.path.match(/^(\/v4\/|\/raster\/v1\/)/)||!r.path.match(/\.[\w]+$/))return t;let i="mapbox://";r.path.match(/^\/raster\/v1\//)?i+=`raster/${r.path.replace(`/${N.RASTER_URL_PREFIX}/`,"")}`:i+=`tiles/${r.path.replace(`/${N.TILE_URL_VERSION}/`,"")}`;let n=r.params;return e&&(n=n.filter(t=>!t.match(/^access_token=/))),n.length&&(i+=`?${n.join("&")}`),i}canonicalizeTileset(t,e){const r=!!e&&W(e),i=[];for(const e of t.tiles||[])J(e)?i.push(this.canonicalizeTileURL(e,r)):i.push(e);return i}_makeAPIURL(t,e){const r="See https://www.mapbox.com/api-documentation/#access-tokens-and-token-scopes",i=tt(N.API_URL);if(t.protocol=i.protocol,t.authority=i.authority,"http"===t.protocol){const e=t.params.indexOf("secure");e>=0&&t.params.splice(e,1);}if("/"!==i.path&&(t.path=`${i.path}${t.path}`),!N.REQUIRE_ACCESS_TOKEN)return et(t);if(!(e=e||N.ACCESS_TOKEN))throw new Error(`An API access token is required to use Mapbox GL. ${r}`);if("s"===e[0])throw new Error(`Use a public access token (pk.*) with Mapbox GL, not a secret access token (sk.*). ${r}`);return t.params=t.params.filter(t=>-1===t.indexOf("access_token")),t.params.push(`access_token=${e}`),et(t)}},t.RequestPerformance=th,t.ResourceType=vt,t.SegmentVector=ya,t.SourceCache=kp,t.StencilMode=bp,t.StructArrayLayout1ui2=zs,t.StructArrayLayout2f1f2i16=vs,t.StructArrayLayout2i4=us,t.StructArrayLayout3f12=ys,t.StructArrayLayout3ui6=ws,t.StructArrayLayout4i8=cs,t.Texture=Wc,t.Tile=wh,t.Transitionable=Gn,t.Uniform1f=Ws,t.Uniform1i=class extends Ys{constructor(t,e){super(t,e),this.current=0;}set(t){this.current!==t&&(this.current=t,this.gl.uniform1i(this.location,t));}},t.Uniform2f=class extends Ys{constructor(t,e){super(t,e),this.current=[0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]||(this.current=t,this.gl.uniform2f(this.location,t[0],t[1]));}},t.Uniform3f=class extends Ys{constructor(t,e){super(t,e),this.current=[0,0,0];}set(t){t[0]===this.current[0]&&t[1]===this.current[1]&&t[2]===this.current[2]||(this.current=t,this.gl.uniform3f(this.location,t[0],t[1],t[2]));}},t.Uniform4f=Js,t.UniformColor=Qs,t.UniformMatrix3f=class extends Ys{constructor(t,e){super(t,e),this.current=ea;}set(t){for(let e=0;e<9;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix3fv(this.location,!1,t);break}}},t.UniformMatrix4f=class extends Ys{constructor(t,e){super(t,e),this.current=ta;}set(t){if(t[12]!==this.current[12]||t[0]!==this.current[0])return this.current=t,void this.gl.uniformMatrix4fv(this.location,!1,t);for(let e=1;e<16;e++)if(t[e]!==this.current[e]){this.current=t,this.gl.uniformMatrix4fv(this.location,!1,t);break}}},t.UnwrappedTileID=yh,t.ValidationError=Rt,t.VectorTileWorkerSource=class extends Vt{constructor(t,e,r,i,n){super(),this.actor=t,this.layerIndex=e,this.availableImages=r,this.loadVectorData=n||Pp,this.loading={},this.loaded={},this.deduped=new Cp(t.scheduler),this.isSpriteLoaded=i,this.scheduler=t.scheduler;}loadTile(t,e){const r=t.uid,i=!!(t&&t.request&&t.request.collectResourceTiming)&&new th(t.request),n=this.loading[r]=new Bp(t);n.abort=this.loadVectorData(t,(s,a)=>{const o=!this.loading[r];if(delete this.loading[r],o||s||!a)return n.status="done",o||(this.loaded[r]=n),e(s);const l=a.rawData,u={};a.expires&&(u.expires=a.expires),a.cacheControl&&(u.cacheControl=a.cacheControl);const c={};if(i){const t=i.finish();t&&(c.resourceTiming=JSON.parse(JSON.stringify(t)));}n.vectorTile=a.vectorTile||new Al.VectorTile(new ou(l));const h=()=>{n.parse(n.vectorTile,this.layerIndex,this.availableImages,this.actor,(t,r)=>{if(t||!r)return e(t);e(null,x({rawTileData:l.slice(0)},r,u,c));});};this.isSpriteLoaded?h():this.once("isSpriteLoaded",()=>{this.scheduler?this.scheduler.add(h,{type:"parseTile",isSymbolTile:t.isSymbolTile,zoom:t.tileZoom}):h();}),this.loaded=this.loaded||{},this.loaded[r]=n;});}reloadTile(t,e){const r=this.loaded,i=t.uid,n=this;if(r&&r[i]){const s=r[i];s.showCollisionBoxes=t.showCollisionBoxes,s.enableTerrain=!!t.enableTerrain;const a=(t,r)=>{const i=s.reloadCallback;i&&(delete s.reloadCallback,s.parse(s.vectorTile,n.layerIndex,this.availableImages,n.actor,i)),e(t,r);};"parsing"===s.status?s.reloadCallback=a:"done"===s.status&&(s.vectorTile?s.parse(s.vectorTile,this.layerIndex,this.availableImages,this.actor,a):a());}}abortTile(t,e){const r=t.uid,i=this.loading[r];i&&(i.abort&&i.abort(),delete this.loading[r]),e();}removeTile(t,e){const r=this.loaded,i=t.uid;r&&r[i]&&delete r[i],e();}},t.WritingMode=Bu,t.ZoomHistory=Yi,t.add=Ha,t.addDynamicAttributes=Bc,t.altitudeFromMercatorZ=hh,t.asyncAll=m,t.bezier=p,t.bindAll=k,t.browser=$,t.bufferConvexPolygon=function(t,e){const r=[];for(let i=0;i<t.length;i++){const n=y(i-1,-1,t.length-1),s=y(i+1,-1,t.length-1),a=t[i],o=t[s],l=t[n].sub(a).unit(),u=o.sub(a).unit(),c=u.angleWithSep(l.x,l.y),h=l.add(u).unit().mult(-1*e/Math.sin(c/2));r.push(a.add(h));}return r},t.cacheEntryPossiblyAdded=function(t){gt++,gt>dt&&(t.getActor().send("enforceCacheSizeLimit",pt),gt=0);},t.clamp=f,t.clearTileCache=function(t){const e=s.caches.delete("mapbox-tiles");t&&e.catch(t).then(()=>t());},t.clipLine=Qu,t.clone=function(t){var e=new Oa(16);return e[0]=t[0],e[1]=t[1],e[2]=t[2],e[3]=t[3],e[4]=t[4],e[5]=t[5],e[6]=t[6],e[7]=t[7],e[8]=t[8],e[9]=t[9],e[10]=t[10],e[11]=t[11],e[12]=t[12],e[13]=t[13],e[14]=t[14],e[15]=t[15],e},t.clone$1=T,t.collisionCircleLayout=Jl,t.config=N,t.conjugate=function(t,e){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=e[3],t},t.create=function(){var t=new Oa(16);return Oa!=Float32Array&&(t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=0,t[12]=0,t[13]=0,t[14]=0),t[0]=1,t[5]=1,t[10]=1,t[15]=1,t},t.create$1=$a,t.create$2=function(){var t=new Oa(4);return Oa!=Float32Array&&(t[1]=0,t[2]=0),t[0]=1,t[3]=1,t},t.createExpression=Qr,t.createLayout=os,t.createStyleLayer=function(t){return "custom"===t.type?new qc(t):new Gc[t.type](t)},t.cross=eo,t.deepEqual=a,t.degToRad=c,t.div=function(t,e,r){return t[0]=e[0]/r[0],t[1]=e[1]/r[1],t[2]=e[2]/r[2],t},t.dot=to,t.ease=d,t.easeCubicInOut=h,t.emitValidationErrors=Ui,t.endsWith=A,t.enforceCacheSizeLimit=function(t){ft(),ct&&ct.then(e=>{e.keys().then(r=>{for(let i=0;i<r.length-t;i++)e.delete(r[i]);});});},t.evaluateSizeForFeature=tu,t.evaluateSizeForZoom=eu,t.evaluateVariableOffset=vc,t.evented=Ln,t.exactEquals=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]&&t[3]===e[3]},t.exactEquals$1=function(t,e){return t[0]===e[0]&&t[1]===e[1]&&t[2]===e[2]},t.extend=x,t.featureFilter=pi,t.filterObject=I,t.fromMat4=function(t,e){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t},t.fromQuat=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=r+r,o=i+i,l=n+n,u=r*a,c=i*a,h=i*o,p=n*a,d=n*o,f=n*l,y=s*a,m=s*o,g=s*l;return t[0]=1-h-f,t[1]=c+g,t[2]=p-m,t[3]=0,t[4]=c-g,t[5]=1-u-f,t[6]=d+y,t[7]=0,t[8]=p+m,t[9]=d-y,t[10]=1-u-h,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t},t.fromRotation=function(t,e){var r=Math.sin(e),i=Math.cos(e);return t[0]=i,t[1]=r,t[2]=0,t[3]=-r,t[4]=i,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t},t.getAnchorAlignment=qu,t.getAnchorJustification=wc,t.getBounds=function(t){let e=1/0,r=1/0,n=-1/0,s=-1/0;for(const i of t)e=Math.min(e,i.x),r=Math.min(r,i.y),n=Math.max(n,i.x),s=Math.max(s,i.y);return {min:new i(e,r),max:new i(n,s)}},t.getImage=Mt,t.getJSON=function(t,e){return _t(x(t,{type:"json"}),e)},t.getMapSessionAPI=ut,t.getRTLTextPluginStatus=Un,t.getReferrer=wt,t.getVideo=function(t,e){const r=s.document.createElement("video");r.muted=!0,r.onloadstart=function(){e(null,r);};for(let e=0;e<t.length;e++){const i=s.document.createElement("source");It(t[e])||(r.crossOrigin="Anonymous"),i.src=t[e],r.appendChild(i);}return {cancel:()=>{}}},t.identity=qa,t.identity$1=uo,t.invert=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=e[4],o=e[5],l=e[6],u=e[7],c=e[8],h=e[9],p=e[10],d=e[11],f=e[12],y=e[13],m=e[14],g=e[15],x=r*o-i*a,v=r*l-n*a,b=r*u-s*a,w=i*l-n*o,_=i*u-s*o,k=n*u-s*l,A=c*y-h*f,S=c*m-p*f,I=c*g-d*f,T=h*m-p*y,z=h*g-d*y,E=p*g-d*m,M=x*E-v*z+b*T+w*I-_*S+k*A;return M?(t[0]=(o*E-l*z+u*T)*(M=1/M),t[1]=(n*z-i*E-s*T)*M,t[2]=(y*k-m*_+g*w)*M,t[3]=(p*_-h*k-d*w)*M,t[4]=(l*I-a*E-u*S)*M,t[5]=(r*E-n*I+s*S)*M,t[6]=(m*b-f*k-g*v)*M,t[7]=(c*k-p*b+d*v)*M,t[8]=(a*z-o*I+u*A)*M,t[9]=(i*I-r*z-s*A)*M,t[10]=(f*_-y*b+g*x)*M,t[11]=(h*b-c*_-d*x)*M,t[12]=(o*S-a*T-l*A)*M,t[13]=(r*T-i*S+n*A)*M,t[14]=(y*v-f*w-m*x)*M,t[15]=(c*w-h*v+p*x)*M,t):null},t.isMapboxURL=W,t.latFromMercatorY=ch,t.len=ao,t.length=Xa,t.length$1=function(t){return Math.hypot(t[0],t[1],t[2],t[3])},t.loadVectorTile=Pp,t.makeRequest=_t,t.mercatorXfromLng=oh,t.mercatorYfromLat=lh,t.mercatorZfromAltitude=uh,t.mul=ja,t.mul$1=function(t,e,r){return t[0]=e[0]*r[0],t[1]=e[1]*r[1],t[2]=e[2]*r[2],t},t.multiply=Na,t.mvt=Al,t.nextPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.ceil(Math.log(t)/Math.LN2))},t.normalize=Qa,t.normalize$1=function(t,e){var r=e[0],i=e[1],n=e[2],s=e[3],a=r*r+i*i+n*n+s*s;return a>0&&(a=1/Math.sqrt(a)),t[0]=r*a,t[1]=i*a,t[2]=n*a,t[3]=s*a,t},t.number=Je,t.offscreenCanvasSupported=xt,t.ortho=function(t,e,r,i,n,s,a){var o=1/(e-r),l=1/(i-n),u=1/(s-a);return t[0]=-2*o,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=-2*l,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=2*u,t[11]=0,t[12]=(e+r)*o,t[13]=(n+i)*l,t[14]=(a+s)*u,t[15]=1,t},t.pbf=ou,t.perspective=function(t,e,r,i,n){var s,a=1/Math.tan(e/2);return t[0]=a/r,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=a,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[11]=-1,t[12]=0,t[13]=0,t[15]=0,null!=n&&n!==1/0?(t[10]=(n+i)*(s=1/(i-n)),t[14]=2*n*i*s):(t[10]=-1,t[14]=-2*i),t},t.pick=function(t,e){const r={};for(let i=0;i<e.length;i++){const n=e[i];n in t&&(r[n]=t[n]);}return r},t.plugin=$n,t.polygonIntersectsBox=Da,t.polygonIntersectsPolygon=_a,t.polygonizeBounds=function(t,e,r=0,n=!0){const s=new i(r,r),a=t.sub(s),o=e.add(s),l=[a,new i(o.x,a.y),o,new i(a.x,o.y)];return n&&l.push(a),l},t.posAttributes=bh,t.postMapLoadEvent=ot,t.postTurnstileEvent=st,t.potpack=zu,t.prevPowerOfTwo=function(t){return t<=1?1:Math.pow(2,Math.floor(Math.log(t)/Math.LN2))},t.radToDeg=function(t){return t*u},t.refProperties=["type","source","source-layer","minzoom","maxzoom","filter","layout"],t.registerForPluginStateChange=function(t){return t({pluginStatus:Pn,pluginURL:Vn}),Ln.on("pluginStateChange",t),t},t.renderColorRamp=So,t.rotate=function(t,e,r){var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+s*o,t[1]=n*l+a*o,t[2]=i*-o+s*l,t[3]=n*-o+a*l,t},t.rotateX=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[4],a=e[5],o=e[6],l=e[7],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[4]=s*n+u*i,t[5]=a*n+c*i,t[6]=o*n+h*i,t[7]=l*n+p*i,t[8]=u*n-s*i,t[9]=c*n-a*i,t[10]=h*n-o*i,t[11]=p*n-l*i,t},t.rotateX$1=co,t.rotateY=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[8],c=e[9],h=e[10],p=e[11];return e!==t&&(t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n-u*i,t[1]=a*n-c*i,t[2]=o*n-h*i,t[3]=l*n-p*i,t[8]=s*i+u*n,t[9]=a*i+c*n,t[10]=o*i+h*n,t[11]=l*i+p*n,t},t.rotateZ=function(t,e,r){var i=Math.sin(r),n=Math.cos(r),s=e[0],a=e[1],o=e[2],l=e[3],u=e[4],c=e[5],h=e[6],p=e[7];return e!==t&&(t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15]),t[0]=s*n+u*i,t[1]=a*n+c*i,t[2]=o*n+h*i,t[3]=l*n+p*i,t[4]=u*n-s*i,t[5]=c*n-a*i,t[6]=h*n-o*i,t[7]=p*n-l*i,t},t.rotateZ$1=function(t,e,r){r*=.5;var i=e[0],n=e[1],s=e[2],a=e[3],o=Math.sin(r),l=Math.cos(r);return t[0]=i*l+n*o,t[1]=n*l-i*o,t[2]=s*l+a*o,t[3]=a*l-s*o,t},t.scale=function(t,e,r){var i=r[0],n=r[1],s=r[2];return t[0]=e[0]*i,t[1]=e[1]*i,t[2]=e[2]*i,t[3]=e[3]*i,t[4]=e[4]*n,t[5]=e[5]*n,t[6]=e[6]*n,t[7]=e[7]*n,t[8]=e[8]*s,t[9]=e[9]*s,t[10]=e[10]*s,t[11]=e[11]*s,t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t},t.scale$1=function(t,e,r){return t[0]=e[0]*r,t[1]=e[1]*r,t[2]=e[2]*r,t[3]=e[3]*r,t},t.scale$2=Wa,t.scaleAndAdd=Ja,t.setCacheLimits=function(t,e){pt=t,dt=e;},t.setRTLTextPlugin=function(t,e,r=!1){if("deferred"===Pn||"loading"===Pn||"loaded"===Pn)throw new Error("setRTLTextPlugin cannot be called multiple times.");Vn=$.resolveURL(t),Pn="deferred",Cn=e,Rn(),r||On();},t.styleSpec=Ft,t.sub=so,t.subtract=Ya,t.symbolSize=ru,t.transformMat3=function(t,e,r){var i=e[0],n=e[1],s=e[2];return t[0]=i*r[0]+n*r[3]+s*r[6],t[1]=i*r[1]+n*r[4]+s*r[7],t[2]=i*r[2]+n*r[5]+s*r[8],t},t.transformMat4=oo,t.transformQuat=io,t.translate=function(t,e,r){var i,n,s,a,o,l,u,c,h,p,d,f,y=r[0],m=r[1],g=r[2];return e===t?(t[12]=e[0]*y+e[4]*m+e[8]*g+e[12],t[13]=e[1]*y+e[5]*m+e[9]*g+e[13],t[14]=e[2]*y+e[6]*m+e[10]*g+e[14],t[15]=e[3]*y+e[7]*m+e[11]*g+e[15]):(n=e[1],s=e[2],a=e[3],o=e[4],l=e[5],u=e[6],c=e[7],h=e[8],p=e[9],d=e[10],f=e[11],t[0]=i=e[0],t[1]=n,t[2]=s,t[3]=a,t[4]=o,t[5]=l,t[6]=u,t[7]=c,t[8]=h,t[9]=p,t[10]=d,t[11]=f,t[12]=i*y+o*m+h*g+e[12],t[13]=n*y+l*m+p*g+e[13],t[14]=s*y+u*m+d*g+e[14],t[15]=a*y+c*m+f*g+e[15]),t},t.triggerPluginCompletionEvent=Fn,t.uniqueId=b,t.validateCustomStyleLayer=function(t){const e=[],r=t.id;return void 0===r&&e.push({message:`layers.${r}: missing required property "id"`}),void 0===t.render&&e.push({message:`layers.${r}: missing required method "render"`}),t.renderingMode&&"2d"!==t.renderingMode&&"3d"!==t.renderingMode&&e.push({message:`layers.${r}: property "renderingMode" must be either "2d" or "3d"`}),e},t.validateLight=Fi,t.validateStyle=Vi,t.values=g,t.vectorTile=Al,t.version="2.1.1",t.warnOnce=E,t.webpSupported=j,t.window=s,t.wrap=y;}));

define(["./shared"],(function(e){"use strict";function t(e){const r=typeof e;if("number"===r||"boolean"===r||"string"===r||null==e)return JSON.stringify(e);if(Array.isArray(e)){let r="[";for(const n of e)r+=`${t(n)},`;return `${r}]`}const n=Object.keys(e).sort();let o="{";for(let r=0;r<n.length;r++)o+=`${JSON.stringify(n[r])}:${t(e[n[r]])},`;return `${o}}`}function r(r){let n="";for(const o of e.refProperties)n+=`/${t(r[o])}`;return n}class n{constructor(e){this.keyCache={},e&&this.replace(e);}replace(e){this._layerConfigs={},this._layers={},this.update(e,[]);}update(t,n){for(const r of t){this._layerConfigs[r.id]=r;const t=this._layers[r.id]=e.createStyleLayer(r);t._featureFilter=e.featureFilter(t.filter),this.keyCache[r.id]&&delete this.keyCache[r.id];}for(const e of n)delete this.keyCache[e],delete this._layerConfigs[e],delete this._layers[e];this.familiesBySource={};const o=function(e,t){const n={};for(let o=0;o<e.length;o++){const i=t&&t[e[o].id]||r(e[o]);t&&(t[e[o].id]=i);let s=n[i];s||(s=n[i]=[]),s.push(e[o]);}const o=[];for(const e in n)o.push(n[e]);return o}(e.values(this._layerConfigs),this.keyCache);for(const e of o){const t=e.map(e=>this._layers[e.id]),r=t[0];if("none"===r.visibility)continue;const n=r.source||"";let o=this.familiesBySource[n];o||(o=this.familiesBySource[n]={});const i=r.sourceLayer||"_geojsonTileLayer";let s=o[i];s||(s=o[i]=[]),s.push(t);}}}const{ImageBitmap:o}=e.window;class i{loadTile(t,r){const{uid:n,encoding:i,rawImageData:s,padding:a,buildQuadTree:l}=t,u=o&&s instanceof o?this.getImageData(s,a):s;r(null,new e.DEMData(n,u,i,a<1,l));}getImageData(t,r){this.offscreenCanvas&&this.offscreenCanvasContext||(this.offscreenCanvas=new OffscreenCanvas(t.width,t.height),this.offscreenCanvasContext=this.offscreenCanvas.getContext("2d")),this.offscreenCanvas.width=t.width,this.offscreenCanvas.height=t.height,this.offscreenCanvasContext.drawImage(t,0,0,t.width,t.height);const n=this.offscreenCanvasContext.getImageData(-r,-r,t.width+2*r,t.height+2*r);return this.offscreenCanvasContext.clearRect(0,0,this.offscreenCanvas.width,this.offscreenCanvas.height),new e.RGBAImage({width:n.width,height:n.height},n.data)}}function s(e,t){if(0!==e.length){a(e[0],t);for(var r=1;r<e.length;r++)a(e[r],!t);}}function a(e,t){for(var r=0,n=0,o=e.length,i=o-1;n<o;i=n++)r+=(e[n][0]-e[i][0])*(e[i][1]+e[n][1]);r>=0!=!!t&&e.reverse();}const l=e.vectorTile.VectorTileFeature.prototype.toGeoJSON;class u{constructor(t){this._feature=t,this.extent=e.EXTENT,this.type=t.type,this.properties=t.tags,"id"in t&&!isNaN(t.id)&&(this.id=parseInt(t.id,10));}loadGeometry(){if(1===this._feature.type){const t=[];for(const r of this._feature.geometry)t.push([new e.Point$1(r[0],r[1])]);return t}{const t=[];for(const r of this._feature.geometry){const n=[];for(const t of r)n.push(new e.Point$1(t[0],t[1]));t.push(n);}return t}}toGeoJSON(e,t,r){return l.call(this,e,t,r)}}class h{constructor(t){this.layers={_geojsonTileLayer:this},this.name="_geojsonTileLayer",this.extent=e.EXTENT,this.length=t.length,this._features=t;}feature(e){return new u(this._features[e])}}var c=e.vectorTile.VectorTileFeature,f=p;function p(e,t){this.options=t||{},this.features=e,this.length=e.length;}function d(e,t){this.id="number"==typeof e.id?e.id:void 0,this.type=e.type,this.rawGeometry=1===e.type?[e.geometry]:e.geometry,this.properties=e.tags,this.extent=t||4096;}p.prototype.feature=function(e){return new d(this.features[e],this.options.extent)},d.prototype.loadGeometry=function(){var t=this.rawGeometry;this.geometry=[];for(var r=0;r<t.length;r++){for(var n=t[r],o=[],i=0;i<n.length;i++)o.push(new e.Point$1(n[i][0],n[i][1]));this.geometry.push(o);}return this.geometry},d.prototype.bbox=function(){this.geometry||this.loadGeometry();for(var e=this.geometry,t=1/0,r=-1/0,n=1/0,o=-1/0,i=0;i<e.length;i++)for(var s=e[i],a=0;a<s.length;a++){var l=s[a];t=Math.min(t,l.x),r=Math.max(r,l.x),n=Math.min(n,l.y),o=Math.max(o,l.y);}return [t,n,r,o]},d.prototype.toGeoJSON=c.prototype.toGeoJSON;var g=y,m=f;function y(t){var r=new e.pbf;return function(e,t){for(var r in e.layers)t.writeMessage(3,v,e.layers[r]);}(t,r),r.finish()}function v(e,t){var r;t.writeVarintField(15,e.version||1),t.writeStringField(1,e.name||""),t.writeVarintField(5,e.extent||4096);var n={keys:[],values:[],keycache:{},valuecache:{}};for(r=0;r<e.length;r++)n.feature=e.feature(r),t.writeMessage(2,x,n);var o=n.keys;for(r=0;r<o.length;r++)t.writeStringField(3,o[r]);var i=n.values;for(r=0;r<i.length;r++)t.writeMessage(4,P,i[r]);}function x(e,t){var r=e.feature;void 0!==r.id&&t.writeVarintField(1,r.id),t.writeMessage(2,w,e),t.writeVarintField(3,r.type),t.writeMessage(4,_,r);}function w(e,t){var r=e.feature,n=e.keys,o=e.values,i=e.keycache,s=e.valuecache;for(var a in r.properties){var l=i[a];void 0===l&&(n.push(a),i[a]=l=n.length-1),t.writeVarint(l);var u=r.properties[a],h=typeof u;"string"!==h&&"boolean"!==h&&"number"!==h&&(u=JSON.stringify(u));var c=h+":"+u,f=s[c];void 0===f&&(o.push(u),s[c]=f=o.length-1),t.writeVarint(f);}}function S(e,t){return (t<<3)+(7&e)}function M(e){return e<<1^e>>31}function _(e,t){for(var r=e.loadGeometry(),n=e.type,o=0,i=0,s=r.length,a=0;a<s;a++){var l=r[a],u=1;1===n&&(u=l.length),t.writeVarint(S(1,u));for(var h=3===n?l.length-1:l.length,c=0;c<h;c++){1===c&&1!==n&&t.writeVarint(S(2,h-1));var f=l[c].x-o,p=l[c].y-i;t.writeVarint(M(f)),t.writeVarint(M(p)),o+=f,i+=p;}3===n&&t.writeVarint(S(7,1));}}function P(e,t){var r=typeof e;"string"===r?t.writeStringField(1,e):"boolean"===r?t.writeBooleanField(7,e):"number"===r&&(e%1!=0?t.writeDoubleField(3,e):e<0?t.writeSVarintField(6,e):t.writeVarintField(5,e));}function b(e,t,r,n){k(e,r,n),k(t,2*r,2*n),k(t,2*r+1,2*n+1);}function k(e,t,r){const n=e[t];e[t]=e[r],e[r]=n;}function T(e,t,r,n){const o=e-r,i=t-n;return o*o+i*i}g.fromVectorTileJs=y,g.fromGeojsonVt=function(e,t){t=t||{};var r={};for(var n in e)r[n]=new f(e[n].features,t),r[n].name=n,r[n].version=t.version,r[n].extent=t.extent;return y({layers:r})},g.GeoJSONWrapper=m;const I=e=>e[0],C=e=>e[1];class L{constructor(e,t=I,r=C,n=64,o=Float64Array){this.nodeSize=n,this.points=e;const i=e.length<65536?Uint16Array:Uint32Array,s=this.ids=new i(e.length),a=this.coords=new o(2*e.length);for(let n=0;n<e.length;n++)s[n]=n,a[2*n]=t(e[n]),a[2*n+1]=r(e[n]);!function e(t,r,n,o,i,s){if(i-o<=n)return;const a=o+i>>1;!function e(t,r,n,o,i,s){for(;i>o;){if(i-o>600){const a=i-o+1,l=n-o+1,u=Math.log(a),h=.5*Math.exp(2*u/3),c=.5*Math.sqrt(u*h*(a-h)/a)*(l-a/2<0?-1:1);e(t,r,n,Math.max(o,Math.floor(n-l*h/a+c)),Math.min(i,Math.floor(n+(a-l)*h/a+c)),s);}const a=r[2*n+s];let l=o,u=i;for(b(t,r,o,n),r[2*i+s]>a&&b(t,r,o,i);l<u;){for(b(t,r,l,u),l++,u--;r[2*l+s]<a;)l++;for(;r[2*u+s]>a;)u--;}r[2*o+s]===a?b(t,r,o,u):(u++,b(t,r,u,i)),u<=n&&(o=u+1),n<=u&&(i=u-1);}}(t,r,a,o,i,s%2),e(t,r,n,o,a-1,s+1),e(t,r,n,a+1,i,s+1);}(s,a,n,0,s.length-1,0);}range(e,t,r,n){return function(e,t,r,n,o,i,s){const a=[0,e.length-1,0],l=[];let u,h;for(;a.length;){const c=a.pop(),f=a.pop(),p=a.pop();if(f-p<=s){for(let s=p;s<=f;s++)u=t[2*s],h=t[2*s+1],u>=r&&u<=o&&h>=n&&h<=i&&l.push(e[s]);continue}const d=Math.floor((p+f)/2);u=t[2*d],h=t[2*d+1],u>=r&&u<=o&&h>=n&&h<=i&&l.push(e[d]);const g=(c+1)%2;(0===c?r<=u:n<=h)&&(a.push(p),a.push(d-1),a.push(g)),(0===c?o>=u:i>=h)&&(a.push(d+1),a.push(f),a.push(g));}return l}(this.ids,this.coords,e,t,r,n,this.nodeSize)}within(e,t,r){return function(e,t,r,n,o,i){const s=[0,e.length-1,0],a=[],l=o*o;for(;s.length;){const u=s.pop(),h=s.pop(),c=s.pop();if(h-c<=i){for(let o=c;o<=h;o++)T(t[2*o],t[2*o+1],r,n)<=l&&a.push(e[o]);continue}const f=Math.floor((c+h)/2),p=t[2*f],d=t[2*f+1];T(p,d,r,n)<=l&&a.push(e[f]);const g=(u+1)%2;(0===u?r-o<=p:n-o<=d)&&(s.push(c),s.push(f-1),s.push(g)),(0===u?r+o>=p:n+o>=d)&&(s.push(f+1),s.push(h),s.push(g));}return a}(this.ids,this.coords,e,t,r,this.nodeSize)}}const O={minZoom:0,maxZoom:16,minPoints:2,radius:40,extent:512,nodeSize:64,log:!1,generateId:!1,reduce:null,map:e=>e},z=Math.fround||(E=new Float32Array(1),e=>(E[0]=+e,E[0]));var E;class F{constructor(e){this.options=X(Object.create(O),e),this.trees=new Array(this.options.maxZoom+1);}load(e){const{log:t,minZoom:r,maxZoom:n,nodeSize:o}=this.options;t&&console.time("total time");const i=`prepare ${e.length} points`;t&&console.time(i),this.points=e;let s=[];for(let t=0;t<e.length;t++)e[t].geometry&&s.push(Z(e[t],t));this.trees[n+1]=new L(s,V,$,o,Float32Array),t&&console.timeEnd(i);for(let e=n;e>=r;e--){const r=+Date.now();s=this._cluster(s,e),this.trees[e]=new L(s,V,$,o,Float32Array),t&&console.log("z%d: %d clusters in %dms",e,s.length,+Date.now()-r);}return t&&console.timeEnd("total time"),this}getClusters(e,t){let r=((e[0]+180)%360+360)%360-180;const n=Math.max(-90,Math.min(90,e[1]));let o=180===e[2]?180:((e[2]+180)%360+360)%360-180;const i=Math.max(-90,Math.min(90,e[3]));if(e[2]-e[0]>=360)r=-180,o=180;else if(r>o){const e=this.getClusters([r,n,180,i],t),s=this.getClusters([-180,n,o,i],t);return e.concat(s)}const s=this.trees[this._limitZoom(t)],a=s.range(G(r),Y(i),G(o),Y(n)),l=[];for(const e of a){const t=s.points[e];l.push(t.numPoints?J(t):this.points[t.index]);}return l}getChildren(e){const t=this._getOriginId(e),r=this._getOriginZoom(e),n="No cluster with the specified id.",o=this.trees[r];if(!o)throw new Error(n);const i=o.points[t];if(!i)throw new Error(n);const s=this.options.radius/(this.options.extent*Math.pow(2,r-1)),a=o.within(i.x,i.y,s),l=[];for(const t of a){const r=o.points[t];r.parentId===e&&l.push(r.numPoints?J(r):this.points[r.index]);}if(0===l.length)throw new Error(n);return l}getLeaves(e,t,r){const n=[];return this._appendLeaves(n,e,t=t||10,r=r||0,0),n}getTile(e,t,r){const n=this.trees[this._limitZoom(e)],o=Math.pow(2,e),{extent:i,radius:s}=this.options,a=s/i,l=(r-a)/o,u=(r+1+a)/o,h={features:[]};return this._addTileFeatures(n.range((t-a)/o,l,(t+1+a)/o,u),n.points,t,r,o,h),0===t&&this._addTileFeatures(n.range(1-a/o,l,1,u),n.points,o,r,o,h),t===o-1&&this._addTileFeatures(n.range(0,l,a/o,u),n.points,-1,r,o,h),h.features.length?h:null}getClusterExpansionZoom(e){let t=this._getOriginZoom(e)-1;for(;t<=this.options.maxZoom;){const r=this.getChildren(e);if(t++,1!==r.length)break;e=r[0].properties.cluster_id;}return t}_appendLeaves(e,t,r,n,o){const i=this.getChildren(t);for(const t of i){const i=t.properties;if(i&&i.cluster?o+i.point_count<=n?o+=i.point_count:o=this._appendLeaves(e,i.cluster_id,r,n,o):o<n?o++:e.push(t),e.length===r)break}return o}_addTileFeatures(e,t,r,n,o,i){for(const s of e){const e=t[s],a=e.numPoints,l={type:1,geometry:[[Math.round(this.options.extent*(e.x*o-r)),Math.round(this.options.extent*(e.y*o-n))]],tags:a?D(e):this.points[e.index].properties};let u;a?u=e.id:this.options.generateId?u=e.index:this.points[e.index].id&&(u=this.points[e.index].id),void 0!==u&&(l.id=u),i.features.push(l);}}_limitZoom(e){return Math.max(this.options.minZoom,Math.min(+e,this.options.maxZoom+1))}_cluster(e,t){const r=[],{radius:n,extent:o,reduce:i,minPoints:s}=this.options,a=n/(o*Math.pow(2,t));for(let n=0;n<e.length;n++){const o=e[n];if(o.zoom<=t)continue;o.zoom=t;const l=this.trees[t+1],u=l.within(o.x,o.y,a),h=o.numPoints||1;let c=h;for(const e of u){const r=l.points[e];r.zoom>t&&(c+=r.numPoints||1);}if(c>=s){let e=o.x*h,s=o.y*h,a=i&&h>1?this._map(o,!0):null;const f=(n<<5)+(t+1)+this.points.length;for(const r of u){const n=l.points[r];if(n.zoom<=t)continue;n.zoom=t;const u=n.numPoints||1;e+=n.x*u,s+=n.y*u,n.parentId=f,i&&(a||(a=this._map(o,!0)),i(a,this._map(n)));}o.parentId=f,r.push(N(e/c,s/c,f,c,a));}else if(r.push(o),c>1)for(const e of u){const n=l.points[e];n.zoom<=t||(n.zoom=t,r.push(n));}}return r}_getOriginId(e){return e-this.points.length>>5}_getOriginZoom(e){return (e-this.points.length)%32}_map(e,t){if(e.numPoints)return t?X({},e.properties):e.properties;const r=this.points[e.index].properties,n=this.options.map(r);return t&&n===r?X({},n):n}}function N(e,t,r,n,o){return {x:z(e),y:z(t),zoom:1/0,id:r,parentId:-1,numPoints:n,properties:o}}function Z(e,t){const[r,n]=e.geometry.coordinates;return {x:z(G(r)),y:z(Y(n)),zoom:1/0,index:t,parentId:-1}}function J(e){return {type:"Feature",id:e.id,properties:D(e),geometry:{type:"Point",coordinates:[(t=e.x,360*(t-.5)),W(e.y)]}};var t;}function D(e){const t=e.numPoints,r=t>=1e4?`${Math.round(t/1e3)}k`:t>=1e3?`${Math.round(t/100)/10}k`:t;return X(X({},e.properties),{cluster:!0,cluster_id:e.id,point_count:t,point_count_abbreviated:r})}function G(e){return e/360+.5}function Y(e){const t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function W(e){const t=(180-360*e)*Math.PI/180;return 360*Math.atan(Math.exp(t))/Math.PI-90}function X(e,t){for(const r in t)e[r]=t[r];return e}function V(e){return e.x}function $(e){return e.y}function j(e,t,r,n,o,i){var s=o-r,a=i-n;if(0!==s||0!==a){var l=((e-r)*s+(t-n)*a)/(s*s+a*a);l>1?(r=o,n=i):l>0&&(r+=s*l,n+=a*l);}return (s=e-r)*s+(a=t-n)*a}function A(e,t,r,n){var o={id:void 0===e?null:e,type:t,geometry:r,tags:n,minX:1/0,minY:1/0,maxX:-1/0,maxY:-1/0};return function(e){var t=e.geometry,r=e.type;if("Point"===r||"MultiPoint"===r||"LineString"===r)R(e,t);else if("Polygon"===r||"MultiLineString"===r)for(var n=0;n<t.length;n++)R(e,t[n]);else if("MultiPolygon"===r)for(n=0;n<t.length;n++)for(var o=0;o<t[n].length;o++)R(e,t[n][o]);}(o),o}function R(e,t){for(var r=0;r<t.length;r+=3)e.minX=Math.min(e.minX,t[r]),e.minY=Math.min(e.minY,t[r+1]),e.maxX=Math.max(e.maxX,t[r]),e.maxY=Math.max(e.maxY,t[r+1]);}function B(e,t,r,n){if(t.geometry){var o=t.geometry.coordinates,i=t.geometry.type,s=Math.pow(r.tolerance/((1<<r.maxZoom)*r.extent),2),a=[],l=t.id;if(r.promoteId?l=t.properties[r.promoteId]:r.generateId&&(l=n||0),"Point"===i)q(o,a);else if("MultiPoint"===i)for(var u=0;u<o.length;u++)q(o[u],a);else if("LineString"===i)U(o,a,s,!1);else if("MultiLineString"===i){if(r.lineMetrics){for(u=0;u<o.length;u++)U(o[u],a=[],s,!1),e.push(A(l,"LineString",a,t.properties));return}Q(o,a,s,!1);}else if("Polygon"===i)Q(o,a,s,!0);else {if("MultiPolygon"!==i){if("GeometryCollection"===i){for(u=0;u<t.geometry.geometries.length;u++)B(e,{id:l,geometry:t.geometry.geometries[u],properties:t.properties},r,n);return}throw new Error("Input data is not a valid GeoJSON object.")}for(u=0;u<o.length;u++){var h=[];Q(o[u],h,s,!0),a.push(h);}}e.push(A(l,i,a,t.properties));}}function q(e,t){t.push(H(e[0])),t.push(K(e[1])),t.push(0);}function U(e,t,r,n){for(var o,i,s=0,a=0;a<e.length;a++){var l=H(e[a][0]),u=K(e[a][1]);t.push(l),t.push(u),t.push(0),a>0&&(s+=n?(o*u-l*i)/2:Math.sqrt(Math.pow(l-o,2)+Math.pow(u-i,2))),o=l,i=u;}var h=t.length-3;t[2]=1,function e(t,r,n,o){for(var i,s=o,a=n-r>>1,l=n-r,u=t[r],h=t[r+1],c=t[n],f=t[n+1],p=r+3;p<n;p+=3){var d=j(t[p],t[p+1],u,h,c,f);if(d>s)i=p,s=d;else if(d===s){var g=Math.abs(p-a);g<l&&(i=p,l=g);}}s>o&&(i-r>3&&e(t,r,i,o),t[i+2]=s,n-i>3&&e(t,i,n,o));}(t,0,h,r),t[h+2]=1,t.size=Math.abs(s),t.start=0,t.end=t.size;}function Q(e,t,r,n){for(var o=0;o<e.length;o++){var i=[];U(e[o],i,r,n),t.push(i);}}function H(e){return e/360+.5}function K(e){var t=Math.sin(e*Math.PI/180),r=.5-.25*Math.log((1+t)/(1-t))/Math.PI;return r<0?0:r>1?1:r}function ee(e,t,r,n,o,i,s,a){if(n/=t,i>=(r/=t)&&s<n)return e;if(s<r||i>=n)return null;for(var l=[],u=0;u<e.length;u++){var h=e[u],c=h.geometry,f=h.type,p=0===o?h.minX:h.minY,d=0===o?h.maxX:h.maxY;if(p>=r&&d<n)l.push(h);else if(!(d<r||p>=n)){var g=[];if("Point"===f||"MultiPoint"===f)te(c,g,r,n,o);else if("LineString"===f)re(c,g,r,n,o,!1,a.lineMetrics);else if("MultiLineString"===f)oe(c,g,r,n,o,!1);else if("Polygon"===f)oe(c,g,r,n,o,!0);else if("MultiPolygon"===f)for(var m=0;m<c.length;m++){var y=[];oe(c[m],y,r,n,o,!0),y.length&&g.push(y);}if(g.length){if(a.lineMetrics&&"LineString"===f){for(m=0;m<g.length;m++)l.push(A(h.id,f,g[m],h.tags));continue}"LineString"!==f&&"MultiLineString"!==f||(1===g.length?(f="LineString",g=g[0]):f="MultiLineString"),"Point"!==f&&"MultiPoint"!==f||(f=3===g.length?"Point":"MultiPoint"),l.push(A(h.id,f,g,h.tags));}}}return l.length?l:null}function te(e,t,r,n,o){for(var i=0;i<e.length;i+=3){var s=e[i+o];s>=r&&s<=n&&(t.push(e[i]),t.push(e[i+1]),t.push(e[i+2]));}}function re(e,t,r,n,o,i,s){for(var a,l,u=ne(e),h=0===o?se:ae,c=e.start,f=0;f<e.length-3;f+=3){var p=e[f],d=e[f+1],g=e[f+2],m=e[f+3],y=e[f+4],v=0===o?p:d,x=0===o?m:y,w=!1;s&&(a=Math.sqrt(Math.pow(p-m,2)+Math.pow(d-y,2))),v<r?x>r&&(l=h(u,p,d,m,y,r),s&&(u.start=c+a*l)):v>n?x<n&&(l=h(u,p,d,m,y,n),s&&(u.start=c+a*l)):ie(u,p,d,g),x<r&&v>=r&&(l=h(u,p,d,m,y,r),w=!0),x>n&&v<=n&&(l=h(u,p,d,m,y,n),w=!0),!i&&w&&(s&&(u.end=c+a*l),t.push(u),u=ne(e)),s&&(c+=a);}var S=e.length-3;p=e[S],d=e[S+1],g=e[S+2],(v=0===o?p:d)>=r&&v<=n&&ie(u,p,d,g),S=u.length-3,i&&S>=3&&(u[S]!==u[0]||u[S+1]!==u[1])&&ie(u,u[0],u[1],u[2]),u.length&&t.push(u);}function ne(e){var t=[];return t.size=e.size,t.start=e.start,t.end=e.end,t}function oe(e,t,r,n,o,i){for(var s=0;s<e.length;s++)re(e[s],t,r,n,o,i,!1);}function ie(e,t,r,n){e.push(t),e.push(r),e.push(n);}function se(e,t,r,n,o,i){var s=(i-t)/(n-t);return e.push(i),e.push(r+(o-r)*s),e.push(1),s}function ae(e,t,r,n,o,i){var s=(i-r)/(o-r);return e.push(t+(n-t)*s),e.push(i),e.push(1),s}function le(e,t){for(var r=[],n=0;n<e.length;n++){var o,i=e[n],s=i.type;if("Point"===s||"MultiPoint"===s||"LineString"===s)o=ue(i.geometry,t);else if("MultiLineString"===s||"Polygon"===s){o=[];for(var a=0;a<i.geometry.length;a++)o.push(ue(i.geometry[a],t));}else if("MultiPolygon"===s)for(o=[],a=0;a<i.geometry.length;a++){for(var l=[],u=0;u<i.geometry[a].length;u++)l.push(ue(i.geometry[a][u],t));o.push(l);}r.push(A(i.id,s,o,i.tags));}return r}function ue(e,t){var r=[];r.size=e.size,void 0!==e.start&&(r.start=e.start,r.end=e.end);for(var n=0;n<e.length;n+=3)r.push(e[n]+t,e[n+1],e[n+2]);return r}function he(e,t){if(e.transformed)return e;var r,n,o,i=1<<e.z,s=e.x,a=e.y;for(r=0;r<e.features.length;r++){var l=e.features[r],u=l.geometry,h=l.type;if(l.geometry=[],1===h)for(n=0;n<u.length;n+=2)l.geometry.push(ce(u[n],u[n+1],t,i,s,a));else for(n=0;n<u.length;n++){var c=[];for(o=0;o<u[n].length;o+=2)c.push(ce(u[n][o],u[n][o+1],t,i,s,a));l.geometry.push(c);}}return e.transformed=!0,e}function ce(e,t,r,n,o,i){return [Math.round(r*(e*n-o)),Math.round(r*(t*n-i))]}function fe(e,t,r,n,o){for(var i=t===o.maxZoom?0:o.tolerance/((1<<t)*o.extent),s={features:[],numPoints:0,numSimplified:0,numFeatures:0,source:null,x:r,y:n,z:t,transformed:!1,minX:2,minY:1,maxX:-1,maxY:0},a=0;a<e.length;a++){s.numFeatures++,pe(s,e[a],i,o);var l=e[a].minX,u=e[a].minY,h=e[a].maxX,c=e[a].maxY;l<s.minX&&(s.minX=l),u<s.minY&&(s.minY=u),h>s.maxX&&(s.maxX=h),c>s.maxY&&(s.maxY=c);}return s}function pe(e,t,r,n){var o=t.geometry,i=t.type,s=[];if("Point"===i||"MultiPoint"===i)for(var a=0;a<o.length;a+=3)s.push(o[a]),s.push(o[a+1]),e.numPoints++,e.numSimplified++;else if("LineString"===i)de(s,o,e,r,!1,!1);else if("MultiLineString"===i||"Polygon"===i)for(a=0;a<o.length;a++)de(s,o[a],e,r,"Polygon"===i,0===a);else if("MultiPolygon"===i)for(var l=0;l<o.length;l++){var u=o[l];for(a=0;a<u.length;a++)de(s,u[a],e,r,!0,0===a);}if(s.length){var h=t.tags||null;if("LineString"===i&&n.lineMetrics){for(var c in h={},t.tags)h[c]=t.tags[c];h.mapbox_clip_start=o.start/o.size,h.mapbox_clip_end=o.end/o.size;}var f={geometry:s,type:"Polygon"===i||"MultiPolygon"===i?3:"LineString"===i||"MultiLineString"===i?2:1,tags:h};null!==t.id&&(f.id=t.id),e.features.push(f);}}function de(e,t,r,n,o,i){var s=n*n;if(n>0&&t.size<(o?s:n))r.numPoints+=t.length/3;else {for(var a=[],l=0;l<t.length;l+=3)(0===n||t[l+2]>s)&&(r.numSimplified++,a.push(t[l]),a.push(t[l+1])),r.numPoints++;o&&function(e,t){for(var r=0,n=0,o=e.length,i=o-2;n<o;i=n,n+=2)r+=(e[n]-e[i])*(e[n+1]+e[i+1]);if(r>0===t)for(n=0,o=e.length;n<o/2;n+=2){var s=e[n],a=e[n+1];e[n]=e[o-2-n],e[n+1]=e[o-1-n],e[o-2-n]=s,e[o-1-n]=a;}}(a,i),e.push(a);}}function ge(e,t){var r=(t=this.options=function(e,t){for(var r in t)e[r]=t[r];return e}(Object.create(this.options),t)).debug;if(r&&console.time("preprocess data"),t.maxZoom<0||t.maxZoom>24)throw new Error("maxZoom should be in the 0-24 range");if(t.promoteId&&t.generateId)throw new Error("promoteId and generateId cannot be used together.");var n=function(e,t){var r=[];if("FeatureCollection"===e.type)for(var n=0;n<e.features.length;n++)B(r,e.features[n],t,n);else B(r,"Feature"===e.type?e:{geometry:e},t);return r}(e,t);this.tiles={},this.tileCoords=[],r&&(console.timeEnd("preprocess data"),console.log("index: maxZoom: %d, maxPoints: %d",t.indexMaxZoom,t.indexMaxPoints),console.time("generate tiles"),this.stats={},this.total=0),(n=function(e,t){var r=t.buffer/t.extent,n=e,o=ee(e,1,-1-r,r,0,-1,2,t),i=ee(e,1,1-r,2+r,0,-1,2,t);return (o||i)&&(n=ee(e,1,-r,1+r,0,-1,2,t)||[],o&&(n=le(o,1).concat(n)),i&&(n=n.concat(le(i,-1)))),n}(n,t)).length&&this.splitTile(n,0,0,0),r&&(n.length&&console.log("features: %d, points: %d",this.tiles[0].numFeatures,this.tiles[0].numPoints),console.timeEnd("generate tiles"),console.log("tiles generated:",this.total,JSON.stringify(this.stats)));}function me(e,t,r){return 32*((1<<e)*r+t)+e}function ye(e,t){const r=e.tileID.canonical;if(!this._geoJSONIndex)return t(null,null);const n=this._geoJSONIndex.getTile(r.z,r.x,r.y);if(!n)return t(null,null);const o=new h(n.features);let i=g(o);0===i.byteOffset&&i.byteLength===i.buffer.byteLength||(i=new Uint8Array(i)),t(null,{vectorTile:o,rawData:i.buffer});}ge.prototype.options={maxZoom:14,indexMaxZoom:5,indexMaxPoints:1e5,tolerance:3,extent:4096,buffer:64,lineMetrics:!1,promoteId:null,generateId:!1,debug:0},ge.prototype.splitTile=function(e,t,r,n,o,i,s){for(var a=[e,t,r,n],l=this.options,u=l.debug;a.length;){n=a.pop(),r=a.pop(),t=a.pop(),e=a.pop();var h=1<<t,c=me(t,r,n),f=this.tiles[c];if(!f&&(u>1&&console.time("creation"),f=this.tiles[c]=fe(e,t,r,n,l),this.tileCoords.push({z:t,x:r,y:n}),u)){u>1&&(console.log("tile z%d-%d-%d (features: %d, points: %d, simplified: %d)",t,r,n,f.numFeatures,f.numPoints,f.numSimplified),console.timeEnd("creation"));var p="z"+t;this.stats[p]=(this.stats[p]||0)+1,this.total++;}if(f.source=e,o){if(t===l.maxZoom||t===o)continue;var d=1<<o-t;if(r!==Math.floor(i/d)||n!==Math.floor(s/d))continue}else if(t===l.indexMaxZoom||f.numPoints<=l.indexMaxPoints)continue;if(f.source=null,0!==e.length){u>1&&console.time("clipping");var g,m,y,v,x,w,S=.5*l.buffer/l.extent,M=.5-S,_=.5+S,P=1+S;g=m=y=v=null,x=ee(e,h,r-S,r+_,0,f.minX,f.maxX,l),w=ee(e,h,r+M,r+P,0,f.minX,f.maxX,l),e=null,x&&(g=ee(x,h,n-S,n+_,1,f.minY,f.maxY,l),m=ee(x,h,n+M,n+P,1,f.minY,f.maxY,l),x=null),w&&(y=ee(w,h,n-S,n+_,1,f.minY,f.maxY,l),v=ee(w,h,n+M,n+P,1,f.minY,f.maxY,l),w=null),u>1&&console.timeEnd("clipping"),a.push(g||[],t+1,2*r,2*n),a.push(m||[],t+1,2*r,2*n+1),a.push(y||[],t+1,2*r+1,2*n),a.push(v||[],t+1,2*r+1,2*n+1);}}},ge.prototype.getTile=function(e,t,r){var n=this.options,o=n.extent,i=n.debug;if(e<0||e>24)return null;var s=1<<e,a=me(e,t=(t%s+s)%s,r);if(this.tiles[a])return he(this.tiles[a],o);i>1&&console.log("drilling down to z%d-%d-%d",e,t,r);for(var l,u=e,h=t,c=r;!l&&u>0;)u--,h=Math.floor(h/2),c=Math.floor(c/2),l=this.tiles[me(u,h,c)];return l&&l.source?(i>1&&console.log("found parent tile z%d-%d-%d",u,h,c),i>1&&console.time("drilling down"),this.splitTile(l.source,u,h,c,e,t,r),i>1&&console.timeEnd("drilling down"),this.tiles[a]?he(this.tiles[a],o):null):null};class ve extends e.VectorTileWorkerSource{constructor(e,t,r,n,o){super(e,t,r,n,ye),o&&(this.loadGeoJSON=o);}loadData(e,t){this._pendingCallback&&this._pendingCallback(null,{abandoned:!0}),this._pendingCallback=t,this._pendingLoadDataParams=e,this._state&&"Idle"!==this._state?this._state="NeedsLoadData":(this._state="Coalescing",this._loadData());}_loadData(){if(!this._pendingCallback||!this._pendingLoadDataParams)return;const t=this._pendingCallback,r=this._pendingLoadDataParams;delete this._pendingCallback,delete this._pendingLoadDataParams;const n=!!(r&&r.request&&r.request.collectResourceTiming)&&new e.RequestPerformance(r.request);this.loadGeoJSON(r,(o,i)=>{if(o||!i)return t(o);if("object"!=typeof i)return t(new Error(`Input data given to '${r.source}' is not a valid GeoJSON object.`));{!function e(t,r){var n,o=t&&t.type;if("FeatureCollection"===o)for(n=0;n<t.features.length;n++)e(t.features[n],r);else if("GeometryCollection"===o)for(n=0;n<t.geometries.length;n++)e(t.geometries[n],r);else if("Feature"===o)e(t.geometry,r);else if("Polygon"===o)s(t.coordinates,r);else if("MultiPolygon"===o)for(n=0;n<t.coordinates.length;n++)s(t.coordinates[n],r);return t}(i,!0);try{if(r.filter){const t=e.createExpression(r.filter,{type:"boolean","property-type":"data-driven",overridable:!1,transition:!1});if("error"===t.result)throw new Error(t.value.map(e=>`${e.key}: ${e.message}`).join(", "));const n=i.features.filter(e=>t.value.evaluate({zoom:0},e));i={type:"FeatureCollection",features:n};}this._geoJSONIndex=r.cluster?new F(function({superclusterOptions:t,clusterProperties:r}){if(!r||!t)return t;const n={},o={},i={accumulated:null,zoom:0},s={properties:null},a=Object.keys(r);for(const t of a){const[i,s]=r[t],a=e.createExpression(s),l=e.createExpression("string"==typeof i?[i,["accumulated"],["get",t]]:i);n[t]=a.value,o[t]=l.value;}return t.map=e=>{s.properties=e;const t={};for(const e of a)t[e]=n[e].evaluate(i,s);return t},t.reduce=(e,t)=>{s.properties=t;for(const t of a)i.accumulated=e[t],e[t]=o[t].evaluate(i,s);},t}(r)).load(i.features):function(e,t){return new ge(e,t)}(i,r.geojsonVtOptions);}catch(o){return t(o)}this.loaded={};const a={};if(n){const e=n.finish();e&&(a.resourceTiming={},a.resourceTiming[r.source]=JSON.parse(JSON.stringify(e)));}t(null,a);}});}coalesce(){"Coalescing"===this._state?this._state="Idle":"NeedsLoadData"===this._state&&(this._state="Coalescing",this._loadData());}reloadTile(e,t){const r=this.loaded;return r&&r[e.uid]?super.reloadTile(e,t):this.loadTile(e,t)}loadGeoJSON(t,r){if(t.request)e.getJSON(t.request,r);else {if("string"!=typeof t.data)return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`));try{return r(null,JSON.parse(t.data))}catch(e){return r(new Error(`Input data given to '${t.source}' is not a valid GeoJSON object.`))}}}removeSource(e,t){this._pendingCallback&&this._pendingCallback(null,{abandoned:!0}),t();}getClusterExpansionZoom(e,t){try{t(null,this._geoJSONIndex.getClusterExpansionZoom(e.clusterId));}catch(e){t(e);}}getClusterChildren(e,t){try{t(null,this._geoJSONIndex.getChildren(e.clusterId));}catch(e){t(e);}}getClusterLeaves(e,t){try{t(null,this._geoJSONIndex.getLeaves(e.clusterId,e.limit,e.offset));}catch(e){t(e);}}}class xe{constructor(t){this.self=t,this.actor=new e.Actor(t,this),this.layerIndexes={},this.availableImages={},this.isSpriteLoaded=!1,this.workerSourceTypes={vector:e.VectorTileWorkerSource,geojson:ve},this.workerSources={},this.demWorkerSources={},this.self.registerWorkerSource=(e,t)=>{if(this.workerSourceTypes[e])throw new Error(`Worker source with name "${e}" already registered.`);this.workerSourceTypes[e]=t;},this.self.registerRTLTextPlugin=t=>{if(e.plugin.isParsed())throw new Error("RTL text plugin already registered.");e.plugin.applyArabicShaping=t.applyArabicShaping,e.plugin.processBidirectionalText=t.processBidirectionalText,e.plugin.processStyledBidirectionalText=t.processStyledBidirectionalText;};}checkIfReady(e,t,r){r();}setReferrer(e,t){this.referrer=t;}spriteLoaded(t,r){this.isSpriteLoaded=r;for(const n in this.workerSources[t]){const o=this.workerSources[t][n];for(const t in o)o[t]instanceof e.VectorTileWorkerSource&&(o[t].isSpriteLoaded=r,o[t].fire(new e.Event("isSpriteLoaded")));}}setImages(e,t,r){this.availableImages[e]=t;for(const r in this.workerSources[e]){const n=this.workerSources[e][r];for(const e in n)n[e].availableImages=t;}r();}enableTerrain(e,t,r){this.terrain=t,r();}setLayers(e,t,r){this.getLayerIndex(e).replace(t),r();}updateLayers(e,t,r){this.getLayerIndex(e).update(t.layers,t.removedIds),r();}loadTile(t,r,n){const o=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).loadTile(o,n);}loadDEMTile(t,r,n){const o=this.enableTerrain?e.extend({buildQuadTree:this.terrain},r):r;this.getDEMWorkerSource(t,r.source).loadTile(o,n);}reloadTile(t,r,n){const o=this.enableTerrain?e.extend({enableTerrain:this.terrain},r):r;this.getWorkerSource(t,r.type,r.source).reloadTile(o,n);}abortTile(e,t,r){this.getWorkerSource(e,t.type,t.source).abortTile(t,r);}removeTile(e,t,r){this.getWorkerSource(e,t.type,t.source).removeTile(t,r);}removeSource(e,t,r){if(!this.workerSources[e]||!this.workerSources[e][t.type]||!this.workerSources[e][t.type][t.source])return;const n=this.workerSources[e][t.type][t.source];delete this.workerSources[e][t.type][t.source],void 0!==n.removeSource?n.removeSource(t,r):r();}loadWorkerSource(e,t,r){try{this.self.importScripts(t.url),r();}catch(e){r(e.toString());}}syncRTLPluginState(t,r,n){try{e.plugin.setState(r);const t=e.plugin.getPluginURL();if(e.plugin.isLoaded()&&!e.plugin.isParsed()&&null!=t){this.self.importScripts(t);const r=e.plugin.isParsed();n(r?void 0:new Error(`RTL Text Plugin failed to import scripts from ${t}`),r);}}catch(e){n(e.toString());}}getAvailableImages(e){let t=this.availableImages[e];return t||(t=[]),t}getLayerIndex(e){let t=this.layerIndexes[e];return t||(t=this.layerIndexes[e]=new n),t}getWorkerSource(e,t,r){return this.workerSources[e]||(this.workerSources[e]={}),this.workerSources[e][t]||(this.workerSources[e][t]={}),this.workerSources[e][t][r]||(this.workerSources[e][t][r]=new this.workerSourceTypes[t]({send:(t,r,n,o,i,s)=>{this.actor.send(t,r,n,e,o,s);},scheduler:this.actor.scheduler},this.getLayerIndex(e),this.getAvailableImages(e),this.isSpriteLoaded)),this.workerSources[e][t][r]}getDEMWorkerSource(e,t){return this.demWorkerSources[e]||(this.demWorkerSources[e]={}),this.demWorkerSources[e][t]||(this.demWorkerSources[e][t]=new i),this.demWorkerSources[e][t]}enforceCacheSizeLimit(t,r){e.enforceCacheSizeLimit(r);}getWorkerPerformanceMetrics(e,t,r){r(void 0,void 0);}}return "undefined"!=typeof WorkerGlobalScope&&"undefined"!=typeof self&&self instanceof WorkerGlobalScope&&(self.worker=new xe(self)),xe}));

define(["./shared"],(function(e){"use strict";var t=i;function i(e){return !function(e){return "undefined"==typeof window||"undefined"==typeof document?"not a browser":Array.prototype&&Array.prototype.every&&Array.prototype.filter&&Array.prototype.forEach&&Array.prototype.indexOf&&Array.prototype.lastIndexOf&&Array.prototype.map&&Array.prototype.some&&Array.prototype.reduce&&Array.prototype.reduceRight&&Array.isArray?Function.prototype&&Function.prototype.bind?Object.keys&&Object.create&&Object.getPrototypeOf&&Object.getOwnPropertyNames&&Object.isSealed&&Object.isFrozen&&Object.isExtensible&&Object.getOwnPropertyDescriptor&&Object.defineProperty&&Object.defineProperties&&Object.seal&&Object.freeze&&Object.preventExtensions?"JSON"in window&&"parse"in JSON&&"stringify"in JSON?function(){if(!("Worker"in window&&"Blob"in window&&"URL"in window))return !1;var e,t,i=new Blob([""],{type:"text/javascript"}),o=URL.createObjectURL(i);try{t=new Worker(o),e=!0;}catch(t){e=!1;}return t&&t.terminate(),URL.revokeObjectURL(o),e}()?"Uint8ClampedArray"in window?ArrayBuffer.isView?function(){var e=document.createElement("canvas");e.width=e.height=1;var t=e.getContext("2d");if(!t)return !1;var i=t.getImageData(0,0,1,1);return i&&i.width===e.width}()?(void 0===o[t=e&&e.failIfMajorPerformanceCaveat]&&(o[t]=function(e){var t,o=function(e){var t=document.createElement("canvas"),o=Object.create(i.webGLContextAttributes);return o.failIfMajorPerformanceCaveat=e,t.getContext("webgl",o)||t.getContext("experimental-webgl",o)}(e);if(!o)return !1;try{t=o.createShader(o.VERTEX_SHADER);}catch(e){return !1}return !(!t||o.isContextLost())&&(o.shaderSource(t,"void main() {}"),o.compileShader(t),!0===o.getShaderParameter(t,o.COMPILE_STATUS))}(t)),o[t]?document.documentMode?"insufficient ECMAScript 6 support":void 0:"insufficient WebGL support"):"insufficient Canvas/getImageData support":"insufficient ArrayBuffer support":"insufficient Uint8ClampedArray support":"insufficient worker support":"insufficient JSON support":"insufficient Object support":"insufficient Function support":"insufficent Array support";var t;}(e)}var o={};i.webGLContextAttributes={antialias:!1,alpha:!0,stencil:!0,depth:!0};const a={create:function(t,i,o){const a=e.window.document.createElement(t);return void 0!==i&&(a.className=i),o&&o.appendChild(a),a},createNS:function(t,i){return e.window.document.createElementNS(t,i)}},r=e.window.document&&e.window.document.documentElement.style,n=r&&void 0!==r.userSelect?"userSelect":"WebkitUserSelect";let s;a.disableDrag=function(){r&&n&&(s=r[n],r[n]="none");},a.enableDrag=function(){r&&n&&(r[n]=s);},a.setTransform=function(e,t){e.style.transform=t;};let l=!1;try{const t=Object.defineProperty({},"passive",{get(){l=!0;}});e.window.addEventListener("test",t,t),e.window.removeEventListener("test",t,t);}catch(e){l=!1;}a.addEventListener=function(e,t,i,o={}){e.addEventListener(t,i,"passive"in o&&l?o:o.capture);},a.removeEventListener=function(e,t,i,o={}){e.removeEventListener(t,i,"passive"in o&&l?o:o.capture);};const c=function(t){t.preventDefault(),t.stopPropagation(),e.window.removeEventListener("click",c,!0);};function h(e){const{userImage:t}=e;return !!(t&&t.render&&t.render())&&(e.data.replace(new Uint8Array(t.data.buffer)),!0)}a.suppressClick=function(){e.window.addEventListener("click",c,!0),e.window.setTimeout(()=>{e.window.removeEventListener("click",c,!0);},0);},a.mousePos=function(t,i){const o=t.getBoundingClientRect();return new e.Point(i.clientX-o.left-t.clientLeft,i.clientY-o.top-t.clientTop)},a.touchPos=function(t,i){const o=t.getBoundingClientRect(),a=[];for(let r=0;r<i.length;r++)a.push(new e.Point(i[r].clientX-o.left-t.clientLeft,i[r].clientY-o.top-t.clientTop));return a},a.mouseButton=function(t){return void 0!==e.window.InstallTrigger&&2===t.button&&t.ctrlKey&&e.window.navigator.platform.toUpperCase().indexOf("MAC")>=0?0:t.button},a.remove=function(e){e.parentNode&&e.parentNode.removeChild(e);};class u extends e.Evented{constructor(){super(),this.images={},this.updatedImages={},this.callbackDispatchedThisFrame={},this.loaded=!1,this.requestors=[],this.patterns={},this.atlasImage=new e.RGBAImage({width:1,height:1}),this.dirty=!0;}isLoaded(){return this.loaded}setLoaded(e){if(this.loaded!==e&&(this.loaded=e,e)){for(const{ids:e,callback:t}of this.requestors)this._notify(e,t);this.requestors=[];}}getImage(e){return this.images[e]}addImage(e,t){this._validate(e,t)&&(this.images[e]=t);}_validate(t,i){let o=!0;return this._validateStretch(i.stretchX,i.data&&i.data.width)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchX" value`))),o=!1),this._validateStretch(i.stretchY,i.data&&i.data.height)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "stretchY" value`))),o=!1),this._validateContent(i.content,i)||(this.fire(new e.ErrorEvent(new Error(`Image "${t}" has invalid "content" value`))),o=!1),o}_validateStretch(e,t){if(!e)return !0;let i=0;for(const o of e){if(o[0]<i||o[1]<o[0]||t<o[1])return !1;i=o[1];}return !0}_validateContent(e,t){return !(e&&(4!==e.length||e[0]<0||t.data.width<e[0]||e[1]<0||t.data.height<e[1]||e[2]<0||t.data.width<e[2]||e[3]<0||t.data.height<e[3]||e[2]<e[0]||e[3]<e[1]))}updateImage(e,t){t.version=this.images[e].version+1,this.images[e]=t,this.updatedImages[e]=!0;}removeImage(e){const t=this.images[e];delete this.images[e],delete this.patterns[e],t.userImage&&t.userImage.onRemove&&t.userImage.onRemove();}listImages(){return Object.keys(this.images)}getImages(e,t){let i=!0;if(!this.isLoaded())for(const t of e)this.images[t]||(i=!1);this.isLoaded()||i?this._notify(e,t):this.requestors.push({ids:e,callback:t});}_notify(t,i){const o={};for(const i of t){this.images[i]||this.fire(new e.Event("styleimagemissing",{id:i}));const t=this.images[i];t?o[i]={data:t.data.clone(),pixelRatio:t.pixelRatio,sdf:t.sdf,version:t.version,stretchX:t.stretchX,stretchY:t.stretchY,content:t.content,hasRenderCallback:Boolean(t.userImage&&t.userImage.render)}:e.warnOnce(`Image "${i}" could not be loaded. Please make sure you have added the image with map.addImage() or a "sprite" property in your style. You can provide missing images by listening for the "styleimagemissing" map event.`);}i(null,o);}getPixelSize(){const{width:e,height:t}=this.atlasImage;return {width:e,height:t}}getPattern(t){const i=this.patterns[t],o=this.getImage(t);if(!o)return null;if(i&&i.position.version===o.version)return i.position;if(i)i.position.version=o.version;else {const i={w:o.data.width+2,h:o.data.height+2,x:0,y:0},a=new e.ImagePosition(i,o);this.patterns[t]={bin:i,position:a};}return this._updatePatternAtlas(),this.patterns[t].position}bind(t){const i=t.gl;this.atlasTexture?this.dirty&&(this.atlasTexture.update(this.atlasImage),this.dirty=!1):this.atlasTexture=new e.Texture(t,this.atlasImage,i.RGBA),this.atlasTexture.bind(i.LINEAR,i.CLAMP_TO_EDGE);}_updatePatternAtlas(){const t=[];for(const e in this.patterns)t.push(this.patterns[e].bin);const{w:i,h:o}=e.potpack(t),a=this.atlasImage;a.resize({width:i||1,height:o||1});for(const t in this.patterns){const{bin:i}=this.patterns[t],o=i.x+1,r=i.y+1,n=this.images[t].data,s=n.width,l=n.height;e.RGBAImage.copy(n,a,{x:0,y:0},{x:o,y:r},{width:s,height:l}),e.RGBAImage.copy(n,a,{x:0,y:l-1},{x:o,y:r-1},{width:s,height:1}),e.RGBAImage.copy(n,a,{x:0,y:0},{x:o,y:r+l},{width:s,height:1}),e.RGBAImage.copy(n,a,{x:s-1,y:0},{x:o-1,y:r},{width:1,height:l}),e.RGBAImage.copy(n,a,{x:0,y:0},{x:o+s,y:r},{width:1,height:l});}this.dirty=!0;}beginFrame(){this.callbackDispatchedThisFrame={};}dispatchRenderCallbacks(e){for(const t of e){if(this.callbackDispatchedThisFrame[t])continue;this.callbackDispatchedThisFrame[t]=!0;const e=this.images[t];h(e)&&this.updateImage(t,e);}}}const d=new e.Properties({anchor:new e.DataConstantProperty(e.styleSpec.light.anchor),position:new class{constructor(){this.specification=e.styleSpec.light.position;}possiblyEvaluate(t,i){return function([t,i,o]){const a=e.degToRad(i+90),r=e.degToRad(o);return {x:t*Math.cos(a)*Math.sin(r),y:t*Math.sin(a)*Math.sin(r),z:t*Math.cos(r),azimuthal:i,polar:o}}(t.expression.evaluate(i))}interpolate(t,i,o){return {x:e.number(t.x,i.x,o),y:e.number(t.y,i.y,o),z:e.number(t.z,i.z,o),azimuthal:e.number(t.azimuthal,i.azimuthal,o),polar:e.number(t.polar,i.polar,o)}}},color:new e.DataConstantProperty(e.styleSpec.light.color),intensity:new e.DataConstantProperty(e.styleSpec.light.intensity)});class _ extends e.Evented{constructor(t){super(),this._transitionable=new e.Transitionable(d),this.setLight(t),this._transitioning=this._transitionable.untransitioned();}getLight(){return this._transitionable.serialize()}setLight(t,i={}){if(!this._validate(e.validateLight,t,i))for(const i in t){const o=t[i];e.endsWith(i,"-transition")?this._transitionable.setTransition(i.slice(0,-"-transition".length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}_validate(t,i,o){return (!o||!1!==o.validate)&&e.emitValidationErrors(this,t.call(e.validateStyle,e.extend({value:i,style:{glyphs:!0,sprite:!0},styleSpec:e.styleSpec})))}}const m=new e.Properties({source:new e.DataConstantProperty(e.styleSpec.terrain.source),exaggeration:new e.DataConstantProperty(e.styleSpec.terrain.exaggeration)});class p extends e.Evented{constructor(t){super(),this._transitionable=new e.Transitionable(m),this.set(t),this._transitioning=this._transitionable.untransitioned();}get(){return this._transitionable.serialize()}set(t){for(const i in t){const o=t[i];e.endsWith(i,"-transition")?this._transitionable.setTransition(i.slice(0,-"-transition".length),o):this._transitionable.setValue(i,o);}}updateTransitions(e){this._transitioning=this._transitionable.transitioned(e,this._transitioning);}hasTransition(){return this._transitioning.hasTransition()}recalculate(e){this.properties=this._transitioning.possiblyEvaluate(e);}}class f{constructor(e,t){this.width=e,this.height=t,this.nextRow=0,this.data=new Uint8Array(this.width*this.height),this.dashEntry={};}getDash(e,t){const i=e.join(",")+String(t);return this.dashEntry[i]||(this.dashEntry[i]=this.addDash(e,t)),this.dashEntry[i]}getDashRanges(e,t,i){const o=[];let a=e.length%2==1?-e[e.length-1]*i:0,r=e[0]*i,n=!0;o.push({left:a,right:r,isDash:n,zeroLength:0===e[0]});let s=e[0];for(let t=1;t<e.length;t++){n=!n;const l=e[t];a=s*i,s+=l,r=s*i,o.push({left:a,right:r,isDash:n,zeroLength:0===l});}return o}addRoundDash(e,t,i){const o=t/2;for(let t=-i;t<=i;t++){const a=this.width*(this.nextRow+i+t);let r=0,n=e[r];for(let s=0;s<this.width;s++){s/n.right>1&&(n=e[++r]);const l=Math.abs(s-n.left),c=Math.abs(s-n.right),h=Math.min(l,c);let u;const d=t/i*(o+1);if(n.isDash){const e=o-Math.abs(d);u=Math.sqrt(h*h+e*e);}else u=o-Math.sqrt(h*h+d*d);this.data[a+s]=Math.max(0,Math.min(255,u+128));}}}addRegularDash(e){for(let t=e.length-1;t>=0;--t){const i=e[t],o=e[t+1];i.zeroLength?e.splice(t,1):o&&o.isDash===i.isDash&&(o.left=i.left,e.splice(t,1));}const t=e[0],i=e[e.length-1];t.isDash===i.isDash&&(t.left=i.left-this.width,i.right=t.right+this.width);const o=this.width*this.nextRow;let a=0,r=e[a];for(let t=0;t<this.width;t++){t/r.right>1&&(r=e[++a]);const i=Math.abs(t-r.left),n=Math.abs(t-r.right),s=Math.min(i,n);this.data[o+t]=Math.max(0,Math.min(255,(r.isDash?s:-s)+128));}}addDash(t,i){const o=i?7:0,a=2*o+1;if(this.nextRow+a>this.height)return e.warnOnce("LineAtlas out of space"),null;0===t.length&&t.push(1);let r=0;for(let i=0;i<t.length;i++)t[i]<0&&(e.warnOnce("Negative value is found in line dasharray, replacing values with 0"),t[i]=0),r+=t[i];if(0!==r){const e=this.width/r,a=this.getDashRanges(t,this.width,e);i?this.addRoundDash(a,e,o):this.addRegularDash(a);}const n={y:(this.nextRow+o+.5)/this.height,height:2*o/this.height,width:r};return this.nextRow+=a,this.dirty=!0,n}bind(e){const t=e.gl;this.texture?(t.bindTexture(t.TEXTURE_2D,this.texture),this.dirty&&(this.dirty=!1,t.texSubImage2D(t.TEXTURE_2D,0,0,0,this.width,this.height,t.ALPHA,t.UNSIGNED_BYTE,this.data))):(this.texture=t.createTexture(),t.bindTexture(t.TEXTURE_2D,this.texture),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_S,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_WRAP_T,t.REPEAT),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MIN_FILTER,t.LINEAR),t.texParameteri(t.TEXTURE_2D,t.TEXTURE_MAG_FILTER,t.LINEAR),t.texImage2D(t.TEXTURE_2D,0,t.ALPHA,this.width,this.height,0,t.ALPHA,t.UNSIGNED_BYTE,this.data));}}class g{constructor(t,i){this.workerPool=t,this.actors=[],this.currentActor=0,this.id=e.uniqueId();const o=this.workerPool.acquire(this.id);for(let e=0;e<o.length;e++){const t=new g.Actor(o[e],i,this.id);t.name=`Worker ${e}`,this.actors.push(t);}this.ready=!1,this.broadcast("checkIfReady",null,()=>{this.ready=!0;});}broadcast(t,i,o){e.asyncAll(this.actors,(e,o)=>{e.send(t,i,o);},o=o||function(){});}getActor(){return this.currentActor=(this.currentActor+1)%this.actors.length,this.actors[this.currentActor]}remove(){this.actors.forEach(e=>{e.remove();}),this.actors=[],this.workerPool.release(this.id);}}function v(t,i,o){return i*(e.EXTENT/(t.tileSize*Math.pow(2,o-t.tileID.overscaledZ)))}g.Actor=e.Actor;class x{constructor(e,t,i,o){this.screenBounds=e,this.cameraPoint=t,this._screenRaycastCache={},this._cameraRaycastCache={},this.isAboveHorizon=i,this.screenGeometry=this.bufferedScreenGeometry(0),this.screenGeometryMercator=this.screenGeometry.map(e=>o.pointCoordinate3D(e)),this.cameraGeometry=this.bufferedCameraGeometry(0);}static createFromScreenPoints(t,i){let o,a;if(t instanceof e.Point||"number"==typeof t[0]){const r=e.Point.convert(t);o=[e.Point.convert(t)],a=i.isPointAboveHorizon(r);}else {const r=e.Point.convert(t[0]),n=e.Point.convert(t[1]);o=[r,n],a=e.polygonizeBounds(r,n).every(e=>i.isPointAboveHorizon(e));}return new x(o,i.getCameraPoint(),a,i)}isPointQuery(){return 1===this.screenBounds.length}bufferedScreenGeometry(t){return e.polygonizeBounds(this.screenBounds[0],1===this.screenBounds.length?this.screenBounds[0]:this.screenBounds[1],t)}bufferedCameraGeometry(t){const i=this.screenBounds[0],o=1===this.screenBounds.length?this.screenBounds[0].add(new e.Point(1,1)):this.screenBounds[1],a=e.polygonizeBounds(i,o,0,!1);return this.cameraPoint.y>o.y&&(this.cameraPoint.x>i.x&&this.cameraPoint.x<o.x?a.splice(3,0,this.cameraPoint):this.cameraPoint.x>=o.x?a[2]=this.cameraPoint:this.cameraPoint.x<=i.x&&(a[3]=this.cameraPoint)),e.bufferConvexPolygon(a,t)}containsTile(t,i,o){const a=t.queryPadding+1,r=o?this._bufferedCameraMercator(a,i).map(e=>t.tileID.getTilePoint(e)):this._bufferedScreenMercator(a,i).map(e=>t.tileID.getTilePoint(e)),n=this.screenGeometryMercator.map(e=>t.tileID.getTileVec3(e)),s=n.map(t=>new e.Point(t[0],t[1])),l=i.getFreeCameraOptions().position||new e.MercatorCoordinate(0,0,0),c=t.tileID.getTileVec3(l),h=n.map(t=>{const i=e.sub(t,t,c);return e.normalize(i,i),new e.Ray(c,i)}),u=v(t,1,i.zoom);if(e.polygonIntersectsBox(r,0,0,e.EXTENT,e.EXTENT))return {queryGeometry:this,tilespaceGeometry:s,tilespaceRays:h,bufferedTilespaceGeometry:r,bufferedTilespaceBounds:(d=e.getBounds(r),d.min.x=e.clamp(d.min.x,0,e.EXTENT),d.min.y=e.clamp(d.min.y,0,e.EXTENT),d.max.x=e.clamp(d.max.x,0,e.EXTENT),d.max.y=e.clamp(d.max.y,0,e.EXTENT),d),tile:t,tileID:t.tileID,pixelToTileUnitsFactor:u};var d;}_bufferedScreenMercator(e,t){const i=y(e);if(this._screenRaycastCache[i])return this._screenRaycastCache[i];{const o=this.bufferedScreenGeometry(e).map(e=>t.pointCoordinate3D(e));return this._screenRaycastCache[i]=o,o}}_bufferedCameraMercator(e,t){const i=y(e);if(this._cameraRaycastCache[i])return this._cameraRaycastCache[i];{const o=this.bufferedCameraGeometry(e).map(e=>t.pointCoordinate3D(e));return this._cameraRaycastCache[i]=o,o}}}function y(e){return 100*e|0}function b(t,i,o){const a=function(a,r){if(a)return o(a);if(r){const a=e.pick(e.extend(r,t),["tiles","minzoom","maxzoom","attribution","mapbox_logo","bounds","scheme","tileSize","encoding"]);r.vector_layers&&(a.vectorLayers=r.vector_layers,a.vectorLayerIds=a.vectorLayers.map(e=>e.id)),a.tiles=i.canonicalizeTileset(a,t.url),o(null,a);}};return t.url?e.getJSON(i.transformRequest(i.normalizeSourceURL(t.url),e.ResourceType.Source),a):e.browser.frame(()=>a(null,t))}class w{constructor(t,i,o){this.bounds=e.LngLatBounds.convert(this.validateBounds(t)),this.minzoom=i||0,this.maxzoom=o||24;}validateBounds(e){return Array.isArray(e)&&4===e.length?[Math.max(-180,e[0]),Math.max(-90,e[1]),Math.min(180,e[2]),Math.min(90,e[3])]:[-180,-90,180,90]}contains(t){const i=Math.pow(2,t.z),o=Math.floor(e.mercatorXfromLng(this.bounds.getWest())*i),a=Math.floor(e.mercatorYfromLat(this.bounds.getNorth())*i),r=Math.ceil(e.mercatorXfromLng(this.bounds.getEast())*i),n=Math.ceil(e.mercatorYfromLat(this.bounds.getSouth())*i);return t.x>=o&&t.x<r&&t.y>=a&&t.y<n}}class T extends e.Evented{constructor(t,i,o,a){super(),this.id=t,this.dispatcher=o,this.setEventedParent(a),this.type="raster",this.minzoom=0,this.maxzoom=22,this.roundZoom=!0,this.scheme="xyz",this.tileSize=512,this._loaded=!1,this._options=e.extend({type:"raster"},i),e.extend(this,e.pick(i,["url","scheme","tileSize"]));}load(){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=b(this._options,this.map._requestManager,(t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(e.extend(this,i),i.bounds&&(this.tileBounds=new w(i.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(i.tiles),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})));});}loaded(){return this._loaded}onAdd(e){this.map=e,this.load();}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return e.extend({},this._options)}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}loadTile(t,i){const o=e.browser.devicePixelRatio>=2,a=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),o,this.tileSize);t.request=e.getImage(this.map._requestManager.transformRequest(a,e.ResourceType.Tile),(o,a)=>{if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(a){this.map._refreshExpiredTiles&&t.setExpiryData(a),delete a.cacheControl,delete a.expires;const o=this.map.painter.context,r=o.gl;t.texture=this.map.painter.getTileTexture(a.width),t.texture?t.texture.update(a,{useMipmap:!0}):(t.texture=new e.Texture(o,a,r.RGBA,{useMipmap:!0}),t.texture.bind(r.LINEAR,r.CLAMP_TO_EDGE,r.LINEAR_MIPMAP_NEAREST),o.extTextureFilterAnisotropic&&r.texParameterf(r.TEXTURE_2D,o.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,o.extTextureFilterAnisotropicMax)),t.state="loaded",e.cacheEntryPossiblyAdded(this.dispatcher),i(null);}});}abortTile(e,t){e.request&&(e.request.cancel(),delete e.request),t();}unloadTile(e,t){e.texture&&this.map.painter.saveTileTexture(e.texture),t();}hasTransition(){return !1}}var E=e.createLayout([{name:"a_pos",type:"Int16",components:2},{name:"a_texture_pos",type:"Int16",components:2}]);class C extends e.Evented{constructor(e,t,i,o){super(),this.id=e,this.dispatcher=i,this.coordinates=t.coordinates,this.type="image",this.minzoom=0,this.maxzoom=22,this.tileSize=512,this.tiles={},this._loaded=!1,this.setEventedParent(o),this.options=t;}load(t,i){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this.url=this.options.url,e.getImage(this.map._requestManager.transformRequest(this.url,e.ResourceType.Image),(o,a)=>{this._loaded=!0,o?this.fire(new e.ErrorEvent(o)):a&&(this.image=a,t&&(this.coordinates=t),i&&i(),this._finishLoading());});}loaded(){return this._loaded}updateImage(e){return this.image&&e.url?(this.options.url=e.url,this.load(e.coordinates,()=>{this.texture=null;}),this):this}_finishLoading(){this.map&&(this.setCoordinates(this.coordinates),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})));}onAdd(e){this.map=e,this.load();}setCoordinates(t){this.coordinates=t;const i=t.map(e.MercatorCoordinate.fromLngLat);this.tileID=function(t){let i=1/0,o=1/0,a=-1/0,r=-1/0;for(const e of t)i=Math.min(i,e.x),o=Math.min(o,e.y),a=Math.max(a,e.x),r=Math.max(r,e.y);const n=Math.max(a-i,r-o),s=Math.max(0,Math.floor(-Math.log(n)/Math.LN2)),l=Math.pow(2,s);return new e.CanonicalTileID(s,Math.floor((i+a)/2*l),Math.floor((o+r)/2*l))}(i),this.minzoom=this.maxzoom=this.tileID.z;const o=i.map(e=>this.tileID.getTilePoint(e)._round());return this._boundsArray=new e.StructArrayLayout4i8,this._boundsArray.emplaceBack(o[0].x,o[0].y,0,0),this._boundsArray.emplaceBack(o[1].x,o[1].y,e.EXTENT,0),this._boundsArray.emplaceBack(o[3].x,o[3].y,0,e.EXTENT),this._boundsArray.emplaceBack(o[2].x,o[2].y,e.EXTENT,e.EXTENT),this.boundsBuffer&&(this.boundsBuffer.destroy(),delete this.boundsBuffer),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})),this}prepare(){if(0===Object.keys(this.tiles).length||!this.image)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,E.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2)),this.texture||(this.texture=new e.Texture(t,this.image,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}loadTile(e,t){this.tileID&&this.tileID.equals(e.tileID.canonical)?(this.tiles[String(e.tileID.wrap)]=e,e.buckets={},t(null)):(e.state="errored",t(null));}serialize(){return {type:"image",url:this.options.url,coordinates:this.coordinates}}hasTransition(){return !1}}const S={vector:class extends e.Evented{constructor(t,i,o,a){if(super(),this.id=t,this.dispatcher=o,this.type="vector",this.minzoom=0,this.maxzoom=22,this.scheme="xyz",this.tileSize=512,this.reparseOverscaled=!0,this.isTileClipped=!0,this._loaded=!1,e.extend(this,e.pick(i,["url","scheme","tileSize","promoteId"])),this._options=e.extend({type:"vector"},i),this._collectResourceTiming=i.collectResourceTiming,512!==this.tileSize)throw new Error("vector tile sources must have a tileSize of 512");this.setEventedParent(a),this._tileWorkers={},this._deduped=new e.DedupedRequest;}load(){this._loaded=!1,this.fire(new e.Event("dataloading",{dataType:"source"})),this._tileJSONRequest=b(this._options,this.map._requestManager,(t,i)=>{this._tileJSONRequest=null,this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(e.extend(this,i),i.bounds&&(this.tileBounds=new w(i.bounds,this.minzoom,this.maxzoom)),e.postTurnstileEvent(i.tiles,this.map._requestManager._customAccessToken),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"metadata"})),this.fire(new e.Event("data",{dataType:"source",sourceDataType:"content"})));});}loaded(){return this._loaded}hasTile(e){return !this.tileBounds||this.tileBounds.contains(e.canonical)}onAdd(e){this.map=e,this.load();}setSourceProperty(e){this._tileJSONRequest&&this._tileJSONRequest.cancel(),e();const t=this.map.style._getSourceCaches(this.id);for(const e of t)e.clearTiles();this.load();}setTiles(e){return this.setSourceProperty(()=>{this._options.tiles=e;}),this}setUrl(e){return this.setSourceProperty(()=>{this.url=e,this._options.url=e;}),this}onRemove(){this._tileJSONRequest&&(this._tileJSONRequest.cancel(),this._tileJSONRequest=null);}serialize(){return e.extend({},this._options)}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme)),a={request:this.map._requestManager.transformRequest(o,e.ResourceType.Tile),data:void 0,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,tileSize:this.tileSize*t.tileID.overscaleFactor(),type:this.type,source:this.id,pixelRatio:e.browser.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId,isSymbolTile:t.isSymbolTile};if(a.request.collectResourceTiming=this._collectResourceTiming,t.actor&&"expired"!==t.state)"loading"===t.state?t.reloadCallback=i:t.request=t.actor.send("reloadTile",a,r.bind(this));else if(t.actor=this._tileWorkers[o]=this._tileWorkers[o]||this.dispatcher.getActor(),this.dispatcher.ready)t.request=t.actor.send("loadTile",a,r.bind(this));else {const i=e.loadVectorTile.call({deduped:this._deduped},a,(e,i)=>{e||!i?r.call(this,e):(a.data={cacheControl:i.cacheControl,expires:i.expires,rawData:i.rawData.slice(0)},t.actor&&t.actor.send("loadTile",a,r.bind(this)));},!0);t.request={cancel:i};}function r(o,a){return delete t.request,t.aborted?i(null):o&&404!==o.status?i(o):(a&&a.resourceTiming&&(t.resourceTiming=a.resourceTiming),this.map._refreshExpiredTiles&&a&&t.setExpiryData(a),t.loadVectorData(a,this.map.painter),e.cacheEntryPossiblyAdded(this.dispatcher),i(null),void(t.reloadCallback&&(this.loadTile(t,t.reloadCallback),t.reloadCallback=null)))}}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.actor&&e.actor.send("abortTile",{uid:e.uid,type:this.type,source:this.id},void 0);}unloadTile(e){e.unloadVectorData(),e.actor&&e.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id},void 0);}hasTransition(){return !1}afterUpdate(){this._tileWorkers={};}},raster:T,"raster-dem":class extends T{constructor(t,i,o,a){super(t,i,o,a),this.type="raster-dem",this.maxzoom=22,this._options=e.extend({type:"raster-dem"},i),this.encoding=i.encoding||"mapbox";}serialize(){return {type:"raster-dem",url:this.url,tileSize:this.tileSize,tiles:this.tiles,bounds:this.bounds,encoding:this.encoding}}loadTile(t,i){const o=this.map._requestManager.normalizeTileURL(t.tileID.canonical.url(this.tiles,this.scheme),!1,this.tileSize);function a(e,o){e&&(t.state="errored",i(e)),o&&(t.dem=o,t.dem.onDeserialize(),t.needsHillshadePrepare=!0,t.needsDEMTextureUpload=!0,t.state="loaded",i(null));}t.request=e.getImage(this.map._requestManager.transformRequest(o,e.ResourceType.Tile),function(o,r){if(delete t.request,t.aborted)t.state="unloaded",i(null);else if(o)t.state="errored",i(o);else if(r){this.map._refreshExpiredTiles&&t.setExpiryData(r),delete r.cacheControl,delete r.expires;const i=e.window.ImageBitmap&&r instanceof e.window.ImageBitmap&&e.offscreenCanvasSupported(),o=1-(r.width-e.prevPowerOfTwo(r.width))/2;o<1||t.neighboringTiles||(t.neighboringTiles=this._getNeighboringTiles(t.tileID));const n=i?r:e.browser.getImageData(r,o),s={uid:t.uid,coord:t.tileID,source:this.id,rawImageData:n,encoding:this.encoding,padding:o};t.actor&&"expired"!==t.state||(t.actor=this.dispatcher.getActor(),t.actor.send("loadDEMTile",s,a.bind(this)));}}.bind(this));}_getNeighboringTiles(t){const i=t.canonical,o=Math.pow(2,i.z),a=(i.x-1+o)%o,r=0===i.x?t.wrap-1:t.wrap,n=(i.x+1+o)%o,s=i.x+1===o?t.wrap+1:t.wrap,l={};return l[new e.OverscaledTileID(t.overscaledZ,r,i.z,a,i.y).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,n,i.y).key]={backfilled:!1},i.y>0&&(l[new e.OverscaledTileID(t.overscaledZ,r,i.z,a,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y-1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,n,i.y-1).key]={backfilled:!1}),i.y+1<o&&(l[new e.OverscaledTileID(t.overscaledZ,r,i.z,a,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,t.wrap,i.z,i.x,i.y+1).key]={backfilled:!1},l[new e.OverscaledTileID(t.overscaledZ,s,i.z,n,i.y+1).key]={backfilled:!1}),l}unloadTile(e){e.demTexture&&this.map.painter.saveTileTexture(e.demTexture),e.fbo&&(e.fbo.destroy(),delete e.fbo),e.dem&&delete e.dem,delete e.neighboringTiles,e.state="unloaded";}},geojson:class extends e.Evented{constructor(t,i,o,a){super(),this.id=t,this.type="geojson",this.minzoom=0,this.maxzoom=18,this.tileSize=512,this.isTileClipped=!0,this.reparseOverscaled=!0,this._removed=!1,this._loaded=!1,this.actor=o.getActor(),this.setEventedParent(a),this._data=i.data,this._options=e.extend({},i),this._collectResourceTiming=i.collectResourceTiming,this._resourceTiming=[],void 0!==i.maxzoom&&(this.maxzoom=i.maxzoom),i.type&&(this.type=i.type),i.attribution&&(this.attribution=i.attribution),this.promoteId=i.promoteId;const r=e.EXTENT/this.tileSize;this.workerOptions=e.extend({source:this.id,cluster:i.cluster||!1,geojsonVtOptions:{buffer:(void 0!==i.buffer?i.buffer:128)*r,tolerance:(void 0!==i.tolerance?i.tolerance:.375)*r,extent:e.EXTENT,maxZoom:this.maxzoom,lineMetrics:i.lineMetrics||!1,generateId:i.generateId||!1},superclusterOptions:{maxZoom:void 0!==i.clusterMaxZoom?i.clusterMaxZoom:this.maxzoom-1,minPoints:Math.max(2,i.clusterMinPoints||2),extent:e.EXTENT,radius:(i.clusterRadius||50)*r,log:!1,generateId:i.generateId||!1},clusterProperties:i.clusterProperties,filter:i.filter},i.workerOptions);}load(){this.fire(new e.Event("dataloading",{dataType:"source"})),this._updateWorkerData(t=>{if(t)return void this.fire(new e.ErrorEvent(t));const i={dataType:"source",sourceDataType:"metadata"};this._collectResourceTiming&&this._resourceTiming&&this._resourceTiming.length>0&&(i.resourceTiming=this._resourceTiming,this._resourceTiming=[]),this.fire(new e.Event("data",i));});}onAdd(e){this.map=e,this.load();}setData(t){return this._data=t,this.fire(new e.Event("dataloading",{dataType:"source"})),this._updateWorkerData(t=>{if(t)return void this.fire(new e.ErrorEvent(t));const i={dataType:"source",sourceDataType:"content"};this._collectResourceTiming&&this._resourceTiming&&this._resourceTiming.length>0&&(i.resourceTiming=this._resourceTiming,this._resourceTiming=[]),this.fire(new e.Event("data",i));}),this}getClusterExpansionZoom(e,t){return this.actor.send("geojson.getClusterExpansionZoom",{clusterId:e,source:this.id},t),this}getClusterChildren(e,t){return this.actor.send("geojson.getClusterChildren",{clusterId:e,source:this.id},t),this}getClusterLeaves(e,t,i,o){return this.actor.send("geojson.getClusterLeaves",{source:this.id,clusterId:e,limit:t,offset:i},o),this}_updateWorkerData(t){this._loaded=!1;const i=e.extend({},this.workerOptions),o=this._data;"string"==typeof o?(i.request=this.map._requestManager.transformRequest(e.browser.resolveURL(o),e.ResourceType.Source),i.request.collectResourceTiming=this._collectResourceTiming):i.data=JSON.stringify(o),this.actor.send(`${this.type}.loadData`,i,(e,o)=>{this._removed||o&&o.abandoned||(this._loaded=!0,o&&o.resourceTiming&&o.resourceTiming[this.id]&&(this._resourceTiming=o.resourceTiming[this.id].slice(0)),this.actor.send(`${this.type}.coalesce`,{source:i.source},null),t(e));});}loaded(){return this._loaded}loadTile(t,i){const o=t.actor?"reloadTile":"loadTile";t.actor=this.actor,t.request=this.actor.send(o,{type:this.type,uid:t.uid,tileID:t.tileID,tileZoom:t.tileZoom,zoom:t.tileID.overscaledZ,maxZoom:this.maxzoom,tileSize:this.tileSize,source:this.id,pixelRatio:e.browser.devicePixelRatio,showCollisionBoxes:this.map.showCollisionBoxes,promoteId:this.promoteId},(e,a)=>(delete t.request,t.unloadVectorData(),t.aborted?i(null):e?i(e):(t.loadVectorData(a,this.map.painter,"reloadTile"===o),i(null))));}abortTile(e){e.request&&(e.request.cancel(),delete e.request),e.aborted=!0;}unloadTile(e){e.unloadVectorData(),this.actor.send("removeTile",{uid:e.uid,type:this.type,source:this.id});}onRemove(){this._removed=!0,this.actor.send("removeSource",{type:this.type,source:this.id});}serialize(){return e.extend({},this._options,{type:this.type,data:this._data})}hasTransition(){return !1}},video:class extends C{constructor(e,t,i,o){super(e,t,i,o),this.roundZoom=!0,this.type="video",this.options=t;}load(){this._loaded=!1;const t=this.options;this.urls=[];for(const i of t.urls)this.urls.push(this.map._requestManager.transformRequest(i,e.ResourceType.Source).url);e.getVideo(this.urls,(t,i)=>{this._loaded=!0,t?this.fire(new e.ErrorEvent(t)):i&&(this.video=i,this.video.loop=!0,this.video.addEventListener("playing",()=>{this.map.triggerRepaint();}),this.map&&this.video.play(),this._finishLoading());});}pause(){this.video&&this.video.pause();}play(){this.video&&this.video.play();}seek(t){if(this.video){const i=this.video.seekable;t<i.start(0)||t>i.end(0)?this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${this.id}`,null,`Playback for this video can be set only between the ${i.start(0)} and ${i.end(0)}-second mark.`))):this.video.currentTime=t;}}getVideo(){return this.video}onAdd(e){this.map||(this.map=e,this.load(),this.video&&(this.video.play(),this.setCoordinates(this.coordinates)));}prepare(){if(0===Object.keys(this.tiles).length||this.video.readyState<2)return;const t=this.map.painter.context,i=t.gl;this.boundsBuffer||(this.boundsBuffer=t.createVertexBuffer(this._boundsArray,E.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2)),this.texture?this.video.paused||(this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE),i.texSubImage2D(i.TEXTURE_2D,0,0,0,i.RGBA,i.UNSIGNED_BYTE,this.video)):(this.texture=new e.Texture(t,this.video,i.RGBA),this.texture.bind(i.LINEAR,i.CLAMP_TO_EDGE));for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}serialize(){return {type:"video",urls:this.urls,coordinates:this.coordinates}}hasTransition(){return this.video&&!this.video.paused}},image:C,canvas:class extends C{constructor(t,i,o,a){super(t,i,o,a),i.coordinates?Array.isArray(i.coordinates)&&4===i.coordinates.length&&!i.coordinates.some(e=>!Array.isArray(e)||2!==e.length||e.some(e=>"number"!=typeof e))||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"coordinates" property must be an array of 4 longitude/latitude array pairs'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "coordinates"'))),i.animate&&"boolean"!=typeof i.animate&&this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'optional "animate" property must be a boolean value'))),i.canvas?"string"==typeof i.canvas||i.canvas instanceof e.window.HTMLCanvasElement||this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'"canvas" must be either a string representing the ID of the canvas element from which to read, or an HTMLCanvasElement instance'))):this.fire(new e.ErrorEvent(new e.ValidationError(`sources.${t}`,null,'missing required property "canvas"'))),this.options=i,this.animate=void 0===i.animate||i.animate;}load(){this._loaded=!0,this.canvas||(this.canvas=this.options.canvas instanceof e.window.HTMLCanvasElement?this.options.canvas:e.window.document.getElementById(this.options.canvas)),this.width=this.canvas.width,this.height=this.canvas.height,this._hasInvalidDimensions()?this.fire(new e.ErrorEvent(new Error("Canvas dimensions cannot be less than or equal to zero."))):(this.play=function(){this._playing=!0,this.map.triggerRepaint();},this.pause=function(){this._playing&&(this.prepare(),this._playing=!1);},this._finishLoading());}getCanvas(){return this.canvas}onAdd(e){this.map=e,this.load(),this.canvas&&this.animate&&this.play();}onRemove(){this.pause();}prepare(){let t=!1;if(this.canvas.width!==this.width&&(this.width=this.canvas.width,t=!0),this.canvas.height!==this.height&&(this.height=this.canvas.height,t=!0),this._hasInvalidDimensions())return;if(0===Object.keys(this.tiles).length)return;const i=this.map.painter.context,o=i.gl;this.boundsBuffer||(this.boundsBuffer=i.createVertexBuffer(this._boundsArray,E.members)),this.boundsSegments||(this.boundsSegments=e.SegmentVector.simpleSegment(0,0,4,2)),this.texture?(t||this._playing)&&this.texture.update(this.canvas,{premultiply:!0}):this.texture=new e.Texture(i,this.canvas,o.RGBA,{premultiply:!0});for(const e in this.tiles){const t=this.tiles[e];"loaded"!==t.state&&(t.state="loaded",t.texture=this.texture);}}serialize(){return {type:"canvas",coordinates:this.coordinates}}hasTransition(){return this._playing}_hasInvalidDimensions(){for(const e of [this.canvas.width,this.canvas.height])if(isNaN(e)||e<=0)return !0;return !1}}},I=function(t,i,o,a){const r=new S[i.type](t,i,o,a);if(r.id!==t)throw new Error(`Expected Source id to be ${t} instead of ${r.id}`);return e.bindAll(["load","abort","unload","serialize","prepare"],r),r};function P(t,i){const o=e.identity([]);return e.scale(o,o,[.5*t.width,.5*-t.height,1]),e.translate(o,o,[1,-1,0]),e.multiply(o,o,t.calculatePosMatrix(i.toUnwrapped()))}function M(e,t,i,o,a,r,n,s=!1){const l=e.tilesIn(o,n,s);l.sort(A);const c=[];for(const o of l)c.push({wrappedTileID:o.tile.tileID.wrapped().key,queryResults:o.tile.queryRenderedFeatures(t,i,e._state,o,a,r,P(e.transform,o.tile.tileID),s)});const h=function(e){const t={},i={};for(const o of e){const e=o.queryResults,a=o.wrappedTileID,r=i[a]=i[a]||{};for(const i in e){const o=e[i],a=r[i]=r[i]||{},n=t[i]=t[i]||[];for(const e of o)a[e.featureIndex]||(a[e.featureIndex]=!0,n.push(e));}}return t}(c);for(const t in h)h[t].forEach(t=>{const i=t.feature,o=e.getFeatureState(i.layer["source-layer"],i.id);i.source=i.layer.source,i.layer["source-layer"]&&(i.sourceLayer=i.layer["source-layer"]),i.state=o;});return h}function z(e,t){const i=e.getRenderableIds().map(t=>e.getTileByID(t)),o=[],a={};for(let e=0;e<i.length;e++){const r=i[e],n=r.tileID.canonical.key;a[n]||(a[n]=!0,r.querySourceFeatures(o,t));}return o}function A(e,t){const i=e.tileID,o=t.tileID;return i.overscaledZ-o.overscaledZ||i.canonical.y-o.canonical.y||i.wrap-o.wrap||i.canonical.x-o.canonical.x}function D(){return null!=fa.workerClass?new fa.workerClass:new e.window.Worker(fa.workerUrl)}const L="mapboxgl_preloaded_worker_pool";class R{constructor(){this.active={};}acquire(e){if(!this.workers)for(this.workers=[];this.workers.length<R.workerCount;)this.workers.push(new D);return this.active[e]=!0,this.workers.slice()}release(e){delete this.active[e],0===this.numActive()&&(this.workers.forEach(e=>{e.terminate();}),this.workers=null);}isPreloaded(){return !!this.active[L]}numActive(){return Object.keys(this.active).length}}let k;function B(){return k||(k=new R),k}function F(t,i){const o={};for(const e in t)"ref"!==e&&(o[e]=t[e]);return e.refProperties.forEach(e=>{e in i&&(o[e]=i[e]);}),o}function O(e){e=e.slice();const t=Object.create(null);for(let i=0;i<e.length;i++)t[e[i].id]=e[i];for(let i=0;i<e.length;i++)"ref"in e[i]&&(e[i]=F(e[i],t[e[i].ref]));return e}R.workerCount=2;const U={setStyle:"setStyle",addLayer:"addLayer",removeLayer:"removeLayer",setPaintProperty:"setPaintProperty",setLayoutProperty:"setLayoutProperty",setFilter:"setFilter",addSource:"addSource",removeSource:"removeSource",setGeoJSONSourceData:"setGeoJSONSourceData",setLayerZoomRange:"setLayerZoomRange",setLayerProperty:"setLayerProperty",setCenter:"setCenter",setZoom:"setZoom",setBearing:"setBearing",setPitch:"setPitch",setSprite:"setSprite",setGlyphs:"setGlyphs",setTransition:"setTransition",setLight:"setLight",setTerrain:"setTerrain"};function N(e,t,i){i.push({command:U.addSource,args:[e,t[e]]});}function Z(e,t,i){t.push({command:U.removeSource,args:[e]}),i[e]=!0;}function G(e,t,i,o){Z(e,i,o),N(e,t,i);}function V(t,i,o){let a;for(a in t[o])if(t[o].hasOwnProperty(a)&&"data"!==a&&!e.deepEqual(t[o][a],i[o][a]))return !1;for(a in i[o])if(i[o].hasOwnProperty(a)&&"data"!==a&&!e.deepEqual(t[o][a],i[o][a]))return !1;return !0}function q(t,i,o,a,r,n){let s;for(s in i=i||{},t=t||{})t.hasOwnProperty(s)&&(e.deepEqual(t[s],i[s])||o.push({command:n,args:[a,s,i[s],r]}));for(s in i)i.hasOwnProperty(s)&&!t.hasOwnProperty(s)&&(e.deepEqual(t[s],i[s])||o.push({command:n,args:[a,s,i[s],r]}));}function j(e){return e.id}function $(e,t){return e[t.id]=t,e}class X{constructor(e,t){this.reset(e,t);}reset(e,t){this.points=e||[],this._distances=[0];for(let e=1;e<this.points.length;e++)this._distances[e]=this._distances[e-1]+this.points[e].dist(this.points[e-1]);this.length=this._distances[this._distances.length-1],this.padding=Math.min(t||0,.5*this.length),this.paddedLength=this.length-2*this.padding;}lerp(t){if(1===this.points.length)return this.points[0];t=e.clamp(t,0,1);let i=1,o=this._distances[i];const a=t*this.paddedLength+this.padding;for(;o<a&&i<this._distances.length;)o=this._distances[++i];const r=i-1,n=this._distances[r],s=o-n,l=s>0?(a-n)/s:0;return this.points[r].mult(1-l).add(this.points[i].mult(l))}}class W{constructor(e,t,i){const o=this.boxCells=[],a=this.circleCells=[];this.xCellCount=Math.ceil(e/i),this.yCellCount=Math.ceil(t/i);for(let e=0;e<this.xCellCount*this.yCellCount;e++)o.push([]),a.push([]);this.circleKeys=[],this.boxKeys=[],this.bboxes=[],this.circles=[],this.width=e,this.height=t,this.xScale=this.xCellCount/e,this.yScale=this.yCellCount/t,this.boxUid=0,this.circleUid=0;}keysLength(){return this.boxKeys.length+this.circleKeys.length}insert(e,t,i,o,a){this._forEachCell(t,i,o,a,this._insertBoxCell,this.boxUid++),this.boxKeys.push(e),this.bboxes.push(t),this.bboxes.push(i),this.bboxes.push(o),this.bboxes.push(a);}insertCircle(e,t,i,o){this._forEachCell(t-o,i-o,t+o,i+o,this._insertCircleCell,this.circleUid++),this.circleKeys.push(e),this.circles.push(t),this.circles.push(i),this.circles.push(o);}_insertBoxCell(e,t,i,o,a,r){this.boxCells[a].push(r);}_insertCircleCell(e,t,i,o,a,r){this.circleCells[a].push(r);}_query(e,t,i,o,a,r){if(i<0||e>this.width||o<0||t>this.height)return !a&&[];const n=[];if(e<=0&&t<=0&&this.width<=i&&this.height<=o){if(a)return !0;for(let e=0;e<this.boxKeys.length;e++)n.push({key:this.boxKeys[e],x1:this.bboxes[4*e],y1:this.bboxes[4*e+1],x2:this.bboxes[4*e+2],y2:this.bboxes[4*e+3]});for(let e=0;e<this.circleKeys.length;e++){const t=this.circles[3*e],i=this.circles[3*e+1],o=this.circles[3*e+2];n.push({key:this.circleKeys[e],x1:t-o,y1:i-o,x2:t+o,y2:i+o});}return r?n.filter(r):n}return this._forEachCell(e,t,i,o,this._queryCell,n,{hitTest:a,seenUids:{box:{},circle:{}}},r),a?n.length>0:n}_queryCircle(e,t,i,o,a){const r=e-i,n=e+i,s=t-i,l=t+i;if(n<0||r>this.width||l<0||s>this.height)return !o&&[];const c=[];return this._forEachCell(r,s,n,l,this._queryCellCircle,c,{hitTest:o,circle:{x:e,y:t,radius:i},seenUids:{box:{},circle:{}}},a),o?c.length>0:c}query(e,t,i,o,a){return this._query(e,t,i,o,!1,a)}hitTest(e,t,i,o,a){return this._query(e,t,i,o,!0,a)}hitTestCircle(e,t,i,o){return this._queryCircle(e,t,i,!0,o)}_queryCell(e,t,i,o,a,r,n,s){const l=n.seenUids,c=this.boxCells[a];if(null!==c){const a=this.bboxes;for(const h of c)if(!l.box[h]){l.box[h]=!0;const c=4*h;if(e<=a[c+2]&&t<=a[c+3]&&i>=a[c+0]&&o>=a[c+1]&&(!s||s(this.boxKeys[h]))){if(n.hitTest)return r.push(!0),!0;r.push({key:this.boxKeys[h],x1:a[c],y1:a[c+1],x2:a[c+2],y2:a[c+3]});}}}const h=this.circleCells[a];if(null!==h){const a=this.circles;for(const c of h)if(!l.circle[c]){l.circle[c]=!0;const h=3*c;if(this._circleAndRectCollide(a[h],a[h+1],a[h+2],e,t,i,o)&&(!s||s(this.circleKeys[c]))){if(n.hitTest)return r.push(!0),!0;{const e=a[h],t=a[h+1],i=a[h+2];r.push({key:this.circleKeys[c],x1:e-i,y1:t-i,x2:e+i,y2:t+i});}}}}}_queryCellCircle(e,t,i,o,a,r,n,s){const l=n.circle,c=n.seenUids,h=this.boxCells[a];if(null!==h){const e=this.bboxes;for(const t of h)if(!c.box[t]){c.box[t]=!0;const i=4*t;if(this._circleAndRectCollide(l.x,l.y,l.radius,e[i+0],e[i+1],e[i+2],e[i+3])&&(!s||s(this.boxKeys[t])))return r.push(!0),!0}}const u=this.circleCells[a];if(null!==u){const e=this.circles;for(const t of u)if(!c.circle[t]){c.circle[t]=!0;const i=3*t;if(this._circlesCollide(e[i],e[i+1],e[i+2],l.x,l.y,l.radius)&&(!s||s(this.circleKeys[t])))return r.push(!0),!0}}}_forEachCell(e,t,i,o,a,r,n,s){const l=this._convertToXCellCoord(e),c=this._convertToYCellCoord(t),h=this._convertToXCellCoord(i),u=this._convertToYCellCoord(o);for(let d=l;d<=h;d++)for(let l=c;l<=u;l++)if(a.call(this,e,t,i,o,this.xCellCount*l+d,r,n,s))return}_convertToXCellCoord(e){return Math.max(0,Math.min(this.xCellCount-1,Math.floor(e*this.xScale)))}_convertToYCellCoord(e){return Math.max(0,Math.min(this.yCellCount-1,Math.floor(e*this.yScale)))}_circlesCollide(e,t,i,o,a,r){const n=o-e,s=a-t,l=i+r;return l*l>n*n+s*s}_circleAndRectCollide(e,t,i,o,a,r,n){const s=(r-o)/2,l=Math.abs(e-(o+s));if(l>s+i)return !1;const c=(n-a)/2,h=Math.abs(t-(a+c));if(h>c+i)return !1;if(l<=s||h<=c)return !0;const u=l-s,d=h-c;return u*u+d*d<=i*i}}function H(t,i,o,a,r){const n=e.create();return i?(e.scale(n,n,[1/r,1/r,1]),o||e.rotateZ(n,n,a.angle)):e.multiply(n,a.labelPlaneMatrix,t),n}function K(t,i,o,a,r){if(i){const i=e.clone(t);return e.scale(i,i,[r,r,1]),o||e.rotateZ(i,i,-a.angle),i}return a.glCoordMatrix}function Y(t,i,o=0){const a=[t.x,t.y,o,1];o?e.transformMat4(a,a,i):le(a,a,i);const r=a[3];return {point:new e.Point(a[0]/r,a[1]/r),signedDistanceFromCamera:r}}function J(e,t){return Math.min(.5+e/t*.5,1.5)}function Q(e,t){const i=e[0]/e[3],o=e[1]/e[3];return i>=-t[0]&&i<=t[0]&&o>=-t[1]&&o<=t[1]}function ee(t,i,o,a,r,n,s,l,c){const h=a?t.textSizeData:t.iconSizeData,u=e.evaluateSizeForZoom(h,o.transform.zoom),d=[256/o.width*2+1,256/o.height*2+1],_=a?t.text.dynamicLayoutVertexArray:t.icon.dynamicLayoutVertexArray;_.clear();const m=t.lineVertexArray,p=a?t.text.placedSymbolArray:t.icon.placedSymbolArray,f=o.transform.width/o.transform.height;let g=!1;for(let a=0;a<p.length;a++){const v=p.get(a);if(v.hidden||v.writingMode===e.WritingMode.vertical&&!g){se(v.numGlyphs,_);continue}g=!1;const x=c?c({x:v.anchorX,y:v.anchorY}):0,y=[v.anchorX,v.anchorY,x,1];if(e.transformMat4(y,y,i),!Q(y,d)){se(v.numGlyphs,_);continue}const b=J(o.transform.cameraToCenterDistance,y[3]),w=e.evaluateSizeForFeature(h,u,v),T=s?w/b:w*b,E=new e.Point(v.anchorX,v.anchorY),C=Y(E,r,x);if(C.signedDistanceFromCamera<=0){se(v.numGlyphs,_);continue}const S=C.point;let I={};const P=s?null:c,M=oe(v,T,!1,l,i,r,n,t.glyphOffsetArray,m,_,S,E,I,f,P);g=M.useVertical,P&&M.needsFlipping&&(I={}),(M.notEnoughRoom||g||M.needsFlipping&&oe(v,T,!0,l,i,r,n,t.glyphOffsetArray,m,_,S,E,I,f,P).notEnoughRoom)&&se(v.numGlyphs,_);}a?t.text.dynamicLayoutVertexBuffer.updateData(_):t.icon.dynamicLayoutVertexBuffer.updateData(_);}function te(e,t,i,o,a,r,n,s,l,c,h,u,d){const _=s.glyphStartIndex+s.numGlyphs,m=s.lineStartIndex,p=s.lineStartIndex+s.lineLength,f=t.getoffsetX(s.glyphStartIndex),g=t.getoffsetX(_-1),v=re(e*f,i,o,a,r,n,s.segment,m,p,l,c,h,u,d,!0);if(!v)return null;const x=re(e*g,i,o,a,r,n,s.segment,m,p,l,c,h,u,d,!0);return x?{first:v,last:x}:null}function ie(t,i,o,a){return t===e.WritingMode.horizontal&&Math.abs(o.y-i.y)>Math.abs(o.x-i.x)*a?{useVertical:!0}:(t===e.WritingMode.vertical?i.y<o.y:i.x>o.x)?{needsFlipping:!0}:null}function oe(t,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=i/24,g=t.lineOffsetX*f,v=t.lineOffsetY*f;let x;if(t.numGlyphs>1){const e=t.glyphStartIndex+t.numGlyphs,i=t.lineStartIndex,r=t.lineStartIndex+t.lineLength,h=te(f,l,g,v,o,u,d,t,c,n,_,p);if(!h)return {notEnoughRoom:!0};const y=Y(h.first.point,s).point,b=Y(h.last.point,s).point;if(a&&!o){const e=ie(t.writingMode,y,b,m);if(e)return e}x=[h.first];for(let a=t.glyphStartIndex+1;a<e-1;a++)x.push(re(f*l.getoffsetX(a),g,v,o,u,d,t.segment,i,r,c,n,_,p));x.push(h.last);}else {if(a&&!o){const i=Y(d,r).point,o=t.lineStartIndex+t.segment+1,a=new e.Point(c.getx(o),c.gety(o)),n=Y(a,r),s=n.signedDistanceFromCamera>0?n.point:ae(d,a,i,1,r),l=ie(t.writingMode,i,s,m);if(l)return l}const i=re(f*l.getoffsetX(t.glyphStartIndex),g,v,o,u,d,t.segment,t.lineStartIndex,t.lineStartIndex+t.lineLength,c,n,_,p);if(!i)return {notEnoughRoom:!0};x=[i];}for(const t of x)e.addDynamicAttributes(h,t.point,t.angle);return {}}function ae(e,t,i,o,a,r){const n=e.add(e.sub(t)._unit()),s=Y(n,a,r?r(n):0).point,l=i.sub(s);return i.add(l._mult(o/l.mag()))}function re(t,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=a?t-i:t+i;let g=f>0?1:-1,v=0;a&&(g*=-1,v=Math.PI),g<0&&(v+=Math.PI);let x=g>0?l+s:l+s+1,y=r,b=r,w=0,T=0;const E=Math.abs(f),C=[],S=[];let I=n;const P=()=>{const t=x-g;return 0===w?n:new e.Point(h.getx(t),h.gety(t))},M=()=>ae(P(),I,b,E-w+1,u,_);for(;w+T<=E;){if(x+=g,x<l||x>=c)return null;if(b=y,C.push(y),m&&S.push(I||P()),y=d[x],void 0===y){I=new e.Point(h.getx(x),h.gety(x));const t=Y(I,u,_?_(I):0);y=t.signedDistanceFromCamera>0?d[x]=t.point:M();}else I=null;w+=T,T=b.dist(y);}p&&_&&(I=I||new e.Point(h.getx(x),h.gety(x)),d[x]=y=void 0===d[x]?y:M(),T=b.dist(y));const z=(E-w)/T,A=y.sub(b),D=A.mult(z)._add(b);o&&D._add(A._unit()._perp()._mult(o*g));const L=v+Math.atan2(y.y-b.y,y.x-b.x);return C.push(D),m&&(I=I||new e.Point(h.getx(x),h.gety(x)),S.push(function(t,i,o){const a=1-o;return new e.Point(t.x*a+i.x*o,t.y*a+i.y*o)}(S.length>0?S[S.length-1]:I,I,z))),{point:D,angle:L,path:C,tilePath:S}}const ne=new Float32Array([-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0,-1/0,-1/0,0]);function se(e,t){for(let i=0;i<e;i++){const e=t.length;t.resize(e+4),t.float32.set(ne,3*e);}}function le(e,t,i){const o=t[0],a=t[1];return e[0]=i[0]*o+i[4]*a+i[12],e[1]=i[1]*o+i[5]*a+i[13],e[3]=i[3]*o+i[7]*a+i[15],e}class ce{constructor(e,t=new W(e.width+200,e.height+200,25),i=new W(e.width+200,e.height+200,25)){this.transform=e,this.grid=t,this.ignoredGrid=i,this.pitchfactor=Math.cos(e._pitch)*e.cameraToCenterDistance,this.screenRightBoundary=e.width+100,this.screenBottomBoundary=e.height+100,this.gridRightBoundary=e.width+200,this.gridBottomBoundary=e.height+200;}placeCollisionBox(e,t,i,o,a,r,n){const s=this.projectAndGetPerspectiveRatio(r,t.anchorPointX,t.anchorPointY,t.elevation),l=a*s.perspectiveRatio,c=(t.x1*e+i.x-t.padding)*l+s.point.x,h=(t.y1*e+i.y-t.padding)*l+s.point.y,u=(t.x2*e+i.x+t.padding)*l+s.point.x,d=(t.y2*e+i.y+t.padding)*l+s.point.y,_=s.perspectiveRatio<=.55||s.aboveHorizon;return !this.isInsideGrid(c,h,u,d)||!o&&this.grid.hitTest(c,h,u,d,n)||_?{box:[],offscreen:!1}:{box:[c,h,u,d],offscreen:this.isOffscreen(c,h,u,d)}}placeCollisionCircles(t,i,o,a,r,n,s,l,c,h,u,d,_,m){const p=[],f=this.transform.elevation,g=f?e=>f.getAtTileOffset(m,e.x,e.y):e=>0,v=new e.Point(i.anchorX,i.anchorY),x=g(v),y=this.projectAndGetPerspectiveRatio(n,v.x,v.y,x),{perspectiveRatio:b}=y,w=(h?r/b:r*b)/e.ONE_EM,T=Y(v,s,x).point,E=y.signedDistanceFromCamera>0?te(w,a,i.lineOffsetX*w,i.lineOffsetY*w,!1,T,v,i,o,s,{},f&&!h?g:null,h&&!!f):null;let C=!1,S=!1,I=!0;if(E&&!y.aboveHorizon){const i=.5*d*b+_,o=new e.Point(-100,-100),a=new e.Point(this.screenRightBoundary,this.screenBottomBoundary),r=new X,n=E.first,s=E.last;let h=[];for(let e=n.path.length-1;e>=1;e--)h.push(n.path[e]);for(let e=1;e<s.path.length;e++)h.push(s.path[e]);const m=2.5*i;if(l){const e=h.map(f?(e,t)=>{const i=g(t<n.path.length-1?n.tilePath[n.path.length-1-t]:s.tilePath[t-n.path.length+2]);return Y(e,l,i)}:e=>Y(e,l));h=e.some(e=>e.signedDistanceFromCamera<=0)?[]:e.map(e=>e.point);}let v=[];if(h.length>0){const t=h[0].clone(),i=h[0].clone();for(let e=1;e<h.length;e++)t.x=Math.min(t.x,h[e].x),t.y=Math.min(t.y,h[e].y),i.x=Math.max(i.x,h[e].x),i.y=Math.max(i.y,h[e].y);v=t.x>=o.x&&i.x<=a.x&&t.y>=o.y&&i.y<=a.y?[h]:i.x<o.x||t.x>a.x||i.y<o.y||t.y>a.y?[]:e.clipLine([h],o.x,o.y,a.x,a.y);}for(const e of v){r.reset(e,.25*i);let o=0;o=r.length<=.5*i?1:Math.ceil(r.paddedLength/m)+1;for(let e=0;e<o;e++){const a=e/Math.max(o-1,1),n=r.lerp(a),s=n.x+100,l=n.y+100;p.push(s,l,i,0);const h=s-i,d=l-i,_=s+i,m=l+i;if(I=I&&this.isOffscreen(h,d,_,m),S=S||this.isInsideGrid(h,d,_,m),!t&&this.grid.hitTestCircle(s,l,i,u)&&(C=!0,!c))return {circles:[],offscreen:!1,collisionDetected:C}}}}return {circles:!c&&C||!S?[]:p,offscreen:I,collisionDetected:C}}queryRenderedSymbols(t){if(0===t.length||0===this.grid.keysLength()&&0===this.ignoredGrid.keysLength())return {};const i=[];let o=1/0,a=1/0,r=-1/0,n=-1/0;for(const s of t){const t=new e.Point(s.x+100,s.y+100);o=Math.min(o,t.x),a=Math.min(a,t.y),r=Math.max(r,t.x),n=Math.max(n,t.y),i.push(t);}const s=this.grid.query(o,a,r,n).concat(this.ignoredGrid.query(o,a,r,n)),l={},c={};for(const t of s){const o=t.key;if(void 0===l[o.bucketInstanceId]&&(l[o.bucketInstanceId]={}),l[o.bucketInstanceId][o.featureIndex])continue;const a=[new e.Point(t.x1,t.y1),new e.Point(t.x2,t.y1),new e.Point(t.x2,t.y2),new e.Point(t.x1,t.y2)];e.polygonIntersectsPolygon(i,a)&&(l[o.bucketInstanceId][o.featureIndex]=!0,void 0===c[o.bucketInstanceId]&&(c[o.bucketInstanceId]=[]),c[o.bucketInstanceId].push(o.featureIndex));}return c}insertCollisionBox(e,t,i,o,a){(t?this.ignoredGrid:this.grid).insert({bucketInstanceId:i,featureIndex:o,collisionGroupID:a},e[0],e[1],e[2],e[3]);}insertCollisionCircles(e,t,i,o,a){const r=t?this.ignoredGrid:this.grid,n={bucketInstanceId:i,featureIndex:o,collisionGroupID:a};for(let t=0;t<e.length;t+=4)r.insertCircle(n,e[t],e[t+1],e[t+2]);}projectAndGetPerspectiveRatio(t,i,o,a){const r=[i,o,a||0,1];let n=!1;return a||this.transform.pitch>0?(e.transformMat4(r,r,t),n=r[2]>r[3]):le(r,r,t),{point:new e.Point((r[0]/r[3]+1)/2*this.transform.width+100,(-r[1]/r[3]+1)/2*this.transform.height+100),perspectiveRatio:Math.min(.5+this.transform.cameraToCenterDistance/r[3]*.5,1.5),signedDistanceFromCamera:r[3],aboveHorizon:n}}isOffscreen(e,t,i,o){return i<100||e>=this.screenRightBoundary||o<100||t>this.screenBottomBoundary}isInsideGrid(e,t,i,o){return i>=0&&e<this.gridRightBoundary&&o>=0&&t<this.gridBottomBoundary}getViewportMatrix(){const t=e.identity([]);return e.translate(t,t,[-100,-100,0]),t}}class he{constructor(e,t,i,o){this.opacity=e?Math.max(0,Math.min(1,e.opacity+(e.placed?t:-t))):o&&i?1:0,this.placed=i;}isHidden(){return 0===this.opacity&&!this.placed}}class ue{constructor(e,t,i,o,a){this.text=new he(e?e.text:null,t,i,a),this.icon=new he(e?e.icon:null,t,o,a);}isHidden(){return this.text.isHidden()&&this.icon.isHidden()}}class de{constructor(e,t,i){this.text=e,this.icon=t,this.skipFade=i;}}class _e{constructor(){this.invProjMatrix=e.create(),this.viewportMatrix=e.create(),this.circles=[];}}class me{constructor(e,t,i,o,a){this.bucketInstanceId=e,this.featureIndex=t,this.sourceLayerIndex=i,this.bucketIndex=o,this.tileID=a;}}class pe{constructor(e){this.crossSourceCollisions=e,this.maxGroupID=0,this.collisionGroups={};}get(e){if(this.crossSourceCollisions)return {ID:0,predicate:null};if(!this.collisionGroups[e]){const t=++this.maxGroupID;this.collisionGroups[e]={ID:t,predicate:e=>e.collisionGroupID===t};}return this.collisionGroups[e]}}function fe(t,i,o,a,r){const{horizontalAlign:n,verticalAlign:s}=e.getAnchorAlignment(t),l=-(n-.5)*i,c=-(s-.5)*o,h=e.evaluateVariableOffset(t,a);return new e.Point(l+h[0]*r,c+h[1]*r)}function ge(t,i,o,a,r){const n=new e.Point(t,i);return o&&n._rotate(a?r:-r),n}class ve{constructor(e,t,i,o){this.transform=e.clone(),this.collisionIndex=new ce(this.transform),this.placements={},this.opacities={},this.variableOffsets={},this.stale=!1,this.commitTime=0,this.fadeDuration=t,this.retainedQueryData={},this.collisionGroups=new pe(i),this.collisionCircleArrays={},this.prevPlacement=o,o&&(o.prevPlacement=void 0),this.placedOrientations={};}getBucketParts(t,i,o,a){const r=o.getBucket(i),n=o.latestFeatureIndex;if(!r||!n||i.id!==r.layerIds[0])return;const s=o.collisionBoxArray,l=r.layers[0].layout,c=Math.pow(2,this.transform.zoom-o.tileID.overscaledZ),h=o.tileSize/e.EXTENT,u=this.transform.calculatePosMatrix(o.tileID.toUnwrapped()),d="map"===l.get("text-pitch-alignment"),_="map"===l.get("text-rotation-alignment"),m=v(o,1,this.transform.zoom),p=H(u,d,_,this.transform,m);let f=null;if(d){const t=K(u,d,_,this.transform,m);f=e.multiply([],this.transform.labelPlaneMatrix,t);}this.retainedQueryData[r.bucketInstanceId]=new me(r.bucketInstanceId,n,r.sourceLayerIndex,r.index,o.tileID);const g={bucket:r,layout:l,posMatrix:u,textLabelPlaneMatrix:p,labelToScreenMatrix:f,scale:c,textPixelRatio:h,holdingForFade:o.holdingForFade(),collisionBoxArray:s,partiallyEvaluatedTextSize:e.evaluateSizeForZoom(r.textSizeData,this.transform.zoom),partiallyEvaluatedIconSize:e.evaluateSizeForZoom(r.iconSizeData,this.transform.zoom),collisionGroup:this.collisionGroups.get(r.sourceID)};if(a)for(const e of r.sortKeyRanges){const{sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:a}=e;t.push({sortKey:i,symbolInstanceStart:o,symbolInstanceEnd:a,parameters:g});}else t.push({symbolInstanceStart:0,symbolInstanceEnd:r.symbolInstances.length,parameters:g});}attemptAnchorPlacement(e,t,i,o,a,r,n,s,l,c,h,u,d,_,m,p,f,g){const v=[u.textOffset0,u.textOffset1],x=_.getSymbolInstanceTextSize(f,u,this.transform.zoom,d),y=fe(e,i,o,v,a),b=this.collisionIndex.placeCollisionBox(x,t,ge(y.x,y.y,r,n,this.transform.angle),h,s,l,c.predicate);if((!p||0!==this.collisionIndex.placeCollisionBox(_.getSymbolInstanceIconSize(g,this.transform.zoom,d),p,ge(y.x,y.y,r,n,this.transform.angle),h,s,l,c.predicate).box.length)&&b.box.length>0){let t;return this.prevPlacement&&this.prevPlacement.variableOffsets[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID]&&this.prevPlacement.placements[u.crossTileID].text&&(t=this.prevPlacement.variableOffsets[u.crossTileID].anchor),this.variableOffsets[u.crossTileID]={textOffset:v,width:i,height:o,anchor:e,textBoxScale:a,prevAnchor:t},this.markUsedJustification(_,e,u,m),_.allowVerticalPlacement&&(this.markUsedOrientation(_,m,u),this.placedOrientations[u.crossTileID]=m),{shift:y,placedGlyphBoxes:b}}}placeLayerBucketPart(t,i,o){const{bucket:a,layout:r,posMatrix:n,textLabelPlaneMatrix:s,labelToScreenMatrix:l,textPixelRatio:c,holdingForFade:h,collisionBoxArray:u,partiallyEvaluatedTextSize:d,partiallyEvaluatedIconSize:_,collisionGroup:m}=t.parameters,p=r.get("text-optional"),f=r.get("icon-optional"),g=r.get("text-allow-overlap"),v=r.get("icon-allow-overlap"),x="map"===r.get("text-rotation-alignment"),y="map"===r.get("text-pitch-alignment"),b="none"!==r.get("icon-text-fit"),w="viewport-y"===r.get("symbol-z-order"),T=g&&(v||!a.hasIconData()||f),E=v&&(g||!a.hasTextData()||p);!a.collisionArrays&&u&&a.deserializeCollisionBoxes(u),o&&a.updateCollisionDebugBuffers(this.transform.zoom,u);const C=(t,u,w)=>{if(i[t.crossTileID])return;if(h)return void(this.placements[t.crossTileID]=new de(!1,!1,!1));let C=!1,S=!1,I=!0,P=null,M={box:null,offscreen:null},z={box:null,offscreen:null},A=null,D=null,L=null,R=0,k=0,B=0;w.textFeatureIndex?R=w.textFeatureIndex:t.useRuntimeCollisionCircles&&(R=t.featureIndex),w.verticalTextFeatureIndex&&(k=w.verticalTextFeatureIndex);const F=e=>{(this.transform.elevation||e.elevation)&&(e.elevation=this.transform.elevation?this.transform.elevation.getAtTileOffset(this.retainedQueryData[a.bucketInstanceId].tileID,e.anchorPointX,e.anchorPointY):0);},O=w.textBox;if(O){F(O);const i=i=>{let o=e.WritingMode.horizontal;if(a.allowVerticalPlacement&&!i&&this.prevPlacement){const e=this.prevPlacement.placedOrientations[t.crossTileID];e&&(this.placedOrientations[t.crossTileID]=e,o=e,this.markUsedOrientation(a,o,t));}return o},o=(i,o)=>{if(a.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&w.verticalTextBox){for(const t of a.writingModes)if(t===e.WritingMode.vertical?(M=o(),z=M):M=i(),M&&M.box&&M.box.length)break}else M=i();};if(r.get("text-variable-anchor")){let s=r.get("text-variable-anchor");if(this.prevPlacement&&this.prevPlacement.variableOffsets[t.crossTileID]){const e=this.prevPlacement.variableOffsets[t.crossTileID];s.indexOf(e.anchor)>0&&(s=s.filter(t=>t!==e.anchor),s.unshift(e.anchor));}const l=(e,i,o)=>{const r=t.textBoxScale,l=(e.x2-e.x1)*r+2*e.padding,h=(e.y2-e.y1)*r+2*e.padding,p=b&&!v?i:null;p&&F(p);let f={box:[],offscreen:!1};const w=g?2*s.length:s.length;for(let i=0;i<w;++i){const g=this.attemptAnchorPlacement(s[i%s.length],e,l,h,r,x,y,c,n,m,i>=s.length,t,u,a,o,p,d,_);if(g&&(f=g.placedGlyphBoxes,f&&f.box&&f.box.length)){C=!0,P=g.shift;break}}return f};o(()=>l(O,w.iconBox,e.WritingMode.horizontal),()=>{const i=w.verticalTextBox;return i&&F(i),a.allowVerticalPlacement&&!(M&&M.box&&M.box.length)&&t.numVerticalGlyphVertices>0&&i?l(i,w.verticalIconBox,e.WritingMode.vertical):{box:null,offscreen:null}}),M&&(C=M.box,I=M.offscreen);const h=i(M&&M.box);if(!C&&this.prevPlacement){const e=this.prevPlacement.variableOffsets[t.crossTileID];e&&(this.variableOffsets[t.crossTileID]=e,this.markUsedJustification(a,e.anchor,t,h));}}else {const r=(i,o)=>{const r=a.getSymbolInstanceTextSize(d,t,this.transform.zoom,u),s=this.collisionIndex.placeCollisionBox(r,i,new e.Point(0,0),g,c,n,m.predicate);return s&&s.box&&s.box.length&&(this.markUsedOrientation(a,o,t),this.placedOrientations[t.crossTileID]=o),s};o(()=>r(O,e.WritingMode.horizontal),()=>{const i=w.verticalTextBox;return a.allowVerticalPlacement&&t.numVerticalGlyphVertices>0&&i?(F(i),r(i,e.WritingMode.vertical)):{box:null,offscreen:null}}),i(M&&M.box&&M.box.length);}}if(A=M,C=A&&A.box&&A.box.length>0,I=A&&A.offscreen,t.useRuntimeCollisionCircles){const i=a.text.placedSymbolArray.get(t.centerJustifiedTextSymbolIndex),c=e.evaluateSizeForFeature(a.textSizeData,d,i),h=r.get("text-padding");D=this.collisionIndex.placeCollisionCircles(g,i,a.lineVertexArray,a.glyphOffsetArray,c,n,s,l,o,y,m.predicate,t.collisionCircleDiameter,h,this.retainedQueryData[a.bucketInstanceId].tileID),C=g||D.circles.length>0&&!D.collisionDetected,I=I&&D.offscreen;}if(w.iconFeatureIndex&&(B=w.iconFeatureIndex),w.iconBox){const t=t=>{F(t);const i=b&&P?ge(P.x,P.y,x,y,this.transform.angle):new e.Point(0,0),o=a.getSymbolInstanceIconSize(_,this.transform.zoom,u);return this.collisionIndex.placeCollisionBox(o,t,i,v,c,n,m.predicate)};z&&z.box&&z.box.length&&w.verticalIconBox?(L=t(w.verticalIconBox),S=L.box.length>0):(L=t(w.iconBox),S=L.box.length>0),I=I&&L.offscreen;}const U=p||0===t.numHorizontalGlyphVertices&&0===t.numVerticalGlyphVertices,N=f||0===t.numIconVertices;if(U||N?N?U||(S=S&&C):C=S&&C:S=C=S&&C,C&&A&&A.box&&this.collisionIndex.insertCollisionBox(A.box,r.get("text-ignore-placement"),a.bucketInstanceId,z&&z.box&&k?k:R,m.ID),S&&L&&this.collisionIndex.insertCollisionBox(L.box,r.get("icon-ignore-placement"),a.bucketInstanceId,B,m.ID),D&&(C&&this.collisionIndex.insertCollisionCircles(D.circles,r.get("text-ignore-placement"),a.bucketInstanceId,R,m.ID),o)){const e=a.bucketInstanceId;let t=this.collisionCircleArrays[e];void 0===t&&(t=this.collisionCircleArrays[e]=new _e);for(let e=0;e<D.circles.length;e+=4)t.circles.push(D.circles[e+0]),t.circles.push(D.circles[e+1]),t.circles.push(D.circles[e+2]),t.circles.push(D.collisionDetected?1:0);}this.placements[t.crossTileID]=new de(C||T,S||E,I||a.justReloaded),i[t.crossTileID]=!0;};if(w){const e=a.getSortedSymbolIndexes(this.transform.angle);for(let t=e.length-1;t>=0;--t){const i=e[t];C(a.symbolInstances.get(i),i,a.collisionArrays[i]);}}else for(let e=t.symbolInstanceStart;e<t.symbolInstanceEnd;e++)C(a.symbolInstances.get(e),e,a.collisionArrays[e]);if(o&&a.bucketInstanceId in this.collisionCircleArrays){const t=this.collisionCircleArrays[a.bucketInstanceId];e.invert(t.invProjMatrix,n),t.viewportMatrix=this.collisionIndex.getViewportMatrix();}a.justReloaded=!1;}markUsedJustification(t,i,o,a){let r;r=a===e.WritingMode.vertical?o.verticalPlacedTextSymbolIndex:{left:o.leftJustifiedTextSymbolIndex,center:o.centerJustifiedTextSymbolIndex,right:o.rightJustifiedTextSymbolIndex}[e.getAnchorJustification(i)];const n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex,o.verticalPlacedTextSymbolIndex];for(const e of n)e>=0&&(t.text.placedSymbolArray.get(e).crossTileID=r>=0&&e!==r?0:o.crossTileID);}markUsedOrientation(t,i,o){const a=i===e.WritingMode.horizontal||i===e.WritingMode.horizontalOnly?i:0,r=i===e.WritingMode.vertical?i:0,n=[o.leftJustifiedTextSymbolIndex,o.centerJustifiedTextSymbolIndex,o.rightJustifiedTextSymbolIndex];for(const e of n)t.text.placedSymbolArray.get(e).placedOrientation=a;o.verticalPlacedTextSymbolIndex&&(t.text.placedSymbolArray.get(o.verticalPlacedTextSymbolIndex).placedOrientation=r);}commit(e){this.commitTime=e,this.zoomAtLastRecencyCheck=this.transform.zoom;const t=this.prevPlacement;let i=!1;this.prevZoomAdjustment=t?t.zoomAdjustment(this.transform.zoom):0;const o=t?t.symbolFadeChange(e):1,a=t?t.opacities:{},r=t?t.variableOffsets:{},n=t?t.placedOrientations:{};for(const e in this.placements){const t=this.placements[e],r=a[e];r?(this.opacities[e]=new ue(r,o,t.text,t.icon),i=i||t.text!==r.text.placed||t.icon!==r.icon.placed):(this.opacities[e]=new ue(null,o,t.text,t.icon,t.skipFade),i=i||t.text||t.icon);}for(const e in a){const t=a[e];if(!this.opacities[e]){const a=new ue(t,o,!1,!1);a.isHidden()||(this.opacities[e]=a,i=i||t.text.placed||t.icon.placed);}}for(const e in r)this.variableOffsets[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.variableOffsets[e]=r[e]);for(const e in n)this.placedOrientations[e]||!this.opacities[e]||this.opacities[e].isHidden()||(this.placedOrientations[e]=n[e]);i?this.lastPlacementChangeTime=e:"number"!=typeof this.lastPlacementChangeTime&&(this.lastPlacementChangeTime=t?t.lastPlacementChangeTime:e);}updateLayerOpacities(e,t){const i={};for(const o of t){const t=o.getBucket(e);t&&o.latestFeatureIndex&&e.id===t.layerIds[0]&&this.updateBucketOpacities(t,i,o.collisionBoxArray);}}updateBucketOpacities(t,i,o){t.hasTextData()&&t.text.opacityVertexArray.clear(),t.hasIconData()&&t.icon.opacityVertexArray.clear(),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexArray.clear(),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexArray.clear();const a=t.layers[0].layout,r=new ue(null,0,!1,!1,!0),n=a.get("text-allow-overlap"),s=a.get("icon-allow-overlap"),l=a.get("text-variable-anchor"),c="map"===a.get("text-rotation-alignment"),h="map"===a.get("text-pitch-alignment"),u="none"!==a.get("icon-text-fit"),d=new ue(null,0,n&&(s||!t.hasIconData()||a.get("icon-optional")),s&&(n||!t.hasTextData()||a.get("text-optional")),!0);!t.collisionArrays&&o&&(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData())&&t.deserializeCollisionBoxes(o);const _=(e,t,i)=>{for(let o=0;o<t/4;o++)e.opacityVertexArray.emplaceBack(i);};for(let o=0;o<t.symbolInstances.length;o++){const a=t.symbolInstances.get(o),{numHorizontalGlyphVertices:n,numVerticalGlyphVertices:s,crossTileID:m}=a;let p=this.opacities[m];i[m]?p=r:p||(p=d,this.opacities[m]=p),i[m]=!0;const f=a.numIconVertices>0,g=this.placedOrientations[a.crossTileID],v=g===e.WritingMode.vertical,x=g===e.WritingMode.horizontal||g===e.WritingMode.horizontalOnly;if(n>0||s>0){const e=Ie(p.text);_(t.text,n,v?Pe:e),_(t.text,s,x?Pe:e);const i=p.text.isHidden();[a.rightJustifiedTextSymbolIndex,a.centerJustifiedTextSymbolIndex,a.leftJustifiedTextSymbolIndex].forEach(e=>{e>=0&&(t.text.placedSymbolArray.get(e).hidden=i||v?1:0);}),a.verticalPlacedTextSymbolIndex>=0&&(t.text.placedSymbolArray.get(a.verticalPlacedTextSymbolIndex).hidden=i||x?1:0);const o=this.variableOffsets[a.crossTileID];o&&this.markUsedJustification(t,o.anchor,a,g);const r=this.placedOrientations[a.crossTileID];r&&(this.markUsedJustification(t,"left",a,r),this.markUsedOrientation(t,r,a));}if(f){const e=Ie(p.icon),i=!(u&&a.verticalPlacedIconSymbolIndex&&v);a.placedIconSymbolIndex>=0&&(_(t.icon,a.numIconVertices,i?e:Pe),t.icon.placedSymbolArray.get(a.placedIconSymbolIndex).hidden=p.icon.isHidden()),a.verticalPlacedIconSymbolIndex>=0&&(_(t.icon,a.numVerticalIconVertices,i?Pe:e),t.icon.placedSymbolArray.get(a.verticalPlacedIconSymbolIndex).hidden=p.icon.isHidden());}if(t.hasIconCollisionBoxData()||t.hasTextCollisionBoxData()){const i=t.collisionArrays[o];if(i){let o=new e.Point(0,0);if(i.textBox||i.verticalTextBox){let e=!0;if(l){const t=this.variableOffsets[m];t?(o=fe(t.anchor,t.width,t.height,t.textOffset,t.textBoxScale),c&&o._rotate(h?this.transform.angle:-this.transform.angle)):e=!1;}i.textBox&&xe(t.textCollisionBox.collisionVertexArray,p.text.placed,!e||v,o.x,o.y),i.verticalTextBox&&xe(t.textCollisionBox.collisionVertexArray,p.text.placed,!e||x,o.x,o.y);}const a=Boolean(!x&&i.verticalIconBox);i.iconBox&&xe(t.iconCollisionBox.collisionVertexArray,p.icon.placed,a,u?o.x:0,u?o.y:0),i.verticalIconBox&&xe(t.iconCollisionBox.collisionVertexArray,p.icon.placed,!a,u?o.x:0,u?o.y:0);}}}if(t.sortFeatures(this.transform.angle),this.retainedQueryData[t.bucketInstanceId]&&(this.retainedQueryData[t.bucketInstanceId].featureSortOrder=t.featureSortOrder),t.hasTextData()&&t.text.opacityVertexBuffer&&t.text.opacityVertexBuffer.updateData(t.text.opacityVertexArray),t.hasIconData()&&t.icon.opacityVertexBuffer&&t.icon.opacityVertexBuffer.updateData(t.icon.opacityVertexArray),t.hasIconCollisionBoxData()&&t.iconCollisionBox.collisionVertexBuffer&&t.iconCollisionBox.collisionVertexBuffer.updateData(t.iconCollisionBox.collisionVertexArray),t.hasTextCollisionBoxData()&&t.textCollisionBox.collisionVertexBuffer&&t.textCollisionBox.collisionVertexBuffer.updateData(t.textCollisionBox.collisionVertexArray),t.bucketInstanceId in this.collisionCircleArrays){const e=this.collisionCircleArrays[t.bucketInstanceId];t.placementInvProjMatrix=e.invProjMatrix,t.placementViewportMatrix=e.viewportMatrix,t.collisionCircleArray=e.circles,delete this.collisionCircleArrays[t.bucketInstanceId];}}symbolFadeChange(e){return 0===this.fadeDuration?1:(e-this.commitTime)/this.fadeDuration+this.prevZoomAdjustment}zoomAdjustment(e){return Math.max(0,(this.transform.zoom-e)/1.5)}hasTransitions(e){return this.stale||e-this.lastPlacementChangeTime<this.fadeDuration}stillRecent(e,t){const i=this.zoomAtLastRecencyCheck===t?1-this.zoomAdjustment(t):1;return this.zoomAtLastRecencyCheck=t,this.commitTime+this.fadeDuration*i>e}setStale(){this.stale=!0;}}function xe(e,t,i,o,a){e.emplaceBack(t?1:0,i?1:0,o||0,a||0),e.emplaceBack(t?1:0,i?1:0,o||0,a||0),e.emplaceBack(t?1:0,i?1:0,o||0,a||0),e.emplaceBack(t?1:0,i?1:0,o||0,a||0);}const ye=Math.pow(2,25),be=Math.pow(2,24),we=Math.pow(2,17),Te=Math.pow(2,16),Ee=Math.pow(2,9),Ce=Math.pow(2,8),Se=Math.pow(2,1);function Ie(e){if(0===e.opacity&&!e.placed)return 0;if(1===e.opacity&&e.placed)return 4294967295;const t=e.placed?1:0,i=Math.floor(127*e.opacity);return i*ye+t*be+i*we+t*Te+i*Ee+t*Ce+i*Se+t}const Pe=0;class Me{constructor(e){this._sortAcrossTiles="viewport-y"!==e.layout.get("symbol-z-order")&&void 0!==e.layout.get("symbol-sort-key").constantOr(1),this._currentTileIndex=0,this._currentPartIndex=0,this._seenCrossTileIDs={},this._bucketParts=[];}continuePlacement(e,t,i,o,a){const r=this._bucketParts;for(;this._currentTileIndex<e.length;)if(t.getBucketParts(r,o,e[this._currentTileIndex],this._sortAcrossTiles),this._currentTileIndex++,a())return !0;for(this._sortAcrossTiles&&(this._sortAcrossTiles=!1,r.sort((e,t)=>e.sortKey-t.sortKey));this._currentPartIndex<r.length;)if(t.placeLayerBucketPart(r[this._currentPartIndex],this._seenCrossTileIDs,i),this._currentPartIndex++,a())return !0;return !1}}class ze{constructor(e,t,i,o,a,r,n){this.placement=new ve(e,a,r,n),this._currentPlacementIndex=t.length-1,this._forceFullPlacement=i,this._showCollisionBoxes=o,this._done=!1;}isDone(){return this._done}continuePlacement(t,i,o){const a=e.browser.now(),r=()=>{const t=e.browser.now()-a;return !this._forceFullPlacement&&t>2};for(;this._currentPlacementIndex>=0;){const e=i[t[this._currentPlacementIndex]],a=this.placement.collisionIndex.transform.zoom;if("symbol"===e.type&&(!e.minzoom||e.minzoom<=a)&&(!e.maxzoom||e.maxzoom>a)){if(this._inProgressLayer||(this._inProgressLayer=new Me(e)),this._inProgressLayer.continuePlacement(o[e.source],this.placement,this._showCollisionBoxes,e,r))return;delete this._inProgressLayer;}this._currentPlacementIndex--;}this._done=!0;}commit(e){return this.placement.commit(e),this.placement}}const Ae=512/e.EXTENT/2;class De{constructor(e,t,i){this.tileID=e,this.indexedSymbolInstances={},this.bucketInstanceId=i;for(let i=0;i<t.length;i++){const o=t.get(i),a=o.key;this.indexedSymbolInstances[a]||(this.indexedSymbolInstances[a]=[]),this.indexedSymbolInstances[a].push({crossTileID:o.crossTileID,coord:this.getScaledCoordinates(o,e)});}}getScaledCoordinates(t,i){const o=Ae/Math.pow(2,i.canonical.z-this.tileID.canonical.z);return {x:Math.floor((i.canonical.x*e.EXTENT+t.anchorX)*o),y:Math.floor((i.canonical.y*e.EXTENT+t.anchorY)*o)}}findMatches(e,t,i){const o=this.tileID.canonical.z<t.canonical.z?1:Math.pow(2,this.tileID.canonical.z-t.canonical.z);for(let a=0;a<e.length;a++){const r=e.get(a);if(r.crossTileID)continue;const n=this.indexedSymbolInstances[r.key];if(!n)continue;const s=this.getScaledCoordinates(r,t);for(const e of n)if(Math.abs(e.coord.x-s.x)<=o&&Math.abs(e.coord.y-s.y)<=o&&!i[e.crossTileID]){i[e.crossTileID]=!0,r.crossTileID=e.crossTileID;break}}}}class Le{constructor(){this.maxCrossTileID=0;}generate(){return ++this.maxCrossTileID}}class Re{constructor(){this.indexes={},this.usedCrossTileIDs={},this.lng=0;}handleWrapJump(e){const t=Math.round((e-this.lng)/360);if(0!==t)for(const e in this.indexes){const i=this.indexes[e],o={};for(const e in i){const a=i[e];a.tileID=a.tileID.unwrapTo(a.tileID.wrap+t),o[a.tileID.key]=a;}this.indexes[e]=o;}this.lng=e;}addBucket(e,t,i){if(this.indexes[e.overscaledZ]&&this.indexes[e.overscaledZ][e.key]){if(this.indexes[e.overscaledZ][e.key].bucketInstanceId===t.bucketInstanceId)return !1;this.removeBucketCrossTileIDs(e.overscaledZ,this.indexes[e.overscaledZ][e.key]);}for(let e=0;e<t.symbolInstances.length;e++)t.symbolInstances.get(e).crossTileID=0;this.usedCrossTileIDs[e.overscaledZ]||(this.usedCrossTileIDs[e.overscaledZ]={});const o=this.usedCrossTileIDs[e.overscaledZ];for(const i in this.indexes){const a=this.indexes[i];if(Number(i)>e.overscaledZ)for(const i in a){const r=a[i];r.tileID.isChildOf(e)&&r.findMatches(t.symbolInstances,e,o);}else {const r=a[e.scaledTo(Number(i)).key];r&&r.findMatches(t.symbolInstances,e,o);}}for(let e=0;e<t.symbolInstances.length;e++){const a=t.symbolInstances.get(e);a.crossTileID||(a.crossTileID=i.generate(),o[a.crossTileID]=!0);}return void 0===this.indexes[e.overscaledZ]&&(this.indexes[e.overscaledZ]={}),this.indexes[e.overscaledZ][e.key]=new De(e,t.symbolInstances,t.bucketInstanceId),!0}removeBucketCrossTileIDs(e,t){for(const i in t.indexedSymbolInstances)for(const o of t.indexedSymbolInstances[i])delete this.usedCrossTileIDs[e][o.crossTileID];}removeStaleBuckets(e){let t=!1;for(const i in this.indexes){const o=this.indexes[i];for(const a in o)e[o[a].bucketInstanceId]||(this.removeBucketCrossTileIDs(i,o[a]),delete o[a],t=!0);}return t}}class ke{constructor(){this.layerIndexes={},this.crossTileIDs=new Le,this.maxBucketInstanceId=0,this.bucketsInCurrentPlacement={};}addLayer(e,t,i){let o=this.layerIndexes[e.id];void 0===o&&(o=this.layerIndexes[e.id]=new Re);let a=!1;const r={};o.handleWrapJump(i);for(const i of t){const t=i.getBucket(e);t&&e.id===t.layerIds[0]&&(t.bucketInstanceId||(t.bucketInstanceId=++this.maxBucketInstanceId),o.addBucket(i.tileID,t,this.crossTileIDs)&&(a=!0),r[t.bucketInstanceId]=!0);}return o.removeStaleBuckets(r)&&(a=!0),a}pruneUnusedLayers(e){const t={};e.forEach(e=>{t[e]=!0;});for(const e in this.layerIndexes)t[e]||delete this.layerIndexes[e];}}const Be=(t,i)=>e.emitValidationErrors(t,i&&i.filter(e=>"source.canvas"!==e.identifier)),Fe=e.pick(U,["addLayer","removeLayer","setPaintProperty","setLayoutProperty","setFilter","addSource","removeSource","setLayerZoomRange","setLight","setTransition","setGeoJSONSourceData","setTerrain"]),Oe=e.pick(U,["setCenter","setZoom","setBearing","setPitch"]),Ue=function(){const t={},i=e.styleSpec.$version;for(const o in e.styleSpec.$root){const a=e.styleSpec.$root[o];if(a.required){let e=null;e="version"===o?i:"array"===a.type?[]:{},null!=e&&(t[o]=e);}}return t}(),Ne={fill:!0,line:!0,background:!0,hillshade:!0,raster:!0};class Ze extends e.Evented{constructor(t,i={}){super(),this.map=t,this.dispatcher=new g(B(),this),this.imageManager=new u,this.imageManager.setEventedParent(this),this.glyphManager=new e.GlyphManager(t._requestManager,i.localFontFamily?e.LocalGlyphMode.all:i.localIdeographFontFamily?e.LocalGlyphMode.ideographs:e.LocalGlyphMode.none,i.localFontFamily||i.localIdeographFontFamily),this.lineAtlas=new f(256,512),this.crossTileSymbolIndex=new ke,this._layers={},this._num3DLayers=0,this._numSymbolLayers=0,this._numCircleLayers=0,this._serializedLayers={},this._sourceCaches={},this._otherSourceCaches={},this._symbolSourceCaches={},this.zoomHistory=new e.ZoomHistory,this._loaded=!1,this._availableImages=[],this._order=[],this._drapedFirstOrder=[],this._resetUpdates(),this.dispatcher.broadcast("setReferrer",e.getReferrer());const o=this;this._rtlTextPluginCallback=Ze.registerForPluginStateChange(t=>{o.dispatcher.broadcast("syncRTLPluginState",{pluginStatus:t.pluginStatus,pluginURL:t.pluginURL},(t,i)=>{if(e.triggerPluginCompletionEvent(t),i&&i.every(e=>e))for(const e in o._sourceCaches){const t=o._sourceCaches[e],i=t.getSource().type;"vector"!==i&&"geojson"!==i||t.reload();}});}),this.on("data",e=>{if("source"!==e.dataType||"metadata"!==e.sourceDataType)return;const t=this.getSource(e.sourceId);if(t&&t.vectorLayerIds)for(const e in this._layers){const i=this._layers[e];i.source===t.id&&this._validateLayer(i);}});}loadURL(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"}));const o="boolean"==typeof i.validate?i.validate:!e.isMapboxURL(t);t=this.map._requestManager.normalizeStyleURL(t,i.accessToken);const a=this.map._requestManager.transformRequest(t,e.ResourceType.Style);this._request=e.getJSON(a,(t,i)=>{this._request=null,t?this.fire(new e.ErrorEvent(t)):i&&this._load(i,o);});}loadJSON(t,i={}){this.fire(new e.Event("dataloading",{dataType:"style"})),this._request=e.browser.frame(()=>{this._request=null,this._load(t,!1!==i.validate);});}loadEmpty(){this.fire(new e.Event("dataloading",{dataType:"style"})),this._load(Ue,!1);}_updateLayerCount(e,t){const i=t?1:-1;e.is3D()&&(this._num3DLayers+=i),"circle"===e.type&&(this._numCircleLayers+=i),"symbol"===e.type&&(this._numSymbolLayers+=i);}_load(t,i){if(i&&Be(this,e.validateStyle(t)))return;this._loaded=!0,this.stylesheet=t;for(const e in t.sources)this.addSource(e,t.sources[e],{validate:!1});this._changed=!1,t.sprite?this._loadSprite(t.sprite):(this.imageManager.setLoaded(!0),this.dispatcher.broadcast("spriteLoaded",!0)),this.glyphManager.setURL(t.glyphs);const o=O(this.stylesheet.layers);this._order=o.map(e=>e.id),this._layers={},this._serializedLayers={};for(let t of o)t=e.createStyleLayer(t),t.setEventedParent(this,{layer:{id:t.id}}),this._layers[t.id]=t,this._serializedLayers[t.id]=t.serialize(),this._updateLayerCount(t,!0);this.dispatcher.broadcast("setLayers",this._serializeLayers(this._order)),this.light=new _(this.stylesheet.light),this.stylesheet.terrain&&this._createTerrain(this.stylesheet.terrain),this._updateDrapeFirstLayers(),this.fire(new e.Event("data",{dataType:"style"})),this.fire(new e.Event("style.load"));}_loadSprite(t){this._spriteRequest=function(t,i,o){let a,r,n;const s=e.browser.devicePixelRatio>1?"@2x":"";let l=e.getJSON(i.transformRequest(i.normalizeSpriteURL(t,s,".json"),e.ResourceType.SpriteJSON),(e,t)=>{l=null,n||(n=e,a=t,h());}),c=e.getImage(i.transformRequest(i.normalizeSpriteURL(t,s,".png"),e.ResourceType.SpriteImage),(e,t)=>{c=null,n||(n=e,r=t,h());});function h(){if(n)o(n);else if(a&&r){const t=e.browser.getImageData(r),i={};for(const o in a){const{width:r,height:n,x:s,y:l,sdf:c,pixelRatio:h,stretchX:u,stretchY:d,content:_}=a[o],m=new e.RGBAImage({width:r,height:n});e.RGBAImage.copy(t,m,{x:s,y:l},{x:0,y:0},{width:r,height:n}),i[o]={data:m,pixelRatio:h,sdf:c,stretchX:u,stretchY:d,content:_};}o(null,i);}}return {cancel(){l&&(l.cancel(),l=null),c&&(c.cancel(),c=null);}}}(t,this.map._requestManager,(t,i)=>{if(this._spriteRequest=null,t)this.fire(new e.ErrorEvent(t));else if(i)for(const e in i)this.imageManager.addImage(e,i[e]);this.imageManager.setLoaded(!0),this._availableImages=this.imageManager.listImages(),this.dispatcher.broadcast("setImages",this._availableImages),this.dispatcher.broadcast("spriteLoaded",!0),this.fire(new e.Event("data",{dataType:"style"}));});}_validateLayer(t){const i=this.getSource(t.source);if(!i)return;const o=t.sourceLayer;o&&("geojson"===i.type||i.vectorLayerIds&&-1===i.vectorLayerIds.indexOf(o))&&this.fire(new e.ErrorEvent(new Error(`Source layer "${o}" `+`does not exist on source "${i.id}" `+`as specified by style layer "${t.id}"`)));}loaded(){if(!this._loaded)return !1;if(Object.keys(this._updatedSources).length)return !1;for(const e in this._sourceCaches)if(!this._sourceCaches[e].loaded())return !1;return !!this.imageManager.isLoaded()}_serializeLayers(e){const t=[];for(const i of e){const e=this._layers[i];"custom"!==e.type&&t.push(e.serialize());}return t}hasTransitions(){if(this.light&&this.light.hasTransition())return !0;for(const e in this._sourceCaches)if(this._sourceCaches[e].hasTransition())return !0;for(const e in this._layers)if(this._layers[e].hasTransition())return !0;return !1}get order(){return this.map._optimizeForTerrain&&this.terrain?this._drapedFirstOrder:this._order}isLayerDraped(e){return !!this.terrain&&Ne[e.type]}_checkLoaded(){if(!this._loaded)throw new Error("Style is not done loading")}update(t){if(!this._loaded)return;const i=this._changed;if(this._changed){const e=Object.keys(this._updatedLayers),i=Object.keys(this._removedLayers);(e.length||i.length)&&this._updateWorkerLayers(e,i);for(const e in this._updatedSources){const t=this._updatedSources[e];"reload"===t?this._reloadSource(e):"clear"===t&&this._clearSource(e);}this._updateTilesForChangedImages();for(const e in this._updatedPaintProps)this._layers[e].updateTransitions(t);this.light.updateTransitions(t),this._resetUpdates();}const o={};for(const e in this._sourceCaches){const t=this._sourceCaches[e];o[e]=t.used,t.used=!1;}for(const e of this._order){const i=this._layers[e];if(i.recalculate(t,this._availableImages),!i.isHidden(t.zoom)){const e=this._getLayerSourceCache(i);e&&(e.used=!0);}const o=this.map.painter;if(o){const e=i.getProgramIds();if(!e)continue;const a=i.getProgramConfiguration(t.zoom);for(const t of e)o.useProgram(t,a);}}for(const t in o){const i=this._sourceCaches[t];o[t]!==i.used&&i.getSource().fire(new e.Event("data",{sourceDataType:"visibility",dataType:"source",sourceId:i.getSource().id}));}this.light.recalculate(t),this.terrain&&this.terrain.recalculate(t),this.z=t.zoom,i&&this.fire(new e.Event("data",{dataType:"style"}));}_updateTilesForChangedImages(){const e=Object.keys(this._changedImages);if(e.length){for(const t in this._sourceCaches)this._sourceCaches[t].reloadTilesForDependencies(["icons","patterns"],e);this._changedImages={};}}_updateWorkerLayers(e,t){this.dispatcher.broadcast("updateLayers",{layers:this._serializeLayers(e),removedIds:t});}_resetUpdates(){this._changed=!1,this._updatedLayers={},this._removedLayers={},this._updatedSources={},this._updatedPaintProps={},this._changedImages={};}setState(t){if(this._checkLoaded(),Be(this,e.validateStyle(t)))return !1;(t=e.clone$1(t)).layers=O(t.layers);const i=function(t,i){if(!t)return [{command:U.setStyle,args:[i]}];let o=[];try{if(!e.deepEqual(t.version,i.version))return [{command:U.setStyle,args:[i]}];e.deepEqual(t.center,i.center)||o.push({command:U.setCenter,args:[i.center]}),e.deepEqual(t.zoom,i.zoom)||o.push({command:U.setZoom,args:[i.zoom]}),e.deepEqual(t.bearing,i.bearing)||o.push({command:U.setBearing,args:[i.bearing]}),e.deepEqual(t.pitch,i.pitch)||o.push({command:U.setPitch,args:[i.pitch]}),e.deepEqual(t.sprite,i.sprite)||o.push({command:U.setSprite,args:[i.sprite]}),e.deepEqual(t.glyphs,i.glyphs)||o.push({command:U.setGlyphs,args:[i.glyphs]}),e.deepEqual(t.transition,i.transition)||o.push({command:U.setTransition,args:[i.transition]}),e.deepEqual(t.light,i.light)||o.push({command:U.setLight,args:[i.light]});const a={},r=[];!function(t,i,o,a){let r;for(r in i=i||{},t=t||{})t.hasOwnProperty(r)&&(i.hasOwnProperty(r)||Z(r,o,a));for(r in i)i.hasOwnProperty(r)&&(t.hasOwnProperty(r)?e.deepEqual(t[r],i[r])||("geojson"===t[r].type&&"geojson"===i[r].type&&V(t,i,r)?o.push({command:U.setGeoJSONSourceData,args:[r,i[r].data]}):G(r,i,o,a)):N(r,i,o));}(t.sources,i.sources,r,a);const n=[];t.layers&&t.layers.forEach(e=>{a[e.source]?o.push({command:U.removeLayer,args:[e.id]}):n.push(e);});let s=t.terrain;s&&a[s.source]&&(o.push({command:U.setTerrain,args:[void 0]}),s=void 0),o=o.concat(r),e.deepEqual(s,i.terrain)||o.push({command:U.setTerrain,args:[i.terrain]}),function(t,i,o){i=i||[];const a=(t=t||[]).map(j),r=i.map(j),n=t.reduce($,{}),s=i.reduce($,{}),l=a.slice(),c=Object.create(null);let h,u,d,_,m,p,f;for(h=0,u=0;h<a.length;h++)d=a[h],s.hasOwnProperty(d)?u++:(o.push({command:U.removeLayer,args:[d]}),l.splice(l.indexOf(d,u),1));for(h=0,u=0;h<r.length;h++)d=r[r.length-1-h],l[l.length-1-h]!==d&&(n.hasOwnProperty(d)?(o.push({command:U.removeLayer,args:[d]}),l.splice(l.lastIndexOf(d,l.length-u),1)):u++,p=l[l.length-h],o.push({command:U.addLayer,args:[s[d],p]}),l.splice(l.length-h,0,d),c[d]=!0);for(h=0;h<r.length;h++)if(d=r[h],_=n[d],m=s[d],!c[d]&&!e.deepEqual(_,m))if(e.deepEqual(_.source,m.source)&&e.deepEqual(_["source-layer"],m["source-layer"])&&e.deepEqual(_.type,m.type)){for(f in q(_.layout,m.layout,o,d,null,U.setLayoutProperty),q(_.paint,m.paint,o,d,null,U.setPaintProperty),e.deepEqual(_.filter,m.filter)||o.push({command:U.setFilter,args:[d,m.filter]}),e.deepEqual(_.minzoom,m.minzoom)&&e.deepEqual(_.maxzoom,m.maxzoom)||o.push({command:U.setLayerZoomRange,args:[d,m.minzoom,m.maxzoom]}),_)_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?q(_[f],m[f],o,d,f.slice(6),U.setPaintProperty):e.deepEqual(_[f],m[f])||o.push({command:U.setLayerProperty,args:[d,f,m[f]]}));for(f in m)m.hasOwnProperty(f)&&!_.hasOwnProperty(f)&&"layout"!==f&&"paint"!==f&&"filter"!==f&&"metadata"!==f&&"minzoom"!==f&&"maxzoom"!==f&&(0===f.indexOf("paint.")?q(_[f],m[f],o,d,f.slice(6),U.setPaintProperty):e.deepEqual(_[f],m[f])||o.push({command:U.setLayerProperty,args:[d,f,m[f]]}));}else o.push({command:U.removeLayer,args:[d]}),p=l[l.lastIndexOf(d)+1],o.push({command:U.addLayer,args:[m,p]});}(n,i.layers,o);}catch(e){console.warn("Unable to compute style diff:",e),o=[{command:U.setStyle,args:[i]}];}return o}(this.serialize(),t).filter(e=>!(e.command in Oe));if(0===i.length)return !1;const o=i.filter(e=>!(e.command in Fe));if(o.length>0)throw new Error(`Unimplemented: ${o.map(e=>e.command).join(", ")}.`);return i.forEach(e=>{"setTransition"!==e.command&&this[e.command].apply(this,e.args);}),this.stylesheet=t,!0}addImage(t,i){if(this.getImage(t))return this.fire(new e.ErrorEvent(new Error("An image with this name already exists.")));this.imageManager.addImage(t,i),this._afterImageUpdated(t);}updateImage(e,t){this.imageManager.updateImage(e,t);}getImage(e){return this.imageManager.getImage(e)}removeImage(t){if(!this.getImage(t))return this.fire(new e.ErrorEvent(new Error("No image with this name exists.")));this.imageManager.removeImage(t),this._afterImageUpdated(t);}_afterImageUpdated(t){this._availableImages=this.imageManager.listImages(),this._changedImages[t]=!0,this._changed=!0,this.dispatcher.broadcast("setImages",this._availableImages),this.fire(new e.Event("data",{dataType:"style"}));}listImages(){return this._checkLoaded(),this.imageManager.listImages()}addSource(t,i,o={}){if(this._checkLoaded(),void 0!==this.getSource(t))throw new Error("There is already a source with this ID");if(!i.type)throw new Error(`The type property must be defined, but only the following properties were given: ${Object.keys(i).join(", ")}.`);if(["vector","raster","geojson","video","image"].indexOf(i.type)>=0&&this._validate(e.validateStyle.source,`sources.${t}`,i,null,o))return;this.map&&this.map._collectResourceTiming&&(i.collectResourceTiming=!0);const a=I(t,i,this.dispatcher,this);a.setEventedParent(this,()=>({isSourceLoaded:this.loaded(),source:a.serialize(),sourceId:t}));const r=i=>{const o=(i?"symbol:":"other:")+t,r=this._sourceCaches[o]=new e.SourceCache(o,a,i);(i?this._symbolSourceCaches:this._otherSourceCaches)[t]=r,r.style=this,r.onAdd(this.map);};r(!1),"vector"!==i.type&&"geojson"!==i.type||r(!0),a.onAdd&&a.onAdd(this.map),this._changed=!0;}removeSource(t){this._checkLoaded();const i=this.getSource(t);if(void 0===i)throw new Error("There is no source with this ID");for(const i in this._layers)if(this._layers[i].source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while layer "${i}" is using it.`)));if(this.terrain&&this.terrain.get().source===t)return this.fire(new e.ErrorEvent(new Error(`Source "${t}" cannot be removed while terrain is using it.`)));const o=this._getSourceCaches(t);for(const t of o)delete this._sourceCaches[t.id],delete this._updatedSources[t.id],t.fire(new e.Event("data",{sourceDataType:"metadata",dataType:"source",sourceId:t.getSource().id})),t.setEventedParent(null),t.clearTiles();delete this._otherSourceCaches[t],delete this._symbolSourceCaches[t],i.setEventedParent(null),i.onRemove&&i.onRemove(this.map),this._changed=!0;}setGeoJSONSourceData(e,t){this._checkLoaded(),this.getSource(e).setData(t),this._changed=!0;}getSource(e){const t=this._getSourceCache(e);return t&&t.getSource()}addLayer(t,i,o={}){this._checkLoaded();const a=t.id;if(this.getLayer(a))return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${a}" already exists on this map`)));let r;if("custom"===t.type){if(Be(this,e.validateCustomStyleLayer(t)))return;r=e.createStyleLayer(t);}else {if("object"==typeof t.source&&(this.addSource(a,t.source),t=e.clone$1(t),t=e.extend(t,{source:a})),this._validate(e.validateStyle.layer,`layers.${a}`,t,{arrayIndex:-1},o))return;r=e.createStyleLayer(t),this._validateLayer(r),r.setEventedParent(this,{layer:{id:a}}),this._serializedLayers[r.id]=r.serialize(),this._updateLayerCount(r,!0);}const n=i?this._order.indexOf(i):this._order.length;if(i&&-1===n)return void this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`)));this._order.splice(n,0,a),this._layerOrderChanged=!0,this._layers[a]=r;const s=this._getLayerSourceCache(r);if(this._removedLayers[a]&&r.source&&s&&"custom"!==r.type){const e=this._removedLayers[a];delete this._removedLayers[a],e.type!==r.type?this._updatedSources[r.source]="clear":(this._updatedSources[r.source]="reload",s.pause());}this._updateLayer(r),r.onAdd&&r.onAdd(this.map),this._updateDrapeFirstLayers();}moveLayer(t,i){if(this._checkLoaded(),this._changed=!0,!this._layers[t])return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be moved.`)));if(t===i)return;const o=this._order.indexOf(t);this._order.splice(o,1);const a=i?this._order.indexOf(i):this._order.length;i&&-1===a?this.fire(new e.ErrorEvent(new Error(`Layer with id "${i}" does not exist on this map.`))):(this._order.splice(a,0,t),this._layerOrderChanged=!0,this._updateDrapeFirstLayers());}removeLayer(t){this._checkLoaded();const i=this._layers[t];if(!i)return void this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be removed.`)));i.setEventedParent(null),this._updateLayerCount(i,!1);const o=this._order.indexOf(t);this._order.splice(o,1),this._layerOrderChanged=!0,this._changed=!0,this._removedLayers[t]=i,delete this._layers[t],delete this._serializedLayers[t],delete this._updatedLayers[t],delete this._updatedPaintProps[t],i.onRemove&&i.onRemove(this.map),this._updateDrapeFirstLayers();}getLayer(e){return this._layers[e]}hasLayer(e){return e in this._layers}hasLayerType(e){for(const t in this._layers)if(this._layers[t].type===e)return !0;return !1}setLayerZoomRange(t,i,o){this._checkLoaded();const a=this.getLayer(t);a?a.minzoom===i&&a.maxzoom===o||(null!=i&&(a.minzoom=i),null!=o&&(a.maxzoom=o),this._updateLayer(a)):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot have zoom extent.`)));}setFilter(t,i,o={}){this._checkLoaded();const a=this.getLayer(t);if(a){if(!e.deepEqual(a.filter,i))return null==i?(a.filter=void 0,void this._updateLayer(a)):void(this._validate(e.validateStyle.filter,`layers.${a.id}.filter`,i,null,o)||(a.filter=e.clone$1(i),this._updateLayer(a)))}else this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be filtered.`)));}getFilter(t){return e.clone$1(this.getLayer(t).filter)}setLayoutProperty(t,i,o,a={}){this._checkLoaded();const r=this.getLayer(t);r?e.deepEqual(r.getLayoutProperty(i),o)||(r.setLayoutProperty(i,o,a),this._updateLayer(r)):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be styled.`)));}getLayoutProperty(t,i){const o=this.getLayer(t);if(o)return o.getLayoutProperty(i);this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style.`)));}setPaintProperty(t,i,o,a={}){this._checkLoaded();const r=this.getLayer(t);r?e.deepEqual(r.getPaintProperty(i),o)||(r.setPaintProperty(i,o,a)&&this._updateLayer(r),this._changed=!0,this._updatedPaintProps[t]=!0):this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be styled.`)));}getPaintProperty(e,t){return this.getLayer(e).getPaintProperty(t)}setFeatureState(t,i){this._checkLoaded();const o=t.source,a=t.sourceLayer,r=this.getSource(o);if(void 0===r)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const n=r.type;if("geojson"===n&&a)return void this.fire(new e.ErrorEvent(new Error("GeoJSON sources cannot have a sourceLayer parameter.")));if("vector"===n&&!a)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided.")));const s=this._getSourceCaches(o);for(const e of s)e.setFeatureState(a,t.id,i);}removeFeatureState(t,i){this._checkLoaded();const o=t.source,a=this.getSource(o);if(void 0===a)return void this.fire(new e.ErrorEvent(new Error(`The source '${o}' does not exist in the map's style.`)));const r=a.type,n="vector"===r?t.sourceLayer:void 0;if("vector"===r&&!n)return void this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));if(i&&"string"!=typeof t.id&&"number"!=typeof t.id)return void this.fire(new e.ErrorEvent(new Error("A feature id is required to remove its specific state property.")));const s=this._getSourceCaches(o);for(const e of s)e.removeFeatureState(n,t.id,i);}getFeatureState(t){this._checkLoaded();const i=t.source,o=t.sourceLayer,a=this.getSource(i);if(void 0!==a){if("vector"!==a.type||o)return void 0===t.id&&this.fire(new e.ErrorEvent(new Error("The feature id parameter must be provided."))),this._getSourceCaches(i)[0].getFeatureState(o,t.id);this.fire(new e.ErrorEvent(new Error("The sourceLayer parameter must be provided for vector source types.")));}else this.fire(new e.ErrorEvent(new Error(`The source '${i}' does not exist in the map's style.`)));}getTransition(){return e.extend({duration:300,delay:0},this.stylesheet&&this.stylesheet.transition)}serialize(){const t={};for(const e in this._sourceCaches){const i=this._sourceCaches[e].getSource();t[i.id]||(t[i.id]=i.serialize());}return e.filterObject({version:this.stylesheet.version,name:this.stylesheet.name,metadata:this.stylesheet.metadata,light:this.stylesheet.light,terrain:this.stylesheet.terrain,center:this.stylesheet.center,zoom:this.stylesheet.zoom,bearing:this.stylesheet.bearing,pitch:this.stylesheet.pitch,sprite:this.stylesheet.sprite,glyphs:this.stylesheet.glyphs,transition:this.stylesheet.transition,sources:t,layers:this._serializeLayers(this._order)},e=>void 0!==e)}_updateLayer(e){this._updatedLayers[e.id]=!0;const t=this._getLayerSourceCache(e);e.source&&!this._updatedSources[e.source]&&t&&"raster"!==t.getSource().type&&(this._updatedSources[e.source]="reload",t.pause()),this._changed=!0;}_flattenAndSortRenderedFeatures(e){const t=e=>"fill-extrusion"===this._layers[e].type,i={},o=[];for(let a=this._order.length-1;a>=0;a--){const r=this._order[a];if(t(r)){i[r]=a;for(const t of e){const e=t[r];if(e)for(const t of e)o.push(t);}}}o.sort((e,t)=>t.intersectionZ-e.intersectionZ);const a=[];for(let r=this._order.length-1;r>=0;r--){const n=this._order[r];if(t(n))for(let e=o.length-1;e>=0;e--){const t=o[e].feature;if(i[t.layer.id]<r)break;a.push(t),o.pop();}else for(const t of e){const e=t[n];if(e)for(const t of e)a.push(t.feature);}}return a}queryRenderedFeatures(t,i,o){i&&i.filter&&this._validate(e.validateStyle.filter,"queryRenderedFeatures.filter",i.filter,null,i);const a={};if(i&&i.layers){if(!Array.isArray(i.layers))return this.fire(new e.ErrorEvent(new Error("parameters.layers must be an Array."))),[];for(const t of i.layers){const i=this._layers[t];if(!i)return this.fire(new e.ErrorEvent(new Error(`The layer '${t}' does not exist in the map's style and cannot be queried for features.`))),[];a[i.source]=!0;}}const r=[];i.availableImages=this._availableImages;const n=i&&i.layers?i.layers.some(e=>{const t=this.getLayer(e);return t&&t.is3D()}):this.has3DLayers(),s=x.createFromScreenPoints(t,o);for(const e in this._sourceCaches){const t=this._sourceCaches[e].getSource().id;i.layers&&!a[t]||r.push(M(this._sourceCaches[e],this._layers,this._serializedLayers,s,i,o,n,!!this.map._showQueryGeometry));}return this.placement&&r.push(function(e,t,i,o,a,r,n){const s={},l=r.queryRenderedSymbols(o),c=[];for(const e of Object.keys(l).map(Number))c.push(n[e]);c.sort(A);for(const i of c){const o=i.featureIndex.lookupSymbolFeatures(l[i.bucketInstanceId],t,i.bucketIndex,i.sourceLayerIndex,a.filter,a.layers,a.availableImages,e);for(const e in o){const t=s[e]=s[e]||[],a=o[e];a.sort((e,t)=>{const o=i.featureSortOrder;if(o){const i=o.indexOf(e.featureIndex);return o.indexOf(t.featureIndex)-i}return t.featureIndex-e.featureIndex});for(const e of a)t.push(e);}}for(const t in s)s[t].forEach(o=>{const a=o.feature,r=i(e[t]).getFeatureState(a.layer["source-layer"],a.id);a.source=a.layer.source,a.layer["source-layer"]&&(a.sourceLayer=a.layer["source-layer"]),a.state=r;});return s}(this._layers,this._serializedLayers,this._getLayerSourceCache.bind(this),s.screenGeometry,i,this.placement.collisionIndex,this.placement.retainedQueryData)),this._flattenAndSortRenderedFeatures(r)}querySourceFeatures(t,i){i&&i.filter&&this._validate(e.validateStyle.filter,"querySourceFeatures.filter",i.filter,null,i);const o=this._getSourceCaches(t);let a=[];for(const e of o)a=a.concat(z(e,i));return a}addSourceType(e,t,i){return Ze.getSourceType(e)?i(new Error(`A source type called "${e}" already exists.`)):(Ze.setSourceType(e,t),t.workerSourceURL?void this.dispatcher.broadcast("loadWorkerSource",{name:e,url:t.workerSourceURL},i):i(null,null))}getLight(){return this.light.getLight()}setLight(t,i={}){this._checkLoaded();const o=this.light.getLight();let a=!1;for(const i in t)if(!e.deepEqual(t[i],o[i])){a=!0;break}if(!a)return;const r={now:e.browser.now(),transition:e.extend({duration:300,delay:0},this.stylesheet.transition)};this.light.setLight(t,i),this.light.updateTransitions(r);}setTerrain(t){if(this._checkLoaded(),!t)return delete this.terrain,delete this.stylesheet.terrain,this.dispatcher.broadcast("enableTerrain",!1),void this._force3DLayerUpdate();if("object"==typeof t.source){const i="terrain-dem-src";this.addSource(i,t.source),t=e.clone$1(t),t=e.extend(t,{source:i});}if(!this._validate(e.validateStyle.terrain,"terrain",t)){if(this.terrain){const i=this.terrain,o=i.get();for(const a in t)if(!e.deepEqual(t[a],o[a])){i.set(t),this.stylesheet.terrain=t;const o={now:e.browser.now(),transition:e.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);break}}else this._createTerrain(t);this._updateDrapeFirstLayers();}}_updateDrapeFirstLayers(){if(!this.map._optimizeForTerrain||!this.terrain)return;const e=this._order.filter(e=>this.isLayerDraped(this._layers[e])),t=this._order.filter(e=>!this.isLayerDraped(this._layers[e]));this._drapedFirstOrder=[],this._drapedFirstOrder.push(...e),this._drapedFirstOrder.push(...t);}_createTerrain(t){const i=this.terrain=new p(t);this.stylesheet.terrain=t,this.dispatcher.broadcast("enableTerrain",!0),this._force3DLayerUpdate();const o={now:e.browser.now(),transition:e.extend({duration:0},this.stylesheet.transition)};i.updateTransitions(o);}_force3DLayerUpdate(){for(const e in this._layers){const t=this._layers[e];"fill-extrusion"===t.type&&this._updateLayer(t);}}_validate(t,i,o,a,r={}){return (!r||!1!==r.validate)&&Be(this,t.call(e.validateStyle,e.extend({key:i,style:this.serialize(),value:o,styleSpec:e.styleSpec},a)))}_remove(){this._request&&(this._request.cancel(),this._request=null),this._spriteRequest&&(this._spriteRequest.cancel(),this._spriteRequest=null),e.evented.off("pluginStateChange",this._rtlTextPluginCallback);for(const e in this._layers)this._layers[e].setEventedParent(null);for(const e in this._sourceCaches)this._sourceCaches[e].clearTiles(),this._sourceCaches[e].setEventedParent(null);this.imageManager.setEventedParent(null),this.setEventedParent(null),this.dispatcher.remove();}_clearSource(e){const t=this._getSourceCaches(e);for(const e of t)e.clearTiles();}_reloadSource(e){const t=this._getSourceCaches(e);for(const e of t)e.resume(),e.reload();}_updateSources(e){for(const t in this._sourceCaches)this._sourceCaches[t].update(e);}_generateCollisionBoxes(){for(const e in this._sourceCaches){const t=this._sourceCaches[e];t.resume(),t.reload();}}_updatePlacement(t,i,o,a,r=!1){let n=!1,s=!1;const l={};for(const e of this._order){const i=this._layers[e];if("symbol"!==i.type)continue;if(!l[i.source]){const e=this._getLayerSourceCache(i);if(!e)continue;l[i.source]=e.getRenderableIds(!0).map(t=>e.getTileByID(t)).sort((e,t)=>t.tileID.overscaledZ-e.tileID.overscaledZ||(e.tileID.isLessThan(t.tileID)?-1:1));}const o=this.crossTileSymbolIndex.addLayer(i,l[i.source],t.center.lng);n=n||o;}if(this.crossTileSymbolIndex.pruneUnusedLayers(this._order),r=r||this._layerOrderChanged||0===o,this._layerOrderChanged&&this.fire(new e.Event("neworder")),(r||!this.pauseablePlacement||this.pauseablePlacement.isDone()&&!this.placement.stillRecent(e.browser.now(),t.zoom))&&(this.pauseablePlacement=new ze(t,this._order,r,i,o,a,this.placement),this._layerOrderChanged=!1),this.pauseablePlacement.isDone()?this.placement.setStale():(this.pauseablePlacement.continuePlacement(this._order,this._layers,l),this.pauseablePlacement.isDone()&&(this.placement=this.pauseablePlacement.commit(e.browser.now()),s=!0),n&&this.pauseablePlacement.placement.setStale()),s||n)for(const e of this._order){const t=this._layers[e];"symbol"===t.type&&this.placement.updateLayerOpacities(t,l[t.source]);}return !this.pauseablePlacement.isDone()||this.placement.hasTransitions(e.browser.now())}_releaseSymbolFadeTiles(){for(const e in this._sourceCaches)this._sourceCaches[e].releaseSymbolFadeTiles();}getImages(e,t,i){this.imageManager.getImages(t.icons,i),this._updateTilesForChangedImages();const o=e=>{e&&e.setDependencies(t.tileID.key,t.type,t.icons);};o(this._otherSourceCaches[t.source]),o(this._symbolSourceCaches[t.source]);}getGlyphs(e,t,i){this.glyphManager.getGlyphs(t.stacks,i);}getResource(t,i,o){return e.makeRequest(i,o)}_getSourceCache(e){return this._otherSourceCaches[e]}_getLayerSourceCache(e){return "symbol"===e.type?this._symbolSourceCaches[e.source]:this._otherSourceCaches[e.source]}_getSourceCaches(e){const t=[];return this._otherSourceCaches[e]&&t.push(this._otherSourceCaches[e]),this._symbolSourceCaches[e]&&t.push(this._symbolSourceCaches[e]),t}has3DLayers(){return this._num3DLayers>0}hasSymbolLayers(){return this._numSymbolLayers>0}hasCircleLayers(){return this._numCircleLayers>0}}Ze.getSourceType=function(e){return S[e]},Ze.setSourceType=function(e,t){S[e]=t;},Ze.registerForPluginStateChange=e.registerForPluginStateChange;var Ge="attribute highp vec3 a_pos_3f;uniform lowp mat4 u_matrix;varying highp vec3 v_uv;void main() {const mat3 half_neg_pi_around_x=mat3(1.0,0.0, 0.0,0.0,0.0,-1.0,0.0,1.0, 0.0);v_uv=half_neg_pi_around_x*a_pos_3f;vec4 pos=u_matrix*vec4(a_pos_3f,1.0);gl_Position=pos.xyww;}";let Ve={};Ve=bt("","\n#define ELEVATION_SCALE 7.3\n#ifdef TERRAIN\nuniform sampler2D u_dem;uniform sampler2D u_dem_prev;uniform vec4 u_dem_unpack;uniform vec2 u_dem_tl;uniform vec2 u_dem_tl_prev;uniform float u_dem_scale;uniform float u_dem_scale_prev;uniform float u_dem_size;uniform float u_dem_lerp;uniform float u_exaggeration;uniform float u_meter_to_dem;uniform mat4 u_label_plane_matrix_inv;uniform sampler2D u_depth;uniform vec2 u_depth_size_inv;vec4 tileUvToDemSample(vec2 uv,float dem_size,float dem_scale,vec2 dem_tl) {vec2 pos=dem_size*(uv*dem_scale+dem_tl)+1.0;vec2 f=fract(pos);return vec4((pos-f+0.5)/(dem_size+2.0),f);}float decodeElevation(vec4 v) {return dot(vec4(v.xyz*255.0,-1.0),u_dem_unpack);}float currentElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale,u_dem_tl);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem,pos));float tr=decodeElevation(texture2D(u_dem,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}float prevElevation(vec2 apos) {float dd=1.0/(u_dem_size+2.0);vec4 r=tileUvToDemSample(apos/8192.0,u_dem_size,u_dem_scale_prev,u_dem_tl_prev);vec2 pos=r.xy;vec2 f=r.zw;float tl=decodeElevation(texture2D(u_dem_prev,pos));float tr=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,0.0)));float bl=decodeElevation(texture2D(u_dem_prev,pos+vec2(0.0,dd)));float br=decodeElevation(texture2D(u_dem_prev,pos+vec2(dd,dd)));return u_exaggeration*mix(mix(tl,tr,f.x),mix(bl,br,f.x),f.y);}\n#ifdef TERRAIN_VERTEX_MORPHING\nfloat elevation(vec2 apos) {float nextElevation=currentElevation(apos);float prevElevation=prevElevation(apos);return mix(prevElevation,nextElevation,u_dem_lerp);}\n#else\nfloat elevation(vec2 apos) {return currentElevation(apos);}\n#endif\nfloat unpack_depth(vec4 rgba_depth)\n{const vec4 bit_shift=vec4(1.0/(256.0*256.0*256.0),1.0/(256.0*256.0),1.0/256.0,1.0);return dot(rgba_depth,bit_shift)*2.0-1.0;}bool isOccluded(vec4 frag) {vec3 coord=frag.xyz/frag.w;float depth=unpack_depth(texture2D(u_depth,(coord.xy+1.0)*0.5));return coord.z > depth+0.0005;}float occlusionFade(vec4 frag) {vec3 coord=frag.xyz/frag.w;vec3 df=vec3(5.0*u_depth_size_inv,0.0);vec2 uv=0.5*coord.xy+0.5;vec4 depth=vec4(\nunpack_depth(texture2D(u_depth,uv-df.xz)),unpack_depth(texture2D(u_depth,uv+df.xz)),unpack_depth(texture2D(u_depth,uv-df.zy)),unpack_depth(texture2D(u_depth,uv+df.zy))\n);return dot(vec4(0.25),vec4(1.0)-clamp(300.0*(vec4(coord.z-0.001)-depth),0.0,1.0));}vec4 fourSample(vec2 pos,vec2 off) {vec4 demtl=vec4(texture2D(u_dem,pos).xyz*255.0,-1.0);float tl=dot(demtl,u_dem_unpack);vec4 demtr=vec4(texture2D(u_dem,pos+vec2(off.x,0.0)).xyz*255.0,-1.0);float tr=dot(demtr,u_dem_unpack);vec4 dembl=vec4(texture2D(u_dem,pos+vec2(0.0,off.y)).xyz*255.0,-1.0);float bl=dot(dembl,u_dem_unpack);vec4 dembr=vec4(texture2D(u_dem,pos+off).xyz*255.0,-1.0);float br=dot(dembr,u_dem_unpack);return vec4(tl,tr,bl,br);}float flatElevation(vec2 pack) {vec2 apos=floor(pack/8.0);vec2 span=10.0*(pack-apos*8.0);vec2 uvTex=(apos-vec2(1.0,1.0))/8190.0;float size=u_dem_size+2.0;float dd=1.0/size;vec2 pos=u_dem_size*(uvTex*u_dem_scale+u_dem_tl)+1.0;vec2 f=fract(pos);pos=(pos-f+0.5)*dd;vec4 h=fourSample(pos,vec2(dd));float z=mix(mix(h.x,h.y,f.x),mix(h.z,h.w,f.x),f.y);vec2 w=floor(0.5*(span*u_meter_to_dem-1.0));vec2 d=dd*w;vec4 bounds=vec4(d,vec2(1.0)-d);h=fourSample(pos-d,2.0*d+vec2(dd));vec4 diff=abs(h.xzxy-h.ywzw);vec2 slope=min(vec2(0.25),u_meter_to_dem*0.5*(diff.xz+diff.yw)/(2.0*w+vec2(1.0)));vec2 fix=slope*span;float base=z+max(fix.x,fix.y);return u_exaggeration*base;}float elevationFromUint16(float word) {return u_exaggeration*word/ELEVATION_SCALE;}\n#else\nfloat elevation(vec2 pos) { return 0.0; }bool isOccluded(vec4 frag) { return false; }float occlusionFade(vec4 frag) { return 1.0; }\n#endif",!0);const qe=bt("#ifdef GL_ES\nprecision mediump float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nconst float PI=3.141592653589793;","#ifdef GL_ES\nprecision highp float;\n#else\n#if !defined(lowp)\n#define lowp\n#endif\n#if !defined(mediump)\n#define mediump\n#endif\n#if !defined(highp)\n#define highp\n#endif\n#endif\nvec2 unpack_float(const float packedValue) {int packedIntValue=int(packedValue);int v0=packedIntValue/256;return vec2(v0,packedIntValue-v0*256);}vec2 unpack_opacity(const float packedOpacity) {int intOpacity=int(packedOpacity)/2;return vec2(float(intOpacity)/127.0,mod(packedOpacity,2.0));}vec4 decode_color(const vec2 encodedColor) {return vec4(\nunpack_float(encodedColor[0])/255.0,unpack_float(encodedColor[1])/255.0\n);}float unpack_mix_vec2(const vec2 packedValue,const float t) {return mix(packedValue[0],packedValue[1],t);}vec4 unpack_mix_color(const vec4 packedColors,const float t) {vec4 minColor=decode_color(vec2(packedColors[0],packedColors[1]));vec4 maxColor=decode_color(vec2(packedColors[2],packedColors[3]));return mix(minColor,maxColor,t);}vec2 get_pattern_pos(const vec2 pixel_coord_upper,const vec2 pixel_coord_lower,const vec2 pattern_size,const float tile_units_to_pixels,const vec2 pos) {vec2 offset=mod(mod(mod(pixel_coord_upper,pattern_size)*256.0,pattern_size)*256.0+pixel_coord_lower,pattern_size);return (tile_units_to_pixels*pos+offset)/pattern_size;}const float PI=3.141592653589793;const vec4 AWAY=vec4(-1000.0,-1000.0,-1000.0,1);//Normalized device coordinate that is not rendered."),je=bt("uniform vec4 u_color;uniform float u_opacity;void main() {gl_FragColor=u_color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),$e=bt("uniform vec2 u_pattern_tl_a;uniform vec2 u_pattern_br_a;uniform vec2 u_pattern_tl_b;uniform vec2 u_pattern_br_b;uniform vec2 u_texsize;uniform float u_mix;uniform float u_opacity;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(u_pattern_tl_a/u_texsize,u_pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(u_pattern_tl_b/u_texsize,u_pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_mix)*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pattern_size_a;uniform vec2 u_pattern_size_b;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_scale_a;uniform float u_scale_b;uniform float u_tile_units_to_pixels;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_a*u_pattern_size_a,u_tile_units_to_pixels,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,u_scale_b*u_pattern_size_b,u_tile_units_to_pixels,a_pos);}"),Xe=bt("varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=v_data.xy;float extrude_length=length(extrude);lowp float antialiasblur=v_data.z;float antialiased_blur=-max(blur,antialiasblur);float opacity_t=smoothstep(0.0,antialiased_blur,extrude_length-1.0);float color_t=stroke_width < 0.01 ? 0.0 : smoothstep(\nantialiased_blur,0.0,extrude_length-radius/(radius+stroke_width)\n);gl_FragColor=v_visibility*opacity_t*mix(color*opacity,stroke_color*stroke_opacity,color_t);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","#define NUM_VISIBILITY_RINGS 2\n#define INV_SQRT2 0.70710678\n#define ELEVATION_BIAS 0.0001\n#define NUM_SAMPLES_PER_RING 16\nuniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform lowp float u_device_pixel_ratio;uniform highp float u_camera_to_center_distance;attribute vec2 a_pos;varying vec3 v_data;varying float v_visibility;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define mediump float radius\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define highp vec4 stroke_color\n#pragma mapbox: define mediump float stroke_width\n#pragma mapbox: define lowp float stroke_opacity\nvec2 calc_offset(vec2 extrusion,float radius,float stroke_width, float view_scale) {return extrusion*(radius+stroke_width)*u_extrude_scale*view_scale;}float cantilevered_elevation(vec2 pos,float radius,float stroke_width,float view_scale) {vec2 c1=pos+calc_offset(vec2(-1,-1),radius,stroke_width,view_scale);vec2 c2=pos+calc_offset(vec2(1,-1),radius,stroke_width,view_scale);vec2 c3=pos+calc_offset(vec2(1,1),radius,stroke_width,view_scale);vec2 c4=pos+calc_offset(vec2(-1,1),radius,stroke_width,view_scale);float h1=elevation(c1)+ELEVATION_BIAS;float h2=elevation(c2)+ELEVATION_BIAS;float h3=elevation(c3)+ELEVATION_BIAS;float h4=elevation(c4)+ELEVATION_BIAS;return max(h4,max(h3,max(h1,h2)));}float circle_elevation(vec2 pos) {\n#if defined(TERRAIN)\nreturn elevation(pos)+ELEVATION_BIAS;\n#else\nreturn 0.0;\n#endif\n}vec4 project_vertex(vec2 extrusion,vec4 world_center,vec4 projected_center,float radius,float stroke_width, float view_scale) {vec2 sample_offset=calc_offset(extrusion,radius,stroke_width,view_scale);\n#ifdef PITCH_WITH_MAP\nreturn u_matrix*( world_center+vec4(sample_offset,0,0) );\n#else\nreturn projected_center+vec4(sample_offset,0,0);\n#endif\n}float get_sample_step() {\n#ifdef PITCH_WITH_MAP\nreturn 2.0*PI/float(NUM_SAMPLES_PER_RING);\n#else\nreturn PI/float(NUM_SAMPLES_PER_RING);\n#endif\n}void main(void) {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize mediump float radius\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize highp vec4 stroke_color\n#pragma mapbox: initialize mediump float stroke_width\n#pragma mapbox: initialize lowp float stroke_opacity\nvec2 extrude=vec2(mod(a_pos,2.0)*2.0-1.0);vec2 circle_center=floor(a_pos*0.5);float height=circle_elevation(circle_center);vec4 world_center=vec4(circle_center,height,1);vec4 projected_center=u_matrix*world_center;float view_scale=0.0;\n#ifdef PITCH_WITH_MAP\n#ifdef SCALE_WITH_MAP\nview_scale=1.0;\n#else\nview_scale=projected_center.w/u_camera_to_center_distance;\n#endif\n#else\n#ifdef SCALE_WITH_MAP\nview_scale=u_camera_to_center_distance;\n#else\nview_scale=projected_center.w;\n#endif\n#endif\ngl_Position=project_vertex(extrude,world_center,projected_center,radius,stroke_width,view_scale);float visibility=0.0;\n#ifdef TERRAIN\nfloat step=get_sample_step();\n#ifdef PITCH_WITH_MAP\nfloat cantilevered_height=cantilevered_elevation(circle_center,radius,stroke_width,view_scale);vec4 occlusion_world_center=vec4(circle_center,cantilevered_height,1);vec4 occlusion_projected_center=u_matrix*occlusion_world_center;\n#else\nvec4 occlusion_world_center=world_center;vec4 occlusion_projected_center=projected_center;\n#endif\nfor(int ring=0; ring < NUM_VISIBILITY_RINGS; ring++) {float scale=(float(ring)+1.0)/float(NUM_VISIBILITY_RINGS);for(int i=0; i < NUM_SAMPLES_PER_RING; i++) {vec2 extrusion=vec2(cos(step*float(i)),-sin(step*float(i)))*scale;vec4 frag_pos=project_vertex(extrusion,occlusion_world_center,occlusion_projected_center,radius,stroke_width,view_scale);visibility+=float(!isOccluded(frag_pos));}}visibility/=float(NUM_VISIBILITY_RINGS)*float(NUM_SAMPLES_PER_RING);\n#else\nvisibility=1.0;\n#endif\nv_visibility=visibility;lowp float antialiasblur=1.0/u_device_pixel_ratio/(radius+stroke_width);v_data=vec3(extrude.x,extrude.y,antialiasblur);}"),We=bt("void main() {gl_FragColor=vec4(1.0);}","attribute vec2 a_pos;uniform mat4 u_matrix;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);}"),He=bt("uniform highp float u_intensity;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#define GAUSS_COEF 0.3989422804014327\nvoid main() {\n#pragma mapbox: initialize highp float weight\nfloat d=-0.5*3.0*3.0*dot(v_extrude,v_extrude);float val=weight*u_intensity*GAUSS_COEF*exp(d);gl_FragColor=vec4(val,1.0,1.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_extrude_scale;uniform float u_opacity;uniform float u_intensity;attribute vec2 a_pos;varying vec2 v_extrude;\n#pragma mapbox: define highp float weight\n#pragma mapbox: define mediump float radius\nconst highp float ZERO=1.0/255.0/16.0;\n#define GAUSS_COEF 0.3989422804014327\nvoid main(void) {\n#pragma mapbox: initialize highp float weight\n#pragma mapbox: initialize mediump float radius\nvec2 unscaled_extrude=vec2(mod(a_pos,2.0)*2.0-1.0);float S=sqrt(-2.0*log(ZERO/weight/u_intensity/GAUSS_COEF))/3.0;v_extrude=S*unscaled_extrude;vec2 extrude=v_extrude*radius*u_extrude_scale;vec4 pos=vec4(floor(a_pos*0.5)+extrude,elevation(floor(a_pos*0.5)),1);gl_Position=u_matrix*pos;}"),Ke=bt("uniform sampler2D u_image;uniform sampler2D u_color_ramp;uniform float u_opacity;varying vec2 v_pos;void main() {float t=texture2D(u_image,v_pos).r;vec4 color=texture2D(u_color_ramp,vec2(t,0.5));gl_FragColor=color*u_opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(0.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;attribute vec2 a_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos*u_world,0,1);v_pos.x=a_pos.x;v_pos.y=1.0-a_pos.y;}"),Ye=bt("varying float v_placed;varying float v_notUsed;void main() {vec4 red =vec4(1.0,0.0,0.0,1.0);vec4 blue=vec4(0.0,0.0,1.0,0.5);gl_FragColor =mix(red,blue,step(0.5,v_placed))*0.5;gl_FragColor*=mix(1.0,0.1,step(0.5,v_notUsed));}","attribute vec2 a_pos;attribute vec2 a_anchor_pos;attribute vec2 a_extrude;attribute vec2 a_placed;attribute vec2 a_shift;attribute float a_size_scale;attribute vec2 a_padding;uniform mat4 u_matrix;uniform vec2 u_extrude_scale;uniform float u_camera_to_center_distance;varying float v_placed;varying float v_notUsed;void main() {vec4 projectedPoint=u_matrix*vec4(a_anchor_pos,elevation(a_anchor_pos),1);highp float camera_to_anchor_distance=projectedPoint.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,1.5);gl_Position=u_matrix*vec4(a_pos,elevation(a_pos),1.0);gl_Position.xy+=(a_extrude*a_size_scale+a_shift+a_padding)*u_extrude_scale*gl_Position.w*collision_perspective_ratio;v_placed=a_placed.x;v_notUsed=a_placed.y;}"),Je=bt("varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;void main() {float alpha=0.5*min(v_perspective_ratio,1.0);float stroke_radius=0.9*max(v_perspective_ratio,1.0);float distance_to_center=length(v_extrude);float distance_to_edge=abs(distance_to_center-v_radius);float opacity_t=smoothstep(-stroke_radius,0.0,-distance_to_edge);vec4 color=mix(vec4(0.0,0.0,1.0,0.5),vec4(1.0,0.0,0.0,1.0),v_collision);gl_FragColor=color*alpha*opacity_t;}","attribute vec2 a_pos_2f;attribute float a_radius;attribute vec2 a_flags;uniform mat4 u_matrix;uniform mat4 u_inv_matrix;uniform vec2 u_viewport_size;uniform float u_camera_to_center_distance;varying float v_radius;varying vec2 v_extrude;varying float v_perspective_ratio;varying float v_collision;vec3 toTilePosition(vec2 screenPos) {vec4 rayStart=u_inv_matrix*vec4(screenPos,-1.0,1.0);vec4 rayEnd  =u_inv_matrix*vec4(screenPos, 1.0,1.0);rayStart.xyz/=rayStart.w;rayEnd.xyz  /=rayEnd.w;highp float t=(0.0-rayStart.z)/(rayEnd.z-rayStart.z);return mix(rayStart.xyz,rayEnd.xyz,t);}void main() {vec2 quadCenterPos=a_pos_2f;float radius=a_radius;float collision=a_flags.x;float vertexIdx=a_flags.y;vec2 quadVertexOffset=vec2(\nmix(-1.0,1.0,float(vertexIdx >=2.0)),mix(-1.0,1.0,float(vertexIdx >=1.0 && vertexIdx <=2.0)));vec2 quadVertexExtent=quadVertexOffset*radius;vec3 tilePos=toTilePosition(quadCenterPos);vec4 clipPos=u_matrix*vec4(tilePos,1.0);highp float camera_to_anchor_distance=clipPos.w;highp float collision_perspective_ratio=clamp(\n0.5+0.5*(u_camera_to_center_distance/camera_to_anchor_distance),0.0,4.0);float padding_factor=1.2;v_radius=radius;v_extrude=quadVertexExtent*padding_factor;v_perspective_ratio=collision_perspective_ratio;v_collision=collision;gl_Position=vec4(clipPos.xyz/clipPos.w,1.0)+vec4(quadVertexExtent*padding_factor/u_viewport_size*2.0,0.0,0.0);}"),Qe=bt("uniform highp vec4 u_color;uniform sampler2D u_overlay;varying vec2 v_uv;void main() {vec4 overlay_color=texture2D(u_overlay,v_uv);gl_FragColor=mix(u_color,overlay_color,overlay_color.a);}","attribute vec2 a_pos;varying vec2 v_uv;uniform mat4 u_matrix;uniform float u_overlay_scale;void main() {float h=elevation(a_pos);v_uv=a_pos/8192.0;gl_Position=u_matrix*vec4(a_pos*u_overlay_scale,h,1);}"),et=bt("#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_FragColor=color*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);}"),tt=bt("varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=outline_color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec2 a_pos;uniform mat4 u_matrix;uniform vec2 u_world;varying vec2 v_pos;\n#pragma mapbox: define highp vec4 outline_color\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 outline_color\n#pragma mapbox: initialize lowp float opacity\ngl_Position=u_matrix*vec4(a_pos,0,1);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),it=bt("uniform vec2 u_texsize;uniform sampler2D u_image;uniform float u_fade;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);float dist=length(v_pos-gl_FragCoord.xy);float alpha=1.0-smoothstep(0.0,1.0,dist);gl_FragColor=mix(color1,color2,u_fade)*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_world;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec2 v_pos;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;gl_Position=u_matrix*vec4(a_pos,0,1);vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,a_pos);v_pos=(gl_Position.xy/gl_Position.w+1.0)/2.0*u_world;}"),ot=bt("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);gl_FragColor=mix(color1,color2,u_fade)*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform vec3 u_scale;attribute vec2 a_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;gl_Position=u_matrix*vec4(a_pos,0,1);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileZoomRatio,a_pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileZoomRatio,a_pos);}"),at=bt("varying vec4 v_color;void main() {gl_FragColor=v_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;uniform float u_vertical_gradient;uniform lowp float u_opacity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec4 v_color;\n#pragma mapbox: define highp float base\n#pragma mapbox: define highp float height\n#pragma mapbox: define highp vec4 color\nvoid main() {\n#pragma mapbox: initialize highp float base\n#pragma mapbox: initialize highp float height\n#pragma mapbox: initialize highp vec4 color\nvec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,t > 0.0 ? height : base,1);\n#endif\nfloat colorvalue=color.r*0.2126+color.g*0.7152+color.b*0.0722;v_color=vec4(0.0,0.0,0.0,1.0);vec4 ambientlight=vec4(0.03,0.03,0.03,1.0);color+=ambientlight;float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((1.0-colorvalue+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_color.r+=clamp(color.r*directional*u_lightcolor.r,mix(0.0,0.3,1.0-u_lightcolor.r),1.0);v_color.g+=clamp(color.g*directional*u_lightcolor.g,mix(0.0,0.3,1.0-u_lightcolor.g),1.0);v_color.b+=clamp(color.b*directional*u_lightcolor.b,mix(0.0,0.3,1.0-u_lightcolor.b),1.0);v_color*=u_opacity;}"),rt=bt("uniform vec2 u_texsize;uniform float u_fade;uniform sampler2D u_image;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;vec2 imagecoord=mod(v_pos_a,1.0);vec2 pos=mix(pattern_tl_a/u_texsize,pattern_br_a/u_texsize,imagecoord);vec4 color1=texture2D(u_image,pos);vec2 imagecoord_b=mod(v_pos_b,1.0);vec2 pos2=mix(pattern_tl_b/u_texsize,pattern_br_b/u_texsize,imagecoord_b);vec4 color2=texture2D(u_image,pos2);vec4 mixedColor=mix(color1,color2,u_fade);gl_FragColor=mixedColor*v_lighting;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_pixel_coord_upper;uniform vec2 u_pixel_coord_lower;uniform float u_height_factor;uniform vec3 u_scale;uniform float u_vertical_gradient;uniform lowp float u_opacity;uniform vec3 u_lightcolor;uniform lowp vec3 u_lightpos;uniform lowp float u_lightintensity;attribute vec4 a_pos_normal_ed;attribute vec2 a_centroid_pos;varying vec2 v_pos_a;varying vec2 v_pos_b;varying vec4 v_lighting;\n#pragma mapbox: define lowp float base\n#pragma mapbox: define lowp float height\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float base\n#pragma mapbox: initialize lowp float height\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec3 pos_nx=floor(a_pos_normal_ed.xyz*0.5);mediump vec3 top_up_ny=a_pos_normal_ed.xyz-2.0*pos_nx;float x_normal=pos_nx.z/8192.0;vec3 normal=top_up_ny.y==1.0 ? vec3(0.0,0.0,1.0) : normalize(vec3(x_normal,(2.0*top_up_ny.z-1.0)*(1.0-abs(x_normal)),0.0));float edgedistance=a_pos_normal_ed.w;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;base=max(0.0,base);height=max(0.0,height);float t=top_up_ny.x;float z=t > 0.0 ? height : base;\n#ifdef TERRAIN\nvec2 centroid_pos=a_centroid_pos;bool flat_roof=centroid_pos.x !=0.0;float ele=elevation(pos_nx.xy);float hidden=float(centroid_pos.x==0.0 && centroid_pos.y==1.0);float c_ele=flat_roof ? centroid_pos.y==0.0 ? elevationFromUint16(centroid_pos.x) : flatElevation(centroid_pos) : ele;float h=flat_roof ? max(c_ele+height,ele+base+2.0) : ele+(t > 0.0 ? height : base==0.0 ?-5.0 : base);gl_Position=mix(u_matrix*vec4(pos_nx.xy,h,1),AWAY,hidden);\n#else\ngl_Position=u_matrix*vec4(pos_nx.xy,z,1);\n#endif\nvec2 pos=normal.z==1.0\n? pos_nx.xy\n: vec2(edgedistance,z*u_height_factor);v_pos_a=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,fromScale*display_size_a,tileRatio,pos);v_pos_b=get_pattern_pos(u_pixel_coord_upper,u_pixel_coord_lower,toScale*display_size_b,tileRatio,pos);v_lighting=vec4(0.0,0.0,0.0,1.0);float directional=clamp(dot(normal,u_lightpos),0.0,1.0);directional=mix((1.0-u_lightintensity),max((0.5+u_lightintensity),1.0),directional);if (normal.y !=0.0) {directional*=(\n(1.0-u_vertical_gradient)+(u_vertical_gradient*clamp((t+base)*pow(height/150.0,0.5),mix(0.7,0.98,1.0-u_lightintensity),1.0)));}v_lighting.rgb+=clamp(directional*u_lightcolor,mix(vec3(0.0),vec3(0.3),1.0-u_lightcolor),vec3(1.0));v_lighting*=u_opacity;}"),nt=bt("#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_dimension;uniform float u_zoom;uniform vec4 u_unpack;float getElevation(vec2 coord,float bias) {vec4 data=texture2D(u_image,coord)*255.0;data.a=-1.0;return dot(data,u_unpack)/4.0;}void main() {vec2 epsilon=1.0/u_dimension;float a=getElevation(v_pos+vec2(-epsilon.x,-epsilon.y),0.0);float b=getElevation(v_pos+vec2(0,-epsilon.y),0.0);float c=getElevation(v_pos+vec2(epsilon.x,-epsilon.y),0.0);float d=getElevation(v_pos+vec2(-epsilon.x,0),0.0);float e=getElevation(v_pos,0.0);float f=getElevation(v_pos+vec2(epsilon.x,0),0.0);float g=getElevation(v_pos+vec2(-epsilon.x,epsilon.y),0.0);float h=getElevation(v_pos+vec2(0,epsilon.y),0.0);float i=getElevation(v_pos+vec2(epsilon.x,epsilon.y),0.0);float exaggerationFactor=u_zoom < 2.0 ? 0.4 : u_zoom < 4.5 ? 0.35 : 0.3;float exaggeration=u_zoom < 15.0 ? (u_zoom-15.0)*exaggerationFactor : 0.0;vec2 deriv=vec2(\n(c+f+f+i)-(a+d+d+g),(g+h+h+i)-(a+b+b+c)\n)/pow(2.0,exaggeration+(19.2562-u_zoom));gl_FragColor=clamp(vec4(\nderiv.x/2.0+0.5,deriv.y/2.0+0.5,1.0,1.0),0.0,1.0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_dimension;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);highp vec2 epsilon=1.0/u_dimension;float scale=(u_dimension.x-2.0)/u_dimension.x;v_pos=(a_texture_pos/8192.0)*scale+epsilon;}"),st=bt("uniform sampler2D u_image;varying vec2 v_pos;uniform vec2 u_latrange;uniform vec2 u_light;uniform vec4 u_shadow;uniform vec4 u_highlight;uniform vec4 u_accent;void main() {vec4 pixel=texture2D(u_image,v_pos);vec2 deriv=((pixel.rg*2.0)-1.0);float scaleFactor=cos(radians((u_latrange[0]-u_latrange[1])*(1.0-v_pos.y)+u_latrange[1]));float slope=atan(1.25*length(deriv)/scaleFactor);float aspect=deriv.x !=0.0 ? atan(deriv.y,-deriv.x) : PI/2.0*(deriv.y > 0.0 ? 1.0 :-1.0);float intensity=u_light.x;float azimuth=u_light.y+PI;float base=1.875-intensity*1.75;float maxValue=0.5*PI;float scaledSlope=intensity !=0.5 ? ((pow(base,slope)-1.0)/(pow(base,maxValue)-1.0))*maxValue : slope;float accent=cos(scaledSlope);vec4 accent_color=(1.0-accent)*u_accent*clamp(intensity*2.0,0.0,1.0);float shade=abs(mod((aspect+azimuth)/PI+0.5,2.0)-1.0);vec4 shade_color=mix(u_shadow,u_highlight,shade)*sin(scaledSlope)*clamp(intensity*2.0,0.0,1.0);gl_FragColor=accent_color*(1.0-shade_color.a)+shade_color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos=a_texture_pos/8192.0;}"),lt=bt("uniform lowp float u_device_pixel_ratio;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform vec2 u_units_to_pixels;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),ct=bt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;varying vec2 v_width2;varying vec2 v_normal;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);vec4 color=texture2D(u_image,v_uv);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_uv_x;attribute float a_split_index;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_units_to_pixels;uniform float u_image_height;varying vec2 v_normal;varying vec2 v_width2;varying float v_gamma_scale;varying highp vec2 v_uv;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;highp float texel_height=1.0/u_image_height;highp float half_texel_height=0.5*texel_height;v_uv=vec2(a_uv_x,a_split_index*texel_height-half_texel_height);vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_width2=vec2(outset,inset);}"),ht=bt("uniform lowp float u_device_pixel_ratio;uniform vec2 u_texsize;uniform float u_fade;uniform mediump vec3 u_scale;uniform sampler2D u_image;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\nvec2 pattern_tl_a=pattern_from.xy;vec2 pattern_br_a=pattern_from.zw;vec2 pattern_tl_b=pattern_to.xy;vec2 pattern_br_b=pattern_to.zw;float tileZoomRatio=u_scale.x;float fromScale=u_scale.y;float toScale=u_scale.z;vec2 display_size_a=(pattern_br_a-pattern_tl_a)/pixel_ratio_from;vec2 display_size_b=(pattern_br_b-pattern_tl_b)/pixel_ratio_to;vec2 pattern_size_a=vec2(display_size_a.x*fromScale/tileZoomRatio,display_size_a.y);vec2 pattern_size_b=vec2(display_size_b.x*toScale/tileZoomRatio,display_size_b.y);float aspect_a=display_size_a.y/v_width;float aspect_b=display_size_b.y/v_width;float dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float x_a=mod(v_linesofar/pattern_size_a.x*aspect_a,1.0);float x_b=mod(v_linesofar/pattern_size_b.x*aspect_b,1.0);float y=0.5*v_normal.y+0.5;vec2 texel_size=1.0/u_texsize;vec2 pos_a=mix(pattern_tl_a*texel_size-texel_size,pattern_br_a*texel_size+texel_size,vec2(x_a,y));vec2 pos_b=mix(pattern_tl_b*texel_size-texel_size,pattern_br_b*texel_size+texel_size,vec2(x_b,y));vec4 color=mix(texture2D(u_image,pos_a),texture2D(u_image,pos_b),u_fade);gl_FragColor=color*alpha*opacity;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform vec2 u_units_to_pixels;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;varying vec2 v_normal;varying vec2 v_width2;varying float v_linesofar;varying float v_gamma_scale;varying float v_width;\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\n#pragma mapbox: define lowp vec4 pattern_from\n#pragma mapbox: define lowp vec4 pattern_to\n#pragma mapbox: define lowp float pixel_ratio_from\n#pragma mapbox: define lowp float pixel_ratio_to\nvoid main() {\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\n#pragma mapbox: initialize mediump vec4 pattern_from\n#pragma mapbox: initialize mediump vec4 pattern_to\n#pragma mapbox: initialize lowp float pixel_ratio_from\n#pragma mapbox: initialize lowp float pixel_ratio_to\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_linesofar=a_linesofar;v_width2=vec2(outset,inset);v_width=floorwidth;}"),ut=bt("uniform lowp float u_device_pixel_ratio;uniform sampler2D u_image;uniform float u_sdfgamma;uniform float u_mix;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat dist=length(v_normal)*v_width2.s;float blur2=(blur+1.0/u_device_pixel_ratio)*v_gamma_scale;float alpha=clamp(min(dist-(v_width2.t-blur2),v_width2.s-dist)/blur2,0.0,1.0);float sdfdist_a=texture2D(u_image,v_tex_a).a;float sdfdist_b=texture2D(u_image,v_tex_b).a;float sdfdist=mix(sdfdist_a,sdfdist_b,u_mix);alpha*=smoothstep(0.5-u_sdfgamma/floorwidth,0.5+u_sdfgamma/floorwidth,sdfdist);gl_FragColor=color*(alpha*opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","\n#define scale 0.015873016\nattribute vec2 a_pos_normal;attribute vec4 a_data;attribute float a_linesofar;uniform mat4 u_matrix;uniform mediump float u_ratio;uniform lowp float u_device_pixel_ratio;uniform vec2 u_patternscale_a;uniform float u_tex_y_a;uniform vec2 u_patternscale_b;uniform float u_tex_y_b;uniform vec2 u_units_to_pixels;varying vec2 v_normal;varying vec2 v_width2;varying vec2 v_tex_a;varying vec2 v_tex_b;varying float v_gamma_scale;\n#pragma mapbox: define highp vec4 color\n#pragma mapbox: define lowp float blur\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define mediump float gapwidth\n#pragma mapbox: define lowp float offset\n#pragma mapbox: define mediump float width\n#pragma mapbox: define lowp float floorwidth\nvoid main() {\n#pragma mapbox: initialize highp vec4 color\n#pragma mapbox: initialize lowp float blur\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize mediump float gapwidth\n#pragma mapbox: initialize lowp float offset\n#pragma mapbox: initialize mediump float width\n#pragma mapbox: initialize lowp float floorwidth\nfloat ANTIALIASING=1.0/u_device_pixel_ratio/2.0;vec2 a_extrude=a_data.xy-128.0;float a_direction=mod(a_data.z,4.0)-1.0;vec2 pos=floor(a_pos_normal*0.5);mediump vec2 normal=a_pos_normal-2.0*pos;normal.y=normal.y*2.0-1.0;v_normal=normal;gapwidth=gapwidth/2.0;float halfwidth=width/2.0;offset=-1.0*offset;float inset=gapwidth+(gapwidth > 0.0 ? ANTIALIASING : 0.0);float outset=gapwidth+halfwidth*(gapwidth > 0.0 ? 2.0 : 1.0)+(halfwidth==0.0 ? 0.0 : ANTIALIASING);mediump vec2 dist=outset*a_extrude*scale;mediump float u=0.5*a_direction;mediump float t=1.0-abs(u);mediump vec2 offset2=offset*a_extrude*scale*normal.y*mat2(t,-u,u,t);vec4 projected_extrude=u_matrix*vec4(dist/u_ratio,0.0,0.0);gl_Position=u_matrix*vec4(pos+offset2/u_ratio,0.0,1.0)+projected_extrude;\n#ifndef RENDER_TO_TEXTURE\nfloat extrude_length_without_perspective=length(dist);float extrude_length_with_perspective=length(projected_extrude.xy/gl_Position.w*u_units_to_pixels);v_gamma_scale=extrude_length_without_perspective/extrude_length_with_perspective;\n#else\nv_gamma_scale=1.0;\n#endif\nv_tex_a=vec2(a_linesofar*u_patternscale_a.x/floorwidth,normal.y*u_patternscale_a.y+u_tex_y_a);v_tex_b=vec2(a_linesofar*u_patternscale_b.x/floorwidth,normal.y*u_patternscale_b.y+u_tex_y_b);v_width2=vec2(outset,inset);}"),dt=bt("uniform float u_fade_t;uniform float u_opacity;uniform sampler2D u_image0;uniform sampler2D u_image1;varying vec2 v_pos0;varying vec2 v_pos1;uniform float u_brightness_low;uniform float u_brightness_high;uniform float u_saturation_factor;uniform float u_contrast_factor;uniform vec3 u_spin_weights;void main() {vec4 color0=texture2D(u_image0,v_pos0);vec4 color1=texture2D(u_image1,v_pos1);if (color0.a > 0.0) {color0.rgb=color0.rgb/color0.a;}if (color1.a > 0.0) {color1.rgb=color1.rgb/color1.a;}vec4 color=mix(color0,color1,u_fade_t);color.a*=u_opacity;vec3 rgb=color.rgb;rgb=vec3(\ndot(rgb,u_spin_weights.xyz),dot(rgb,u_spin_weights.zxy),dot(rgb,u_spin_weights.yzx));float average=(color.r+color.g+color.b)/3.0;rgb+=(average-rgb)*u_saturation_factor;rgb=(rgb-0.5)*u_contrast_factor+0.5;vec3 u_high_vec=vec3(u_brightness_low,u_brightness_low,u_brightness_low);vec3 u_low_vec=vec3(u_brightness_high,u_brightness_high,u_brightness_high);gl_FragColor=vec4(mix(u_high_vec,u_low_vec,rgb)*color.a,color.a);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform vec2 u_tl_parent;uniform float u_scale_parent;uniform float u_buffer_scale;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;varying vec2 v_pos1;void main() {gl_Position=u_matrix*vec4(a_pos,0,1);v_pos0=(((a_texture_pos/8192.0)-0.5)/u_buffer_scale )+0.5;v_pos1=(v_pos0*u_scale_parent)+u_tl_parent;}"),_t=bt("uniform sampler2D u_texture;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nlowp float alpha=opacity*v_fade_opacity;gl_FragColor=texture2D(u_texture,v_tex)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform highp float u_camera_to_center_distance;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform float u_fade_change;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform vec2 u_texsize;varying vec2 v_tex;varying float v_fade_opacity;\n#pragma mapbox: define lowp float opacity\nvoid main() {\n#pragma mapbox: initialize lowp float opacity\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;vec2 a_minFontScale=a_pixeloffset.zw/256.0;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*max(a_minFontScale,fontScale)+a_pxoffset/16.0);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));v_tex=a_tex/u_texsize;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;v_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));}"),mt=bt("#define SDF_PX 8.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;uniform bool u_is_text;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat EDGE_GAMMA=0.105/u_device_pixel_ratio;vec2 tex=v_data0.xy;float gamma_scale=v_data1.x;float size=v_data1.y;float fade_opacity=v_data1[2];float fontScale=u_is_text ? size/24.0 : size;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec4 a_pixeloffset;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;varying vec2 v_data0;varying vec3 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);vec2 a_pxoffset=a_pixeloffset.xy;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=u_is_text ? size/24.0 : size;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale+a_pxoffset);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0=a_tex/u_texsize;v_data1=vec3(gamma_scale,size,interpolated_fade_opacity);}"),pt=bt("#define SDF_PX 8.0\n#define SDF 1.0\n#define ICON 0.0\nuniform bool u_is_halo;uniform sampler2D u_texture;uniform sampler2D u_texture_icon;uniform highp float u_gamma_scale;uniform lowp float u_device_pixel_ratio;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nfloat fade_opacity=v_data1[2];if (v_data1.w==ICON) {vec2 tex_icon=v_data0.zw;lowp float alpha=opacity*fade_opacity;gl_FragColor=texture2D(u_texture_icon,tex_icon)*alpha;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\nreturn;}vec2 tex=v_data0.xy;float EDGE_GAMMA=0.105/u_device_pixel_ratio;float gamma_scale=v_data1.x;float size=v_data1.y;float fontScale=size/24.0;lowp vec4 color=fill_color;highp float gamma=EDGE_GAMMA/(fontScale*u_gamma_scale);lowp float buff=(256.0-64.0)/256.0;if (u_is_halo) {color=halo_color;gamma=(halo_blur*1.19/SDF_PX+EDGE_GAMMA)/(fontScale*u_gamma_scale);buff=(6.0-halo_width/fontScale)/SDF_PX;}lowp float dist=texture2D(u_texture,tex).a;highp float gamma_scaled=gamma*gamma_scale;highp float alpha=smoothstep(buff-gamma_scaled,buff+gamma_scaled,dist);gl_FragColor=color*(alpha*opacity*fade_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","attribute vec4 a_pos_offset;attribute vec4 a_data;attribute vec3 a_projected_pos;attribute float a_fade_opacity;uniform bool u_is_size_zoom_constant;uniform bool u_is_size_feature_constant;uniform highp float u_size_t;uniform highp float u_size;uniform mat4 u_matrix;uniform mat4 u_label_plane_matrix;uniform mat4 u_coord_matrix;uniform bool u_is_text;uniform bool u_pitch_with_map;uniform highp float u_pitch;uniform bool u_rotate_symbol;uniform highp float u_aspect_ratio;uniform highp float u_camera_to_center_distance;uniform float u_fade_change;uniform vec2 u_texsize;uniform vec2 u_texsize_icon;varying vec4 v_data0;varying vec4 v_data1;\n#pragma mapbox: define highp vec4 fill_color\n#pragma mapbox: define highp vec4 halo_color\n#pragma mapbox: define lowp float opacity\n#pragma mapbox: define lowp float halo_width\n#pragma mapbox: define lowp float halo_blur\nvoid main() {\n#pragma mapbox: initialize highp vec4 fill_color\n#pragma mapbox: initialize highp vec4 halo_color\n#pragma mapbox: initialize lowp float opacity\n#pragma mapbox: initialize lowp float halo_width\n#pragma mapbox: initialize lowp float halo_blur\nvec2 a_pos=a_pos_offset.xy;vec2 a_offset=a_pos_offset.zw;vec2 a_tex=a_data.xy;vec2 a_size=a_data.zw;float a_size_min=floor(a_size[0]*0.5);float is_sdf=a_size[0]-2.0*a_size_min;highp float segment_angle=-a_projected_pos[2];float size;if (!u_is_size_zoom_constant && !u_is_size_feature_constant) {size=mix(a_size_min,a_size[1],u_size_t)/128.0;} else if (u_is_size_zoom_constant && !u_is_size_feature_constant) {size=a_size_min/128.0;} else {size=u_size;}float h=elevation(a_pos);vec4 projectedPoint=u_matrix*vec4(a_pos,h,1);highp float camera_to_anchor_distance=projectedPoint.w;highp float distance_ratio=u_pitch_with_map ?\ncamera_to_anchor_distance/u_camera_to_center_distance :\nu_camera_to_center_distance/camera_to_anchor_distance;highp float perspective_ratio=clamp(\n0.5+0.5*distance_ratio,0.0,1.5);size*=perspective_ratio;float fontScale=size/24.0;highp float symbol_rotation=0.0;if (u_rotate_symbol) {vec4 offsetProjectedPoint=u_matrix*vec4(a_pos+vec2(1,0),h,1);vec2 a=projectedPoint.xy/projectedPoint.w;vec2 b=offsetProjectedPoint.xy/offsetProjectedPoint.w;symbol_rotation=atan((b.y-a.y)/u_aspect_ratio,b.x-a.x);}highp float angle_sin=sin(segment_angle+symbol_rotation);highp float angle_cos=cos(segment_angle+symbol_rotation);mat2 rotation_matrix=mat2(angle_cos,-1.0*angle_sin,angle_sin,angle_cos);vec4 projected_pos=u_label_plane_matrix*vec4(a_projected_pos.xy,h,1.0);float z=0.0;vec2 offset=rotation_matrix*(a_offset/32.0*fontScale);\n#ifdef PITCH_WITH_MAP_TERRAIN\nvec4 tile_pos=u_label_plane_matrix_inv*vec4(a_projected_pos.xy+offset,0.0,1.0);z=elevation(tile_pos.xy);\n#endif\nfloat occlusion_fade=occlusionFade(projectedPoint);gl_Position=mix(u_coord_matrix*vec4(projected_pos.xy/projected_pos.w+offset,z,1.0),AWAY,float(projectedPoint.w <=0.0 || occlusion_fade==0.0));float gamma_scale=gl_Position.w;vec2 fade_opacity=unpack_opacity(a_fade_opacity);float fade_change=fade_opacity[1] > 0.5 ? u_fade_change :-u_fade_change;float interpolated_fade_opacity=max(0.0,min(occlusion_fade,fade_opacity[0]+fade_change));v_data0.xy=a_tex/u_texsize;v_data0.zw=a_tex/u_texsize_icon;v_data1=vec4(gamma_scale,size,interpolated_fade_opacity,is_sdf);}"),ft=bt("uniform sampler2D u_image0;varying vec2 v_pos0;void main() {gl_FragColor=texture2D(u_image0,v_pos0);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}","uniform mat4 u_matrix;uniform float u_skirt_height;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying vec2 v_pos0;const float skirtOffset=24575.0;void main() {v_pos0=a_texture_pos/8192.0;float skirt=float(a_pos.x >=skirtOffset);float elevation=elevation(a_texture_pos)-skirt*u_skirt_height;vec2 decodedPos=a_pos-vec2(skirt*skirtOffset,0.0);gl_Position=u_matrix*vec4(decodedPos,elevation,1.0);}"),gt=bt("#ifdef GL_ES\nprecision highp float;\n#endif\nvec4 pack_depth(float ndc_z) {float depth=ndc_z*0.5+0.5;const vec4 bit_shift=vec4(256.0*256.0*256.0,256.0*256.0,256.0,1.0);const vec4 bit_mask =vec4(0.0,1.0/256.0,1.0/256.0,1.0/256.0);vec4 res=fract(depth*bit_shift);res-=res.xxyz*bit_mask;return res;}varying float v_depth;void main() {gl_FragColor=pack_depth(v_depth);}","uniform mat4 u_matrix;attribute vec2 a_pos;attribute vec2 a_texture_pos;varying float v_depth;void main() {float elevation=elevation(a_texture_pos);gl_Position=u_matrix*vec4(a_pos,elevation,1.0);v_depth=gl_Position.z/gl_Position.w;}"),vt=bt("\nvarying lowp vec3 v_uv;uniform lowp samplerCube u_cubemap;uniform lowp float u_opacity;uniform highp float u_temporal_offset;uniform highp vec3 u_sun_direction;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}float sun_disk(highp vec3 ray_direction,highp vec3 sun_direction) {highp float cos_angle=dot(normalize(ray_direction),sun_direction);const highp float cos_sun_angular_diameter=0.99996192306;const highp float smoothstep_delta=1e-5;return smoothstep(\ncos_sun_angular_diameter-smoothstep_delta,cos_sun_angular_diameter+smoothstep_delta,cos_angle);}float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec3 uv=v_uv;const float y_bias=0.015;uv.y+=y_bias;uv.y=pow(abs(uv.y),1.0/5.0);uv.y=map(uv.y,0.0,1.0,-1.0,1.0);vec3 sky_color=textureCube(u_cubemap,uv).rgb;sky_color.rgb=dither(sky_color.rgb,gl_FragCoord.xy+u_temporal_offset);sky_color+=0.1*sun_disk(v_uv,u_sun_direction);gl_FragColor=vec4(sky_color*u_opacity,u_opacity);\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Ge),xt=bt("varying highp vec3 v_uv;uniform lowp sampler2D u_color_ramp;uniform lowp vec3 u_center_direction;uniform lowp float u_radius;uniform lowp float u_opacity;uniform highp float u_temporal_offset;highp vec3 hash(highp vec2 p) {highp vec3 p3=fract(vec3(p.xyx)*vec3(443.8975,397.2973,491.1871));p3+=dot(p3,p3.yxz+19.19);return fract(vec3((p3.x+p3.y)*p3.z,(p3.x+p3.z)*p3.y,(p3.y+p3.z)*p3.x));}vec3 dither(vec3 color,highp vec2 seed) {vec3 rnd=hash(seed)+hash(seed+0.59374)-0.5;color.rgb+=rnd/255.0;return color;}void main() {float progress=acos(dot(normalize(v_uv),u_center_direction))/u_radius;vec4 color=texture2D(u_color_ramp,vec2(progress,0.5))*u_opacity;color.rgb=dither(color.rgb,gl_FragCoord.xy+u_temporal_offset);gl_FragColor=color;\n#ifdef OVERDRAW_INSPECTOR\ngl_FragColor=vec4(1.0);\n#endif\n}",Ge),yt=bt("\nvarying highp vec3 v_position;uniform highp float u_sun_intensity;uniform highp float u_luminance;uniform lowp vec3 u_sun_direction;uniform highp vec4 u_color_tint_r;uniform highp vec4 u_color_tint_m;\n#ifdef GL_ES\nprecision highp float;\n#endif\n#define BETA_R                  vec3(5.5e-6,13.0e-6,22.4e-6)\n#define BETA_M                  vec3(21e-6,21e-6,21e-6)\n#define MIE_G                   0.76\n#define DENSITY_HEIGHT_SCALE_R  8000.0\n#define DENSITY_HEIGHT_SCALE_M  1200.0\n#define PLANET_RADIUS           6360e3\n#define ATMOSPHERE_RADIUS       6420e3\n#define SAMPLE_STEPS            10\n#define DENSITY_STEPS           4\nfloat ray_sphere_exit(vec3 orig,vec3 dir,float radius) {float a=dot(dir,dir);float b=2.0*dot(dir,orig);float c=dot(orig,orig)-radius*radius;float d=sqrt(b*b-4.0*a*c);return (-b+d)/(2.0*a);}vec3 extinction(vec2 density) {return exp(-vec3(BETA_R*u_color_tint_r.a*density.x+BETA_M*u_color_tint_m.a*density.y));}vec2 local_density(vec3 point) {float height=max(length(point)-PLANET_RADIUS,0.0);float exp_r=exp(-height/DENSITY_HEIGHT_SCALE_R);float exp_m=exp(-height/DENSITY_HEIGHT_SCALE_M);return vec2(exp_r,exp_m);}float phase_ray(float cos_angle) {return (3.0/(16.0*PI))*(1.0+cos_angle*cos_angle);}float phase_mie(float cos_angle) {return (3.0/(8.0*PI))*((1.0-MIE_G*MIE_G)*(1.0+cos_angle*cos_angle))/((2.0+MIE_G*MIE_G)*pow(1.0+MIE_G*MIE_G-2.0*MIE_G*cos_angle,1.5));}vec2 density_to_atmosphere(vec3 point,vec3 light_dir) {float ray_len=ray_sphere_exit(point,light_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(DENSITY_STEPS);vec2 density_point_to_atmosphere=vec2(0.0);for (int i=0; i < DENSITY_STEPS;++i) {vec3 point_on_ray=point+light_dir*((float(i)+0.5)*step_len);density_point_to_atmosphere+=local_density(point_on_ray)*step_len;;}return density_point_to_atmosphere;}vec3 atmosphere(vec3 ray_dir,vec3 sun_direction,float sun_intensity) {vec2 density_orig_to_point=vec2(0.0);vec3 scatter_r=vec3(0.0);vec3 scatter_m=vec3(0.0);vec3 origin=vec3(0.0,PLANET_RADIUS,0.0);float ray_len=ray_sphere_exit(origin,ray_dir,ATMOSPHERE_RADIUS);float step_len=ray_len/float(SAMPLE_STEPS);for (int i=0; i < SAMPLE_STEPS;++i) {vec3 point_on_ray=origin+ray_dir*((float(i)+0.5)*step_len);vec2 density=local_density(point_on_ray)*step_len;density_orig_to_point+=density;vec2 density_point_to_atmosphere=density_to_atmosphere(point_on_ray,sun_direction);vec2 density_orig_to_atmosphere=density_orig_to_point+density_point_to_atmosphere;vec3 extinction=extinction(density_orig_to_atmosphere);scatter_r+=density.x*extinction;scatter_m+=density.y*extinction;}float cos_angle=dot(ray_dir,sun_direction);float phase_r=phase_ray(cos_angle);float phase_m=phase_mie(cos_angle);vec3 beta_r=BETA_R*u_color_tint_r.rgb*u_color_tint_r.a;vec3 beta_m=BETA_M*u_color_tint_m.rgb*u_color_tint_m.a;return (scatter_r*phase_r*beta_r+scatter_m*phase_m*beta_m)*sun_intensity;}const float A=0.15;const float B=0.50;const float C=0.10;const float D=0.20;const float E=0.02;const float F=0.30;vec3 uncharted2_tonemap(vec3 x) {return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;}void main() {vec3 ray_direction=v_position;ray_direction.y=pow(ray_direction.y,5.0);const float y_bias=0.015;ray_direction.y+=y_bias;vec3 color=atmosphere(normalize(ray_direction),u_sun_direction,u_sun_intensity);float white_scale=1.0748724675633854;color=uncharted2_tonemap((log2(2.0/pow(u_luminance,4.0)))*color)*white_scale;gl_FragColor=vec4(color,1.0);}","attribute highp vec3 a_pos_3f;uniform mat3 u_matrix_3f;varying highp vec3 v_position;float map(float value,float start,float end,float new_start,float new_end) {return ((value-start)*(new_end-new_start))/(end-start)+new_start;}void main() {vec4 pos=vec4(u_matrix_3f*a_pos_3f,1.0);v_position=pos.xyz;v_position.y*=-1.0;v_position.y=map(v_position.y,-1.0,1.0,0.0,1.0);gl_Position=vec4(a_pos_3f.xy,0.0,1.0);}");function bt(e,t,i){const o=/#pragma mapbox: ([\w]+) ([\w]+) ([\w]+) ([\w]+)/g,a=t.match(/attribute (highp |mediump |lowp )?([\w]+) ([\w]+)/g),r=e.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g),n=t.match(/uniform (highp |mediump |lowp )?([\w]+) ([\w]+)([\s]*)([\w]*)/g);let s=n?n.concat(r):r;i||(s=Ve.staticUniforms.concat(s));const l={};return {fragmentSource:e=e.replace(o,(e,t,i,o,a)=>(l[a]=!0,"define"===t?`\n#ifndef HAS_UNIFORM_u_${a}\nvarying ${i} ${o} ${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:`\n#ifdef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = u_${a};\n#endif\n`)),vertexSource:t=t.replace(o,(e,t,i,o,a)=>{const r="float"===o?"vec2":"vec4",n=a.match(/color/)?"color":r;return l[a]?"define"===t?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${r} a_${a};\nvarying ${i} ${o} ${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = a_${a};\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${a} = unpack_mix_${n}(a_${a}, u_${a}_t);\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:"define"===t?`\n#ifndef HAS_UNIFORM_u_${a}\nuniform lowp float u_${a}_t;\nattribute ${i} ${r} a_${a};\n#else\nuniform ${i} ${o} u_${a};\n#endif\n`:"vec4"===n?`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = a_${a};\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`:`\n#ifndef HAS_UNIFORM_u_${a}\n    ${i} ${o} ${a} = unpack_mix_${n}(a_${a}, u_${a}_t);\n#else\n    ${i} ${o} ${a} = u_${a};\n#endif\n`}),staticAttributes:a,staticUniforms:s}}var wt=Object.freeze({__proto__:null,get preludeTerrain(){return Ve},prelude:qe,background:je,backgroundPattern:$e,circle:Xe,clippingMask:We,heatmap:He,heatmapTexture:Ke,collisionBox:Ye,collisionCircle:Je,debug:Qe,fill:et,fillOutline:tt,fillOutlinePattern:it,fillPattern:ot,fillExtrusion:at,fillExtrusionPattern:rt,hillshadePrepare:nt,hillshade:st,line:lt,lineGradient:ct,linePattern:ht,lineSDF:ut,raster:dt,symbolIcon:_t,symbolSDF:mt,symbolTextAndIcon:pt,terrainRaster:ft,terrainDepth:gt,skybox:vt,skyboxGradient:xt,skyboxCapture:yt});class Tt{constructor(){this.boundProgram=null,this.boundLayoutVertexBuffer=null,this.boundPaintVertexBuffers=[],this.boundIndexBuffer=null,this.boundVertexOffset=null,this.boundDynamicVertexBuffer=null,this.vao=null;}bind(e,t,i,o,a,r,n,s){this.context=e;let l=this.boundPaintVertexBuffers.length!==o.length;for(let e=0;!l&&e<o.length;e++)this.boundPaintVertexBuffers[e]!==o[e]&&(l=!0);e.extVertexArrayObject&&this.vao&&this.boundProgram===t&&this.boundLayoutVertexBuffer===i&&!l&&this.boundIndexBuffer===a&&this.boundVertexOffset===r&&this.boundDynamicVertexBuffer===n&&this.boundDynamicVertexBuffer2===s?(e.bindVertexArrayOES.set(this.vao),n&&n.bind(),a&&a.dynamicDraw&&a.bind(),s&&s.bind()):this.freshBind(t,i,o,a,r,n,s);}freshBind(e,t,i,o,a,r,n){let s;const l=e.numAttributes,c=this.context,h=c.gl;if(c.extVertexArrayObject)this.vao&&this.destroy(),this.vao=c.extVertexArrayObject.createVertexArrayOES(),c.bindVertexArrayOES.set(this.vao),s=0,this.boundProgram=e,this.boundLayoutVertexBuffer=t,this.boundPaintVertexBuffers=i,this.boundIndexBuffer=o,this.boundVertexOffset=a,this.boundDynamicVertexBuffer=r,this.boundDynamicVertexBuffer2=n;else {s=c.currentNumAttributes||0;for(let e=l;e<s;e++)h.disableVertexAttribArray(e);}t.enableAttributes(h,e);for(const t of i)t.enableAttributes(h,e);r&&r.enableAttributes(h,e),n&&n.enableAttributes(h,e),t.bind(),t.setVertexAttribPointers(h,e,a);for(const t of i)t.bind(),t.setVertexAttribPointers(h,e,a);r&&(r.bind(),r.setVertexAttribPointers(h,e,a)),o&&o.bind(),n&&(n.bind(),n.setVertexAttribPointers(h,e,a)),c.currentNumAttributes=l;}destroy(){this.vao&&(this.context.extVertexArrayObject.deleteVertexArrayOES(this.vao),this.vao=null);}}function Et(t,i){const o=Math.pow(2,i.canonical.z),a=i.canonical.y;return [new e.MercatorCoordinate(0,a/o).toLngLat().lat,new e.MercatorCoordinate(0,(a+1)/o).toLngLat().lat]}function Ct(t,i,o,a,r,n,s){const l=t.context,c=l.gl,h=o.fbo;if(!h)return;t.prepareDrawTile(i);const u=t.useProgram("hillshade");l.activeTexture.set(c.TEXTURE0),c.bindTexture(c.TEXTURE_2D,h.colorAttachment.get());const d=((e,t,i,o)=>{const a=i.paint.get("hillshade-shadow-color"),r=i.paint.get("hillshade-highlight-color"),n=i.paint.get("hillshade-accent-color");let s=i.paint.get("hillshade-illumination-direction")*(Math.PI/180);"viewport"===i.paint.get("hillshade-illumination-anchor")&&(s-=e.transform.angle);const l=!e.options.moving;return {u_matrix:o||e.transform.calculatePosMatrix(t.tileID.toUnwrapped(),l),u_image:0,u_latrange:Et(0,t.tileID),u_light:[i.paint.get("hillshade-exaggeration"),s],u_shadow:a,u_highlight:r,u_accent:n}})(t,o,a,t.terrain?i.posMatrix:null);u.draw(l,c.TRIANGLES,r,n,s,e.CullFaceMode.disabled,d,a.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}function St(t,i,o){if(!i.needsDEMTextureUpload)return;const a=t.context,r=a.gl;a.pixelStoreUnpackPremultiplyAlpha.set(!1),i.demTexture=i.demTexture||t.getTileTexture(o.stride);const n=o.getPixels();i.demTexture?i.demTexture.update(n,{premultiply:!1}):i.demTexture=new e.Texture(a,n,r.RGBA,{premultiply:!1}),i.needsDEMTextureUpload=!1;}function It(t,i,o,a,r,n){const s=t.context,l=s.gl;if(!i.dem)return;const c=i.dem;if(s.activeTexture.set(l.TEXTURE1),St(t,i,c),!i.demTexture)return;i.demTexture.bind(l.NEAREST,l.CLAMP_TO_EDGE);const h=c.dim;s.activeTexture.set(l.TEXTURE0);let u=i.fbo;if(!u){const t=new e.Texture(s,{width:h,height:h,data:null},l.RGBA);t.bind(l.LINEAR,l.CLAMP_TO_EDGE),u=i.fbo=s.createFramebuffer(h,h,!0),u.colorAttachment.set(t.texture);}s.bindFramebuffer.set(u.framebuffer),s.viewport.set([0,0,h,h]),t.useProgram("hillshadePrepare").draw(s,l.TRIANGLES,a,r,n,e.CullFaceMode.disabled,((t,i)=>{const o=i.stride,a=e.create();return e.ortho(a,0,e.EXTENT,-e.EXTENT,0,0,1),e.translate(a,a,[0,-e.EXTENT,0]),{u_matrix:a,u_image:1,u_dimension:[o,o],u_zoom:t.overscaledZ,u_unpack:i.unpackVector}})(i.tileID,c),o.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments),i.needsHillshadePrepare=!1;}const Pt=(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image0:new e.Uniform1i(t,i.u_image0),u_skirt_height:new e.Uniform1f(t,i.u_skirt_height)}),Mt=(e,t)=>({u_matrix:e,u_image0:0,u_skirt_height:t}),zt=new class{constructor(){this.operations={};}newMorphing(e,t,i,o,a){if(e in this.operations){const t=this.operations[e];t.to.tileID.key!==i.tileID.key&&(t.queued=i);}else this.operations[e]={startTime:o,phase:0,duration:a,from:t,to:i,queued:null};}getMorphValuesForProxy(e){if(!(e in this.operations))return null;const t=this.operations[e];return {from:t.from,to:t.to,phase:t.phase}}update(e){for(const t in this.operations){const i=this.operations[t];for(i.phase=(e-i.startTime)/i.duration;i.phase>=1||!this._validOp(i);)if(!this._nextOp(i,e)){delete this.operations[t];break}}}_nextOp(e,t){return !!e.queued&&(e.from=e.to,e.to=e.queued,e.queued=null,e.phase=0,e.startTime=t,!0)}_validOp(e){return e.from.hasData()&&e.to.hasData()}},At={0:null,1:"TERRAIN_VERTEX_MORPHING"};function Dt(t,i,o,a,r){const n=t.context,s=n.gl;let l=t.useProgram("terrainRaster"),c=0;const h=t.colorModeForRenderPass(),u=new e.DepthMode(s.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);zt.update(r);const d=t.transform,_=6*Math.pow(1.5,22-d.zoom)*i.exaggeration();var m,p,f;for(const g of a){const a=o.getTile(g),v=e.StencilMode.disabled,x=i.prevTerrainTileForTile[g.key],y=i.terrainTileForTile[g.key];f=y,null!=(p=x)&&null!=f&&p.hasData()&&f.hasData()&&null!=p.demTexture&&null!=f.demTexture&&p.tileID.key!==f.tileID.key&&zt.newMorphing(g.key,x,y,r,250),n.activeTexture.set(s.TEXTURE0),a.texture.bind(s.LINEAR,s.CLAMP_TO_EDGE,s.LINEAR_MIPMAP_NEAREST);const b=zt.getMorphValuesForProxy(g.key),w=b?1:0;let T;b&&(T={morphing:{srcDemTile:b.from,dstDemTile:b.to,phase:e.easeCubicInOut(b.phase)}});const E=Mt(g.posMatrix,Lt(g.canonical,d.renderWorldCopies)?_/10:_);c!==(m=w)&&(l=t.useProgram("terrainRaster",null,At[m]),c=m),i.setupElevationDraw(a,l,T),l.draw(n,s.TRIANGLES,u,v,h,e.CullFaceMode.backCCW,E,"terrain_raster",i.gridBuffer,i.gridIndexBuffer,i.gridSegments);}}function Lt(e,t){const i=1<<e.z;return !t&&(0===e.x||e.x===i-1)||0===e.y||e.y===i-1}const Rt=e=>({u_matrix:e});function kt(t,i,o,a,r){if(r>0){const n=e.browser.now(),s=(n-t.timeAdded)/r,l=i?(n-i.timeAdded)/r:-1,c=o.getSource(),h=a.coveringZoomLevel({tileSize:c.tileSize,roundZoom:c.roundZoom}),u=!i||Math.abs(i.tileID.overscaledZ-h)>Math.abs(t.tileID.overscaledZ-h),d=u&&t.refreshedUponExpiration?1:e.clamp(u?s:1-l,0,1);return t.refreshedUponExpiration&&s>=1&&(t.refreshedUponExpiration=!1),i?{opacity:1,mix:1-d}:{opacity:d,mix:0}}return {opacity:1,mix:0}}class Bt extends e.SourceCache{constructor(e){const t=I("proxy",{type:"geojson",maxzoom:e.transform.maxZoom},new g(B(),null),e.style);super("proxy",t,!1),t.setEventedParent(this),this.map=this.getSource().map=e,this.used=this._sourceLoaded=!0,this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}update(t,i,o){if(t.freezeTileCoverage)return;this.transform=t;const a=t.coveringTiles({tileSize:this._source.tileSize,minzoom:this._source.minzoom,maxzoom:this._source.maxzoom,roundZoom:this._source.roundZoom,reparseOverscaled:this._source.reparseOverscaled,useElevationData:!0}).reduce((i,o)=>{if(i[o.key]="",!this._tiles[o.key]){const i=new e.Tile(o,this._source.tileSize*o.overscaleFactor(),t.tileZoom);i.state="loaded",this._tiles[o.key]=i;}return i},{});for(const e in this._tiles)e in a||(this.freeFBO(e),this._tiles[e].state="unloaded",delete this._tiles[e]);}freeFBO(e){const t=this.proxyCachedFBO[e];if(void 0!==t){const i=Object.values(t);this.renderCachePool.push(...i),delete this.proxyCachedFBO[e];}}deallocRenderCache(){this.renderCache.forEach(e=>e.fb.destroy()),this.renderCache=[],this.renderCachePool=[],this.proxyCachedFBO={};}}class Ft extends e.OverscaledTileID{constructor(e,t,i){super(e.overscaledZ,e.wrap,e.canonical.z,e.canonical.x,e.canonical.y),this.proxyTileKey=t,this.posMatrix=i;}}class Ot extends e.Elevation{constructor(t,i){super(),this.painter=t,this.terrainTileForTile={},this.prevTerrainTileForTile={};const[o,a,r]=function(t){const i=new e.StructArrayLayout4i8,o=new e.StructArrayLayout3ui6;i.reserve(17161),o.reserve(33800);const a=e.EXTENT/128,r=e.EXTENT+a/2,n=r+a;for(let t=-a;t<n;t+=a)for(let o=-a;o<n;o+=a){const a=o<0||o>r||t<0||t>r?24575:0,n=e.clamp(Math.round(o),0,e.EXTENT),s=e.clamp(Math.round(t),0,e.EXTENT);i.emplaceBack(n+a,s,n,s);}const s=(e,t)=>{const i=131*t+e;o.emplaceBack(i+1,i,i+131),o.emplaceBack(i+131,i+131+1,i+1);};for(let e=1;e<129;e++)for(let t=1;t<129;t++)s(t,e);return [0,129].forEach(e=>{for(let t=0;t<130;t++)s(t,e),s(e,t);}),[i,o,32768]}(),n=t.context;this.gridBuffer=n.createVertexBuffer(o,E.members),this.gridIndexBuffer=n.createIndexBuffer(a),this.gridSegments=e.SegmentVector.simpleSegment(0,0,o.length,a.length),this.gridNoSkirtSegments=e.SegmentVector.simpleSegment(0,0,o.length,r),this.proxyCoords=[],this.proxiedCoords={},this._visibleDemTiles=[],this._drapedRenderBatches=[],this._sourceTilesOverlap={},this.proxySourceCache=new Bt(i.map),this.orthoMatrix=e.create(),e.ortho(this.orthoMatrix,0,e.EXTENT,0,e.EXTENT,0,1);const s=n.gl;this._overlapStencilMode=new e.StencilMode({func:s.GEQUAL,mask:255},0,255,s.KEEP,s.KEEP,s.REPLACE),this._previousZoom=t.transform.zoom,this.pool=[],this._findCoveringTileCache={},this._tilesDirty={},this.style=i,this._useVertexMorphing=!0;}set style(e){e.on("data",this._onStyleDataEvent.bind(this)),e.on("neworder",this._checkRenderCacheEfficiency.bind(this)),this._style=e,this._checkRenderCacheEfficiency();}update(t,i,o){if(t&&t.terrain){this._style!==t&&(this.style=t),this.enabled=!0;const a=t.terrain.properties;this.sourceCache=t._getSourceCache(a.get("source")),this._exaggeration=a.get("exaggeration");const r=()=>{this.sourceCache.used&&e.warnOnce(`Raster DEM source '${this.sourceCache.id}' is used both for terrain and as layer source.\n`+"This leads to lower resolution of hillshade. For full hillshade resolution but higher memory consumption, define another raster DEM source.");const t=this.sourceCache.getSource().tileSize/128,o=this.proxySourceCache.getSource().tileSize;this.sourceCache.update(i,t*o,!0),this._findCoveringTileCache[this.sourceCache.id]={};};this.sourceCache.usedForTerrain||(this._findCoveringTileCache[this.sourceCache.id]={},this.sourceCache.usedForTerrain=!0,r(),this._initializing=!0),r(),i.updateElevation(!o),this._findCoveringTileCache[this.proxySourceCache.id]={},this.proxySourceCache.update(i),this._emptyDEMTextureDirty=!0;}else this._disable();}_checkRenderCacheEfficiency(){const t=this.renderCacheEfficiency(this._style);this._style.map._optimizeForTerrain||100!==t.efficiency&&e.warnOnce(`Terrain render cache efficiency is not optimal (${t.efficiency}%) and performance\n                may be affected negatively, consider placing all background, fill and line layers before layer\n                with id '${t.firstUndrapedLayer}' or create a map using optimizeForTerrain: true option.`);}_onStyleDataEvent(e){e.coord&&"source"===e.dataType?this._clearRenderCacheForTile(e.sourceCacheId,e.coord):"style"===e.dataType&&(this._invalidateRenderCache=!0);}_disable(){if(this.enabled&&(this.enabled=!1,this.proxySourceCache.deallocRenderCache(),this._style))for(const e in this._style._sourceCaches)this._style._sourceCaches[e].usedForTerrain=!1;}destroy(){this._disable(),this._emptyDEMTexture&&this._emptyDEMTexture.destroy(),this.pool.forEach(e=>e.fb.destroy()),this.pool=[],this._depthFBO&&(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture);}_source(){return this.enabled?this.sourceCache:null}exaggeration(){return this._exaggeration}get visibleDemTiles(){return this._visibleDemTiles}get drapeBufferSize(){const e=2*this.proxySourceCache.getSource().tileSize;return [e,e]}set useVertexMorphing(e){this._useVertexMorphing=e;}updateTileBinding(t){if(!this.enabled)return;this.prevTerrainTileForTile=this.terrainTileForTile;const i=this.proxySourceCache,o=this.painter.transform;this._initializing&&(this._initializing=0===o._centerAltitude&&-1===this.getAtPoint(e.MercatorCoordinate.fromLngLat(o.center),-1),this._emptyDEMTextureDirty=!this._initializing);const a=this.painter.options;this.renderCached=(a.zooming||a.moving||a.rotating||!!this.forceRenderCached)&&!this._invalidateRenderCache,this._invalidateRenderCache=!1;const r=this.proxyCoords=i.getIds().map(e=>{const t=i.getTileByID(e).tileID;return t.posMatrix=o.calculatePosMatrix(t.toUnwrapped()),t});!function(t,i){const o=i.transform.pointCoordinate(i.transform.getCameraPoint()),a=new e.Point(o.x,o.y);t.sort((t,i)=>{if(i.overscaledZ-t.overscaledZ)return i.overscaledZ-t.overscaledZ;const o=new e.Point(t.canonical.x+(1<<t.canonical.z)*t.wrap,t.canonical.y),r=new e.Point(i.canonical.x+(1<<i.canonical.z)*i.wrap,i.canonical.y),n=a.mult(1<<t.canonical.z);return n.x-=.5,n.y-=.5,n.distSqr(o)-n.distSqr(r)});}(r,this.painter),this._previousZoom=o.zoom;const n=this.proxyToSource||{};this.proxyToSource={},r.forEach(e=>{this.proxyToSource[e.key]={};}),this.terrainTileForTile={};const s=this._style._sourceCaches;for(const e in s){const i=s[e];if(!i.used)continue;if(i!==this.sourceCache&&(this._findCoveringTileCache[i.id]={}),this._setupProxiedCoordsForOrtho(i,t[e],n),i.usedForTerrain)continue;const o=t[e];i.getSource().reparseOverscaled&&this._assignTerrainTiles(o);}this.proxiedCoords[i.id]=r.map(e=>new Ft(e,e.key,this.orthoMatrix)),this._assignTerrainTiles(r),this._prepareDEMTextures(),this._setupDrapedRenderBatches(),this._setupRenderCache(n),this.renderingToTexture=!1,this._initFBOPool(),this._updateTimestamp=e.browser.now();const l={};this._visibleDemTiles=[];for(const e of this.proxyCoords){const t=this.terrainTileForTile[e.key];if(!t)continue;const i=t.tileID.key;i in l||(this._visibleDemTiles.push(t),l[i]=i);}}_assignTerrainTiles(e){this._initializing||e.forEach(e=>{if(this.terrainTileForTile[e.key])return;const t=this._findTileCoveringTileID(e,this.sourceCache);t&&(this.terrainTileForTile[e.key]=t);});}_prepareDEMTextures(){const e=this.painter.context,t=e.gl;for(const i in this.terrainTileForTile){const o=this.terrainTileForTile[i],a=o.dem;!a||o.demTexture&&!o.needsDEMTextureUpload||(e.activeTexture.set(t.TEXTURE1),St(this.painter,o,a));}}_prepareDemTileUniforms(e,t,i,o){if(!t||null==t.demTexture)return !1;const a=e.tileID.canonical,r=Math.pow(2,t.tileID.canonical.z-a.z),n=o||"";return i[`u_dem_tl${n}`]=[a.x*r%1,a.y*r%1],i[`u_dem_scale${n}`]=r,!0}get emptyDEMTexture(){return !this._emptyDEMTextureDirty&&this._emptyDEMTexture?this._emptyDEMTexture:this._updateEmptyDEMTexture()}_getLoadedAreaMinimum(){let e=0;const t=this._visibleDemTiles.reduce((t,i)=>{if(!i.dem)return t;const o=i.dem.tree.minimums[0];return o>0&&e++,t+o},0);return e?t/e:0}_updateEmptyDEMTexture(){const t=this.painter.context,i=t.gl;t.activeTexture.set(i.TEXTURE2);const o=this._getLoadedAreaMinimum(),a={width:1,height:1,data:new Uint8Array(e.DEMData.pack(o,this.sourceCache.getSource().encoding))};this._emptyDEMTextureDirty=!1;let r=this._emptyDEMTexture;return r?r.update(a,{premultiply:!1}):r=this._emptyDEMTexture=new e.Texture(t,a,i.RGBA,{premultiply:!1}),r}setupElevationDraw(t,i,o){const a=this.painter.context,r=a.gl,n=(s=this.sourceCache.getSource().encoding,{u_dem:2,u_dem_prev:4,u_dem_unpack:e.DEMData.getUnpackVector(s),u_dem_tl:[0,0],u_dem_tl_prev:[0,0],u_dem_scale:0,u_dem_scale_prev:0,u_dem_size:0,u_dem_lerp:1,u_depth:3,u_depth_size_inv:[0,0],u_exaggeration:0});var s;n.u_dem_size=this.sourceCache.getSource().tileSize,n.u_exaggeration=this.exaggeration();let l=null,c=null,h=1;if(o&&o.morphing&&this._useVertexMorphing){const e=o.morphing.srcDemTile,i=o.morphing.dstDemTile;h=o.morphing.phase,e&&i&&(this._prepareDemTileUniforms(t,e,n,"_prev")&&(c=e),this._prepareDemTileUniforms(t,i,n)&&(l=i));}if(c&&l?(a.activeTexture.set(r.TEXTURE2),l.demTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),a.activeTexture.set(r.TEXTURE4),c.demTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),n.u_dem_lerp=h):(l=this.terrainTileForTile[t.tileID.key],a.activeTexture.set(r.TEXTURE2),(this._prepareDemTileUniforms(t,l,n)?l.demTexture:this.emptyDEMTexture).bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST)),o&&o.useDepthForOcclusion&&(a.activeTexture.set(r.TEXTURE3),this._depthTexture.bind(r.NEAREST,r.CLAMP_TO_EDGE,r.NEAREST),n.u_depth_size_inv=[1/this._depthFBO.width,1/this._depthFBO.height]),o&&o.useMeterToDem&&l){const t=(1<<l.tileID.canonical.z)*e.mercatorZfromAltitude(1,this.painter.transform.center.lat)*this.sourceCache.getSource().tileSize;n.u_meter_to_dem=t;}o&&o.labelPlaneMatrixInv&&(n.u_label_plane_matrix_inv=o.labelPlaneMatrixInv),i.setTerrainUniformValues(a,n);}renderBatch(t){if(0===this._drapedRenderBatches.length)return t+1;this.renderingToTexture=!0;const i=this.painter,o=this.painter.context,a=this.proxySourceCache,r=this.proxiedCoords[a.id],n=()=>{o.bindFramebuffer.set(null),o.viewport.set([0,0,i.width,i.height]),this.renderingToTexture=!1;},s=this._drapedRenderBatches.shift();let l=[];const c=i.style.order;let h=0;for(let u=0;u<r.length;u++){const d=r[u],_=a.getTileByID(d.proxyTileKey),m=a.proxyCachedFBO[d.key]?a.proxyCachedFBO[d.key][t]:void 0;let p,f;if(p=this.currentFBO=void 0!==m?a.renderCache[m]:this.pool[h++],_.texture=p.tex,void 0===m||p.dirty){o.bindFramebuffer.set(p.fb.framebuffer),this.renderedToTile=!1,p.dirty&&(o.clear({color:e.Color.transparent}),p.dirty=!1);for(let e=s.start;e<=s.end;++e){const t=i.style._layers[c[e]];if(t.isHidden(i.transform.zoom))continue;const a=i.style._getLayerSourceCache(t),r=a?this.proxyToSource[d.key][a.id]:[d];if(!r)continue;const n=r;o.viewport.set([0,0,p.fb.width,p.fb.height]),f!==(a?a.id:null)&&(this._setupStencil(r,t,a),f=a?a.id:null),i.renderLayer(i,a,t,n);}p.dirty=this.renderedToTile,this.renderedToTile&&l.push(_.tileID),5===h&&(h=0,l.length>0&&(n(),Dt(i,this,a,l,this._updateTimestamp),this.renderingToTexture=!0,l=[]));}else l.push(_.tileID);}return n(),l.length>0&&Dt(i,this,a,l,this._updateTimestamp),s.end+1}postRender(){}renderCacheEfficiency(e){const t=e.order.length;if(0===t)return {efficiency:100};let i,o=0,a=0,r=!1;for(let n=0;n<t;++n){const t=e._layers[e.order[n]];this._style.isLayerDraped(t)?(r&&++o,++a):r||(r=!0,i=t.id);}return 0===a?{efficiency:100}:{efficiency:100*(1-o/a),firstUndrapedLayer:i}}raycast(e,t,i){if(!this._visibleDemTiles)return null;const o=this._visibleDemTiles.filter(e=>e.dem).map(o=>{const a=o.tileID,r=Math.pow(2,a.overscaledZ),{x:n,y:s}=a.canonical,l=n/r,c=(n+1)/r,h=s/r,u=(s+1)/r;return {minx:l,miny:h,maxx:c,maxy:u,t:o.dem.tree.raycastRoot(l,h,c,u,e,t,i),tile:o}});o.sort((e,t)=>(null!==e.t?e.t:Number.MAX_VALUE)-(null!==t.t?t.t:Number.MAX_VALUE));for(const a of o){if(null==a.t)return null;const o=a.tile.dem.tree.raycast(a.minx,a.miny,a.maxx,a.maxy,e,t,i);if(null!=o)return o}return null}_createFBO(){const t=this.painter.context,i=t.gl,o=this.drapeBufferSize;t.activeTexture.set(i.TEXTURE0);const a=new e.Texture(t,{width:o[0],height:o[1],data:null},i.RGBA);a.bind(i.LINEAR,i.CLAMP_TO_EDGE);const r=t.createFramebuffer(o[0],o[1],!1);return r.colorAttachment.set(a.texture),t.extTextureFilterAnisotropic&&!t.extTextureFilterAnisotropicForceOff&&i.texParameterf(i.TEXTURE_2D,t.extTextureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,t.extTextureFilterAnisotropicMax),{fb:r,tex:a,dirty:!1,ref:1}}_initFBOPool(){for(;this.pool.length<Math.min(5,this.proxyCoords.length);)this.pool.push(this._createFBO());}_shouldDisableRenderCache(){return !this.renderCached||this._style.order.some(e=>{const t=this._style._layers[e],i=!t.isHidden(this.painter.transform.zoom),o=t.getCrossfadeParameters();return "custom"!==t.type&&!i&&!!o&&1!==o.t})}_clearRasterFadeFromRenderCache(){let e=!1;for(const t in this._style._sourceCaches)if(this._style._sourceCaches[t]._source instanceof T){e=!0;break}if(e)for(let e=0;e<this._style.order.length;++e){const t=this._style._layers[this._style.order[e]],i=t.isHidden(this.painter.transform.zoom),o=this._style._getLayerSourceCache(t);if("raster"!==t.type||i||!o)continue;const a=t.paint.get("raster-fade-duration");for(const e of this.proxyCoords){const t=this.proxyToSource[e.key][o.id];if(t)for(const e of t){const t=kt(o.getTile(e),o.findLoadedParent(e,0),o,this.painter.transform,a);(1!==t.opacity||0!==t.mix)&&this._clearRenderCacheForTile(o.id,e);}}}}_setupDrapedRenderBatches(){const e=this._style.order,t=e.length;if(0===t)return;const i=[];let o,a=0,r=this._style._layers[e[a]];for(;!this._style.isLayerDraped(r)&&r.isHidden(this.painter.transform.zoom)&&++a<t;)r=this._style._layers[e[a]];for(;a<t;++a){const t=this._style._layers[e[a]];t.isHidden(this.painter.transform.zoom)||(this._style.isLayerDraped(t)?void 0===o&&(o=a):void 0!==o&&(i.push({start:o,end:a-1}),o=void 0));}void 0!==o&&i.push({start:o,end:a-1}),this._drapedRenderBatches=i;}_setupRenderCache(e){const t=this.proxySourceCache;if(this._shouldDisableRenderCache()){if(t.renderCache.length>t.renderCachePool.length){const e=Object.values(t.proxyCachedFBO);t.proxyCachedFBO={};for(let i=0;i<e.length;++i){const o=Object.values(e[i]);t.renderCachePool.push(...o);}}return}this._clearRasterFadeFromRenderCache();const i=this.proxyCoords,o=this._tilesDirty;for(let a=i.length-1;a>=0;a--){const r=i[a];if(t.getTileByID(r.key),void 0!==t.proxyCachedFBO[r.key]){const i=e[r.key],a=this.proxyToSource[r.key];let n=0;for(const e in a){const t=a[e],r=i[e];if(!r||r.length!==t.length||t.some((t,i)=>t!==r[i]||o[e]&&o[e].hasOwnProperty(t.key))){n=-1;break}++n;}for(const e in t.proxyCachedFBO[r.key])t.renderCache[t.proxyCachedFBO[r.key][e]].dirty=n<0||n!==Object.values(i).length;}else for(let e=0;e<this._drapedRenderBatches.length;++e){const i=this._drapedRenderBatches[e];let o=t.renderCachePool.pop();void 0===o&&t.renderCache.length<50&&(o=t.renderCache.length,t.renderCache.push(this._createFBO())),void 0!==o&&(void 0===t.proxyCachedFBO[r.key]&&(t.proxyCachedFBO[r.key]={}),t.proxyCachedFBO[r.key][i.start]=o,t.renderCache[o].dirty=!0);}}this._tilesDirty={};}_setupStencil(t,i,o){if(!o||!this._sourceTilesOverlap[o.id])return void(this._overlapStencilType&&(this._overlapStencilType=!1));const a=this.painter.context,r=a.gl;if(t.length<=1)return void(this._overlapStencilType=!1);const n=this.currentFBO,s=n.fb;let l;if(i.isTileClipped())l=t.length,this._overlapStencilMode.test={func:r.EQUAL,mask:255},this._overlapStencilType="Clip";else {if(!(t[0].overscaledZ>t[t.length-1].overscaledZ))return void(this._overlapStencilType=!1);l=1,this._overlapStencilMode.test={func:r.GREATER,mask:255},this._overlapStencilType="Mask";}if(!s.depthAttachment){const t=a.createRenderbuffer(a.gl.DEPTH_STENCIL,s.width,s.height);s.depthAttachment=new e.DepthStencilAttachment(a,s.framebuffer),s.depthAttachment.set(t),a.clear({stencil:0});}n.ref+l>255&&(a.clear({stencil:0}),n.ref=0),n.ref+=l,this._overlapStencilMode.ref=n.ref,i.isTileClipped()&&this._renderTileClippingMasks(t,this._overlapStencilMode.ref);}stencilModeForRTTOverlap(t){return this.renderingToTexture&&this._overlapStencilType?("Clip"===this._overlapStencilType&&(this._overlapStencilMode.ref=this.painter._tileClippingMaskIDs[t.key]),this._overlapStencilMode):e.StencilMode.disabled}_renderTileClippingMasks(t,i){const o=this.painter,a=this.painter.context,r=a.gl;o._tileClippingMaskIDs={},a.setColorMode(e.ColorMode.disabled),a.setDepthMode(e.DepthMode.disabled);const n=o.useProgram("clippingMask");for(const s of t){const t=o._tileClippingMaskIDs[s.key]=--i;n.draw(a,r.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:r.ALWAYS,mask:0},t,255,r.KEEP,r.KEEP,r.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,Rt(s.posMatrix),"$clipping",o.tileExtentBuffer,o.quadTriangleIndexBuffer,o.tileExtentSegments);}}pointCoordinate(t){const i=this.painter.transform;if(t.x<0||t.x>i.width||t.y<0||t.y>i.height)return null;const o=[t.x,t.y,1,1];e.transformMat4(o,o,i.pixelMatrixInverse),e.scale$1(o,o,1/o[3]),o[0]/=i.worldSize,o[1]/=i.worldSize;const a=i._camera.position,r=e.mercatorZfromAltitude(1,i.center.lat),n=[a[0],a[1],a[2]/r,0],s=e.subtract([],o.slice(0,3),n);e.normalize(s,s);const l=this.raycast(n,s,this._exaggeration);return null!==l&&l?(e.scaleAndAdd(n,n,s,l),n[3]=n[2],n[2]*=r,n):null}drawDepth(){const t=this.painter,i=t.context,o=this.proxySourceCache,a=Math.ceil(t.width),r=Math.ceil(t.height);if(!this._depthFBO||this._depthFBO.width===a&&this._depthFBO.height===r||(this._depthFBO.destroy(),delete this._depthFBO,delete this._depthTexture),!this._depthFBO){const t=i.gl,o=i.createFramebuffer(a,r,!0);i.activeTexture.set(t.TEXTURE0);const n=new e.Texture(i,{width:a,height:r,data:null},t.RGBA);n.bind(t.NEAREST,t.CLAMP_TO_EDGE),o.colorAttachment.set(n.texture);const s=i.createRenderbuffer(i.gl.DEPTH_COMPONENT16,a,r);o.depthAttachment.set(s),this._depthFBO=o,this._depthTexture=n;}i.bindFramebuffer.set(this._depthFBO.framebuffer),i.viewport.set([0,0,a,r]),function(t,i,o,a){const r=t.context,n=r.gl;r.clear({depth:1});const s=t.useProgram("terrainDepth"),l=new e.DepthMode(n.LESS,e.DepthMode.ReadWrite,t.depthRangeFor3D);for(const t of a){const a=o.getTile(t),c=Mt(t.posMatrix,0);i.setupElevationDraw(a,s),s.draw(r,n.TRIANGLES,l,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.backCCW,c,"terrain_depth",i.gridBuffer,i.gridIndexBuffer,i.gridNoSkirtSegments);}}(t,this,o,this.proxyCoords);}_setupProxiedCoordsForOrtho(e,t,i){if(e.getSource()instanceof C)return this._setupProxiedCoordsForImageSource(e,t,i);this._findCoveringTileCache[e.id]=this._findCoveringTileCache[e.id]||{};const o=this.proxiedCoords[e.id]=[],a=this.proxyCoords;for(let t=0;t<a.length;t++){const r=a[t],n=this._findTileCoveringTileID(r,e);if(n){const t=this._createProxiedId(r,n,i[r.key]&&i[r.key][e.id]);o.push(t),this.proxyToSource[r.key][e.id]=[t];}}let r=!1;for(let a=0;a<t.length;a++){const n=e.getTile(t[a]);if(!n||!n.hasData())continue;const s=this._findTileCoveringTileID(n.tileID,this.proxySourceCache);if(s&&s.tileID.canonical.z!==n.tileID.canonical.z){const t=this.proxyToSource[s.tileID.key][e.id],a=this._createProxiedId(s.tileID,n,i[s.tileID.key]&&i[s.tileID.key][e.id]);t?t.splice(t.length-1,0,a):this.proxyToSource[s.tileID.key][e.id]=[a],o.push(a),r=!0;}}this._sourceTilesOverlap[e.id]=r;}_setupProxiedCoordsForImageSource(t,i,o){if(!t.getSource().loaded())return;const a=this.proxiedCoords[t.id]=[],r=this.proxyCoords,n=t.getSource(),s=new e.Point(n.tileID.x,n.tileID.y)._div(1<<n.tileID.z),l=n.coordinates.map(e.MercatorCoordinate.fromLngLat).reduce((e,t)=>(e.min.x=Math.min(e.min.x,t.x-s.x),e.min.y=Math.min(e.min.y,t.y-s.y),e.max.x=Math.max(e.max.x,t.x-s.x),e.max.y=Math.max(e.max.y,t.y-s.y),e),{min:new e.Point(Number.MAX_VALUE,Number.MAX_VALUE),max:new e.Point(-Number.MAX_VALUE,-Number.MAX_VALUE)}),c=(t,i)=>{const o=t.wrap+t.canonical.x/(1<<t.canonical.z),a=t.canonical.y/(1<<t.canonical.z),r=e.EXTENT/(1<<t.canonical.z),n=i.wrap+i.canonical.x/(1<<i.canonical.z),s=i.canonical.y/(1<<i.canonical.z);return o+r<n+l.min.x||o>n+l.max.x||a+r<s+l.min.y||a>s+l.max.y};for(let e=0;e<r.length;e++){const n=r[e];for(let e=0;e<i.length;e++){const r=t.getTile(i[e]);if(!r||!r.hasData())continue;if(c(n,r.tileID))continue;const s=this._createProxiedId(n,r,o[n.key]&&o[n.key][t.id]),l=this.proxyToSource[n.key][t.id];l?l.push(s):this.proxyToSource[n.key][t.id]=[s],a.push(s);}}}_createProxiedId(t,i,o){let a=this.orthoMatrix;if(o){const e=o.find(e=>e.key===i.tileID.key);if(e)return e}if(i.tileID.key!==t.key){const o=t.canonical.z-i.tileID.canonical.z;let r,n,s;a=e.create();const l=i.tileID.wrap-t.wrap<<t.overscaledZ;o>0?(r=e.EXTENT>>o,n=r*((i.tileID.canonical.x<<o)-t.canonical.x+l),s=r*((i.tileID.canonical.y<<o)-t.canonical.y)):(r=e.EXTENT<<-o,n=e.EXTENT*(i.tileID.canonical.x-(t.canonical.x+l<<-o)),s=e.EXTENT*(i.tileID.canonical.y-(t.canonical.y<<-o))),e.ortho(a,0,r,0,r,0,1),e.translate(a,a,[n,s,0]);}return new Ft(i.tileID,t.key,a)}_findTileCoveringTileID(t,i){let o=i.getTile(t);if(o&&o.hasData())return o;const a=this._findCoveringTileCache[i.id],r=a[t.key];if(o=r?i.getTileByID(r):null,o&&o.hasData()||null===r)return o;let n=o?o.tileID:t,s=n.overscaledZ;const l=i.getSource().minzoom,c=[];if(!r){const a=i.getSource().maxzoom;if(t.canonical.z>=a){const o=t.canonical.z-a;i.getSource().reparseOverscaled?(s=Math.max(t.canonical.z+2,i.transform.tileZoom),n=new e.OverscaledTileID(s,t.wrap,a,t.canonical.x>>o,t.canonical.y>>o)):0!==o&&(s=a,n=new e.OverscaledTileID(s,t.wrap,a,t.canonical.x>>o,t.canonical.y>>o));}n.key!==t.key&&(c.push(n.key),o=i.getTile(n));}const h=e=>{c.forEach(t=>{a[t]=e;}),c.length=0;};for(s-=1;s>=l&&(!o||!o.hasData());s--){o&&h(o.tileID.key);const e=n.calculateScaledKey(s);if(o=i.getTileByID(e),o&&o.hasData())break;const t=a[e];if(null===t)break;void 0===t?c.push(e):o=i.getTileByID(t);}return h(o?o.tileID.key:null),o&&o.hasData()?o:null}findDEMTileFor(e){return this.enabled?this._findTileCoveringTileID(e,this.sourceCache):null}prepareDrawTile(e){this.renderedToTile||(this.renderedToTile=!0);}_clearRenderCacheForTile(e,t){let i=this._tilesDirty[e];i||(i=this._tilesDirty[e]={}),i[t.key]=!0;}}function Ut(e){const t=[];for(let i=0;i<e.length;i++){if(null===e[i])continue;const o=e[i].split(" ");t.push(o.pop());}return t}class Nt{static cacheKey(e,t,i){let o=`${e}${i?i.cacheKey:""}`;for(const e of t)o+=`/${e}`;return o}constructor(t,i,o,a,r,n){const s=t.gl;this.program=s.createProgram();const l=Ut(o.staticAttributes),c=a?a.getBinderAttributes():[],h=l.concat(c),u=o.staticUniforms?Ut(o.staticUniforms):[],d=a?a.getBinderUniforms():[],_=u.concat(d),m=[];for(const e of _)m.indexOf(e)<0&&m.push(e);let p=a?a.defines():[];p=p.concat(n.map(e=>`#define ${e}`));const f=p.concat(qe.fragmentSource,o.fragmentSource).join("\n"),g=p.concat(qe.vertexSource,Ve.vertexSource,o.vertexSource).join("\n"),v=s.createShader(s.FRAGMENT_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(v,f),s.compileShader(v),s.attachShader(this.program,v);const x=s.createShader(s.VERTEX_SHADER);if(s.isContextLost())return void(this.failedToCreate=!0);s.shaderSource(x,g),s.compileShader(x),s.attachShader(this.program,x),this.attributes={};const y={};this.numAttributes=h.length;for(let e=0;e<this.numAttributes;e++)h[e]&&(s.bindAttribLocation(this.program,e,h[e]),this.attributes[h[e]]=e);s.linkProgram(this.program),s.deleteShader(x),s.deleteShader(v);for(let e=0;e<m.length;e++){const t=m[e];if(t&&!y[t]){const e=s.getUniformLocation(this.program,t);e&&(y[t]=e);}}this.fixedUniforms=r(t,y),this.binderUniforms=a?a.getUniforms(t,y):[],-1!==n.indexOf("TERRAIN")&&(this.terrainUniforms=((t,i)=>({u_dem:new e.Uniform1i(t,i.u_dem),u_dem_prev:new e.Uniform1i(t,i.u_dem_prev),u_dem_unpack:new e.Uniform4f(t,i.u_dem_unpack),u_dem_tl:new e.Uniform2f(t,i.u_dem_tl),u_dem_scale:new e.Uniform1f(t,i.u_dem_scale),u_dem_tl_prev:new e.Uniform2f(t,i.u_dem_tl_prev),u_dem_scale_prev:new e.Uniform1f(t,i.u_dem_scale_prev),u_dem_size:new e.Uniform1f(t,i.u_dem_size),u_dem_lerp:new e.Uniform1f(t,i.u_dem_lerp),u_exaggeration:new e.Uniform1f(t,i.u_exaggeration),u_depth:new e.Uniform1i(t,i.u_depth),u_depth_size_inv:new e.Uniform2f(t,i.u_depth_size_inv),u_meter_to_dem:new e.Uniform1f(t,i.u_meter_to_dem),u_label_plane_matrix_inv:new e.UniformMatrix4f(t,i.u_label_plane_matrix_inv)}))(t,y));}setTerrainUniformValues(e,t){if(!this.terrainUniforms)return;const i=this.terrainUniforms;if(!this.failedToCreate){e.program.set(this.program);for(const e in t)i[e].set(t[e]);}}draw(e,t,i,o,a,r,n,s,l,c,h,u,d,_,m,p){const f=e.gl;if(this.failedToCreate)return;e.program.set(this.program),e.setDepthMode(i),e.setStencilMode(o),e.setColorMode(a),e.setCullFace(r);for(const e in this.fixedUniforms)this.fixedUniforms[e].set(n[e]);_&&_.setUniforms(e,this.binderUniforms,u,{zoom:d});const g={[f.LINES]:2,[f.TRIANGLES]:3,[f.LINE_STRIP]:1}[t];for(const i of h.get()){const o=i.vaos||(i.vaos={});(o[s]||(o[s]=new Tt)).bind(e,this,l,_?_.getPaintVertexBuffers():[],c,i.vertexOffset,m,p),f.drawElements(t,i.primitiveLength*g,f.UNSIGNED_SHORT,i.primitiveOffset*g*2);}}}function Zt(e,t,i){const o=1/v(i,1,t.transform.tileZoom),a=Math.pow(2,i.tileID.overscaledZ),r=i.tileSize*Math.pow(2,t.transform.tileZoom)/a,n=r*(i.tileID.canonical.x+i.tileID.wrap*a),s=r*i.tileID.canonical.y;return {u_image:0,u_texsize:i.imageAtlasTexture.size,u_scale:[o,e.fromScale,e.toScale],u_fade:e.t,u_pixel_coord_upper:[n>>16,s>>16],u_pixel_coord_lower:[65535&n,65535&s]}}const Gt=(t,i,o,a)=>{const r=i.style.light,n=r.properties.get("position"),s=[n.x,n.y,n.z],l=e.create$1();"viewport"===r.properties.get("anchor")&&(e.fromRotation(l,-i.transform.angle),e.transformMat3(s,s,l));const c=r.properties.get("color");return {u_matrix:t,u_lightpos:s,u_lightintensity:r.properties.get("intensity"),u_lightcolor:[c.r,c.g,c.b],u_vertical_gradient:+o,u_opacity:a}},Vt=(t,i,o,a,r,n,s)=>e.extend(Gt(t,i,o,a),Zt(n,i,s),{u_height_factor:-Math.pow(2,r.overscaledZ)/s.tileSize/8}),qt=e=>({u_matrix:e}),jt=(t,i,o,a)=>e.extend(qt(t),Zt(o,i,a)),$t=(e,t)=>({u_matrix:e,u_world:t}),Xt=(t,i,o,a,r)=>e.extend(jt(t,i,o,a),{u_world:r}),Wt=(t,i,o,a)=>{const r=t.transform;let n;if("map"===a.paint.get("circle-pitch-alignment")){const e=v(o,1,r.zoom);n=[e,e];}else n=r.pixelsToGLUnits;return {u_camera_to_center_distance:r.cameraToCenterDistance,u_matrix:t.translatePosMatrix(i.posMatrix,o,a.paint.get("circle-translate"),a.paint.get("circle-translate-anchor")),u_device_pixel_ratio:e.browser.devicePixelRatio,u_extrude_scale:n}},Ht=e=>{const t=[];return "map"===e.paint.get("circle-pitch-alignment")&&t.push("PITCH_WITH_MAP"),"map"===e.paint.get("circle-pitch-scale")&&t.push("SCALE_WITH_MAP"),t},Kt=(t,i,o)=>{const a=e.EXTENT/o.tileSize;return {u_matrix:t,u_camera_to_center_distance:i.cameraToCenterDistance,u_extrude_scale:[i.pixelsToGLUnits[0]/a,i.pixelsToGLUnits[1]/a]}},Yt=(e,t,i=1)=>({u_matrix:e,u_color:t,u_overlay:0,u_overlay_scale:i}),Jt=(e,t,i,o)=>({u_matrix:e,u_extrude_scale:v(t,1,i),u_intensity:o}),Qt=(t,i,o,a)=>{const r=t.transform;return {u_matrix:ai(t,i,o,a),u_ratio:1/v(i,1,r.zoom),u_device_pixel_ratio:e.browser.devicePixelRatio,u_units_to_pixels:[1/r.pixelsToGLUnits[0],1/r.pixelsToGLUnits[1]]}},ei=(t,i,o,a,r)=>e.extend(Qt(t,i,o,a),{u_image:0,u_image_height:r}),ti=(t,i,o,a,r)=>{const n=t.transform,s=oi(i,n);return {u_matrix:ai(t,i,o,r),u_texsize:i.imageAtlasTexture.size,u_ratio:1/v(i,1,n.zoom),u_device_pixel_ratio:e.browser.devicePixelRatio,u_image:0,u_scale:[s,a.fromScale,a.toScale],u_fade:a.t,u_units_to_pixels:[1/n.pixelsToGLUnits[0],1/n.pixelsToGLUnits[1]]}},ii=(t,i,o,a,r,n)=>{const s=t.lineAtlas,l=oi(i,t.transform),c="round"===o.layout.get("line-cap"),h=s.getDash(a.from,c),u=s.getDash(a.to,c),d=h.width*r.fromScale,_=u.width*r.toScale;return e.extend(Qt(t,i,o,n),{u_patternscale_a:[l/d,-h.height/2],u_patternscale_b:[l/_,-u.height/2],u_sdfgamma:s.width/(256*Math.min(d,_)*e.browser.devicePixelRatio)/2,u_image:0,u_tex_y_a:h.y,u_tex_y_b:u.y,u_mix:r.t})};function oi(e,t){return 1/v(e,1,t.tileZoom)}function ai(e,t,i,o){return e.translatePosMatrix(o||t.tileID.posMatrix,t,i.paint.get("line-translate"),i.paint.get("line-translate-anchor"))}const ri=(e,t,i,o,a)=>{return {u_matrix:e,u_tl_parent:t,u_scale_parent:i,u_buffer_scale:1,u_fade_t:o.mix,u_opacity:o.opacity*a.paint.get("raster-opacity"),u_image0:0,u_image1:1,u_brightness_low:a.paint.get("raster-brightness-min"),u_brightness_high:a.paint.get("raster-brightness-max"),u_saturation_factor:(n=a.paint.get("raster-saturation"),n>0?1-1/(1.001-n):-n),u_contrast_factor:(r=a.paint.get("raster-contrast"),r>0?1/(1-r):1+r),u_spin_weights:ni(a.paint.get("raster-hue-rotate"))};var r,n;};function ni(e){e*=Math.PI/180;const t=Math.sin(e),i=Math.cos(e);return [(2*i+1)/3,(-Math.sqrt(3)*t-i+1)/3,(Math.sqrt(3)*t-i+1)/3]}const si=(e,t,i,o,a,r,n,s,l,c)=>{const h=a.transform;return {u_is_size_zoom_constant:+("constant"===e||"source"===e),u_is_size_feature_constant:+("constant"===e||"camera"===e),u_size_t:t?t.uSizeT:0,u_size:t?t.uSize:0,u_camera_to_center_distance:h.cameraToCenterDistance,u_pitch:h.pitch/360*2*Math.PI,u_rotate_symbol:+i,u_aspect_ratio:h.width/h.height,u_fade_change:a.options.fadeDuration?a.symbolFadeChange:1,u_matrix:r,u_label_plane_matrix:n,u_coord_matrix:s,u_is_text:+l,u_pitch_with_map:+o,u_texsize:c,u_texture:0}},li=(t,i,o,a,r,n,s,l,c,h,u)=>{const{cameraToCenterDistance:d,_pitch:_}=r.transform;return e.extend(si(t,i,o,a,r,n,s,l,c,h),{u_gamma_scale:a?d*Math.cos(r.terrain?0:_):1,u_device_pixel_ratio:e.browser.devicePixelRatio,u_is_halo:+u})},ci=(t,i,o,a,r,n,s,l,c,h)=>e.extend(li(t,i,o,a,r,n,s,l,!0,c,!0),{u_texsize_icon:h,u_texture_icon:1}),hi=(e,t,i)=>({u_matrix:e,u_opacity:t,u_color:i}),ui=(t,i,o,a,r,n)=>e.extend(function(e,t,i,o){const a=i.imageManager.getPattern(e.from.toString()),r=i.imageManager.getPattern(e.to.toString()),{width:n,height:s}=i.imageManager.getPixelSize(),l=Math.pow(2,o.tileID.overscaledZ),c=o.tileSize*Math.pow(2,i.transform.tileZoom)/l,h=c*(o.tileID.canonical.x+o.tileID.wrap*l),u=c*o.tileID.canonical.y;return {u_image:0,u_pattern_tl_a:a.tl,u_pattern_br_a:a.br,u_pattern_tl_b:r.tl,u_pattern_br_b:r.br,u_texsize:[n,s],u_mix:t.t,u_pattern_size_a:a.displaySize,u_pattern_size_b:r.displaySize,u_scale_a:t.fromScale,u_scale_b:t.toScale,u_tile_units_to_pixels:1/v(o,1,i.transform.tileZoom),u_pixel_coord_upper:[h>>16,u>>16],u_pixel_coord_lower:[65535&h,65535&u]}}(a,n,o,r),{u_matrix:t,u_opacity:i}),di={fillExtrusion:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_lightpos:new e.Uniform3f(t,i.u_lightpos),u_lightintensity:new e.Uniform1f(t,i.u_lightintensity),u_lightcolor:new e.Uniform3f(t,i.u_lightcolor),u_vertical_gradient:new e.Uniform1f(t,i.u_vertical_gradient),u_opacity:new e.Uniform1f(t,i.u_opacity)}),fillExtrusionPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_lightpos:new e.Uniform3f(t,i.u_lightpos),u_lightintensity:new e.Uniform1f(t,i.u_lightintensity),u_lightcolor:new e.Uniform3f(t,i.u_lightcolor),u_vertical_gradient:new e.Uniform1f(t,i.u_vertical_gradient),u_height_factor:new e.Uniform1f(t,i.u_height_factor),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade),u_opacity:new e.Uniform1f(t,i.u_opacity)}),fill:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),fillPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade)}),fillOutline:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_world:new e.Uniform2f(t,i.u_world)}),fillOutlinePattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_world:new e.Uniform2f(t,i.u_world),u_image:new e.Uniform1i(t,i.u_image),u_texsize:new e.Uniform2f(t,i.u_texsize),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade)}),circle:(t,i)=>({u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_extrude_scale:new e.Uniform2f(t,i.u_extrude_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),collisionBox:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_extrude_scale:new e.Uniform2f(t,i.u_extrude_scale)}),collisionCircle:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_inv_matrix:new e.UniformMatrix4f(t,i.u_inv_matrix),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_viewport_size:new e.Uniform2f(t,i.u_viewport_size)}),debug:(t,i)=>({u_color:new e.UniformColor(t,i.u_color),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_overlay:new e.Uniform1i(t,i.u_overlay),u_overlay_scale:new e.Uniform1f(t,i.u_overlay_scale)}),clippingMask:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),heatmap:(t,i)=>({u_extrude_scale:new e.Uniform1f(t,i.u_extrude_scale),u_intensity:new e.Uniform1f(t,i.u_intensity),u_matrix:new e.UniformMatrix4f(t,i.u_matrix)}),heatmapTexture:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_world:new e.Uniform2f(t,i.u_world),u_image:new e.Uniform1i(t,i.u_image),u_color_ramp:new e.Uniform1i(t,i.u_color_ramp),u_opacity:new e.Uniform1f(t,i.u_opacity)}),hillshade:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_latrange:new e.Uniform2f(t,i.u_latrange),u_light:new e.Uniform2f(t,i.u_light),u_shadow:new e.UniformColor(t,i.u_shadow),u_highlight:new e.UniformColor(t,i.u_highlight),u_accent:new e.UniformColor(t,i.u_accent)}),hillshadePrepare:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_image:new e.Uniform1i(t,i.u_image),u_dimension:new e.Uniform2f(t,i.u_dimension),u_zoom:new e.Uniform1f(t,i.u_zoom),u_unpack:new e.Uniform4f(t,i.u_unpack)}),line:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_ratio:new e.Uniform1f(t,i.u_ratio),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels)}),lineGradient:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_ratio:new e.Uniform1f(t,i.u_ratio),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels),u_image:new e.Uniform1i(t,i.u_image),u_image_height:new e.Uniform1f(t,i.u_image_height)}),linePattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_texsize:new e.Uniform2f(t,i.u_texsize),u_ratio:new e.Uniform1f(t,i.u_ratio),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_image:new e.Uniform1i(t,i.u_image),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels),u_scale:new e.Uniform3f(t,i.u_scale),u_fade:new e.Uniform1f(t,i.u_fade)}),lineSDF:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_ratio:new e.Uniform1f(t,i.u_ratio),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_units_to_pixels:new e.Uniform2f(t,i.u_units_to_pixels),u_patternscale_a:new e.Uniform2f(t,i.u_patternscale_a),u_patternscale_b:new e.Uniform2f(t,i.u_patternscale_b),u_sdfgamma:new e.Uniform1f(t,i.u_sdfgamma),u_image:new e.Uniform1i(t,i.u_image),u_tex_y_a:new e.Uniform1f(t,i.u_tex_y_a),u_tex_y_b:new e.Uniform1f(t,i.u_tex_y_b),u_mix:new e.Uniform1f(t,i.u_mix)}),raster:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_tl_parent:new e.Uniform2f(t,i.u_tl_parent),u_scale_parent:new e.Uniform1f(t,i.u_scale_parent),u_buffer_scale:new e.Uniform1f(t,i.u_buffer_scale),u_fade_t:new e.Uniform1f(t,i.u_fade_t),u_opacity:new e.Uniform1f(t,i.u_opacity),u_image0:new e.Uniform1i(t,i.u_image0),u_image1:new e.Uniform1i(t,i.u_image1),u_brightness_low:new e.Uniform1f(t,i.u_brightness_low),u_brightness_high:new e.Uniform1f(t,i.u_brightness_high),u_saturation_factor:new e.Uniform1f(t,i.u_saturation_factor),u_contrast_factor:new e.Uniform1f(t,i.u_contrast_factor),u_spin_weights:new e.Uniform3f(t,i.u_spin_weights)}),symbolIcon:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_texture:new e.Uniform1i(t,i.u_texture)}),symbolSDF:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_texture:new e.Uniform1i(t,i.u_texture),u_gamma_scale:new e.Uniform1f(t,i.u_gamma_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_is_halo:new e.Uniform1i(t,i.u_is_halo)}),symbolTextAndIcon:(t,i)=>({u_is_size_zoom_constant:new e.Uniform1i(t,i.u_is_size_zoom_constant),u_is_size_feature_constant:new e.Uniform1i(t,i.u_is_size_feature_constant),u_size_t:new e.Uniform1f(t,i.u_size_t),u_size:new e.Uniform1f(t,i.u_size),u_camera_to_center_distance:new e.Uniform1f(t,i.u_camera_to_center_distance),u_pitch:new e.Uniform1f(t,i.u_pitch),u_rotate_symbol:new e.Uniform1i(t,i.u_rotate_symbol),u_aspect_ratio:new e.Uniform1f(t,i.u_aspect_ratio),u_fade_change:new e.Uniform1f(t,i.u_fade_change),u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_label_plane_matrix:new e.UniformMatrix4f(t,i.u_label_plane_matrix),u_coord_matrix:new e.UniformMatrix4f(t,i.u_coord_matrix),u_is_text:new e.Uniform1i(t,i.u_is_text),u_pitch_with_map:new e.Uniform1i(t,i.u_pitch_with_map),u_texsize:new e.Uniform2f(t,i.u_texsize),u_texsize_icon:new e.Uniform2f(t,i.u_texsize_icon),u_texture:new e.Uniform1i(t,i.u_texture),u_texture_icon:new e.Uniform1i(t,i.u_texture_icon),u_gamma_scale:new e.Uniform1f(t,i.u_gamma_scale),u_device_pixel_ratio:new e.Uniform1f(t,i.u_device_pixel_ratio),u_is_halo:new e.Uniform1i(t,i.u_is_halo)}),background:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_opacity:new e.Uniform1f(t,i.u_opacity),u_color:new e.UniformColor(t,i.u_color)}),backgroundPattern:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_opacity:new e.Uniform1f(t,i.u_opacity),u_image:new e.Uniform1i(t,i.u_image),u_pattern_tl_a:new e.Uniform2f(t,i.u_pattern_tl_a),u_pattern_br_a:new e.Uniform2f(t,i.u_pattern_br_a),u_pattern_tl_b:new e.Uniform2f(t,i.u_pattern_tl_b),u_pattern_br_b:new e.Uniform2f(t,i.u_pattern_br_b),u_texsize:new e.Uniform2f(t,i.u_texsize),u_mix:new e.Uniform1f(t,i.u_mix),u_pattern_size_a:new e.Uniform2f(t,i.u_pattern_size_a),u_pattern_size_b:new e.Uniform2f(t,i.u_pattern_size_b),u_scale_a:new e.Uniform1f(t,i.u_scale_a),u_scale_b:new e.Uniform1f(t,i.u_scale_b),u_pixel_coord_upper:new e.Uniform2f(t,i.u_pixel_coord_upper),u_pixel_coord_lower:new e.Uniform2f(t,i.u_pixel_coord_lower),u_tile_units_to_pixels:new e.Uniform1f(t,i.u_tile_units_to_pixels)}),terrainRaster:Pt,terrainDepth:Pt,skybox:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_sun_direction:new e.Uniform3f(t,i.u_sun_direction),u_cubemap:new e.Uniform1i(t,i.u_cubemap),u_opacity:new e.Uniform1f(t,i.u_opacity),u_temporal_offset:new e.Uniform1f(t,i.u_temporal_offset)}),skyboxGradient:(t,i)=>({u_matrix:new e.UniformMatrix4f(t,i.u_matrix),u_color_ramp:new e.Uniform1i(t,i.u_color_ramp),u_center_direction:new e.Uniform3f(t,i.u_center_direction),u_radius:new e.Uniform1f(t,i.u_radius),u_opacity:new e.Uniform1f(t,i.u_opacity),u_temporal_offset:new e.Uniform1f(t,i.u_temporal_offset)}),skyboxCapture:(t,i)=>({u_matrix_3f:new e.UniformMatrix3f(t,i.u_matrix_3f),u_sun_direction:new e.Uniform3f(t,i.u_sun_direction),u_sun_intensity:new e.Uniform1f(t,i.u_sun_intensity),u_color_tint_r:new e.Uniform4f(t,i.u_color_tint_r),u_color_tint_m:new e.Uniform4f(t,i.u_color_tint_m),u_luminance:new e.Uniform1f(t,i.u_luminance)})};let _i;function mi(t,i,o,a,r,n,s){const l=t.context,c=l.gl,h=t.useProgram("collisionBox"),u=[];let d=0,_=0;for(let m=0;m<a.length;m++){const p=a[m],f=i.getTile(p),g=f.getBucket(o);if(!g)continue;let v=p.posMatrix;0===r[0]&&0===r[1]||(v=t.translatePosMatrix(p.posMatrix,f,r,n));const x=s?g.textCollisionBox:g.iconCollisionBox,y=g.collisionCircleArray;if(y.length>0){const i=e.create(),o=v;e.mul(i,g.placementInvProjMatrix,t.transform.glCoordMatrix),e.mul(i,i,g.placementViewportMatrix),u.push({circleArray:y,circleOffset:_,transform:o,invTransform:i}),d+=y.length/4,_=d;}x&&(t.terrain&&t.terrain.setupElevationDraw(f,h),h.draw(l,c.LINES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,Kt(v,t.transform,f),o.id,x.layoutVertexBuffer,x.indexBuffer,x.segments,null,t.transform.zoom,null,x.collisionVertexBuffer,x.collisionVertexBufferExt));}if(!s||!u.length)return;const m=t.useProgram("collisionCircle"),p=new e.StructArrayLayout2f1f2i16;p.resize(4*d),p._trim();let f=0;for(const e of u)for(let t=0;t<e.circleArray.length/4;t++){const i=4*t,o=e.circleArray[i+0],a=e.circleArray[i+1],r=e.circleArray[i+2],n=e.circleArray[i+3];p.emplace(f++,o,a,r,n,0),p.emplace(f++,o,a,r,n,1),p.emplace(f++,o,a,r,n,2),p.emplace(f++,o,a,r,n,3);}(!_i||_i.length<2*d)&&(_i=function(t){const i=2*t,o=new e.StructArrayLayout3ui6;o.resize(i),o._trim();for(let e=0;e<i;e++){const t=6*e;o.uint16[t+0]=4*e+0,o.uint16[t+1]=4*e+1,o.uint16[t+2]=4*e+2,o.uint16[t+3]=4*e+2,o.uint16[t+4]=4*e+3,o.uint16[t+5]=4*e+0;}return o}(d));const g=l.createIndexBuffer(_i,!0),v=l.createVertexBuffer(p,e.collisionCircleLayout.members,!0);for(const i of u){const a={u_matrix:i.transform,u_inv_matrix:i.invTransform,u_camera_to_center_distance:(x=t.transform).cameraToCenterDistance,u_viewport_size:[x.width,x.height]};m.draw(l,c.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,a,o.id,v,g,e.SegmentVector.simpleSegment(0,2*i.circleOffset,i.circleArray.length,i.circleArray.length/2),null,t.transform.zoom,null,null,null);}var x;v.destroy(),g.destroy();}const pi=e.identity(new Float32Array(16));function fi(t,i,o,a,r,n){const{horizontalAlign:s,verticalAlign:l}=e.getAnchorAlignment(t),c=-(s-.5)*i,h=-(l-.5)*o,u=e.evaluateVariableOffset(t,a);return new e.Point((c/r+u[0])*n,(h/r+u[1])*n)}function gi(t,i,o,a,r,n,s,l,c,h,u,d){const _=t.text.placedSymbolArray,m=t.text.dynamicLayoutVertexArray,p=t.icon.dynamicLayoutVertexArray,f={};m.clear();for(let p=0;p<_.length;p++){const g=_.get(p),v=t.allowVerticalPlacement&&!g.placedOrientation,x=g.hidden||!g.crossTileID||v?null:a[g.crossTileID];if(x){const a=new e.Point(g.anchorX,g.anchorY),_=d(a),p=Y(a,o?l:s,_),v=J(n.cameraToCenterDistance,p.signedDistanceFromCamera);let y=r.evaluateSizeForFeature(t.textSizeData,h,g)*v/e.ONE_EM;o&&(y*=t.tilePixelRatio/c);const{width:b,height:w,anchor:T,textOffset:E,textBoxScale:C}=x,S=fi(T,b,w,E,C,y),I=o?Y(a.add(S),s,_).point:p.point.add(i?S.rotate(-n.angle):S),P=t.allowVerticalPlacement&&g.placedOrientation===e.WritingMode.vertical?Math.PI/2:0;for(let t=0;t<g.numGlyphs;t++)e.addDynamicAttributes(m,I,P);u&&g.associatedIconIndex>=0&&(f[g.associatedIconIndex]={shiftedAnchor:I,angle:P});}else se(g.numGlyphs,m);}if(u){p.clear();const i=t.icon.placedSymbolArray;for(let t=0;t<i.length;t++){const o=i.get(t);if(o.hidden)se(o.numGlyphs,p);else {const i=f[t];if(i)for(let t=0;t<o.numGlyphs;t++)e.addDynamicAttributes(p,i.shiftedAnchor,i.angle);else se(o.numGlyphs,p);}}t.icon.dynamicLayoutVertexBuffer.updateData(p);}t.text.dynamicLayoutVertexBuffer.updateData(m);}function vi(e,t,i){return i.iconsInText&&t?"symbolTextAndIcon":e?"symbolSDF":"symbolIcon"}function xi(t,i,o,a,r,n,s,l,c,h,u,d){const _=t.context,m=_.gl,p=t.transform,f="map"===l,g="map"===c,x=f&&"point"!==o.layout.get("symbol-placement"),y=f&&!g&&!x,b=void 0!==o.layout.get("symbol-sort-key").constantOr(1);let w=!1;const T=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),E=o.layout.get("text-variable-anchor"),C=[],S=t.terrain&&g?["PITCH_WITH_MAP_TERRAIN"]:null;for(const l of a){const a=i.getTile(l),c=a.getBucket(o);if(!c)continue;const u=r?c.text:c.icon;if(!u||!u.segments.get().length)continue;const d=u.programConfigurations.get(o.id),_=r||c.sdfIcons,T=r?c.textSizeData:c.iconSizeData,I=g||0!==p.pitch,P=t.useProgram(vi(_,r,c),d,S),M=e.evaluateSizeForZoom(T,p.zoom);let z,A,D,L,R=[0,0],k=null;if(r){if(A=a.glyphAtlasTexture,D=m.LINEAR,z=a.glyphAtlasTexture.size,c.iconsInText){R=a.imageAtlasTexture.size,k=a.imageAtlasTexture;const e="composite"===T.kind||"camera"===T.kind;L=I||t.options.rotating||t.options.zooming||e?m.LINEAR:m.NEAREST;}}else {const e=1!==o.layout.get("icon-size").constantOr(0)||c.iconsNeedLinear;A=a.imageAtlasTexture,D=_||t.options.rotating||t.options.zooming||e||I?m.LINEAR:m.NEAREST,z=a.imageAtlasTexture.size;}const B=v(a,1,t.transform.zoom),F=H(l.posMatrix,g,f,t.transform,B),O=t.terrain&&g&&x?e.invert(new Float32Array(16),F):pi,U=K(l.posMatrix,g,f,t.transform,B),N=E&&c.hasTextData(),Z="none"!==o.layout.get("icon-text-fit")&&N&&c.hasIconData();if(x){const e=p.elevation;ee(c,l.posMatrix,t,r,F,U,g,h,e?t=>e.getAtTileOffset(l,t.x,t.y):null);}const G=t.translatePosMatrix(l.posMatrix,a,n,s),V=x||r&&E||Z?pi:F,q=t.translatePosMatrix(U,a,n,s,!0),j=_&&0!==o.paint.get(r?"text-halo-width":"icon-halo-width").constantOr(1);let $;$=_?c.iconsInText?ci(T.kind,M,y,g,t,G,V,q,z,R):li(T.kind,M,y,g,t,G,V,q,r,z,!0):si(T.kind,M,y,g,t,G,V,q,r,z);const X={program:P,buffers:u,uniformValues:$,atlasTexture:A,atlasTextureIcon:k,atlasInterpolation:D,atlasInterpolationIcon:L,isSDF:_,hasHalo:j,tile:a,labelPlaneMatrixInv:O};if(b&&c.canOverlap){w=!0;const t=u.segments.get();for(const i of t)C.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:X});}else C.push({segments:u.segments,sortKey:0,state:X});}w&&C.sort((e,t)=>e.sortKey-t.sortKey);for(const e of C){const i=e.state;if(t.terrain&&t.terrain.setupElevationDraw(i.tile,i.program,{useDepthForOcclusion:!0,labelPlaneMatrixInv:i.labelPlaneMatrixInv}),_.activeTexture.set(m.TEXTURE0),i.atlasTexture.bind(i.atlasInterpolation,m.CLAMP_TO_EDGE),i.atlasTextureIcon&&(_.activeTexture.set(m.TEXTURE1),i.atlasTextureIcon&&i.atlasTextureIcon.bind(i.atlasInterpolationIcon,m.CLAMP_TO_EDGE)),i.isSDF){const a=i.uniformValues;i.hasHalo&&(a.u_is_halo=1,yi(i.buffers,e.segments,o,t,i.program,T,u,d,a)),a.u_is_halo=0;}yi(i.buffers,e.segments,o,t,i.program,T,u,d,i.uniformValues);}}function yi(t,i,o,a,r,n,s,l,c){const h=a.context;r.draw(h,h.gl.TRIANGLES,n,s,l,e.CullFaceMode.disabled,c,o.id,t.layoutVertexBuffer,t.indexBuffer,i,o.paint,a.transform.zoom,t.programConfigurations.get(o.id),t.dynamicLayoutVertexBuffer,t.opacityVertexBuffer);}function bi(t,i,o,a,r,n,s){const l=t.context.gl,c=o.paint.get("fill-pattern"),h=c&&c.constantOr(1),u=o.getCrossfadeParameters();let d,_,m,p,f;s?(_=h&&!o.getPaintProperty("fill-outline-color")?"fillOutlinePattern":"fillOutline",d=l.LINES):(_=h?"fillPattern":"fill",d=l.TRIANGLES);for(const g of a){const a=i.getTile(g);if(h&&!a.patternsLoaded())continue;const v=a.getBucket(o);if(!v)continue;t.prepareDrawTile(g);const x=v.programConfigurations.get(o.id),y=t.useProgram(_,x);h&&(t.context.activeTexture.set(l.TEXTURE0),a.imageAtlasTexture.bind(l.LINEAR,l.CLAMP_TO_EDGE),x.updatePaintBuffers(u));const b=c.constantOr(null);if(b&&a.imageAtlas){const e=a.imageAtlas,t=e.patternPositions[b.to.toString()],i=e.patternPositions[b.from.toString()];t&&i&&x.setConstantPatternPositions(t,i);}const w=t.translatePosMatrix(g.posMatrix,a,o.paint.get("fill-translate"),o.paint.get("fill-translate-anchor"));if(s){p=v.indexBuffer2,f=v.segments2;const e=t.terrain&&t.terrain.renderingToTexture?t.terrain.drapeBufferSize:[l.drawingBufferWidth,l.drawingBufferHeight];m="fillOutlinePattern"===_&&h?Xt(w,t,u,a,e):$t(w,e);}else p=v.indexBuffer,f=v.segments,m=h?jt(w,t,u,a):qt(w);y.draw(t.context,d,r,t.stencilModeForClipping(g),n,e.CullFaceMode.disabled,m,o.id,v.layoutVertexBuffer,p,f,o.paint,t.transform.zoom,x);}}function wi(t,i,o,a,r,n,s){const l=t.context,c=l.gl,h=o.paint.get("fill-extrusion-pattern"),u=h.constantOr(1),d=o.getCrossfadeParameters(),_=o.paint.get("fill-extrusion-opacity");for(const m of a){const a=i.getTile(m),p=a.getBucket(o);if(!p)continue;const f=p.programConfigurations.get(o.id),g=t.useProgram(u?"fillExtrusionPattern":"fillExtrusion",f);if(t.terrain){const e=t.terrain;if(!p.enableTerrain)continue;if(e.setupElevationDraw(a,g,{useMeterToDem:!0}),Ti(l,i,m,p,o,e),!p.centroidVertexBuffer){const e=g.attributes.a_centroid_pos;void 0!==e&&c.vertexAttrib2f(e,0,0);}}u&&(t.context.activeTexture.set(c.TEXTURE0),a.imageAtlasTexture.bind(c.LINEAR,c.CLAMP_TO_EDGE),f.updatePaintBuffers(d));const v=h.constantOr(null);if(v&&a.imageAtlas){const e=a.imageAtlas,t=e.patternPositions[v.to.toString()],i=e.patternPositions[v.from.toString()];t&&i&&f.setConstantPatternPositions(t,i);}const x=t.translatePosMatrix(m.posMatrix,a,o.paint.get("fill-extrusion-translate"),o.paint.get("fill-extrusion-translate-anchor")),y=o.paint.get("fill-extrusion-vertical-gradient"),b=u?Vt(x,t,y,_,m,d,a):Gt(x,t,y,_);g.draw(l,l.gl.TRIANGLES,r,n,s,e.CullFaceMode.backCCW,b,o.id,p.layoutVertexBuffer,p.indexBuffer,p.segments,o.paint,t.transform.zoom,f,t.terrain?p.centroidVertexBuffer:null);}}function Ti(t,i,o,a,r,n){const s=[t=>{let i=t.canonical.x-1,o=t.wrap;return i<0&&(i=(1<<t.canonical.z)-1,o--),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>{let i=t.canonical.x+1,o=t.wrap;return i===1<<t.canonical.z&&(i=0,o++),new e.OverscaledTileID(t.overscaledZ,o,t.canonical.z,i,t.canonical.y)},t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,(0===t.canonical.y?1<<t.canonical.z:t.canonical.y)-1),t=>new e.OverscaledTileID(t.overscaledZ,t.wrap,t.canonical.z,t.canonical.x,t.canonical.y===(1<<t.canonical.z)-1?0:t.canonical.y+1)],l=e=>{const t=i.getSource().maxzoom;for(const o of [0,-1,1]){if(e.overscaledZ+o<t)continue;if(o>0&&e.overscaledZ<t)continue;const a=i.getTileByID(e.calculateScaledKey(e.overscaledZ+o));if(a&&a.hasData()){const e=a.getBucket(r);if(e)return e}}},c=[0,0,0],h=(t,i)=>(c[0]=Math.min(t.min.y,i.min.y),c[1]=Math.max(t.max.y,i.max.y),c[2]=e.EXTENT-i.min.x>t.max.x?i.min.x-e.EXTENT:t.max.x,c),u=(t,i)=>(c[0]=Math.min(t.min.x,i.min.x),c[1]=Math.max(t.max.x,i.max.x),c[2]=e.EXTENT-i.min.y>t.max.y?i.min.y-e.EXTENT:t.max.y,c),d=[(e,t)=>h(e,t),(e,t)=>h(t,e),(e,t)=>u(e,t),(e,t)=>u(t,e)],_=new e.Point(0,0);let m,p,f;const g=(t,i,a,r,s)=>{const l=[[r?a:t,r?t:a,0],[r?a:i,r?i:a,0]],c=s<0?e.EXTENT+s:s,h=[r?c:(t+i)/2,r?(t+i)/2:c,0];return 0===a&&s<0||0!==a&&s>0?n.getForTilePoints(f,[h],!0,p):l.push(h),n.getForTilePoints(o,l,!0,m),Math.max(l[0][2],l[1][2],h[2])/n.exaggeration()};for(let t=0;t<4;t++){const i=a.borders[t];if(0===i.length&&(a.borderDone[t]=!0),a.borderDone[t])continue;const r=f=s[t](o),c=l(r);if(!c||!c.enableTerrain)continue;if(p=n.findDEMTileFor(r),!p||!p.dem)continue;if(!m){const e=n.findDEMTileFor(o);if(!e||!e.dem)return;m=e;}const h=(t<2?1:5)-t,u=c.borders[h];let v=0;for(let o=0;o<i.length;o++){const r=a.featuresOnBorder[i[o]],n=r.borders[t];let s;for(;v<u.length&&(s=c.featuresOnBorder[u[v]],!(s.borders[h][1]>n[0]+3));)c.borderDone[h]||c.encodeCentroid(void 0,s,!1),v++;if(s&&v<u.length){const i=v;let o=0;for(;!(s.borders[h][0]>n[1]-3)&&(o++,++v!==u.length);)s=c.featuresOnBorder[u[v]];if(s=c.featuresOnBorder[u[i]],r.intersectsCount()>1||s.intersectsCount()>1||1!==o){1!==o&&(v=i),a.encodeCentroid(void 0,r,!1),c.borderDone[h]||c.encodeCentroid(void 0,s,!1);continue}const l=d[t](r,s),m=t%2?e.EXTENT-1:0;_.x=g(l[0],Math.min(e.EXTENT-1,l[1]),m,t<2,l[2]),_.y=0,a.encodeCentroid(_,r,!1),c.borderDone[h]||c.encodeCentroid(_,s,!1);}else a.encodeCentroid(void 0,r,!1);}a.borderDone[t]=a.needsCentroidUpdate=!0,c.borderDone[h]||(c.borderDone[h]=c.needsCentroidUpdate=!0);}(a.needsCentroidUpdate||!a.centroidVertexBuffer&&0!==a.centroidVertexArray.length)&&a.uploadCentroid(t);}const Ei=new e.Color(1,0,0,1),Ci=new e.Color(0,1,0,1),Si=new e.Color(0,0,1,1),Ii=new e.Color(1,0,1,1),Pi=new e.Color(0,1,1,1);function Mi(e,t,i,o){Ai(e,0,t+i/2,e.transform.width,i,o);}function zi(e,t,i,o){Ai(e,t-i/2,0,i,e.transform.height,o);}function Ai(t,i,o,a,r,n){const s=t.context,l=s.gl;l.enable(l.SCISSOR_TEST),l.scissor(i*e.browser.devicePixelRatio,o*e.browser.devicePixelRatio,a*e.browser.devicePixelRatio,r*e.browser.devicePixelRatio),s.clear({color:n}),l.disable(l.SCISSOR_TEST);}function Di(t,i,o){const a=t.context,r=a.gl,n=o.posMatrix,s=t.useProgram("debug"),l=i.getTileByID(o.key);t.terrain&&t.terrain.setupElevationDraw(l,s);const c=e.DepthMode.disabled,h=e.StencilMode.disabled,u=t.colorModeForRenderPass();a.activeTexture.set(r.TEXTURE0),t.emptyTexture.bind(r.LINEAR,r.CLAMP_TO_EDGE),s.draw(a,r.LINE_STRIP,c,h,u,e.CullFaceMode.disabled,Yt(n,e.Color.red),"$debug",t.debugBuffer,t.tileBorderIndexBuffer,t.debugSegments);const d=l.latestRawTileData,_=Math.floor((d&&d.byteLength||0)/1024),m=i.getTile(o).tileSize,p=512/Math.min(m,512)*(o.overscaledZ/t.transform.zoom)*.5;let f=o.canonical.toString();o.overscaledZ!==o.canonical.z&&(f+=` => ${o.overscaledZ}`),function(e,t){e.initDebugOverlayCanvas();const i=e.debugOverlayCanvas,o=e.context.gl,a=e.debugOverlayCanvas.getContext("2d");a.clearRect(0,0,i.width,i.height),a.shadowColor="white",a.shadowBlur=2,a.lineWidth=1.5,a.strokeStyle="white",a.textBaseline="top",a.font="bold 36px Open Sans, sans-serif",a.fillText(t,5,5),a.strokeText(t,5,5),e.debugOverlayTexture.update(i),e.debugOverlayTexture.bind(o.LINEAR,o.CLAMP_TO_EDGE);}(t,`${f} ${_}kb`),s.draw(a,r.TRIANGLES,c,h,e.ColorMode.alphaBlended,e.CullFaceMode.disabled,Yt(n,e.Color.transparent,p),"$debug",t.debugBuffer,t.quadTriangleIndexBuffer,t.debugSegments);}const Li=e.createLayout([{name:"a_pos_3f",components:3,type:"Float32"}]),{members:Ri}=Li;function ki(e,t,i,o){e.emplaceBack(t,i,o);}class Bi{constructor(t){this.vertexArray=new e.StructArrayLayout3f12,this.indices=new e.StructArrayLayout3ui6,ki(this.vertexArray,-1,-1,1),ki(this.vertexArray,1,-1,1),ki(this.vertexArray,-1,1,1),ki(this.vertexArray,1,1,1),ki(this.vertexArray,-1,-1,-1),ki(this.vertexArray,1,-1,-1),ki(this.vertexArray,-1,1,-1),ki(this.vertexArray,1,1,-1),this.indices.emplaceBack(5,1,3),this.indices.emplaceBack(3,7,5),this.indices.emplaceBack(6,2,0),this.indices.emplaceBack(0,4,6),this.indices.emplaceBack(2,6,7),this.indices.emplaceBack(7,3,2),this.indices.emplaceBack(5,4,0),this.indices.emplaceBack(0,1,5),this.indices.emplaceBack(0,2,3),this.indices.emplaceBack(3,1,0),this.indices.emplaceBack(7,6,4),this.indices.emplaceBack(4,5,7),this.vertexBuffer=t.createVertexBuffer(this.vertexArray,Ri),this.indexBuffer=t.createIndexBuffer(this.indices),this.segment=e.SegmentVector.simpleSegment(0,0,36,12);}}function Fi(t,i,o,a,r,n){const s=t.gl,l=i.paint.get("sky-atmosphere-color"),c=i.paint.get("sky-atmosphere-halo-color"),h=i.paint.get("sky-atmosphere-sun-intensity"),u=((e,t,i,o,a)=>({u_matrix_3f:e,u_sun_direction:t,u_sun_intensity:i,u_color_tint_r:[o.r,o.g,o.b,o.a],u_color_tint_m:[a.r,a.g,a.b,a.a],u_luminance:5e-5}))(e.fromMat4([],a),r,h,l,c);s.framebufferTexture2D(s.FRAMEBUFFER,s.COLOR_ATTACHMENT0,s.TEXTURE_CUBE_MAP_POSITIVE_X+n,i.skyboxTexture,0),o.draw(t,s.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,e.ColorMode.unblended,e.CullFaceMode.frontCW,u,"skyboxCapture",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}const Oi={symbol:function(t,i,o,a,r){if("translucent"!==t.renderPass)return;const n=e.StencilMode.disabled,s=t.colorModeForRenderPass();o.layout.get("text-variable-anchor")&&function(t,i,o,a,r,n,s){const l=i.transform,c="map"===r,h="map"===n;for(const r of t){const t=a.getTile(r),n=t.getBucket(o);if(!n||!n.text||!n.text.segments.get().length)continue;const u=e.evaluateSizeForZoom(n.textSizeData,l.zoom),d=v(t,1,i.transform.zoom),_=H(r.posMatrix,h,c,i.transform,d),m="none"!==o.layout.get("icon-text-fit")&&n.hasIconData();if(u){const i=Math.pow(2,l.zoom-t.tileID.overscaledZ),o=l.elevation;gi(n,c,h,s,e.symbolSize,l,_,r.posMatrix,i,u,m,o?e=>o.getAtTileOffset(r,e.x,e.y):e=>0);}}}(a,t,o,i,o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),r),0!==o.paint.get("icon-opacity").constantOr(1)&&xi(t,i,o,a,!1,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),o.layout.get("icon-rotation-alignment"),o.layout.get("icon-pitch-alignment"),o.layout.get("icon-keep-upright"),n,s),0!==o.paint.get("text-opacity").constantOr(1)&&xi(t,i,o,a,!0,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),o.layout.get("text-rotation-alignment"),o.layout.get("text-pitch-alignment"),o.layout.get("text-keep-upright"),n,s),i.map.showCollisionBoxes&&(mi(t,i,o,a,o.paint.get("text-translate"),o.paint.get("text-translate-anchor"),!0),mi(t,i,o,a,o.paint.get("icon-translate"),o.paint.get("icon-translate-anchor"),!1));},circle:function(t,i,o,a){if("translucent"!==t.renderPass)return;const r=o.paint.get("circle-opacity"),n=o.paint.get("circle-stroke-width"),s=o.paint.get("circle-stroke-opacity"),l=void 0!==o.layout.get("circle-sort-key").constantOr(1);if(0===r.constantOr(1)&&(0===n.constantOr(1)||0===s.constantOr(1)))return;const c=t.context,h=c.gl,u=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),d=e.StencilMode.disabled,_=t.colorModeForRenderPass(),m=[];for(let r=0;r<a.length;r++){const n=a[r],s=i.getTile(n),c=s.getBucket(o);if(!c)continue;const h=c.programConfigurations.get(o.id),u=Ht(o),d={programConfiguration:h,program:t.useProgram("circle",h,u),layoutVertexBuffer:c.layoutVertexBuffer,indexBuffer:c.indexBuffer,uniformValues:Wt(t,n,s,o),tile:s};if(l){const t=c.segments.get();for(const i of t)m.push({segments:new e.SegmentVector([i]),sortKey:i.sortKey,state:d});}else m.push({segments:c.segments,sortKey:0,state:d});}l&&m.sort((e,t)=>e.sortKey-t.sortKey);for(const i of m){const{programConfiguration:a,program:r,layoutVertexBuffer:n,indexBuffer:s,uniformValues:l,tile:m}=i.state,p=i.segments;t.terrain&&t.terrain.setupElevationDraw(m,r,{useDepthForOcclusion:!0}),r.draw(c,h.TRIANGLES,u,d,_,e.CullFaceMode.disabled,l,o.id,n,s,p,o.paint,t.transform.zoom,a);}},heatmap:function(t,i,o,a){if(0!==o.paint.get("heatmap-opacity"))if("offscreen"===t.renderPass){const r=t.context,n=r.gl,s=e.StencilMode.disabled,l=new e.ColorMode([n.ONE,n.ONE],e.Color.transparent,[!0,!0,!0,!0]);!function(e,t,i){const o=e.gl;e.activeTexture.set(o.TEXTURE1),e.viewport.set([0,0,t.width/4,t.height/4]);let a=i.heatmapFbo;if(a)o.bindTexture(o.TEXTURE_2D,a.colorAttachment.get()),e.bindFramebuffer.set(a.framebuffer);else {const r=o.createTexture();o.bindTexture(o.TEXTURE_2D,r),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_S,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_WRAP_T,o.CLAMP_TO_EDGE),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MIN_FILTER,o.LINEAR),o.texParameteri(o.TEXTURE_2D,o.TEXTURE_MAG_FILTER,o.LINEAR),a=i.heatmapFbo=e.createFramebuffer(t.width/4,t.height/4,!1),function(e,t,i,o){const a=e.gl;a.texImage2D(a.TEXTURE_2D,0,a.RGBA,t.width/4,t.height/4,0,a.RGBA,e.extRenderToTextureHalfFloat?e.extTextureHalfFloat.HALF_FLOAT_OES:a.UNSIGNED_BYTE,null),o.colorAttachment.set(i);}(e,t,r,a);}}(r,t,o),r.clear({color:e.Color.transparent});for(let c=0;c<a.length;c++){const h=a[c];if(i.hasRenderableParent(h))continue;const u=i.getTile(h),d=u.getBucket(o);if(!d)continue;const _=d.programConfigurations.get(o.id),m=t.useProgram("heatmap",_),{zoom:p}=t.transform;t.terrain&&t.terrain.setupElevationDraw(u,m),m.draw(r,n.TRIANGLES,e.DepthMode.disabled,s,l,e.CullFaceMode.disabled,Jt(h.posMatrix,u,p,o.paint.get("heatmap-intensity")),o.id,d.layoutVertexBuffer,d.indexBuffer,d.segments,o.paint,t.transform.zoom,_);}r.viewport.set([0,0,t.width,t.height]);}else "translucent"===t.renderPass&&(t.context.setColorMode(t.colorModeForRenderPass()),function(t,i){const o=t.context,a=o.gl,r=i.heatmapFbo;if(!r)return;o.activeTexture.set(a.TEXTURE0),a.bindTexture(a.TEXTURE_2D,r.colorAttachment.get()),o.activeTexture.set(a.TEXTURE1);let n=i.colorRampTexture;n||(n=i.colorRampTexture=new e.Texture(o,i.colorRamp,a.RGBA)),n.bind(a.LINEAR,a.CLAMP_TO_EDGE),t.useProgram("heatmapTexture").draw(o,a.TRIANGLES,e.DepthMode.disabled,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.disabled,((t,i,o,a)=>{const r=e.create();e.ortho(r,0,t.width,t.height,0,0,1);const n=t.context.gl;return {u_matrix:r,u_world:[n.drawingBufferWidth,n.drawingBufferHeight],u_image:0,u_color_ramp:1,u_opacity:i.paint.get("heatmap-opacity")}})(t,i),i.id,t.viewportBuffer,t.quadTriangleIndexBuffer,t.viewportSegments,i.paint,t.transform.zoom);}(t,o));},line:function(t,i,o,a){if("translucent"!==t.renderPass)return;const r=o.paint.get("line-opacity"),n=o.paint.get("line-width");if(0===r.constantOr(1)||0===n.constantOr(1))return;const s=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),l=t.colorModeForRenderPass(),c=o.paint.get("line-dasharray"),h=o.paint.get("line-pattern"),u=h.constantOr(1),d=o.paint.get("line-gradient"),_=o.getCrossfadeParameters(),m=u?"linePattern":c?"lineSDF":d?"lineGradient":"line",p=t.context,f=p.gl;let g=!0;for(const r of a){const a=i.getTile(r);if(u&&!a.patternsLoaded())continue;const n=a.getBucket(o);if(!n)continue;t.prepareDrawTile(r);const v=n.programConfigurations.get(o.id),x=t.context.program.get(),y=t.useProgram(m,v),b=g||y.program!==x,w=h.constantOr(null);if(w&&a.imageAtlas){const e=a.imageAtlas,t=e.patternPositions[w.to.toString()],i=e.patternPositions[w.from.toString()];t&&i&&v.setConstantPatternPositions(t,i);}const T=t.terrain?r.posMatrix:null,E=u?ti(t,a,o,_,T):c?ii(t,a,o,c,_,T):d?ei(t,a,o,T,n.lineClipsArray.length):Qt(t,a,o,T);if(u)p.activeTexture.set(f.TEXTURE0),a.imageAtlasTexture.bind(f.LINEAR,f.CLAMP_TO_EDGE),v.updatePaintBuffers(_);else if(c&&(b||t.lineAtlas.dirty))p.activeTexture.set(f.TEXTURE0),t.lineAtlas.bind(p);else if(d){const a=n.gradients[o.id];let s=a.texture;if(o.gradientVersion!==a.version){let l=256;if(o.stepInterpolant){const o=i.getSource().maxzoom,a=r.canonical.z===o?Math.ceil(1<<t.transform.maxZoom-r.canonical.z):1;l=e.clamp(e.nextPowerOfTwo(n.maxLineLength/e.EXTENT*1024*a),256,p.maxTextureSize);}a.gradient=e.renderColorRamp({expression:o.gradientExpression(),evaluationKey:"lineProgress",resolution:l,image:a.gradient||void 0,clips:n.lineClipsArray}),a.texture?a.texture.update(a.gradient):a.texture=new e.Texture(p,a.gradient,f.RGBA),a.version=o.gradientVersion,s=a.texture;}p.activeTexture.set(f.TEXTURE0),s.bind(o.stepInterpolant?f.NEAREST:f.LINEAR,f.CLAMP_TO_EDGE);}y.draw(p,f.TRIANGLES,s,t.stencilModeForClipping(r),l,e.CullFaceMode.disabled,E,o.id,n.layoutVertexBuffer,n.indexBuffer,n.segments,o.paint,t.transform.zoom,v,n.layoutVertexBuffer2),g=!1;}},fill:function(t,i,o,a){const r=o.paint.get("fill-color"),n=o.paint.get("fill-opacity");if(0===n.constantOr(1))return;const s=t.colorModeForRenderPass(),l=o.paint.get("fill-pattern"),c=t.opaquePassEnabledForLayer()&&!l.constantOr(1)&&1===r.constantOr(e.Color.transparent).a&&1===n.constantOr(0)?"opaque":"translucent";if(t.renderPass===c){const r=t.depthModeForSublayer(1,"opaque"===t.renderPass?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly);bi(t,i,o,a,r,s,!1);}if("translucent"===t.renderPass&&o.paint.get("fill-antialias")){const r=t.depthModeForSublayer(o.getPaintProperty("fill-outline-color")?2:0,e.DepthMode.ReadOnly);bi(t,i,o,a,r,s,!0);}},"fill-extrusion":function(t,i,o,a){const r=o.paint.get("fill-extrusion-opacity");if(0!==r&&"translucent"===t.renderPass){const n=new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D);if(1!==r||o.paint.get("fill-extrusion-pattern").constantOr(1))wi(t,i,o,a,n,e.StencilMode.disabled,e.ColorMode.disabled),wi(t,i,o,a,n,t.stencilModeFor3D(),t.colorModeForRenderPass());else {const r=t.colorModeForRenderPass();wi(t,i,o,a,n,e.StencilMode.disabled,r);}}},hillshade:function(t,i,o,a){if("offscreen"!==t.renderPass&&"translucent"!==t.renderPass)return;const r=t.context,n=t.depthModeForSublayer(0,e.DepthMode.ReadOnly),s=t.colorModeForRenderPass(),l=t.terrain&&t.terrain.renderingToTexture,[c,h]="translucent"!==t.renderPass||l?[{},a]:t.stencilConfigForOverlap(a);for(const a of h){const r=i.getTile(a);if(r.needsHillshadePrepare&&"offscreen"===t.renderPass)It(t,r,o,n,e.StencilMode.disabled,s);else if("translucent"===t.renderPass){const e=l&&t.terrain?t.terrain.stencilModeForRTTOverlap(a):c[a.overscaledZ];Ct(t,a,r,o,n,e,s);}}r.viewport.set([0,0,t.width,t.height]);},raster:function(t,i,o,a,r,n){if("translucent"!==t.renderPass)return;if(0===o.paint.get("raster-opacity"))return;if(!a.length)return;const s=t.context,l=s.gl,c=i.getSource(),h=t.useProgram("raster"),u=t.colorModeForRenderPass(),d=t.terrain&&t.terrain.renderingToTexture,[_,m]=c instanceof C||d?[{},a]:t.stencilConfigForOverlap(a),p=m[m.length-1].overscaledZ,f=!t.options.moving;for(const a of m){const r=d?e.DepthMode.disabled:t.depthModeForSublayer(a.overscaledZ-p,1===o.paint.get("raster-opacity")?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly,l.LESS),m=i.getTile(a);if(d&&(!m||!m.hasData()))continue;const g=d?a.posMatrix:t.transform.calculatePosMatrix(a.toUnwrapped(),f),v=t.terrain&&d?t.terrain.stencilModeForRTTOverlap(a):_[a.overscaledZ],x=n?0:o.paint.get("raster-fade-duration");m.registerFadeDuration(x);const y=i.findLoadedParent(a,0),b=kt(m,y,i,t.transform,x);let w,T;t.terrain&&t.terrain.prepareDrawTile(a);const E="nearest"===o.paint.get("raster-resampling")?l.NEAREST:l.LINEAR;s.activeTexture.set(l.TEXTURE0),m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),s.activeTexture.set(l.TEXTURE1),y?(y.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST),w=Math.pow(2,y.tileID.overscaledZ-m.tileID.overscaledZ),T=[m.tileID.canonical.x*w%1,m.tileID.canonical.y*w%1]):m.texture.bind(E,l.CLAMP_TO_EDGE,l.LINEAR_MIPMAP_NEAREST);const S=ri(g,T||[0,0],w||1,b,o);c instanceof C?h.draw(s,l.TRIANGLES,r,e.StencilMode.disabled,u,e.CullFaceMode.disabled,S,o.id,c.boundsBuffer,t.quadTriangleIndexBuffer,c.boundsSegments):h.draw(s,l.TRIANGLES,r,v,u,e.CullFaceMode.disabled,S,o.id,t.rasterBoundsBuffer,t.quadTriangleIndexBuffer,t.rasterBoundsSegments);}},background:function(t,i,o,a){const r=o.paint.get("background-color"),n=o.paint.get("background-opacity");if(0===n)return;const s=t.context,l=s.gl,c=t.transform,h=c.tileSize,u=o.paint.get("background-pattern");if(t.isPatternMissing(u))return;const d=!u&&1===r.a&&1===n&&t.opaquePassEnabledForLayer()?"opaque":"translucent";if(t.renderPass!==d)return;const _=e.StencilMode.disabled,m=t.depthModeForSublayer(0,"opaque"===d?e.DepthMode.ReadWrite:e.DepthMode.ReadOnly),p=t.colorModeForRenderPass(),f=t.useProgram(u?"backgroundPattern":"background"),g=a||c.coveringTiles({tileSize:h});u&&(s.activeTexture.set(l.TEXTURE0),t.imageManager.bind(t.context));const v=o.getCrossfadeParameters();for(const i of g){const c=a?i.posMatrix:t.transform.calculatePosMatrix(i.toUnwrapped());t.prepareDrawTile(i);const d=u?ui(c,n,t,u,{tileID:i,tileSize:h},v):hi(c,n,r);f.draw(s,l.TRIANGLES,m,_,p,e.CullFaceMode.disabled,d,o.id,t.tileExtentBuffer,t.quadTriangleIndexBuffer,t.tileExtentSegments);}},sky:function(t,i,o){const a=o.paint.get("sky-opacity");if(0===a)return;const r=t.context,n=o.paint.get("sky-type"),s=new e.DepthMode(r.gl.LEQUAL,e.DepthMode.ReadOnly,[0,1]),l=t.frameCounter/1e3%1;"atmosphere"===n?"offscreen"===t.renderPass?o.needsSkyboxCapture(t)&&(function(t,i,o,a){const r=t.context,n=r.gl;let s=i.skyboxFbo;if(!s){s=i.skyboxFbo=r.createFramebuffer(32,32,!1),i.skyboxGeometry=new Bi(r),i.skyboxTexture=r.gl.createTexture(),n.bindTexture(n.TEXTURE_CUBE_MAP,i.skyboxTexture),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_S,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_WRAP_T,n.CLAMP_TO_EDGE),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MIN_FILTER,n.LINEAR),n.texParameteri(n.TEXTURE_CUBE_MAP,n.TEXTURE_MAG_FILTER,n.LINEAR);for(let e=0;e<6;++e)n.texImage2D(n.TEXTURE_CUBE_MAP_POSITIVE_X+e,0,n.RGBA,32,32,0,n.RGBA,n.UNSIGNED_BYTE,null);}r.bindFramebuffer.set(s.framebuffer),r.viewport.set([0,0,32,32]);const l=i.getCenter(t,!0),c=t.useProgram("skyboxCapture"),h=new Float64Array(16);e.identity(h),e.rotateY(h,h,.5*-Math.PI),Fi(r,i,c,h,l,0),e.identity(h),e.rotateY(h,h,.5*Math.PI),Fi(r,i,c,h,l,1),e.identity(h),e.rotateX(h,h,.5*-Math.PI),Fi(r,i,c,h,l,2),e.identity(h),e.rotateX(h,h,.5*Math.PI),Fi(r,i,c,h,l,3),e.identity(h),Fi(r,i,c,h,l,4),e.identity(h),e.rotateY(h,h,Math.PI),Fi(r,i,c,h,l,5),r.viewport.set([0,0,t.width,t.height]);}(t,o),o.markSkyboxValid(t)):"sky"===t.renderPass&&function(t,i,o,a,r){const n=t.context,s=n.gl,l=t.transform,c=t.useProgram("skybox");n.activeTexture.set(s.TEXTURE0),s.bindTexture(s.TEXTURE_CUBE_MAP,i.skyboxTexture);const h=((e,t,i,o,a)=>({u_matrix:e,u_sun_direction:t,u_cubemap:0,u_opacity:o,u_temporal_offset:a}))(l.skyboxMatrix,i.getCenter(t,!1),0,a,r);c.draw(n,s.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,h,"skybox",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,s,a,l):"gradient"===n&&"sky"===t.renderPass&&function(t,i,o,a,r){const n=t.context,s=n.gl,l=t.transform,c=t.useProgram("skyboxGradient");i.skyboxGeometry||(i.skyboxGeometry=new Bi(n)),n.activeTexture.set(s.TEXTURE0);let h=i.colorRampTexture;h||(h=i.colorRampTexture=new e.Texture(n,i.colorRamp,s.RGBA)),h.bind(s.LINEAR,s.CLAMP_TO_EDGE);const u=((t,i,o,a,r)=>({u_matrix:t,u_color_ramp:0,u_center_direction:i,u_radius:e.degToRad(o),u_opacity:a,u_temporal_offset:r}))(l.skyboxMatrix,i.getCenter(t,!1),i.paint.get("sky-gradient-radius"),a,r);c.draw(n,s.TRIANGLES,o,e.StencilMode.disabled,t.colorModeForRenderPass(),e.CullFaceMode.backCW,u,"skyboxGradient",i.skyboxGeometry.vertexBuffer,i.skyboxGeometry.indexBuffer,i.skyboxGeometry.segment);}(t,o,s,a,l);},debug:function(e,t,i){for(let o=0;o<i.length;o++)Di(e,t,i[o]);},custom:function(t,i,o){const a=t.context,r=o.implementation;if("offscreen"===t.renderPass){const e=r.prerender;e&&(t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),e.call(r,a.gl,t.transform.customLayerMatrix()),a.setDirty(),t.setBaseState());}else if("translucent"===t.renderPass){t.setCustomLayerDefaults(),a.setColorMode(t.colorModeForRenderPass()),a.setStencilMode(e.StencilMode.disabled);const i="3d"===r.renderingMode?new e.DepthMode(t.context.gl.LEQUAL,e.DepthMode.ReadWrite,t.depthRangeFor3D):t.depthModeForSublayer(0,e.DepthMode.ReadOnly);a.setDepthMode(i),r.render(a.gl,t.transform.customLayerMatrix()),a.setDirty(),t.setBaseState(),a.bindFramebuffer.set(null);}}};class Ui{constructor(t,i){this.context=new e.Context(t),this.transform=i,this._tileTextures={},this.frameCopies=[],this.loadTimeStamps=[],this.setup(),this.numSublayers=e.SourceCache.maxUnderzooming+e.SourceCache.maxOverzooming+1,this.depthEpsilon=1/Math.pow(2,16),this.crossTileSymbolIndex=new ke,this.gpuTimers={},this.frameCounter=0;}updateTerrain(e,t){const i=!!e&&!!e.terrain;if(!(i||this._terrain&&this._terrain.enabled))return;this._terrain||(this._terrain=new Ot(this,e));const o=this._terrain;this.transform.elevation=i?o:null,o.update(e,this.transform,t);}get terrain(){return this._terrain&&this._terrain.enabled?this._terrain:null}resize(t,i){if(this.width=t*e.browser.devicePixelRatio,this.height=i*e.browser.devicePixelRatio,this.context.viewport.set([0,0,this.width,this.height]),this.style)for(const e of this.style.order)this.style._layers[e].resize();}setup(){const t=this.context,i=new e.StructArrayLayout2i4;i.emplaceBack(0,0),i.emplaceBack(e.EXTENT,0),i.emplaceBack(0,e.EXTENT),i.emplaceBack(e.EXTENT,e.EXTENT),this.tileExtentBuffer=t.createVertexBuffer(i,e.posAttributes.members),this.tileExtentSegments=e.SegmentVector.simpleSegment(0,0,4,2);const o=new e.StructArrayLayout2i4;o.emplaceBack(0,0),o.emplaceBack(e.EXTENT,0),o.emplaceBack(0,e.EXTENT),o.emplaceBack(e.EXTENT,e.EXTENT),this.debugBuffer=t.createVertexBuffer(o,e.posAttributes.members),this.debugSegments=e.SegmentVector.simpleSegment(0,0,4,5);const a=new e.StructArrayLayout4i8;a.emplaceBack(0,0,0,0),a.emplaceBack(e.EXTENT,0,e.EXTENT,0),a.emplaceBack(0,e.EXTENT,0,e.EXTENT),a.emplaceBack(e.EXTENT,e.EXTENT,e.EXTENT,e.EXTENT),this.rasterBoundsBuffer=t.createVertexBuffer(a,E.members),this.rasterBoundsSegments=e.SegmentVector.simpleSegment(0,0,4,2);const r=new e.StructArrayLayout2i4;r.emplaceBack(0,0),r.emplaceBack(1,0),r.emplaceBack(0,1),r.emplaceBack(1,1),this.viewportBuffer=t.createVertexBuffer(r,e.posAttributes.members),this.viewportSegments=e.SegmentVector.simpleSegment(0,0,4,2);const n=new e.StructArrayLayout1ui2;n.emplaceBack(0),n.emplaceBack(1),n.emplaceBack(3),n.emplaceBack(2),n.emplaceBack(0),this.tileBorderIndexBuffer=t.createIndexBuffer(n);const s=new e.StructArrayLayout3ui6;s.emplaceBack(0,1,2),s.emplaceBack(2,1,3),this.quadTriangleIndexBuffer=t.createIndexBuffer(s),this.emptyTexture=new e.Texture(t,{width:1,height:1,data:new Uint8Array([0,0,0,0])},t.gl.RGBA);const l=this.context.gl;this.stencilClearMode=new e.StencilMode({func:l.ALWAYS,mask:0},0,255,l.ZERO,l.ZERO,l.ZERO),this.loadTimeStamps.push(e.window.performance.now());}clearStencil(){const t=this.context,i=t.gl;this.nextStencilID=1,this.currentStencilSource=void 0;const o=e.create();e.ortho(o,0,this.width,this.height,0,0,1),e.scale(o,o,[i.drawingBufferWidth,i.drawingBufferHeight,0]),this.useProgram("clippingMask").draw(t,i.TRIANGLES,e.DepthMode.disabled,this.stencilClearMode,e.ColorMode.disabled,e.CullFaceMode.disabled,Rt(o),"$clipping",this.viewportBuffer,this.quadTriangleIndexBuffer,this.viewportSegments);}_renderTileClippingMasks(t,i,o){if(!(i&&this.currentStencilSource!==i.id&&t.isTileClipped()&&o&&o.length))return;this.currentStencilSource=i.id;const a=this.context,r=a.gl;this.nextStencilID+o.length>256&&this.clearStencil(),a.setColorMode(e.ColorMode.disabled),a.setDepthMode(e.DepthMode.disabled);const n=this.useProgram("clippingMask");this._tileClippingMaskIDs={};for(const t of o){const i=this._tileClippingMaskIDs[t.key]=this.nextStencilID++;n.draw(a,r.TRIANGLES,e.DepthMode.disabled,new e.StencilMode({func:r.ALWAYS,mask:0},i,255,r.KEEP,r.KEEP,r.REPLACE),e.ColorMode.disabled,e.CullFaceMode.disabled,Rt(t.posMatrix),"$clipping",this.tileExtentBuffer,this.quadTriangleIndexBuffer,this.tileExtentSegments);}}stencilModeFor3D(){this.currentStencilSource=void 0,this.nextStencilID+1>256&&this.clearStencil();const t=this.nextStencilID++,i=this.context.gl;return new e.StencilMode({func:i.NOTEQUAL,mask:255},t,255,i.KEEP,i.KEEP,i.REPLACE)}stencilModeForClipping(t){if(this.terrain)return this.terrain.stencilModeForRTTOverlap(t);const i=this.context.gl;return new e.StencilMode({func:i.EQUAL,mask:255},this._tileClippingMaskIDs[t.key],0,i.KEEP,i.KEEP,i.REPLACE)}stencilConfigForOverlap(t){const i=this.context.gl,o=t.sort((e,t)=>t.overscaledZ-e.overscaledZ),a=o[o.length-1].overscaledZ,r=o[0].overscaledZ-a+1;if(r>1){this.currentStencilSource=void 0,this.nextStencilID+r>256&&this.clearStencil();const t={};for(let o=0;o<r;o++)t[o+a]=new e.StencilMode({func:i.GEQUAL,mask:255},o+this.nextStencilID,255,i.KEEP,i.KEEP,i.REPLACE);return this.nextStencilID+=r,[t,o]}return [{[a]:e.StencilMode.disabled},o]}colorModeForRenderPass(){const t=this.context.gl;if(this._showOverdrawInspector){const i=1/8;return new e.ColorMode([t.CONSTANT_COLOR,t.ONE],new e.Color(i,i,i,0),[!0,!0,!0,!0])}return "opaque"===this.renderPass?e.ColorMode.unblended:e.ColorMode.alphaBlended}depthModeForSublayer(t,i,o){if(!this.opaquePassEnabledForLayer())return e.DepthMode.disabled;const a=1-((1+this.currentLayer)*this.numSublayers+t)*this.depthEpsilon;return new e.DepthMode(o||this.context.gl.LEQUAL,i,[a,a])}opaquePassEnabledForLayer(){return this.currentLayer<this.opaquePassCutoff}render(t,i){this.style=t,this.options=i,this.lineAtlas=t.lineAtlas,this.imageManager=t.imageManager,this.glyphManager=t.glyphManager,this.symbolFadeChange=t.placement.symbolFadeChange(e.browser.now()),this.imageManager.beginFrame();const o=this.style.order,a=this.style._sourceCaches;for(const e in a){const t=a[e];t.used&&t.prepare(this.context);}const r={},n={},s={};for(const e in a){const t=a[e];r[e]=t.getVisibleCoordinates(),n[e]=r[e].slice().reverse(),s[e]=t.getVisibleCoordinates(!0).reverse();}this.opaquePassCutoff=1/0;for(let e=0;e<o.length;e++)if(this.style._layers[o[e]].is3D()){this.opaquePassCutoff=e;break}this.terrain&&(this.terrain.updateTileBinding(s),this.opaquePassCutoff=0),this.renderPass="offscreen";for(const e of o){const i=this.style._layers[e],o=t._getLayerSourceCache(i);if(!i.hasOffscreenPass()||i.isHidden(this.transform.zoom))continue;const a=o?n[o.id]:void 0;("custom"===i.type||i.isSky()||a&&a.length)&&this.renderLayer(this,o,i,a);}if(this.depthRangeFor3D=[0,1-(t.order.length+2)*this.numSublayers*this.depthEpsilon],this.terrain&&(this.style.hasSymbolLayers()||this.style.hasCircleLayers())&&this.terrain.drawDepth(),this.context.bindFramebuffer.set(null),this.context.viewport.set([0,0,this.width,this.height]),this.context.clear({color:i.showOverdrawInspector?e.Color.black:e.Color.transparent,depth:1}),this.clearStencil(),this._showOverdrawInspector=i.showOverdrawInspector,this.renderPass="opaque",!this.terrain)for(this.currentLayer=o.length-1;this.currentLayer>=0;this.currentLayer--){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky())continue;const a=i?n[i.id]:void 0;this._renderTileClippingMasks(e,i,a),this.renderLayer(this,i,e,a);}if(this.renderPass="sky",this.transform.isHorizonVisible())for(this.currentLayer=0;this.currentLayer<o.length;this.currentLayer++){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);e.isSky()&&this.renderLayer(this,i,e,i?n[i.id]:void 0);}for(this.renderPass="translucent",this.currentLayer=0;this.currentLayer<o.length;){const e=this.style._layers[o[this.currentLayer]],i=t._getLayerSourceCache(e);if(e.isSky()){++this.currentLayer;continue}if(this.terrain&&this.style.isLayerDraped(e)){if(e.isHidden(this.transform.zoom)){++this.currentLayer;continue}this.currentLayer=this.terrain.renderBatch(this.currentLayer);continue}const a=i?("symbol"===e.type?s:n)[i.id]:void 0;this._renderTileClippingMasks(e,i,i?r[i.id]:void 0),this.renderLayer(this,i,e,a),++this.currentLayer;}if(this.terrain&&this.terrain.postRender(),this.options.showTileBoundaries||this.options.showQueryGeometry){let i=null;e.values(this.style._layers).forEach(e=>{const o=t._getLayerSourceCache(e);o&&!e.isHidden(this.transform.zoom)&&(!i||i.getSource().maxzoom<o.getSource().maxzoom)&&(i=o);}),i&&this.options.showTileBoundaries&&Oi.debug(this,i,i.getVisibleCoordinates());}this.options.showPadding&&function(e){const t=e.transform.padding;Mi(e,e.transform.height-(t.top||0),3,Ei),Mi(e,t.bottom||0,3,Ci),zi(e,t.left||0,3,Si),zi(e,e.transform.width-(t.right||0),3,Ii);const i=e.transform.centerPoint;!function(e,t,i,o){Ai(e,t-1,i-10,2,20,o),Ai(e,t-10,i-1,20,2,o);}(e,i.x,e.transform.height-i.y,Pi);}(this),this.context.setDefault(),this.frameCounter=(this.frameCounter+1)%e.MAX_SAFE_INTEGER,this.tileLoaded&&this.options.speedIndexTiming&&(this.loadTimeStamps.push(e.window.performance.now()),this.saveCanvasCopy());}renderLayer(e,t,i,o){i.isHidden(this.transform.zoom)||("background"===i.type||"sky"===i.type||"custom"===i.type||o&&o.length)&&(this.id=i.id,this.gpuTimingStart(i),Oi[i.type](e,t,i,o,this.style.placement.variableOffsets,this.options.isInitialLoad),this.gpuTimingEnd());}gpuTimingStart(e){if(!this.options.gpuTiming)return;const t=this.context.extTimerQuery;let i=this.gpuTimers[e.id];i||(i=this.gpuTimers[e.id]={calls:0,cpuTime:0,query:t.createQueryEXT()}),i.calls++,t.beginQueryEXT(t.TIME_ELAPSED_EXT,i.query);}gpuTimingEnd(){if(!this.options.gpuTiming)return;const e=this.context.extTimerQuery;e.endQueryEXT(e.TIME_ELAPSED_EXT);}collectGpuTimers(){const e=this.gpuTimers;return this.gpuTimers={},e}queryGpuTimers(e){const t={};for(const i in e){const o=e[i],a=this.context.extTimerQuery,r=a.getQueryObjectEXT(o.query,a.QUERY_RESULT_EXT)/1e6;a.deleteQueryEXT(o.query),t[i]=r;}return t}translatePosMatrix(t,i,o,a,r){if(!o[0]&&!o[1])return t;const n=r?"map"===a?this.transform.angle:0:"viewport"===a?-this.transform.angle:0;if(n){const e=Math.sin(n),t=Math.cos(n);o=[o[0]*t-o[1]*e,o[0]*e+o[1]*t];}const s=[r?o[0]:v(i,o[0],this.transform.zoom),r?o[1]:v(i,o[1],this.transform.zoom),0],l=new Float32Array(16);return e.translate(l,t,s),l}saveTileTexture(e){const t=this._tileTextures[e.size[0]];t?t.push(e):this._tileTextures[e.size[0]]=[e];}getTileTexture(e){const t=this._tileTextures[e];return t&&t.length>0?t.pop():null}isPatternMissing(e){if(!e)return !1;if(!e.from||!e.to)return !0;const t=this.imageManager.getPattern(e.from.toString()),i=this.imageManager.getPattern(e.to.toString());return !t||!i}currentGlobalDefines(){const e=this.terrain&&this.terrain.renderingToTexture,t=[];return this.terrain&&!this.terrain.renderingToTexture&&t.push("TERRAIN"),e&&t.push("RENDER_TO_TEXTURE"),this._showOverdrawInspector&&t.push("OVERDRAW_INSPECTOR"),t}useProgram(e,t,i){this.cache=this.cache||{};const o=i||[],a=this.currentGlobalDefines().concat(o),r=Nt.cacheKey(e,a,t);return this.cache[r]||(this.cache[r]=new Nt(this.context,e,wt[e],t,di[e],a)),this.cache[r]}setCustomLayerDefaults(){this.context.unbindVAO(),this.context.cullFace.setDefault(),this.context.activeTexture.setDefault(),this.context.pixelStoreUnpack.setDefault(),this.context.pixelStoreUnpackPremultiplyAlpha.setDefault(),this.context.pixelStoreUnpackFlipY.setDefault();}setBaseState(){const e=this.context.gl;this.context.cullFace.set(!1),this.context.viewport.set([0,0,this.width,this.height]),this.context.blendEquation.set(e.FUNC_ADD);}initDebugOverlayCanvas(){null==this.debugOverlayCanvas&&(this.debugOverlayCanvas=e.window.document.createElement("canvas"),this.debugOverlayCanvas.width=512,this.debugOverlayCanvas.height=512,this.debugOverlayTexture=new e.Texture(this.context,this.debugOverlayCanvas,this.context.gl.RGBA));}destroy(){this._terrain&&this._terrain.destroy(),this.emptyTexture.destroy(),this.debugOverlayTexture&&this.debugOverlayTexture.destroy();}prepareDrawTile(e){this.terrain&&this.terrain.prepareDrawTile(e);}setTileLoadedFlag(e){this.tileLoaded=e;}saveCanvasCopy(){this.frameCopies.push(this.canvasCopy()),this.tileLoaded=!1;}canvasCopy(){const e=this.context.gl,t=e.createTexture();return e.bindTexture(e.TEXTURE_2D,t),e.copyTexImage2D(e.TEXTURE_2D,0,e.RGBA,0,0,e.drawingBufferWidth,e.drawingBufferHeight,0),t}getCanvasCopiesAndTimestamps(){return {canvasCopies:this.frameCopies,timeStamps:this.loadTimeStamps}}}class Ni{constructor(e=0,t=0,i=0,o=0){if(isNaN(e)||e<0||isNaN(t)||t<0||isNaN(i)||i<0||isNaN(o)||o<0)throw new Error("Invalid value for edge-insets, top, bottom, left and right must all be numbers");this.top=e,this.bottom=t,this.left=i,this.right=o;}interpolate(t,i,o){return null!=i.top&&null!=t.top&&(this.top=e.number(t.top,i.top,o)),null!=i.bottom&&null!=t.bottom&&(this.bottom=e.number(t.bottom,i.bottom,o)),null!=i.left&&null!=t.left&&(this.left=e.number(t.left,i.left,o)),null!=i.right&&null!=t.right&&(this.right=e.number(t.right,i.right,o)),this}getCenter(t,i){const o=e.clamp((this.left+t-this.right)/2,0,t),a=e.clamp((this.top+i-this.bottom)/2,0,i);return new e.Point(o,a)}equals(e){return this.top===e.top&&this.bottom===e.bottom&&this.left===e.left&&this.right===e.right}clone(){return new Ni(this.top,this.bottom,this.left,this.right)}toJSON(){return {top:this.top,bottom:this.bottom,left:this.left,right:this.right}}}function Zi(e,t){return [e[4*t],e[4*t+1],e[4*t+2],e[4*t+3]]}function Gi(e,t,i){e[4*t+0]=i[0],e[4*t+1]=i[1],e[4*t+2]=i[2],e[4*t+3]=i[3];}function Vi(t,i){const o=Zi(t,3);e.fromQuat(t,i),Gi(t,3,o);}function qi(e,t){Gi(e,3,[t[0],t[1],t[2],1]);}function ji(t,i){const o=e.identity$1([]);return e.rotateZ$1(o,o,-i),e.rotateX$1(o,o,-t),o}function $i(t,i){const o=[t[0],t[1],0],a=[i[0],i[1],0];if(e.length(o)>=1e-15){const t=e.normalize([],o);e.scale$2(a,t,e.dot(a,t)),i[0]=a[0],i[1]=a[1];}const r=e.cross([],i,t);if(e.len(r)<1e-15)return null;const n=Math.atan2(-r[1],r[0]);return ji(Math.atan2(Math.sqrt(t[0]*t[0]+t[1]*t[1]),-t[2]),n)}class Xi{constructor(e,t){this.position=e,this.orientation=t;}get position(){return this._position}set position(t){this._position=this._renderWorldCopies?function(t){if(!t)return;const i=Array.isArray(t)?new e.MercatorCoordinate(t[0],t[1],t[2]):t;return i.x=e.wrap(i.x,0,1),i}(t):t;}lookAtPoint(t,i){if(this.orientation=null,!this.position)return;const o=this._elevation?this._elevation.getAtPoint(e.MercatorCoordinate.fromLngLat(t)):0,a=this.position,r=e.MercatorCoordinate.fromLngLat(t,o),n=[r.x-a.x,r.y-a.y,r.z-a.z];i||(i=[0,0,1]),i[2]=Math.abs(i[2]),this.orientation=$i(n,i);}setPitchBearing(t,i){this.orientation=ji(e.degToRad(t),e.degToRad(-i));}}class Wi{constructor(t,i){this._transform=e.identity([]),this._orientation=e.identity$1([]),i&&(this._orientation=i,Vi(this._transform,this._orientation)),t&&qi(this._transform,t);}get mercatorPosition(){const t=this.position;return new e.MercatorCoordinate(t[0],t[1],t[2])}get position(){const e=Zi(this._transform,3);return [e[0],e[1],e[2]]}set position(e){qi(this._transform,e);}get orientation(){return this._orientation}set orientation(e){this._orientation=e,Vi(this._transform,this._orientation);}getPitchBearing(){const e=this.forward(),t=this.right();return {bearing:Math.atan2(-t[1],t[0]),pitch:Math.atan2(Math.sqrt(e[0]*e[0]+e[1]*e[1]),-e[2])}}setPitchBearing(e,t){this._orientation=ji(e,t),Vi(this._transform,this._orientation);}forward(){const e=Zi(this._transform,2);return [-e[0],-e[1],-e[2]]}up(){const e=Zi(this._transform,1);return [-e[0],-e[1],-e[2]]}right(){const e=Zi(this._transform,0);return [e[0],e[1],e[2]]}getCameraToWorld(t,i){const o=new Float64Array(16);return e.invert(o,this.getWorldToCamera(t,i)),o}getWorldToCamera(t,i){const o=new Float64Array(16),a=new Float64Array(4),r=this.position;return e.conjugate(a,this._orientation),e.scale$2(r,r,-t),e.fromQuat(o,a),e.translate(o,o,r),o[1]*=-1,o[5]*=-1,o[9]*=-1,o[13]*=-1,o[8]*=i,o[9]*=i,o[10]*=i,o[11]*=i,o}getCameraToClipPerspective(t,i,o,a){const r=new Float64Array(16);return e.perspective(r,t,i,o,a),r}clone(){return new Wi([...this.position],[...this.orientation])}}class Hi{constructor(t,i,o,a,r){this.tileSize=512,this.maxValidLatitude=85.051129,this._renderWorldCopies=void 0===r||r,this._minZoom=t||0,this._maxZoom=i||22,this._minPitch=null==o?0:o,this._maxPitch=null==a?60:a,this.setMaxBounds(),this.width=0,this.height=0,this._center=new e.LngLat(0,0),this.zoom=0,this.angle=0,this._fov=.6435011087932844,this._pitch=0,this._unmodified=!0,this._edgeInsets=new Ni,this._posMatrixCache={},this._alignedPosMatrixCache={},this._camera=new Wi,this._centerAltitude=0,this.cameraElevationReference="ground",this._horizonShift=.1;}clone(){const e=new Hi(this._minZoom,this._maxZoom,this._minPitch,this.maxPitch,this._renderWorldCopies);return e._elevation=this._elevation,e._centerAltitude=this._centerAltitude,e.tileSize=this.tileSize,e.latRange=this.latRange,e.width=this.width,e.height=this.height,e.cameraElevationReference=this.cameraElevationReference,e._center=this._center,e._setZoom(this.zoom),e._cameraZoom=this._cameraZoom,e.angle=this.angle,e._fov=this._fov,e._pitch=this._pitch,e._unmodified=this._unmodified,e._edgeInsets=this._edgeInsets.clone(),e._camera=this._camera.clone(),e._calcMatrices(),e.freezeTileCoverage=this.freezeTileCoverage,e}get elevation(){return this._elevation}set elevation(e){this._elevation!==e&&(this._elevation=e,e?this._updateCenterElevation()&&this._updateCameraOnTerrain():(this._cameraZoom=null,this._centerAltitude=0),this._calcMatrices());}updateElevation(e){this._terrainEnabled()&&null==this._cameraZoom&&this._updateCenterElevation()&&this._updateCameraOnTerrain(),e&&this._constrainCameraAltitude(),this._calcMatrices();}get minZoom(){return this._minZoom}set minZoom(e){this._minZoom!==e&&(this._minZoom=e,this.zoom=Math.max(this.zoom,e));}get maxZoom(){return this._maxZoom}set maxZoom(e){this._maxZoom!==e&&(this._maxZoom=e,this.zoom=Math.min(this.zoom,e));}get minPitch(){return this._minPitch}set minPitch(e){this._minPitch!==e&&(this._minPitch=e,this.pitch=Math.max(this.pitch,e));}get maxPitch(){return this._maxPitch}set maxPitch(e){this._maxPitch!==e&&(this._maxPitch=e,this.pitch=Math.min(this.pitch,e));}get renderWorldCopies(){return this._renderWorldCopies}set renderWorldCopies(e){void 0===e?e=!0:null===e&&(e=!1),this._renderWorldCopies=e;}get worldSize(){return this.tileSize*this.scale}get centerOffset(){return this.centerPoint._sub(this.size._div(2))}get size(){return new e.Point(this.width,this.height)}get bearing(){return -this.angle/Math.PI*180}set bearing(t){const i=-e.wrap(t,-180,180)*Math.PI/180;this.angle!==i&&(this._unmodified=!1,this.angle=i,this._calcMatrices(),this.rotationMatrix=e.create$2(),e.rotate(this.rotationMatrix,this.rotationMatrix,this.angle));}get pitch(){return this._pitch/Math.PI*180}set pitch(t){const i=e.clamp(t,this.minPitch,this.maxPitch)/180*Math.PI;this._pitch!==i&&(this._unmodified=!1,this._pitch=i,this._calcMatrices());}get fov(){return this._fov/Math.PI*180}set fov(e){e=Math.max(.01,Math.min(60,e)),this._fov!==e&&(this._unmodified=!1,this._fov=e/180*Math.PI,this._calcMatrices());}get zoom(){return this._zoom}set zoom(e){const t=Math.min(Math.max(e,this.minZoom),this.maxZoom);this._zoom!==t&&(this._unmodified=!1,this._setZoom(t),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._constrain(),this._calcMatrices());}_setZoom(e){this._zoom=e,this.scale=this.zoomScale(e),this.tileZoom=Math.floor(e),this.zoomFraction=e-this.tileZoom;}_updateCenterElevation(){if(!this._elevation)return !1;const t=this._elevation.getAtPoint(e.MercatorCoordinate.fromLngLat(this.center),-1);return -1===t?(this._cameraZoom=null,!1):(this._centerAltitude=t,!0)}_updateCameraOnTerrain(){const t=this.cameraToCenterDistance/this.worldSize,i=e.mercatorZfromAltitude(this._centerAltitude,this.center.lat);this._cameraZoom=this._zoomFromMercatorZ(i+t);}get center(){return this._center}set center(e){e.lat===this._center.lat&&e.lng===this._center.lng||(this._unmodified=!1,this._center=e,this._terrainEnabled()&&("ground"===this.cameraElevationReference?this._updateCenterElevation()?this._updateCameraOnTerrain():this._cameraZoom=null:this._updateZoomFromElevation()),this._constrain(),this._calcMatrices());}_updateZoomFromElevation(){if(null==this._cameraZoom||!this._elevation)return;const t=this._cameraZoom,i=this._elevation.getAtPoint(e.MercatorCoordinate.fromLngLat(this.center)),o=e.mercatorZfromAltitude(i,this.center.lat),a=this._mercatorZfromZoom(t),r=this._mercatorZfromZoom(this._maxZoom),n=Math.max(a-o,r);this._setZoom(this._zoomFromMercatorZ(n));}get padding(){return this._edgeInsets.toJSON()}set padding(e){this._edgeInsets.equals(e)||(this._unmodified=!1,this._edgeInsets.interpolate(this._edgeInsets,e,1),this._calcMatrices());}computeZoomRelativeTo(t){const i=this.rayIntersectionCoordinate(this.pointRayIntersection(this.centerPoint,t.toAltitude()));let o;o=t.z<this._camera.position[2]?[i.x,i.y,i.z]:[t.x,t.y,t.z];const a=e.length(e.sub([],this._camera.position,o));return e.clamp(this._zoomFromMercatorZ(a),this._minZoom,this._maxZoom)}setFreeCameraOptions(t){if(!this.height)return;if(!t.position&&!t.orientation)return;this._updateCameraState();let i=!1;if(t.orientation&&!e.exactEquals(t.orientation,this._camera.orientation)&&(i=this._setCameraOrientation(t.orientation)),t.position){const o=[t.position.x,t.position.y,t.position.z];e.exactEquals$1(o,this._camera.position)||(this._setCameraPosition(o),i=!0);}i&&(this._updateStateFromCamera(),this.recenterOnTerrain());}getFreeCameraOptions(){this._updateCameraState();const t=this._camera.position,i=new Xi;return i.position=new e.MercatorCoordinate(t[0],t[1],t[2]),i.orientation=this._camera.orientation,i._elevation=this.elevation,i._renderWorldCopies=this._renderWorldCopies,i}_setCameraOrientation(t){if(!e.length$1(t))return !1;e.normalize$1(t,t);const i=e.transformQuat([],[0,0,-1],t),o=e.transformQuat([],[0,-1,0],t);if(o[2]<0)return !1;const a=$i(i,o);return !!a&&(this._camera.orientation=a,!0)}_setCameraPosition(t){const i=this.zoomScale(this.minZoom)*this.tileSize,o=this.zoomScale(this.maxZoom)*this.tileSize,a=this.cameraToCenterDistance;t[2]=e.clamp(t[2],a/o,a/i),this._camera.position=t;}get centerPoint(){return this._edgeInsets.getCenter(this.width,this.height)}get fovAboveCenter(){return this._fov*(.5+this.centerOffset.y/this.height)}isPaddingEqual(e){return this._edgeInsets.equals(e)}interpolatePadding(e,t,i){this._unmodified=!1,this._edgeInsets.interpolate(e,t,i),this._constrain(),this._calcMatrices();}coveringZoomLevel(e){const t=(e.roundZoom?Math.round:Math.floor)(this.zoom+this.scaleZoom(this.tileSize/e.tileSize));return Math.max(0,t)}getVisibleUnwrappedCoordinates(t){const i=[new e.UnwrappedTileID(0,t)];if(this._renderWorldCopies){const o=this.pointCoordinate(new e.Point(0,0)),a=this.pointCoordinate(new e.Point(this.width,0)),r=this.pointCoordinate(new e.Point(this.width,this.height)),n=this.pointCoordinate(new e.Point(0,this.height)),s=Math.floor(Math.min(o.x,a.x,r.x,n.x)),l=Math.floor(Math.max(o.x,a.x,r.x,n.x)),c=1;for(let o=s-c;o<=l+c;o++)0!==o&&i.push(new e.UnwrappedTileID(o,t));}return i}coveringTiles(t){let i=this.coveringZoomLevel(t);const o=i,a=!!t.useElevationData;if(void 0!==t.minzoom&&i<t.minzoom)return [];void 0!==t.maxzoom&&i>t.maxzoom&&(i=t.maxzoom);const r=e.MercatorCoordinate.fromLngLat(this.center),n=1<<i,s=[n*r.x,n*r.y,0],l=e.Frustum.fromInvProjectionMatrix(this.invProjMatrix,this.worldSize,i),c=this.pointCoordinate(this.getCameraPoint()),h=n*e.mercatorZfromAltitude(1,this.center.lat),u=this._camera.position[2]/e.mercatorZfromAltitude(1,this.center.lat),d=[n*c.x,n*c.y,u],_=this.cameraToCenterDistance/t.tileSize*(t.roundZoom?1:.502),m=this.pitch<=60&&this._edgeInsets.top<=this._edgeInsets.bottom&&!this._elevation?i:0,p=this.elevation?1e4*this.elevation.exaggeration():0,f=t=>({aabb:new e.Aabb([t*n,0,-p],[(t+1)*n,n,p]),zoom:0,x:0,y:0,wrap:t,fullyVisible:!1}),g=[],v=[],x=i,y=t.reparseOverscaled?o:i,b=(e,t)=>{if(!this._elevation)return;const i=this._elevation.getMinMaxForTile(t);i&&(e.min[2]=i.min,e.max[2]=i.max,e.center[2]=(e.min[2]+e.max[2])/2);},w=e=>e*e,T=w((u-this._centerAltitude)*h),E=(e,t)=>{if(t*w(.707)<e)return 1;const i=Math.sqrt(t/e);return i/(1/.707+(Math.pow(1.1,i-1/.707+1)-1)/(1.1-1)-1)};if(this._renderWorldCopies)for(let e=1;e<=3;e++)g.push(f(-e)),g.push(f(e));for(g.push(f(0));g.length>0;){const o=g.pop(),r=o.x,n=o.y;let c=o.fullyVisible;if(!c){const e=o.aabb.intersects(l);if(0===e)continue;c=2===e;}let u=!0;if(m<=o.zoom&&o.zoom<x){const e=o.aabb.distanceX(d),t=o.aabb.distanceY(d);let i=T;a&&(i=w(o.aabb.distanceZ(d)*h));const r=e*e+t*t+i;u=r<w((1<<x-o.zoom)*_*E(Math.max(i,T),r));}if(o.zoom!==x&&u)for(let t=0;t<4;t++){const i=(r<<1)+t%2,s=(n<<1)+(t>>1),l=o.aabb.quadrant(t);let h=null;a&&o.zoom>x-6&&(h=new e.OverscaledTileID(o.zoom+1===x?y:o.zoom+1,o.wrap,o.zoom+1,i,s),b(l,h)),g.push({aabb:l,zoom:o.zoom+1,x:i,y:s,wrap:o.wrap,fullyVisible:c,tileID:h});}else {const a=o.zoom===x?y:o.zoom;if(t.minzoom&&t.minzoom>a)continue;const l=s[0]-(.5+r+(o.wrap<<o.zoom))*(1<<i-o.zoom),c=s[1]-.5-n,h=o.tileID?o.tileID:new e.OverscaledTileID(a,o.wrap,o.zoom,r,n);v.push({tileID:h,distanceSq:l*l+c*c});}}return v.sort((e,t)=>e.distanceSq-t.distanceSq).map(e=>e.tileID)}resize(e,t){this.width=e,this.height=t,this.pixelsToGLUnits=[2/e,-2/t],this._constrain(),this._calcMatrices();}get unmodified(){return this._unmodified}zoomScale(e){return Math.pow(2,e)}scaleZoom(e){return Math.log(e)/Math.LN2}project(t){const i=e.clamp(t.lat,-this.maxValidLatitude,this.maxValidLatitude);return new e.Point(e.mercatorXfromLng(t.lng)*this.worldSize,e.mercatorYfromLat(i)*this.worldSize)}unproject(t){return new e.MercatorCoordinate(t.x/this.worldSize,t.y/this.worldSize).toLngLat()}get point(){return this.project(this.center)}setLocationAtPoint(t,i){const o=this.pointCoordinate(i),a=this.pointCoordinate(this.centerPoint),r=this.locationCoordinate(t),n=new e.MercatorCoordinate(r.x-(o.x-a.x),r.y-(o.y-a.y));this.center=this.coordinateLocation(n),this._renderWorldCopies&&(this.center=this.center.wrap());}setLocation(e){this.center=this.coordinateLocation(e),this._renderWorldCopies&&(this.center=this.center.wrap());}locationPoint(e){return this._coordinatePoint(this.locationCoordinate(e),!1)}locationPoint3D(e){return this._coordinatePoint(this.locationCoordinate(e),!0)}pointLocation(e){return this.coordinateLocation(this.pointCoordinate(e))}pointLocation3D(e){return this.coordinateLocation(this.pointCoordinate3D(e))}locationCoordinate(t){return e.MercatorCoordinate.fromLngLat(t)}coordinateLocation(e){return e.toLngLat()}pointRayIntersection(t,i){const o=null!=i?i:this._centerAltitude,a=[t.x,t.y,0,1],r=[t.x,t.y,1,1];e.transformMat4(a,a,this.pixelMatrixInverse),e.transformMat4(r,r,this.pixelMatrixInverse);const n=r[3];e.scale$1(a,a,1/a[3]),e.scale$1(r,r,1/n);const s=a[2],l=r[2];return {p0:a,p1:r,t:s===l?0:(o-s)/(l-s)}}screenPointToMercatorRay(t){const i=[t.x,t.y,0,1],o=[t.x,t.y,1,1];return e.transformMat4(i,i,this.pixelMatrixInverse),e.transformMat4(o,o,this.pixelMatrixInverse),e.scale$1(i,i,1/i[3]),e.scale$1(o,o,1/o[3]),i[2]=e.mercatorZfromAltitude(i[2],this._center.lat)*this.worldSize,o[2]=e.mercatorZfromAltitude(o[2],this._center.lat)*this.worldSize,e.scale$1(i,i,1/this.worldSize),e.scale$1(o,o,1/this.worldSize),new e.Ray([i[0],i[1],i[2]],e.normalize([],e.sub([],o,i)))}rayIntersectionCoordinate(t){const{p0:i,p1:o,t:a}=t,r=e.mercatorZfromAltitude(i[2],this._center.lat),n=e.mercatorZfromAltitude(o[2],this._center.lat);return new e.MercatorCoordinate(e.number(i[0],o[0],a)/this.worldSize,e.number(i[1],o[1],a)/this.worldSize,e.number(r,n,a))}pointCoordinate(t){const i=this.horizonLineFromTop(!1),o=new e.Point(t.x,Math.max(i,t.y));return this.rayIntersectionCoordinate(this.pointRayIntersection(o))}pointCoordinate3D(t){if(!this.elevation)return this.pointCoordinate(t);const i=this.elevation;let o=this.elevation.pointCoordinate(t);if(o)return new e.MercatorCoordinate(o[0],o[1],o[2]);let a=0,r=this.horizonLineFromTop();if(t.y>r)return this.pointCoordinate(t);const n=.02*r,s=t.clone();for(let t=0;t<10&&r-a>n;t++){s.y=e.number(a,r,.66);const t=i.pointCoordinate(s);t?(r=s.y,o=t):a=s.y;}return o?new e.MercatorCoordinate(o[0],o[1],o[2]):this.pointCoordinate(t)}isPointAboveHorizon(e){if(this.elevation)return !this.elevation.pointCoordinate(e);{const t=this.horizonLineFromTop();return e.y<t}}_coordinatePoint(t,i){const o=i&&this.elevation?this.elevation.getAtPoint(t,this._centerAltitude):this._centerAltitude,a=[t.x*this.worldSize,t.y*this.worldSize,o+t.toAltitude(),1];return e.transformMat4(a,a,this.pixelMatrix),a[3]>0?new e.Point(a[0]/a[3],a[1]/a[3]):new e.Point(Number.MAX_VALUE,Number.MAX_VALUE)}getBounds(){return this._terrainEnabled()?this._getBounds3D():(new e.LngLatBounds).extend(this.pointLocation(new e.Point(0,0))).extend(this.pointLocation(new e.Point(this.width,0))).extend(this.pointLocation(new e.Point(this.width,this.height))).extend(this.pointLocation(new e.Point(0,this.height)))}_getBounds3D(){const t=this.elevation,i=t.visibleDemTiles.reduce((e,t)=>{if(t.dem){const i=t.dem.tree;e.min=Math.min(e.min,i.minimums[0]),e.max=Math.max(e.max,i.maximums[0]);}return e},{min:Number.MAX_VALUE,max:0});i.min*=t.exaggeration(),i.max*=t.exaggeration();const o=this.horizonLineFromTop();return [new e.Point(0,o),new e.Point(this.width,o),new e.Point(this.width,this.height),new e.Point(0,this.height)].reduce((e,t)=>e.extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(t,i.min)))).extend(this.coordinateLocation(this.rayIntersectionCoordinate(this.pointRayIntersection(t,i.max)))),new e.LngLatBounds)}horizonLineFromTop(e=!0){const t=this.height/2/Math.tan(this._fov/2)/Math.tan(Math.max(this._pitch,.1))+this.centerOffset.y,i=this.height/2-.97*t;return e?Math.max(0,i):i}getMaxBounds(){return this.latRange&&2===this.latRange.length&&this.lngRange&&2===this.lngRange.length?new e.LngLatBounds([this.lngRange[0],this.latRange[0]],[this.lngRange[1],this.latRange[1]]):null}setMaxBounds(e){e?(this.lngRange=[e.getWest(),e.getEast()],this.latRange=[e.getSouth(),e.getNorth()],this._constrain()):(this.lngRange=null,this.latRange=[-this.maxValidLatitude,this.maxValidLatitude]);}calculatePosMatrix(t,i=!1){const o=t.key,a=i?this._alignedPosMatrixCache:this._posMatrixCache;if(a[o])return a[o];const r=t.canonical,n=this.worldSize/this.zoomScale(r.z),s=r.x+Math.pow(2,r.z)*t.wrap,l=e.identity(new Float64Array(16));return e.translate(l,l,[s*n,r.y*n,0]),e.scale(l,l,[n/e.EXTENT,n/e.EXTENT,1]),e.multiply(l,i?this.alignedProjMatrix:this.projMatrix,l),a[o]=new Float32Array(l),a[o]}customLayerMatrix(){return this.mercatorMatrix.slice()}recenterOnTerrain(){if(!this._elevation)return;const t=this._elevation;this._updateCameraState();const i=this._camera.position,o=this._camera.forward();if(i.z<=0||o[2]>=0)return;const a=e.mercatorZfromAltitude(1,this._center.lat);i[2]/=a,o[2]/=a,e.normalize(o,o);const r=t.raycast(i,o,t.exaggeration());if(r){const t=e.scaleAndAdd([],i,o,r),a=new e.MercatorCoordinate(t[0],t[1],e.mercatorZfromAltitude(t[2],e.latFromMercatorY(t[1]))),n=this._camera.position,s=a.z+e.length([a.x-n[0],a.y-n[1],a.z-n[2]]);this._cameraZoom=this._zoomFromMercatorZ(s),this._centerAltitude=a.toAltitude(),this._center=a.toLngLat(),this._updateZoomFromElevation(),this._constrain(),this._calcMatrices();}}_constrainCameraAltitude(){if(!this._elevation)return;const t=this._elevation;this._updateCameraState();const i=t.getAtPoint(this._camera.mercatorPosition),o=this._minimumHeightOverTerrain()*Math.cos(e.degToRad(this._maxPitch)),a=e.mercatorZfromAltitude(i,this._center.lat),r=this._camera.position[2]-a;if(r<o){const t=e.MercatorCoordinate.fromLngLat(this._center,this._centerAltitude),i=this._camera.mercatorPosition,a=[t.x-i.x,t.y-i.y,t.z-i.z],n=e.length(a);a[2]-=o-r;const s=e.length(a);if(0===s)return;e.scale$2(a,a,n/s),this._camera.position=[t.x-a[0],t.y-a[1],t.z-a[2]],this._camera.orientation=$i(a,this._camera.up()),this._updateStateFromCamera();}}_constrain(){if(!this.center||!this.width||!this.height||this._constraining)return;this._constraining=!0;let t,i,o,a,r=-90,n=90,s=-180,l=180;const c=this.size,h=this._unmodified;if(this.latRange){const i=this.latRange;r=e.mercatorYfromLat(i[1])*this.worldSize,n=e.mercatorYfromLat(i[0])*this.worldSize,t=n-r<c.y?c.y/(n-r):0;}if(this.lngRange){const t=this.lngRange;s=e.mercatorXfromLng(t[0])*this.worldSize,l=e.mercatorXfromLng(t[1])*this.worldSize,i=l-s<c.x?c.x/(l-s):0;}const u=this.point,d=Math.max(i||0,t||0);if(d)return this.center=this.unproject(new e.Point(i?(l+s)/2:u.x,t?(n+r)/2:u.y)),this.zoom+=this.scaleZoom(d),this._unmodified=h,void(this._constraining=!1);if(this.latRange){const e=u.y,t=c.y/2;e-t<r&&(a=r+t),e+t>n&&(a=n-t);}if(this.lngRange){const e=u.x,t=c.x/2;e-t<s&&(o=s+t),e+t>l&&(o=l-t);}void 0===o&&void 0===a||(this.center=this.unproject(new e.Point(void 0!==o?o:u.x,void 0!==a?a:u.y))),this._constrainCameraAltitude(),this._unmodified=h,this._constraining=!1;}_minZoomForBounds(){const t=(e,t)=>Math.log2(e/(this.tileSize*Math.abs(t[1]-t[0])));let i=0;if(this.latRange){const o=this.latRange;i=t(this.height,[e.mercatorYfromLat(o[0]),e.mercatorYfromLat(o[1])]);}let o=0;if(this.lngRange){const i=this.lngRange;o=t(this.width,[e.mercatorXfromLng(i[0]),e.mercatorXfromLng(i[1])]);}return Math.max(i,o)}_maxCameraBoundsDistance(){return this._mercatorZfromZoom(this._minZoomForBounds())}_calcMatrices(){if(!this.height)return;const t=this.centerOffset;this.cameraToCenterDistance=.5/Math.tan(this._fov/2)*this.height;const i=e.mercatorZfromAltitude(1,this.center.lat)*this.worldSize;this._updateCameraState();const o=Math.PI/2+this._pitch,a=this.fovAboveCenter,r=this._camera.position[2]*this.worldSize/Math.cos(this._pitch),n=Math.sin(a)*r/Math.sin(e.clamp(Math.PI-o-a,.01,Math.PI-.01)),s=this.point,l=s.x,c=s.y,h=Math.cos(Math.PI/2-this._pitch)*n+r,u=Math.min(1.01*h,r*(1/this._horizonShift)),d=this.height/50,_=this._camera.getWorldToCamera(this.worldSize,i),m=this._camera.getCameraToClipPerspective(this._fov,this.width/this.height,d,u);m[8]=2*-t.x/this.width,m[9]=2*t.y/this.height;let p=e.mul([],m,_);this.mercatorMatrix=e.scale([],p,[this.worldSize,this.worldSize,this.worldSize/i]),this.projMatrix=p,this.invProjMatrix=e.invert(new Float64Array(16),this.projMatrix);const f=new Float32Array(16);e.identity(f),e.scale(f,f,[1,-1,1]),e.rotateX(f,f,this._pitch),e.rotateZ(f,f,this.angle);const g=e.perspective(new Float32Array(16),this._fov,this.width/this.height,d,u),v=(Math.PI/2-this._pitch)*(this.height/this._fov)*this._horizonShift;g[8]=2*-t.x/this.width,g[9]=2*(t.y+v)/this.height,this.skyboxMatrix=e.multiply(f,g,f);const x=this.width%2/2,y=this.height%2/2,b=Math.cos(this.angle),w=Math.sin(this.angle),T=l-Math.round(l)+b*x+w*y,E=c-Math.round(c)+b*y+w*x,C=new Float64Array(p);if(e.translate(C,C,[T>.5?T-1:T,E>.5?E-1:E,0]),this.alignedProjMatrix=C,p=e.create(),e.scale(p,p,[this.width/2,-this.height/2,1]),e.translate(p,p,[1,-1,0]),this.labelPlaneMatrix=p,p=e.create(),e.scale(p,p,[1,-1,1]),e.translate(p,p,[-1,-1,0]),e.scale(p,p,[2/this.width,2/this.height,1]),this.glCoordMatrix=p,this.pixelMatrix=e.multiply(new Float64Array(16),this.labelPlaneMatrix,this.projMatrix),p=e.invert(new Float64Array(16),this.pixelMatrix),!p)throw new Error("failed to invert matrix");this.pixelMatrixInverse=p,this._posMatrixCache={},this._alignedPosMatrixCache={};}_updateCameraState(){if(!this.height)return;this._camera.setPitchBearing(this._pitch,this.angle);const t=this._camera.forward(),i=this.cameraToCenterDistance,o=this.point,a=this._mercatorZfromZoom(this._cameraZoom?this._cameraZoom:this._zoom)-e.mercatorZfromAltitude(this._centerAltitude,this.center.lat),r=this.cameraToCenterDistance/a;this._camera.position=[o.x/this.worldSize-t[0]*i/r,o.y/this.worldSize-t[1]*i/r,e.mercatorZfromAltitude(this._centerAltitude,this._center.lat)+-t[2]*i/r];}_translateCameraConstrained(t){const i=this._maxCameraBoundsDistance()*Math.cos(this._pitch),o=t[2];let a=1;o>0&&(a=Math.min((i-this._camera.position[2])/o,1)),this._camera.position=e.scaleAndAdd([],this._camera.position,t,a),this._updateStateFromCamera();}_updateStateFromCamera(){const t=this._camera.position,i=this._camera.forward(),{pitch:o,bearing:a}=this._camera.getPitchBearing(),r=e.mercatorZfromAltitude(this._centerAltitude,this.center.lat),n=this._mercatorZfromZoom(this._maxZoom)*Math.cos(e.degToRad(this._maxPitch)),s=Math.max((t[2]-r)/Math.cos(o),n),l=this._zoomFromMercatorZ(s);e.scaleAndAdd(t,t,i,s),this._pitch=e.clamp(o,e.degToRad(this.minPitch),e.degToRad(this.maxPitch)),this.angle=e.wrap(a,-Math.PI,Math.PI),this._setZoom(e.clamp(l,this._minZoom,this._maxZoom)),this._terrainEnabled()&&this._updateCameraOnTerrain(),this._center=new e.MercatorCoordinate(t[0],t[1],t[2]).toLngLat(),this._unmodified=!1,this._constrain(),this._calcMatrices();}_worldSizeFromZoom(e){return Math.pow(2,e)*this.tileSize}_mercatorZfromZoom(e){return this.cameraToCenterDistance/this._worldSizeFromZoom(e)}_minimumHeightOverTerrain(){const e=Math.min((null!=this._cameraZoom?this._cameraZoom:this._zoom)+2,this._maxZoom);return this._mercatorZfromZoom(e)}_zoomFromMercatorZ(e){return this.scaleZoom(this.cameraToCenterDistance/(e*this.tileSize))}_terrainEnabled(){return !!this._elevation}isHorizonVisibleForPoints(t,i){const o=Math.min(t.x,i.x),a=Math.max(t.x,i.x),r=Math.min(t.y,i.y),n=Math.max(t.y,i.y),s=[new e.Point(o,r),new e.Point(a,n),new e.Point(o,n),new e.Point(a,r)],l=this._renderWorldCopies?-3:0,c=this._renderWorldCopies?4:1;for(const e of s){const t=this.pointRayIntersection(e);if(t.t<0)return !0;const i=this.rayIntersectionCoordinate(t);if(i.x<l||i.y<0||i.x>c||i.y>1)return !0}return !1}isHorizonVisible(){return this.pitch+e.radToDeg(this.fovAboveCenter)>88||this.isHorizonVisibleForPoints(new e.Point(0,0),new e.Point(this.width,this.height))}zoomDeltaToMovement(t,i){const o=e.length(e.sub([],this._camera.position,t)),a=this._zoomFromMercatorZ(o)+i;return o-this._mercatorZfromZoom(a)}getCameraPoint(){const t=Math.tan(this._pitch)*(this.cameraToCenterDistance||1);return this.centerPoint.add(new e.Point(0,t))}}class Ki{constructor(t){this._hashName=t&&encodeURIComponent(t),e.bindAll(["_getCurrentHash","_onHashChange","_updateHash"],this),this._updateHash=function(e,t){let i=!1,o=null;const a=()=>{o=null,i&&(e(),o=setTimeout(a,300),i=!1);};return ()=>(i=!0,o||a(),o)}(this._updateHashUnthrottled.bind(this));}addTo(t){return this._map=t,e.window.addEventListener("hashchange",this._onHashChange,!1),this._map.on("moveend",this._updateHash),this}remove(){return e.window.removeEventListener("hashchange",this._onHashChange,!1),this._map.off("moveend",this._updateHash),clearTimeout(this._updateHash()),delete this._map,this}getHashString(t){const i=this._map.getCenter(),o=Math.round(100*this._map.getZoom())/100,a=Math.ceil((o*Math.LN2+Math.log(512/360/.5))/Math.LN10),r=Math.pow(10,a),n=Math.round(i.lng*r)/r,s=Math.round(i.lat*r)/r,l=this._map.getBearing(),c=this._map.getPitch();let h="";if(h+=t?`/${n}/${s}/${o}`:`${o}/${s}/${n}`,(l||c)&&(h+=`/${Math.round(10*l)/10}`),c&&(h+=`/${Math.round(c)}`),this._hashName){const t=this._hashName;let i=!1;const o=e.window.location.hash.slice(1).split("&").map(e=>{const o=e.split("=")[0];return o===t?(i=!0,`${o}=${h}`):e}).filter(e=>e);return i||o.push(`${t}=${h}`),`#${o.join("&")}`}return `#${h}`}_getCurrentHash(){const t=e.window.location.hash.replace("#","");if(this._hashName){let e;return t.split("&").map(e=>e.split("=")).forEach(t=>{t[0]===this._hashName&&(e=t);}),(e&&e[1]||"").split("/")}return t.split("/")}_onHashChange(){const e=this._getCurrentHash();if(e.length>=3&&!e.some(e=>isNaN(e))){const t=this._map.dragRotate.isEnabled()&&this._map.touchZoomRotate.isEnabled()?+(e[3]||0):this._map.getBearing();return this._map.jumpTo({center:[+e[2],+e[1]],zoom:+e[0],bearing:t,pitch:+(e[4]||0)}),!0}return !1}_updateHashUnthrottled(){const t=e.window.location.href.replace(/(#.+)?$/,this.getHashString());e.window.history.replaceState(e.window.history.state,null,t);}}const Yi={linearity:.3,easing:e.bezier(0,0,.3,1)},Ji=e.extend({deceleration:2500,maxSpeed:1400},Yi),Qi=e.extend({deceleration:20,maxSpeed:1400},Yi),eo=e.extend({deceleration:1e3,maxSpeed:360},Yi),to=e.extend({deceleration:1e3,maxSpeed:90},Yi);class io{constructor(e){this._map=e,this.clear();}clear(){this._inertiaBuffer=[];}record(t){this._drainInertiaBuffer(),this._inertiaBuffer.push({time:e.browser.now(),settings:t});}_drainInertiaBuffer(){const t=this._inertiaBuffer,i=e.browser.now();for(;t.length>0&&i-t[0].time>160;)t.shift();}_onMoveEnd(t){if(this._drainInertiaBuffer(),this._inertiaBuffer.length<2)return;const i={zoom:0,bearing:0,pitch:0,pan:new e.Point(0,0),pinchAround:void 0,around:void 0};for(const{settings:e}of this._inertiaBuffer)i.zoom+=e.zoomDelta||0,i.bearing+=e.bearingDelta||0,i.pitch+=e.pitchDelta||0,e.panDelta&&i.pan._add(e.panDelta),e.around&&(i.around=e.around),e.pinchAround&&(i.pinchAround=e.pinchAround);const o=this._inertiaBuffer[this._inertiaBuffer.length-1].time-this._inertiaBuffer[0].time,a={};if(i.pan.mag()){const r=ao(i.pan.mag(),o,e.extend({},Ji,t||{}));a.offset=i.pan.mult(r.amount/i.pan.mag()),a.center=this._map.transform.center,oo(a,r);}if(i.zoom){const e=ao(i.zoom,o,Qi);a.zoom=this._map.transform.zoom+e.amount,oo(a,e);}if(i.bearing){const t=ao(i.bearing,o,eo);a.bearing=this._map.transform.bearing+e.clamp(t.amount,-179,179),oo(a,t);}if(i.pitch){const e=ao(i.pitch,o,to);a.pitch=this._map.transform.pitch+e.amount,oo(a,e);}if(a.zoom||a.bearing){const e=void 0===i.pinchAround?i.around:i.pinchAround;a.around=e?this._map.unproject(e):this._map.getCenter();}return this.clear(),e.extend(a,{noMoveStart:!0})}}function oo(e,t){(!e.duration||e.duration<t.duration)&&(e.duration=t.duration,e.easing=t.easing);}function ao(t,i,o){const{maxSpeed:a,linearity:r,deceleration:n}=o,s=e.clamp(t*r/(i/1e3),-a,a),l=Math.abs(s)/(n*r);return {easing:o.easing,duration:1e3*l,amount:s*(l/2)}}class ro extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o,r={}){const n=a.mousePos(i.getCanvasContainer(),o),s=i.unproject(n);super(t,e.extend({point:n,lngLat:s,originalEvent:o},r)),this._defaultPrevented=!1,this.target=i;}}class no extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(t,i,o){const r="touchend"===t?o.changedTouches:o.touches,n=a.touchPos(i.getCanvasContainer(),r),s=n.map(e=>i.unproject(e)),l=n.reduce((e,t,i,o)=>e.add(t.div(o.length)),new e.Point(0,0));super(t,{points:n,point:l,lngLats:s,lngLat:i.unproject(l),originalEvent:o}),this._defaultPrevented=!1;}}class so extends e.Event{preventDefault(){this._defaultPrevented=!0;}get defaultPrevented(){return this._defaultPrevented}constructor(e,t,i){super(e,{originalEvent:i}),this._defaultPrevented=!1;}}class lo{constructor(e,t){this._map=e,this._clickTolerance=t.clickTolerance;}reset(){delete this._mousedownPos;}wheel(e){return this._firePreventable(new so(e.type,this._map,e))}mousedown(e,t){return this._mousedownPos=t,this._firePreventable(new ro(e.type,this._map,e))}mouseup(e){this._map.fire(new ro(e.type,this._map,e));}click(e,t){this._mousedownPos&&this._mousedownPos.dist(t)>=this._clickTolerance||this._map.fire(new ro(e.type,this._map,e));}dblclick(e){return this._firePreventable(new ro(e.type,this._map,e))}mouseover(e){this._map.fire(new ro(e.type,this._map,e));}mouseout(e){this._map.fire(new ro(e.type,this._map,e));}touchstart(e){return this._firePreventable(new no(e.type,this._map,e))}touchmove(e){this._map.fire(new no(e.type,this._map,e));}touchend(e){this._map.fire(new no(e.type,this._map,e));}touchcancel(e){this._map.fire(new no(e.type,this._map,e));}_firePreventable(e){if(this._map.fire(e),e.defaultPrevented)return {}}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class co{constructor(e){this._map=e;}reset(){this._delayContextMenu=!1,delete this._contextMenuEvent;}mousemove(e){this._map.fire(new ro(e.type,this._map,e));}mousedown(){this._delayContextMenu=!0;}mouseup(){this._delayContextMenu=!1,this._contextMenuEvent&&(this._map.fire(new ro("contextmenu",this._map,this._contextMenuEvent)),delete this._contextMenuEvent);}contextmenu(e){this._delayContextMenu?this._contextMenuEvent=e:this._map.fire(new ro(e.type,this._map,e)),this._map.listens("contextmenu")&&e.preventDefault();}isEnabled(){return !0}isActive(){return !1}enable(){}disable(){}}class ho{constructor(e,t){this._map=e,this._el=e.getCanvasContainer(),this._container=e.getContainer(),this._clickTolerance=t.clickTolerance||1;}isEnabled(){return !!this._enabled}isActive(){return !!this._active}enable(){this.isEnabled()||(this._enabled=!0);}disable(){this.isEnabled()&&(this._enabled=!1);}mousedown(e,t){this.isEnabled()&&e.shiftKey&&0===e.button&&(a.disableDrag(),this._startPos=this._lastPos=t,this._active=!0);}mousemoveWindow(e,t){if(!this._active)return;const i=t;if(this._lastPos.equals(i)||!this._box&&i.dist(this._startPos)<this._clickTolerance)return;const o=this._startPos;this._lastPos=i,this._box||(this._box=a.create("div","mapboxgl-boxzoom",this._container),this._container.classList.add("mapboxgl-crosshair"),this._fireEvent("boxzoomstart",e));const r=Math.min(o.x,i.x),n=Math.max(o.x,i.x),s=Math.min(o.y,i.y),l=Math.max(o.y,i.y);a.setTransform(this._box,`translate(${r}px,${s}px)`),this._box.style.width=`${n-r}px`,this._box.style.height=`${l-s}px`;}mouseupWindow(t,i){if(!this._active)return;if(0!==t.button)return;const o=this._startPos,r=i;if(this.reset(),a.suppressClick(),o.x!==r.x||o.y!==r.y)return this._map.fire(new e.Event("boxzoomend",{originalEvent:t})),{cameraAnimation:e=>e.fitScreenCoordinates(o,r,this._map.getBearing(),{linear:!1})};this._fireEvent("boxzoomcancel",t);}keydown(e){this._active&&27===e.keyCode&&(this.reset(),this._fireEvent("boxzoomcancel",e));}reset(){this._active=!1,this._container.classList.remove("mapboxgl-crosshair"),this._box&&(a.remove(this._box),this._box=null),a.enableDrag(),delete this._startPos,delete this._lastPos;}_fireEvent(t,i){return this._map.fire(new e.Event(t,{originalEvent:i}))}}function uo(e,t){const i={};for(let o=0;o<e.length;o++)i[e[o].identifier]=t[o];return i}class _o{constructor(e){this.reset(),this.numTouches=e.numTouches;}reset(){delete this.centroid,delete this.startTime,delete this.touches,this.aborted=!1;}touchstart(t,i,o){(this.centroid||o.length>this.numTouches)&&(this.aborted=!0),this.aborted||(void 0===this.startTime&&(this.startTime=t.timeStamp),o.length===this.numTouches&&(this.centroid=function(t){const i=new e.Point(0,0);for(const e of t)i._add(e);return i.div(t.length)}(i),this.touches=uo(o,i)));}touchmove(e,t,i){if(this.aborted||!this.centroid)return;const o=uo(i,t);for(const e in this.touches){const t=this.touches[e],i=o[e];(!i||i.dist(t)>30)&&(this.aborted=!0);}}touchend(e,t,i){if((!this.centroid||e.timeStamp-this.startTime>500)&&(this.aborted=!0),0===i.length){const e=!this.aborted&&this.centroid;if(this.reset(),e)return e}}}class mo{constructor(e){this.singleTap=new _o(e),this.numTaps=e.numTaps,this.reset();}reset(){this.lastTime=1/0,delete this.lastTap,this.count=0,this.singleTap.reset();}touchstart(e,t,i){this.singleTap.touchstart(e,t,i);}touchmove(e,t,i){this.singleTap.touchmove(e,t,i);}touchend(e,t,i){const o=this.singleTap.touchend(e,t,i);if(o){const t=e.timeStamp-this.lastTime<500,i=!this.lastTap||this.lastTap.dist(o)<30;if(t&&i||this.reset(),this.count++,this.lastTime=e.timeStamp,this.lastTap=o,this.count===this.numTaps)return this.reset(),o}}}class po{constructor(){this._zoomIn=new mo({numTouches:1,numTaps:2}),this._zoomOut=new mo({numTouches:2,numTaps:1}),this.reset();}reset(){this._active=!1,this._zoomIn.reset(),this._zoomOut.reset();}touchstart(e,t,i){this._zoomIn.touchstart(e,t,i),this._zoomOut.touchstart(e,t,i);}touchmove(e,t,i){this._zoomIn.touchmove(e,t,i),this._zoomOut.touchmove(e,t,i);}touchend(e,t,i){const o=this._zoomIn.touchend(e,t,i),a=this._zoomOut.touchend(e,t,i);return o?(this._active=!0,e.preventDefault(),setTimeout(()=>this.reset(),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()+1,around:t.unproject(o)},{originalEvent:e})}):a?(this._active=!0,e.preventDefault(),setTimeout(()=>this.reset(),0),{cameraAnimation:t=>t.easeTo({duration:300,zoom:t.getZoom()-1,around:t.unproject(a)},{originalEvent:e})}):void 0}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}const fo={0:1,2:2};class go{constructor(e){this.reset(),this._clickTolerance=e.clickTolerance||1;}reset(){this._active=!1,this._moved=!1,delete this._lastPoint,delete this._eventButton;}_correctButton(e,t){return !1}_move(e,t){return {}}mousedown(e,t){if(this._lastPoint)return;const i=a.mouseButton(e);this._correctButton(e,i)&&(this._lastPoint=t,this._eventButton=i);}mousemoveWindow(e,t){const i=this._lastPoint;if(i)if(e.preventDefault(),function(e,t){const i=fo[t];return void 0===e.buttons||(e.buttons&i)!==i}(e,this._eventButton))this.reset();else if(this._moved||!(t.dist(i)<this._clickTolerance))return this._moved=!0,this._lastPoint=t,this._move(i,t)}mouseupWindow(e){this._lastPoint&&a.mouseButton(e)===this._eventButton&&(this._moved&&a.suppressClick(),this.reset());}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class vo extends go{mousedown(e,t){super.mousedown(e,t),this._lastPoint&&(this._active=!0);}_correctButton(e,t){return 0===t&&!e.ctrlKey}_move(e,t){return {around:t,panDelta:t.sub(e)}}}class xo extends go{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=.8*(t.x-e.x);if(i)return this._active=!0,{bearingDelta:i}}contextmenu(e){e.preventDefault();}}class yo extends go{_correctButton(e,t){return 0===t&&e.ctrlKey||2===t}_move(e,t){const i=-.5*(t.y-e.y);if(i)return this._active=!0,{pitchDelta:i}}contextmenu(e){e.preventDefault();}}class bo{constructor(e){this._minTouches=1,this._clickTolerance=e.clickTolerance||1,this.reset();}reset(){this._active=!1,this._touches={},this._sum=new e.Point(0,0);}touchstart(e,t,i){return this._calculateTransform(e,t,i)}touchmove(e,t,i){if(this._active&&!(i.length<this._minTouches))return e.preventDefault(),this._calculateTransform(e,t,i)}touchend(e,t,i){this._calculateTransform(e,t,i),this._active&&i.length<this._minTouches&&this.reset();}touchcancel(){this.reset();}_calculateTransform(t,i,o){o.length>0&&(this._active=!0);const a=uo(o,i),r=new e.Point(0,0),n=new e.Point(0,0);let s=0;for(const e in a){const t=a[e],i=this._touches[e];i&&(r._add(t),n._add(t.sub(i)),s++,a[e]=t);}if(this._touches=a,s<this._minTouches||!n.mag())return;const l=n.div(s);return this._sum._add(l),this._sum.mag()<this._clickTolerance?void 0:{around:r.div(s),panDelta:l}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class wo{constructor(){this.reset();}reset(){this._active=!1,delete this._firstTwoTouches;}_start(e){}_move(e,t,i){return {}}touchstart(e,t,i){this._firstTwoTouches||i.length<2||(this._firstTwoTouches=[i[0].identifier,i[1].identifier],this._start([t[0],t[1]]));}touchmove(e,t,i){if(!this._firstTwoTouches)return;e.preventDefault();const[o,a]=this._firstTwoTouches,r=To(i,t,o),n=To(i,t,a);if(!r||!n)return;const s=this._aroundCenter?null:r.add(n).div(2);return this._move([r,n],s,e)}touchend(e,t,i){if(!this._firstTwoTouches)return;const[o,r]=this._firstTwoTouches,n=To(i,t,o),s=To(i,t,r);n&&s||(this._active&&a.suppressClick(),this.reset());}touchcancel(){this.reset();}enable(e){this._enabled=!0,this._aroundCenter=!!e&&"center"===e.around;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}function To(e,t,i){for(let o=0;o<e.length;o++)if(e[o].identifier===i)return t[o]}function Eo(e,t){return Math.log(e/t)/Math.LN2}class Co extends wo{reset(){super.reset(),delete this._distance,delete this._startDistance;}_start(e){this._startDistance=this._distance=e[0].dist(e[1]);}_move(e,t){const i=this._distance;if(this._distance=e[0].dist(e[1]),this._active||!(Math.abs(Eo(this._distance,this._startDistance))<.1))return this._active=!0,{zoomDelta:Eo(this._distance,i),pinchAround:t}}}function So(e,t){return 180*e.angleWith(t)/Math.PI}class Io extends wo{reset(){super.reset(),delete this._minDiameter,delete this._startVector,delete this._vector;}_start(e){this._startVector=this._vector=e[0].sub(e[1]),this._minDiameter=e[0].dist(e[1]);}_move(e,t){const i=this._vector;if(this._vector=e[0].sub(e[1]),this._active||!this._isBelowThreshold(this._vector))return this._active=!0,{bearingDelta:So(this._vector,i),pinchAround:t}}_isBelowThreshold(e){this._minDiameter=Math.min(this._minDiameter,e.mag());const t=25/(Math.PI*this._minDiameter)*360,i=So(e,this._startVector);return Math.abs(i)<t}}function Po(e){return Math.abs(e.y)>Math.abs(e.x)}class Mo extends wo{reset(){super.reset(),this._valid=void 0,delete this._firstMove,delete this._lastPoints;}_start(e){this._lastPoints=e,Po(e[0].sub(e[1]))&&(this._valid=!1);}_move(e,t,i){const o=e[0].sub(this._lastPoints[0]),a=e[1].sub(this._lastPoints[1]);if(this._valid=this.gestureBeginsVertically(o,a,i.timeStamp),this._valid)return this._lastPoints=e,this._active=!0,{pitchDelta:(o.y+a.y)/2*-.5}}gestureBeginsVertically(e,t,i){if(void 0!==this._valid)return this._valid;const o=e.mag()>=2,a=t.mag()>=2;if(!o&&!a)return;if(!o||!a)return void 0===this._firstMove&&(this._firstMove=i),i-this._firstMove<100&&void 0;const r=e.y>0==t.y>0;return Po(e)&&Po(t)&&r}}const zo={panStep:100,bearingStep:15,pitchStep:10};class Ao{constructor(){const e=zo;this._panStep=e.panStep,this._bearingStep=e.bearingStep,this._pitchStep=e.pitchStep,this._rotationDisabled=!1;}reset(){this._active=!1;}keydown(e){if(e.altKey||e.ctrlKey||e.metaKey)return;let t=0,i=0,o=0,a=0,r=0;switch(e.keyCode){case 61:case 107:case 171:case 187:t=1;break;case 189:case 109:case 173:t=-1;break;case 37:e.shiftKey?i=-1:(e.preventDefault(),a=-1);break;case 39:e.shiftKey?i=1:(e.preventDefault(),a=1);break;case 38:e.shiftKey?o=1:(e.preventDefault(),r=-1);break;case 40:e.shiftKey?o=-1:(e.preventDefault(),r=1);break;default:return}return this._rotationDisabled&&(i=0,o=0),{cameraAnimation:n=>{const s=n.getZoom();n.easeTo({duration:300,easeId:"keyboardHandler",easing:Do,zoom:t?Math.round(s)+t*(e.shiftKey?2:1):s,bearing:n.getBearing()+i*this._bearingStep,pitch:n.getPitch()+o*this._pitchStep,offset:[-a*this._panStep,-r*this._panStep],center:n.getCenter()},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}disableRotation(){this._rotationDisabled=!0;}enableRotation(){this._rotationDisabled=!1;}}function Do(e){return e*(2-e)}class Lo{constructor(t,i){this._map=t,this._el=t.getCanvasContainer(),this._handler=i,this._delta=0,this._defaultZoomRate=.01,this._wheelZoomRate=1/450,e.bindAll(["_onTimeout"],this);}setZoomRate(e){this._defaultZoomRate=e;}setWheelZoomRate(e){this._wheelZoomRate=e;}isEnabled(){return !!this._enabled}isActive(){return !!this._active||void 0!==this._finishTimeout}isZooming(){return !!this._zooming}enable(e){this.isEnabled()||(this._enabled=!0,this._aroundCenter=e&&"center"===e.around);}disable(){this.isEnabled()&&(this._enabled=!1);}wheel(t){if(!this.isEnabled())return;let i=t.deltaMode===e.window.WheelEvent.DOM_DELTA_LINE?40*t.deltaY:t.deltaY;const o=e.browser.now(),a=o-(this._lastWheelEventTime||0);this._lastWheelEventTime=o,0!==i&&i%4.000244140625==0?this._type="wheel":0!==i&&Math.abs(i)<4?this._type="trackpad":a>400?(this._type=null,this._lastValue=i,this._timeout=setTimeout(this._onTimeout,40,t)):this._type||(this._type=Math.abs(a*i)<200?"trackpad":"wheel",this._timeout&&(clearTimeout(this._timeout),this._timeout=null,i+=this._lastValue)),t.shiftKey&&i&&(i/=4),this._type&&(this._lastWheelEvent=t,this._delta-=i,this._active||this._start(t)),t.preventDefault();}_onTimeout(e){this._type="wheel",this._delta-=this._lastValue,this._active||this._start(e);}_start(e){if(!this._delta)return;this._frameId&&(this._frameId=null),this._active=!0,this.isZooming()||(this._zooming=!0),this._finishTimeout&&(clearTimeout(this._finishTimeout),delete this._finishTimeout);const t=a.mousePos(this._el,e);this._aroundPoint=this._aroundCenter?this._map.transform.centerPoint:t,this._aroundCoord=this._map.transform.pointCoordinate3D(this._aroundPoint),this._targetZoom=void 0,this._frameId||(this._frameId=!0,this._handler._triggerRenderFrame());}renderFrame(){if(!this._frameId)return;if(this._frameId=null,!this.isActive())return;const t=this._map.transform,i=()=>t._terrainEnabled()?t.computeZoomRelativeTo(this._aroundCoord):t.zoom;if(0!==this._delta){const e="wheel"===this._type&&Math.abs(this._delta)>4.000244140625?this._wheelZoomRate:this._defaultZoomRate;let o=2/(1+Math.exp(-Math.abs(this._delta*e)));this._delta<0&&0!==o&&(o=1/o);const a=i(),r=Math.pow(2,a),n="number"==typeof this._targetZoom?t.zoomScale(this._targetZoom):r;this._targetZoom=Math.min(t.maxZoom,Math.max(t.minZoom,t.scaleZoom(n*o))),"wheel"===this._type&&(this._startZoom=i(),this._easing=this._smoothOutEasing(200)),this._delta=0;}const o="number"==typeof this._targetZoom?this._targetZoom:i(),a=this._startZoom,r=this._easing;let n,s=!1;if("wheel"===this._type&&a&&r){const t=Math.min((e.browser.now()-this._lastWheelEventTime)/200,1),i=r(t);n=e.number(a,o,i),t<1?this._frameId||(this._frameId=!0):s=!0;}else n=o,s=!0;return this._active=!0,s&&(this._active=!1,this._finishTimeout=setTimeout(()=>{this._zooming=!1,this._handler._triggerRenderFrame(),delete this._targetZoom,delete this._finishTimeout;},200)),{noInertia:!0,needsRenderFrame:!s,zoomDelta:n-i(),around:this._aroundPoint,aroundCoord:this._aroundCoord,originalEvent:this._lastWheelEvent}}_smoothOutEasing(t){let i=e.ease;if(this._prevEase){const t=this._prevEase,o=(e.browser.now()-t.start)/t.duration,a=t.easing(o+.01)-t.easing(o),r=.27/Math.sqrt(a*a+1e-4)*.01,n=Math.sqrt(.0729-r*r);i=e.bezier(r,n,.25,1);}return this._prevEase={start:e.browser.now(),duration:t,easing:i},i}reset(){this._active=!1;}}class Ro{constructor(e,t){this._clickZoom=e,this._tapZoom=t;}enable(){this._clickZoom.enable(),this._tapZoom.enable();}disable(){this._clickZoom.disable(),this._tapZoom.disable();}isEnabled(){return this._clickZoom.isEnabled()&&this._tapZoom.isEnabled()}isActive(){return this._clickZoom.isActive()||this._tapZoom.isActive()}}class ko{constructor(){this.reset();}reset(){this._active=!1;}dblclick(e,t){return e.preventDefault(),{cameraAnimation:i=>{i.easeTo({duration:300,zoom:i.getZoom()+(e.shiftKey?-1:1),around:i.unproject(t)},{originalEvent:e});}}}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Bo{constructor(){this._tap=new mo({numTouches:1,numTaps:1}),this.reset();}reset(){this._active=!1,delete this._swipePoint,delete this._swipeTouch,delete this._tapTime,this._tap.reset();}touchstart(e,t,i){this._swipePoint||(this._tapTime&&e.timeStamp-this._tapTime>500&&this.reset(),this._tapTime?i.length>0&&(this._swipePoint=t[0],this._swipeTouch=i[0].identifier):this._tap.touchstart(e,t,i));}touchmove(e,t,i){if(this._tapTime){if(this._swipePoint){if(i[0].identifier!==this._swipeTouch)return;const o=t[0],a=o.y-this._swipePoint.y;return this._swipePoint=o,e.preventDefault(),this._active=!0,{zoomDelta:a/128}}}else this._tap.touchmove(e,t,i);}touchend(e,t,i){this._tapTime?this._swipePoint&&0===i.length&&this.reset():this._tap.touchend(e,t,i)&&(this._tapTime=e.timeStamp);}touchcancel(){this.reset();}enable(){this._enabled=!0;}disable(){this._enabled=!1,this.reset();}isEnabled(){return this._enabled}isActive(){return this._active}}class Fo{constructor(e,t,i){this._el=e,this._mousePan=t,this._touchPan=i;}enable(e){this._inertiaOptions=e||{},this._mousePan.enable(),this._touchPan.enable(),this._el.classList.add("mapboxgl-touch-drag-pan");}disable(){this._mousePan.disable(),this._touchPan.disable(),this._el.classList.remove("mapboxgl-touch-drag-pan");}isEnabled(){return this._mousePan.isEnabled()&&this._touchPan.isEnabled()}isActive(){return this._mousePan.isActive()||this._touchPan.isActive()}}class Oo{constructor(e,t,i){this._pitchWithRotate=e.pitchWithRotate,this._mouseRotate=t,this._mousePitch=i;}enable(){this._mouseRotate.enable(),this._pitchWithRotate&&this._mousePitch.enable();}disable(){this._mouseRotate.disable(),this._mousePitch.disable();}isEnabled(){return this._mouseRotate.isEnabled()&&(!this._pitchWithRotate||this._mousePitch.isEnabled())}isActive(){return this._mouseRotate.isActive()||this._mousePitch.isActive()}}class Uo{constructor(e,t,i,o){this._el=e,this._touchZoom=t,this._touchRotate=i,this._tapDragZoom=o,this._rotationDisabled=!1,this._enabled=!0;}enable(e){this._touchZoom.enable(e),this._rotationDisabled||this._touchRotate.enable(e),this._tapDragZoom.enable(),this._el.classList.add("mapboxgl-touch-zoom-rotate");}disable(){this._touchZoom.disable(),this._touchRotate.disable(),this._tapDragZoom.disable(),this._el.classList.remove("mapboxgl-touch-zoom-rotate");}isEnabled(){return this._touchZoom.isEnabled()&&(this._rotationDisabled||this._touchRotate.isEnabled())&&this._tapDragZoom.isEnabled()}isActive(){return this._touchZoom.isActive()||this._touchRotate.isActive()||this._tapDragZoom.isActive()}disableRotation(){this._rotationDisabled=!0,this._touchRotate.disable();}enableRotation(){this._rotationDisabled=!1,this._touchZoom.isEnabled()&&this._touchRotate.enable();}}const No=e=>e.zoom||e.drag||e.pitch||e.rotate;class Zo extends e.Event{}class Go{constructor(){this.constants=[1,1,.01],this.radius=0;}setup(t,i){const o=e.sub([],i,t);this.radius=e.length(o[2]<0?e.div([],o,this.constants):[o[0],o[1],0]);}projectRay(t){e.div(t,t,this.constants),e.normalize(t,t),e.mul$1(t,t,this.constants);const i=e.scale$2([],t,this.radius);if(i[2]>0){const t=e.scale$2([],[0,0,1],e.dot(i,[0,0,1])),o=e.scale$2([],e.normalize([],[i[0],i[1],0]),this.radius),a=e.add([],i,e.scale$2([],e.sub([],e.add([],o,t),i),2));i[0]=a[0],i[1]=a[1];}return i}}function Vo(e){return e.panDelta&&e.panDelta.mag()||e.zoomDelta||e.bearingDelta||e.pitchDelta}class qo{constructor(t,i){this._map=t,this._el=this._map.getCanvasContainer(),this._handlers=[],this._handlersById={},this._changes=[],this._inertia=new io(t),this._bearingSnap=i.bearingSnap,this._previousActiveHandlers={},this._trackingEllipsoid=new Go,this._dragOrigin=null,this._eventsInProgress={},this._addDefaultHandlers(i),e.bindAll(["handleEvent","handleWindowEvent"],this);const o=this._el;this._listeners=[[o,"touchstart",{passive:!0}],[o,"touchmove",{passive:!1}],[o,"touchend",void 0],[o,"touchcancel",void 0],[o,"mousedown",void 0],[o,"mousemove",void 0],[o,"mouseup",void 0],[e.window.document,"mousemove",{capture:!0}],[e.window.document,"mouseup",void 0],[o,"mouseover",void 0],[o,"mouseout",void 0],[o,"dblclick",void 0],[o,"click",void 0],[o,"keydown",{capture:!1}],[o,"keyup",void 0],[o,"wheel",{passive:!1}],[o,"contextmenu",void 0],[e.window,"blur",void 0]];for(const[t,i,o]of this._listeners)a.addEventListener(t,i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}destroy(){for(const[t,i,o]of this._listeners)a.removeEventListener(t,i,t===e.window.document?this.handleWindowEvent:this.handleEvent,o);}_addDefaultHandlers(e){const t=this._map,i=t.getCanvasContainer();this._add("mapEvent",new lo(t,e));const o=t.boxZoom=new ho(t,e);this._add("boxZoom",o);const a=new po,r=new ko;t.doubleClickZoom=new Ro(r,a),this._add("tapZoom",a),this._add("clickZoom",r);const n=new Bo;this._add("tapDragZoom",n);const s=t.touchPitch=new Mo;this._add("touchPitch",s);const l=new xo(e),c=new yo(e);t.dragRotate=new Oo(e,l,c),this._add("mouseRotate",l,["mousePitch"]),this._add("mousePitch",c,["mouseRotate"]);const h=new vo(e),u=new bo(e);t.dragPan=new Fo(i,h,u),this._add("mousePan",h),this._add("touchPan",u,["touchZoom","touchRotate"]);const d=new Io,_=new Co;t.touchZoomRotate=new Uo(i,_,d,n),this._add("touchRotate",d,["touchPan","touchZoom"]),this._add("touchZoom",_,["touchPan","touchRotate"]),this._add("blockableMapEvent",new co(t));const m=t.scrollZoom=new Lo(t,this);this._add("scrollZoom",m,["mousePan"]);const p=t.keyboard=new Ao;this._add("keyboard",p);for(const i of ["boxZoom","doubleClickZoom","tapDragZoom","touchPitch","dragRotate","dragPan","touchZoomRotate","scrollZoom","keyboard"])e.interactive&&e[i]&&t[i].enable(e[i]);}_add(e,t,i){this._handlers.push({handlerName:e,handler:t,allowed:i}),this._handlersById[e]=t;}stop(e){if(!this._updatingCamera){for(const{handler:e}of this._handlers)e.reset();this._inertia.clear(),this._fireEvents({},{},e),this._changes=[];}}isActive(){for(const{handler:e}of this._handlers)if(e.isActive())return !0;return !1}isZooming(){return !!this._eventsInProgress.zoom||this._map.scrollZoom.isZooming()}isRotating(){return !!this._eventsInProgress.rotate}isMoving(){return Boolean(No(this._eventsInProgress))||this.isZooming()}_blockedByActive(e,t,i){for(const o in e)if(o!==i&&(!t||t.indexOf(o)<0))return !0;return !1}handleWindowEvent(e){this.handleEvent(e,`${e.type}Window`);}_getMapTouches(e){const t=[];for(const i of e)this._el.contains(i.target)&&t.push(i);return t}handleEvent(e,t){if("blur"===e.type)return void this.stop(!0);this._updatingCamera=!0;const i="renderFrame"===e.type?void 0:e,o={needsRenderFrame:!1},r={},n={},s=e.touches?this._getMapTouches(e.touches):void 0,l=s?a.touchPos(this._el,s):a.mousePos(this._el,e);for(const{handlerName:a,handler:c,allowed:h}of this._handlers){if(!c.isEnabled())continue;let u;this._blockedByActive(n,h,a)?c.reset():c[t||e.type]&&(u=c[t||e.type](e,l,s),this.mergeHandlerResult(o,r,u,a,i),u&&u.needsRenderFrame&&this._triggerRenderFrame()),(u||c.isActive())&&(n[a]=c);}const c={};for(const e in this._previousActiveHandlers)n[e]||(c[e]=i);this._previousActiveHandlers=n,(Object.keys(c).length||Vo(o))&&(this._changes.push([o,r,c]),this._triggerRenderFrame()),(Object.keys(n).length||Vo(o))&&this._map._stop(!0),this._updatingCamera=!1;const{cameraAnimation:h}=o;h&&(this._inertia.clear(),this._fireEvents({},{},!0),this._changes=[],h(this._map));}mergeHandlerResult(t,i,o,a,r){if(!o)return;e.extend(t,o);const n={handlerName:a,originalEvent:o.originalEvent||r};void 0!==o.zoomDelta&&(i.zoom=n),void 0!==o.panDelta&&(i.drag=n),void 0!==o.pitchDelta&&(i.pitch=n),void 0!==o.bearingDelta&&(i.rotate=n);}_applyChanges(){const t={},i={},o={};for(const[a,r,n]of this._changes)a.panDelta&&(t.panDelta=(t.panDelta||new e.Point(0,0))._add(a.panDelta)),a.zoomDelta&&(t.zoomDelta=(t.zoomDelta||0)+a.zoomDelta),a.bearingDelta&&(t.bearingDelta=(t.bearingDelta||0)+a.bearingDelta),a.pitchDelta&&(t.pitchDelta=(t.pitchDelta||0)+a.pitchDelta),void 0!==a.around&&(t.around=a.around),void 0!==a.aroundCoord&&(t.aroundCoord=a.aroundCoord),void 0!==a.pinchAround&&(t.pinchAround=a.pinchAround),a.noInertia&&(t.noInertia=a.noInertia),e.extend(i,r),e.extend(o,n);this._updateMapTransform(t,i,o),this._changes=[];}_updateMapTransform(t,i,o){const a=this._map,r=a.transform,n=e=>[e.x,e.y,e.z];if((e=>{const t=this._eventsInProgress.drag;return t&&!this._handlersById[t.handlerName].isActive()})()&&!Vo(t)){const e=r.zoom;r.cameraElevationReference="sea",r.recenterOnTerrain(),r.cameraElevationReference="ground",e!==r.zoom&&this._map._update(!0);}if(!Vo(t))return this._fireEvents(i,o,!0);let{panDelta:s,zoomDelta:l,bearingDelta:c,pitchDelta:h,around:u,aroundCoord:d,pinchAround:_}=t;void 0!==_&&(u=_),(e=>i.drag&&!this._eventsInProgress.drag)()&&u&&(this._dragOrigin=n(r.pointCoordinate3D(u)),this._trackingEllipsoid.setup(r._camera.position,this._dragOrigin)),r.cameraElevationReference="sea",a._stop(!0),u=u||a.transform.centerPoint,c&&(r.bearing+=c),h&&(r.pitch+=h),r._updateCameraState();const m=[0,0,0];if(s){const e=r.screenPointToMercatorRay(u),t=r.screenPointToMercatorRay(u.sub(s)),i=this._trackingEllipsoid.projectRay(e.dir),o=this._trackingEllipsoid.projectRay(t.dir);m[0]=o[0]-i[0],m[1]=o[1]-i[1];}const p=r.zoom,f=[0,0,0];if(l){const t=n(d||r.pointCoordinate3D(u)),i={dir:e.normalize([],e.sub([],t,r._camera.position))},o=r.screenPointToMercatorRay(r.centerPoint);if(i.dir[2]<0){const a=e.altitudeFromMercatorZ(t[2],t[1]),s=r.rayIntersectionCoordinate(r.pointRayIntersection(r.centerPoint,a)),c=r.zoomDeltaToMovement(n(s),l)*(o.dir[2]/i.dir[2]);e.scale$2(f,i.dir,c);}else if(r._terrainEnabled()){const o=r.zoomDeltaToMovement(t,l);e.scale$2(f,i.dir,o);}}const g=e.add(m,m,f);r._translateCameraConstrained(g),l&&Math.abs(r.zoom-p)>1e-4&&r.recenterOnTerrain(),r.cameraElevationReference="ground",this._map._update(),t.noInertia||this._inertia.record(t),this._fireEvents(i,o,!0);}_fireEvents(t,i,o){const a=No(this._eventsInProgress),r=No(t),n={};for(const e in t){const{originalEvent:i}=t[e];this._eventsInProgress[e]||(n[`${e}start`]=i),this._eventsInProgress[e]=t[e];}!a&&r&&this._fireEvent("movestart",r.originalEvent);for(const e in n)this._fireEvent(e,n[e]);r&&this._fireEvent("move",r.originalEvent);for(const e in t){const{originalEvent:i}=t[e];this._fireEvent(e,i);}const s={};let l;for(const e in this._eventsInProgress){const{handlerName:t,originalEvent:o}=this._eventsInProgress[e];this._handlersById[t].isActive()||(delete this._eventsInProgress[e],l=i[t]||o,s[`${e}end`]=l);}for(const e in s)this._fireEvent(e,s[e]);const c=No(this._eventsInProgress);if(o&&(a||r)&&!c){this._updatingCamera=!0;const t=this._inertia._onMoveEnd(this._map.dragPan._inertiaOptions),i=e=>0!==e&&-this._bearingSnap<e&&e<this._bearingSnap;t?(i(t.bearing||this._map.getBearing())&&(t.bearing=0),this._map.easeTo(t,{originalEvent:l})):(this._map.fire(new e.Event("moveend",{originalEvent:l})),i(this._map.getBearing())&&this._map.resetNorth()),this._updatingCamera=!1;}}_fireEvent(t,i){this._map.fire(new e.Event(t,i?{originalEvent:i}:{}));}_requestFrame(){return this._map.triggerRepaint(),this._map._renderTaskQueue.add(e=>{delete this._frameId,this.handleEvent(new Zo("renderFrame",{timeStamp:e})),this._applyChanges();})}_triggerRenderFrame(){void 0===this._frameId&&(this._frameId=this._requestFrame());}}class jo extends e.Evented{constructor(t,i){super(),this._moving=!1,this._zooming=!1,this.transform=t,this._bearingSnap=i.bearingSnap,e.bindAll(["_renderFrameCallback"],this);}getCenter(){return new e.LngLat(this.transform.center.lng,this.transform.center.lat)}setCenter(e,t){return this.jumpTo({center:e},t)}panBy(t,i,o){return t=e.Point.convert(t).mult(-1),this.panTo(this.transform.center,e.extend({offset:t},i),o)}panTo(t,i,o){return this.easeTo(e.extend({center:t},i),o)}getZoom(){return this.transform.zoom}setZoom(e,t){return this.jumpTo({zoom:e},t),this}zoomTo(t,i,o){return this.easeTo(e.extend({zoom:t},i),o)}zoomIn(e,t){return this.zoomTo(this.getZoom()+1,e,t),this}zoomOut(e,t){return this.zoomTo(this.getZoom()-1,e,t),this}getBearing(){return this.transform.bearing}setBearing(e,t){return this.jumpTo({bearing:e},t),this}getPadding(){return this.transform.padding}setPadding(e,t){return this.jumpTo({padding:e},t),this}rotateTo(t,i,o){return this.easeTo(e.extend({bearing:t},i),o)}resetNorth(t,i){return this.rotateTo(0,e.extend({duration:1e3},t),i),this}resetNorthPitch(t,i){return this.easeTo(e.extend({bearing:0,pitch:0,duration:1e3},t),i),this}snapToNorth(e,t){return Math.abs(this.getBearing())<this._bearingSnap?this.resetNorth(e,t):this}getPitch(){return this.transform.pitch}setPitch(e,t){return this.jumpTo({pitch:e},t),this}cameraForBounds(t,i){t=e.LngLatBounds.convert(t);const o=i&&i.bearing||0;return this._cameraForBoxAndBearing(t.getNorthWest(),t.getSouthEast(),o,i)}_extendCameraOptions(t){const i={top:0,bottom:0,right:0,left:0};if("number"==typeof(t=e.extend({padding:i,offset:[0,0],maxZoom:this.transform.maxZoom},t)).padding){const e=t.padding;t.padding={top:e,bottom:e,right:e,left:e};}return t.padding=e.extend(i,t.padding),t}_cameraForBoxAndBearing(t,i,o,a){const r=this._extendCameraOptions(a),n=this.transform,s=n.padding,l=n.project(e.LngLat.convert(t)),c=n.project(e.LngLat.convert(i)),h=l.rotate(-e.degToRad(o)),u=c.rotate(-e.degToRad(o)),d=new e.Point(Math.max(h.x,u.x),Math.max(h.y,u.y)),_=new e.Point(Math.min(h.x,u.x),Math.min(h.y,u.y)),m=d.sub(_),p=(n.width-(s.left+s.right+r.padding.left+r.padding.right))/m.x,f=(n.height-(s.top+s.bottom+r.padding.top+r.padding.bottom))/m.y;if(f<0||p<0)return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");const g=Math.min(n.scaleZoom(n.scale*Math.min(p,f)),r.maxZoom),v="number"==typeof r.offset.x?new e.Point(r.offset.x,r.offset.y):e.Point.convert(r.offset),x=new e.Point((r.padding.left-r.padding.right)/2,(r.padding.top-r.padding.bottom)/2).rotate(o*Math.PI/180),y=v.add(x).mult(n.scale/n.zoomScale(g));return {center:n.unproject(l.add(c).div(2).sub(y)),zoom:g,bearing:o}}_cameraForBox(t,i,o,a,r){const n=this._extendCameraOptions(r);o=o||0,a=a||0,t=e.LngLat.convert(t),i=e.LngLat.convert(i);const s=this.transform.clone();s.padding=n.padding;const l=this.getFreeCameraOptions(),c=new e.LngLat(.5*(t.lng+i.lng),.5*(t.lat+i.lat)),h=.5*(o+a);if(s._camera.position[2]<e.mercatorZfromAltitude(h,c.lat))return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.");l.lookAtPoint(c),s.setFreeCameraOptions(l);const u=e.MercatorCoordinate.fromLngLat(t),d=e.MercatorCoordinate.fromLngLat(i),_=s.pointRayIntersection(s.centerPoint,h),m=[(p=s.rayIntersectionCoordinate(_)).x,p.y,p.z];var p;const f=s.screenPointToMercatorRay(s.centerPoint);let g,v=0;do{const t=Math.floor(s.zoom),i=1<<t,r=Math.min(i*u.x,i*d.x),n=Math.min(i*u.y,i*d.y),l=Math.max(i*u.x,i*d.x),c=Math.max(i*u.y,i*d.y),h=new e.Aabb([r,n,o],[l,c,a]),_=e.Frustum.fromInvProjectionMatrix(s.invProjMatrix,s.worldSize,t);if(2!==h.intersects(_)){g&&(s._camera.position=e.scaleAndAdd([],s._camera.position,f.dir,-g),s._updateStateFromCamera());break}const p=e.sub([],s._camera.position,m);g=.5*e.length(p),s._camera.position=e.scaleAndAdd([],s._camera.position,f.dir,g);try{s._updateStateFromCamera();}catch(t){return void e.warnOnce("Map cannot fit within canvas with the given bounds, padding, and/or offset.")}}while(++v<10);return {center:s.center,zoom:s.zoom,bearing:s.bearing,pitch:s.pitch}}fitBounds(e,t,i){return this._fitInternal(this.cameraForBounds(e,t),t,i)}_raycastElevationBox(t,i){const o=this.transform.elevation;if(!o)return;const a=new e.Point(t.x,i.y),r=new e.Point(i.x,t.y),n=o.pointCoordinate(t);if(!n)return;const s=o.pointCoordinate(i);if(!s)return;const l=o.pointCoordinate(a);if(!l)return;const c=o.pointCoordinate(r);if(!c)return;const h=new e.MercatorCoordinate(n[0],n[1]).toLngLat(),u=new e.MercatorCoordinate(s[0],s[1]).toLngLat(),d=new e.MercatorCoordinate(l[0],l[1]).toLngLat(),_=new e.MercatorCoordinate(c[0],c[1]).toLngLat(),m=Math.min(h.lng,Math.min(u.lng,Math.min(d.lng,_.lng))),p=Math.min(h.lat,Math.min(u.lat,Math.min(d.lat,_.lat))),f=Math.max(h.lng,Math.max(u.lng,Math.max(d.lng,_.lng))),g=Math.max(h.lat,Math.max(u.lat,Math.max(d.lat,_.lat))),v=Math.min(n[3],Math.min(s[3],Math.min(l[3],c[3]))),x=Math.max(n[3],Math.max(s[3],Math.max(l[3],c[3])));return {minLngLat:new e.LngLat(m,p),maxLngLat:new e.LngLat(f,g),minAltitude:v,maxAltitude:x}}fitScreenCoordinates(t,i,o,a,r){let n,s,l,c;const h=e.Point.convert(t),u=e.Point.convert(i),d=this._raycastElevationBox(h,u);if(d)n=d.minLngLat,s=d.maxLngLat,l=d.minAltitude,c=d.maxAltitude;else {if(this.transform.isHorizonVisibleForPoints(h,u))return this;n=this.transform.pointLocation(h),s=this.transform.pointLocation(u);}return this._fitInternal(0===this.transform.pitch?this._cameraForBoxAndBearing(this.transform.pointLocation(e.Point.convert(t)),this.transform.pointLocation(e.Point.convert(i)),o,a):this._cameraForBox(n,s,l,c,a),a,r)}_fitInternal(t,i,o){return t?(delete(i=e.extend(t,i)).padding,i.linear?this.easeTo(i,o):this.flyTo(i,o)):this}jumpTo(t,i){this.stop();const o=this.transform;let a=!1,r=!1,n=!1;return "zoom"in t&&o.zoom!==+t.zoom&&(a=!0,o.zoom=+t.zoom),void 0!==t.center&&(o.center=e.LngLat.convert(t.center)),"bearing"in t&&o.bearing!==+t.bearing&&(r=!0,o.bearing=+t.bearing),"pitch"in t&&o.pitch!==+t.pitch&&(n=!0,o.pitch=+t.pitch),null==t.padding||o.isPaddingEqual(t.padding)||(o.padding=t.padding),this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),a&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),r&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),n&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i))}getFreeCameraOptions(){return this.transform.getFreeCameraOptions()}setFreeCameraOptions(t,i){this.stop();const o=this.transform,a=o.zoom,r=o.pitch,n=o.bearing;o.setFreeCameraOptions(t);const s=a!==o.zoom,l=r!==o.pitch,c=n!==o.bearing;return this.fire(new e.Event("movestart",i)).fire(new e.Event("move",i)),s&&this.fire(new e.Event("zoomstart",i)).fire(new e.Event("zoom",i)).fire(new e.Event("zoomend",i)),c&&this.fire(new e.Event("rotatestart",i)).fire(new e.Event("rotate",i)).fire(new e.Event("rotateend",i)),l&&this.fire(new e.Event("pitchstart",i)).fire(new e.Event("pitch",i)).fire(new e.Event("pitchend",i)),this.fire(new e.Event("moveend",i)),this}easeTo(t,i){this._stop(!1,t.easeId),(!1===(t=e.extend({offset:[0,0],duration:500,easing:e.ease},t)).animate||!t.essential&&e.browser.prefersReducedMotion)&&(t.duration=0);const o=this.transform,a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in t?+t.zoom:a,c="bearing"in t?this._normalizeBearing(t.bearing,r):r,h="pitch"in t?+t.pitch:n,u="padding"in t?t.padding:o.padding,d=e.Point.convert(t.offset);let _=o.centerPoint.add(d);const m=o.pointLocation(_),p=e.LngLat.convert(t.center||m);this._normalizeCenter(p);const f=o.project(m),g=o.project(p).sub(f),v=o.zoomScale(l-a);let x,y;t.around&&(x=e.LngLat.convert(t.around),y=o.locationPoint(x));const b={moving:this._moving,zooming:this._zooming,rotating:this._rotating,pitching:this._pitching};return this._zooming=this._zooming||l!==a,this._rotating=this._rotating||r!==c,this._pitching=this._pitching||h!==n,this._padding=!o.isPaddingEqual(u),this._easeId=t.easeId,this._prepareEase(i,t.noMoveStart,b),this._ease(t=>{if(this._zooming&&(o.zoom=e.number(a,l,t)),this._rotating&&(o.bearing=e.number(r,c,t)),this._pitching&&(o.pitch=e.number(n,h,t)),this._padding&&(o.interpolatePadding(s,u,t),_=o.centerPoint.add(d)),x)o.setLocationAtPoint(x,y);else {const e=o.zoomScale(o.zoom-a),i=l>a?Math.min(2,v):Math.max(.5,v),r=Math.pow(i,1-t),n=o.unproject(f.add(g.mult(t*r)).mult(e));o.setLocationAtPoint(o.renderWorldCopies?n.wrap():n,_);}this._fireMoveEvents(i);},e=>{o.recenterOnTerrain(),this._afterEase(i,e);},t),this}_prepareEase(t,i,o={}){this._moving=!0,this.transform.cameraElevationReference="sea",i||o.moving||this.fire(new e.Event("movestart",t)),this._zooming&&!o.zooming&&this.fire(new e.Event("zoomstart",t)),this._rotating&&!o.rotating&&this.fire(new e.Event("rotatestart",t)),this._pitching&&!o.pitching&&this.fire(new e.Event("pitchstart",t));}_fireMoveEvents(t){this.fire(new e.Event("move",t)),this._zooming&&this.fire(new e.Event("zoom",t)),this._rotating&&this.fire(new e.Event("rotate",t)),this._pitching&&this.fire(new e.Event("pitch",t));}_afterEase(t,i){if(this._easeId&&i&&this._easeId===i)return;delete this._easeId,this.transform.cameraElevationReference="ground";const o=this._zooming,a=this._rotating,r=this._pitching;this._moving=!1,this._zooming=!1,this._rotating=!1,this._pitching=!1,this._padding=!1,o&&this.fire(new e.Event("zoomend",t)),a&&this.fire(new e.Event("rotateend",t)),r&&this.fire(new e.Event("pitchend",t)),this.fire(new e.Event("moveend",t));}flyTo(t,i){if(!t.essential&&e.browser.prefersReducedMotion){const o=e.pick(t,["center","zoom","bearing","pitch","around"]);return this.jumpTo(o,i)}this.stop(),t=e.extend({offset:[0,0],speed:1.2,curve:1.42,easing:e.ease},t);const o=this.transform,a=this.getZoom(),r=this.getBearing(),n=this.getPitch(),s=this.getPadding(),l="zoom"in t?e.clamp(+t.zoom,o.minZoom,o.maxZoom):a,c="bearing"in t?this._normalizeBearing(t.bearing,r):r,h="pitch"in t?+t.pitch:n,u="padding"in t?t.padding:o.padding,d=o.zoomScale(l-a),_=e.Point.convert(t.offset);let m=o.centerPoint.add(_);const p=o.pointLocation(m),f=e.LngLat.convert(t.center||p);this._normalizeCenter(f);const g=o.project(p),v=o.project(f).sub(g);let x=t.curve;const y=Math.max(o.width,o.height),b=y/d,w=v.mag();if("minZoom"in t){const i=e.clamp(Math.min(t.minZoom,a,l),o.minZoom,o.maxZoom),r=y/o.zoomScale(i-a);x=Math.sqrt(r/w*2);}const T=x*x;function E(e){const t=(b*b-y*y+(e?-1:1)*T*T*w*w)/(2*(e?b:y)*T*w);return Math.log(Math.sqrt(t*t+1)-t)}function C(e){return (Math.exp(e)-Math.exp(-e))/2}function S(e){return (Math.exp(e)+Math.exp(-e))/2}const I=E(0);let P=function(e){return S(I)/S(I+x*e)},M=function(e){return y*((S(I)*(C(t=I+x*e)/S(t))-C(I))/T)/w;var t;},z=(E(1)-I)/x;if(Math.abs(w)<1e-6||!isFinite(z)){if(Math.abs(y-b)<1e-6)return this.easeTo(t,i);const e=b<y?-1:1;z=Math.abs(Math.log(b/y))/x,M=function(){return 0},P=function(t){return Math.exp(e*x*t)};}return t.duration="duration"in t?+t.duration:1e3*z/("screenSpeed"in t?+t.screenSpeed/x:+t.speed),t.maxDuration&&t.duration>t.maxDuration&&(t.duration=0),this._zooming=!0,this._rotating=r!==c,this._pitching=h!==n,this._padding=!o.isPaddingEqual(u),this._prepareEase(i,!1),this._ease(t=>{const d=t*z,p=1/P(d);o.zoom=1===t?l:a+o.scaleZoom(p),this._rotating&&(o.bearing=e.number(r,c,t)),this._pitching&&(o.pitch=e.number(n,h,t)),this._padding&&(o.interpolatePadding(s,u,t),m=o.centerPoint.add(_));const x=1===t?f:o.unproject(g.add(v.mult(M(d))).mult(p));o.setLocationAtPoint(o.renderWorldCopies?x.wrap():x,m),o._updateCenterElevation(),this._fireMoveEvents(i);},()=>this._afterEase(i),t),this}isEasing(){return !!this._easeFrameId}stop(){return this._stop()}_stop(e,t){if(this._easeFrameId&&(this._cancelRenderFrame(this._easeFrameId),delete this._easeFrameId,delete this._onEaseFrame),this._onEaseEnd){const e=this._onEaseEnd;delete this._onEaseEnd,e.call(this,t);}if(!e){const e=this.handlers;e&&e.stop(!1);}return this}_ease(t,i,o){!1===o.animate||0===o.duration?(t(1),i()):(this._easeStart=e.browser.now(),this._easeOptions=o,this._onEaseFrame=t,this._onEaseEnd=i,this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback));}_renderFrameCallback(){const t=Math.min((e.browser.now()-this._easeStart)/this._easeOptions.duration,1);this._onEaseFrame(this._easeOptions.easing(t)),t<1?this._easeFrameId=this._requestRenderFrame(this._renderFrameCallback):this.stop();}_normalizeBearing(t,i){t=e.wrap(t,-180,180);const o=Math.abs(t-i);return Math.abs(t-360-i)<o&&(t-=360),Math.abs(t+360-i)<o&&(t+=360),t}_normalizeCenter(e){const t=this.transform;if(!t.renderWorldCopies||t.lngRange)return;const i=e.lng-t.center.lng;e.lng+=i>180?-360:i<-180?360:0;}}class $o{constructor(t={}){this.options=t,e.bindAll(["_toggleAttribution","_updateEditLink","_updateData","_updateCompact"],this);}getDefaultPosition(){return "bottom-right"}onAdd(e){const t=this.options&&this.options.compact;return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-attrib"),this._compactButton=a.create("button","mapboxgl-ctrl-attrib-button",this._container),this._compactButton.addEventListener("click",this._toggleAttribution),this._setElementTitle(this._compactButton,"ToggleAttribution"),this._innerContainer=a.create("div","mapboxgl-ctrl-attrib-inner",this._container),this._innerContainer.setAttribute("role","list"),t&&this._container.classList.add("mapboxgl-compact"),this._updateAttributions(),this._updateEditLink(),this._map.on("styledata",this._updateData),this._map.on("sourcedata",this._updateData),this._map.on("moveend",this._updateEditLink),void 0===t&&(this._map.on("resize",this._updateCompact),this._updateCompact()),this._container}onRemove(){a.remove(this._container),this._map.off("styledata",this._updateData),this._map.off("sourcedata",this._updateData),this._map.off("moveend",this._updateEditLink),this._map.off("resize",this._updateCompact),this._map=void 0,this._attribHTML=void 0;}_setElementTitle(e,t){const i=this._map._getUIString(`AttributionControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}_toggleAttribution(){this._container.classList.contains("mapboxgl-compact-show")?(this._container.classList.remove("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","false")):(this._container.classList.add("mapboxgl-compact-show"),this._compactButton.setAttribute("aria-pressed","true"));}_updateEditLink(){let t=this._editLink;t||(t=this._editLink=this._container.querySelector(".mapbox-improve-map"));const i=[{key:"owner",value:this.styleOwner},{key:"id",value:this.styleId},{key:"access_token",value:this._map._requestManager._customAccessToken||e.config.ACCESS_TOKEN}];if(t){const o=i.reduce((e,t,o)=>(t.value&&(e+=`${t.key}=${t.value}${o<i.length-1?"&":""}`),e),"?");t.href=`${e.config.FEEDBACK_URL}/${o}${this._map._hash?this._map._hash.getHashString(!0):""}`,t.rel="noopener nofollow",this._setElementTitle(t,"MapFeedback");}}_updateData(e){!e||"metadata"!==e.sourceDataType&&"visibility"!==e.sourceDataType&&"style"!==e.dataType||(this._updateAttributions(),this._updateEditLink());}_updateAttributions(){if(!this._map.style)return;let e=[];if(this.options.customAttribution&&(Array.isArray(this.options.customAttribution)?e=e.concat(this.options.customAttribution.map(e=>"string"!=typeof e?"":e)):"string"==typeof this.options.customAttribution&&e.push(this.options.customAttribution)),this._map.style.stylesheet){const e=this._map.style.stylesheet;this.styleOwner=e.owner,this.styleId=e.id;}const t=this._map.style._sourceCaches;for(const i in t){const o=t[i];if(o.used){const t=o.getSource();t.attribution&&e.indexOf(t.attribution)<0&&e.push(t.attribution);}}e.sort((e,t)=>e.length-t.length),e=e.filter((t,i)=>{for(let o=i+1;o<e.length;o++)if(e[o].indexOf(t)>=0)return !1;return !0});const i=e.join(" | ");i!==this._attribHTML&&(this._attribHTML=i,e.length?(this._innerContainer.innerHTML=i,this._container.classList.remove("mapboxgl-attrib-empty")):this._container.classList.add("mapboxgl-attrib-empty"),this._editLink=null);}_updateCompact(){this._map.getCanvasContainer().offsetWidth<=640?this._container.classList.add("mapboxgl-compact"):this._container.classList.remove("mapboxgl-compact","mapboxgl-compact-show");}}class Xo{constructor(){e.bindAll(["_updateLogo"],this),e.bindAll(["_updateCompact"],this);}onAdd(e){this._map=e,this._container=a.create("div","mapboxgl-ctrl");const t=a.create("a","mapboxgl-ctrl-logo");return t.target="_blank",t.rel="noopener nofollow",t.href="https://www.mapbox.com/",t.setAttribute("aria-label",this._map._getUIString("LogoControl.Title")),t.setAttribute("rel","noopener nofollow"),this._container.appendChild(t),this._container.style.display="none",this._map.on("sourcedata",this._updateLogo),this._updateLogo(),this._map.on("resize",this._updateCompact),this._updateCompact(),this._container}onRemove(){a.remove(this._container),this._map.off("sourcedata",this._updateLogo),this._map.off("resize",this._updateCompact);}getDefaultPosition(){return "bottom-left"}_updateLogo(e){e&&"metadata"!==e.sourceDataType||(this._container.style.display=this._logoRequired()?"block":"none");}_logoRequired(){if(!this._map.style)return;const e=this._map.style._sourceCaches;if(0===Object.entries(e).length)return !0;for(const t in e){const i=e[t].getSource();if(i.hasOwnProperty("mapbox_logo")&&!i.mapbox_logo)return !1}return !0}_updateCompact(){const e=this._container.children;if(e.length){const t=e[0];this._map.getCanvasContainer().offsetWidth<250?t.classList.add("mapboxgl-compact"):t.classList.remove("mapboxgl-compact");}}}class Wo{constructor(){this._queue=[],this._id=0,this._cleared=!1,this._currentlyRunning=!1;}add(e){const t=++this._id;return this._queue.push({callback:e,id:t,cancelled:!1}),t}remove(e){const t=this._currentlyRunning,i=t?this._queue.concat(t):this._queue;for(const t of i)if(t.id===e)return void(t.cancelled=!0)}run(e=0){const t=this._currentlyRunning=this._queue;this._queue=[];for(const i of t)if(!i.cancelled&&(i.callback(e),this._cleared))break;this._cleared=!1,this._currentlyRunning=!1;}clear(){this._currentlyRunning&&(this._cleared=!0),this._queue=[];}}const Ho={"AttributionControl.ToggleAttribution":"Toggle attribution","AttributionControl.MapFeedback":"Map feedback","FullscreenControl.Enter":"Enter fullscreen","FullscreenControl.Exit":"Exit fullscreen","GeolocateControl.FindMyLocation":"Find my location","GeolocateControl.LocationNotAvailable":"Location not available","LogoControl.Title":"Mapbox logo","NavigationControl.ResetBearing":"Reset bearing to north","NavigationControl.ZoomIn":"Zoom in","NavigationControl.ZoomOut":"Zoom out","ScaleControl.Feet":"ft","ScaleControl.Meters":"m","ScaleControl.Kilometers":"km","ScaleControl.Miles":"mi","ScaleControl.NauticalMiles":"nm"},{HTMLImageElement:Ko,HTMLElement:Yo,ImageBitmap:Jo}=e.window,Qo={center:[0,0],zoom:0,bearing:0,pitch:0,minZoom:-2,maxZoom:22,minPitch:0,maxPitch:85,interactive:!0,scrollZoom:!0,boxZoom:!0,dragRotate:!0,dragPan:!0,keyboard:!0,doubleClickZoom:!0,touchZoomRotate:!0,touchPitch:!0,bearingSnap:7,clickTolerance:3,pitchWithRotate:!0,hash:!1,attributionControl:!0,failIfMajorPerformanceCaveat:!1,preserveDrawingBuffer:!1,trackResize:!0,optimizeForTerrain:!0,renderWorldCopies:!0,refreshExpiredTiles:!0,maxTileCacheSize:null,localIdeographFontFamily:"sans-serif",localFontFamily:null,transformRequest:null,accessToken:null,fadeDuration:300,crossSourceCollisions:!0};function ea(e){e.parentNode&&e.parentNode.removeChild(e);}const ta={showCompass:!0,showZoom:!0,visualizePitch:!1};class ia{constructor(t,i,o=!1){this._clickTolerance=10,this.element=i,this.mouseRotate=new xo({clickTolerance:t.dragRotate._mouseRotate._clickTolerance}),this.map=t,o&&(this.mousePitch=new yo({clickTolerance:t.dragRotate._mousePitch._clickTolerance})),e.bindAll(["mousedown","mousemove","mouseup","touchstart","touchmove","touchend","reset"],this),a.addEventListener(i,"mousedown",this.mousedown),a.addEventListener(i,"touchstart",this.touchstart,{passive:!1}),a.addEventListener(i,"touchmove",this.touchmove),a.addEventListener(i,"touchend",this.touchend),a.addEventListener(i,"touchcancel",this.reset);}down(e,t){this.mouseRotate.mousedown(e,t),this.mousePitch&&this.mousePitch.mousedown(e,t),a.disableDrag();}move(e,t){const i=this.map,o=this.mouseRotate.mousemoveWindow(e,t);if(o&&o.bearingDelta&&i.setBearing(i.getBearing()+o.bearingDelta),this.mousePitch){const o=this.mousePitch.mousemoveWindow(e,t);o&&o.pitchDelta&&i.setPitch(i.getPitch()+o.pitchDelta);}}off(){const e=this.element;a.removeEventListener(e,"mousedown",this.mousedown),a.removeEventListener(e,"touchstart",this.touchstart,{passive:!1}),a.removeEventListener(e,"touchmove",this.touchmove),a.removeEventListener(e,"touchend",this.touchend),a.removeEventListener(e,"touchcancel",this.reset),this.offTemp();}offTemp(){a.enableDrag(),a.removeEventListener(e.window,"mousemove",this.mousemove),a.removeEventListener(e.window,"mouseup",this.mouseup);}mousedown(t){this.down(e.extend({},t,{ctrlKey:!0,preventDefault:()=>t.preventDefault()}),a.mousePos(this.element,t)),a.addEventListener(e.window,"mousemove",this.mousemove),a.addEventListener(e.window,"mouseup",this.mouseup);}mousemove(e){this.move(e,a.mousePos(this.element,e));}mouseup(e){this.mouseRotate.mouseupWindow(e),this.mousePitch&&this.mousePitch.mouseupWindow(e),this.offTemp();}touchstart(e){1!==e.targetTouches.length?this.reset():(this._startPos=this._lastPos=a.touchPos(this.element,e.targetTouches)[0],this.down({type:"mousedown",button:0,ctrlKey:!0,preventDefault:()=>e.preventDefault()},this._startPos));}touchmove(e){1!==e.targetTouches.length?this.reset():(this._lastPos=a.touchPos(this.element,e.targetTouches)[0],this.move({preventDefault:()=>e.preventDefault()},this._lastPos));}touchend(e){0===e.targetTouches.length&&this._startPos&&this._lastPos&&this._startPos.dist(this._lastPos)<this._clickTolerance&&this.element.click(),this.reset();}reset(){this.mouseRotate.reset(),this.mousePitch&&this.mousePitch.reset(),delete this._startPos,delete this._lastPos,this.offTemp();}}function oa(t,i,o){if(t=new e.LngLat(t.lng,t.lat),i){const a=new e.LngLat(t.lng-360,t.lat),r=new e.LngLat(t.lng+360,t.lat),n=360*Math.ceil(Math.abs(t.lng-o.center.lng)/360),s=o.locationPoint(t).distSqr(i),l=i.x<0||i.y<0||i.x>o.width||i.y>o.height;o.locationPoint(a).distSqr(i)<s&&(l||Math.abs(a.lng-o.center.lng)<n)?t=a:o.locationPoint(r).distSqr(i)<s&&(l||Math.abs(r.lng-o.center.lng)<n)&&(t=r);}for(;Math.abs(t.lng-o.center.lng)>180;){const e=o.locationPoint(t);if(e.x>=0&&e.y>=0&&e.x<=o.width&&e.y<=o.height)break;t.lng>o.center.lng?t.lng-=360:t.lng+=360;}return t}const aa={center:"translate(-50%,-50%)",top:"translate(-50%,0)","top-left":"translate(0,0)","top-right":"translate(-100%,0)",bottom:"translate(-50%,-100%)","bottom-left":"translate(0,-100%)","bottom-right":"translate(-100%,-100%)",left:"translate(0,-50%)",right:"translate(-100%,-50%)"};function ra(e,t,i){const o=e.classList;for(const e in aa)o.remove(`mapboxgl-${i}-anchor-${e}`);o.add(`mapboxgl-${i}-anchor-${t}`);}class na extends e.Evented{constructor(t,i){if(super(),(t instanceof e.window.HTMLElement||i)&&(t=e.extend({element:t},i)),e.bindAll(["_update","_onMove","_onUp","_addDragHandler","_onMapClick","_onKeyPress"],this),this._anchor=t&&t.anchor||"center",this._color=t&&t.color||"#3FB1CE",this._scale=t&&t.scale||1,this._draggable=t&&t.draggable||!1,this._clickTolerance=t&&t.clickTolerance||0,this._isDragging=!1,this._state="inactive",this._rotation=t&&t.rotation||0,this._rotationAlignment=t&&t.rotationAlignment||"auto",this._pitchAlignment=t&&t.pitchAlignment&&"auto"!==t.pitchAlignment?t.pitchAlignment:this._rotationAlignment,t&&t.element)this._element=t.element,this._offset=e.Point.convert(t&&t.offset||[0,0]);else {this._defaultMarker=!0,this._element=a.create("div"),this._element.setAttribute("aria-label","Map marker");const i=a.createNS("http://www.w3.org/2000/svg","svg"),o=41,r=27;i.setAttributeNS(null,"display","block"),i.setAttributeNS(null,"height",`${o}px`),i.setAttributeNS(null,"width",`${r}px`),i.setAttributeNS(null,"viewBox",`0 0 ${r} ${o}`);const n=a.createNS("http://www.w3.org/2000/svg","g");n.setAttributeNS(null,"stroke","none"),n.setAttributeNS(null,"stroke-width","1"),n.setAttributeNS(null,"fill","none"),n.setAttributeNS(null,"fill-rule","evenodd");const s=a.createNS("http://www.w3.org/2000/svg","g");s.setAttributeNS(null,"fill-rule","nonzero");const l=a.createNS("http://www.w3.org/2000/svg","g");l.setAttributeNS(null,"transform","translate(3.0, 29.0)"),l.setAttributeNS(null,"fill","#000000");const c=[{rx:"10.5",ry:"5.25002273"},{rx:"10.5",ry:"5.25002273"},{rx:"9.5",ry:"4.77275007"},{rx:"8.5",ry:"4.29549936"},{rx:"7.5",ry:"3.81822308"},{rx:"6.5",ry:"3.34094679"},{rx:"5.5",ry:"2.86367051"},{rx:"4.5",ry:"2.38636864"}];for(const e of c){const t=a.createNS("http://www.w3.org/2000/svg","ellipse");t.setAttributeNS(null,"opacity","0.04"),t.setAttributeNS(null,"cx","10.5"),t.setAttributeNS(null,"cy","5.80029008"),t.setAttributeNS(null,"rx",e.rx),t.setAttributeNS(null,"ry",e.ry),l.appendChild(t);}const h=a.createNS("http://www.w3.org/2000/svg","g");h.setAttributeNS(null,"fill",this._color);const u=a.createNS("http://www.w3.org/2000/svg","path");u.setAttributeNS(null,"d","M27,13.5 C27,19.074644 20.250001,27.000002 14.75,34.500002 C14.016665,35.500004 12.983335,35.500004 12.25,34.500002 C6.7499993,27.000002 0,19.222562 0,13.5 C0,6.0441559 6.0441559,0 13.5,0 C20.955844,0 27,6.0441559 27,13.5 Z"),h.appendChild(u);const d=a.createNS("http://www.w3.org/2000/svg","g");d.setAttributeNS(null,"opacity","0.25"),d.setAttributeNS(null,"fill","#000000");const _=a.createNS("http://www.w3.org/2000/svg","path");_.setAttributeNS(null,"d","M13.5,0 C6.0441559,0 0,6.0441559 0,13.5 C0,19.222562 6.7499993,27 12.25,34.5 C13,35.522727 14.016664,35.500004 14.75,34.5 C20.250001,27 27,19.074644 27,13.5 C27,6.0441559 20.955844,0 13.5,0 Z M13.5,1 C20.415404,1 26,6.584596 26,13.5 C26,15.898657 24.495584,19.181431 22.220703,22.738281 C19.945823,26.295132 16.705119,30.142167 13.943359,33.908203 C13.743445,34.180814 13.612715,34.322738 13.5,34.441406 C13.387285,34.322738 13.256555,34.180814 13.056641,33.908203 C10.284481,30.127985 7.4148684,26.314159 5.015625,22.773438 C2.6163816,19.232715 1,15.953538 1,13.5 C1,6.584596 6.584596,1 13.5,1 Z"),d.appendChild(_);const m=a.createNS("http://www.w3.org/2000/svg","g");m.setAttributeNS(null,"transform","translate(6.0, 7.0)"),m.setAttributeNS(null,"fill","#FFFFFF");const p=a.createNS("http://www.w3.org/2000/svg","g");p.setAttributeNS(null,"transform","translate(8.0, 8.0)");const f=a.createNS("http://www.w3.org/2000/svg","circle");f.setAttributeNS(null,"fill","#000000"),f.setAttributeNS(null,"opacity","0.25"),f.setAttributeNS(null,"cx","5.5"),f.setAttributeNS(null,"cy","5.5"),f.setAttributeNS(null,"r","5.4999962");const g=a.createNS("http://www.w3.org/2000/svg","circle");g.setAttributeNS(null,"fill","#FFFFFF"),g.setAttributeNS(null,"cx","5.5"),g.setAttributeNS(null,"cy","5.5"),g.setAttributeNS(null,"r","5.4999962"),p.appendChild(f),p.appendChild(g),s.appendChild(l),s.appendChild(h),s.appendChild(d),s.appendChild(m),s.appendChild(p),i.appendChild(s),i.setAttributeNS(null,"height",`${o*this._scale}px`),i.setAttributeNS(null,"width",`${r*this._scale}px`),this._element.appendChild(i),this._offset=e.Point.convert(t&&t.offset||[0,-14]);}this._element.classList.add("mapboxgl-marker"),this._element.addEventListener("dragstart",e=>{e.preventDefault();}),this._element.addEventListener("mousedown",e=>{e.preventDefault();}),ra(this._element,this._anchor,"marker"),this._popup=null;}addTo(e){return this.remove(),this._map=e,e.getCanvasContainer().appendChild(this._element),e.on("move",this._update),e.on("moveend",this._update),this.setDraggable(this._draggable),this._update(),this._map.on("click",this._onMapClick),this}remove(){return this._map&&(this._map.off("click",this._onMapClick),this._map.off("move",this._update),this._map.off("moveend",this._update),this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler),this._map.off("mouseup",this._onUp),this._map.off("touchend",this._onUp),this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),delete this._map),a.remove(this._element),this._popup&&this._popup.remove(),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.LngLat.convert(t),this._pos=null,this._popup&&this._popup.setLngLat(this._lngLat),this._update(),this}getElement(){return this._element}setPopup(e){if(this._popup&&(this._popup.remove(),this._popup=null,this._element.removeEventListener("keypress",this._onKeyPress),this._originalTabIndex||this._element.removeAttribute("tabindex")),e){if(!("offset"in e.options)){const t=38.1,i=13.5,o=Math.sqrt(Math.pow(i,2)/2);e.options.offset=this._defaultMarker?{top:[0,0],"top-left":[0,0],"top-right":[0,0],bottom:[0,-t],"bottom-left":[o,-1*(t-i+o)],"bottom-right":[-o,-1*(t-i+o)],left:[i,-1*(t-i)],right:[-i,-1*(t-i)]}:this._offset;}this._popup=e,this._lngLat&&this._popup.setLngLat(this._lngLat),this._originalTabIndex=this._element.getAttribute("tabindex"),this._originalTabIndex||this._element.setAttribute("tabindex","0"),this._element.addEventListener("keypress",this._onKeyPress);}return this}_onKeyPress(e){const t=e.code,i=e.charCode||e.keyCode;"Space"!==t&&"Enter"!==t&&32!==i&&13!==i||this.togglePopup();}_onMapClick(e){const t=e.originalEvent.target,i=this._element;this._popup&&(t===i||i.contains(t))&&this.togglePopup();}getPopup(){return this._popup}togglePopup(){const e=this._popup;return e?(e.isOpen()?e.remove():e.addTo(this._map),this):this}_updateOcclusion(){this._occlusionTimer||(this._occlusionTimer=setTimeout(this._onOcclusionTimer.bind(this),60));}_onOcclusionTimer(){const e=this._map.transform,t=this._pos?this._pos.sub(this._transformedOffset()):null;if(t&&t.x>=0&&t.x<e.width&&t.y>=0&&t.y<e.height){const e=this._map.unproject(t),i=this._map.getFreeCameraOptions();if(i.position){const t=i.position.toLngLat(),o=t.distanceTo(e),a=t.distanceTo(this._lngLat);this._element.classList.toggle("mapboxgl-marker-occluded",o<.9*a);}}this._occlusionTimer=null;}_update(e){if(!this._map)return;this._map.transform.renderWorldCopies&&(this._lngLat=oa(this._lngLat,this._pos,this._map.transform)),this._pos=this._map.project(this._lngLat)._add(this._transformedOffset()),this._map.transform.elevation&&this._updateOcclusion();let t="";"viewport"===this._rotationAlignment||"auto"===this._rotationAlignment?t=`rotateZ(${this._rotation}deg)`:"map"===this._rotationAlignment&&(t=`rotateZ(${this._rotation-this._map.getBearing()}deg)`);let i="";"viewport"===this._pitchAlignment||"auto"===this._pitchAlignment?i="rotateX(0deg)":"map"===this._pitchAlignment&&(i=`rotateX(${this._map.getPitch()}deg)`),e&&"moveend"!==e.type||(this._pos=this._pos.round()),a.setTransform(this._element,`${aa[this._anchor]} translate(${this._pos.x}px, ${this._pos.y}px) ${i} ${t}`);}_transformedOffset(){if(!this._defaultMarker)return this._offset;const e=this._map.transform,t=this._offset.mult(this._scale);return "map"===this._rotationAlignment&&t._rotate(e.angle),"map"===this._pitchAlignment&&(t.y*=Math.cos(e._pitch)),t}getOffset(){return this._offset}setOffset(t){return this._offset=e.Point.convert(t),this._update(),this}_onMove(t){if(!this._isDragging){const e=this._clickTolerance||this._map._clickTolerance;this._isDragging=t.point.dist(this._pointerdownPos)>=e;}this._isDragging&&(this._pos=t.point.sub(this._positionDelta),this._lngLat=this._map.unproject(this._pos),this.setLngLat(this._lngLat),this._element.style.pointerEvents="none","pending"===this._state&&(this._state="active",this.fire(new e.Event("dragstart"))),this.fire(new e.Event("drag")));}_onUp(){this._element.style.pointerEvents="auto",this._positionDelta=null,this._pointerdownPos=null,this._isDragging=!1,this._map.off("mousemove",this._onMove),this._map.off("touchmove",this._onMove),"active"===this._state&&this.fire(new e.Event("dragend")),this._state="inactive";}_addDragHandler(e){this._element.contains(e.originalEvent.target)&&(e.preventDefault(),this._positionDelta=e.point.sub(this._pos).add(this._transformedOffset()),this._pointerdownPos=e.point,this._state="pending",this._map.on("mousemove",this._onMove),this._map.on("touchmove",this._onMove),this._map.once("mouseup",this._onUp),this._map.once("touchend",this._onUp));}setDraggable(e){return this._draggable=!!e,this._map&&(e?(this._map.on("mousedown",this._addDragHandler),this._map.on("touchstart",this._addDragHandler)):(this._map.off("mousedown",this._addDragHandler),this._map.off("touchstart",this._addDragHandler))),this}isDraggable(){return this._draggable}setRotation(e){return this._rotation=e||0,this._update(),this}getRotation(){return this._rotation}setRotationAlignment(e){return this._rotationAlignment=e||"auto",this._update(),this}getRotationAlignment(){return this._rotationAlignment}setPitchAlignment(e){return this._pitchAlignment=e&&"auto"!==e?e:this._rotationAlignment,this._update(),this}getPitchAlignment(){return this._pitchAlignment}}const sa={positionOptions:{enableHighAccuracy:!1,maximumAge:0,timeout:6e3},fitBoundsOptions:{maxZoom:15},trackUserLocation:!1,showAccuracyCircle:!0,showUserLocation:!0};let la,ca=0,ha=!1;const ua={maxWidth:100,unit:"metric"};function da(e,t,i){const o=i&&i.maxWidth||100,a=e._container.clientHeight/2,r=e.unproject([0,a]),n=e.unproject([o,a]),s=r.distanceTo(n);if(i&&"imperial"===i.unit){const i=3.2808*s;i>5280?_a(t,o,i/5280,e._getUIString("ScaleControl.Miles")):_a(t,o,i,e._getUIString("ScaleControl.Feet"));}else i&&"nautical"===i.unit?_a(t,o,s/1852,e._getUIString("ScaleControl.NauticalMiles")):s>=1e3?_a(t,o,s/1e3,e._getUIString("ScaleControl.Kilometers")):_a(t,o,s,e._getUIString("ScaleControl.Meters"));}function _a(e,t,i,o){const a=function(e){const t=Math.pow(10,`${Math.floor(e)}`.length-1);let i=e/t;return i=i>=10?10:i>=5?5:i>=3?3:i>=2?2:i>=1?1:function(e){const t=Math.pow(10,Math.ceil(-Math.log(e)/Math.LN10));return Math.round(e*t)/t}(i),t*i}(i);e.style.width=`${t*(a/i)}px`,e.innerHTML=`${a}&nbsp;${o}`;}const ma={closeButton:!0,closeOnClick:!0,focusAfterOpen:!0,className:"",maxWidth:"240px"},pa=["a[href]","[tabindex]:not([tabindex='-1'])","[contenteditable]:not([contenteditable='false'])","button:not([disabled])","input:not([disabled])","select:not([disabled])","textarea:not([disabled])"].join(", "),fa={version:e.version,supported:t,setRTLTextPlugin:e.setRTLTextPlugin,getRTLTextPluginStatus:e.getRTLTextPluginStatus,Map:class extends jo{constructor(t){if(null!=(t=e.extend({},Qo,t)).minZoom&&null!=t.maxZoom&&t.minZoom>t.maxZoom)throw new Error("maxZoom must be greater than or equal to minZoom");if(null!=t.minPitch&&null!=t.maxPitch&&t.minPitch>t.maxPitch)throw new Error("maxPitch must be greater than or equal to minPitch");if(null!=t.minPitch&&t.minPitch<0)throw new Error("minPitch must be greater than or equal to 0");if(null!=t.maxPitch&&t.maxPitch>85)throw new Error("maxPitch must be less than or equal to 85");if(super(new Hi(t.minZoom,t.maxZoom,t.minPitch,t.maxPitch,t.renderWorldCopies),t),this._interactive=t.interactive,this._maxTileCacheSize=t.maxTileCacheSize,this._failIfMajorPerformanceCaveat=t.failIfMajorPerformanceCaveat,this._preserveDrawingBuffer=t.preserveDrawingBuffer,this._antialias=t.antialias,this._trackResize=t.trackResize,this._bearingSnap=t.bearingSnap,this._refreshExpiredTiles=t.refreshExpiredTiles,this._fadeDuration=t.fadeDuration,this._isInitialLoad=!0,this._crossSourceCollisions=t.crossSourceCollisions,this._crossFadingFactor=1,this._collectResourceTiming=t.collectResourceTiming,this._optimizeForTerrain=t.optimizeForTerrain,this._renderTaskQueue=new Wo,this._controls=[],this._mapId=e.uniqueId(),this._locale=e.extend({},Ho,t.locale),this._clickTolerance=t.clickTolerance,this._requestManager=new e.RequestManager(t.transformRequest,t.accessToken),"string"==typeof t.container){if(this._container=e.window.document.getElementById(t.container),!this._container)throw new Error(`Container '${t.container}' not found.`)}else {if(!(t.container instanceof Yo))throw new Error("Invalid type: 'container' must be a String or HTMLElement.");this._container=t.container;}if(t.maxBounds&&this.setMaxBounds(t.maxBounds),e.bindAll(["_onWindowOnline","_onWindowResize","_onMapScroll","_contextLost","_contextRestored"],this),this._setupContainer(),this._setupPainter(),void 0===this.painter)throw new Error("Failed to initialize WebGL.");this.on("move",()=>this._update(!1)),this.on("moveend",()=>this._update(!1)),this.on("zoom",()=>this._update(!0)),void 0!==e.window&&(e.window.addEventListener("online",this._onWindowOnline,!1),e.window.addEventListener("resize",this._onWindowResize,!1),e.window.addEventListener("orientationchange",this._onWindowResize,!1)),this.handlers=new qo(this,t),this._hash=t.hash&&new Ki("string"==typeof t.hash&&t.hash||void 0).addTo(this),this._hash&&this._hash._onHashChange()||(this.jumpTo({center:t.center,zoom:t.zoom,bearing:t.bearing,pitch:t.pitch}),t.bounds&&(this.resize(),this.fitBounds(t.bounds,e.extend({},t.fitBoundsOptions,{duration:0})))),this.resize(),this._localFontFamily=t.localFontFamily,this._localIdeographFontFamily=t.localIdeographFontFamily,t.style&&this.setStyle(t.style,{localFontFamily:this._localFontFamily,localIdeographFontFamily:this._localIdeographFontFamily}),t.attributionControl&&this.addControl(new $o({customAttribution:t.customAttribution})),this._logoControl=new Xo,this.addControl(this._logoControl,t.logoPosition),this.on("style.load",()=>{this.transform.unmodified&&this.jumpTo(this.style.stylesheet);}),this.on("data",t=>{this._update("style"===t.dataType),this.fire(new e.Event(`${t.dataType}data`,t));}),this.on("dataloading",t=>{this.fire(new e.Event(`${t.dataType}dataloading`,t));});}_getMapId(){return this._mapId}addControl(t,i){if(void 0===i&&(i=t.getDefaultPosition?t.getDefaultPosition():"top-right"),!t||!t.onAdd)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.addControl(). Argument must be a control with onAdd and onRemove methods.")));const o=t.onAdd(this);this._controls.push(t);const a=this._controlPositions[i];return -1!==i.indexOf("bottom")?a.insertBefore(o,a.firstChild):a.appendChild(o),this}removeControl(t){if(!t||!t.onRemove)return this.fire(new e.ErrorEvent(new Error("Invalid argument to map.removeControl(). Argument must be a control with onAdd and onRemove methods.")));const i=this._controls.indexOf(t);return i>-1&&this._controls.splice(i,1),t.onRemove(this),this}hasControl(e){return this._controls.indexOf(e)>-1}resize(t){const i=this._containerDimensions(),o=i[0],a=i[1];this._resizeCanvas(o,a),this.transform.resize(o,a),this.painter.resize(o,a);const r=!this._moving;return r&&(this.stop(),this.fire(new e.Event("movestart",t)).fire(new e.Event("move",t))),this.fire(new e.Event("resize",t)),r&&this.fire(new e.Event("moveend",t)),this}getBounds(){return this.transform.getBounds()}getMaxBounds(){return this.transform.getMaxBounds()}setMaxBounds(t){return this.transform.setMaxBounds(e.LngLatBounds.convert(t)),this._update()}setMinZoom(e){if((e=null==e?-2:e)>=-2&&e<=this.transform.maxZoom)return this.transform.minZoom=e,this._update(),this.getZoom()<e&&this.setZoom(e),this;throw new Error("minZoom must be between -2 and the current maxZoom, inclusive")}getMinZoom(){return this.transform.minZoom}setMaxZoom(e){if((e=null==e?22:e)>=this.transform.minZoom)return this.transform.maxZoom=e,this._update(),this.getZoom()>e&&this.setZoom(e),this;throw new Error("maxZoom must be greater than the current minZoom")}getMaxZoom(){return this.transform.maxZoom}setMinPitch(e){if((e=null==e?0:e)<0)throw new Error("minPitch must be greater than or equal to 0");if(e>=0&&e<=this.transform.maxPitch)return this.transform.minPitch=e,this._update(),this.getPitch()<e&&this.setPitch(e),this;throw new Error("minPitch must be between 0 and the current maxPitch, inclusive")}getMinPitch(){return this.transform.minPitch}setMaxPitch(e){if((e=null==e?85:e)>85)throw new Error("maxPitch must be less than or equal to 85");if(e>=this.transform.minPitch)return this.transform.maxPitch=e,this._update(),this.getPitch()>e&&this.setPitch(e),this;throw new Error("maxPitch must be greater than the current minPitch")}getMaxPitch(){return this.transform.maxPitch}getRenderWorldCopies(){return this.transform.renderWorldCopies}setRenderWorldCopies(e){return this.transform.renderWorldCopies=e,this._update()}project(t){return this.transform.locationPoint3D(e.LngLat.convert(t))}unproject(t){return this.transform.pointLocation3D(e.Point.convert(t))}isMoving(){return this._moving||this.handlers&&this.handlers.isMoving()}isZooming(){return this._zooming||this.handlers&&this.handlers.isZooming()}isRotating(){return this._rotating||this.handlers&&this.handlers.isRotating()}_createDelegatedListener(e,t,i){if("mouseenter"===e||"mouseover"===e){let o=!1;const a=a=>{const r=this.getLayer(t)?this.queryRenderedFeatures(a.point,{layers:[t]}):[];r.length?o||(o=!0,i.call(this,new ro(e,this,a.originalEvent,{features:r}))):o=!1;};return {layer:t,listener:i,delegates:{mousemove:a,mouseout:()=>{o=!1;}}}}if("mouseleave"===e||"mouseout"===e){let o=!1;const a=a=>{(this.getLayer(t)?this.queryRenderedFeatures(a.point,{layers:[t]}):[]).length?o=!0:o&&(o=!1,i.call(this,new ro(e,this,a.originalEvent)));},r=t=>{o&&(o=!1,i.call(this,new ro(e,this,t.originalEvent)));};return {layer:t,listener:i,delegates:{mousemove:a,mouseout:r}}}{const o=e=>{const o=this.getLayer(t)?this.queryRenderedFeatures(e.point,{layers:[t]}):[];o.length&&(e.features=o,i.call(this,e),delete e.features);};return {layer:t,listener:i,delegates:{[e]:o}}}}on(e,t,i){if(void 0===i)return super.on(e,t);const o=this._createDelegatedListener(e,t,i);this._delegatedListeners=this._delegatedListeners||{},this._delegatedListeners[e]=this._delegatedListeners[e]||[],this._delegatedListeners[e].push(o);for(const e in o.delegates)this.on(e,o.delegates[e]);return this}once(e,t,i){if(void 0===i)return super.once(e,t);const o=this._createDelegatedListener(e,t,i);for(const e in o.delegates)this.once(e,o.delegates[e]);return this}off(e,t,i){return void 0===i?super.off(e,t):(this._delegatedListeners&&this._delegatedListeners[e]&&(o=>{const a=this._delegatedListeners[e];for(let e=0;e<a.length;e++){const o=a[e];if(o.layer===t&&o.listener===i){for(const e in o.delegates)this.off(e,o.delegates[e]);return a.splice(e,1),this}}})(),this)}queryRenderedFeatures(t,i){return this.style?(void 0!==i||void 0===t||t instanceof e.Point||Array.isArray(t)||(i=t,t=void 0),this.style.queryRenderedFeatures(t=t||[[0,0],[this.transform.width,this.transform.height]],i=i||{},this.transform)):[]}querySourceFeatures(e,t){return this.style.querySourceFeatures(e,t)}setStyle(t,i){return !1!==(i=e.extend({},{localIdeographFontFamily:this._localIdeographFontFamily,localFontFamily:this._localFontFamily},i)).diff&&i.localIdeographFontFamily===this._localIdeographFontFamily&&i.localFontFamily===this._localFontFamily&&this.style&&t?(this._diffStyle(t,i),this):(this._localIdeographFontFamily=i.localIdeographFontFamily,this._localFontFamily=i.localFontFamily,this._updateStyle(t,i))}_getUIString(e){const t=this._locale[e];if(null==t)throw new Error(`Missing UI string '${e}'`);return t}_updateStyle(e,t){return this.style&&(this.style.setEventedParent(null),this.style._remove(),delete this.style),e&&(this.style=new Ze(this,t||{}),this.style.setEventedParent(this,{style:this.style}),"string"==typeof e?this.style.loadURL(e):this.style.loadJSON(e)),this._updateTerrain(),this}_lazyInitEmptyStyle(){this.style||(this.style=new Ze(this,{}),this.style.setEventedParent(this,{style:this.style}),this.style.loadEmpty());}_diffStyle(t,i){if("string"==typeof t){const o=this._requestManager.normalizeStyleURL(t),a=this._requestManager.transformRequest(o,e.ResourceType.Style);e.getJSON(a,(t,o)=>{t?this.fire(new e.ErrorEvent(t)):o&&this._updateDiff(o,i);});}else "object"==typeof t&&this._updateDiff(t,i);}_updateDiff(t,i){try{this.style.setState(t)&&this._update(!0);}catch(o){e.warnOnce(`Unable to perform style diff: ${o.message||o.error||o}.  Rebuilding the style from scratch.`),this._updateStyle(t,i);}}getStyle(){if(this.style)return this.style.serialize()}isStyleLoaded(){return this.style?this.style.loaded():e.warnOnce("There is no style added to the map.")}addSource(e,t){return this._lazyInitEmptyStyle(),this.style.addSource(e,t),this._update(!0)}isSourceLoaded(t){const i=this.style&&this.style._getSourceCaches(t);if(0!==i.length)return i.every(e=>e.loaded());this.fire(new e.ErrorEvent(new Error(`There is no source with ID '${t}'`)));}areTilesLoaded(){const e=this.style&&this.style._sourceCaches;for(const t in e){const i=e[t]._tiles;for(const e in i){const t=i[e];if("loaded"!==t.state&&"errored"!==t.state)return !1}}return !0}addSourceType(e,t,i){return this._lazyInitEmptyStyle(),this.style.addSourceType(e,t,i)}removeSource(e){return this.style.removeSource(e),this._updateTerrain(),this._update(!0)}getSource(e){return this.style.getSource(e)}addImage(t,i,{pixelRatio:o=1,sdf:a=!1,stretchX:r,stretchY:n,content:s}={}){if(this._lazyInitEmptyStyle(),i instanceof Ko||Jo&&i instanceof Jo){const{width:l,height:c,data:h}=e.browser.getImageData(i);this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},h),pixelRatio:o,stretchX:r,stretchY:n,content:s,sdf:a,version:0});}else {if(void 0===i.width||void 0===i.height)return this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.addImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`")));{const{width:l,height:c,data:h}=i,u=i;this.style.addImage(t,{data:new e.RGBAImage({width:l,height:c},new Uint8Array(h)),pixelRatio:o,stretchX:r,stretchY:n,content:s,sdf:a,version:0,userImage:u}),u.onAdd&&u.onAdd(this,t);}}}updateImage(t,i){const o=this.style.getImage(t);if(!o)return this.fire(new e.ErrorEvent(new Error("The map has no image with that id. If you are adding a new image use `map.addImage(...)` instead.")));const a=i instanceof Ko||Jo&&i instanceof Jo?e.browser.getImageData(i):i,{width:r,height:n,data:s}=a;return void 0===r||void 0===n?this.fire(new e.ErrorEvent(new Error("Invalid arguments to map.updateImage(). The second argument must be an `HTMLImageElement`, `ImageData`, `ImageBitmap`, or object with `width`, `height`, and `data` properties with the same format as `ImageData`"))):r!==o.data.width||n!==o.data.height?this.fire(new e.ErrorEvent(new Error("The width and height of the updated image must be that same as the previous version of the image"))):(o.data.replace(s,!(i instanceof Ko||Jo&&i instanceof Jo)),void this.style.updateImage(t,o))}hasImage(t){return t?!!this.style.getImage(t):(this.fire(new e.ErrorEvent(new Error("Missing required image id"))),!1)}removeImage(e){this.style.removeImage(e);}loadImage(t,i){e.getImage(this._requestManager.transformRequest(t,e.ResourceType.Image),i);}listImages(){return this.style.listImages()}addLayer(e,t){return this._lazyInitEmptyStyle(),this.style.addLayer(e,t),this._update(!0)}moveLayer(e,t){return this.style.moveLayer(e,t),this._update(!0)}removeLayer(e){return this.style.removeLayer(e),this._update(!0)}getLayer(e){return this.style.getLayer(e)}setLayerZoomRange(e,t,i){return this.style.setLayerZoomRange(e,t,i),this._update(!0)}setFilter(e,t,i={}){return this.style.setFilter(e,t,i),this._update(!0)}getFilter(e){return this.style.getFilter(e)}setPaintProperty(e,t,i,o={}){return this.style.setPaintProperty(e,t,i,o),this._update(!0)}getPaintProperty(e,t){return this.style.getPaintProperty(e,t)}setLayoutProperty(e,t,i,o={}){return this.style.setLayoutProperty(e,t,i,o),this._update(!0)}getLayoutProperty(e,t){return this.style.getLayoutProperty(e,t)}setLight(e,t={}){return this._lazyInitEmptyStyle(),this.style.setLight(e,t),this._update(!0)}getLight(){return this.style.getLight()}setTerrain(e){return this._lazyInitEmptyStyle(),this.style.setTerrain(e),this._update(!0)}setFeatureState(e,t){return this.style.setFeatureState(e,t),this._update()}removeFeatureState(e,t){return this.style.removeFeatureState(e,t),this._update()}getFeatureState(e){return this.style.getFeatureState(e)}getContainer(){return this._container}getCanvasContainer(){return this._canvasContainer}getCanvas(){return this._canvas}_containerDimensions(){let e=0,t=0;return this._container&&(e=this._container.clientWidth||400,t=this._container.clientHeight||300),[e,t]}_detectMissingCSS(){"rgb(250, 128, 114)"!==e.window.getComputedStyle(this._missingCSSCanary).getPropertyValue("background-color")&&e.warnOnce("This page appears to be missing CSS declarations for Mapbox GL JS, which may cause the map to display incorrectly. Please ensure your page includes mapbox-gl.css, as described in https://www.mapbox.com/mapbox-gl-js/api/.");}_setupContainer(){const e=this._container;e.classList.add("mapboxgl-map"),(this._missingCSSCanary=a.create("div","mapboxgl-canary",e)).style.visibility="hidden",this._detectMissingCSS();const t=this._canvasContainer=a.create("div","mapboxgl-canvas-container",e);this._interactive&&t.classList.add("mapboxgl-interactive"),this._canvas=a.create("canvas","mapboxgl-canvas",t),this._canvas.addEventListener("webglcontextlost",this._contextLost,!1),this._canvas.addEventListener("webglcontextrestored",this._contextRestored,!1),this._canvas.setAttribute("tabindex","0"),this._canvas.setAttribute("aria-label","Map"),this._canvas.setAttribute("role","region");const i=this._containerDimensions();this._resizeCanvas(i[0],i[1]);const o=this._controlContainer=a.create("div","mapboxgl-control-container",e),r=this._controlPositions={};["top-left","top-right","bottom-left","bottom-right"].forEach(e=>{r[e]=a.create("div",`mapboxgl-ctrl-${e}`,o);}),this._container.addEventListener("scroll",this._onMapScroll,!1);}_resizeCanvas(t,i){const o=e.browser.devicePixelRatio||1;this._canvas.width=o*t,this._canvas.height=o*i,this._canvas.style.width=`${t}px`,this._canvas.style.height=`${i}px`;}_setupPainter(){const i=e.extend({},t.webGLContextAttributes,{failIfMajorPerformanceCaveat:this._failIfMajorPerformanceCaveat,preserveDrawingBuffer:this._preserveDrawingBuffer,antialias:this._antialias||!1}),o=this._canvas.getContext("webgl",i)||this._canvas.getContext("experimental-webgl",i);o?(this.painter=new Ui(o,this.transform),this.on("data",e=>{"source"===e.dataType&&this.painter.setTileLoadedFlag(!0);}),e.webpSupported.testSupport(o)):this.fire(new e.ErrorEvent(new Error("Failed to initialize WebGL")));}_contextLost(t){t.preventDefault(),this._frame&&(this._frame.cancel(),this._frame=null),this.fire(new e.Event("webglcontextlost",{originalEvent:t}));}_contextRestored(t){this._setupPainter(),this.resize(),this._update(),this.fire(new e.Event("webglcontextrestored",{originalEvent:t}));}_onMapScroll(e){if(e.target===this._container)return this._container.scrollTop=0,this._container.scrollLeft=0,!1}loaded(){return !this._styleDirty&&!this._sourcesDirty&&!!this.style&&this.style.loaded()}_update(e){return this.style?(this._styleDirty=this._styleDirty||e,this._sourcesDirty=!0,this.triggerRepaint(),this):this}_requestRenderFrame(e){return this._update(),this._renderTaskQueue.add(e)}_cancelRenderFrame(e){this._renderTaskQueue.remove(e);}_render(t){let i,o=0;const a=this.painter.context.extTimerQuery;if(this.listens("gpu-timing-frame")&&(i=a.createQueryEXT(),a.beginQueryEXT(a.TIME_ELAPSED_EXT,i),o=e.browser.now()),this.painter.context.setDirty(),this.painter.setBaseState(),this._renderTaskQueue.run(t),this._removed)return;let r=!1;const n=this._isInitialLoad?0:this._fadeDuration;if(this.style&&this._styleDirty){this._styleDirty=!1;const t=this.transform.zoom,i=e.browser.now();this.style.zoomHistory.update(t,i);const o=new e.EvaluationParameters(t,{now:i,fadeDuration:n,zoomHistory:this.style.zoomHistory,transition:this.style.getTransition()}),a=o.crossFadingFactor();1===a&&a===this._crossFadingFactor||(r=!0,this._crossFadingFactor=a),this.style.update(o);}if(this.style&&this._sourcesDirty&&(this._sourcesDirty=!1,this._updateTerrain(),this.style._updateSources(this.transform)),this._placementDirty=this.style&&this.style._updatePlacement(this.painter.transform,this.showCollisionBoxes,n,this._crossSourceCollisions),this.painter.render(this.style,{showTileBoundaries:this.showTileBoundaries,showOverdrawInspector:this._showOverdrawInspector,showQueryGeometry:!!this._showQueryGeometry,rotating:this.isRotating(),zooming:this.isZooming(),moving:this.isMoving(),fadeDuration:n,isInitialLoad:this._isInitialLoad,showPadding:this.showPadding,gpuTiming:!!this.listens("gpu-timing-layer"),speedIndexTiming:this.speedIndexTiming}),this.fire(new e.Event("render")),this.loaded()&&!this._loaded&&(this._loaded=!0,this.fire(new e.Event("load"))),this.style&&(this.style.hasTransitions()||r)&&(this._styleDirty=!0),this.style&&!this._placementDirty&&this.style._releaseSymbolFadeTiles(),this.listens("gpu-timing-frame")){const t=e.browser.now()-o;a.endQueryEXT(a.TIME_ELAPSED_EXT,i),setTimeout(()=>{const o=a.getQueryObjectEXT(i,a.QUERY_RESULT_EXT)/1e6;a.deleteQueryEXT(i),this.fire(new e.Event("gpu-timing-frame",{cpuTime:t,gpuTime:o}));},50);}if(this.listens("gpu-timing-layer")){const t=this.painter.collectGpuTimers();setTimeout(()=>{const i=this.painter.queryGpuTimers(t);this.fire(new e.Event("gpu-timing-layer",{layerTimes:i}));},50);}const s=this._sourcesDirty||this._styleDirty||this._placementDirty;if(s||this._repaint)this.triggerRepaint();else if(this._triggerFrame(!1),!this.isMoving()&&this.loaded()&&(this.fire(new e.Event("idle")),this._isInitialLoad&&this._authenticate(),this._isInitialLoad=!1,this.speedIndexTiming)){const t=this._calculateSpeedIndex();this.fire(new e.Event("speedindexcompleted",{speedIndex:t})),this.speedIndexTiming=!1;}return !this._loaded||this._fullyLoaded||s||(this._fullyLoaded=!0),this}_authenticate(){e.getMapSessionAPI(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,t=>{if(t&&(t.message===e.AUTH_ERR_MSG||401===t.status)){console.error("Error: A valid Mapbox access token is required to use Mapbox GL JS. To create an account or a new access token, visit https://account.mapbox.com/"),e.browser.setErrorState();const t=this.painter.context.gl;this._logoControl instanceof Xo&&this._logoControl._updateLogo(),t&&t.clear(t.DEPTH_BUFFER_BIT|t.COLOR_BUFFER_BIT|t.STENCIL_BUFFER_BIT);}}),e.postMapLoadEvent(this._getMapId(),this._requestManager._skuToken,this._requestManager._customAccessToken,()=>{});}_updateTerrain(){this.painter.updateTerrain(this.style,this.isMoving()||this.isRotating()||this.isZooming());}_calculateSpeedIndex(){const e=this.painter.canvasCopy(),t=this.painter.getCanvasCopiesAndTimestamps();t.timeStamps.push(performance.now());const i=this.painter.context.gl,o=i.createFramebuffer();function a(e){i.framebufferTexture2D(i.FRAMEBUFFER,i.COLOR_ATTACHMENT0,i.TEXTURE_2D,e,0);const t=new Uint8Array(i.drawingBufferWidth*i.drawingBufferHeight*4);return i.readPixels(0,0,i.drawingBufferWidth,i.drawingBufferHeight,i.RGBA,i.UNSIGNED_BYTE,t),t}return i.bindFramebuffer(i.FRAMEBUFFER,o),this._canvasPixelComparison(a(e),t.canvasCopies.map(a),t.timeStamps)}_canvasPixelComparison(e,t,i){let o=i[1]-i[0];const a=e.length/4;for(let r=0;r<t.length;r++){const n=t[r];let s=0;for(let t=0;t<n.length;t+=4)n[t]===e[t]&&n[t+1]===e[t+1]&&n[t+2]===e[t+2]&&n[t+3]===e[t+3]&&(s+=1);o+=(i[r+2]-i[r+1])*(1-s/a);}return o}remove(){this._hash&&this._hash.remove();for(const e of this._controls)e.onRemove(this);this._controls=[],this._frame&&(this._frame.cancel(),this._frame=null),this._renderTaskQueue.clear(),this.painter.destroy(),this.handlers.destroy(),delete this.handlers,this.setStyle(null),void 0!==e.window&&(e.window.removeEventListener("resize",this._onWindowResize,!1),e.window.removeEventListener("orientationchange",this._onWindowResize,!1),e.window.removeEventListener("online",this._onWindowOnline,!1));const t=this.painter.context.gl.getExtension("WEBGL_lose_context");t&&t.loseContext(),ea(this._canvasContainer),ea(this._controlContainer),ea(this._missingCSSCanary),this._container.classList.remove("mapboxgl-map"),this._removed=!0,this.fire(new e.Event("remove"));}triggerRepaint(){this._triggerFrame(!0);}_triggerFrame(t){this._renderNextFrame=this._renderNextFrame||t,this.style&&!this._frame&&(this._frame=e.browser.frame(e=>{const t=!!this._renderNextFrame;this._frame=null,this._renderNextFrame=null,t&&this._render(e);}));}_onWindowOnline(){this._update();}_onWindowResize(e){this._trackResize&&this.resize({originalEvent:e})._update();}get showTileBoundaries(){return !!this._showTileBoundaries}set showTileBoundaries(e){this._showTileBoundaries!==e&&(this._showTileBoundaries=e,this._update());}get speedIndexTiming(){return !!this._speedIndexTiming}set speedIndexTiming(e){this._speedIndexTiming!==e&&(this._speedIndexTiming=e,this._update());}get showPadding(){return !!this._showPadding}set showPadding(e){this._showPadding!==e&&(this._showPadding=e,this._update());}get showCollisionBoxes(){return !!this._showCollisionBoxes}set showCollisionBoxes(e){this._showCollisionBoxes!==e&&(this._showCollisionBoxes=e,e?this.style._generateCollisionBoxes():this._update());}get showOverdrawInspector(){return !!this._showOverdrawInspector}set showOverdrawInspector(e){this._showOverdrawInspector!==e&&(this._showOverdrawInspector=e,this._update());}get repaint(){return !!this._repaint}set repaint(e){this._repaint!==e&&(this._repaint=e,this.triggerRepaint());}get vertices(){return !!this._vertices}set vertices(e){this._vertices=e,this._update();}_setCacheLimits(t,i){e.setCacheLimits(t,i);}get version(){return e.version}},NavigationControl:class{constructor(t){this.options=e.extend({},ta,t),this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._container.addEventListener("contextmenu",e=>e.preventDefault()),this.options.showZoom&&(e.bindAll(["_setButtonTitle","_updateZoomButtons"],this),this._zoomInButton=this._createButton("mapboxgl-ctrl-zoom-in",e=>this._map.zoomIn({},{originalEvent:e})),a.create("span","mapboxgl-ctrl-icon",this._zoomInButton).setAttribute("aria-hidden",!0),this._zoomOutButton=this._createButton("mapboxgl-ctrl-zoom-out",e=>this._map.zoomOut({},{originalEvent:e})),a.create("span","mapboxgl-ctrl-icon",this._zoomOutButton).setAttribute("aria-hidden",!0)),this.options.showCompass&&(e.bindAll(["_rotateCompassArrow"],this),this._compass=this._createButton("mapboxgl-ctrl-compass",e=>{this.options.visualizePitch?this._map.resetNorthPitch({},{originalEvent:e}):this._map.resetNorth({},{originalEvent:e});}),this._compassIcon=a.create("span","mapboxgl-ctrl-icon",this._compass),this._compassIcon.setAttribute("aria-hidden",!0));}_updateZoomButtons(){const e=this._map.getZoom(),t=e===this._map.getMaxZoom(),i=e===this._map.getMinZoom();this._zoomInButton.disabled=t,this._zoomOutButton.disabled=i,this._zoomInButton.setAttribute("aria-disabled",t.toString()),this._zoomOutButton.setAttribute("aria-disabled",i.toString());}_rotateCompassArrow(){const e=this.options.visualizePitch?`scale(${1/Math.pow(Math.cos(this._map.transform.pitch*(Math.PI/180)),.5)}) rotateX(${this._map.transform.pitch}deg) rotateZ(${this._map.transform.angle*(180/Math.PI)}deg)`:`rotate(${this._map.transform.angle*(180/Math.PI)}deg)`;this._compassIcon.style.transform=e;}onAdd(e){return this._map=e,this.options.showZoom&&(this._setButtonTitle(this._zoomInButton,"ZoomIn"),this._setButtonTitle(this._zoomOutButton,"ZoomOut"),this._map.on("zoom",this._updateZoomButtons),this._updateZoomButtons()),this.options.showCompass&&(this._setButtonTitle(this._compass,"ResetBearing"),this.options.visualizePitch&&this._map.on("pitch",this._rotateCompassArrow),this._map.on("rotate",this._rotateCompassArrow),this._rotateCompassArrow(),this._handler=new ia(this._map,this._compass,this.options.visualizePitch)),this._container}onRemove(){a.remove(this._container),this.options.showZoom&&this._map.off("zoom",this._updateZoomButtons),this.options.showCompass&&(this.options.visualizePitch&&this._map.off("pitch",this._rotateCompassArrow),this._map.off("rotate",this._rotateCompassArrow),this._handler.off(),delete this._handler),delete this._map;}_createButton(e,t){const i=a.create("button",e,this._container);return i.type="button",i.addEventListener("click",t),i}_setButtonTitle(e,t){const i=this._map._getUIString(`NavigationControl.${t}`);e.title=i,e.setAttribute("aria-label",i);}},GeolocateControl:class extends e.Evented{constructor(t){super(),this.options=e.extend({},sa,t),e.bindAll(["_onSuccess","_onError","_onZoom","_finish","_setupUI","_updateCamera","_updateMarker"],this);}onAdd(t){var i;return this._map=t,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),i=this._setupUI,void 0!==la?i(la):void 0!==e.window.navigator.permissions?e.window.navigator.permissions.query({name:"geolocation"}).then(e=>{la="denied"!==e.state,i(la);}):(la=!!e.window.navigator.geolocation,i(la)),this._container}onRemove(){void 0!==this._geolocationWatchID&&(e.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0),this.options.showUserLocation&&this._userLocationDotMarker&&this._userLocationDotMarker.remove(),this.options.showAccuracyCircle&&this._accuracyCircleMarker&&this._accuracyCircleMarker.remove(),a.remove(this._container),this._map.off("zoom",this._onZoom),this._map=void 0,ca=0,ha=!1;}_isOutOfMapMaxBounds(e){const t=this._map.getMaxBounds(),i=e.coords;return t&&(i.longitude<t.getWest()||i.longitude>t.getEast()||i.latitude<t.getSouth()||i.latitude>t.getNorth())}_setErrorState(){switch(this._watchState){case"WAITING_ACTIVE":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"ACTIVE_LOCK":this._watchState="ACTIVE_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");break;case"BACKGROUND":this._watchState="BACKGROUND_ERROR",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting");}}_onSuccess(t){if(this._map){if(this._isOutOfMapMaxBounds(t))return this._setErrorState(),this.fire(new e.Event("outofmaxbounds",t)),this._updateMarker(),void this._finish();if(this.options.trackUserLocation)switch(this._lastKnownPosition=t,this._watchState){case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"BACKGROUND":case"BACKGROUND_ERROR":this._watchState="BACKGROUND",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");}this.options.showUserLocation&&"OFF"!==this._watchState&&this._updateMarker(t),this.options.trackUserLocation&&"ACTIVE_LOCK"!==this._watchState||this._updateCamera(t),this.options.showUserLocation&&this._dotElement.classList.remove("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("geolocate",t)),this._finish();}}_updateCamera(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude),o=t.coords.accuracy,a=this._map.getBearing(),r=e.extend({bearing:a},this.options.fitBoundsOptions);this._map.fitBounds(i.toBounds(o),r,{geolocateSource:!0});}_updateMarker(t){if(t){const i=new e.LngLat(t.coords.longitude,t.coords.latitude);this._accuracyCircleMarker.setLngLat(i).addTo(this._map),this._userLocationDotMarker.setLngLat(i).addTo(this._map),this._accuracy=t.coords.accuracy,this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}else this._userLocationDotMarker.remove(),this._accuracyCircleMarker.remove();}_updateCircleRadius(){const e=this._map._container.clientHeight/2,t=this._map.unproject([0,e]),i=this._map.unproject([1,e]),o=t.distanceTo(i),a=Math.ceil(2*this._accuracy/o);this._circleElement.style.width=`${a}px`,this._circleElement.style.height=`${a}px`;}_onZoom(){this.options.showUserLocation&&this.options.showAccuracyCircle&&this._updateCircleRadius();}_onError(t){if(this._map){if(this.options.trackUserLocation)if(1===t.code){this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this._geolocateButton.disabled=!0;const e=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e),void 0!==this._geolocationWatchID&&this._clearWatch();}else {if(3===t.code&&ha)return;this._setErrorState();}"OFF"!==this._watchState&&this.options.showUserLocation&&this._dotElement.classList.add("mapboxgl-user-location-dot-stale"),this.fire(new e.Event("error",t)),this._finish();}}_finish(){this._timeoutId&&clearTimeout(this._timeoutId),this._timeoutId=void 0;}_setupUI(t){if(this._container.addEventListener("contextmenu",e=>e.preventDefault()),this._geolocateButton=a.create("button","mapboxgl-ctrl-geolocate",this._container),a.create("span","mapboxgl-ctrl-icon",this._geolocateButton).setAttribute("aria-hidden",!0),this._geolocateButton.type="button",!1===t){e.warnOnce("Geolocation support is not available so the GeolocateControl will be disabled.");const t=this._map._getUIString("GeolocateControl.LocationNotAvailable");this._geolocateButton.disabled=!0,this._geolocateButton.title=t,this._geolocateButton.setAttribute("aria-label",t);}else {const e=this._map._getUIString("GeolocateControl.FindMyLocation");this._geolocateButton.title=e,this._geolocateButton.setAttribute("aria-label",e);}this.options.trackUserLocation&&(this._geolocateButton.setAttribute("aria-pressed","false"),this._watchState="OFF"),this.options.showUserLocation&&(this._dotElement=a.create("div","mapboxgl-user-location-dot"),this._userLocationDotMarker=new na(this._dotElement),this._circleElement=a.create("div","mapboxgl-user-location-accuracy-circle"),this._accuracyCircleMarker=new na({element:this._circleElement,pitchAlignment:"map"}),this.options.trackUserLocation&&(this._watchState="OFF"),this._map.on("zoom",this._onZoom)),this._geolocateButton.addEventListener("click",this.trigger.bind(this)),this._setup=!0,this.options.trackUserLocation&&this._map.on("movestart",t=>{t.geolocateSource||"ACTIVE_LOCK"!==this._watchState||t.originalEvent&&"resize"===t.originalEvent.type||(this._watchState="BACKGROUND",this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this.fire(new e.Event("trackuserlocationend")));});}trigger(){if(!this._setup)return e.warnOnce("Geolocate control triggered before added to a map"),!1;if(this.options.trackUserLocation){switch(this._watchState){case"OFF":this._watchState="WAITING_ACTIVE",this.fire(new e.Event("trackuserlocationstart"));break;case"WAITING_ACTIVE":case"ACTIVE_LOCK":case"ACTIVE_ERROR":case"BACKGROUND_ERROR":ca--,ha=!1,this._watchState="OFF",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-active-error"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background-error"),this.fire(new e.Event("trackuserlocationend"));break;case"BACKGROUND":this._watchState="ACTIVE_LOCK",this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-background"),this._lastKnownPosition&&this._updateCamera(this._lastKnownPosition),this.fire(new e.Event("trackuserlocationstart"));}switch(this._watchState){case"WAITING_ACTIVE":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_LOCK":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active");break;case"ACTIVE_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-active-error");break;case"BACKGROUND":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background");break;case"BACKGROUND_ERROR":this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-background-error");}if("OFF"===this._watchState&&void 0!==this._geolocationWatchID)this._clearWatch();else if(void 0===this._geolocationWatchID){let t;this._geolocateButton.classList.add("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","true"),ca++,ca>1?(t={maximumAge:6e5,timeout:0},ha=!0):(t=this.options.positionOptions,ha=!1),this._geolocationWatchID=e.window.navigator.geolocation.watchPosition(this._onSuccess,this._onError,t);}}else e.window.navigator.geolocation.getCurrentPosition(this._onSuccess,this._onError,this.options.positionOptions),this._timeoutId=setTimeout(this._finish,1e4);return !0}_clearWatch(){e.window.navigator.geolocation.clearWatch(this._geolocationWatchID),this._geolocationWatchID=void 0,this._geolocateButton.classList.remove("mapboxgl-ctrl-geolocate-waiting"),this._geolocateButton.setAttribute("aria-pressed","false"),this.options.showUserLocation&&this._updateMarker(null);}},AttributionControl:$o,ScaleControl:class{constructor(t){this.options=e.extend({},ua,t),e.bindAll(["_onMove","setUnit"],this);}getDefaultPosition(){return "bottom-left"}_onMove(){da(this._map,this._container,this.options);}onAdd(e){return this._map=e,this._container=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-scale",e.getContainer()),this._map.on("move",this._onMove),this._onMove(),this._container}onRemove(){a.remove(this._container),this._map.off("move",this._onMove),this._map=void 0;}setUnit(e){this.options.unit=e,da(this._map,this._container,this.options);}},FullscreenControl:class{constructor(t){this._fullscreen=!1,t&&t.container&&(t.container instanceof e.window.HTMLElement?this._container=t.container:e.warnOnce("Full screen control 'container' must be a DOM element.")),e.bindAll(["_onClickFullscreen","_changeIcon"],this),"onfullscreenchange"in e.window.document?this._fullscreenchange="fullscreenchange":"onwebkitfullscreenchange"in e.window.document&&(this._fullscreenchange="webkitfullscreenchange");}onAdd(t){return this._map=t,this._container||(this._container=this._map.getContainer()),this._controlContainer=a.create("div","mapboxgl-ctrl mapboxgl-ctrl-group"),this._checkFullscreenSupport()?this._setupUI():(this._controlContainer.style.display="none",e.warnOnce("This device does not support fullscreen mode.")),this._controlContainer}onRemove(){a.remove(this._controlContainer),this._map=null,e.window.document.removeEventListener(this._fullscreenchange,this._changeIcon);}_checkFullscreenSupport(){return !(!e.window.document.fullscreenEnabled&&!e.window.document.webkitFullscreenEnabled)}_setupUI(){const t=this._fullscreenButton=a.create("button","mapboxgl-ctrl-fullscreen",this._controlContainer);a.create("span","mapboxgl-ctrl-icon",t).setAttribute("aria-hidden",!0),t.type="button",this._updateTitle(),this._fullscreenButton.addEventListener("click",this._onClickFullscreen),e.window.document.addEventListener(this._fullscreenchange,this._changeIcon);}_updateTitle(){const e=this._getTitle();this._fullscreenButton.setAttribute("aria-label",e),this._fullscreenButton.title=e;}_getTitle(){return this._map._getUIString(this._isFullscreen()?"FullscreenControl.Exit":"FullscreenControl.Enter")}_isFullscreen(){return this._fullscreen}_changeIcon(){(e.window.document.fullscreenElement||e.window.document.webkitFullscreenElement)===this._container!==this._fullscreen&&(this._fullscreen=!this._fullscreen,this._fullscreenButton.classList.toggle("mapboxgl-ctrl-shrink"),this._fullscreenButton.classList.toggle("mapboxgl-ctrl-fullscreen"),this._updateTitle());}_onClickFullscreen(){this._isFullscreen()?e.window.document.exitFullscreen?e.window.document.exitFullscreen():e.window.document.webkitCancelFullScreen&&e.window.document.webkitCancelFullScreen():this._container.requestFullscreen?this._container.requestFullscreen():this._container.webkitRequestFullscreen&&this._container.webkitRequestFullscreen();}},Popup:class extends e.Evented{constructor(t){super(),this.options=e.extend(Object.create(ma),t),e.bindAll(["_update","_onClose","remove","_onMouseMove","_onMouseUp","_onDrag"],this);}addTo(t){return this._map&&this.remove(),this._map=t,this.options.closeOnClick&&this._map.on("click",this._onClose),this.options.closeOnMove&&this._map.on("move",this._onClose),this._map.on("remove",this.remove),this._update(),this._focusFirstElement(),this._trackPointer?(this._map.on("mousemove",this._onMouseMove),this._map.on("mouseup",this._onMouseUp),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")):this._map.on("move",this._update),this.fire(new e.Event("open")),this}isOpen(){return !!this._map}remove(){return this._content&&a.remove(this._content),this._container&&(a.remove(this._container),delete this._container),this._map&&(this._map.off("move",this._update),this._map.off("move",this._onClose),this._map.off("click",this._onClose),this._map.off("remove",this.remove),this._map.off("mousemove",this._onMouseMove),this._map.off("mouseup",this._onMouseUp),this._map.off("drag",this._onDrag),delete this._map),this.fire(new e.Event("close")),this}getLngLat(){return this._lngLat}setLngLat(t){return this._lngLat=e.LngLat.convert(t),this._pos=null,this._trackPointer=!1,this._update(),this._map&&(this._map.on("move",this._update),this._map.off("mousemove",this._onMouseMove),this._container&&this._container.classList.remove("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.remove("mapboxgl-track-pointer")),this}trackPointer(){return this._trackPointer=!0,this._pos=null,this._update(),this._map&&(this._map.off("move",this._update),this._map.on("mousemove",this._onMouseMove),this._map.on("drag",this._onDrag),this._container&&this._container.classList.add("mapboxgl-popup-track-pointer"),this._map._canvasContainer.classList.add("mapboxgl-track-pointer")),this}getElement(){return this._container}setText(t){return this.setDOMContent(e.window.document.createTextNode(t))}setHTML(t){const i=e.window.document.createDocumentFragment(),o=e.window.document.createElement("body");let a;for(o.innerHTML=t;a=o.firstChild,a;)i.appendChild(a);return this.setDOMContent(i)}getMaxWidth(){return this._container&&this._container.style.maxWidth}setMaxWidth(e){return this.options.maxWidth=e,this._update(),this}setDOMContent(e){if(this._content)for(;this._content.hasChildNodes();)this._content.firstChild&&this._content.removeChild(this._content.firstChild);else this._content=a.create("div","mapboxgl-popup-content",this._container);return this._content.appendChild(e),this._createCloseButton(),this._update(),this._focusFirstElement(),this}addClassName(e){this._container&&this._container.classList.add(e);}removeClassName(e){this._container&&this._container.classList.remove(e);}setOffset(e){return this.options.offset=e,this._update(),this}toggleClassName(e){if(this._container)return this._container.classList.toggle(e)}_createCloseButton(){this.options.closeButton&&(this._closeButton=a.create("button","mapboxgl-popup-close-button",this._content),this._closeButton.type="button",this._closeButton.setAttribute("aria-label","Close popup"),this._closeButton.innerHTML="&#215;",this._closeButton.addEventListener("click",this._onClose));}_onMouseUp(e){this._update(e.point);}_onMouseMove(e){this._update(e.point);}_onDrag(e){this._update(e.point);}_update(t){if(!this._map||!this._lngLat&&!this._trackPointer||!this._content)return;if(this._container||(this._container=a.create("div","mapboxgl-popup",this._map.getContainer()),this._tip=a.create("div","mapboxgl-popup-tip",this._container),this._container.appendChild(this._content),this.options.className&&this.options.className.split(" ").forEach(e=>this._container.classList.add(e)),this._trackPointer&&this._container.classList.add("mapboxgl-popup-track-pointer")),this.options.maxWidth&&this._container.style.maxWidth!==this.options.maxWidth&&(this._container.style.maxWidth=this.options.maxWidth),this._map.transform.renderWorldCopies&&!this._trackPointer&&(this._lngLat=oa(this._lngLat,this._pos,this._map.transform)),this._trackPointer&&!t)return;const i=this._pos=this._trackPointer&&t?t:this._map.project(this._lngLat);let o=this.options.anchor;const r=function t(i){if(i){if("number"==typeof i){const t=Math.round(Math.sqrt(.5*Math.pow(i,2)));return {center:new e.Point(0,0),top:new e.Point(0,i),"top-left":new e.Point(t,t),"top-right":new e.Point(-t,t),bottom:new e.Point(0,-i),"bottom-left":new e.Point(t,-t),"bottom-right":new e.Point(-t,-t),left:new e.Point(i,0),right:new e.Point(-i,0)}}if(i instanceof e.Point||Array.isArray(i)){const t=e.Point.convert(i);return {center:t,top:t,"top-left":t,"top-right":t,bottom:t,"bottom-left":t,"bottom-right":t,left:t,right:t}}return {center:e.Point.convert(i.center||[0,0]),top:e.Point.convert(i.top||[0,0]),"top-left":e.Point.convert(i["top-left"]||[0,0]),"top-right":e.Point.convert(i["top-right"]||[0,0]),bottom:e.Point.convert(i.bottom||[0,0]),"bottom-left":e.Point.convert(i["bottom-left"]||[0,0]),"bottom-right":e.Point.convert(i["bottom-right"]||[0,0]),left:e.Point.convert(i.left||[0,0]),right:e.Point.convert(i.right||[0,0])}}return t(new e.Point(0,0))}(this.options.offset);if(!o){const e=this._container.offsetWidth,t=this._container.offsetHeight;let a;a=i.y+r.bottom.y<t?["top"]:i.y>this._map.transform.height-t?["bottom"]:[],i.x<e/2?a.push("left"):i.x>this._map.transform.width-e/2&&a.push("right"),o=0===a.length?"bottom":a.join("-");}const n=i.add(r[o]).round();a.setTransform(this._container,`${aa[o]} translate(${n.x}px,${n.y}px)`),ra(this._container,o,"popup");}_focusFirstElement(){if(!this.options.focusAfterOpen||!this._container)return;const e=this._container.querySelector(pa);e&&e.focus();}_onClose(){this.remove();}},Marker:na,Style:Ze,LngLat:e.LngLat,LngLatBounds:e.LngLatBounds,Point:e.Point,MercatorCoordinate:e.MercatorCoordinate,FreeCameraOptions:Xi,Evented:e.Evented,config:e.config,prewarm:function(){B().acquire(L);},clearPrewarmedResources:function(){const e=k;e&&(e.isPreloaded()&&1===e.numActive()?(e.release(L),k=null):console.warn("Could not clear WebWorkers since there are active Map instances that still reference it. The pre-warmed WebWorker pool can only be cleared when all map instances have been removed with map.remove()"));},get accessToken(){return e.config.ACCESS_TOKEN},set accessToken(t){e.config.ACCESS_TOKEN=t;},get baseApiUrl(){return e.config.API_URL},set baseApiUrl(t){e.config.API_URL=t;},get workerCount(){return R.workerCount},set workerCount(e){R.workerCount=e;},get maxParallelImageRequests(){return e.config.MAX_PARALLEL_IMAGE_REQUESTS},set maxParallelImageRequests(t){e.config.MAX_PARALLEL_IMAGE_REQUESTS=t;},clearStorage(t){e.clearTileCache(t);},workerUrl:"",workerClass:null,setNow:e.browser.setNow,restoreNow:e.browser.restoreNow};return fa}));

//

return mapboxgl;

})));
//# sourceMappingURL=mapbox-gl.js.map
