/**
 * @description 导出主题配置
 */
module.exports = {
  // 布局种类：非企业版只支持vertical
  layout: 'vertical',
  // 主题名称：非企业版只支持blue-black
  themeName: 'blue-black',
  // 菜单背景 none
  background: 'none',
  // 菜单宽度，建议大小：190px，其余尺寸会影响美观
  menuWidth: '190px',
  // 分栏风格(仅针对分栏布局column时生效)
  columnStyle: 'vertical',
  // 是否固定头部固定
  fixedHeader: true,
  // 是否开启顶部进度条
  showProgressBar: true,
  // 是否开启标签页
  showTabs: true,
  // 显示标签页时标签页样式：卡片风格card、灵动风格smart、圆滑风格smooth
  tabsBarStyle: 'smooth',
  // 是否标签页图标
  showTabsIcon: true,
  // 是否开启语言选择组件
  showLanguage: true,
  // 是否开启刷新组件
  showRefresh: true,
  // 是否开启通知组件
  showNotice: true,
  // 是否开启全屏组件
  showFullScreen: true,
  //纵向布局、常规布局、综合布局时是否默认收起左侧菜单
  foldSidebar: false,
  // 是否开启页面动画
  showPageTransition: true,
}
