
showdoc支持plantuml，包括时序图、用例图、类图、组件图、状态图等等。你可以使用markdown代码块声明plantuml，然后中间插入plantuml语句。如：

<pre>
```plantuml 
@startuml
Alice -> Bob: Authentication Request
Bob --> Alice: Authentication Response
Alice -> Bob: Another authentication Request
Alice <-- Bob: another authentication Response
@enduml
```
</pre>

上述代码生成的图例效果如下：

```plantuml

@startuml
Alice -> Bob: Authentication Request
Bob --> Alice: Authentication Response

Alice -> Bob: Another authentication Request
Alice <-- Bob: another authentication Response
@enduml


```


#### 更多plantuml语法规则请看https://plantuml.com/zh 
#### 下方将给出各个图的预览效果



------------


### 时序图

```plantuml

@startuml
Alice -> Bob: Authentication Request
Bob --> Alice: Authentication Response

Alice -> Bob: Another authentication Request
Alice <-- Bob: another authentication Response
@enduml


```


### 用例图

```plantuml

@startuml

(First usecase)
(Another usecase) as (UC2)  
usecase UC3
usecase (Last\nusecase) as UC4

@enduml


```


### 类图

```plantuml

@startuml
Class01 <|-- Class02
Class03 *-- Class04
Class05 o-- Class06
Class07 .. Class08
Class09 -- Class10
@enduml


```

### 活动图


```plantuml

@startuml

(*) --> "First Activity"
"First Activity" --> (*)

@enduml


```


### 组件图


```plantuml

@startuml

[First component]
[Another component] as Comp2  
component Comp3
component [Last\ncomponent] as Comp4

@enduml


```


### 状态图



```plantuml

@startuml

[*] --> State1
State1 --> [*]
State1 : this is a string
State1 : this is another string

State1 -> State2
State2 --> [*]

@enduml


```

### 定时图



```plantuml

@startuml
robust "Web 浏览器" as WB
concise "Web 用户" as WU

@0
WU is 空闲
WB is 空闲

@100
WU is 等待中
WB is 处理中

@300
WB is 等待中
@enduml


```
