<?php declare(strict_types=1);

namespace Shopware\Core\Migration\V6_4;

use Doctrine\DBAL\Connection;
use Shopware\Core\Checkout\Payment\Cart\PaymentHandler\CashPayment;
use Shopware\Core\Framework\Log\Package;
use Shopware\Core\Framework\Migration\MigrationStep;

/**
 * @internal
 *
 * @codeCoverageIgnore
 */
#[Package('core')]
class Migration1617000878AddTemplateDataToMailTemplateType extends MigrationStep
{
    public function getCreationTimestamp(): int
    {
        return 1617000878;
    }

    public function update(Connection $connection): void
    {
        $connection->executeStatement(
            '
        ALTER TABLE `mail_template_type`
        ADD `template_data` LONGTEXT COLLATE utf8mb4_unicode_ci NULL'
        );

        $orderDeliverState = [
            'order' => [
                'orderNumber' => '10060',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'currencyFactor' => 1.0,
                'salesChannelId' => '6d5b12a8049e411cb463296092b0e887',
                'billingAddressId' => '658f064fb7214daca0821410c265a54a',
                'orderDateTime' => '2021-04-08T08:06:47.547+00:00',
                'orderDate' => '2021-04-08T00:00:00.000+00:00',
                'price' => [
                    'netPrice' => 740.0,
                    'totalPrice' => 740.0,
                    'calculatedTaxes' => [
                        0 => [
                            'tax' => 0.0,
                            'taxRate' => 0.0,
                            'price' => 740.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'taxRules' => [
                        0 => [
                            'taxRate' => 0.0,
                            'percentage' => 100.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'positionPrice' => 740.0,
                    'taxStatus' => 'gross',
                    'rawTotal' => 740.0,
                    'extensions' => [
                    ],
                ],
                'amountTotal' => 740.0,
                'amountNet' => 740.0,
                'positionPrice' => 740.0,
                'taxStatus' => 'gross',
                'shippingCosts' => [
                    'unitPrice' => 0.0,
                    'quantity' => 1,
                    'totalPrice' => 0.0,
                    'calculatedTaxes' => [
                        0 => [
                            'tax' => 0.0,
                            'taxRate' => 0.0,
                            'price' => 0.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'taxRules' => [
                        0 => [
                            'taxRate' => 0.0,
                            'percentage' => 100.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'referencePrice' => null,
                    'listPrice' => null,
                    'extensions' => [
                    ],
                ],
                'shippingTotal' => 0.0,
                'orderCustomer' => [
                    'email' => 'test@example.com',
                    'orderId' => '666434556c72430e8626f13339ea7bdc',
                    'salutationId' => 'b3b9251279764583a0f11ff92e3d40ef',
                    'firstName' => 'Max',
                    'lastName' => 'Mustermann',
                    'title' => null,
                    'vatIds' => null,
                    'company' => null,
                    'customerNumber' => '1337',
                    'customerId' => '6b216f01cab54ef5807f1aa180414ce7',
                    'customer' => [
                        'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                        'defaultPaymentMethodId' => '11491d8f829143c9a1f15c9c55e3df0c',
                        'salesChannelId' => '98432def39fc4624b33213a56b8c944d',
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'lastPaymentMethodId' => null,
                        'defaultBillingAddressId' => 'a3d3353fc86f4cc78bc4d4ccf5fd0f5e',
                        'defaultShippingAddressId' => '7cd64c81e0dc4488a4c461dab4e9bf4b',
                        'customerNumber' => '1337',
                        'salutationId' => 'b3b9251279764583a0f11ff92e3d40ef',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'company' => null,
                        'email' => 'test@example.com',
                        'title' => null,
                        'vatIds' => null,
                        'affiliateCode' => null,
                        'campaignCode' => null,
                        'active' => true,
                        'doubleOptInRegistration' => false,
                        'doubleOptInEmailSentDate' => null,
                        'doubleOptInConfirmDate' => null,
                        'hash' => null,
                        'guest' => false,
                        'firstLogin' => null,
                        'lastLogin' => '2021-04-08T08:06:35.953+00:00',
                        'newsletter' => false,
                        'birthday' => null,
                        'lastOrderDate' => '2021-04-08T08:06:47.547+00:00',
                        'orderCount' => 3,
                        'createdAt' => '2021-04-08T07:31:30.853+00:00',
                        'updatedAt' => '2021-04-08T08:06:47.769+00:00',
                        'legacyEncoder' => null,
                        'legacyPassword' => null,
                        'group' => null,
                        'defaultPaymentMethod' => null,
                        'salesChannel' => null,
                        'language' => null,
                        'lastPaymentMethod' => null,
                        'salutation' => null,
                        'defaultBillingAddress' => null,
                        'defaultShippingAddress' => null,
                        'activeBillingAddress' => null,
                        'activeShippingAddress' => null,
                        'addresses' => null,
                        'orderCustomers' => null,
                        'autoIncrement' => 61,
                        'tags' => null,
                        'tagIds' => null,
                        'promotions' => null,
                        'recoveryCustomer' => null,
                        'customFields' => null,
                        'productReviews' => null,
                        'remoteAddress' => '::',
                        'requestedGroupId' => null,
                        'requestedGroup' => null,
                        'boundSalesChannelId' => null,
                        'boundSalesChannel' => null,
                        'wishlists' => null,
                        '_uniqueIdentifier' => '6b216f01cab54ef5807f1aa180414ce7',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'extensions' => [
                            'internal_mapping_storage' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '6b216f01cab54ef5807f1aa180414ce7',
                    ],
                    'salutation' => [
                        'salutationKey' => 'not_specified',
                        'displayName' => 'Not specified',
                        'letterName' => ' ',
                        'translations' => null,
                        'customers' => null,
                        'customerAddresses' => null,
                        'orderCustomers' => null,
                        'orderAddresses' => null,
                        'newsletterRecipients' => null,
                        '_uniqueIdentifier' => 'b3b9251279764583a0f11ff92e3d40ef',
                        'versionId' => null,
                        'translated' => [
                            'displayName' => 'Not specified',
                            'letterName' => ' ',
                        ],
                        'createdAt' => '2021-04-08T07:30:01.479+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'internal_mapping_storage' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'b3b9251279764583a0f11ff92e3d40ef',
                    ],
                    'order' => null,
                    'customFields' => null,
                    'remoteAddress' => '::',
                    '_uniqueIdentifier' => '9105dcbe44d9424fab96d351be47a927',
                    'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    'translated' => [
                    ],
                    'createdAt' => '2021-04-08T08:06:47.671+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '9105dcbe44d9424fab96d351be47a927',
                    'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                ],
                'currency' => [
                    'isoCode' => 'EUR',
                    'factor' => 1.0,
                    'symbol' => '€',
                    'shortName' => 'EUR',
                    'name' => 'Euro',
                    'position' => 1,
                    'translations' => null,
                    'orders' => null,
                    'salesChannels' => null,
                    'salesChannelDefaultAssignments' => null,
                    'salesChannelDomains' => null,
                    'customFields' => null,
                    'shippingMethodPrices' => null,
                    'promotionDiscountPrices' => null,
                    'isSystemDefault' => true,
                    'productExports' => null,
                    'countryRoundings' => null,
                    'itemRounding' => [
                        'decimals' => 2,
                        'interval' => 0.01,
                        'roundForNet' => true,
                        'extensions' => [
                        ],
                    ],
                    'totalRounding' => [
                        'decimals' => 2,
                        'interval' => 0.01,
                        'roundForNet' => true,
                        'extensions' => [
                        ],
                    ],
                    '_uniqueIdentifier' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                    'versionId' => null,
                    'translated' => [
                        'shortName' => 'EUR',
                        'name' => 'Euro',
                        'customFields' => [
                        ],
                    ],
                    'createdAt' => '2021-04-08T07:30:01.679+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                ],
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'language' => null,
                'salesChannel' => [
                    'typeId' => '8a243080f92e4c719546314b577cf82b',
                    'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                    'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                    'paymentMethodId' => '11491d8f829143c9a1f15c9c55e3df0c',
                    'shippingMethodId' => '03168af91f804087b7bc24eea072c2d6',
                    'countryId' => '36159d966ed844e6add50a0a370c99b2',
                    'navigationCategoryId' => 'aee8846cc9214295bd832fc436ff0891',
                    'navigationCategoryDepth' => 2,
                    'homeSlotConfig' => null,
                    'homeCmsPageId' => null,
                    'homeCmsPage' => null,
                    'homeEnabled' => null,
                    'homeName' => null,
                    'homeMetaTitle' => null,
                    'homeMetaDescription' => null,
                    'homeKeywords' => null,
                    'footerCategoryId' => null,
                    'serviceCategoryId' => null,
                    'name' => 'Storefront',
                    'shortName' => null,
                    'accessKey' => 'SWSCATLQZHBWBVZ1SGHNQNBLAQ',
                    'currencies' => null,
                    'languages' => null,
                    'configuration' => null,
                    'active' => true,
                    'maintenance' => false,
                    'maintenanceIpWhitelist' => null,
                    'taxCalculationType' => 'horizontal',
                    'type' => null,
                    'currency' => null,
                    'language' => null,
                    'paymentMethod' => null,
                    'shippingMethod' => null,
                    'country' => null,
                    'orders' => null,
                    'customers' => null,
                    'countries' => null,
                    'paymentMethods' => null,
                    'shippingMethods' => null,
                    'translations' => null,
                    'domains' => null,
                    'systemConfigs' => null,
                    'customFields' => null,
                    'navigationCategory' => null,
                    'footerCategory' => null,
                    'serviceCategory' => null,
                    'productVisibilities' => null,
                    'mailHeaderFooterId' => null,
                    'numberRangeSalesChannels' => null,
                    'mailHeaderFooter' => null,
                    'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                    'customerGroup' => null,
                    'newsletterRecipients' => null,
                    'promotionSalesChannels' => null,
                    'documentBaseConfigSalesChannels' => null,
                    'productReviews' => null,
                    'seoUrls' => null,
                    'seoUrlTemplates' => null,
                    'mainCategories' => null,
                    'paymentMethodIds' => [
                        0 => '02f698f2ca24408bbbd40370ac95275d',
                        1 => '11491d8f829143c9a1f15c9c55e3df0c',
                        2 => '68cd624bbe2946f4afbdc1ae2f389e0e',
                        3 => 'e226a70069af441f965e79459acccb41',
                    ],
                    'productExports' => null,
                    'hreflangActive' => false,
                    'hreflangDefaultDomainId' => null,
                    'hreflangDefaultDomain' => null,
                    'analyticsId' => null,
                    'analytics' => null,
                    'customerGroupsRegistrations' => null,
                    'eventActions' => null,
                    'boundCustomers' => null,
                    'wishlists' => null,
                    'landingPages' => null,
                    '_uniqueIdentifier' => '6d5b12a8049e411cb463296092b0e887',
                    'versionId' => null,
                    'translated' => [
                        'name' => 'Storefront',
                        'customFields' => [
                        ],
                    ],
                    'createdAt' => '2021-04-08T07:30:38.224+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '6d5b12a8049e411cb463296092b0e887',
                    'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    'footerCategoryVersionId' => null,
                    'serviceCategoryVersionId' => null,
                ],
                'addresses' => [
                    0 => [
                        'countryId' => 'add8539b11814972818256faa91f3316',
                        'countryStateId' => null,
                        'salutationId' => 'b3b9251279764583a0f11ff92e3d40ef',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'street' => 'Ebbinghoff 10',
                        'zipcode' => '48624',
                        'city' => 'Schöppingen',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'vatId' => null,
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => [
                            'name' => 'Paraguay',
                            'iso' => 'PY',
                            'position' => 10,
                            'taxFree' => false,
                            'active' => true,
                            'shippingAvailable' => true,
                            'iso3' => 'PRY',
                            'displayStateInRegistration' => false,
                            'forceStateInRegistration' => false,
                            'companyTaxFree' => false,
                            'checkVatIdPattern' => false,
                            'vatIdPattern' => null,
                            'states' => null,
                            'translations' => null,
                            'orderAddresses' => null,
                            'customerAddresses' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'taxRules' => null,
                            'currencyCountryRoundings' => null,
                            '_uniqueIdentifier' => 'add8539b11814972818256faa91f3316',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Paraguay',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-08T07:30:11.066+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'add8539b11814972818256faa91f3316',
                        ],
                        'countryState' => null,
                        'order' => null,
                        'salutation' => null,
                        'orderDeliveries' => null,
                        'orderId' => '666434556c72430e8626f13339ea7bdc',
                        'customFields' => null,
                        '_uniqueIdentifier' => '5a915d3e124b409389785aa5a7534472',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T08:06:47.691+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '5a915d3e124b409389785aa5a7534472',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                    1 => [
                        'countryId' => 'b0baef05cfca4995bfbdd75a95b1d2d7',
                        'countryStateId' => null,
                        'salutationId' => 'b3b9251279764583a0f11ff92e3d40ef',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'street' => 'Bahnhofstraße 27',
                        'zipcode' => '10332',
                        'city' => 'Berlin',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'vatId' => null,
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => [
                            'name' => 'Djibouti',
                            'iso' => 'DJ',
                            'position' => 10,
                            'taxFree' => false,
                            'active' => true,
                            'shippingAvailable' => true,
                            'iso3' => 'DJI',
                            'displayStateInRegistration' => false,
                            'forceStateInRegistration' => false,
                            'companyTaxFree' => false,
                            'checkVatIdPattern' => false,
                            'vatIdPattern' => null,
                            'states' => null,
                            'translations' => null,
                            'orderAddresses' => null,
                            'customerAddresses' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'taxRules' => null,
                            'currencyCountryRoundings' => null,
                            '_uniqueIdentifier' => 'b0baef05cfca4995bfbdd75a95b1d2d7',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Djibouti',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-08T07:30:10.954+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'b0baef05cfca4995bfbdd75a95b1d2d7',
                        ],
                        'countryState' => null,
                        'order' => null,
                        'salutation' => null,
                        'orderDeliveries' => null,
                        'orderId' => '666434556c72430e8626f13339ea7bdc',
                        'customFields' => null,
                        '_uniqueIdentifier' => '658f064fb7214daca0821410c265a54a',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T08:06:47.687+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '658f064fb7214daca0821410c265a54a',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'billingAddress' => null,
                'deliveries' => [
                    0 => [
                        'orderId' => '666434556c72430e8626f13339ea7bdc',
                        'shippingOrderAddressId' => '5a915d3e124b409389785aa5a7534472',
                        'shippingMethodId' => '03168af91f804087b7bc24eea072c2d6',
                        'trackingCodes' => [
                        ],
                        'shippingDateEarliest' => '2021-04-09T00:00:00.000+00:00',
                        'shippingDateLatest' => '2021-04-11T00:00:00.000+00:00',
                        'shippingCosts' => [
                            'unitPrice' => 0.0,
                            'quantity' => 1,
                            'totalPrice' => 0.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 0.0,
                                    'taxRate' => 0.0,
                                    'price' => 0.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 0.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'shippingOrderAddress' => [
                            'countryId' => 'add8539b11814972818256faa91f3316',
                            'countryStateId' => null,
                            'salutationId' => 'b3b9251279764583a0f11ff92e3d40ef',
                            'firstName' => 'Max',
                            'lastName' => 'Mustermann',
                            'street' => 'Ebbinghoff 10',
                            'zipcode' => '48624',
                            'city' => 'Schöppingen',
                            'company' => null,
                            'department' => null,
                            'title' => null,
                            'vatId' => null,
                            'phoneNumber' => null,
                            'additionalAddressLine1' => null,
                            'additionalAddressLine2' => null,
                            'country' => [
                                'name' => 'Paraguay',
                                'iso' => 'PY',
                                'position' => 10,
                                'taxFree' => false,
                                'active' => true,
                                'shippingAvailable' => true,
                                'iso3' => 'PRY',
                                'displayStateInRegistration' => false,
                                'forceStateInRegistration' => false,
                                'companyTaxFree' => false,
                                'checkVatIdPattern' => false,
                                'vatIdPattern' => null,
                                'states' => null,
                                'translations' => null,
                                'orderAddresses' => null,
                                'customerAddresses' => null,
                                'salesChannelDefaultAssignments' => null,
                                'salesChannels' => null,
                                'customFields' => null,
                                'taxRules' => null,
                                'currencyCountryRoundings' => null,
                                '_uniqueIdentifier' => 'add8539b11814972818256faa91f3316',
                                'versionId' => null,
                                'translated' => [
                                    'name' => 'Paraguay',
                                    'customFields' => [
                                    ],
                                ],
                                'createdAt' => '2021-04-08T07:30:11.066+00:00',
                                'updatedAt' => null,
                                'extensions' => [
                                    'internal_mapping_storage' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                    'foreignKeys' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                ],
                                'id' => 'add8539b11814972818256faa91f3316',
                            ],
                            'countryState' => null,
                            'order' => null,
                            'salutation' => null,
                            'orderDeliveries' => null,
                            'orderId' => '666434556c72430e8626f13339ea7bdc',
                            'customFields' => null,
                            '_uniqueIdentifier' => '5a915d3e124b409389785aa5a7534472',
                            'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                            'translated' => [
                            ],
                            'createdAt' => '2021-04-08T08:06:47.691+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '5a915d3e124b409389785aa5a7534472',
                            'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        ],
                        'stateId' => 'da7999756a0b4f24a8f1b2c3517c63c6',
                        'stateMachineState' => [
                            'name' => 'Shipped',
                            'technicalName' => 'shipped',
                            'stateMachineId' => 'fa6a3f6ee9ac40b88cb2383890b96e4b',
                            'stateMachine' => null,
                            'fromStateMachineTransitions' => null,
                            'toStateMachineTransitions' => null,
                            'translations' => null,
                            'orders' => null,
                            'orderTransactions' => null,
                            'orderDeliveries' => null,
                            'fromStateMachineHistoryEntries' => null,
                            'toStateMachineHistoryEntries' => null,
                            'customFields' => null,
                            '_uniqueIdentifier' => 'da7999756a0b4f24a8f1b2c3517c63c6',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Shipped',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-08T07:30:01.817+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'da7999756a0b4f24a8f1b2c3517c63c6',
                        ],
                        'shippingMethod' => [
                            'name' => 'Express',
                            'active' => true,
                            'description' => null,
                            'trackingUrl' => null,
                            'deliveryTimeId' => '0733a509484c40daa1225173e6ccf382',
                            'deliveryTime' => [
                                'name' => '1-3 days',
                                'min' => 1,
                                'max' => 3,
                                'unit' => 'day',
                                'shippingMethods' => null,
                                'translations' => null,
                                'customFields' => null,
                                'products' => null,
                                '_uniqueIdentifier' => '0733a509484c40daa1225173e6ccf382',
                                'versionId' => null,
                                'translated' => [
                                    'name' => '1-3 days',
                                    'customFields' => [
                                    ],
                                ],
                                'createdAt' => '2021-04-08T07:30:01.000+00:00',
                                'updatedAt' => null,
                                'extensions' => [
                                    'internal_mapping_storage' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                    'foreignKeys' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                ],
                                'id' => '0733a509484c40daa1225173e6ccf382',
                            ],
                            'translations' => null,
                            'orderDeliveries' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'availabilityRule' => null,
                            'availabilityRuleId' => 'f52b985fe172452d8eb4be30ae838bca',
                            'prices' => [
                            ],
                            'mediaId' => null,
                            'taxId' => null,
                            'media' => null,
                            'tags' => null,
                            'taxType' => 'auto',
                            'tax' => null,
                            '_uniqueIdentifier' => '03168af91f804087b7bc24eea072c2d6',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Express',
                                'customFields' => [
                                ],
                                'description' => null,
                                'trackingUrl' => null,
                            ],
                            'createdAt' => '2021-04-08T07:30:01.696+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '03168af91f804087b7bc24eea072c2d6',
                        ],
                        'order' => null,
                        'positions' => null,
                        'customFields' => null,
                        '_uniqueIdentifier' => 'bdd092a2bd9547d3a05c513c2dc37e13',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T08:06:47.694+00:00',
                        'updatedAt' => '2021-04-08T08:07:42.742+00:00',
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'bdd092a2bd9547d3a05c513c2dc37e13',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'shippingOrderAddressVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'lineItems' => [
                    0 => [
                        'orderId' => '666434556c72430e8626f13339ea7bdc',
                        'identifier' => '26641f6d8e52424a9238cb25b59ac402',
                        'referencedId' => '26641f6d8e52424a9238cb25b59ac402',
                        'productId' => '26641f6d8e52424a9238cb25b59ac402',
                        'quantity' => 1,
                        'unitPrice' => 740.0,
                        'totalPrice' => 740.0,
                        'label' => 'Aerodynamic Bronze Brush n Flush',
                        'description' => null,
                        'good' => true,
                        'removable' => true,
                        'coverId' => '04e72112470e4e989372b03e356eea70',
                        'stackable' => true,
                        'position' => 1,
                        'price' => [
                            'unitPrice' => 740.0,
                            'quantity' => 1,
                            'totalPrice' => 740.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 0.0,
                                    'taxRate' => 0.0,
                                    'price' => 740.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 0.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'priceDefinition' => [
                            'price' => 740.0,
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 0.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'quantity' => 1,
                            'isCalculated' => true,
                            'referencePriceDefinition' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                            'type' => 'quantity',
                        ],
                        'payload' => [
                            'isNew' => false,
                            'taxId' => 'a8e6660add084484988909a3eba996f8',
                            'tagIds' => null,
                            'options' => [
                            ],
                            'features' => [
                            ],
                            'createdAt' => '2021-04-08 07:31:35.403',
                            'optionIds' => null,
                            'isCloseout' => false,
                            'categoryIds' => [
                                0 => 'aee8846cc9214295bd832fc436ff0891',
                                1 => '7f21a683489742aeac15c846ff26089b',
                                2 => '6901b0428273411fafb4c20657a87819',
                            ],
                            'propertyIds' => [
                                0 => '1f320a0a3e1e4032b9840c25b216c01c',
                                1 => '27c7db6c50e1458b80bd48b7fd156bbb',
                                2 => '2ac677dfc0ea43d9afc33ff4eba10557',
                                3 => '33856bf045a74d438a85232de72555ce',
                                4 => '4868b068ff0b4706ad02b2beb7fb68ae',
                                5 => '4afcfa4dc9444ae28b2bc4fc5e37fca8',
                                6 => '5f0d692e20774e22b1339acb55a4ab8c',
                                7 => '7c29e4c1659b4c1e86703cb8c57ad017',
                                8 => '7e4b7a49eda545dd8619bf350534d2b9',
                                9 => '9975751305c542d592674b0a516e7faf',
                                10 => '9b7ba56210154b05a71de31f1fdef294',
                                11 => 'a5d876efaf824a4f83f146d9280a833e',
                                12 => 'ab47e83d07f14b978730c28fcdcf7dbb',
                                13 => 'bd885d5a1fbe467d92fc1d9878b69308',
                                14 => 'bfc247a0147b43b1900c16437a59d2ac',
                                15 => 'c73ec99cbf3c4e6da14727f34bc79a1b',
                                16 => 'ec048350008846569f8e3e786b2f3839',
                                17 => 'f40a4cb7036d48a3bb92901ea9806de4',
                            ],
                            'releaseDate' => null,
                            'customFields' => [
                            ],
                            'productNumber' => '63695d9584c7469f923053c43e6bc51b',
                            'manufacturerId' => '60fe1e82644c4ac98024d37428848ef0',
                            'purchasePrices' => '{"currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","net":6.5,"gross":6.5,"linked":true,"listPrice":null,"extensions":[]}',
                            'markAsTopseller' => null,
                        ],
                        'parentId' => null,
                        'type' => 'product',
                        'order' => null,
                        'orderDeliveryPositions' => null,
                        'customFields' => null,
                        'cover' => null,
                        'children' => null,
                        'product' => null,
                        '_uniqueIdentifier' => '782f865d67ba4c7fa4b0295523860bd3',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T08:06:47.700+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '782f865d67ba4c7fa4b0295523860bd3',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'productVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'parentVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'transactions' => [
                    0 => [
                        'orderId' => '666434556c72430e8626f13339ea7bdc',
                        'paymentMethodId' => '11491d8f829143c9a1f15c9c55e3df0c',
                        'amount' => [
                            'unitPrice' => 740.0,
                            'quantity' => 1,
                            'totalPrice' => 740.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 0.0,
                                    'taxRate' => 0.0,
                                    'price' => 740.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 0.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'paymentMethod' => [
                            'pluginId' => null,
                            'handlerIdentifier' => CashPayment::class,
                            'name' => 'Cash on delivery',
                            'description' => 'Payment upon receipt of goods.',
                            'position' => 1,
                            'active' => true,
                            'afterOrderEnabled' => true,
                            'plugin' => null,
                            'translations' => null,
                            'orderTransactions' => null,
                            'customers' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'availabilityRule' => null,
                            'availabilityRuleId' => null,
                            'mediaId' => null,
                            'media' => null,
                            'customFields' => null,
                            'formattedHandlerIdentifier' => 'handler_shopware_cashpayment',
                            'shortName' => 'cash_payment',
                            '_uniqueIdentifier' => '11491d8f829143c9a1f15c9c55e3df0c',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Cash on delivery',
                                'description' => 'Payment upon receipt of goods.',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-08T07:30:01.687+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '11491d8f829143c9a1f15c9c55e3df0c',
                        ],
                        'order' => null,
                        'stateMachineState' => [
                            'name' => 'Open',
                            'technicalName' => 'open',
                            'stateMachineId' => '6e6136e244b94bb7a45cc0892710d8e5',
                            'stateMachine' => null,
                            'fromStateMachineTransitions' => null,
                            'toStateMachineTransitions' => null,
                            'translations' => null,
                            'orders' => null,
                            'orderTransactions' => null,
                            'orderDeliveries' => null,
                            'fromStateMachineHistoryEntries' => null,
                            'toStateMachineHistoryEntries' => null,
                            'customFields' => null,
                            '_uniqueIdentifier' => 'c535a5a0502041cf82876451ddb6e9d8',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Open',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-08T07:30:01.828+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'c535a5a0502041cf82876451ddb6e9d8',
                        ],
                        'stateId' => 'c535a5a0502041cf82876451ddb6e9d8',
                        'customFields' => null,
                        '_uniqueIdentifier' => '5d5231dbd1e246919b334d26733b4fd2',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T08:06:47.702+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '5d5231dbd1e246919b334d26733b4fd2',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'deepLinkCode' => 'xdmAUXn23g527SYM1yLLDKyOZ4BSUvJE',
                'autoIncrement' => 61,
                'stateMachineState' => [
                    'name' => 'Open',
                    'technicalName' => 'open',
                    'stateMachineId' => '79a76fe8cd784a469aaa34f628713cfd',
                    'stateMachine' => null,
                    'fromStateMachineTransitions' => null,
                    'toStateMachineTransitions' => null,
                    'translations' => null,
                    'orders' => null,
                    'orderTransactions' => null,
                    'orderDeliveries' => null,
                    'fromStateMachineHistoryEntries' => null,
                    'toStateMachineHistoryEntries' => null,
                    'customFields' => null,
                    '_uniqueIdentifier' => '7c5f81be5ede4c4f88efc6689cea5f62',
                    'versionId' => null,
                    'translated' => [
                        'name' => 'Open',
                        'customFields' => [
                        ],
                    ],
                    'createdAt' => '2021-04-08T07:30:01.796+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '7c5f81be5ede4c4f88efc6689cea5f62',
                ],
                'stateId' => '7c5f81be5ede4c4f88efc6689cea5f62',
                'customFields' => null,
                'documents' => null,
                'tags' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'customerComment' => null,
                'ruleIds' => [
                    0 => 'ddc661de2b4449f2aee52bd73f8884ec',
                    1 => 'f52b985fe172452d8eb4be30ae838bca',
                    2 => 'fe822fb82ad74e6d85821673de316388',
                    3 => '6ccc3d984ec04f07a9ddb1e288c0b7f4',
                ],
                'createdById' => null,
                'createdBy' => null,
                'updatedById' => null,
                'updatedBy' => null,
                'itemRounding' => [
                    'decimals' => 2,
                    'interval' => 0.01,
                    'roundForNet' => true,
                    'extensions' => [
                    ],
                ],
                'totalRounding' => [
                    'decimals' => 2,
                    'interval' => 0.01,
                    'roundForNet' => true,
                    'extensions' => [
                    ],
                ],
                '_uniqueIdentifier' => '666434556c72430e8626f13339ea7bdc',
                'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'translated' => [
                ],
                'createdAt' => '2021-04-08T08:06:47.705+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '666434556c72430e8626f13339ea7bdc',
                'billingAddressVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => '11491d8f829143c9a1f15c9c55e3df0c',
                'shippingMethodId' => '03168af91f804087b7bc24eea072c2d6',
                'countryId' => '36159d966ed844e6add50a0a370c99b2',
                'navigationCategoryId' => 'aee8846cc9214295bd832fc436ff0891',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCATLQZHBWBVZ1SGHNQNBLAQ',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '765a7f1059ee4f75a4592194291d1e1e',
                        'snippetSet' => null,
                        'salesChannelId' => '6d5b12a8049e411cb463296092b0e887',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => '7ed2b68f70284aea83d1c2747b622848',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-08T07:30:38.224+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '7ed2b68f70284aea83d1c2747b622848',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => '02f698f2ca24408bbbd40370ac95275d',
                    1 => '11491d8f829143c9a1f15c9c55e3df0c',
                    2 => '68cd624bbe2946f4afbdc1ae2f389e0e',
                    3 => 'e226a70069af441f965e79459acccb41',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => '6d5b12a8049e411cb463296092b0e887',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-04-08T07:30:38.224+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '6d5b12a8049e411cb463296092b0e887',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $guestOrder = [
            'customer' => [
                'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'defaultPaymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'lastPaymentMethodId' => null,
                'defaultBillingAddressId' => 'a97c45ffcb3246b18a57dff85ebf440e',
                'defaultShippingAddressId' => 'a97c45ffcb3246b18a57dff85ebf440e',
                'customerNumber' => '10061',
                'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'company' => null,
                'email' => 'testing@example.com',
                'title' => null,
                'vatIds' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'active' => false,
                'doubleOptInRegistration' => true,
                'doubleOptInEmailSentDate' => '2021-03-29T14:55:28.861+00:00',
                'doubleOptInConfirmDate' => null,
                'hash' => '6cf0a92813a6465ca445a1039b04fcae',
                'guest' => true,
                'firstLogin' => '2021-03-29T14:55:28.858+00:00',
                'lastLogin' => null,
                'newsletter' => false,
                'birthday' => null,
                'lastOrderDate' => null,
                'orderCount' => 0,
                'createdAt' => '2021-03-29T14:55:28.885+00:00',
                'updatedAt' => null,
                'legacyEncoder' => null,
                'legacyPassword' => null,
                'group' => null,
                'defaultPaymentMethod' => null,
                'salesChannel' => null,
                'language' => null,
                'lastPaymentMethod' => null,
                'salutation' => [
                    'salutationKey' => 'mr',
                    'displayName' => 'Mr.',
                    'letterName' => 'Dear Mr.',
                    'translations' => null,
                    'customers' => null,
                    'customerAddresses' => null,
                    'orderCustomers' => null,
                    'orderAddresses' => null,
                    'newsletterRecipients' => null,
                    '_uniqueIdentifier' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                    'versionId' => null,
                    'translated' => [
                        'displayName' => 'Mr.',
                        'letterName' => 'Dear Mr.',
                    ],
                    'createdAt' => '2021-03-09T09:43:59.659+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                ],
                'defaultBillingAddress' => null,
                'defaultShippingAddress' => null,
                'activeBillingAddress' => null,
                'activeShippingAddress' => null,
                'addresses' => [
                    0 => [
                        'customerId' => '580c15d36d6e4b959b5a5ce9074dae08',
                        'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                        'countryStateId' => '4629fdb36d08457fadb88272fd3c7d2b',
                        'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'zipcode' => '12345',
                        'city' => 'Musterstadt',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'street' => 'Musterstr. 2',
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => null,
                        'countryState' => null,
                        'salutation' => null,
                        'customer' => null,
                        'customFields' => null,
                        '_uniqueIdentifier' => 'a97c45ffcb3246b18a57dff85ebf440e',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-29T14:55:28.884+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'a97c45ffcb3246b18a57dff85ebf440e',
                    ],
                ],
                'orderCustomers' => null,
                'autoIncrement' => 63,
                'tags' => null,
                'tagIds' => null,
                'promotions' => null,
                'recoveryCustomer' => null,
                'customFields' => null,
                'productReviews' => null,
                'remoteAddress' => null,
                'requestedGroupId' => null,
                'requestedGroup' => null,
                'boundSalesChannelId' => null,
                'boundSalesChannel' => null,
                'wishlists' => null,
                '_uniqueIdentifier' => '580c15d36d6e4b959b5a5ce9074dae08',
                'versionId' => null,
                'translated' => [
                ],
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '580c15d36d6e4b959b5a5ce9074dae08',
            ],
            'confirmUrl' => 'http://localhost/development/public/registration/confirm?em=168ce4e90d20a42282c682e2383dda1c3eafc23a&hash=6cf0a92813a6465ca445a1039b04fcae&redirectTo=frontend.checkout.confirm.page',
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $customerRecoveryRequest = [
            'customerRecovery' => [
                'id' => 'fffd09464d864770b9ce54e4e8601d7c',
                'customerId' => '51555310038a427a8fcc361433d5784e',
                'hash' => 'Rx33F2DRjmJDHg19tFhtTgMq8tFq0fMF',
                'customer' => [
                    'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                    'defaultPaymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                    'salesChannelId' => '98432def39fc4624b33213a56b8c944d',
                    'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                    'lastPaymentMethodId' => null,
                    'defaultBillingAddressId' => '85f5178d031147fc9847d99b3bb7d5e0',
                    'defaultShippingAddressId' => 'f5299cbf329d4bd1a092f32bb59b0c31',
                    'customerNumber' => '1337',
                    'salutationId' => '44706b43d8bd4b34a4582185c3fd07f1',
                    'firstName' => 'Max',
                    'lastName' => 'Mustermann',
                    'company' => null,
                    'email' => 'test@example.com',
                    'title' => null,
                    'vatIds' => null,
                    'affiliateCode' => null,
                    'campaignCode' => null,
                    'active' => true,
                    'doubleOptInRegistration' => false,
                    'doubleOptInEmailSentDate' => null,
                    'doubleOptInConfirmDate' => null,
                    'hash' => null,
                    'guest' => false,
                    'firstLogin' => null,
                    'lastLogin' => '2021-03-29T08:52:46.863+00:00',
                    'newsletter' => false,
                    'birthday' => null,
                    'lastOrderDate' => '2021-03-29T12:34:22.655+00:00',
                    'orderCount' => 18,
                    'createdAt' => '2021-03-09T09:45:15.280+00:00',
                    'updatedAt' => '2021-03-29T12:34:22.916+00:00',
                    'legacyEncoder' => null,
                    'legacyPassword' => null,
                    'group' => null,
                    'defaultPaymentMethod' => null,
                    'salesChannel' => null,
                    'language' => null,
                    'lastPaymentMethod' => null,
                    'salutation' => null,
                    'defaultBillingAddress' => null,
                    'defaultShippingAddress' => null,
                    'activeBillingAddress' => null,
                    'activeShippingAddress' => null,
                    'addresses' => null,
                    'orderCustomers' => null,
                    'autoIncrement' => 61,
                    'tags' => null,
                    'tagIds' => null,
                    'promotions' => null,
                    'recoveryCustomer' => null,
                    'customFields' => null,
                    'productReviews' => null,
                    'remoteAddress' => '::',
                    'requestedGroupId' => null,
                    'requestedGroup' => null,
                    'boundSalesChannelId' => null,
                    'boundSalesChannel' => null,
                    'wishlists' => null,
                    '_uniqueIdentifier' => '51555310038a427a8fcc361433d5784e',
                    'versionId' => null,
                    'translated' => [
                    ],
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '51555310038a427a8fcc361433d5784e',
                ],
                '_uniqueIdentifier' => 'fffd09464d864770b9ce54e4e8601d7c',
                'versionId' => null,
                'translated' => [
                ],
                'createdAt' => '2021-03-29T12:38:47.091+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
            ],
            'resetUrl' => 'http://localhost/development/public/account/recover/password?hash=Rx33F2DRjmJDHg19tFhtTgMq8tFq0fMF',
            'shopName' => 'Storefront',
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $customerGroupRegistration = [
            'customer' => [
                'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'defaultPaymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'lastPaymentMethodId' => null,
                'defaultBillingAddressId' => 'ad730ece18104f0e924808946e0e11ff',
                'defaultShippingAddressId' => 'ad730ece18104f0e924808946e0e11ff',
                'customerNumber' => '10062',
                'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'company' => null,
                'email' => 'tester@example.com',
                'title' => null,
                'vatIds' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'active' => false,
                'doubleOptInRegistration' => true,
                'doubleOptInEmailSentDate' => '2021-03-29T15:13:15.367+00:00',
                'doubleOptInConfirmDate' => null,
                'hash' => '37111679d6344c94b29fe63e5e90dcae',
                'guest' => false,
                'firstLogin' => '2021-03-29T15:13:15.361+00:00',
                'lastLogin' => null,
                'newsletter' => false,
                'birthday' => null,
                'lastOrderDate' => null,
                'orderCount' => 0,
                'createdAt' => '2021-03-29T15:13:15.590+00:00',
                'updatedAt' => null,
                'legacyEncoder' => null,
                'legacyPassword' => null,
                'group' => null,
                'defaultPaymentMethod' => null,
                'salesChannel' => null,
                'language' => null,
                'lastPaymentMethod' => null,
                'salutation' => [
                    'salutationKey' => 'mr',
                    'displayName' => 'Mr.',
                    'letterName' => 'Dear Mr.',
                    'translations' => null,
                    'customers' => null,
                    'customerAddresses' => null,
                    'orderCustomers' => null,
                    'orderAddresses' => null,
                    'newsletterRecipients' => null,
                    '_uniqueIdentifier' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                    'versionId' => null,
                    'translated' => [
                        'displayName' => 'Mr.',
                        'letterName' => 'Dear Mr.',
                    ],
                    'createdAt' => '2021-03-09T09:43:59.659+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                ],
                'defaultBillingAddress' => null,
                'defaultShippingAddress' => null,
                'activeBillingAddress' => null,
                'activeShippingAddress' => null,
                'addresses' => null,
                'orderCustomers' => null,
                'autoIncrement' => 64,
                'tags' => null,
                'tagIds' => null,
                'promotions' => null,
                'recoveryCustomer' => null,
                'customFields' => null,
                'productReviews' => null,
                'remoteAddress' => null,
                'requestedGroupId' => '9cac9e9ec9be4b12a6159a69d76dd41b',
                'requestedGroup' => [
                    'name' => 'Net price customer group',
                    'displayGross' => false,
                    'translations' => null,
                    'customers' => null,
                    'customFields' => null,
                    'salesChannels' => null,
                    'registrationActive' => true,
                    'registrationTitle' => 'Registration Form',
                    'registrationIntroduction' => null,
                    'registrationOnlyCompanyRegistration' => null,
                    'registrationSeoMetaDescription' => null,
                    'registrationSalesChannels' => null,
                    '_uniqueIdentifier' => '9cac9e9ec9be4b12a6159a69d76dd41b',
                    'versionId' => null,
                    'translated' => [
                        'name' => 'Net price customer group',
                        'customFields' => [
                        ],
                        'registrationTitle' => 'Registration Form',
                        'registrationIntroduction' => null,
                        'registrationOnlyCompanyRegistration' => null,
                        'registrationSeoMetaDescription' => null,
                    ],
                    'createdAt' => '2021-03-09T09:45:01.370+00:00',
                    'updatedAt' => '2021-03-29T15:08:34.004+00:00',
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '9cac9e9ec9be4b12a6159a69d76dd41b',
                ],
                'boundSalesChannelId' => null,
                'boundSalesChannel' => null,
                'wishlists' => null,
                '_uniqueIdentifier' => '7088b93c2cde497ea41becdffa61fe50',
                'versionId' => null,
                'translated' => [
                ],
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '7088b93c2cde497ea41becdffa61fe50',
            ],
            'customerGroup' => [
                'name' => 'Net price customer group',
                'displayGross' => false,
                'translations' => null,
                'customers' => null,
                'customFields' => null,
                'salesChannels' => null,
                'registrationActive' => true,
                'registrationTitle' => 'Registration Form',
                'registrationIntroduction' => null,
                'registrationOnlyCompanyRegistration' => null,
                'registrationSeoMetaDescription' => null,
                'registrationSalesChannels' => null,
                '_uniqueIdentifier' => '9cac9e9ec9be4b12a6159a69d76dd41b',
                'versionId' => null,
                'translated' => [
                    'name' => 'Net price customer group',
                    'customFields' => [
                    ],
                    'registrationTitle' => 'Registration Form',
                    'registrationIntroduction' => null,
                    'registrationOnlyCompanyRegistration' => null,
                    'registrationSeoMetaDescription' => null,
                ],
                'createdAt' => '2021-03-09T09:45:01.370+00:00',
                'updatedAt' => '2021-03-29T15:08:34.004+00:00',
                'extensions' => [
                    'internal_mapping_storage' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '9cac9e9ec9be4b12a6159a69d76dd41b',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $contactForm = [
            'contactFormData' => [
                'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'email' => 'test@example.com',
                'phone' => '+0123456789',
                'subject' => 'Test',
                'comment' => 'This is a test',
                'shopware_surname_confirm' => '',
                'privacy' => 'on',
                '_csrf_token' => 'tcSNom-N6vUHL-CpJgpX5cEVsZciGv120ItEOj10ydw',
                'slotId' => 'a80d8f95414146eea8db85d173b74b2b',
                'salutation' => [
                    'salutationKey' => 'mr',
                    'displayName' => 'Mr.',
                    'letterName' => 'Dear Mr.',
                    'translations' => null,
                    'customers' => null,
                    'customerAddresses' => null,
                    'orderCustomers' => null,
                    'orderAddresses' => null,
                    'newsletterRecipients' => null,
                    '_uniqueIdentifier' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                    'versionId' => null,
                    'translated' => [
                        'displayName' => 'Mr.',
                        'letterName' => 'Dear Mr.',
                    ],
                    'createdAt' => '2021-03-09T09:43:59.659+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                ],
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $newsletterRegister = [
            'newsletterRecipient' => [
                'email' => 'test@example.com',
                'title' => null,
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'zipCode' => '48624',
                'city' => 'Schöppingen',
                'street' => null,
                'status' => 'direct',
                'hash' => '7ee7a7cb1fb741f387b07f4b86a67124',
                'salutationId' => '44706b43d8bd4b34a4582185c3fd07f1',
                'salutation' => null,
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'language' => null,
                'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'salesChannel' => null,
                'customFields' => null,
                'confirmedAt' => null,
                'tags' => null,
                '_uniqueIdentifier' => 'e622fb2224fc4baa9125e0bfd0f2a927',
                'versionId' => null,
                'translated' => [
                ],
                'createdAt' => '2021-03-29T15:10:10.880+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e622fb2224fc4baa9125e0bfd0f2a927',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $userRecoveryRequest = [
            'userRecovery' => [
                'id' => 'a778b433026e4fcbb6c43eeeba788bf7',
                'userId' => '2ea03ac62c1146b588830e0ad467c239',
                'hash' => '7vtxAG9bHk1osCgF4BK53Upn9HYoC8P2',
                'user' => [
                    'localeId' => '8d737b02c2b747a1a3ffca3907751d99',
                    'avatarId' => null,
                    'username' => 'admin',
                    'firstName' => 'Max',
                    'lastName' => 'Mustermann',
                    'title' => null,
                    'email' => 'testing@example.com',
                    'active' => true,
                    'admin' => true,
                    'aclRoles' => null,
                    'locale' => null,
                    'avatarMedia' => null,
                    'media' => null,
                    'accessKeys' => null,
                    'configs' => null,
                    'stateMachineHistoryEntries' => null,
                    'importExportLogEntries' => null,
                    'recoveryUser' => null,
                    'storeToken' => null,
                    'lastUpdatedPasswordAt' => null,
                    'customFields' => null,
                    'createdOrders' => null,
                    'updatedOrders' => null,
                    '_uniqueIdentifier' => '2ea03ac62c1146b588830e0ad467c239',
                    'versionId' => null,
                    'translated' => [
                    ],
                    'createdAt' => '2021-03-09T09:44:27.222+00:00',
                    'updatedAt' => '2021-03-29T15:25:06.403+00:00',
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => '2ea03ac62c1146b588830e0ad467c239',
                ],
                '_uniqueIdentifier' => 'a778b433026e4fcbb6c43eeeba788bf7',
                'versionId' => null,
                'translated' => [
                ],
                'createdAt' => '2021-03-29T15:25:20.638+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
            ],
            'resetUrl' => 'http://localhost/development/public/admin#/login/user-recovery/7vtxAG9bHk1osCgF4BK53Upn9HYoC8P2',
        ];

        $customerRegistration = [
            'customer' => [
                'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'defaultPaymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'lastPaymentMethodId' => null,
                'defaultBillingAddressId' => 'b8794be7a6d840e99ffc76f17320df2b',
                'defaultShippingAddressId' => 'b8794be7a6d840e99ffc76f17320df2b',
                'customerNumber' => '10060',
                'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'company' => null,
                'email' => 'testing@example.com',
                'title' => null,
                'vatIds' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'active' => true,
                'doubleOptInRegistration' => false,
                'doubleOptInEmailSentDate' => null,
                'doubleOptInConfirmDate' => null,
                'hash' => null,
                'guest' => false,
                'firstLogin' => '2021-03-29T12:53:05.736+00:00',
                'lastLogin' => null,
                'newsletter' => false,
                'birthday' => null,
                'lastOrderDate' => null,
                'orderCount' => 0,
                'createdAt' => '2021-03-29T12:53:05.958+00:00',
                'updatedAt' => null,
                'legacyEncoder' => null,
                'legacyPassword' => null,
                'group' => null,
                'defaultPaymentMethod' => null,
                'salesChannel' => null,
                'language' => null,
                'lastPaymentMethod' => null,
                'salutation' => [
                    'salutationKey' => 'mr',
                    'displayName' => 'Mr.',
                    'letterName' => 'Dear Mr.',
                    'translations' => null,
                    'customers' => null,
                    'customerAddresses' => null,
                    'orderCustomers' => null,
                    'orderAddresses' => null,
                    'newsletterRecipients' => null,
                    '_uniqueIdentifier' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                    'versionId' => null,
                    'translated' => [
                        'displayName' => 'Mr.',
                        'letterName' => 'Dear Mr.',
                    ],
                    'createdAt' => '2021-03-09T09:43:59.659+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                ],
                'defaultBillingAddress' => null,
                'defaultShippingAddress' => null,
                'activeBillingAddress' => null,
                'activeShippingAddress' => null,
                'addresses' => [
                    0 => [
                        'customerId' => 'c3445cbcbcec4678b3f15639a892afd1',
                        'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                        'countryStateId' => null,
                        'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'zipcode' => '12345',
                        'city' => 'Musterstadt',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'street' => 'Musterstr. 2',
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => null,
                        'countryState' => null,
                        'salutation' => null,
                        'customer' => null,
                        'customFields' => null,
                        '_uniqueIdentifier' => 'b8794be7a6d840e99ffc76f17320df2b',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-29T12:53:05.958+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'b8794be7a6d840e99ffc76f17320df2b',
                    ],
                ],
                'orderCustomers' => null,
                'autoIncrement' => 62,
                'tags' => null,
                'tagIds' => null,
                'promotions' => null,
                'recoveryCustomer' => null,
                'customFields' => null,
                'productReviews' => null,
                'remoteAddress' => null,
                'requestedGroupId' => null,
                'requestedGroup' => null,
                'boundSalesChannelId' => null,
                'boundSalesChannel' => null,
                'wishlists' => null,
                '_uniqueIdentifier' => 'c3445cbcbcec4678b3f15639a892afd1',
                'versionId' => null,
                'translated' => [
                ],
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'c3445cbcbcec4678b3f15639a892afd1',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $customerGroupChange = [
            'customer' => [
                'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'defaultPaymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'lastPaymentMethodId' => null,
                'defaultBillingAddressId' => 'b8794be7a6d840e99ffc76f17320df2b',
                'defaultShippingAddressId' => 'b8794be7a6d840e99ffc76f17320df2b',
                'customerNumber' => '10060',
                'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                'firstName' => 'Max',
                'lastName' => 'Mustermann',
                'company' => null,
                'email' => 'testing@example.com',
                'title' => null,
                'vatIds' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'active' => true,
                'doubleOptInRegistration' => false,
                'doubleOptInEmailSentDate' => null,
                'doubleOptInConfirmDate' => null,
                'hash' => null,
                'guest' => false,
                'firstLogin' => '2021-03-29T12:53:05.736+00:00',
                'lastLogin' => null,
                'newsletter' => false,
                'birthday' => null,
                'lastOrderDate' => null,
                'orderCount' => 0,
                'createdAt' => '2021-03-29T12:53:05.958+00:00',
                'updatedAt' => null,
                'legacyEncoder' => null,
                'legacyPassword' => null,
                'group' => null,
                'defaultPaymentMethod' => null,
                'salesChannel' => null,
                'language' => null,
                'lastPaymentMethod' => null,
                'salutation' => [
                    'salutationKey' => 'mr',
                    'displayName' => 'Mr.',
                    'letterName' => 'Dear Mr.',
                    'translations' => null,
                    'customers' => null,
                    'customerAddresses' => null,
                    'orderCustomers' => null,
                    'orderAddresses' => null,
                    'newsletterRecipients' => null,
                    '_uniqueIdentifier' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                    'versionId' => null,
                    'translated' => [
                        'displayName' => 'Mr.',
                        'letterName' => 'Dear Mr.',
                    ],
                    'createdAt' => '2021-03-09T09:43:59.659+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                ],
                'defaultBillingAddress' => null,
                'defaultShippingAddress' => null,
                'activeBillingAddress' => null,
                'activeShippingAddress' => null,
                'addresses' => [
                    0 => [
                        'customerId' => 'c3445cbcbcec4678b3f15639a892afd1',
                        'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                        'countryStateId' => null,
                        'salutationId' => 'bd3fd9c43c754e02a11d92b7f7cedc4f',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'zipcode' => '12345',
                        'city' => 'Musterstadt',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'street' => 'Musterstr. 2',
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => null,
                        'countryState' => null,
                        'salutation' => null,
                        'customer' => null,
                        'customFields' => null,
                        '_uniqueIdentifier' => 'b8794be7a6d840e99ffc76f17320df2b',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-29T12:53:05.958+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'b8794be7a6d840e99ffc76f17320df2b',
                    ],
                ],
                'orderCustomers' => null,
                'autoIncrement' => 62,
                'tags' => null,
                'tagIds' => null,
                'promotions' => null,
                'recoveryCustomer' => null,
                'customFields' => null,
                'productReviews' => null,
                'remoteAddress' => null,
                'requestedGroupId' => null,
                'requestedGroup' => null,
                'boundSalesChannelId' => null,
                'boundSalesChannel' => null,
                'wishlists' => null,
                '_uniqueIdentifier' => 'c3445cbcbcec4678b3f15639a892afd1',
                'versionId' => null,
                'translated' => [
                ],
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'c3445cbcbcec4678b3f15639a892afd1',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => 'cf7892d60b794b65b7badae58462715b',
                'shippingMethodId' => '71ebb873740e4f44a9f49a3229961a69',
                'countryId' => 'c0da63f63ceb4d8ebaa5874dbe48f5dc',
                'navigationCategoryId' => 'edffcfe389e84a5aaa40c56874f97e39',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCAETKEFPZSJJHZVBNQ2D6YG',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => '530d80c5293b402d84fe903b9579eb19',
                        'snippetSet' => null,
                        'salesChannelId' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => 'c448b63e00d448ca939b311edce409d3',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-03-09T09:44:27.960+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'c448b63e00d448ca939b311edce409d3',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => 'a4386b473b24419591511f2d60cda25f',
                    1 => 'bfb351a897eb4a699c7c1d6718e1674b',
                    2 => 'cf7892d60b794b65b7badae58462715b',
                    3 => 'eee8328b1c3240a8873fe99723dcdf27',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-03-09T09:44:27.960+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e87ba37297a94629abc2be5ea1d0a1e0',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $orderConfirmation = [
            'order' => [
                'orderNumber' => '10060',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'currencyFactor' => 1.0,
                'salesChannelId' => '08757990bf314633b5d0fa55efc5e63d',
                'billingAddressId' => '3e112279819f4c1d8f5d7107f6b33a25',
                'orderDateTime' => '2021-04-12T08:39:51.371+00:00',
                'orderDate' => '2021-04-12T00:00:00.000+00:00',
                'price' => [
                    'netPrice' => 799.07,
                    'totalPrice' => 855.0,
                    'calculatedTaxes' => [
                        0 => [
                            'tax' => 55.93,
                            'taxRate' => 7.0,
                            'price' => 855.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'taxRules' => [
                        0 => [
                            'taxRate' => 7.0,
                            'percentage' => 100.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'positionPrice' => 855.0,
                    'taxStatus' => 'gross',
                    'rawTotal' => 855.0,
                    'extensions' => [
                    ],
                ],
                'amountTotal' => 855.0,
                'amountNet' => 799.07,
                'positionPrice' => 855.0,
                'taxStatus' => 'gross',
                'shippingCosts' => [
                    'unitPrice' => 0.0,
                    'quantity' => 1,
                    'totalPrice' => 0.0,
                    'calculatedTaxes' => [
                        0 => [
                            'tax' => 0.0,
                            'taxRate' => 7.0,
                            'price' => 0.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'taxRules' => [
                        0 => [
                            'taxRate' => 7.0,
                            'percentage' => 100.0,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'referencePrice' => null,
                    'listPrice' => null,
                    'extensions' => [
                    ],
                ],
                'shippingTotal' => 0.0,
                'orderCustomer' => [
                    'email' => 'test@example.com',
                    'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                    'salutationId' => '4f602c9cb4994a7a96a06630d9f62cee',
                    'firstName' => 'Max',
                    'lastName' => 'Mustermann',
                    'title' => null,
                    'vatIds' => null,
                    'company' => null,
                    'customerNumber' => '1337',
                    'customerId' => '7f0eef7a233a41f886a2fc69b0ca79df',
                    'customer' => [
                        'groupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                        'defaultPaymentMethodId' => '69867b98038e4d41bde2382bbb5810fc',
                        'salesChannelId' => '98432def39fc4624b33213a56b8c944d',
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'lastPaymentMethodId' => null,
                        'defaultBillingAddressId' => 'c9036a6e1bf84f769f06d0ba6490d75b',
                        'defaultShippingAddressId' => '3fc4a0d7787c466daeb6fade1b51c4fd',
                        'customerNumber' => '1337',
                        'salutationId' => '4f602c9cb4994a7a96a06630d9f62cee',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'company' => null,
                        'password' => '$2y$10$9xvO2tM3dEfcOG4lO9CA3eogJD1wkYhW7erQv0d14AAUA9u0V5Dpy',
                        'email' => 'test@example.com',
                        'title' => null,
                        'vatIds' => null,
                        'affiliateCode' => null,
                        'campaignCode' => null,
                        'active' => true,
                        'doubleOptInRegistration' => false,
                        'doubleOptInEmailSentDate' => null,
                        'doubleOptInConfirmDate' => null,
                        'hash' => null,
                        'guest' => false,
                        'firstLogin' => null,
                        'lastLogin' => '2021-04-12T08:39:36.376+00:00',
                        'newsletter' => false,
                        'birthday' => null,
                        'lastOrderDate' => '2021-04-12T08:39:51.371+00:00',
                        'orderCount' => 4,
                        'createdAt' => '2021-04-12T07:54:30.118+00:00',
                        'updatedAt' => '2021-04-12T08:39:51.671+00:00',
                        'legacyEncoder' => null,
                        'legacyPassword' => null,
                        'group' => null,
                        'defaultPaymentMethod' => null,
                        'salesChannel' => null,
                        'language' => null,
                        'lastPaymentMethod' => null,
                        'salutation' => null,
                        'defaultBillingAddress' => null,
                        'defaultShippingAddress' => null,
                        'activeBillingAddress' => null,
                        'activeShippingAddress' => null,
                        'addresses' => null,
                        'orderCustomers' => null,
                        'autoIncrement' => 61,
                        'tags' => null,
                        'tagIds' => null,
                        'promotions' => null,
                        'recoveryCustomer' => null,
                        'customFields' => null,
                        'productReviews' => null,
                        'remoteAddress' => '::',
                        'requestedGroupId' => null,
                        'requestedGroup' => null,
                        'boundSalesChannelId' => null,
                        'boundSalesChannel' => null,
                        'wishlists' => null,
                        '_uniqueIdentifier' => '7f0eef7a233a41f886a2fc69b0ca79df',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'extensions' => [
                            'internal_mapping_storage' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '7f0eef7a233a41f886a2fc69b0ca79df',
                    ],
                    'salutation' => [
                        'salutationKey' => 'not_specified',
                        'displayName' => 'Not specified',
                        'letterName' => ' ',
                        'translations' => null,
                        'customers' => null,
                        'customerAddresses' => null,
                        'orderCustomers' => null,
                        'orderAddresses' => null,
                        'newsletterRecipients' => null,
                        '_uniqueIdentifier' => '4f602c9cb4994a7a96a06630d9f62cee',
                        'versionId' => null,
                        'translated' => [
                            'displayName' => 'Not specified',
                            'letterName' => ' ',
                        ],
                        'createdAt' => '2021-04-12T07:52:38.207+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'internal_mapping_storage' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '4f602c9cb4994a7a96a06630d9f62cee',
                    ],
                    'order' => null,
                    'customFields' => null,
                    'remoteAddress' => '::',
                    '_uniqueIdentifier' => 'e61b6f06cbe5421ebb41d428ce457ac2',
                    'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    'translated' => [
                    ],
                    'createdAt' => '2021-04-12T08:39:51.542+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'e61b6f06cbe5421ebb41d428ce457ac2',
                    'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                ],
                'currency' => [
                    'isoCode' => 'EUR',
                    'factor' => 1.0,
                    'symbol' => '€',
                    'shortName' => 'EUR',
                    'name' => 'Euro',
                    'position' => 1,
                    'translations' => null,
                    'orders' => null,
                    'salesChannels' => null,
                    'salesChannelDefaultAssignments' => null,
                    'salesChannelDomains' => null,
                    'customFields' => null,
                    'shippingMethodPrices' => null,
                    'promotionDiscountPrices' => null,
                    'isSystemDefault' => true,
                    'productExports' => null,
                    'countryRoundings' => null,
                    'itemRounding' => [
                        'decimals' => 2,
                        'interval' => 0.01,
                        'roundForNet' => true,
                        'extensions' => [
                        ],
                    ],
                    'totalRounding' => [
                        'decimals' => 2,
                        'interval' => 0.01,
                        'roundForNet' => true,
                        'extensions' => [
                        ],
                    ],
                    '_uniqueIdentifier' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                    'versionId' => null,
                    'translated' => [
                        'shortName' => 'EUR',
                        'name' => 'Euro',
                        'customFields' => [
                        ],
                    ],
                    'createdAt' => '2021-04-12T07:52:38.772+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                ],
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'language' => null,
                'salesChannel' => null,
                'addresses' => [
                    0 => [
                        'countryId' => 'f68b900afd7644dfb8b7f5392183efd9',
                        'countryStateId' => null,
                        'salutationId' => '4f602c9cb4994a7a96a06630d9f62cee',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'street' => 'Bahnhofstraße 27',
                        'zipcode' => '10332',
                        'city' => 'Berlin',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'vatId' => null,
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => [
                            'name' => 'Saint Barthélemy',
                            'iso' => 'BL',
                            'position' => 10,
                            'taxFree' => false,
                            'active' => true,
                            'shippingAvailable' => true,
                            'iso3' => 'BLM',
                            'displayStateInRegistration' => false,
                            'forceStateInRegistration' => false,
                            'companyTaxFree' => false,
                            'checkVatIdPattern' => false,
                            'vatIdPattern' => null,
                            'states' => null,
                            'translations' => null,
                            'orderAddresses' => null,
                            'customerAddresses' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'taxRules' => null,
                            'currencyCountryRoundings' => null,
                            '_uniqueIdentifier' => 'f68b900afd7644dfb8b7f5392183efd9',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Saint Barthélemy',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-12T07:52:46.949+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'f68b900afd7644dfb8b7f5392183efd9',
                        ],
                        'countryState' => null,
                        'order' => null,
                        'salutation' => null,
                        'orderDeliveries' => null,
                        'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                        'customFields' => null,
                        '_uniqueIdentifier' => '3e112279819f4c1d8f5d7107f6b33a25',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T08:39:51.556+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '3e112279819f4c1d8f5d7107f6b33a25',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                    1 => [
                        'countryId' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                        'countryStateId' => null,
                        'salutationId' => '4f602c9cb4994a7a96a06630d9f62cee',
                        'firstName' => 'Max',
                        'lastName' => 'Mustermann',
                        'street' => 'Ebbinghoff 10',
                        'zipcode' => '48624',
                        'city' => 'Schöppingen',
                        'company' => null,
                        'department' => null,
                        'title' => null,
                        'vatId' => null,
                        'phoneNumber' => null,
                        'additionalAddressLine1' => null,
                        'additionalAddressLine2' => null,
                        'country' => [
                            'name' => 'Kazakhstan',
                            'iso' => 'KZ',
                            'position' => 10,
                            'taxFree' => false,
                            'active' => true,
                            'shippingAvailable' => true,
                            'iso3' => 'KAZ',
                            'displayStateInRegistration' => false,
                            'forceStateInRegistration' => false,
                            'companyTaxFree' => false,
                            'checkVatIdPattern' => false,
                            'vatIdPattern' => null,
                            'states' => null,
                            'translations' => null,
                            'orderAddresses' => null,
                            'customerAddresses' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'taxRules' => null,
                            'currencyCountryRoundings' => null,
                            '_uniqueIdentifier' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Kazakhstan',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-12T07:52:46.847+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                        ],
                        'countryState' => null,
                        'order' => null,
                        'salutation' => null,
                        'orderDeliveries' => null,
                        'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                        'customFields' => null,
                        '_uniqueIdentifier' => '7796bf226130426fb71bef6270dcf8e3',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T08:39:51.561+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '7796bf226130426fb71bef6270dcf8e3',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'billingAddress' => null,
                'deliveries' => [
                    0 => [
                        'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                        'shippingOrderAddressId' => '7796bf226130426fb71bef6270dcf8e3',
                        'shippingMethodId' => '7ab645770dbb4a648268248492ed5f0a',
                        'trackingCodes' => [
                        ],
                        'shippingDateEarliest' => '2021-04-13T00:00:00.000+00:00',
                        'shippingDateLatest' => '2021-04-15T00:00:00.000+00:00',
                        'shippingCosts' => [
                            'unitPrice' => 0.0,
                            'quantity' => 1,
                            'totalPrice' => 0.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 0.0,
                                    'taxRate' => 7.0,
                                    'price' => 0.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 7.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'shippingOrderAddress' => [
                            'countryId' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                            'countryStateId' => null,
                            'salutationId' => '4f602c9cb4994a7a96a06630d9f62cee',
                            'firstName' => 'Max',
                            'lastName' => 'Mustermann',
                            'street' => 'Ebbinghoff 10',
                            'zipcode' => '48624',
                            'city' => 'Schöppingen',
                            'company' => null,
                            'department' => null,
                            'title' => null,
                            'vatId' => null,
                            'phoneNumber' => null,
                            'additionalAddressLine1' => null,
                            'additionalAddressLine2' => null,
                            'country' => [
                                'name' => 'Kazakhstan',
                                'iso' => 'KZ',
                                'position' => 10,
                                'taxFree' => false,
                                'active' => true,
                                'shippingAvailable' => true,
                                'iso3' => 'KAZ',
                                'displayStateInRegistration' => false,
                                'forceStateInRegistration' => false,
                                'companyTaxFree' => false,
                                'checkVatIdPattern' => false,
                                'vatIdPattern' => null,
                                'states' => null,
                                'translations' => null,
                                'orderAddresses' => null,
                                'customerAddresses' => null,
                                'salesChannelDefaultAssignments' => null,
                                'salesChannels' => null,
                                'customFields' => null,
                                'taxRules' => null,
                                'currencyCountryRoundings' => null,
                                '_uniqueIdentifier' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                                'versionId' => null,
                                'translated' => [
                                    'name' => 'Kazakhstan',
                                    'customFields' => [
                                    ],
                                ],
                                'createdAt' => '2021-04-12T07:52:46.847+00:00',
                                'updatedAt' => null,
                                'extensions' => [
                                    'internal_mapping_storage' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                    'foreignKeys' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                ],
                                'id' => 'bf7fe4dae0aa4ebcb28f8e91a4aabc8b',
                            ],
                            'countryState' => null,
                            'order' => null,
                            'salutation' => null,
                            'orderDeliveries' => null,
                            'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                            'customFields' => null,
                            '_uniqueIdentifier' => '7796bf226130426fb71bef6270dcf8e3',
                            'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                            'translated' => [
                            ],
                            'createdAt' => '2021-04-12T08:39:51.561+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '7796bf226130426fb71bef6270dcf8e3',
                            'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        ],
                        'stateId' => '4753bf682a1640d8a89ca672f3982b1b',
                        'stateMachineState' => [
                            'name' => 'Open',
                            'technicalName' => 'open',
                            'stateMachineId' => '2669c221e38a477980f8bef5e9cccdaf',
                            'stateMachine' => null,
                            'fromStateMachineTransitions' => null,
                            'toStateMachineTransitions' => null,
                            'translations' => null,
                            'orders' => null,
                            'orderTransactions' => null,
                            'orderDeliveries' => null,
                            'fromStateMachineHistoryEntries' => null,
                            'toStateMachineHistoryEntries' => null,
                            'customFields' => null,
                            '_uniqueIdentifier' => '4753bf682a1640d8a89ca672f3982b1b',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Open',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-12T07:52:39.108+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '4753bf682a1640d8a89ca672f3982b1b',
                        ],
                        'shippingMethod' => [
                            'name' => 'Standard',
                            'active' => true,
                            'description' => null,
                            'trackingUrl' => null,
                            'deliveryTimeId' => 'd5352c5bdd10417db10125050af38b64',
                            'deliveryTime' => [
                                'name' => '1-3 days',
                                'min' => 1,
                                'max' => 3,
                                'unit' => 'day',
                                'shippingMethods' => null,
                                'translations' => null,
                                'customFields' => null,
                                'products' => null,
                                '_uniqueIdentifier' => 'd5352c5bdd10417db10125050af38b64',
                                'versionId' => null,
                                'translated' => [
                                    'name' => '1-3 days',
                                    'customFields' => [
                                    ],
                                ],
                                'createdAt' => '2021-04-12T07:52:38.000+00:00',
                                'updatedAt' => null,
                                'extensions' => [
                                    'internal_mapping_storage' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                    'foreignKeys' => [
                                        'apiAlias' => null,
                                        'extensions' => [
                                        ],
                                    ],
                                ],
                                'id' => 'd5352c5bdd10417db10125050af38b64',
                            ],
                            'translations' => null,
                            'orderDeliveries' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'customFields' => null,
                            'availabilityRule' => null,
                            'availabilityRuleId' => '132058274b4c4ba5b292e78b79e7fd90',
                            'prices' => [
                            ],
                            'mediaId' => null,
                            'taxId' => null,
                            'media' => null,
                            'tags' => null,
                            'taxType' => 'auto',
                            'tax' => null,
                            '_uniqueIdentifier' => '7ab645770dbb4a648268248492ed5f0a',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Standard',
                                'customFields' => [
                                ],
                                'description' => null,
                                'trackingUrl' => null,
                            ],
                            'createdAt' => '2021-04-12T07:52:38.814+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '7ab645770dbb4a648268248492ed5f0a',
                        ],
                        'order' => null,
                        'positions' => null,
                        'customFields' => null,
                        '_uniqueIdentifier' => '35bf2776cc6c4857980ed8a651bf6060',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T08:39:51.565+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '35bf2776cc6c4857980ed8a651bf6060',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'shippingOrderAddressVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'lineItems' => [
                    0 => [
                        'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                        'identifier' => 'f47e72bf6d0e40c4aa290330a7ffd44d',
                        'referencedId' => 'f47e72bf6d0e40c4aa290330a7ffd44d',
                        'productId' => 'f47e72bf6d0e40c4aa290330a7ffd44d',
                        'quantity' => 1,
                        'unitPrice' => 855.0,
                        'totalPrice' => 855.0,
                        'label' => 'Aerodynamic Cotton Brand Muffin',
                        'description' => null,
                        'good' => true,
                        'removable' => true,
                        'coverId' => '5f3c1ac1ce3744009cc8613f1524fc80',
                        'stackable' => true,
                        'position' => 1,
                        'price' => [
                            'unitPrice' => 855.0,
                            'quantity' => 1,
                            'totalPrice' => 855.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 55.93,
                                    'taxRate' => 7.0,
                                    'price' => 855.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 7.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'priceDefinition' => [
                            'price' => 855.0,
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 7.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'quantity' => 1,
                            'isCalculated' => true,
                            'referencePriceDefinition' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                            'type' => 'quantity',
                        ],
                        'payload' => [
                            'isNew' => false,
                            'taxId' => '40afe75845934469b3528a06573bd395',
                            'tagIds' => null,
                            'options' => [
                            ],
                            'features' => [
                            ],
                            'createdAt' => '2021-04-12 07:54:39.961',
                            'optionIds' => null,
                            'isCloseout' => false,
                            'categoryIds' => [
                                0 => 'e38a91bb89b94313acd546bb813c9bde',
                                1 => 'f5fd0ad1b7904012adeab43c5571249f',
                                2 => '1f232fdf7e744a6188e70373c64059ec',
                            ],
                            'propertyIds' => [
                                0 => '08342bf3c949475081380d7f18ac3013',
                                1 => '1f4a747cd9084a91b5b3354483f64d5c',
                                2 => '242c6322e09642db9a6dd34e4945563b',
                                3 => '2f8fdf5146e3495b93f1477a13b30a70',
                                4 => '33443da934024d7d9a4e949f2dbade33',
                                5 => '38414ab339ae45e8a34c742f74ca951c',
                                6 => '517fa1113cc749cb82acca7a7a911f51',
                                7 => '5db7f83261c746818e2cb119d7b690e3',
                                8 => '6b463dcccdcf44b69c1d64aaa99f465a',
                                9 => '7b0924b10e6c4e7c8cebb21f779014fe',
                                10 => '95746abcc9fe46cc93277210e7184e38',
                                11 => '98a65897b93440e7b5f848e51efa53df',
                                12 => 'ad24e8a73b0f4018827e267346c08254',
                                13 => 'af8b23072130451b8a80b1a94af2a529',
                                14 => 'c021d77e23eb44568bd321158519b807',
                                15 => 'e4a316f3eaf64983a6af02654f7d2fc7',
                                16 => 'fdfb81dcdbb2400aab7ac18e9c967350',
                                17 => 'fe4960c9a2df4bfd9e977b473983bd86',
                            ],
                            'releaseDate' => null,
                            'customFields' => [
                            ],
                            'productNumber' => 'dc0f18c1a31f4f189e7ef7d921052fe6',
                            'manufacturerId' => '0f721bed5f054043a2b5d0986f55757c',
                            'purchasePrices' => '{"currencyId":"b7d2554b0ce847cd82f3ac9bd1c0dfca","net":31.570093457943923,"gross":33.78,"linked":true,"listPrice":null,"extensions":[]}',
                            'markAsTopseller' => null,
                        ],
                        'parentId' => null,
                        'type' => 'product',
                        'order' => null,
                        'orderDeliveryPositions' => null,
                        'customFields' => null,
                        'cover' => null,
                        'children' => null,
                        'product' => null,
                        '_uniqueIdentifier' => '2095623819c546a2893afe2db1557bec',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T08:39:51.572+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '2095623819c546a2893afe2db1557bec',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'productVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'parentVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'transactions' => [
                    0 => [
                        'orderId' => 'e96e47f99c844f1b9997e613bc621f65',
                        'paymentMethodId' => '69867b98038e4d41bde2382bbb5810fc',
                        'amount' => [
                            'unitPrice' => 855.0,
                            'quantity' => 1,
                            'totalPrice' => 855.0,
                            'calculatedTaxes' => [
                                0 => [
                                    'tax' => 55.93,
                                    'taxRate' => 7.0,
                                    'price' => 855.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'taxRules' => [
                                0 => [
                                    'taxRate' => 7.0,
                                    'percentage' => 100.0,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'referencePrice' => null,
                            'listPrice' => null,
                            'extensions' => [
                            ],
                        ],
                        'paymentMethod' => [
                            'pluginId' => null,
                            'handlerIdentifier' => CashPayment::class,
                            'name' => 'Cash on delivery',
                            'description' => 'Payment upon receipt of goods.',
                            'position' => 1,
                            'active' => true,
                            'afterOrderEnabled' => true,
                            'plugin' => null,
                            'translations' => null,
                            'orderTransactions' => null,
                            'customers' => null,
                            'salesChannelDefaultAssignments' => null,
                            'salesChannels' => null,
                            'availabilityRule' => null,
                            'availabilityRuleId' => null,
                            'mediaId' => null,
                            'media' => null,
                            'customFields' => null,
                            'formattedHandlerIdentifier' => 'handler_shopware_cashpayment',
                            'shortName' => 'cash_payment',
                            '_uniqueIdentifier' => '69867b98038e4d41bde2382bbb5810fc',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Cash on delivery',
                                'description' => 'Payment upon receipt of goods.',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-12T07:52:38.793+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => '69867b98038e4d41bde2382bbb5810fc',
                        ],
                        'order' => null,
                        'stateMachineState' => [
                            'name' => 'Open',
                            'technicalName' => 'open',
                            'stateMachineId' => '3e52d2ea8045489bbc13528a1cd68170',
                            'stateMachine' => null,
                            'fromStateMachineTransitions' => null,
                            'toStateMachineTransitions' => null,
                            'translations' => null,
                            'orders' => null,
                            'orderTransactions' => null,
                            'orderDeliveries' => null,
                            'fromStateMachineHistoryEntries' => null,
                            'toStateMachineHistoryEntries' => null,
                            'customFields' => null,
                            '_uniqueIdentifier' => 'db5897dec897426985f29b105875e6a8',
                            'versionId' => null,
                            'translated' => [
                                'name' => 'Open',
                                'customFields' => [
                                ],
                            ],
                            'createdAt' => '2021-04-12T07:52:39.129+00:00',
                            'updatedAt' => null,
                            'extensions' => [
                                'internal_mapping_storage' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                                'foreignKeys' => [
                                    'apiAlias' => null,
                                    'extensions' => [
                                    ],
                                ],
                            ],
                            'id' => 'db5897dec897426985f29b105875e6a8',
                        ],
                        'stateId' => 'db5897dec897426985f29b105875e6a8',
                        'customFields' => null,
                        '_uniqueIdentifier' => 'a57d8d1c18f64f55bfb48b39ceec660f',
                        'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T08:39:51.575+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => 'a57d8d1c18f64f55bfb48b39ceec660f',
                        'orderVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                    ],
                ],
                'deepLinkCode' => 's2i1jbau4LeH0R7RUDrzHo8Y7KglbZ_D',
                'autoIncrement' => 61,
                'stateMachineState' => [
                    'name' => 'Open',
                    'technicalName' => 'open',
                    'stateMachineId' => '040ddecd833d4c98a1935f19b5617e8c',
                    'stateMachine' => null,
                    'fromStateMachineTransitions' => null,
                    'toStateMachineTransitions' => null,
                    'translations' => null,
                    'orders' => null,
                    'orderTransactions' => null,
                    'orderDeliveries' => null,
                    'fromStateMachineHistoryEntries' => null,
                    'toStateMachineHistoryEntries' => null,
                    'customFields' => null,
                    '_uniqueIdentifier' => 'ed244ea9e52c4497ab57c4a12b10d962',
                    'versionId' => null,
                    'translated' => [
                        'name' => 'Open',
                        'customFields' => [
                        ],
                    ],
                    'createdAt' => '2021-04-12T07:52:39.066+00:00',
                    'updatedAt' => null,
                    'extensions' => [
                        'internal_mapping_storage' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                        'foreignKeys' => [
                            'apiAlias' => null,
                            'extensions' => [
                            ],
                        ],
                    ],
                    'id' => 'ed244ea9e52c4497ab57c4a12b10d962',
                ],
                'stateId' => 'ed244ea9e52c4497ab57c4a12b10d962',
                'customFields' => null,
                'documents' => null,
                'tags' => null,
                'affiliateCode' => null,
                'campaignCode' => null,
                'customerComment' => null,
                'ruleIds' => [
                    0 => '132058274b4c4ba5b292e78b79e7fd90',
                    1 => '5bbbd6951e8f4c91a8de6544a5fb8ea2',
                    2 => 'b3963d2ae9f04c8ebd7ea09304f6294f',
                    3 => '8583f4c0d9254ea091c8354a180a3a6d',
                ],
                'createdById' => null,
                'createdBy' => null,
                'updatedById' => null,
                'updatedBy' => null,
                'itemRounding' => [
                    'decimals' => 2,
                    'interval' => 0.01,
                    'roundForNet' => true,
                    'extensions' => [
                    ],
                ],
                'totalRounding' => [
                    'decimals' => 2,
                    'interval' => 0.01,
                    'roundForNet' => true,
                    'extensions' => [
                    ],
                ],
                '_uniqueIdentifier' => 'e96e47f99c844f1b9997e613bc621f65',
                'versionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'translated' => [
                ],
                'createdAt' => '2021-04-12T08:39:51.578+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => 'e96e47f99c844f1b9997e613bc621f65',
                'billingAddressVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
            ],
            'salesChannel' => [
                'typeId' => '8a243080f92e4c719546314b577cf82b',
                'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                'paymentMethodId' => '69867b98038e4d41bde2382bbb5810fc',
                'shippingMethodId' => '7ab645770dbb4a648268248492ed5f0a',
                'countryId' => '77304b7727794e1c9460f192a55d66cf',
                'navigationCategoryId' => 'e38a91bb89b94313acd546bb813c9bde',
                'navigationCategoryDepth' => 2,
                'homeSlotConfig' => null,
                'homeCmsPageId' => null,
                'homeCmsPage' => null,
                'homeEnabled' => null,
                'homeName' => null,
                'homeMetaTitle' => null,
                'homeMetaDescription' => null,
                'homeKeywords' => null,
                'footerCategoryId' => null,
                'serviceCategoryId' => null,
                'name' => 'Storefront',
                'shortName' => null,
                'accessKey' => 'SWSCOGFIOGDVTJLZOVZ5WLEWEA',
                'currencies' => null,
                'languages' => null,
                'configuration' => null,
                'active' => true,
                'maintenance' => false,
                'maintenanceIpWhitelist' => null,
                'taxCalculationType' => 'horizontal',
                'type' => null,
                'currency' => null,
                'language' => null,
                'paymentMethod' => null,
                'shippingMethod' => null,
                'country' => null,
                'orders' => null,
                'customers' => null,
                'countries' => null,
                'paymentMethods' => null,
                'shippingMethods' => null,
                'translations' => null,
                'domains' => [
                    0 => [
                        'url' => 'http://localhost/development/public',
                        'currencyId' => 'b7d2554b0ce847cd82f3ac9bd1c0dfca',
                        'currency' => null,
                        'snippetSetId' => 'c6dd40a58bfd4c54979eaf1c6be56cb1',
                        'snippetSet' => null,
                        'salesChannelId' => '08757990bf314633b5d0fa55efc5e63d',
                        'salesChannel' => null,
                        'languageId' => '2fbb5fe2e29a4d70aa5854ce7ce3e20b',
                        'language' => null,
                        'customFields' => null,
                        'productExports' => null,
                        'salesChannelDefaultHreflang' => null,
                        'hreflangUseOnlyLocale' => false,
                        '_uniqueIdentifier' => '46d268ec94c5430295ec21fa5952ca53',
                        'versionId' => null,
                        'translated' => [
                        ],
                        'createdAt' => '2021-04-12T07:53:19.452+00:00',
                        'updatedAt' => null,
                        'extensions' => [
                            'foreignKeys' => [
                                'apiAlias' => null,
                                'extensions' => [
                                ],
                            ],
                        ],
                        'id' => '46d268ec94c5430295ec21fa5952ca53',
                    ],
                ],
                'systemConfigs' => null,
                'customFields' => null,
                'navigationCategory' => null,
                'footerCategory' => null,
                'serviceCategory' => null,
                'productVisibilities' => null,
                'mailHeaderFooterId' => null,
                'numberRangeSalesChannels' => null,
                'mailHeaderFooter' => null,
                'customerGroupId' => 'cfbd5018d38d41d8adca10d94fc8bdd6',
                'customerGroup' => null,
                'newsletterRecipients' => null,
                'promotionSalesChannels' => null,
                'documentBaseConfigSalesChannels' => null,
                'productReviews' => null,
                'seoUrls' => null,
                'seoUrlTemplates' => null,
                'mainCategories' => null,
                'paymentMethodIds' => [
                    0 => '69867b98038e4d41bde2382bbb5810fc',
                    1 => '81fcce6eda1e4ee994281cf6c41e1208',
                    2 => '8b9ed316d2da4756ab995bd0fa46ef87',
                    3 => '9c8bb5aa0c974f87b44b4a61a9d61d0a',
                ],
                'productExports' => null,
                'hreflangActive' => false,
                'hreflangDefaultDomainId' => null,
                'hreflangDefaultDomain' => null,
                'analyticsId' => null,
                'analytics' => null,
                'customerGroupsRegistrations' => null,
                'eventActions' => null,
                'boundCustomers' => null,
                'wishlists' => null,
                'landingPages' => null,
                '_uniqueIdentifier' => '08757990bf314633b5d0fa55efc5e63d',
                'versionId' => null,
                'translated' => [
                    'name' => 'Storefront',
                    'customFields' => [
                    ],
                ],
                'createdAt' => '2021-04-12T07:53:19.452+00:00',
                'updatedAt' => null,
                'extensions' => [
                    'foreignKeys' => [
                        'apiAlias' => null,
                        'extensions' => [
                        ],
                    ],
                ],
                'id' => '08757990bf314633b5d0fa55efc5e63d',
                'navigationCategoryVersionId' => '0fa91ce3e96a4bc2be4bd9ce752c3425',
                'footerCategoryVersionId' => null,
                'serviceCategoryVersionId' => null,
            ],
        ];

        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'guest_order.double_opt_in\'', [json_encode($guestOrder)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer.recovery.request\'', [json_encode($customerRecoveryRequest)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order.state.completed\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order.state.in_progress\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer.group.registration.accepted\'', [json_encode($customerGroupRegistration)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_delivery.state.shipped_partially\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer.group.registration.declined\'', [json_encode($customerGroupRegistration)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_delivery.state.returned\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.open\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_confirmation_mail\'', [json_encode($orderConfirmation)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'contact_form\'', [json_encode($contactForm)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.refunded\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.paid_partially\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_delivery.state.shipped\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'newsletterRegister\'', [json_encode($newsletterRegister)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_delivery.state.returned_partially\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'user.recovery.request\'', [json_encode($userRecoveryRequest)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.cancelled\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order.state.cancelled\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_delivery.state.cancelled\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.reminded\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.refunded_partially\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order_transaction.state.paid\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer_register\'', [json_encode($customerRegistration)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'sepa_confirmation\'', [json_encode($orderConfirmation)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'order.state.open\'', [json_encode($orderDeliverState)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer_group_change_accept\'', [json_encode($customerGroupChange)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer_register.double_opt_in\'', [json_encode($customerRegistration)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'customer_group_change_reject\'', [json_encode($customerGroupChange)]);
        $connection->executeStatement('UPDATE `mail_template_type` SET `template_data` = ? WHERE `mail_template_type`.`technical_name` = \'newsletterDoubleOptIn\'', [json_encode($newsletterRegister)]);
    }

    public function updateDestructive(Connection $connection): void
    {
    }
}
