# frozen_string_literal: true

# The Shoes logo/icon bounces on the screen. The logo/icon responds to menu options and if clicked on.
xspeed = 10
yspeed = 6
xdir = 1
ydir = 1

Shoes.app width: 300, height: 300 do
  background lightgray

  a = nil
  button('toggle') { a.toggle }
  button('stop') { a.stop }
  button('start') { a.start }
  button('remove') { a.remove }
  img = image File.join(Shoes::DIR, 'static/shoes-icon.png'),
              click: ->() { alert "You're soooo quick!" }

  x = 150
  y = 150
  size = [128, 128]
  pause = 0

  a = animate 24 do |n|
    unless pause == n
      x += xspeed * xdir
      y += yspeed * ydir

      xdir *= -1 if x > 300 - size[0] || x.negative?
      ydir *= -1 if y > 300 - size[1] || y.negative?

      img.move x.to_i, y.to_i
    end
    pause = n
  end
end
