---
meta:
  title: Accessibility Commitment
  description: Shoelace recognizes the need for all users to have undeterred access to the websites and applications that are created with it.
---

# Accessibility Commitment

Shoelace recognizes the need for all users, regardless of ability and device, to have undeterred access to the websites and applications that are created with it. This is an important goal of the project.

Oftentimes, people will ask “is Shoelace accessible?” I’m reluctant to answer because accessibility isn’t binary — there’s no simple “yes” or “no” response to provide. What seems accessible to a sighted user might be completely inaccessible to a non-sighted user. And even if you optimize for various screen readers, you still have to account for low-level vision, color blindness, hearing impairments, mobility impairments, and more.

Accessibility is something you have to continuously strive for. No individual contributor — or perhaps even an entire team — can claim their software is 100% accessible because of the sheer diversity of abilities, devices, assistive technologies, and individual use cases.

Furthermore, accessibility doesn’t stop at the component level. Using accessible building blocks doesn’t magically make the rest of your webpage or application compliant. There is no library or overlay that will make your software “fully accessible” without putting in the effort. It’s also worth noting that web components are still somewhat bleeding edge, so browsers, assistive devices, and [even specifications](https://wicg.github.io/aom/spec/) are still evolving to help improve accessibility on the web platform.

My commitment to Shoelace users is this: Everything I develop will be built with accessibility in mind. I will test and improve every component to the best of my ability and knowledge. I will work around upstream issues, such as browser bugs and limitations, to the best of my ability and within reason.

I’m fully aware that I may not get it right every time for every user, so I invite the community to participate in this ongoing effort by submitting [issues](https://github.com/shoelace-style/shoelace/issues?q=is%3Aissue+is%3Aopen+label%3Aa11y), [pull requests](https://github.com/shoelace-style/shoelace/pulls?q=is%3Aopen+is%3Apr+label%3Aa11y), and [discussions](https://github.com/shoelace-style/shoelace/discussions). Many accessibility improvements have already been made thanks to contributors submitting code, feedback, and suggestions.

This is the path forward. Together, we will continue to make Shoelace accessible to as many users as possible.

— Cory LaViska<br>
_Creator of Shoelace_
