---
weight: 30
title: Building
---

## Overview

Libcsp is designed to be easy to use and high performance. Thus we should
implement some of its features(e.g. stack size analyzing, the construction of
the process entry etc.) in compile time.

[GCC plugin](https://gcc.gnu.org/wiki/plugins) provides the mechanism to allow
us to manipulate its abstract syntax tree(AST) and intermediate representation(
IR, GIMPLE in gcc). Libcsp uses this ability and provides three parts to help
you build your programs:

- libcsp CLI: `cspcli`
- libcsp plugin: `libcspplugin.so`
- libcsp library: `libcsp.so`

A typical building progress is:

```shell
# Define the working directory.
WORKING_DIR = ./build

# Initialize the environment for the building.
cspcli init --working-dir=$(WORKING_DIR)

# Build your program.c with libcsp plugin.
gcc -o program.o -c program.c -fplugin=libcsp -fplugin-arg-libcsp-working-dir=$(WORKING_DIR)

# Analyze the outputs generated by libcsp plugin in $(WORKING_DIR) and then
# generate the configuration file `config.c`.
cspcli analyze --working-dir=$(WORKING_DIR)

# Patch `config.c` to complete the building.
gcc -o program program.o $(WORKING_DIR)/config.c -lcsp -pthread
```

## Libcsp CLI

Libcsp CLI `cspcli` is mainly used to analyze the outputs of libcsp plugin and
generates the configuration file `config.c`.

```text
Usage:
  cspcli <command> [options]

Commands:
  init:
    Initialize the environment for the building. Libcsp will create the
    working directory if it doesn't exist or otherwise clean the generated
    files left by the previous building.

    Options:
      --working-dir:
        The working directory. Default is /tmp/libcsp.

  analyze:
    Analyze the memory usages of processes and generate the configuration
    file `config.c`. Libcsp plugin will generate the function stack frame
    size to files with extension .sf and the function call graph to files
    with extension .cg. This command will analyze the memory usage of all
    processes according to these files. You can set some configurations
    with the following options:

    Options:
      --working-dir:
        The working directory. Default is `/tmp/libcsp/`.
      --installed-prefix:
        The value of option `--prefix` in `./configure` when you build and
        install libcsp from source. Default is `/usr/local/`.
      --extra-su-file:
        The extra stack usage file. The format of every line in it is `fn
        size`(e.g. `main 64`). It's used first if it's set.
      --default-stack-size:
        The default stack size for an unknown function. Default is 2KB.
      --cpu-cores:
        The number of CPU cores on which libcsp will run. Default is max
        CPU cores.
      --max-threads:
        The max threads libcsp can create. Default is 1024.
      --max-procs-hint:
        The hint of the max processes. Libcsp will initialize related
        resource according to it. Default is 100000.

  clean:
    Clear related generated files in the working directory.

    Options:
      --working-dir:
        The working directory. Default is /tmp/libcsp/.

  version:
    Display the cspcli version.
```

## Libcsp plugin

Libcsp plugin is used to do some compile-time work including:

- Wraps the functions in `csp_async`, `csp_sync`, `csp_timer_at` and `csp_timer_after`,
  and then generates the process entry in pure assembly language.
- Records the stack frame size of every function and save them to the files with
  extension `.sf` .
- Records the call graphs and save them to the files with extension `.cg`.

Libcsp supports following parameters:

- `working-dir`: The working directory. Default is `/tmp/libcsp/`
- `installed-prefix`: The value of option `--prefix` in `./configure` when you
  build and install libcsp from source. Default is `/usr/local/`.

Example:

```shell
gcc -o program.o -c program.c -fplugin=libcsp -fplugin-arg-libcsp-working-dir=./build -fplugin-arg-libcsp-installed-prefix=/usr
```

## Libcsp library

Libcsp library provides the high performance runtime scheduler and related APIs
to make your programs concurrent.

[Go to see](/api) more details about the API.
