import React, { SVGProps } from 'react';

interface MaltProps extends SVGProps<SVGSVGElement> {
  size?: number | string;
}

const Malt: React.FC<MaltProps> = ({ size = '1em', fill, ...props }) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    width={size}
    height={size}
    fill={fill}
    viewBox="0 0 186.795 186.795"
    {...props}
  >
    <path
      d="M159.852 26.953c-14.1-14.1-29.162-4.974-38.588 4.452L32.22 120.452c-9.426 9.425-19.292 23.746-4.452 38.584 14.84 14.843 29.161 4.975 38.585-4.451l89.046-89.045c9.426-9.427 18.552-24.489 4.453-38.587zM74.78 23.306L93.635 42.16l19.192-19.192a69.875 69.875 0 013.957-3.661C114.774 9.167 108.988 0 93.626 0c-15.391 0-21.17 9.203-23.169 19.365 1.437 1.243 2.871 2.489 4.323 3.941zM112.816 163.359l-19.18-19.181-18.845 18.843a81.041 81.041 0 01-4.273 3.969c2.161 10.337 8.277 19.805 23.11 19.805 14.872 0 20.98-9.519 23.127-19.889-1.319-1.135-2.639-2.248-3.939-3.547zM66.783 69.013h-36.35C17.105 69.013 0 73.212 0 93.15c0 14.877 9.522 20.986 19.894 23.132 1.228-1.418 46.889-47.269 46.889-47.269zM167.435 69.981c-1.15 1.338-46.907 47.305-46.907 47.305h35.834c13.329 0 30.433-3.149 30.433-24.136 0-15.389-9.2-21.171-19.36-23.169zM78.693 57.081l6.494-6.494-18.843-18.846c-9.427-9.425-23.746-19.292-38.586-4.452-10.882 10.882-8.465 21.473-2.693 30.071 1.758-.13 53.628-.279 53.628-.279zM108.571 129.218l-6.511 6.511 19.194 19.192c9.426 9.427 24.488 18.551 38.586 4.453 10.52-10.521 8.106-21.571 2.29-30.423-1.872.135-53.559.267-53.559.267z"
      fill={fill}
    />
  </svg>
);

export default React.memo<MaltProps>(Malt);
