<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>

<footer class="relative pt-8 pb-6 bg-stone-50 dark:bg-neutral-800 text-neutral-800 dark:text-stone-50">
  <div class="max-w-screen-xl mx-auto px-4">
    <div class="flex flex-wrap justify-between text-left md:text-left">
      <div class="w-full md:w-6/12 px-4">
        <h4><a class="font-logo select-none text-4xl font-bold -tracking-widest" href="/">CheLaburo</a></h4>
        <h5 class="font-semibold my-2">
          ¡Siempre a la mano!
        </h5>
        <div class="mt-6 lg:mb-0 mb-6 flex gap-2 items-center">
          <a href="/" class="inline-block"><i class="fab fa-youtube"></i></a>
          <a href="/" class="inline-block"><i class="fab fa-instagram"></i></a>
          <a href="/" class="inline-block"><i class="fab fa-linkedin"></i></a>
        </div>
      </div>
      <div class="w-full md:w-6/12 px-4">
        <div class="flex items-top mb-6">
          <div class="w-full md:w-4/12 md:px-4 ml-auto">
            <span class="block text-sm font-semibold mb-4">Compañia</span>
            <ul class="list-unstyled">
              <li>
                <a class="block pb-2 text-sm" href="/nosotros">Sobre nosotros</a>
              </li>
              <li>
                <a class="block pb-2 text-sm" href="/nosotros#proposito">Nuestro propósito</a>
              </li>
            </ul>
          </div>
          <div class="mt-4 md:mt-0 w-full md:w-4/12 md:px-4">
            <span class="block text-sm font-semibold mb-4">Descubrí</span>
            <ul class="list-unstyled">
              <li>
                <a class="block pb-2 text-sm" href="/">Servicios</a>
              </li>
              <li>
                <a class="block pb-2 text-sm" href="/registro_laburante">Brindar servicios</a>
              </li>
              <li>
                <a class="block pb-2 text-sm" href="/ayuda">Ayuda</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
    <hr class="my-6 border-neutral-800 dark:border-stone-50">
    <div class="flex flex-wrap items-center md:justify-between justify-center">
      <div class="w-full md:w-4/12 px-4 mx-auto text-center">
        <p class="text-sm font-semibold py-1">
          Desarrollado por
          <a href="https://github.com/sheidiz/CodingDojo-Project" target="_blank" class="hover:text-orange-800">.out.side .the.box Team</a>.
        </p>
      </div>
    </div>
  </div>
</footer>