![CheLaburo logo](https://i.postimg.cc/y8p3hzYX/chelaburo-icon.png)

## Descripción del Proyecto
Plataforma para la contratación de servicios a domicilio en Buenos Aires, Argentina. Permite a los usuarios publicar y buscar servicios disponibles, conectando a quienes necesitan servicios con proveedores locales.

## Tecnologías Utilizadas
- **Spring Framework:** Para la creación de la aplicación backend.
- **Spring MVC:** Para el manejo de los controladores y la lógica de negocio. 
- **Spring JPA:** Para la gestión de la persistencia de datos.
- **JSP y JSTL:** Para la generación de contenido dinámico en las vistas.
- **CSS y Tailwind:** Para el diseño y la presentación de la interfaz de usuario.
- **Figma:** Para el diseño de la interfaz de usuario y la creación de prototipos, facilitando la colaboración y visualización de los elementos de la UI antes de su implementación.

## Funcionalidades
- **Registro y autenticación de usuarios:** Los usuarios pueden registrarse e iniciar sesión en la plataforma.
- **Publicación de servicios:** Los usuarios pueden publicar servicios que ofrecen.
- **Búsqueda de servicios:** Los clientes pueden buscar y solicitar servicios disponibles en la plataforma.
- **Ofertas de servicios:** Los proveedores pueden ofrecer sus servicios para las solicitudes de los clientes.
- **Sistema de calificaciones:** Los usuarios pueden calificar y dejar comentarios sobre los proveedores después de completar un servicio.

## Instalación
Sigue estos pasos para configurar y ejecutar el proyecto localmente:

1. Clona el repositorio:
```bash
  git clone https://github.com/sheidiz/CodingDojo-Project.git
```
2. Configurar la base de datos:
- Configura la base de datos en el archivo application.properties en el directorio src/main/resources.
- Asegúrate de tener una base de datos MySQL en ejecución y actualiza las credenciales en el archivo de configuración.

3. Construir el proyecto:
```bash
  mvn clean install
```
4. Ejecutar la aplicación:
```bash
  mvn spring-boot:run
```

## Autores
- [Cam Rios](https://www.linkedin.com/in/cam-rios-2077641b5/) (Product Designer/Full Stack Developer)
- [Damián Larrosa](https://www.linkedin.com/in/dami%C3%A1n-ariel-larrosa/) (Product Owner/Full Stack Developer)
- Facundo Alvarez - (Full Stack Developer)
- [Federico Mansilla](https://www.linkedin.com/in/federico-tom%C3%A1s-mansilla-ab59651a5/) (Statistics Researcher/Full Stack Developer)
- [Franco Pachao](https://www.linkedin.com/in/franco-rom%C3%A1n-pachao-3a395b2a5/) - (Full Stack Developer)
- Matias Mamaní - (Full Stack Developer)
- [Sheila Diz](https://www.linkedin.com/in/sheila-diz/) (Project Manager/Full Stack Developer)
