# Shedskin Examples

80 programs that work with Shed Skin 0.9.10

## Example Overview

```
lines  name                 description
(sloccount)

   174 ac_encode            Arithmetic coding compressor
   130 adatron              Adatron SVM with polynomial kernel
   330 amaze                maze generator/solver
    85 ant                  TSP approximation
   121 astar                a-star algorithm                (extmod, GUI)
   404 bh                   barnes-hut force calculation
   243 block                Huffman block compressor
    55 brainfuck            brainfuck interpreter
  3332 c64                  commodore 64 emulator           (extmod, GUI)
   211 chaos                chaosgame-like fractals
   316 chess                chess engine
   282 chull                3D convex hull
    65 circle               circle packing animation        (extmod, GUI)
    51 collatz              collatz record sequences
   101 dijkstra             dijkstra's algorithm
    73 dijkstra2            bidirectional dijkstra search
   666 doom                 WAD rendering engine            (extmod, GUI)
   148 fysphun              physics animation               (extmod, GUI)
    93 genetic              genetic algorithm
   169 genetic2             another genetic algorithm
   481 go                   go player (monte carlo/UCT)
   246 gs                   wolfenstein-like 3d engine      (extmod, GUI)
  1531 hq2x                 pixel art scaling               (linecount misleading, autogenerated code)
   306 kanoodle             Knuth's dancing links
   116 kmeanspp             K-means++ Clustering
    52 life                 conway's game of life
   187 linalg               linear algebra
   254 loop                 Havlak loop recognition algorithm
   191 lz2                  Lempel-Ziv compressor
    26 mandelbrot           mandelbrot fractal
    89 mandelbrot2          interactive mandelbrot fractal  (extmod, GUI)
   191 mao                  raytracer (ao benchmark)
   209 mastermind           mastermind against comp         (extmod)
   118 mastermind2          mastermind strategies
   442 minilight            advanced raytracer
    47 minpng               uncompressed PNG encoder
   957 msp_ss               serial bootstrap loader
   482 mwmatching           maximum weighted matching algorithm
   103 nbody                planet body physics
   125 neural1              back-prop neural network
   100 neural2              back-prop neural network
    79 oliva2               sea shell patterns
    94 othello              othello player
   341 othello2             strong othello player
 22503 othello3             advanced othello move generator (linecount misleading, autogenerated code)
   219 path_tracing         path tracing raytracer
    88 pisang               satisfiability solver
   462 plcfrs               natural language parser
   212 pycsg                constructive solid geometry     (extmod)
  1510 pygasus              NES emulator                    (extmod, GUI)
   275 pygmy                raytracer
   286 pylife               hashlife-based game of life     (extmod, curses)
   943 pylot                raytracer                       (extmod, GUI, multiprocessing)
   179 pystone              standard benchmark
  1194 quameon              quantum monte carlo algorithms
   452 rdb                  iPod shuffle programmer
   283 richards             standard benchmark
    83 rsync                rsync algorithm
   811 rubik                rubik solver
    78 rubik2               thistlethwaite rubik solver
   255 sat                  conflict-driven satisfiability solver
   129 score4               connect four/four-in-a-row
   204 sha                  SHA-1 algorithm
    84 sieve                prime number sieves
    82 sokoban              sokoban solver
    99 solitaire            solitaire encryption algorithm
   196 stereo               stereo computer vision          (extmod, GUI)
   142 sudoku1              sudoku solver
   169 sudoku2              sudoku solver
   158 sudoku3              sudoku solver
    74 sudoku4              norvig's sudoku solver
    73 sudoku5              dancing links sudoku solver
   285 sunfish              chess engine
   117 tictactoe            tictactoe on large boards
   498 timsort              advanced sorting algorithm
   868 tarsalzp             data compression algorithm
   740 tonyjpegdecoder      jpeg decoder
    40 voronoi              textual voronoi
   458 voronoi2             voronoi algoritm
   108 webserver            simple web server
   276 yopyra               raytracer
```

If you know of any other interesting examples, please do suggest them in the shedskin discussion group or post an [issue](https://github.com/shedskin/shedskin/issues/new/choose) in the [Shedskin repo](https://github.com/shedskin/shedskin).


## Building and Running Individual Examples

Each example has its own directory which should contain the python code to be translated as well as related data files. Also a README.md if there are any special notes. In some cases, you may need to make a link to '../testdata'.

## Building all Examples

To build all examples:

```bash
shedskin test
```

To build a single example:

```bash
shedskin test --target <foldername>
```

For example to build the `timsort` example

```bash
shedskin test --target timsort
```



