# **simgen-ssg**

```{toctree}
:maxdepth: 2
:hidden:
:caption: Getting started

installation
overview
```

```{toctree}
:hidden:
:caption: Development

CHANGELOG
CONTRIBUTING
License <https://raw.githubusercontent.com/sharmashobhit/simgen-ssg/main/LICENSE>
GitHub Repository <https://github.com/sharmashobhit/simgen-ssg>
```

## What is simgen-ssg?

`simgen-ssg` is a content recommendation engine tailored specifically for static sites. Built on top of [Qdrant](https://qdrant.tech/) and [fastembed](https://qdrant.github.io/fastembed/), it enables seamless integration of personalized 'you might also like' sections for your blog, FAQs, and various content-driven pages.

## Why simgen-ssg?

- Personalization: Tailor suggestions for a user-centric experience.
- Ease of Integration: Effortlessly implement recommendations into static sites.
- Engagement Boost: Enrich user experiences and increase engagement.

## Who is it for?

- **Bloggers**: Offer personalized 'you might also like' sections for blog posts, keeping readers engaged and on your site longer.
- **Knowledge Base Enhancement**: Implement 'similar articles' suggestions in FAQs or documentation pages, aiding users in finding relevant information quickly.
- **Content Publishing Platforms**: Enhance content discovery by suggesting related articles or posts, keeping users engaged and extending their browsing time.
- **Portfolio Websites**: Showcase similar projects or works to visitors, allowing them to explore related content based on their interests.
- **Educational Websites**: Offer 'you might also like' sections for courses or resources, aiding learners in discovering supplementary material.
- **Community Forums**: Facilitate the discovery of related threads or discussions, encouraging deeper engagement among users.
- **Event or Conference Websites**: Recommend similar events or sessions based on attendee preferences, optimizing their experience and participation.
- **Recipe or Lifestyle Blogs**: Suggest similar recipes or articles catering to specific user tastes or interests.
- **Job Boards**: Offer job recommendations based on user profiles or previous job searches, enhancing user experience and increasing the likelihood of finding suitable positions.
- **Travel Websites**: Recommend similar destinations, accommodations, or activities, making trip planning more personalized and engaging.

# Thanks

- [Qdrant](https://qdrant.tech/) for providing the vector database and the underlying search engine.
- [fastembed](https://qdrant.github.io/fastembed/) for providing the embeddings generation library.
- [fastapi](https://fastapi.tiangolo.com/) for providing the web framework.
- [Simon Willison's blog](https://til.simonwillison.net/llms/openai-embeddings-related-content) for the inspiration behind this project.
