<div>
   <h2>Introduction</h2>
   <code>Hello there. I am Shanmukha Sainath, working as AI Engineer at KLA Corporation. I have done my Bachelors from Department of Electronics and Electrical Communication Engineering department, IIT Kharagpur.</code>
   <h3>Connect with me:</h3>
   <p>
      <a href="https://linktr.ee/shanmukh05" target="blank"><img align="center" src="https://github.com/shanmukh05/Machine-Learning-Roadmap/blob/main/linktree.png" alt="@shanmukh05" width="200"/></a>
   </p>
   <h3>Why I made this?</h3>
   <p>Internet world is huge, so as resources to learn any new things. There are numerous free and paid resources to learn Machine Learning. Having many options in hand confuses and it's difficult to select best one (saying from experience). So, I have collected best resources to get started with Machine Learning and continue career in this field. </p>
   <blockquote>Feedback and suggestions are welcome :)</blockquote>
</div>
<div>
   <h2>Prerequisites</h2>
   <ul>
      <li>Mathematics</li>
      <ul>
         <li>Linear Algebra</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://ocw.mit.edu/courses/mathematics/18-06-linear-algebra-spring-2010/index.htm">18.06 Linear Algebra</a> course by MIT is the best course to learn basics of Linear Algebra</p>
         </details>
         <li>Matrix Algebra</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://www.khanacademy.org/math/algebra-home/alg-matrices">Matrices</a> course by Khan Academy is the best course to learn basics of Matrix Algebra</p>
         </details>
         <li>Probability and Statistics</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://www.khanacademy.org/math/statistics-probability">Statistics and Probability</a> course by Khan Academy is best course available.</p>
         </details>
         <li>Calculus</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://www.khanacademy.org/math/differential-calculus">Differential Calculus</a> is the best course to learn basics of Differential Calculus.</p>
         </details>
      </ul>
      <li>Programming Fundamentals</li>
      <ul>
         <li>Data Structures and Algorithms</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-006-introduction-to-algorithms-fall-2011/">6.006 Intoduction to Algorithms</a> is the course by MIT to learn basics of Data Structures and Algorithms.</p>
         </details>
      </ul>
      <li>Programming Language</li>
      <ul>
         <li>Python</li>
         <details>
            <summary>Details</summary>
            <p></p>
            <p><a href="https://www.w3schools.com/python/">Python tutorial</a> is best place to learn basic syntax of Python.</p>
         </details>
      </ul>
   </ul>
</div>
<div><img src="https://geps.dev/progress/20"></div>
<div>
   <h2>Machine Learning</h2>
   <ul>
      <li>Courses</li>
      <ul>
         <li><a href="https://www.coursera.org/specializations/machine-learning-introduction">Machine Learning Specialization by Andrew Ng (New Course🆕)</a> : Coursera.</li>
         <li><a href="https://www.udemy.com/course/machinelearning/">Machine Learning A-Z</a> : Udemy.</li>
      </ul>
      <li>Books</li>
      <ul>
         <li><a href="http://users.isr.ist.utl.pt/~wurmd/Livros/school/Bishop%20-%20Pattern%20Recognition%20And%20Machine%20Learning%20-%20Springer%20%202006.pdf">Pattern Recognition and Machine Learning</a> by Christopher Bishop</li>
         <li><a href="https://www.statlearning.com/">An Introduction to Statistical Learning</a> by Gareth M. James, Daniela Witten, Trevor Hastie and Robert Tibshirani</li>
         <li><a href="https://www.knowledgeisle.com/wp-content/uploads/2019/12/2-Aur%C3%A9lien-G%C3%A9ron-Hands-On-Machine-Learning-with-Scikit-Learn-Keras-and-Tensorflow_-Concepts-Tools-and-Techniques-to-Build-Intelligent-Systems-O%E2%80%99Reilly-Media-2019.pdf">Hands on Machine Learning with Scikit-Learn and TensorFlow</a> by Aurelien Geron</li>
      </ul>
   </ul>
</div>
<div><img src="https://geps.dev/progress/40"></div>
<div>
   <h2>Deep Learning</h2>
   <ul>
      <li>Courses</li>
      <ul>
         <li><a href="https://www.coursera.org/specializations/deep-learning">Deep Learning Specialization by Andrew Ng</a> : Coursera</li>
         <li><a href="https://atcold.github.io/NYU-DLSP20/">Deep Learning with PyTorch by Yann LeCun</a> : YouTube</li>
         <li><a href="https://course.fast.ai/">Deep Learning with fast.ai by Jeremy Howard</a> : fast.ai</li>
      </ul>
      <li>Books</li>
      <ul>
         <li><a href="https://www.deeplearningbook.org/">Deep Learning</a> by Ian Goodfellow, Yoshua Bengio and Aaron Courville</li>
         <li><a href="https://tanthiamhuat.files.wordpress.com/2018/03/deeplearningwithpython.pdf">Deep Learning with Python</a> by François Chollet</li>
         <li><a href="https://amzn.eu/d/4ybZF9x">Hands on Machine Learning with Scikit-Learn and TensorFlow</a> by Aurelien Geron</li>
         <li><a href="https://d2l.ai/">Dive into Deep Learning</a> by Amazon scientists</li>
      </ul>
   </ul>
</div>
<div><img src="https://geps.dev/progress/60"></div>
<div>
   <h2>Frameworks/Libraries</h2>
   <h3>"No tutorial/course is better than Documentation :)"</h3>
   <p>But I am sharing other resources for some libraries to learn them quickly. Whenever you got stuck at some function or implementation. It is always better to refer <code>documentation</code>/<code>tutorials</code>/<code>code</code> present in official website.</p>
   <ul>
      <details>
         <summary>Working with Arrays</summary>
         <ul>
            <li><a href="https://numpy.org/">NumPy</a></li>
            <details>
               <summary>Details</summary>
               <p>NumPy is a library that enables <code>Numerical Computing</code> in Python. In Machine Learning we always work with arrays. NumPy helps to operate these arrays using large number of functions available.</p>
               <a href="https://www.w3schools.com/python/numpy/numpy_intro.asp">This will help to get used to some frequent operations done with NumPy.</a> 
            </details>
         </ul>
      </details>
      <details>
         <summary>Data Preprocessing</summary>
         <ul>
            <li>Tabular data</li>
            <ul>
               <li><a href="https://pandas.pydata.org/">Pandas</a></li>
               <details>
                  <summary>Details</summary>
                  <p>pandas is a fast, powerful, flexible and easy to use open source data analysis and manipulation tool, built on top of the Python programming language. To know more about usage and advantages of Pandas visit <a href="https://pandas.pydata.org/docs/getting_started/overview.html">Package Overview</a> page</p>
                  <a href="https://www.w3schools.com/python/pandas/default.asp">This will help to get used to some frequent operations done with Pandas.</a> 
               </details>
            </ul>
            <li>Image data</li>
            <ul>
               <li><a href="https://docs.opencv.org/4.x/index.html">OpenCV</a></li>
               <details>
                  <summary>Details</summary>
                  <p>OpenCV-Python is a library of Python bindings designed to solve computer vision problems. OpenCV-Python is a Python wrapper for the original OpenCV C++ implementation.</p>
                  <a href="https://docs.opencv.org/4.x/d6/d00/tutorial_py_root.html"> Refer to official tutorials for more details and implementation.</a> 
               </details>
               <li><a href="https://pillow.readthedocs.io/en/stable/index.html">Pillow</a></li>
               <details>
                  <summary>Details</summary>
                  <p>The <code>Python Imaging Library</code> adds image processing capabilities to Python interpreter. This library provides extensive file format support, an efficient internal representation, and fairly powerful image processing capabilities.</p>
                  <a href="https://pillow.readthedocs.io/en/stable/handbook/tutorial.html"> Refer to official tutorials for more details and implementation.</a> 
               </details>
            </ul>
            <li>Text data</li>
            <ul>
               <li><a href="https://www.nltk.org/">NLTK</a></li>
               <details>
                  <summary>Details</summary>
                  <p>NLTK is a leading platform for building Python programs to work with human language data. It provides over 50 corpora and lexical resources such as WordNet, along with a suite of text processing functions for classification, tokenization, stemming, tagging, parsing, and semantic reasoning, wrappers for industrial-strength NLP libraries</p>
                  <a href="https://www.tutorialspoint.com/natural_language_toolkit/index.htm">This will help to get used to some frequent operations done with NLTK.</a> 
               </details>
               <li><a href="https://spacy.io/">SpaCy</a></li>
               <details>
                  <summary>Details</summary>
                  <p>spaCy is an open-source software library for advanced Natural Language Processing, written in the programming languages Python and Cython.</p>
                  <a href="https://course.spacy.io/en/">This course by spaCy helps to get started with spaCy.</a> 
               </details>
            </ul>
         </ul>
      </details>
      <details>
         <summary>Data Visualization</summary>
         <ul>
            <li><a href="https://matplotlib.org/stable/index.html">Matplotlib</a></li>
            <details>
               <summary>Details</summary>
               <p>Matplotlib is a comprehensive library for creating static, animated, and interactive visualizations in Python.</p>
               <a href="https://matplotlib.org/stable/tutorials/index"> Refer to official tutorials for more details and implementation.</a> 
            </details>
            <li><a href="https://seaborn.pydata.org/">Seaborn</a></li>
            <details>
               <summary>Details</summary>
               <p>Seaborn is a Python data visualization library based on matplotlib. It provides a high-level interface for drawing attractive and informative statistical graphics.</p>
               <a href="https://seaborn.pydata.org/tutorial.html"> Refer to official tutorials for more details and implementation.</a> <a href="https://seaborn.pydata.org/examples/index.html"> Refer to gallery to knoe about various types of plots present in seaborn.</a> 
            </details>
            <li><a href="https://plotly.com/python/">Plotly</a></li>
            <details>
               <summary>Details</summary>
               <p>Plotly's Python graphing library makes interactive, publication-quality graphs. Examples of how to make line plots, scatter plots, area charts, bar charts, error bars, box plots, histograms, heatmaps, subplots, multiple-axes, polar charts, and bubble charts. </p>
            </details>
         </ul>
      </details>
      <details>
         <summary>Machine Learning</summary>
         <ul>
            <li><a href="https://scikit-learn.org/stable/index.html">Scikit-Learn</a></li>
            <details>
               <summary>Details</summary>
               <p>Scikit-learn is a free software machine learning library for the Python programming language. It features various <code>classification</code>, <code>regression</code> and <code>clustering algorithms</code>. It is designed to interoperate with the Python numerical and scientific libraries NumPy and SciPy.</p>
               <a href="https://scikit-learn.org/stable/tutorial/index.html"> Refer to official tutorials for more details and implementation.</a>
               <p> <a href="https://courses.dataschool.io/introduction-to-machine-learning-with-scikit-learn">Intro to ML with Scikit-Learn</a> and <a href="https://courses.dataschool.io/scikit-learn-tips">50 scikit-learn tips</a> are best freely available courses provided by <code>Data School</code> to learn Scikit-Learn</p>
            </details>
         </ul>
      </details>
      <details>
         <summary>Deep Learning</summary>
         <ul>
            <li><a href="https://www.fast.ai/">fast.ai</a></li>
            <details>
               <summary>Details</summary>
               <p>fastai is a deep learning library which provides practitioners with high-level components that can quickly and easily provide state-of-the-art results in standard deep learning domains, and provides researchers with low-level components that can be mixed and matched to build new approaches. Check <a href="https://docs.fast.ai/#About-fastai">About page</a> for more information.</p>
               <a href="https://docs.fast.ai/tutorial.html"> Refer to official tutorials for more details and implementation.</a> 
            </details>
            <li><a href="https://pytorch.org/">PyTorch</a></li>
            <details>
               <summary>Details</summary>
               <p>PyTorch is a Deep Learning framework developed by <code>Meta</code> that enables fast, flexible experimentation and efficient production through a user-friendly front-end, distributed training, and ecosystem of tools and libraries.</p>
               <a href="https://pytorch.org/tutorials/"> Refer to official tutorials for more details and implementation.</a> 
            </details>
            <li><a href="https://www.tensorflow.org/">TensorFlow</a></li>
            <details>
               <summary>Details</summary>
               <p>TensorFlow is a Deep Learning framework developed by <code>Google</code>. It is a free and open-source software library for machine learning and artificial intelligence. It can be used across a range of tasks but has a particular focus on training and inference of deep neural networks. </p>
               <a href="https://www.tensorflow.org/tutorials"> Refer to official tutorials for more details and implementation.</a> 
            </details>
         </ul>
      </details>
   </ul>
</div>
<div><img src="https://geps.dev/progress/80"></div>
<div>
   <h2>What next ?</h2>
   <ul>
      <li>Competitions</li>
      <ul>
         <li><a href="https://www.kaggle.com/">Kaggle</a></li>
         <details>
            <summary>Details</summary>
            <p>Kaggle is biggest data sceince community where one can share their work, particpate in competitions, learn from free courses and lot more.</p>
            <p>To get more out of Kaggle, participate in any competition which is in field of your interest. Competitions are aminly divided into 3 categories <code>Tabular</code>, <code>Computer Vision</code>, <code>NLP</code>. If there are no any active competitions attempt past competitions which interests you. If you got stuck at any point refer publicly avaliable notebooks / post in discussion forum. There are enoromous number of datasets available on Kaggle. You can also download datasets and start your own project</p>
         </details>
         <li><a href="https://mlcontests.com/">ML Contests</a></li>
         <p>This website contains a list of ongoing ML competitions across various platforms</p>
         <li><a href="https://medium.com/analytics-vidhya/top-25-machine-learning-hackathons-its-here-now-for-anyone-to-move-to-data-science-a93deb2a198a">List of ML hackathon platforms</a></li>
         <p>This blog written by Vetrivel PS has list of Data Science competition platforms.</p>
      </ul>
      <li>Research</li>
      <ul>
         <li><a href="https://paperswithcode.com/">Papers with Code</a></li>
         <details>
            <summary>Details</summary>
            <p><code>Papers with Code</code> is a free and open resource with Machine Learning papers, code, datasets, methods and evaluation tables.</p>
            <p>Everything in PwC are divided into categories which makes it easy to get particular paper. Go to the category / field that interests you (<code>Browse State-of-the-Art</code>). Select any paper based on benchmarked dataset / Most implemented / Libraries. You can also find code implementations in various frameworks.</p>
            <p>Read the paper. Implement the algorithm/model with your favourite framework. Train it with dummy data to check. It's best way to get into research.</p>
         </details>
      </ul>
   </ul>
</div>
<div><img src="https://geps.dev/progress/95"></div>
<div>
   <h2>Other Resources</h2>
   <ul>
      <li>YouTube Channels</li>
      <ul>
         <li>
            <p><a href="https://www.youtube.com/@AndrejKarpathy">Andrej Karpathy</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src="https://img.shields.io/badge/NLP-brown">
            <img src = "https://img.shields.io/badge/-PyTorch-red">
         </li>
         <li>
            <p><a href="https://www.youtube.com/user/krishnaik06">KrishNaik</a></p>
            <img src = "https://img.shields.io/badge/-Machine%20Learning%20-brightgreen">
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-Data%20Science-yellowgreen">
            <img src = "https://img.shields.io/badge/-Mathematics-yellow">
            <img src = "https://img.shields.io/badge/-Deployment-orange">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/joshstarmer">StatQuest with Josh Starmer</a></p>
            <img src = "https://img.shields.io/badge/-Machine%20Learning%20-brightgreen">
            <img src = "https://img.shields.io/badge/-Data%20Science-yellowgreen">
            <img src = "https://img.shields.io/badge/-Mathematics-yellow">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/3blue1brown">3Blue1Brown</a></p>
            <img src = "https://img.shields.io/badge/-Mathematics-yellow">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/Deeplearningai">DeepLearningAI</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/lexfridman">Lex Fridman</a></p>
            <img src = "https://img.shields.io/badge/-Podcast-blue">
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/YannicKilcher">Yannic Kilcher</a></p>
            <img src = "https://img.shields.io/badge/-ML%20News-blue">
            <img src = "https://img.shields.io/badge/-Research%20Papers-lightgrey">
         </li>
         <li>
            <p><a href="https://www.youtube.com/channel/UCHB9VepY6kYvZjj0Bgxnpbw">Henry AI Labs</a></p>
            <img src = "https://img.shields.io/badge/-Research%20Papers-lightgrey">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/WhatsAI">What's AI</a></p>
            <img src = "https://img.shields.io/badge/-Research%20Papers-lightgrey">
         </li>
         <li>
            <p><a href="https://www.youtube.com/channel/UCr8O8l5cCX85Oem1d18EezQ">Daniel Bourke</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-ML%20News-blue">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/TensorFlow">TensorFlow</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-TensorFlow-orange">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/deeplizard">deeplizard</a></p>
            <img src = "https://img.shields.io/badge/-Machine%20Learning%20-brightgreen">
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-Deployment-orange">
            <img src = "https://img.shields.io/badge/-TensorFlow-orange">
            <img src = "https://img.shields.io/badge/-PyTorch-red">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/AladdinPersson">Aladdin Persson</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-Research%20Papers-lightgrey">
            <img src = "https://img.shields.io/badge/-PyTorch-red">
            <img src="https://img.shields.io/badge/-%20paper%20implementations-yellow">
         </li>
         <li>
            <p><a href="https://www.youtube.com/c/DigitalSreeni/">Digital Sreeni</a></p>
            <img src = "https://img.shields.io/badge/-Deep%20Learning%20-green">
            <img src = "https://img.shields.io/badge/-TensorFlow-orange">
         </li>
      </ul>
      <li>Blogs</li>
      <ul>
         <li>
            <p><a href="https://theaisummer.com/">AI Summer</a></p>
         </li>
         <li>
            <p><a href="https://distill.pub/">Distil</a></p>
         </li>
         <li>
            <p><a href="https://ai.googleblog.com/">Google AI</a></p>
         </li>
         <li>
            <p><a href="https://ai.facebook.com/blog/">Meta AI</a></p>
         </li>
         <li>
            <p><a href="https://openai.com/blog/">Open AI</a></p>
         </li>
         <li>
            <p><a href="https://aws.amazon.com/blogs/machine-learning/">AWS Machine Learning</a></p>
         </li>
         <li>
            <p><a href="https://blogs.microsoft.com/ai/">Microsoft AI Blog</a></p>
         </li>
         <li>
            <p><a href="https://lilianweng.github.io/">Lil'Log</a></p>
         </li>
         <li>
            <p><a href="https://thehackweekly.com/blog/">Hack Weekly</a></p>
         </li>
         <li>
            <p><a href="https://www.deepwizai.com/">DeepwizAI</a></p>
         </li>
         <li>
            <p><a href="https://aman.ai/">aman.ai</a></p>
         </li>
      </ul>
      <li>Research Papers</li>
      <ul>
         <li>
            <p><a href="https://paperswithcode.com/">Papers with Code</a></p>
         </li>
         <li>
            <p><a href="https://arxiv.org/">arXiv</a></p>
         </li>
         <li>
            <p><a href="http://www.arxiv-sanity.com/">arXiv Sanity</a></p>
         </li>
         <li>
            <p><a href="https://sci-hub.se/">SciHub</a></p>
         </li>
      </ul>
      <li>Datasets</li>
      <ul>
         <li>
            <p><a href="https://www.kaggle.com/datasets">Kaggle</a> </p>
         </li>
         <li>
            <p><a href="https://paperswithcode.com/datasets">Papers with Code</a> </p>
         </li>
         <li>
            <p><a href="https://www.openml.org/search?type=data&sort=runs&status=active">Open ML</a> </p>
         </li>
      </ul>
      <li>University Lectures</li>
      <ul>
         <li>
            <p><a href="http://cs231n.stanford.edu/schedule.html">CS231n</a> : Computer Vision</p>
         </li>
         <li>
            <p><a href="https://web.stanford.edu/class/archive/cs/cs224n/cs224n.1194/">CS224n</a> : Natural Language Processing</p>
         </li>
         <li>
            <p><a href="http://web.stanford.edu/class/cs224w/index.html">CS224W</a> : Machine Learning with Graphs</p>
         </li>
         <li>
            <p><a href="https://rail.eecs.berkeley.edu/deeprlcourse/">CS285</a> : Reinforcement Learning</p>
         </li>
         <li>
            <p><a href="https://github.com/mlabonne/llm-course">llm-course</a> : Compiled Resources to learn about LLMs</p>
         </li>
      </ul>
      <li>NewsLetters</li>
      <ul>
         <li>
            <p><a href="https://read.deeplearning.ai/the-batch/">DeepLearning.AI</a> </p>
         </li>
         <li>
            <p><a href="https://alphasignal.ai/">Alpha Signal: The weekly digest for AI Researchers and Engineers</a> </p>
         </li>
         <li>
            <p><a href="https://paperswithcode.com/newsletter">Papers with Code</a> </p>
         </li>
         <li>
            <p><a href="https://www.louisbouchard.ai/newsletter/">What's AI</a> </p>
         </li>
         <li>
            <p><a href="https://www.linkedin.com/newsletters/top-ml-papers-of-the-week-7020865424875474944/">DAIR.AI's Top ML papers of the week</a></p>
         </li>
         <li>
            <p><a href="https://join.dailydoseofds.com/">Daily Dose of Data Science</a></p>
         </li>
      </ul>
      <li>People/Pages to follow</li>
      <ul>
         <li>LinkedIn</li>
         <li>Twitter</li>
         <li>Medium</li>
      </ul>
      <li>Cloud GPUs</li>
      <ul>
         <li>
            <p><a href="https://cloud-gpus.com/">This site has all list of available Cloud GPUs and their pricing</a> </p>
         </li>
      </ul>
      <li>Join these communities</li>
      <ul>
         <li>
            <p><a href="https://ykilcher.com/discord">Yannic Kilcher</a> (Discord)</p>
         </li>
         <li>
            <p><a href="https://www.linkedin.com/company/cord-ai1/">CORD.ai</a> (Slack)</p>
         </li>
         <li>
            <p><a href="https://discord.gg/dNvTQnER">MLSpace: The Machine Learning Community (Abhishek Thakur)</a> (Discord)</p>
         </li>
      </ul>
   </ul>
   <details>
         <summary>Advanced resources</summary>
         <ul>
            <li>
               <p><a href="https://wandb.ai/site">Weights & Biases</a>: Train and fine-tune models, manage models from experimentation to production</p>
            </li>
            <li>
               <p><a href="https://huggingface.co/">Hugging Face</a>: The platform where the machine learning community collaborates on models, datasets, and applications.</p>
            </li>
            <li>
               <p><a href="https://lightning.ai/docs/pytorch/stable/">PyTorch Lightning</a>: PyTorch Lightning is the deep learning framework for professional AI researchers and machine learning engineers who need maximal flexibility without sacrificing performance at scale.</p>
            </li>
            <li>
               <p>AutoMl Libraries: <a href="https://pycaret.org/">PyCaret</a>, <a href="https://docs.h2o.ai/h2o/latest-stable/h2o-docs/automl.html">H2o AutoML</a>, <a href="https://autokeras.com/">AutoKeras</a>, <a href="https://microsoft.github.io/FLAML/">FLAML</a></p>
            </li>
            <li>
               <p>Deployment [Beginner]: <a href="https://flask.palletsprojects.com/en/3.0.x/">Flask</a>, <a href="https://streamlit.io/">Streamlit</a></p>
            </li>
            <li>
               <p><a href="https://www.langchain.com/">LangChain</a>: LangChain is a framework designed to simplify the creation of applications using large language models.</p>
            </li>
      </ul>
   </details>
</div>

## Star History
[![Star History Chart](https://api.star-history.com/svg?repos=shanmukh05/Machine-Learning-Roadmap&type=Date)](https://star-history.com/#shanmukh05/Machine-Learning-Roadmap&Date)
