<div align="center">
<img src="https://user-images.githubusercontent.com/46846821/89666520-f195cb80-d8f3-11ea-80bb-f9d5137c6c6c.png" alt ="Activity Scheduing">
<h1>Timetable Scheduler</h1>
</div>

## 🎯 Plan of Action

The project deals with specific constraints:

- There should be no more than one class of teachers at the same time.

- There should be only one teacher assigned to each class during a lecture.

- A teacher cannot teach more than one subject to a class.

- Each subject can be assigned to a class at most one time.

- Credit hours cannot exceed contact hours.

- There can be only one lecture of a teacher/ subject in a class per day.

- The lecture arrangement feature is available to let users decide how multiple lectures of a subject can appear in the timetable.

- The user can define maximum lectures per day and the working days per week.

## 🛠 Tools and Technologies

- **Windows OS:** Windows OS is used for the development of this project due to its user-friendly interface.

- **VSCode:** VSCode is used as an editor for this project due to its high compatibility with Javascript & React.

- **React.js:** React library is used to build the frontend of the project due to its high scalability and a large number of tools & Packages to aid in the development.

- **Node:** Node is used as the backend of the project to provide backend-APIs services.

- **Express js:** Express.js, a framework for the node is used to design the APIs for the project.

- **Node Package Manager:** npm is used to handle the dependencies of the project.

- **Firebase Authentication:** Firebase Authentication provides secure, user-friendly & multiple sign-in methods with many essential features including forgetting password & change password.

- **Cloud Firestore Database:** Cloud firestore is used as the database for this project due to its efficient performance and many secure built-in features to accelerate the development and provide a remote database for the deployed application.

- **Material UI:** Material UI is used as the standard for the frontend of the project due to its premium look and simplicity.

## 🚀 Installation Guidelines

### **Prerequisite**

Make sure you have the following tools, installed on your system.

- [git](https://git-scm.com/downloads)
- [Node](https://nodejs.org/en/download/)

**Step 1. Clone the repository:**
Open gitbash in your desired directory and run the following command:

```
git clone https://github.com/seyed-sabbagh/timetable_Uni
```

**Step 2. Open Two Terminals:**

- Set path of the first terminal to the root of the project folder, that would have /CS311S20PID08 at the end of the path. This terminal will operate the **frontend** of the project.

- For the second terminal, set its path to the **backend** folder, located in the root directory, or you can initialize its path from the root directory, which will have the same path as of the first terminal and then you can run the following command to set its path to the backend folder.

```
cd backend
```

**Step 3. Install the required npm Packages/ dependencies:**

To install the dependencies of both frontend and backend, run the following command in both terminals:

```
npm install
```

Make sure you run the above-mentioned command for both terminals without any errors.

**Step 4. Run the project:**

Now assuming that your system has all the dependencies required to run the project, it is now set to run over your system.

Now for the final step, run the following command in both terminals to start the project:

```
npm start
```

The link for the application will appear in the frontend terminal.

For the next time, you have to follow steps 2 & 4 only.

## 📧Contact Us

In case of any query regarding the project installation, feel free to drop a mail at:

- 🧑 [Mohammad Javad Sabbagh](mailto:mohammadjavadsabagh@gmail.com)

