---
head.title: 'Command reference - Docker PHP - Server Side Up'
description: 'Learn about all the commands available within the serversideup/php image to improve your developer experience.'
layout: docs
---

# Command Reference
::lead-p
We included a few commands in the `/usr/local/bin` directory to help you with your development experience. These commands are available in the `serversideup/php` image.
::

::note
Since our images are unprivileged by default, you'll need to switch to the `root` user to run these commands. This is a security feature that ensures that your container is as secure as possible.
::

## Official PHP Docker Commands
Since our images are based off the official PHP Docker images, any commands from the Official PHP Docker images are available in our images. You can find the full list of commands on the [official PHP Docker images documentation](https://hub.docker.com/_/php).

## docker-php-serversideup-dep-install-alpine
This command will detect the operating system and install packages if it is an Alpine based system. This is helpful if you're building multiple operating systems from the same Dockerfile.

::code-panel
---
label: Example - Installing the `git` package on Alpine
---
```bash
# Usage: docker-php-serversideup-dep-install-alpine [alpine-packages]
docker-php-serversideup-dep-install-alpine git
```
::

## docker-php-serversideup-dep-install-debian
This command will detect the operating system and install packages if it is a Debian based system. This is helpful if you're building multiple operating systems from the same Dockerfile.

::code-panel
---
label: Example - Installing the `git` package on Debian
---
```bash
# Usage: docker-php-serversideup-dep-install-debian [debian-packages]
docker-php-serversideup-dep-install-debian git
```
::

## docker-php-serversideup-entrypoint
For our images that **DO NOT use S6 Overlay**, this is our default entrypoint script.

## docker-php-serversideup-install-php-ext-installer
This is an internal helper script to shorten up the syntax for the installation of the PHP extension installer.

::code-panel
---
label: Example - Installing the PHP extension installer
---
```bash
# Usage: docker-php-serversideup-install-php-ext-installer [version]
docker-php-serversideup-install-php-ext-installer 2.2.0
```
::

## docker-php-serversideup-set-file-permissions
This command is used to set the file permissions of a service in the container. This is useful for development environments where you want to match the user and group ID of the host machine.

[Learn more about working with file permissions →](/docs/guide/understanding-file-permissions)

::code-panel
---
label: Example - Setting the file permissions of the NGINX service
---
```bash
# Usage: docker-php-serversideup-set-file-permissions --owner USER:GROUP --service SERVICE
docker-php-serversideup-set-file-permissions --owner 1000:1000 --service nginx
```
::

## docker-php-serversideup-set-id
This command is used to set the user and group ID of the `www-data` user in the container. This is useful for development environments where you want to match the user and group ID of the host machine.

[Learn more about working with file permissions →](/docs/guide/understanding-file-permissions)

::code-panel
---
label: Example - Setting the user and group ID of the `www-data` user
---
```bash
#  docker-php-serversideup-set-id [username] [uid]:[gid]
docker-php-serversideup-set-id www-data 1000:1000
```
::

## docker-php-serversideup-s6-install
This is a command used at build time to install a specific version of S6 Overlay.

## install-php-extensions
This command is a wrapper around the `docker-php-ext-install` command that comes with the official PHP Docker images. This command allows you to install PHP extensions with a single command. 

[Check out the docker-php-extension-installer project on GitHub →](https://github.com/mlocati/docker-php-extension-installer)

Here's an example of how you can use this command:

::code-panel
---
label: Example - Installing the "intl" extension
---
```bash
install-php-extensions intl
```
::