---
head.title: 'Environment Variable Specifications - Docker PHP - Server Side Up'
description: 'View the complete reference for environment variables available in the Docker PHP images.'
layout: docs
---

# Environment Variable Specifications
We like to customize our images on a per app basis using environment variables. Look below to see what variables are available and what their defaults are. You can easily override them in your own docker environments ([see Docker's documentation](https://docs.docker.com/compose/environment-variables/#set-environment-variables-in-containers)).

**Variable Name**|**Description**|**Used in variation**
:-----:|:-----:|:-----:
`APACHE_DOCUMENT_ROOT`<br />*Default: "/var/www/html/public"*|Sets the directory from which Apache will serve files. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/core.html#documentroot">Official docs</a>)|fpm-apache
`APACHE_MAX_CONNECTIONS_PER_CHILD`<br />*Default: "0"*|Sets the limit on the number of connections that an individual child server process will handle.(<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#maxconnectionsperchild">Official docs</a>)|fpm-apache
`APACHE_MAX_REQUEST_WORKERS`<br />*Default: "150"*|Sets the limit on the number of simultaneous requests that will be served. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#maxrequestworkers">Official docs</a>)|fpm-apache
`APACHE_MAX_SPARE_THREADS`<br />*Default: "75"*|Maximum number of idle threads. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#maxsparethreads">Official docs</a>)|fpm-apache
`APACHE_MIN_SPARE_THREADS`<br />*Default: "10"*|Minimum number of idle threads to handle request spikes. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#minsparethreads">Official docs</a>)|fpm-apache
`APACHE_RUN_GROUP`<br />*Default: "www-data"*|Set the username of what Apache should run as.|fpm-apache
`APACHE_RUN_USER`<br />*Default: "www-data"*|Set the username of what Apache should run as.|fpm-apache
`APACHE_START_SERVERS`<br />*Default: "2"*|Sets the number of child server processes created on startup.(<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#startservers">Official docs</a>)|fpm-apache
`APACHE_THREAD_LIMIT`<br />*Default: "64"*|Set the maximum configured value for ThreadsPerChild for the lifetime of the Apache httpd process. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#threadlimit">Official docs</a>)|fpm-apache
`APACHE_THREADS_PER_CHILD`<br />*Default: "25"*|This directive sets the number of threads created by each child process. (<a target="_blank" href="https://httpd.apache.org/docs/2.4/mod/mpm_common.html#threadsperchild">Official docs</a>)|fpm-apache
`APP_BASE_DIR`<br />*Default: "/var/www/html"*|Change this only if you mount your application to a different directory within the container. ℹ️ Be sure to change `NGINX_WEBROOT`, `APACHE_DOCUMENT_ROOT`, `UNIT_WEBROOT`, etc if it applies to your use case as well.|all
`AUTORUN_ENABLED`<br />*Default: "false"*|Enable or disable all automations. It's advised to set this to `false` in certain CI environments (especially during a composer install). If this is set to `false`, all `AUTORUN_*` behaviors will also be disabled.| all
`AUTORUN_LARAVEL_CONFIG_CACHE`<br />*Default: "true"*|Automatically run "php artisan config:cache" on container start. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_EVENT_CACHE`<br />*Default: "true"*|Automatically run "php artisan event:cache" on container start. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_MIGRATION`<br />*Default: "true"*|Automatically run `php artisan migrate --force` on container start.  <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_MIGRATION_ISOLATION`<br />*Default: "false"*|Requires Laravel v9.38.0 or higher and a database that supports table locks. Automatically run `php artisan migrate --force --isolated` on container start. <br /><br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.<br />ℹ️ Does not work with SQLite.| all
`AUTORUN_LARAVEL_MIGRATION_TIMEOUT`<br />*Default: "30"*|The number of seconds to wait for the database to come online before attempting `php artisan migrate`.. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_ROUTE_CACHE`<br />*Default: "true"*|Automatically run "php artisan route:cache" on container start. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_STORAGE_LINK`<br />*Default: "true"*|Automatically run "php artisan storage:link" on container start. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`AUTORUN_LARAVEL_VIEW_CACHE`<br />*Default: "true"*|Automatically run "php artisan view:cache" on container start. <br />ℹ️ Requires `AUTORUN_ENABLED = true` to run.| all
`COMPOSER_ALLOW_SUPERUSER`<br />*Default: "1"*|Disable warning about running as super-user|all
`COMPOSER_HOME`<br />*Default: "/composer"*|The COMPOSER_HOME variable allows you to change the Composer home directory. This is a hidden, global (per-user on the machine) directory that is shared between all projects.|all
`COMPOSER_MAX_PARALLEL_HTTP`<br />*Default: "24"*|Set to an integer to configure how many files can be downloaded in parallel. Composer ships with 12 by default and must be between 1 and 50. If your proxy has issues with concurrency maybe you want to lower this. Increasing it should generally not result in performance gains.|all
`DISABLE_DEFAULT_CONFIG`<br />*Default: "false"*|Get full customization of the image and disable all default configurations and automations.| all
`HEALTHCHECK_PATH`<br />*Default: "/healthcheck"*|Set the path for the health check endpoint. (<a target="_blank" href="https://docs.docker.com/engine/reference/builder/#healthcheck">Official docs</a>)|all (except `cli`)
`LOG_OUTPUT_LEVEL`<br />*Default: "warn"*|Set your container output different verbosity levels: debug, info, off |all
`NGINX_FASTCGI_BUFFERS`<br />*Default: "8 8k"*|Sets the number and size of the buffers used for reading a response from a FastCGI server. (<a target="_blank" href="https://nginx.org/en/docs/http/ngx_http_fastcgi_module.html#fastcgi_buffers">Official Docs</a>)|fpm-nginx
`NGINX_FASTCGI_BUFFER_SIZE`<br />*Default: "8k"*|Sets the size of the buffer used for reading a response from a FastCGI server. (<a target="_blank" href="https://nginx.org/en/docs/http/ngx_http_fastcgi_module.html#fastcgi_buffer_size">Official Docs</a>)|fpm-nginx
`NGINX_SERVER_TOKENS`<br />*Default: "off"*|Display NGINX version in responses. (<a target="_blank" href="https://nginx.org/en/docs/http/ngx_http_core_module.html#server_tokens">Official Docs</a>)|fpm-nginx
`NGINX_WEBROOT`<br />*Default: "`/var/www/html/public"*|Sets the root directory for requests. (<a target="_blank" href="https://nginx.org/en/docs/http/ngx_http_core_module.html#root">Official Docs</a>)|fpm-nginx
`PHP_DATE_TIMEZONE`<br />*Default: "UTC"*|Control your timezone. (<a target="_blank" href="https://www.php.net/manual/en/datetime.configuration.php#ini.date.timezone">Official Docs</a>)|all
`PHP_DISPLAY_ERRORS`<br />*Default: Off*|Show PHP errors on screen. (<a target="_blank" href="https://www.php.net/manual/en/errorfunc.configuration.php#ini.display-errors">Official docs</a>)|all
`PHP_DISPLAY_STARTUP_ERRORS`<br />*Default: Off*|Even when display_errors is on, errors that occur during PHP's startup sequence are not displayed. (<a target="_blank" href="https://www.php.net/manual/en/errorfunc.configuration.php#ini.display-startup-errors">Official docs</a>)| all
`PHP_ERROR_LOG`<br />*Default: "/dev/stderr"*|Name of the file where script errors should be logged. . (<a target="_blank" href="https://www.php.net/manual/en/errorfunc.configuration.php#ini.error-log">Official docs</a>)|all
`PHP_ERROR_REPORTING`<br />*Default: "22527"*|Set PHP error reporting level. Must be a number. <a target="_blank" href="https://maximivanov.github.io/php-error-reporting-calculator/">Use this tool for help.</a> (<a target="_blank" href="https://www.php.net/manual/en/errorfunc.configuration.php#ini.error-reporting">Official docs</a>)|all
`PHP_FPM_PM_CONTROL`<br />*Defaults:<br />fpm: dynamic<br />fpm-apache: ondemand<br />fpm-nginx: ondemand*|Choose how the process manager will control the number of child processes. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_FPM_PM_MAX_CHILDREN`<br />*Default: "20"*|The number of child processes to be created when pm is set to static and the maximum number of child processes to be created when pm is set to dynamic. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_FPM_PM_MAX_SPARE_SERVERS`<br />*Default: "3"*|The desired maximum number of idle server processes. Used only when pm is set to dynamic. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_FPM_PM_MIN_SPARE_SERVERS`<br />*Default: "1"*|The desired minimum number of idle server processes. Used only when pm is set to dynamic. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_FPM_PM_START_SERVERS`<br />*Default: "2"*|The number of child processes created on startup. Used only when pm is set to dynamic. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_FPM_POOL_NAME`<br />*Default: "www"*|Set the name of your PHP-FPM pool (helpful when running multiple sites on a single server).|fpm*
`PHP_FPM_PROCESS_CONTROL_TIMEOUT`<br />*Default: "10s"*|Set the timeout for the process control commands. (<a target="_blank" href="https://www.php.net/manual/en/install.fpm.configuration.php">Official docs</a>)|fpm*
`PHP_MAX_EXECUTION_TIME`<br />*Default: "99"*|Set the maximum time in seconds a script is allowed to run before it is terminated by the parser. (<a target="_blank" href="https://www.php.net/manual/en/info.configuration.php#ini.max-execution-time">Official docs</a>)|all
`PHP_MAX_INPUT_TIME`<br />*Default: "-1"*|This sets the maximum time in seconds a script is allowed to parse input data, like POST and GET. Timing begins at the moment PHP is invoked at the server and ends when execution begins. The default setting is -1, which means that max_execution_time is used instead. Set to 0 to allow unlimited time. This directive is hardcoded to -1 for the CLI SAPI by PHP. (<a target="_blank" href="https://php.net/max-input-time">Official docs</a>)|all
`PHP_MEMORY_LIMIT`<br />*Default: "256M"*|Set the maximum amount of memory in bytes that a script is allowed to allocate. (<a target="_blank" href="https://www.php.net/manual/en/ini.core.php#ini.memory-limit">Official docs</a>)|all
`PHP_OPCACHE_ENABLE`<br />*Default: "0" (to keep developers sane)*|Enable or disable OPcache. ⚠️ This will set **both values** for `opcache.enable` and `opcache.enable_cli`. (<a target="_blank" href="https://www.php.net/manual/en/opcache.configuration.php#ini.opcache.enable">Official docs</a>)|all
`PHP_OPCACHE_INTERNED_STRINGS_BUFFER`<br />*Default: "8"*|The amount of memory used to store interned strings, in megabytes. (<a target="_blank" href="https://www.php.net/manual/en/opcache.configuration.php#ini.opcache.interned-strings-buffer">Official docs</a>)|all
`PHP_OPCACHE_MAX_ACCELERATED_FILES`<br />*Default: "10000"*|The maximum number of keys (scripts) in the OPcache hash table. (<a target="_blank" href="https://www.php.net/manual/en/opcache.configuration.php#ini.opcache.max-accelerated-files">Official docs</a>)|all
`PHP_OPCACHE_MEMORY_CONSUMPTION`<br />*Default: "128"*|The amount of memory used by the OPcache engine, in megabytes. (<a target="_blank" href="https://www.php.net/manual/en/opcache.configuration.php#ini.opcache.memory-consumption">Official docs</a>)|all
`PHP_OPCACHE_REVALIDATE_FREQ`<br />*Default: "2"*|How often the OPcache checks for updates to cached files (in seconds). (<a target="_blank" href="https://www.php.net/manual/en/opcache.configuration.php#ini.opcache.revalidate-freq">Official docs</a>)|all
`PHP_OPEN_BASEDIR`<br />*Default: "None"* |Limit the files that can be accessed by PHP to the specified directory-tree, including the file itself. `open_basedir` is just an extra safety net, that is in no way comprehensive, and can therefore not be relied upon when security is needed. (<a target="_blank" href="https://www.php.net/manual/en/ini.core.php#ini.open-basedir">Official docs</a>)| all
`PHP_POST_MAX_SIZE`<br />*Default: "100M"*|Sets max size of post data allowed. (<a target="_blank" href="https://www.php.net/manual/en/ini.core.php#ini.post-max-size">Official docs</a>)|all
`PHP_SESSION_COOKIE_SECURE`<br />*Default: 1 (true)*|Specifies whether cookies should only be sent over secure connections.  (<a target="_blank" href="https://www.php.net/manual/en/session.configuration.php#ini.session.cookie-secure">Official docs</a>)|all
`PHP_UPLOAD_MAX_FILE_SIZE`<br />*Default: "100M"*|The maximum size of an uploaded file. (<a target="_blank" href="https://www.php.net/manual/en/ini.core.php#ini.upload-max-filesize">Official docs</a>)|all
`S6_BEHAVIOUR_IF_STAGE2_FAILS`<br />*Default: "2" (stop the container)*|Determines what the container should do if one of the service scripts fails (<a target="_blank" href="https://github.com/just-containers/s6-overlay#customizing-s6-overlay-behaviour">Official docs</a>)|fpm-nginx,<br />fpm-apache
`S6_CMD_WAIT_FOR_SERVICES_MAXTIME`<br />*Default: "0"*|The maximum time (in milliseconds) the services could take to bring up before proceeding to CMD executing (<a target="_blank" href="https://github.com/just-containers/s6-overlay#customizing-s6-overlay-behaviour">Official docs</a>)|fpm-nginx,<br />fpm-apache
`S6_VERBOSITY`<br />*Default: "1"*|Set the verbosity of "S6 Overlay" (the init system these images are based on). The default is "1" (print warnings and errors). The scale goes from 1 to 5, but the output will quickly become very noisy. If you're having issues, start here. You can also customize many other variables. (<a target="_blank" href="https://github.com/just-containers/s6-overlay#customizing-s6-behaviour">Official docs</a>)|fpm-nginx,<br />fpm-apache
`SHOW_WELCOME_MESSAGE`<br />*Default: "true"*|Show a helpful welcome message showing container information when the container starts.|all
`SSL_CERTIFICATE_FILE`<br />*Default: "/etc/ssl/private/self-signed-web.crt"*|Path to public certificate file for HTTPS. You must provide this file otherwise a self-signed key pair will be generated for you.|fpm-nginx,<br />fpm-apache
`SSL_MODE`<br />*Default: "off"*|Configure how you would like to handle SSL. This can be "off" (HTTP only), "mixed" (HTTP + HTTPS), or "full" (HTTPS only). If you use HTTP, you may need to also change `PHP_SESSION_COOKIE_SECURE`.|fpm-nginx,<br />fpm-apache,<br />unit
`SSL_PRIVATE_KEY_FILE`<br />*Default: "/etc/ssl/private/self-signed-web.key"*|Path to private key file for HTTPS. You must provide this file otherwise a self-signed key pair will be generated for you.|fpm-nginx,<br />fpm-apache
`UNIT_CERTIFICATE_NAME`<br />*Default: "self-signed-web-bundle"*| Name of your certificate bundle. This is used to configure HTTPS. (<a target="_blank" href="https://unit.nginx.org/configuration/#ssl-tls-configuration">Official Docs</a>)| unit
`UNIT_CONFIG_DIRECTORY`<br />*Default: "/etc/unit/config.d"*|Path to the Unit configuration directory. Any *.json, *.js, and *.pem files will be loaded into Unit on initialization.| unit
`UNIT_CONFIG_FILE`<br />*Default: "/etc/unit/config.d/config.json"*|Path to the Unit configuration file. One will be generated automatically by default. (<a target="_blank" href="https://unit.nginx.org/configuration/#">Official Docs</a>)| unit
`UNIT_PROCESSES_IDLE_TIMEOUT`<br />*Default: "30"*|The maximum time in seconds that an idle process will be kept alive. (<a target="_blank" href="https://unit.nginx.org/configuration/#application-processes">Official Docs</a>)| unit
`UNIT_PROCESSES_MAX`<br />*Default: "20"*|The maximum number of application processes that can be started. (<a target="_blank" href="https://unit.nginx.org/configuration/#application-processes">Official Docs</a>)| unit
`UNIT_PROCESSES_SPARE`<br />*Default: "2"*|Minimum number of idle processes that Unit tries to maintain for an app. (<a target="_blank" href="https://unit.nginx.org/configuration/#application-processes">Official Docs</a>)| unit
`UNIT_WEBROOT`<br />*Default: "/var/www/html/public"*|Base directory of the app’s file structure. All URI paths are relative to it. (<a target="_blank" href="https://unit.nginx.org/configuration/#php">Official Docs</a>)| unit
`UNIT_MAX_BODY_SIZE`<br />*Default: "104857600"* (100MB) | Sets maximum number of bytes in the body of a client’s request. (<a target="_blank" href="https://unit.nginx.org/configuration/#settings:~:text=false%20(disabled).-,max_body_size,-Maximum%20number%20of">Official docs</a>) | unit