---
head.title: 'Configuring SSL - Docker PHP - Server Side Up'
description: 'Learn how to use SSL with the serversideup/php images.'
layout: docs
---

# Configuring SSL
SSL is disabled by default but can be turned on by setting `SSL_MODE`:

- `off` (default): HTTP only.
- `mixed`: HTTP and HTTPS.
- `full`: HTTPS only. HTTP requests will be redirected to HTTPS.

## Self-signed Certificate Example
If you set `SSL_MODE` to `mixed` or `full`, a self-signed certificate will be generated by default.

::code-panel
---
label: Set SSL mode to "mixed" (HTTP + HTTPS)
---
```yaml
services:
  php:
    image: serversideup/php:8.4-fpm-nginx
    ports:
      - 80:8080
      - 443:8443
    environment:
      SSL_MODE: "mixed"
    volumes:
      - .:/var/www/html
```
::

The above will generate a self-signed certificate and configure NGINX to listen on both HTTP (Port 80) and HTTPS (Port 443).

## Providing Your Own Certificate
In order to add your own certificate, you will need to mount the certificate files to the container. The following files are required:

::code-panel
---
label: Providing your own certificate pair
---
```yaml
services:
  php:
    image: serversideup/php:8.4-fpm-nginx
    ports:
      - 80:8080
      - 443:8443
    environment:
      SSL_MODE: "mixed"
      SSL_PRIVATE_KEY_FILE: "/etc/ssl/private/test-key.pem"
      SSL_CERTIFICATE_FILE: "/etc/ssl/private/test.pem"
    volumes:
      - ./app:/var/www/html
      - ./certs/:/etc/ssl/private/
```
::

::note
Ensure your private key file is set to the permissions `600` (read/write for owner only). If you don't set the permissions correctly, you will run into errors with loading an insecure private key file.
::

The above example provides the private and public key pair with `SSL_PRIVATE_KEY_FILE` and `SSL_CERTIFICATE_FILE` environment variables. The files are mounted to the container with the `volumes` directive.

To give you a clearer picture of the project structure, this is what my folder looks like:

::code-panel
---
label: Providing your own certificate pair
---
```text
.
├── app
│   └── public
│       └── index.php
├── certs
│   ├── test-key.pem
│   └── test.pem
└── docker-compose.yml
```
::

You can see the `docker-compose.yml` file is in the parent directory. The `app` directory is dedicated for all application files, where the `certs` directory is dedicated for all SSL certificates.

The separation of these two directories is important. It would not be a good practice to mount your certificate files in the `/var/www/html` directory on a production machine.

::note
For a signed certificate, you must acquire one from a trusted certificate authority (like [ssls.com](https://www.ssls.com/)).
::

### Additional options for NGINX Unit
If you're using NGINX Unit, you also have the option of setting `UNIT_CERTIFICATE_NAME` (default: `self-signed-web-bundle`). This is the name of the certificate bundle that will be used by NGINX Unit. You can read more about this in the [NGINX Unit documentation](https://unit.nginx.org/configuration/#ssl-tls-configuration).

## Using Let's Encrypt
If you'd like to use Let's Encrypt (what we use), it's best to use a reverse proxy like [Traefik](https://traefik.io/traefik/) or [Caddy](https://caddyserver.com/).

Providing examples for those are out of the scope of this project, but we may consider adding examples in other projects in the future.
