---
head.title: 'Changing common PHP settings - Docker PHP - Server Side Up'
description: 'Customizing PHP images is as easy as setting an environment variable. So easy your grandma could do it!'
layout: docs
---

# Changing common PHP settings
::lead-p
Instead of going through the effort of writing custom scripts or mounting files to change PHP settings, have the power to change common settings with the simplicity of an environment variable.
::

## Common Examples
All our environment variables are documented and can be found in our [environment variable specification](/docs/reference/environment-variable-specification) documentation.

Here are a few examples on how you can change common PHP settings. 

::code-panel
---
label: "Docker Compose: Changing allowed upload size"
---
```yaml
version: '3'
services:
  php:
    image: serversideup/php:8.2.12-unit-bookworm
    environment:
      PHP_POST_MAX_SIZE: "500M"
      PHP_UPLOAD_MAX_FILE_SIZE: "500M"
      SSL_MODE: "mixed"
    ports:
      - 80:8080
      - 443:8443
    volumes:
      - .:/var/www/html/
```
::

::code-panel
---
label: "Docker CLI: Setting the PHP timezone to New York"
---
```bash
docker run -d \
  -p 80:8080 \
  -v $(pwd):/var/www/html \
  -e PHP_DATE_TIMEZONE="America/New_York" \
  serversideup/php:8.2.12-fpm-nginx-bookworm
```
::

## Setting your own php.ini
PHP will read the `php.ini` file from the `/usr/local/etc/php/conf.d/` directory in alphabetical order. This means you can create your own `php.ini` file and mount it to the container to override the default settings.

For example, we can create this file in our project directory:
::code-panel
---
label: "zzz-custom-php.ini"
---
```ini
mysqli.max_persistent = 300
opcache.max_file_size = 10M
opcache.log_verbosity_level = 3
```
::

Then in our Dockerfile, we can copy this file to the `/usr/local/etc/php/conf.d/` directory:
::code-panel
---
label: "Dockerfile: Append to our default configuration"
---
```dockerfile
FROM serversideup/php:8.4-fpm-nginx-bookworm

COPY zzz-custom-php.ini /usr/local/etc/php/conf.d/
```
::

If you prefer to remove the default `php.ini` file, you can do so by adding the following line to your Dockerfile:

::code-panel
---
label: "Dockerfile: Remove our default configuration"
---
```dockerfile
FROM serversideup/php:8.4-fpm-nginx-bookworm

RUN rm /usr/local/etc/php/conf.d/serversideup-docker-php.ini
COPY zzz-custom-php.ini /usr/local/etc/php/conf.d/
```
::

## Validating changes
It's always best to validate your changes by running `php -i` via the command line or using [`phpinfo()`](https://www.php.net/manual/en/function.phpinfo.php).