---
head.title: 'Laravel Reverb with Docker - Docker PHP - Server Side Up'
description: 'Learn how to configure Laravel Reverb with Docker.'
layout: docs
---

# Laravel Reverb with Docker
We simply pass the command to the Docker container and Laravel will start the Reverb process.

::code-panel
---
label: Usual Laravel Reverb Command
---
```sh
php artisan reverb:start
```
::

## Important concepts
1. You will need to follow the [Laravel Reverb setup instructions](https://laravel.com/docs/11.x/reverb) to install the Laravel Reverb package into your Laravel application.
1. In most cases, you probably want to run this as a separate container from your web container
1. If you're using `fpm-apache` or `fpm-nginx`, might need to set the stop signal to `SIGTERM` for a graceful shutdown (see this [PR](https://github.com/serversideup/docker-php/pull/437) for more details why)
1. Be sure to set the health check
1. You may need a proxy like Traefik to correctly route traffic to the right container
1. If you need to run Reverb in the same container, you might want to look into [writing your own S6 Overlay script](/docs/guide/using-s6-overlay#customizing-the-initialization-process) to manage and monitor multiple processes in one container.

## Run it with Docker
::note
Notice Laravel Reverb is running on port `8000`, where as Laravel is running on port `8080`. You may need to set additional environment variables and configure a reverse proxy like Traefik to correctly route traffic to the right container.
::
::code-panel
---
label: Example Docker Compose File
---
```yaml
services:
  php:
    image: my/laravel-app
    labels:
      - "traefik.enable=true"
      - "traefik.http.routers.laravel.tls=true"
      - "traefik.http.routers.laravel.entrypoints=websecure"
      - "traefik.http.routers.laravel.rule=Host(`https://app.example.com`)"
      - "traefik.http.services.laravel.loadbalancer.server.port=8080"
      - "traefik.http.services.laravel.loadbalancer.server.scheme=http"

  reverb:
    image: my/laravel-app
    command: ["php", "/var/www/html/artisan", "--port=8000", "reverb:start"]
    stop_signal: SIGTERM # Set this for graceful shutdown if you're using fpm-apache or fpm-nginx
    healthcheck:
      # This is our native healthcheck script for Reverb
      test: ["CMD", "healthcheck-reverb"]
      start_period: 10s
    labels:
      - "traefik.enable=true"
      - "traefik.http.routers.reverb.tls=true"
      - "traefik.http.routers.reverb.entrypoints=websecure"
      - "traefik.http.routers.reverb.rule=Host(`https://reverb.example.com`)"
      - "traefik.http.services.reverb.loadbalancer.server.port=8000"
      - "traefik.http.services.reverb.loadbalancer.server.scheme=http"
```
::

## Laravel ENV updates
Reverb may require a few ENV variables to be set in your Laravel application.
| **Laravel ENV Variable** | **Description** | **Value if matching example above** |
| ------------------------- | --------- | --------- |
| `REVERB_HOST`             | The hostname the **CLIENT** will connect to. | `reverb.example.com` |
| `REVERB_PORT`             | The port the **CLIENT** will connect to. | `443` |
| `REVERB_SCHEME`             | The scheme the **CLIENT** will connect to. | `https` |

Be sure to not get `REVERB_HOST` or `REVERB_PORT` confused with `REVERB_SERVER_HOST` or `REVERB_SERVER_PORT`. The `_SERVER_` variables are for the **SERVER** (the Reverb daemon itself) and the others are for the **CLIENT** (people connecting to your application).

## Get Up and Running The Easy Way
We do all the heavy lifting for you with Spin Pro. It's as easy as selecting it in a menu and we'll configure everything else for you. Learn how easy it is to get up and running with Reverb on Spin Pro.

[Learn more about Laravel Reverb + Spin Pro →](https://getspin.pro/docs/services/laravel-reverb)