---
head.title: 'Laravel Horizon with Docker - Docker PHP - Server Side Up'
description: 'Learn how to configure Laravel Horizon with Docker.'
layout: docs
---

# Laravel Horizon with Docker
We simply pass the command to the Docker container and Laravel will start the Horizon process.

::code-panel
---
label: Usual Laravel Horizon Command
---
```sh
php artisan horizon
```
::

## Important concepts
1. In most cases, you probably want to run this as a separate container from your web container
1. If you're using `fpm-apache` or `fpm-nginx`, might need to set the stop signal to `SIGTERM` for a graceful shutdown (see this [PR](https://github.com/serversideup/docker-php/pull/437) for more details why)
1. Be sure to set the health check
1. Ensure that you have your `.env` configured correctly to authenticate with Redis
1. Ensure Redis is running before you attempt to connect Horizon to Redis
1. If you need to run horizon in the same container, you might want to look into [writing your own S6 Overlay script](/docs/guide/using-s6-overlay#customizing-the-initialization-process) to manage and monitor multiple processes in one container.

## Run it with Docker
::note
Notice we're calling the artisan command explicitly with the full path (`/var/www/html/artisan`). This is because we need to run the command from the context of the container.
::
::code-panel
---
label: Example Docker Compose File
---
```yaml
services:
  php:
    image: my/laravel-app

  redis:
    image: redis:6
    command: "redis-server --appendonly yes --requirepass redispassword"

  horizon:
    image: my/laravel-app
    command: ["php", "/var/www/html/artisan", "horizon"]
    stop_signal: SIGTERM # Set this for graceful shutdown if you're using fpm-apache or fpm-nginx
    healthcheck:
      # This is our native healthcheck script for Horizon
      test: ["CMD", "healthcheck-horizon"]
      start_period: 10s
```
::

## Get Up and Running The Easy Way
We do all the heavy lifting for you with Spin Pro. It's as easy as selecting it in a menu and we'll configure everything else for you. Learn how easy it is to get up and running with Horizon on Spin Pro.

[Learn more about Laravel Horizon + Spin Pro →](https://getspin.pro/docs/services/laravel-horizon)