---
head.title: 'Laravel Queue with Docker - Docker PHP - Server Side Up'
description: 'Learn how to configure a Laravel Queue with Docker.'
layout: docs
---

# Laravel Queue with Docker
All you need to do is pass the Laravel Queue command to the container and Laravel will start the queue worker.


::code-panel
---
label: Usual Laravel Queue Command
---
```sh
php artisan queue:work --tries=3
```
::

## Important concepts
1. It's usually best to run the queue as a separate container (but using the same image)
1. If you're using `fpm-apache` or `fpm-nginx`, might need to set the stop signal to `SIGTERM` for a graceful shutdown (see this [PR](https://github.com/serversideup/docker-php/pull/437) for more details why)
1. Be sure to set the health check
1. Notice we're using the same `my/laravel-app` image for both the PHP and Queue services. This is a common practice to keep the image consistent.
1. If you need to run the queue in the same container, you might want to look into [writing your own S6 Overlay script](/docs/guide/using-s6-overlay#customizing-the-initialization-process) to manage and monitor multiple processes in one container.

## Run it with Docker
::note
Notice we're calling the artisan command explicitly with the full path (`/var/www/html/artisan`). This is because we need to run the command from the context of the container.
::

::code-panel
---
label: Example & Simplified Docker Compose File
---
```yaml
services:
  php:
    image: my/laravel-app

  queue:
    image: my/laravel-app
    command: ["php", "/var/www/html/artisan", "queue:work", "--tries=3"]
    stop_signal: SIGTERM # Set this for graceful shutdown if you're using fpm-apache or fpm-nginx
    healthcheck:
      # This is our native healthcheck script for the queue
      test: ["CMD", "healthcheck-queue"]
      start_period: 10s
```
::

## Get Up and Running The Easy Way
We do all the heavy lifting for you with Spin Pro. It's as easy as selecting it in a menu and we'll configure everything else for you. Learn how easy it is to get up and running with Queues on Spin Pro.

[Learn more about Laravel Queues + Spin Pro →](https://getspin.pro/docs/services/laravel-queues)