---
head.title: 'Laravel Automations Script - Docker PHP - Server Side Up'
description: 'Automate your deployments and minimize your efforts with Laravel.'
layout: docs
---

# Laravel Automations
`serversideup/php` has a "Laravel Automations" script that helps you automate certain steps during your deployments. By default, the script is **DISABLED**. We only recommend enabling this script in production environments.

::note
`AUTORUN_ENABLED` must be set to `true` to enable the script. See our [variable reference document](/docs/reference/environment-variable-specification) for more details.
::

## What the script does
This script executes on container start up and performs the following tasks:

### php artisan migrate
Before running migrations, we ensure the database is online and ready to accept connections. By default, we will wait 30 seconds before timing out.

You can enable the [`--isolated`](https://laravel.com/docs/11.x/migrations#running-migrations) flag by setting `AUTORUN_LARAVEL_MIGRATION_ISOLATION` to `true`, which will ensure no other containers are running a migration. 

**Special Notes for Isolated Migrations:**
- Requires Laravel v9.38.0+
- Your database must support database locks (meaning SQLite is not supported)

### php artisan storage:link
This command creates a symbolic link from `public/storage` to `storage/app/public`.

### php artisan config:cache
This command caches all configuration files into a single file, which can then be quickly loaded by Laravel. Once the configuration is cache, the `.env` file will no longer be loaded.

[Read more about configuration caching →](https://laravel.com/docs/11.x/configuration#configuration-caching)

### php artisan route:cache
This command caches the routes, dramatically decrease the time it takes to register all of your application's routes. After running this command, your cached routes file will be loaded on every request.

[Read more about route caching →](https://laravel.com/docs/11.x/routing#route-caching)

### php artisan view:cache
This command caches all of the views in your application, which can greatly decrease the time it takes to render your views.

[Read more about view caching →](https://laravel.com/docs/11.x/views#optimizing-views)

### php artisan event:cache
This command creates a manifest of all your application's events and listeners, which can greatly speed up the process of registering them with Laravel.

[Read more about event caching →](https://laravel.com/docs/11.x/events#event-discovery-in-production)