---
head.title: 'WordPress Optimizations - Docker PHP - Server Side Up'
description: 'Learn how serversideup/php is optimized for running WordPress in production.'
layout: docs
---

# Using WordPress with Docker
Ready to take the dive and modernize WordPress with Docker?

Long story short, it can be definitely be worth it depending on your use case. From our experience, you can save yourself hours, or really over-engineer and dig yourself a hole.

## WordPress & Security Optimizations
* Hardening of Apache & NGINX included
* Disabling of XML-RPC
* Preventative access to sensitive version control or CI files
* Protection against other common attacks

See our [Apache security.conf](https://github.com/serversideup/docker-php/blob/main/src/variations/fpm-apache/etc/apache2/conf-available/security.conf) for more detail.

## "The WordPress Way"
We're very grateful for WordPress, and it even runs our blog for [Server Side Up](https://serversideup.net/). The only downside with WordPress is it has a lot of history with it. That means the core was written with in a mindset before all of the fancy and flashy methods that we have today.

The most important thing you need to remember is always try to do things _"The WordPress Way"_.

The more you work with it, the less you are fighting the platform.

### What do you mean by "fighting the platform"?
Introducing modern toolsets to WordPress may allow you to get WordPress up and running, but severely limit you to the rest of the community tools.

This could be things like (but not limited to):
* Using NGINX as the web server
* Deploying updates by packaging WordPress into a Docker Image
* Using too new of a PHP version
* Using [Roots Bedrock](https://roots.io/) to modernize your development flow

We've tried all of these above and we learned that most of the plugins that we relied on had issues with this.

## How does Server Side Up run WordPress?
We embrace these principals:
1. Always do things "The WordPress Way"
1. Keep plugin installation to a minimum
1. Always use Apache as the webserver
1. Only commit _your own_ source code (not WordPress core or another plugin)

## The structure
We run WordPress in production on Docker Swarm using:
1. [Traefik](https://traefik.io/traefik/) (handles SSL automatically with Let's Encrypt)
2. [Our PHP-Apache image](https://hub.docker.com/r/serversideup/php/tags?name=fpm-apache&page=1&ordering=-name) (this is optimized for WordPress)
3. [MariaDB](https://hub.docker.com/_/mariadb) (the "non-Oracle" alternative to MySQL)

## Deploying updates
We attempted to deploy WordPress with rolling updates (like we do with Laravel) by packaging WordPress into a Docker image use the [Roots Bedrock](https://roots.io/) framework, but we ran into a ton of issues with community plugins.

Our most stable solution (following "The WordPress Way") is to:
1. Mount `/var/www/html` of the container to the host
2. At the host, run an SSH `git pull` from our CI system

Ugly, but it works 🤷‍♂️

## Example Repository
We included an example repository that makes it easy for you to clone down and get started.

[View the Example WordPress + Docker Repository →](https://github.com/serversideup/docker-wordpress)
